/*
 * Decompiled with CFR 0.152.
 */
package drivers.inimprevidia;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Scanner;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 502;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private String host = null;
    private int unitid = 1;
    private boolean gui = true;
    private boolean startupevent = true;
    private String name = null;
    private int online = -1;
    private int pollingtime = 1000;
    private int loopsnumber = 16;
    private int zonesnumber = 1000;
    private int groupsnumber = 240;
    private int loopErrorCounter = 0;
    private int loopErrorThreshold = 5;
    private int loopErrors = 0;
    private int model = 1;
    private static String FILE1 = "./inimprevidia.ini";

    public boolean init(String name, HashMap<String, String> config) {
        block41: {
            super.init(name);
            this.name = name;
            try {
                this.host = String.valueOf(config.get("host")) + ":" + config.get("port");
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            String s = config.get("unitid");
            if (s != null) {
                try {
                    this.unitid = Integer.parseInt(s);
                }
                catch (NumberFormatException e3) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - unitid ignored");
                }
            }
            if ((s = config.get("gui")) != null) {
                try {
                    this.gui = Boolean.parseBoolean(s);
                }
                catch (Exception e4) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - gui ignored");
                }
            }
            if ((s = config.get("startupevents")) != null) {
                try {
                    this.startupevent = Boolean.parseBoolean(s);
                }
                catch (Exception e5) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - startupevents ignored");
                }
            }
            if ((s = config.get("pollingtime")) != null) {
                try {
                    this.pollingtime = Integer.parseInt(s);
                    if (this.pollingtime < 1000) {
                        this.pollingtime = 1000;
                    } else if (this.pollingtime >= 30000) {
                        this.pollingtime = 30000;
                    }
                }
                catch (Exception e6) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - pollingtime ignored");
                }
            }
            if ((s = config.get("loopsnumber")) != null) {
                try {
                    this.loopsnumber = Integer.parseInt(s);
                    if (this.loopsnumber < 1) {
                        this.loopsnumber = 1;
                    } else if (this.loopsnumber >= 16) {
                        this.loopsnumber = 16;
                    }
                }
                catch (Exception e7) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - loopsnumber ignored");
                }
            }
            if ((s = config.get("zonesnumber")) != null) {
                try {
                    this.zonesnumber = Integer.parseInt(s);
                    if (this.zonesnumber < 1) {
                        this.zonesnumber = 1;
                    } else if (this.zonesnumber > 1000) {
                        this.zonesnumber = 1000;
                    }
                }
                catch (Exception e8) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - zonesnumber ignored");
                }
            }
            if ((s = config.get("groupsnumber")) != null) {
                try {
                    this.groupsnumber = Integer.parseInt(s);
                    if (this.groupsnumber < 1) {
                        this.groupsnumber = 1;
                    } else if (this.groupsnumber >= 240) {
                        this.groupsnumber = 240;
                    }
                }
                catch (Exception e9) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - groupsnumber ignored");
                }
            }
            if ((s = config.get("model")) != null) {
                try {
                    if (s.equalsIgnoreCase("compact")) {
                        this.model = 3;
                    }
                }
                catch (Exception e10) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - groupsnumber ignored");
                }
            }
            try {
                this.loadNames();
            }
            catch (FileNotFoundException e11) {
                if (!this.isVerboseLog()) break block41;
                this.messageLog(String.valueOf(name) + ": cannot load inimprevidia.ini file...");
            }
        }
        this.loopErrors = 0;
        return true;
    }

    public boolean loop() {
        long currentTimestampStart = System.currentTimeMillis();
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ": starting loop with errors: " + this.loopErrorCounter);
        }
        this.readGeneralStatus();
        this.readGeneralLoopStatus();
        this.readZonesStatus();
        this.readGroupsStatus();
        this.readDevicesStatus();
        if (this.model == 1) {
            this.readIFM4IO();
        } else {
            this.readCompactIOStatus();
        }
        if (this.loopErrorCounter == 0) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": end of loop ok ");
            }
            this.loopErrors = 0;
            if (this.online <= 0) {
                this.online = 1;
                this.ioWrite("connection", "online");
                if (this.gui) {
                    this.uiSet("connection", "visible", "false");
                }
                try {
                    this.loadNames();
                }
                catch (FileNotFoundException e2) {
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": cannot load inimprevidia.ini file...");
                    }
                }
            }
        } else {
            ++this.loopErrors;
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": number of loops with error " + this.loopErrors);
            }
            if (this.loopErrors >= this.loopErrorThreshold) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": too many read errors, quit driver");
                }
                this.end();
            }
            this.sleep(20000L);
            return false;
        }
        long looptime = System.currentTimeMillis() - currentTimestampStart;
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ": real polling time in ms: " + looptime + " |  user settings polling time: " + this.pollingtime);
        }
        if (looptime < (long)this.pollingtime) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": waiting for ms: " + ((long)this.pollingtime - looptime));
            }
            this.sleep((long)this.pollingtime - looptime);
        }
        this.loopErrorCounter = 0;
        return true;
    }

    private void readGeneralStatus() {
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 0, 8);
        if (response != null) {
            String responseHex2 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  general panel status read: " + responseHex2 + " | response length: " + response.length);
            }
            if (responseHex2.startsWith("04")) {
                byte myByte = response[2];
                boolean bit0 = (myByte & 1) != 0;
                boolean bit1 = (myByte & 2) != 0;
                boolean bit2 = (myByte & 4) != 0;
                boolean bit3 = (myByte & 8) != 0;
                boolean bit4 = (myByte & 0x10) != 0;
                boolean bit5 = (myByte & 0x20) != 0;
                boolean bit6 = (myByte & 0x40) != 0;
                boolean bit7 = (myByte & 0x80) != 0;
                this.ioWrite("global.night.mode", bit0 ? "1" : "0");
                this.ioWrite("global.silence", bit1 ? "1" : "0");
                this.ioWrite("global.patrol", bit2 ? "1" : "0");
                this.ioWrite("global.buzzer.silence", bit3 ? "1" : "0");
                this.ioWrite("global.access.level", Driver.convertNibbleToDecimal(bit4, bit5, bit6, bit7));
                myByte = response[3];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                this.ioWrite("global.alarm", bit0 ? "1" : "0");
                this.ioWrite("global.prealarm", bit1 ? "1" : "0");
                this.ioWrite("global.notice", bit2 ? "1" : "0");
                this.ioWrite("global.fault", bit3 ? "1" : "0");
                this.ioWrite("global.disabled", bit4 ? "1" : "0");
                myByte = response[4];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                this.ioWrite("global.fault.rs485.1", bit0 ? "1" : "0");
                this.ioWrite("global.fault.rs485.2", bit1 ? "1" : "0");
                myByte = response[5];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                this.ioWrite("global.fault.battery", bit0 ? "1" : "0");
                this.ioWrite("global.low.battery", bit1 ? "1" : "0");
                this.ioWrite("global.fault.net", bit2 ? "1" : "0");
                this.ioWrite("global.rt.net", bit3 ? "1" : "0");
                this.ioWrite("global.fault.ground", bit4 ? "1" : "0");
                if (this.model < 3) {
                    myByte = response[6];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifm16io.1", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifm16io.2", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifm16io.3", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifm16io.4", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifmlan", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.emergency.cpu", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifmnet", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifmdial", bit7 ? "1" : "0");
                    myByte = response[7];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifm2l.1", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifm2l.2", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifm2l.3", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifm2l.4", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifm2l.5", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifm2l.6", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifm2l.7", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifm2l.8", bit7 ? "1" : "0");
                    myByte = response[8];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifmext.9", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.10", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.11", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.12", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.13", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.14", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.15", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.16", bit7 ? "1" : "0");
                    myByte = response[9];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifmext.1", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.2", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.3", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.4", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.5", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.6", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.7", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.8", bit7 ? "1" : "0");
                    myByte = response[11];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifmext.17", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.18", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.19", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.20", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.21", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.22", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.23", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifmext.24", bit7 ? "1" : "0");
                    myByte = response[12];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifm4io.9", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.10", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.11", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.12", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.13", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.14", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.15", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.16", bit7 ? "1" : "0");
                    myByte = response[13];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifm4io.1", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.2", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.3", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.4", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.5", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.6", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.7", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifm4io.8", bit7 ? "1" : "0");
                    myByte = response[14];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.power.supply.1", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.power.supply.2", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.power.supply.3", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.power.supply.4", bit3 ? "1" : "0");
                    myByte = response[15];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.fpmled.1", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.fpmled.2", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.fpmled.3", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.fpmled.4", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.fpmled.5", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.fpmled.6", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.fpmled.7", bit6 ? "1" : "0");
                    myByte = response[16];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifmr4.9", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.10", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.11", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.12", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.13", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.14", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.15", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.16", bit7 ? "1" : "0");
                    myByte = response[17];
                    bit0 = (myByte & 1) != 0;
                    bit1 = (myByte & 2) != 0;
                    bit2 = (myByte & 4) != 0;
                    bit3 = (myByte & 8) != 0;
                    bit4 = (myByte & 0x10) != 0;
                    bit5 = (myByte & 0x20) != 0;
                    bit6 = (myByte & 0x40) != 0;
                    bit7 = (myByte & 0x80) != 0;
                    this.ioWrite("global.fault.ifmr4.1", bit0 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.2", bit1 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.3", bit2 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.4", bit3 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.5", bit4 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.6", bit5 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.7", bit6 ? "1" : "0");
                    this.ioWrite("global.fault.ifmr4.8", bit7 ? "1" : "0");
                }
            } else if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
    }

    private void readGeneralLoopStatus() {
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 12, 2);
        if (response != null) {
            String responseHex2 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  general loop status read: " + responseHex2);
            }
            if (responseHex2.startsWith("04")) {
                byte myByte = response[2];
                boolean bit0 = (myByte & 1) != 0;
                boolean bit1 = (myByte & 2) != 0;
                boolean bit2 = (myByte & 4) != 0;
                boolean bit3 = (myByte & 8) != 0;
                boolean bit4 = (myByte & 0x10) != 0;
                boolean bit5 = (myByte & 0x20) != 0;
                boolean bit6 = (myByte & 0x40) != 0;
                boolean bit7 = (myByte & 0x80) != 0;
                this.ioWrite("global.loop.fault.9", bit0 ? "1" : "0");
                this.ioWrite("global.loop.fault.10", bit1 ? "1" : "0");
                this.ioWrite("global.loop.fault.11", bit2 ? "1" : "0");
                this.ioWrite("global.loop.fault.12", bit3 ? "1" : "0");
                this.ioWrite("global.loop.fault.13", bit4 ? "1" : "0");
                this.ioWrite("global.loop.fault.14", bit5 ? "1" : "0");
                this.ioWrite("global.loop.fault.15", bit6 ? "1" : "0");
                this.ioWrite("global.loop.fault.16", bit7 ? "1" : "0");
                myByte = response[3];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                bit6 = (myByte & 0x40) != 0;
                bit7 = (myByte & 0x80) != 0;
                this.ioWrite("global.loop.fault.1", bit0 ? "1" : "0");
                this.ioWrite("global.loop.fault.2", bit1 ? "1" : "0");
                this.ioWrite("global.loop.fault.3", bit2 ? "1" : "0");
                this.ioWrite("global.loop.fault.4", bit3 ? "1" : "0");
                this.ioWrite("global.loop.fault.5", bit4 ? "1" : "0");
                this.ioWrite("global.loop.fault.6", bit5 ? "1" : "0");
                this.ioWrite("global.loop.fault.7", bit6 ? "1" : "0");
                this.ioWrite("global.loop.fault.8", bit7 ? "1" : "0");
                myByte = response[4];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                bit6 = (myByte & 0x40) != 0;
                bit7 = (myByte & 0x80) != 0;
                this.ioWrite("global.loop.disabled.9", bit0 ? "1" : "0");
                this.ioWrite("global.loop.disabled.10", bit1 ? "1" : "0");
                this.ioWrite("global.loop.disabled.11", bit2 ? "1" : "0");
                this.ioWrite("global.loop.disabled.12", bit3 ? "1" : "0");
                this.ioWrite("global.loop.disabled.13", bit4 ? "1" : "0");
                this.ioWrite("global.loop.disabled.14", bit5 ? "1" : "0");
                this.ioWrite("global.loop.disabled.15", bit6 ? "1" : "0");
                this.ioWrite("global.loop.disabled.16", bit7 ? "1" : "0");
                myByte = response[5];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                bit6 = (myByte & 0x40) != 0;
                bit7 = (myByte & 0x80) != 0;
                this.ioWrite("global.loop.disabled.1", bit0 ? "1" : "0");
                this.ioWrite("global.loop.disabled.2", bit1 ? "1" : "0");
                this.ioWrite("global.loop.disabled.3", bit2 ? "1" : "0");
                this.ioWrite("global.loop.disabled.4", bit3 ? "1" : "0");
                this.ioWrite("global.loop.disabled.5", bit4 ? "1" : "0");
                this.ioWrite("global.loop.disabled.6", bit5 ? "1" : "0");
                this.ioWrite("global.loop.disabled.7", bit6 ? "1" : "0");
                this.ioWrite("global.loop.disabled.8", bit7 ? "1" : "0");
            } else if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
    }

    private void readZonesStatus() {
        int totalzonesloops = Driver.divideAndRoundUp(this.zonesnumber);
        int totalzonesblocks = totalzonesloops / 2 + 1;
        if (totalzonesblocks >= 5) {
            totalzonesblocks = 5;
        }
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ":  number of zones: " + this.zonesnumber + " | reading: " + totalzonesblocks + " blocks of 100 registers");
        }
        int currentregister = 100;
        int currentzone = 1;
        int i2 = 1;
        while (i2 <= totalzonesblocks) {
            int currentindex = 1;
            byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, currentregister, 100);
            if (response != null) {
                String responseHex2 = Driver.bytesToHex(response);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ":  zones status read from register " + currentregister + ": " + responseHex2 + " | response length: " + response.length);
                }
                if (responseHex2.startsWith("04")) {
                    int j2 = 2;
                    while (j2 < response.length) {
                        byte myByte = response[currentindex + 2];
                        boolean bit0 = (myByte & 1) != 0;
                        boolean bit1 = (myByte & 2) != 0;
                        boolean bit2 = (myByte & 4) != 0;
                        boolean bit3 = (myByte & 8) != 0;
                        boolean bit4 = (myByte & 0x10) != 0;
                        boolean bit6 = (myByte & 0x40) != 0;
                        boolean bit7 = (myByte & 0x80) != 0;
                        this.ioWrite("z" + currentzone + ".alarm", bit0 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".prealarm", bit1 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".notice", bit2 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".fault", bit3 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".disabled", bit4 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".test", bit6 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".smoke.disabled", bit7 ? "1" : "0");
                        if (++currentzone > this.zonesnumber) break;
                        myByte = response[currentindex + 1];
                        bit0 = (myByte & 1) != 0;
                        bit1 = (myByte & 2) != 0;
                        bit2 = (myByte & 4) != 0;
                        bit3 = (myByte & 8) != 0;
                        bit4 = (myByte & 0x10) != 0;
                        bit6 = (myByte & 0x40) != 0;
                        bit7 = (myByte & 0x80) != 0;
                        this.ioWrite("z" + currentzone + ".alarm", bit0 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".prealarm", bit1 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".notice", bit2 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".fault", bit3 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".disabled", bit4 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".test", bit6 ? "1" : "0");
                        this.ioWrite("z" + currentzone + ".smoke.disabled", bit7 ? "1" : "0");
                        if (++currentzone <= this.zonesnumber) {
                            currentindex += 2;
                            ++j2;
                            ++j2;
                            continue;
                        }
                        break;
                    }
                } else if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                    ++this.loopErrorCounter;
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
                }
                ++this.loopErrorCounter;
            }
            currentregister += 100;
            ++i2;
        }
    }

    private void readGroupsStatus() {
        int totalgroupsloops = Driver.divideAndRoundUp(this.groupsnumber);
        int totalgroupsblocks = totalgroupsloops / 2 + 1;
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ":  number of groups: " + this.groupsnumber + " | reading: " + totalgroupsblocks + " blocks of 100 registers");
        }
        int currentregister = 600;
        int currentgroup = 1;
        if (totalgroupsblocks >= 2) {
            totalgroupsblocks = 2;
        }
        int i2 = 1;
        while (i2 <= totalgroupsblocks) {
            int currentindex = 1;
            byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, currentregister, 100);
            if (response != null) {
                String responseHex2 = Driver.bytesToHex(response);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ":  groups status read from register " + currentregister + ": " + responseHex2 + " | response length: " + response.length);
                }
                if (responseHex2.startsWith("04")) {
                    int j2 = 2;
                    while (j2 < response.length) {
                        byte myByte = response[currentindex + 2];
                        boolean bit0 = (myByte & 1) != 0;
                        boolean bit1 = (myByte & 2) != 0;
                        boolean bit2 = (myByte & 4) != 0;
                        boolean bit4 = (myByte & 0x10) != 0;
                        this.ioWrite("g" + currentgroup + ".alarm", bit0 ? "1" : "0");
                        this.ioWrite("g" + currentgroup + ".prealarm", bit1 ? "1" : "0");
                        this.ioWrite("g" + currentgroup + ".notice", bit2 ? "1" : "0");
                        this.ioWrite("g" + currentgroup + ".disabled", bit4 ? "1" : "0");
                        if (++currentgroup > this.groupsnumber) break;
                        myByte = response[currentindex + 1];
                        bit0 = (myByte & 1) != 0;
                        bit1 = (myByte & 2) != 0;
                        bit2 = (myByte & 4) != 0;
                        bit4 = (myByte & 0x10) != 0;
                        this.ioWrite("g" + currentgroup + ".alarm", bit0 ? "1" : "0");
                        this.ioWrite("g" + currentgroup + ".prealarm", bit1 ? "1" : "0");
                        this.ioWrite("g" + currentgroup + ".notice", bit2 ? "1" : "0");
                        this.ioWrite("g" + currentgroup + ".disabled", bit4 ? "1" : "0");
                        if (++currentgroup <= this.groupsnumber) {
                            currentindex += 2;
                            ++j2;
                            ++j2;
                            continue;
                        }
                        break;
                    }
                } else if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                    ++this.loopErrorCounter;
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
                }
                ++this.loopErrorCounter;
            }
            currentregister += 100;
            ++i2;
        }
    }

    private void readDevicesStatus() {
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ":  number of loops: " + this.loopsnumber);
        }
        int currentregister = 1001;
        int currentloop = 1;
        while (currentloop <= this.loopsnumber) {
            int currentdevice = 1;
            int registerblock = 100;
            boolean loopinalarm = false;
            boolean loopinprealarm = false;
            int k2 = 0;
            while (k2 <= 1) {
                byte[] response;
                int currentindex = 1;
                if (k2 == 1) {
                    registerblock = 20;
                }
                if ((response = userBase.modbusReadInputRegisters(this.host, this.unitid, currentregister, registerblock)) != null) {
                    String responseHex2 = Driver.bytesToHex(response);
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ":  device status read from register " + currentregister + ": " + responseHex2);
                    }
                    if (responseHex2.startsWith("04")) {
                        int j2 = 2;
                        while (j2 < response.length) {
                            byte myByte = response[currentindex + 2];
                            boolean bit0 = (myByte & 1) != 0;
                            boolean bit1 = (myByte & 2) != 0;
                            boolean bit2 = (myByte & 4) != 0;
                            boolean bit3 = (myByte & 8) != 0;
                            boolean bit4 = (myByte & 0x10) != 0;
                            boolean bit5 = (myByte & 0x20) != 0;
                            boolean bit6 = (myByte & 0x40) != 0;
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".alarm", bit0 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".prealarm", bit1 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".notice", bit2 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".fault", bit3 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".disabled", bit4 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".out", bit5 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".test", bit6 ? "1" : "0");
                            if (bit0) {
                                loopinalarm = true;
                            }
                            if (bit1) {
                                loopinprealarm = true;
                            }
                            ++currentdevice;
                            myByte = response[currentindex + 1];
                            bit0 = (myByte & 1) != 0;
                            bit1 = (myByte & 2) != 0;
                            bit2 = (myByte & 4) != 0;
                            bit3 = (myByte & 8) != 0;
                            bit4 = (myByte & 0x10) != 0;
                            bit5 = (myByte & 0x20) != 0;
                            bit6 = (myByte & 0x40) != 0;
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".alarm", bit0 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".prealarm", bit1 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".notice", bit2 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".fault", bit3 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".disabled", bit4 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".out", bit5 ? "1" : "0");
                            this.ioWrite("l" + currentloop + ".d" + currentdevice + ".test", bit6 ? "1" : "0");
                            if (bit0) {
                                loopinalarm = true;
                            }
                            if (bit1) {
                                loopinprealarm = true;
                            }
                            if (j2 == response.length - 2) {
                                if (loopinalarm) {
                                    this.ioWrite("global.loop.alarm." + currentloop, "1");
                                } else {
                                    this.ioWrite("global.loop.alarm." + currentloop, "0");
                                }
                                if (loopinprealarm) {
                                    this.ioWrite("global.loop.prealarm." + currentloop, "1");
                                } else {
                                    this.ioWrite("global.loop.prealarm." + currentloop, "0");
                                }
                            }
                            ++currentdevice;
                            currentindex += 2;
                            ++j2;
                            ++j2;
                        }
                    } else if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                        ++this.loopErrorCounter;
                    }
                } else {
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
                    }
                    ++this.loopErrorCounter;
                }
                currentregister += registerblock;
                ++k2;
            }
            ++currentloop;
        }
    }

    private void readIFM4IO() {
        int currenmodule = 1;
        int currenchannel = 1;
        int currentindex = 1;
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 900, 32);
        String responseHex2 = Driver.bytesToHex(response);
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ":  ifm4io status read: " + responseHex2);
        }
        if (response != null) {
            int j2 = 2;
            while (j2 < response.length) {
                byte myByte = response[currentindex + 2];
                boolean bit0 = (myByte & 1) != 0;
                boolean bit1 = (myByte & 2) != 0;
                boolean bit2 = (myByte & 4) != 0;
                boolean bit3 = (myByte & 8) != 0;
                boolean bit4 = (myByte & 0x10) != 0;
                boolean bit6 = (myByte & 0x40) != 0;
                boolean bit7 = (myByte & 0x80) != 0;
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".alarm", bit0 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".prealarm", bit1 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".notice", bit2 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".fault", bit3 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".disabled", bit4 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".out", bit6 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".test", bit7 ? "1" : "0");
                ++currenchannel;
                myByte = response[currentindex + 1];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit6 = (myByte & 0x40) != 0;
                bit7 = (myByte & 0x80) != 0;
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".alarm", bit0 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".prealarm", bit1 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".notice", bit2 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".fault", bit3 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".disabled", bit4 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".out", bit6 ? "1" : "0");
                this.ioWrite("ifm4io." + currenmodule + ".c" + currenchannel + ".test", bit7 ? "1" : "0");
                if (++currenchannel >= 4) {
                    currenchannel = 1;
                    ++currenmodule;
                }
                currentindex += 2;
                ++j2;
                ++j2;
            }
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  general loop status read: " + responseHex2);
            }
            if (!responseHex2.startsWith("04") && this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
    }

    private void readCompactIOStatus() {
        byte[] response = userBase.modbusReadInputRegisters(this.host, this.unitid, 900, 2);
        if (response != null) {
            String responseHex2 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  compact io status read: " + responseHex2);
            }
            if (responseHex2.startsWith("04")) {
                byte myByte = response[2];
                boolean bit0 = (myByte & 1) != 0;
                boolean bit1 = (myByte & 2) != 0;
                boolean bit2 = (myByte & 4) != 0;
                boolean bit3 = (myByte & 8) != 0;
                boolean bit4 = (myByte & 0x10) != 0;
                boolean bit5 = (myByte & 0x20) != 0;
                boolean bit6 = (myByte & 0x40) != 0;
                this.ioWrite("io.2.alarm", bit0 ? "1" : "0");
                this.ioWrite("io.2.prealarm", bit1 ? "1" : "0");
                this.ioWrite("io.2.notice", bit2 ? "1" : "0");
                this.ioWrite("io.2.fault", bit3 ? "1" : "0");
                this.ioWrite("io.2.disabled", bit4 ? "1" : "0");
                this.ioWrite("io.2.out", bit5 ? "1" : "0");
                this.ioWrite("io.2.test", bit6 ? "1" : "0");
                myByte = response[3];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                bit6 = (myByte & 0x40) != 0;
                this.ioWrite("io.1.alarm", bit0 ? "1" : "0");
                this.ioWrite("io.1.prealarm", bit1 ? "1" : "0");
                this.ioWrite("io.1.notice", bit2 ? "1" : "0");
                this.ioWrite("io.1.fault", bit3 ? "1" : "0");
                this.ioWrite("io.1.disabled", bit4 ? "1" : "0");
                this.ioWrite("io.1.out", bit5 ? "1" : "0");
                this.ioWrite("io.1.test", bit6 ? "1" : "0");
                myByte = response[4];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                bit6 = (myByte & 0x40) != 0;
                this.ioWrite("io.4.alarm", bit0 ? "1" : "0");
                this.ioWrite("io.4.prealarm", bit1 ? "1" : "0");
                this.ioWrite("io.4.notice", bit2 ? "1" : "0");
                this.ioWrite("io.4.fault", bit3 ? "1" : "0");
                this.ioWrite("io.4.disabled", bit4 ? "1" : "0");
                this.ioWrite("io.4.out", bit5 ? "1" : "0");
                this.ioWrite("io.4.test", bit6 ? "1" : "0");
                myByte = response[5];
                bit0 = (myByte & 1) != 0;
                bit1 = (myByte & 2) != 0;
                bit2 = (myByte & 4) != 0;
                bit3 = (myByte & 8) != 0;
                bit4 = (myByte & 0x10) != 0;
                bit5 = (myByte & 0x20) != 0;
                bit6 = (myByte & 0x40) != 0;
                this.ioWrite("io.3.alarm", bit0 ? "1" : "0");
                this.ioWrite("io.3.prealarm", bit1 ? "1" : "0");
                this.ioWrite("io.3.notice", bit2 ? "1" : "0");
                this.ioWrite("io.3.fault", bit3 ? "1" : "0");
                this.ioWrite("io.3.disabled", bit4 ? "1" : "0");
                this.ioWrite("io.3.out", bit5 ? "1" : "0");
                this.ioWrite("io.3.test", bit6 ? "1" : "0");
            } else if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": response error code: " + responseHex2);
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
    }

    public boolean end() {
        if (this.online != 0) {
            this.online = 0;
            this.ioWrite("connection", "offline");
            if (this.gui) {
                this.uiSet("connection", "visible", "true");
            }
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String cname, String value) {
        if (cname.contains(".d") && value.equalsIgnoreCase("enable")) {
            String loopIndex = cname.split("\\.")[0];
            loopIndex = loopIndex.replace("l", "");
            String deviceIndex = cname.split("\\.")[1];
            deviceIndex = deviceIndex.replace("d", "");
            int loopIndexInt = Integer.valueOf(loopIndex);
            int deviceIndexInt = Integer.valueOf(deviceIndex);
            int register = 5700 + 240 * (loopIndexInt - 1) + (deviceIndexInt - 1);
            userBase.modbusWriteSingleCoil(this.host, this.unitid, register, false);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": single device enable command, loop: " + loopIndex + " | device: " + deviceIndex + " | register: " + register);
            }
        } else if (cname.contains(".d") && value.equalsIgnoreCase("disable")) {
            String loopIndex = cname.split("\\.")[0];
            loopIndex = loopIndex.replace("l", "");
            String deviceIndex = cname.split("\\.")[1];
            deviceIndex = deviceIndex.replace("d", "");
            int loopIndexInt = Integer.valueOf(loopIndex);
            int deviceIndexInt = Integer.valueOf(deviceIndex);
            int register = 5700 + 240 * (loopIndexInt - 1) + (deviceIndexInt - 1);
            userBase.modbusWriteSingleCoil(this.host, this.unitid, register, true);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": single device disable command, loop: " + loopIndex + " | device: " + deviceIndex + " | register: " + register);
            }
        } else if (cname.contains("z") && value.equalsIgnoreCase("enable")) {
            String zoneIndex = cname.replace("z", "");
            int zoneIndexInt = Integer.valueOf(zoneIndex);
            int register = 100 + (zoneIndexInt - 1);
            userBase.modbusWriteSingleCoil(this.host, this.unitid, register, false);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": single zone enable command, zone: " + zoneIndexInt + " | register: " + register);
            }
        } else if (cname.contains("z") && value.equalsIgnoreCase("disable")) {
            String zoneIndex = cname.replace("z", "");
            int zoneIndexInt = Integer.valueOf(zoneIndex);
            int register = 100 + (zoneIndexInt - 1);
            userBase.modbusWriteSingleCoil(this.host, this.unitid, register, true);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": single zone disable command, zone: " + zoneIndexInt + " | register: " + register);
            }
        } else if (cname.contains("ifm4io.") && value.equalsIgnoreCase("1")) {
            if (this.model < 3) {
                String moduleIndex = cname.split("\\.")[1];
                String channelIndex = cname.split("\\.")[2];
                channelIndex = channelIndex.replace("c", "");
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int channelIndexInt = Integer.valueOf(channelIndex);
                int register = 1100 + (moduleIndexInt * 4 - 4) + (channelIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, true);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": ifm4io out on command, module: " + moduleIndex + " | channel: " + channelIndex + " | register: " + register);
                }
            }
        } else if (cname.contains("ifm4io.") && value.equalsIgnoreCase("0")) {
            if (this.model < 3) {
                String moduleIndex = cname.split("\\.")[1];
                String channelIndex = cname.split("\\.")[2];
                channelIndex = channelIndex.replace("c", "");
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int channelIndexInt = Integer.valueOf(channelIndex);
                int register = 1100 + (moduleIndexInt * 4 - 4) + (channelIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, false);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": ifm4io out off command, module: " + moduleIndex + " | channel: " + channelIndex + " | register: " + register);
                }
            }
        } else if (cname.contains("ifm4io.") && value.equalsIgnoreCase("disable")) {
            if (this.model < 3) {
                String moduleIndex = cname.split("\\.")[1];
                String channelIndex = cname.split("\\.")[2];
                channelIndex = channelIndex.replace("c", "");
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int channelIndexInt = Integer.valueOf(channelIndex);
                int register = 5400 + (moduleIndexInt * 4 - 4) + (channelIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, true);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": ifm4io disable command, module: " + moduleIndex + " | channel: " + channelIndex + " | register: " + register);
                }
            }
        } else if (cname.contains("ifm4io.") && value.equalsIgnoreCase("enable")) {
            if (this.model < 3) {
                String moduleIndex = cname.split("\\.")[1];
                String channelIndex = cname.split("\\.")[2];
                channelIndex = channelIndex.replace("c", "");
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int channelIndexInt = Integer.valueOf(channelIndex);
                int register = 5400 + (moduleIndexInt * 4 - 4) + (channelIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, false);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": ifm4io enable command, module: " + moduleIndex + " | channel: " + channelIndex + " | register: " + register);
                }
            }
        } else if (cname.contains("io.") && value.equalsIgnoreCase("1") && cname.endsWith("out")) {
            if (this.model == 3) {
                String moduleIndex = cname.split("\\.")[1];
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int register = 1100 + (moduleIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, true);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": compact io out on command, module: " + moduleIndex + " | register: " + register);
                }
            }
        } else if (cname.contains("io.") && value.equalsIgnoreCase("0") && cname.endsWith("out")) {
            if (this.model == 3) {
                String moduleIndex = cname.split("\\.")[1];
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int register = 1100 + (moduleIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, false);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": compact io out off command, module: " + moduleIndex + " | register: " + register);
                }
            }
        } else if (cname.contains("io.") && value.equalsIgnoreCase("disable")) {
            if (this.model == 3) {
                String moduleIndex = cname.split("\\.")[1];
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int register = 5400 + (moduleIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, true);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": compact io disable command, module: " + moduleIndex + " | register: " + register);
                }
            }
        } else if (cname.contains("io.") && value.equalsIgnoreCase("enable")) {
            if (this.model == 3) {
                String moduleIndex = cname.split("\\.")[1];
                int moduleIndexInt = Integer.valueOf(moduleIndex);
                int register = 5400 + (moduleIndexInt - 1);
                userBase.modbusWriteSingleCoil(this.host, this.unitid, register, false);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": compact io enable command, module: " + moduleIndex + " | register: " + register);
                }
            }
        } else if (cname.equalsIgnoreCase("reset")) {
            userBase.modbusWriteSingleCoil(this.host, this.unitid, 21005, value.equals("1"));
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": reset command");
            }
        } else if (cname.equalsIgnoreCase("mute")) {
            userBase.modbusWriteSingleCoil(this.host, this.unitid, 21002, !value.equals("1"));
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": mute command");
            }
        } else if (cname.equalsIgnoreCase("buzzeroff")) {
            userBase.modbusWriteSingleCoil(this.host, this.unitid, 21001, value.equals("1"));
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": buzzer off command");
            }
        } else if (cname.equalsIgnoreCase("prealarmoff")) {
            userBase.modbusWriteSingleCoil(this.host, this.unitid, 21004, value.equals("1"));
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": pre alarm off command");
            }
        } else if (cname.equalsIgnoreCase("patrol")) {
            userBase.modbusWriteSingleCoil(this.host, this.unitid, 21003, value.equals("1"));
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": patrol mode on command");
            }
        } else if (cname.startsWith("write.coil.register.")) {
            String register = cname.split("\\.")[3];
            userBase.modbusWriteSingleCoil(this.host, this.unitid, Integer.valueOf(register), value.equals("1"));
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": write coil register: " + register + " | value: " + value);
            }
        }
    }

    public static String getException(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String sStackTrace = sw.toString();
        return sStackTrace;
    }

    private void loadNames() throws FileNotFoundException {
        Scanner sc;
        block5: {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  loading inimprevidia.ini file");
            }
            sc = new Scanner(new File(FILE1));
            try {
                sc.useDelimiter("(\\n)");
                while (sc.hasNext()) {
                    String next = sc.next();
                    if (next.length() <= 1 || next.startsWith("#") || next == null) continue;
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(this.name) + ":  line: " + next + " | length: " + next.length());
                    }
                    String[] spl = next.split("=");
                    String dp = spl[0].replaceAll("\\s+", "");
                    String n2 = spl[1].trim();
                    String[] spl2 = dp.split("\\.");
                    if (!this.name.equalsIgnoreCase(spl2[0])) continue;
                    dp = dp.replace(String.valueOf(this.name) + ".", "");
                    this.ioWriteNoEvents(String.valueOf(dp) + ".name", n2);
                    if (!this.gui) continue;
                    this.uiSet(String.valueOf(dp) + ".name", "value", n2);
                }
            }
            catch (Exception e2) {
                if (!this.isVerboseLog()) break block5;
                this.messageLog(String.valueOf(this.name) + ":  error reading inimprevidia.ini file " + Driver.getException(e2));
            }
        }
        sc.close();
    }

    @Override
    protected void ioWrite(String dp, String value) {
        block15: {
            try {
                String oldvalue = userBase.ioGet(String.valueOf(this.name) + "." + dp);
                if (!oldvalue.equals(value)) {
                    if (!this.startupevent) {
                        super.ioWriteNoEvents(dp, value);
                    } else {
                        super.ioWrite(dp, value);
                    }
                    if (this.gui) {
                        if (value.equals("0") || value.equals("1")) {
                            if (value.equals("1")) {
                                this.uiSet(String.valueOf(dp) + ".1.label", "visible", "true");
                                this.uiSet(String.valueOf(dp) + ".0.label", "visible", "false");
                            } else {
                                this.uiSet(String.valueOf(dp) + ".1.label", "visible", "false");
                                this.uiSet(String.valueOf(dp) + ".0.label", "visible", "true");
                            }
                        } else {
                            this.uiSet(dp, "value", value);
                        }
                    }
                }
            }
            catch (Exception e2) {
                if (!this.startupevent) {
                    super.ioWriteNoEvents(dp, value);
                } else {
                    super.ioWrite(dp, value);
                }
                if (!this.gui) break block15;
                if (value.equals("0") || value.equals("1")) {
                    if (value.equals("1")) {
                        this.uiSet(String.valueOf(dp) + ".1.label", "visible", "true");
                        this.uiSet(String.valueOf(dp) + ".0.label", "visible", "false");
                    } else {
                        this.uiSet(String.valueOf(dp) + ".1.label", "visible", "false");
                        this.uiSet(String.valueOf(dp) + ".0.label", "visible", "true");
                    }
                }
                this.uiSet(dp, "value", value);
            }
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        return new String(hexChars);
    }

    private static String convertNibbleToDecimal(boolean b0, boolean b1, boolean b2, boolean b3) {
        int decimalValue = 0;
        if (b0) {
            ++decimalValue;
        }
        if (b1) {
            decimalValue += 2;
        }
        if (b2) {
            decimalValue += 4;
        }
        if (b3) {
            decimalValue += 8;
        }
        return String.valueOf(decimalValue);
    }

    private static int divideAndRoundUp(int zonesNumber) {
        return (int)Math.ceil((double)zonesNumber / 100.0);
    }
}

