/*
 * Decompiled with CFR 0.152.
 */
package drivers.ifttt;

import com.hsyco.Configuration;
import com.hsyco.HTTPServer;
import com.hsyco.driverBase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private String serverName = null;
    private String password = null;
    private String eventKey = null;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.serverName = name;
        this.password = config.get("password");
        if (this.password == null) {
            this.errorLog(String.valueOf(name) + ": Initialization failed - password not set");
            this.end();
            return false;
        }
        this.eventKey = config.get("eventkey");
        HTTPServer.registerIFTTTHook(name, this.password);
        return true;
    }

    public boolean loop() {
        this.sleep(20000L);
        return true;
    }

    public boolean end() {
        HTTPServer.registerIFTTTHook(null, null);
        return true;
    }

    public void command(String name, String value) {
        if (name.startsWith("httpPostData")) {
            int i2 = name.indexOf(46);
            if (i2 > 0) {
                this.ioWriteForced("request." + name.substring(i2 + 1), value);
            } else {
                this.ioWriteForced("request", value);
            }
        } else if (this.eventKey != null && name.startsWith("event")) {
            int i3 = name.indexOf(46);
            try {
                String r = Driver.urlGet("https://maker.ifttt.com/trigger/" + (i3 > 0 ? name.substring(i3 + 1) : "hsyco") + "/with/key/" + this.eventKey + "?value1=" + URLEncoder.encode(value, "UTF-8"), null, null);
                if (Configuration.verboseLog) {
                    this.messageLog(String.valueOf(this.serverName) + ": Event trigger response: " + r);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

