/*
 * Decompiled with CFR 0.152.
 */
package drivers.hue;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import com.philips.lighting.hue.listener.PHLightListener;
import com.philips.lighting.hue.sdk.PHBridgeSearchManager;
import com.philips.lighting.hue.sdk.PHHueSDK;
import com.philips.lighting.model.PHBridge;
import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHHueError;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHLightState;
import drivers.hue.BridgeListener;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    public static final String[] WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage", "dimmer", "rgb"};
    private static final long SEARCH_TIMEOUT = 10000L;
    private static final long AUTHENTICATION_TIMEOUT = 30000L;
    private String name;
    private boolean genEvent;
    private boolean master;
    private PHHueSDK phHueSDK;
    private PHBridge bridge;
    boolean quit;
    private boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            this.phHueSDK = PHHueSDK.create();
            this.phHueSDK.setAppName("com.hsyco.drivers.hue");
            this.phHueSDK.setDeviceName("HSYCO");
            BridgeListener bridgeListener = BridgeListener.INSTANCE;
            synchronized (bridgeListener) {
                if (!this.registered) {
                    this.phHueSDK.getNotificationManager().registerSDKListener(BridgeListener.INSTANCE);
                    this.registered = true;
                }
            }
            BridgeListener.INSTANCE.register(this, config.get("mac"));
            PHBridgeSearchManager sm = (PHBridgeSearchManager)this.phHueSDK.getSDKService((byte)1);
            sm.search(true, true);
            long end = System.currentTimeMillis() + 10000L + 30000L + 5000L;
            while (this.bridge == null && System.currentTimeMillis() < end) {
                Thread.sleep(500L);
            }
            this.ioWrite(true, "authentication", "0");
            if (this.bridge == null) {
                throw new Exception("Bridge not found");
            }
            this.messageLog("Connected to bridge");
            this.phHueSDK.setSelectedBridge(this.bridge);
            Integer interval = null;
            try {
                interval = Integer.parseInt(config.get("pollinterval"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            interval = interval == null ? Integer.valueOf(10000) : Integer.valueOf(interval * 1000);
            this.phHueSDK.enableHeartbeat(this.bridge, interval.intValue());
            this.genEvent = Boolean.parseBoolean(config.get("startupevents"));
            this.master = Boolean.parseBoolean(config.get("master"));
            this.enableSystemtopoDiscovery();
            for (PHLight light : this.bridge.getResourceCache().getAllLights()) {
                String lightId = light.getIdentifier();
                String lightName = light.getName();
                this.messageLog("Found light " + lightId + " " + light.getLightType().toString() + " " + lightName);
                String dimmerName = "Hue light " + lightId + " - " + light.getName() + " - Dimmer";
                String rgbName = "Hue light " + lightId + " - " + light.getName() + " - RGB";
                this.deviceSet(11, "light." + lightId + ".rgb", "", rgbName);
                this.deviceSet(11, "light." + lightId + ".dimmer", "", dimmerName);
            }
            this.updateLigthsState();
            this.genEvent = true;
            this.ioWrite("connection", "online");
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Initialization failed - " + e2.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    String getName() {
        return this.name;
    }

    PHHueSDK getPhHueSDK() {
        return this.phHueSDK;
    }

    void setBridge(PHBridge bridge) {
        if (this.bridge == null) {
            this.bridge = bridge;
        }
    }

    PHBridge getBridge() {
        return this.bridge;
    }

    public boolean loop() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !this.quit;
    }

    void updateLigthsState() {
        for (PHLight light : this.bridge.getResourceCache().getAllLights()) {
            String savedState;
            PHLightState state = new PHLightState(light.getLastKnownLightState());
            String id = light.getIdentifier();
            if (this.master && (savedState = this.varGet("__hsyco__hue_" + this.name + "_light." + id + "!")) != null && !savedState.isEmpty()) {
                PHLightState forceState = new PHLightState();
                boolean force = false;
                if (savedState.startsWith("false")) {
                    if (state.isOn().booleanValue()) {
                        forceState.setOn(false);
                        state.setOn(false);
                        force = true;
                    }
                } else {
                    String[] hsb = savedState.split(";");
                    int hue = Integer.parseInt(hsb[1]);
                    int saturation = Integer.parseInt(hsb[2]);
                    int brightness = Integer.parseInt(hsb[3]);
                    if (!state.isOn().booleanValue()) {
                        forceState.setOn(true);
                        state.setOn(true);
                        force = true;
                    }
                    if (state.getHue() != null && state.getHue() != hue) {
                        forceState.setHue(hue);
                        state.setHue(hue);
                        force = true;
                    }
                    if (state.getSaturation() != null && state.getSaturation() != saturation) {
                        forceState.setSaturation(saturation);
                        state.setSaturation(saturation);
                        force = true;
                    }
                    if (state.getBrightness() != brightness) {
                        forceState.setBrightness(brightness);
                        state.setBrightness(brightness);
                        force = true;
                    }
                }
                if (force && state.isReachable().booleanValue()) {
                    this.sendStateUpdate(id, forceState);
                }
            }
            this.writeDatapoints(id, state);
        }
    }

    private void writeDatapoints(String id, PHLightState state) {
        Integer brightness = state.getBrightness();
        Integer saturation = state.getSaturation();
        Integer hue = state.getHue();
        this.ioWrite("light." + id + ".reachable", state.isReachable() != false ? "1" : "0");
        this.ioWrite("light." + id + ".on", state.isOn() != false ? "1" : "0");
        if (brightness != null) {
            this.ioWrite("light." + id + ".brightness", "" + brightness);
        }
        if (saturation != null) {
            this.ioWrite("light." + id + ".saturation", "" + saturation);
        }
        if (hue != null) {
            this.ioWrite("light." + id + ".hue", "" + hue);
        }
        String rgbIoVal = null;
        String rgbDevVal = null;
        String dimIoVal = null;
        String dimDevVal = null;
        if (state.isOn().booleanValue()) {
            if (brightness != null) {
                if (hue != null && saturation != null) {
                    float h2 = (float)hue.intValue() / 65535.0f;
                    float s = (float)saturation.intValue() / 254.0f;
                    float br = (float)brightness.intValue() / 254.0f;
                    int rgb = Color.HSBtoRGB(h2, s, br);
                    int r = rgb >>> 16 & 0xFF;
                    int g2 = rgb >>> 8 & 0xFF;
                    int b2 = rgb & 0xFF;
                    rgbIoVal = String.valueOf(r) + ";" + g2 + ";" + b2;
                    rgbDevVal = String.valueOf(r) + "*" + g2 + "*" + b2;
                }
                dimIoVal = dimDevVal = this.toPercent(brightness);
            }
        } else {
            rgbIoVal = "0;0;0";
            rgbDevVal = "0*0*0";
            dimDevVal = "off";
            dimIoVal = "off";
        }
        if (!state.isReachable().booleanValue()) {
            if (rgbDevVal != null) {
                rgbDevVal = String.valueOf(rgbDevVal) + "*fault";
            }
            if (dimDevVal != null) {
                dimDevVal = String.valueOf(dimDevVal) + "*fault";
            }
        }
        if (rgbIoVal != null) {
            this.ioWrite("light." + id + ".rgb", rgbIoVal);
        }
        if (dimIoVal != null) {
            this.ioWrite("light." + id + ".dimmer", dimIoVal);
        }
        if (rgbDevVal != null) {
            this.deviceSet(11, "light." + id + ".rgb", rgbDevVal, null);
        }
        if (dimDevVal != null) {
            this.deviceSet(11, "light." + id + ".dimmer", dimDevVal, null);
        }
    }

    private String toPercent(int val) {
        if (val == 0) {
            return "0%";
        }
        if ((val = val * 100 / 254) < 1) {
            val = 1;
        }
        return String.valueOf(String.valueOf(val)) + "%";
    }

    private int to254ths(String val) {
        int v = Integer.parseInt(val = val.replace("%", ""));
        if (v < 100) {
            ++v;
        }
        return v * 254 / 100;
    }

    public boolean end() {
        try {
            if (this.bridge != null) {
                for (PHLight light : this.bridge.getResourceCache().getAllLights()) {
                    this.ioWrite("light." + light.getIdentifier() + ".reachable", "0");
                }
                BridgeListener.INSTANCE.unregister(this.bridge);
            }
            if (this.phHueSDK != null) {
                this.phHueSDK.disableAllHeartbeat();
                this.phHueSDK.destroySDK();
            }
            this.ioWrite("connection", "offline");
        }
        catch (Throwable t) {
            this.errorLog("Error quitting: " + t.getLocalizedMessage());
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        this.command(cmd, value);
        return "";
    }

    public void command(String name, String value) {
        block55: {
            try {
                Integer brightness;
                Integer saturation;
                Integer hue;
                if (Configuration.verboseLog) {
                    this.messageLog("Command: " + name + " = " + value);
                }
                int startId = name.indexOf(46) + 1;
                int endId = name.indexOf(46, startId);
                String cmd = name.substring(endId + 1).toLowerCase();
                String id = name.substring(startId, endId);
                PHLightState newState = new PHLightState();
                if (cmd.equals("dimmer")) {
                    if (value.equals("on")) {
                        newState.setOn(true);
                    } else if (value.equals("off") || value.equals("0") || value.equals("0%")) {
                        newState.setOn(false);
                    } else {
                        newState.setOn(true);
                        newState.setBrightness(this.to254ths(value));
                    }
                } else if (cmd.equals("rgb")) {
                    if (value.equals("on")) {
                        newState.setOn(true);
                    } else if (value.equals("off")) {
                        newState.setOn(false);
                    } else {
                        String[] rgb = value.split("[\\*;]");
                        float[] hsb = Color.RGBtoHSB(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]), null);
                        if (hsb[2] == 0.0f) {
                            newState.setOn(false);
                        } else {
                            newState.setOn(true);
                            newState.setHue(Math.round(hsb[0] * 65535.0f));
                            newState.setSaturation(Math.round(hsb[1] * 254.0f));
                            newState.setBrightness(Math.round(hsb[2] * 254.0f));
                        }
                    }
                } else if (cmd.equals("on")) {
                    newState.setOn(value.equals("1"));
                } else if (cmd.equals("brightness")) {
                    newState.setBrightness(Integer.parseInt(value));
                } else if (cmd.equals("xy")) {
                    String[] xy = value.split("[\\*;]");
                    float x = Float.parseFloat(xy[0]);
                    float y = Float.parseFloat(xy[1]);
                    newState.setX(Float.valueOf(x));
                    newState.setY(Float.valueOf(y));
                } else if (cmd.equals("saturation")) {
                    newState.setSaturation(Integer.parseInt(value));
                } else if (cmd.equals("hue")) {
                    newState.setHue(Integer.parseInt(value));
                } else if (cmd.equals("temperature")) {
                    newState.setCt(Integer.parseInt(value));
                } else if (cmd.equals("colorloop")) {
                    if (value.equals("1")) {
                        newState.setEffectMode(PHLight.PHLightEffectMode.EFFECT_COLORLOOP);
                    } else {
                        newState.setEffectMode(PHLight.PHLightEffectMode.EFFECT_NONE);
                    }
                } else if (cmd.equals("blink")) {
                    if (value.equals("single")) {
                        newState.setAlertMode(PHLight.PHLightAlertMode.ALERT_SELECT);
                    } else if (value.equals("long")) {
                        newState.setAlertMode(PHLight.PHLightAlertMode.ALERT_LSELECT);
                    } else {
                        newState.setAlertMode(PHLight.PHLightAlertMode.ALERT_NONE);
                    }
                } else {
                    throw new Exception("unknown command");
                }
                this.sendStateUpdate(id, newState);
                if (!this.master) break block55;
                String lastOhsbVal = this.varGet("__hsyco__hue_" + this.name + "_light." + id + "!");
                String[] lastOhsb = null;
                if (lastOhsbVal != null) {
                    lastOhsb = lastOhsbVal.split(";");
                }
                PHLight light = this.bridge.getResourceCache().getLights().get(id);
                PHLightState lastState = new PHLightState(light.getLastKnownLightState());
                Boolean on = newState.isOn();
                if (on == null) {
                    try {
                        on = Boolean.parseBoolean(lastOhsb[0]);
                    }
                    catch (Exception e2) {
                        on = lastState.isOn();
                    }
                }
                if ((hue = newState.getHue()) == null) {
                    try {
                        hue = Integer.parseInt(lastOhsb[1]);
                    }
                    catch (Exception e3) {
                        hue = lastState.getHue();
                    }
                }
                if ((saturation = newState.getSaturation()) == null) {
                    try {
                        saturation = Integer.parseInt(lastOhsb[2]);
                    }
                    catch (Exception e4) {
                        saturation = lastState.getSaturation();
                    }
                }
                if ((brightness = newState.getBrightness()) == null) {
                    try {
                        brightness = Integer.parseInt(lastOhsb[3]);
                    }
                    catch (Exception e5) {
                        brightness = lastState.getBrightness();
                    }
                }
                try {
                    lastState.setOn(on);
                    lastState.setBrightness(brightness);
                    lastState.setHue(hue);
                    lastState.setSaturation(saturation);
                    this.writeDatapoints(id, lastState);
                }
                catch (Exception e5) {
                    // empty catch block
                }
                if (on != null && hue != null && saturation != null && brightness != null) {
                    String ohsb = on + ";" + hue + ";" + saturation + ";" + brightness;
                    this.varSet("__hsyco__hue_" + this.name + "_light." + id + "!", ohsb);
                }
            }
            catch (Exception e6) {
                this.errorLog("Error executing command: " + e6.getLocalizedMessage());
            }
        }
    }

    synchronized void sendStateUpdate(String lightId, PHLightState lightState) {
        this.bridge.updateLightState(lightId, lightState, new PHLightListener(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onStateUpdate(Map<String, String> successAttribute, List<PHHueError> errorAttribute) {
            }

            @Override
            public void onError(int code, String message) {
                Driver.this.errorLog("Error executing command: " + code + " - " + message);
            }

            @Override
            public void onSearchComplete() {
            }

            @Override
            public void onReceivingLights(List<PHBridgeResource> lights) {
            }

            @Override
            public void onReceivingLightDetails(PHLight light) {
            }
        });
    }

    @Override
    public void ioWrite(String name, String value) {
        this.ioWrite(this.genEvent, name, value);
    }

    public void ioWrite(boolean event, String name, String value) {
        if (event) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    @Override
    public void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    public void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

