/*
 * Decompiled with CFR 0.152.
 */
package drivers.heos;

import com.hsyco.userBase;
import drivers.heos.Driver;
import drivers.heos.Lock;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Monitor
extends Thread {
    private final BufferedReader in;
    private final Driver driver;
    boolean run = true;
    private ConcurrentHashMap<String, Lock> waiting = new ConcurrentHashMap();

    public Monitor(Driver driver, BufferedReader in) {
        this.driver = driver;
        this.in = in;
    }

    @Override
    public void run() {
        while (this.run) {
            try {
                String msg = this.getMessage();
                if (msg.isEmpty()) continue;
                this.processMessage(msg);
            }
            catch (Exception e2) {
                this.driver.errorLog("Exception in monitor loop: " + e2);
                if (!(e2 instanceof SocketException)) continue;
                this.run = false;
            }
        }
        this.run = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(String msg) throws Exception {
        Map<String, String> attributes;
        JSONArray payload;
        String message;
        JSONObject json = new JSONObject(msg);
        JSONObject heos = json.getJSONObject("heos");
        String string = message = heos.has("message") ? heos.getString("message") : null;
        if (message != null && message.startsWith("command under process")) {
            return;
        }
        String command = heos.getString("command");
        if (command.isEmpty()) {
            return;
        }
        boolean fail = heos.has("result") && heos.getString("result").equals("fail");
        Lock w = this.waiting.remove(command);
        if (w != null) {
            w.resp = json;
            w.fail = fail;
            Lock lock = w;
            synchronized (lock) {
                w.notify();
            }
        }
        if (fail) {
            this.driver.errorLog("Command " + command + " failed: " + message);
            return;
        }
        if (command.startsWith("player/")) {
            if (command.endsWith("get_players")) {
                payload = json.getJSONArray("payload");
                Map<String, String> map = this.driver.pidNameMap;
                synchronized (map) {
                    StringBuilder listValues = new StringBuilder();
                    StringBuilder listLabels = new StringBuilder();
                    int i2 = 0;
                    while (i2 < payload.length()) {
                        JSONObject player = payload.getJSONObject(i2);
                        String pid = "" + player.getInt("pid");
                        String name = player.getString("name");
                        name = name.trim().toLowerCase().replaceAll("\\s+", "-");
                        this.driver.pidNameMap.put(pid, name);
                        this.driver.namePidMap.put(name, pid);
                        this.driver.ioWrite(String.valueOf(name) + ".model", player.getString("model"));
                        this.driver.ioWrite(String.valueOf(name) + ".version", player.getString("version"));
                        if (i2 == 0) {
                            userBase.uiSet("__hsyco__heosbrowser.players", "value", pid);
                            this.driver.selectedPlayer = pid;
                        } else {
                            listValues.append(',');
                            listLabels.append(',');
                        }
                        listValues.append(pid);
                        listLabels.append(name);
                        ++i2;
                    }
                    userBase.uiSet("__hsyco__heosbrowser.players", "values", listValues.toString());
                    userBase.uiSet("__hsyco__heosbrowser.players", "labels", listLabels.toString());
                }
            } else if (command.endsWith("get_groups")) {
                payload = json.getJSONArray("payload");
                Map<String, String> map = this.driver.gidNameMap;
                synchronized (map) {
                    this.driver.gidNameMap.clear();
                    int i3 = 0;
                    while (i3 < payload.length()) {
                        JSONObject group = payload.getJSONObject(i3);
                        String gid = "" + group.getInt("gid");
                        String name = group.getString("name");
                        name = "group." + name.trim().toLowerCase().replaceAll("\\s+", "-");
                        this.driver.gidNameMap.put(gid, name);
                        this.driver.nameGidMap.put(name, gid);
                        ++i3;
                    }
                }
            } else {
                attributes = this.getAttributes(message);
                String name = this.driver.pidNameMap.get(attributes.get("pid"));
                if (command.endsWith("get_play_state")) {
                    String state = attributes.get("state");
                    this.writePlayerState(name, state);
                } else if (command.endsWith("get_now_playing_media")) {
                    JSONObject payload2 = json.getJSONObject("payload");
                    Iterator<String> it = payload2.keys();
                    while (it.hasNext()) {
                        String key = it.next();
                        String value = payload2.get(key).toString();
                        String id = String.valueOf(name) + "." + key;
                        this.driver.ioWrite(id, value);
                        this.driver.uiSet(id, "value", value);
                    }
                } else if (command.endsWith("get_volume")) {
                    String level = attributes.get("level");
                    this.writeVolume(name, level);
                } else if (command.endsWith("get_mute")) {
                    String state = attributes.get("state");
                    this.writeMute(name, state);
                } else if (command.endsWith("get_play_mode")) {
                    String repeat = attributes.get("repeat");
                    String shuffle = attributes.get("shuffle");
                    this.writeRepeat(name, repeat);
                    this.writeShuffle(name, shuffle);
                } else if (command.endsWith("get_queue")) {
                    JSONArray payload3 = json.getJSONArray("payload");
                    int i4 = 1;
                    StringBuilder listValues = new StringBuilder();
                    StringBuilder listLabels = new StringBuilder();
                    while (i4 <= payload3.length()) {
                        JSONObject elem = payload3.getJSONObject(i4 - 1);
                        String song = elem.getString("song");
                        String album = elem.getString("album");
                        String artist = elem.getString("artist");
                        String qid = "" + elem.getInt("qid");
                        if (i4 != 1) {
                            listValues.append(',');
                            listLabels.append(',');
                        }
                        listValues.append(qid);
                        listLabels.append(qid).append('|').append(song.replace(",", "&#44;")).append('|').append(artist.replace(",", "&#44;")).append('|').append(album.replace(",", "&#44;"));
                        ++i4;
                    }
                    this.driver.uiSet(String.valueOf(name) + ".queue", "values", listValues.toString());
                    this.driver.uiSet(String.valueOf(name) + ".queue", "labels", listLabels.toString());
                }
            }
        } else if (command.startsWith("group/")) {
            attributes = this.getAttributes(message);
            String name = this.driver.gidNameMap.get(attributes.get("gid"));
            if (command.endsWith("get_volume")) {
                String level = attributes.get("level");
                this.writeVolume(name, level);
            } else if (command.endsWith("get_mute")) {
                String state = attributes.get("state");
                this.writeMute(name, state);
            }
        } else if (command.startsWith("event/")) {
            if (command.endsWith("players_changed")) {
                this.driver.send("player/get_players", null);
            } else if (command.endsWith("groups_changed")) {
                this.driver.send("player/get_groups", null);
            } else if (message != null) {
                attributes = this.getAttributes(message);
                String pid = attributes.get("pid");
                if (pid != null) {
                    String name = this.driver.pidNameMap.get(pid);
                    if (command.endsWith("source_data_changed")) {
                        String sid = attributes.get("sid");
                        this.driver.ioWrite(String.valueOf(name) + ".sid", sid);
                    } else if (command.endsWith("player_state_changed")) {
                        String state = attributes.get("state");
                        this.writePlayerState(name, state);
                    } else if (command.endsWith("player_now_playing_changed")) {
                        this.driver.send("player/get_now_playing_media", "pid=" + pid);
                    } else if (command.endsWith("player_now_playing_progress")) {
                        int duration = Integer.parseInt(attributes.get("duration"));
                        if (duration != 0) {
                            int cur_pos = Integer.parseInt(attributes.get("cur_pos"));
                            String progress = String.valueOf(cur_pos * 100 / duration) + "%";
                            String id = String.valueOf(name) + ".progress";
                            this.driver.ioWrite(id, progress);
                            this.driver.uiSet(id, "value", progress);
                        }
                    } else if (command.endsWith("player_queue_changed")) {
                        this.driver.send("player/get_queue", "pid=" + pid);
                    } else if (command.endsWith("player_volume_changed")) {
                        String level = attributes.get("level");
                        String mute = attributes.get("mute");
                        this.writeVolume(name, level);
                        if (mute != null) {
                            this.writeMute(name, mute);
                        }
                    } else if (command.endsWith("player_mute_changed")) {
                        String state = attributes.get("state");
                        this.writeMute(name, state);
                    } else if (command.endsWith("repeat_mode_changed")) {
                        String repeat = attributes.get("repeat");
                        this.writeRepeat(name, repeat);
                    } else if (command.endsWith("shuffle_mode_changed")) {
                        String shuffle = attributes.get("shuffle");
                        this.writeShuffle(name, shuffle);
                    }
                } else {
                    String gid = attributes.get("gid");
                    if (gid != null) {
                        String name = this.driver.gidNameMap.get(gid);
                        if (command.endsWith("group_volume_changed")) {
                            String level = attributes.get("level");
                            String mute = attributes.get("mute");
                            this.writeVolume(name, level);
                            if (mute != null) {
                                this.writeMute(name, mute);
                            }
                        } else if (command.endsWith("group_mute_changed")) {
                            String state = attributes.get("state");
                            this.writeMute(name, state);
                        }
                    }
                }
            }
        } else if (command.startsWith("browse/")) {
            if (command.endsWith("get_music_sources")) {
                payload = json.getJSONArray("payload");
                StringBuilder listValues = new StringBuilder();
                StringBuilder listLabels = new StringBuilder();
                int i5 = 0;
                while (i5 < payload.length()) {
                    JSONObject source = payload.getJSONObject(i5);
                    int sid = source.getInt("sid");
                    String name = source.getString("name");
                    String type = source.getString("type");
                    if (i5 != 0) {
                        listValues.append(',');
                        listLabels.append(',');
                    }
                    listValues.append(type).append('&');
                    listValues.append("sid=").append(sid);
                    listLabels.append(name.replace(",", "&#44;"));
                    ++i5;
                }
                userBase.uiSet("__hsyco__heosbrowser.browser", "values", listValues.toString());
                userBase.uiSet("__hsyco__heosbrowser.browser", "labels", listLabels.toString());
            } else if (command.endsWith("browse")) {
                attributes = this.getAttributes(message);
                String sid = attributes.get("sid");
                String cid = attributes.get("cid");
                JSONArray payload4 = json.getJSONArray("payload");
                StringBuilder listValues = new StringBuilder();
                StringBuilder listLabels = new StringBuilder();
                int i6 = 0;
                while (i6 < payload4.length()) {
                    String album;
                    JSONObject source = payload4.getJSONObject(i6);
                    if (source.has("sid")) {
                        sid = "" + source.getInt("sid");
                    }
                    if (source.has("cid")) {
                        cid = source.getString("cid");
                    }
                    String mid = source.has("mid") ? source.getString("mid") : null;
                    String name = source.getString("name");
                    String type = source.getString("type");
                    String artist = source.has("artist") ? source.getString("artist") : null;
                    String string2 = album = source.has("album") ? source.getString("album") : null;
                    if (i6 != 0) {
                        listValues.append(',');
                        listLabels.append(',');
                    }
                    listValues.append(type);
                    listValues.append('&');
                    listValues.append("sid=" + sid);
                    if (cid != null && !type.equals("station")) {
                        listValues.append("&cid=").append(cid);
                    }
                    if (mid != null) {
                        listValues.append("&mid=").append(mid);
                    }
                    listLabels.append(name.replace(",", "&#44;"));
                    if (artist != null) {
                        listLabels.append(" - ").append(artist.replace(",", "&#44;"));
                    }
                    if (album != null) {
                        listLabels.append(" - ").append(album.replace(",", "&#44;"));
                    }
                    ++i6;
                }
                userBase.uiSet("__hsyco__heosbrowser.browser", "values", listValues.toString());
                userBase.uiSet("__hsyco__heosbrowser.browser", "labels", listLabels.toString());
            }
        }
    }

    private void writeRepeat(String id, String state) {
        id = String.valueOf(id) + ".repeat";
        if (state.equals("on_one")) {
            this.driver.ioWrite(id, "on_one");
            this.driver.uiSet(String.valueOf(id) + ".on_one", "visible", "true");
            this.driver.uiSet(String.valueOf(id) + ".on_all", "visible", "false");
            this.driver.uiSet(String.valueOf(id) + ".off", "visible", "false");
        } else if (state.equals("on_all")) {
            this.driver.ioWrite(id, "on_all");
            this.driver.uiSet(String.valueOf(id) + ".on_one", "visible", "false");
            this.driver.uiSet(String.valueOf(id) + ".on_all", "visible", "true");
            this.driver.uiSet(String.valueOf(id) + ".off", "visible", "false");
        } else {
            this.driver.ioWrite(id, "off");
            this.driver.uiSet(String.valueOf(id) + ".on_one", "visible", "false");
            this.driver.uiSet(String.valueOf(id) + ".on_all", "visible", "false");
            this.driver.uiSet(String.valueOf(id) + ".off", "visible", "true");
        }
    }

    private void writeShuffle(String id, String state) {
        id = String.valueOf(id) + ".shuffle";
        if (state.equals("on")) {
            this.driver.ioWrite(id, "on");
            this.driver.uiSet(String.valueOf(id) + ".on", "visible", "true");
            this.driver.uiSet(String.valueOf(id) + ".off", "visible", "false");
        } else {
            this.driver.ioWrite(id, "off");
            this.driver.uiSet(String.valueOf(id) + ".off", "visible", "true");
            this.driver.uiSet(String.valueOf(id) + ".on", "visible", "false");
        }
    }

    private void writeMute(String id, String state) {
        id = String.valueOf(id) + ".mute";
        if (state.equals("on")) {
            this.driver.ioWrite(id, "1");
            this.driver.uiSet(String.valueOf(id) + ".1", "visible", "true");
            this.driver.uiSet(String.valueOf(id) + ".0", "visible", "false");
        } else {
            this.driver.ioWrite(id, "0");
            this.driver.uiSet(String.valueOf(id) + ".0", "visible", "true");
            this.driver.uiSet(String.valueOf(id) + ".1", "visible", "false");
        }
    }

    private void writeVolume(String id, String level) {
        level = String.valueOf(level) + "%";
        String dp = String.valueOf(id) + ".volume";
        this.driver.ioWrite(dp, level);
        this.driver.uiSet(dp, "value", level);
        String pid = this.driver.namePidMap.get(id);
        if (pid != null && pid.equals(this.driver.selectedPlayer)) {
            userBase.uiSet("__hsyco__heosbrowser.volume", "value", level.substring(0, level.length()));
        }
    }

    private void writePlayerState(String pid, String state) {
        this.driver.ioWrite(String.valueOf(pid) + ".state", state);
        if (state.equals("play")) {
            this.driver.uiSet(String.valueOf(pid) + ".state.play", "visible", "true");
            this.driver.uiSet(String.valueOf(pid) + ".state.pause", "visible", "false");
            this.driver.uiSet(String.valueOf(pid) + ".state.stop", "visible", "false");
        } else if (state.equals("pause")) {
            this.driver.uiSet(String.valueOf(pid) + ".state.play", "visible", "false");
            this.driver.uiSet(String.valueOf(pid) + ".state.pause", "visible", "true");
            this.driver.uiSet(String.valueOf(pid) + ".state.stop", "visible", "false");
        } else if (state.equals("stop")) {
            this.driver.uiSet(String.valueOf(pid) + ".state.play", "visible", "false");
            this.driver.uiSet(String.valueOf(pid) + ".state.pause", "visible", "false");
            this.driver.uiSet(String.valueOf(pid) + ".state.stop", "visible", "true");
        }
    }

    private Map<String, String> getAttributes(String message) {
        String[] attributes;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = attributes = message.split("&");
        int n2 = attributes.length;
        int n3 = 0;
        while (n3 < n2) {
            String attribute = stringArray[n3];
            String[] name_val = attribute.split("=");
            map.put(name_val[0], name_val[1]);
            ++n3;
        }
        return map;
    }

    private String getMessage() throws IOException {
        StringBuilder resp = new StringBuilder();
        int r = 0;
        try {
            while ((r = this.in.read()) != -1) {
                char c2 = (char)r;
                if (c2 != '\n' || resp.charAt(resp.length() - 1) != '\r') {
                    resp.append(c2);
                    continue;
                }
                break;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return resp.toString();
    }

    public Lock register(String command) {
        Lock lock = new Lock();
        this.waiting.put(command, lock);
        return lock;
    }

    public void quit() {
        this.run = false;
        this.interrupt();
    }
}

