/*
 * Decompiled with CFR 0.152.
 */
package drivers.heos;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import com.hsyco.userBase;
import drivers.heos.Lock;
import drivers.heos.Monitor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final String BROADCAST_ADDR = "239.255.255.250";
    private static final int DISCOVER_PORT = 1900;
    private static final String SEARCH_TARGET = "urn:schemas-denon-com:device:ACT-Denon:1";
    private static final String DISCOVER_MESSAGE = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nST: urn:schemas-denon-com:device:ACT-Denon:1\r\nMAN: \"ssdp:discover\"\r\nMX: 2\r\n\r\n";
    private static final int HEOS_PORT = 1255;
    private static final Charset CHARSET = Charset.forName("UTF-8");
    static final String UI_BROWSER_PREFIX = "__hsyco__heosbrowser.";
    private String name;
    private boolean genEvent = true;
    private String baseUrl;
    private BufferedReader in;
    private BufferedWriter out;
    private Monitor monitor;
    Map<String, String> pidNameMap = new HashMap<String, String>();
    Map<String, String> namePidMap = new HashMap<String, String>();
    Map<String, String> gidNameMap = new HashMap<String, String>();
    Map<String, String> nameGidMap = new HashMap<String, String>();
    String selectedPlayer;
    private String browserMid;
    private String midType;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            try {
                this.discover();
            }
            catch (IOException e2) {
                throw new Exception("Discovery error: " + e2.getLocalizedMessage(), e2);
            }
            this.messageLog("Found device at: " + this.baseUrl);
            Socket s = new Socket(this.baseUrl, 1255);
            s.setSoTimeout(10000);
            this.out = new BufferedWriter(new OutputStreamWriter(s.getOutputStream(), CHARSET));
            this.in = new BufferedReader(new InputStreamReader(s.getInputStream(), CHARSET));
            this.monitor = new Monitor(this, this.in);
            this.monitor.start();
            try {
                this.registerForChanges(false);
            }
            catch (Exception e3) {
                throw new Exception("Error unregistering for change events: " + e3.getLocalizedMessage());
            }
            String startupevents = config.get("startupevents");
            if (startupevents != null) {
                this.genEvent = Boolean.parseBoolean(startupevents);
            }
            String user2 = config.get("user");
            String password = config.get("password");
            if (user2 != null && password != null) {
                try {
                    this.sendAndWaitResponse("system/sign_in", "un=" + user2 + "&pw=" + password, 10000L);
                }
                catch (Exception e4) {
                    throw new Exception("Error signing in: " + e4.getLocalizedMessage(), e4);
                }
            }
            try {
                this.sendAndWaitResponse("player/get_players", null, 20000L);
            }
            catch (Exception e5) {
                throw new Exception("Error looking for players: " + e5.getLocalizedMessage(), e5);
            }
            try {
                this.sendAndWaitResponse("player/get_groups", null, 20000L);
            }
            catch (Exception e6) {
                throw new Exception("Error looking for groups: " + e6.getLocalizedMessage(), e6);
            }
            try {
                this.sendAndWaitResponse("browse/get_music_sources", null, 20000L);
            }
            catch (Exception e7) {
                throw new Exception("Error getting music sources: " + e7.getLocalizedMessage(), e7);
            }
            try {
                this.requestState();
            }
            catch (Exception e8) {
                throw new Exception("Get state error: " + e8.getLocalizedMessage(), e8);
            }
            try {
                this.registerForChanges(true);
            }
            catch (Exception e9) {
                throw new Exception("Error registering for change events: " + e9.getLocalizedMessage(), e9);
            }
            this.send("player/get_players", null);
            Thread.sleep(500L);
            this.send("player/get_players", null);
            this.genEvent = true;
            this.ioWrite("connection", "online");
            this.uiSet("connection", "visible", "false");
            return true;
        }
        catch (Exception e10) {
            this.errorLog("Initialization failed - " + e10.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private void registerForChanges(boolean enable) throws Exception {
        String attribute = "enable=" + (enable ? "on" : "off");
        JSONObject resp = this.sendAndWaitResponse("system/register_for_change_events", attribute);
        String message = resp.getJSONObject("heos").getString("message");
        if (!message.equals(attribute)) {
            throw new Exception("Command response message error: " + message);
        }
    }

    private JSONObject sendAndWaitResponse(String command, String attributes) throws Exception {
        return this.sendAndWaitResponse(command, attributes, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject sendAndWaitResponse(String command, String attributes, long timeout) throws Exception {
        Lock lock = this.monitor.register(command);
        this.send(command, attributes);
        Lock lock2 = lock;
        synchronized (lock2) {
            lock.wait(timeout);
        }
        if (lock.resp == null) {
            throw new Exception("No response for command " + command);
        }
        if (lock.fail) {
            throw new Exception("Command failed");
        }
        return lock.resp;
    }

    private String getCommandURL(String command, String attributes) {
        StringBuilder cmd = new StringBuilder("heos://");
        cmd.append(command);
        if (attributes != null) {
            cmd.append('?');
            cmd.append(attributes);
        }
        cmd.append("\r\n");
        return cmd.toString();
    }

    void send(String command, String attributes) throws IOException {
        String url = this.getCommandURL(command, attributes);
        this.out.write(url);
        this.out.flush();
    }

    private void discover() throws IOException {
        DatagramSocket sock = null;
        try {
            String location;
            DatagramPacket respPacket;
            String st;
            sock = new DatagramSocket();
            byte[] bytes = DISCOVER_MESSAGE.getBytes(CHARSET);
            DatagramPacket discoverPacket = new DatagramPacket(bytes, bytes.length);
            discoverPacket.setAddress(InetAddress.getByName(BROADCAST_ADDR));
            discoverPacket.setPort(1900);
            sock.send(discoverPacket);
            sock.setSoTimeout(5000);
            do {
                byte[] buff = new byte[1536];
                respPacket = new DatagramPacket(buff, buff.length);
                sock.receive(respPacket);
            } while (!SEARCH_TARGET.equals(st = this.getUpnpProperty(respPacket, "st")) || (location = this.getUpnpProperty(respPacket, "location")) == null || location.length() <= 8);
            int end = location.indexOf(47, 8);
            end = Math.min(end, location.indexOf(58, 8));
            this.baseUrl = location.substring(7, end);
            return;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getUpnpProperty(DatagramPacket packet, String property) {
        String[] lines;
        String data = new String(packet.getData(), CHARSET);
        String[] stringArray = lines = data.split("\n");
        int n2 = lines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            if (line.trim().toLowerCase().startsWith(String.valueOf(property) + ":")) {
                try {
                    return line.substring(line.indexOf(58) + 1).trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestState() throws Exception {
        String attr;
        Map<String, String> map = this.pidNameMap;
        synchronized (map) {
            for (String pid : this.pidNameMap.keySet()) {
                attr = "pid=" + pid;
                this.send("player/get_play_state", attr);
                Thread.sleep(100L);
                this.send("player/get_now_playing_media", attr);
                Thread.sleep(100L);
                this.send("player/get_volume", attr);
                Thread.sleep(100L);
                this.send("player/get_mute", attr);
                Thread.sleep(100L);
                this.send("player/get_play_mode", attr);
                Thread.sleep(100L);
                this.send("player/get_queue", attr);
                Thread.sleep(100L);
            }
        }
        map = this.gidNameMap;
        synchronized (map) {
            for (String gid : this.gidNameMap.keySet()) {
                attr = "gid=" + gid;
                this.send("group/get_volume", attr);
                Thread.sleep(100L);
                this.send("group/get_mute", attr);
                Thread.sleep(100L);
            }
        }
    }

    public boolean loop() {
        try {
            Thread.sleep(40000L);
            this.requestState();
            return this.monitor.run;
        }
        catch (Exception e2) {
            this.errorLog("Error in loop: " + e2);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean end() {
        if (this.monitor != null) {
            this.monitor.quit();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ioWrite("connection", "offline");
        this.uiSet("connection", "visible", "true");
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        try {
            if (Configuration.verboseLog) {
                this.messageLog("User command: " + id);
            }
            if (id.startsWith("browser")) {
                String value = id.substring(8);
                if (value.equals("reset")) {
                    this.sendAndWaitResponse("browse/get_music_sources", null, 10000L);
                    userBase.uiSet("__hsyco__heosbrowser.mid", "value", "");
                    userBase.uiSet("__hsyco__heosbrowser.mid.type", "value", "");
                    userBase.uiSet("__hsyco__heosbrowser.play", "enabled", "false");
                    this.browserMid = null;
                } else if (value.equals("play")) {
                    if (this.selectedPlayer != null && this.browserMid != null) {
                        if (this.midType.equals("song")) {
                            this.sendAndWaitResponse("browse/add_to_queue", "pid=" + this.selectedPlayer + "&" + this.browserMid + "&aid=1");
                        } else if (this.midType.equals("station")) {
                            this.sendAndWaitResponse("browse/play_stream", "pid=" + this.selectedPlayer + "&" + this.browserMid);
                        }
                    }
                } else if (value.equals("stop")) {
                    this.sendAndWaitResponse("player/set_play_state", "pid=" + this.selectedPlayer + "&state=stop");
                } else if (value.startsWith("players.")) {
                    this.selectedPlayer = value.substring(8);
                    userBase.uiSet("__hsyco__heosbrowser.players", "value", this.selectedPlayer);
                    String vol = userBase.ioGet(String.valueOf(this.name) + "." + this.pidNameMap.get(this.selectedPlayer) + ".volume");
                    userBase.uiSet("__hsyco__heosbrowser.volume", "value", vol.substring(0, vol.length()));
                } else if (value.startsWith("volume.")) {
                    String level = value.substring(7);
                    this.sendAndWaitResponse("player/set_volume", "pid=" + this.selectedPlayer + "&level=" + level);
                    this.send("player/get_volume", "pid=" + this.selectedPlayer);
                } else if (value.startsWith("browser.")) {
                    int sep = value.indexOf(38);
                    this.midType = value.substring(8, sep);
                    String mid = value.substring(sep + 1);
                    if (mid.contains("&mid=")) {
                        userBase.uiSet("__hsyco__heosbrowser.mid", "value", mid);
                        userBase.uiSet("__hsyco__heosbrowser.mid.type", "value", String.valueOf(this.midType) + " ID:");
                        userBase.uiSet("__hsyco__heosbrowser.play", "enabled", "true");
                        this.browserMid = mid;
                    } else {
                        this.sendAndWaitResponse("browse/browse", mid, 10000L);
                    }
                }
            } else {
                int sep = id.lastIndexOf(46);
                String cmd = id.substring(0, sep);
                String value = id.substring(sep + 1);
                this.command(cmd, value);
            }
        }
        catch (Exception e2) {
            this.errorLog("Error executing user command: " + e2.getLocalizedMessage());
        }
        return "";
    }

    public void command(String name, String value) {
        block33: {
            try {
                name = name.toLowerCase();
                this.messageLog("Command: " + name + " = " + value);
                if (name.startsWith("group.")) {
                    if (name.endsWith("create")) {
                        String[] names = value.split(";");
                        StringBuilder pid = new StringBuilder();
                        String[] stringArray = names;
                        int n2 = names.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String n4 = stringArray[n3];
                            pid.append(',');
                            pid.append(this.namePidMap.get(n4));
                            ++n3;
                        }
                        this.sendAndWaitResponse("group/set_group", "pid=" + pid.substring(1));
                        break block33;
                    }
                    int dotIdx = name.indexOf(46, 6);
                    String gName = name.substring(6, dotIdx);
                    String gid = this.nameGidMap.get(gName);
                    String command = name.substring(dotIdx + 1);
                    if (command.equals("volume")) {
                        String level = value.replace("%", "");
                        if (level.startsWith("+")) {
                            level = level.substring(1);
                            this.sendAndWaitResponse("group/volume_up", "gid=" + gid + "&step=" + level);
                        } else if (level.startsWith("-")) {
                            level = level.substring(1);
                            this.sendAndWaitResponse("group/volume_down", "gid=" + gid + "&step=" + level);
                        } else {
                            this.sendAndWaitResponse("group/set_volume", "gid=" + gid + "&level=" + level);
                        }
                        this.send("group/get_volume", "gid=" + gid);
                        break block33;
                    }
                    if (command.equals("mute")) {
                        if (value.equalsIgnoreCase("flip")) {
                            this.sendAndWaitResponse("group/toggle_mute", "gid=" + gid);
                        } else {
                            String state = value.equals("1") ? "on" : "off";
                            this.sendAndWaitResponse("group/set_mute", "gid=" + gid + "&state=" + state);
                        }
                        this.send("group/get_mute", "gid=" + gid);
                        break block33;
                    }
                    throw new Exception("unknown command");
                }
                int dotIdx = name.indexOf(46);
                String pName = name.substring(0, dotIdx);
                String pid = this.namePidMap.get(pName);
                String command = name.substring(dotIdx + 1);
                if (command.equals("state")) {
                    String state = value.toLowerCase();
                    this.sendAndWaitResponse("player/set_play_state", "pid=" + pid + "&state=" + state);
                    break block33;
                }
                if (command.equals("volume")) {
                    String level = value.replace("%", "");
                    if (level.startsWith("+")) {
                        level = level.substring(1);
                        this.sendAndWaitResponse("player/volume_up", "pid=" + pid + "&step=" + level);
                    } else if (level.startsWith("-")) {
                        level = level.substring(1);
                        this.sendAndWaitResponse("player/volume_down", "pid=" + pid + "&step=" + level);
                    } else {
                        this.sendAndWaitResponse("player/set_volume", "pid=" + pid + "&level=" + level);
                    }
                    this.send("player/get_volume", "pid=" + pid);
                    break block33;
                }
                if (command.equals("mute")) {
                    if (value.equalsIgnoreCase("flip")) {
                        this.sendAndWaitResponse("player/toggle_mute", "pid=" + pid);
                    } else {
                        String state = value.equals("1") ? "on" : "off";
                        this.sendAndWaitResponse("player/set_mute", "pid=" + pid + "&state=" + state);
                    }
                    this.send("player/get_mute", "pid=" + pid);
                    break block33;
                }
                if (command.equals("repeat")) {
                    String repeat = value.toLowerCase();
                    this.sendAndWaitResponse("player/set_play_mode", "pid=" + pid + "&repeat=" + repeat);
                    break block33;
                }
                if (command.equals("shuffle")) {
                    String shuffle = value.toLowerCase();
                    this.sendAndWaitResponse("player/set_play_mode", "pid=" + pid + "&shuffle=" + shuffle);
                    break block33;
                }
                if (command.equals("qid")) {
                    this.sendAndWaitResponse("player/play_queue", "pid=" + pid + "&qid=" + value);
                    break block33;
                }
                if (command.equals("qid.remove")) {
                    if (value.equals("all")) {
                        this.sendAndWaitResponse("player/clear_queue", "pid=" + pid);
                    } else {
                        this.sendAndWaitResponse("player/remove_from_queue", "pid=" + pid + "&qid=" + value);
                    }
                    break block33;
                }
                if (command.equals("next")) {
                    this.sendAndWaitResponse("player/play_next", "pid=" + pid);
                    break block33;
                }
                if (command.equals("previous")) {
                    this.sendAndWaitResponse("player/play_previous", "pid=" + pid);
                    break block33;
                }
                if (command.equals("play.url")) {
                    this.sendAndWaitResponse("browse/play_stream", "pid=" + pid + "&url=" + value);
                    break block33;
                }
                if (command.equals("play.station")) {
                    this.sendAndWaitResponse("browse/play_stream", "pid=" + pid + "&" + value);
                    break block33;
                }
                if (command.equals("play.song")) {
                    this.sendAndWaitResponse("browse/add_to_queue", "pid=" + pid + "&" + value + "&aid=1");
                    break block33;
                }
                throw new Exception("unknown command");
            }
            catch (Exception e2) {
                this.errorLog("Error executing command: " + e2.getLocalizedMessage());
            }
        }
    }

    @Override
    public void ioWrite(String name, String value) {
        if (this.genEvent) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    @Override
    public void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    @Override
    public void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    public void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

