/*
 * Decompiled with CFR 0.152.
 */
package drivers.esser;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import drivers.esser.Point;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 502;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULTLOGSIZE = 500;
    private String host = null;
    private int unitid = 1;
    private boolean gui = true;
    private boolean startupevent = true;
    private String csvseparatorTmp = "";
    private String csvseparator = ";";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private String name = null;
    private int online = -1;
    private int pollingtime = 2000;
    private TreeMap<Integer, Point> pointsList = new TreeMap();
    private TreeMap<String, String> dpsList = new TreeMap();
    private int pointsNumber = 0;
    private int startingAddress = 0;
    private int loopErrorCounter = 0;
    private int loopErrorThreshold = 5;
    private int loopErrors = 0;
    boolean atLeastOneZoneInAlarm = false;
    boolean atLeastOneZoneInPrealarm = false;
    boolean atLeastOneZoneInTrouble = false;

    public boolean init(String name, HashMap<String, String> config) {
        block26: {
            super.init(name);
            this.name = name;
            try {
                this.host = String.valueOf(config.get("host")) + ":" + config.get("port");
            }
            catch (Exception e2) {
                this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            String s = config.get("unitid");
            if (s != null) {
                try {
                    this.unitid = Integer.parseInt(s);
                }
                catch (NumberFormatException e3) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - unitid ignored");
                }
            }
            if ((s = config.get("gui")) != null) {
                try {
                    this.gui = Boolean.parseBoolean(s);
                }
                catch (Exception e4) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - gui ignored");
                }
            }
            if ((s = config.get("startupevents")) != null) {
                try {
                    this.startupevent = Boolean.parseBoolean(s);
                }
                catch (Exception e5) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - startupevents ignored");
                }
            }
            if ((s = config.get("pollingtime")) != null) {
                try {
                    this.pollingtime = Integer.parseInt(s);
                    if (this.pollingtime < 1000) {
                        this.pollingtime = 1000;
                    }
                }
                catch (Exception e6) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - pollingtime ignored");
                }
            }
            if ((s = config.get("csvseparatorTmp")) != null) {
                try {
                    this.csvseparatorTmp = s;
                    if (this.csvseparatorTmp.equals("comma")) {
                        this.csvseparator = ",";
                    } else if (this.csvseparatorTmp.equals("semicolon")) {
                        this.csvseparator = ";";
                    }
                }
                catch (NumberFormatException e7) {
                    this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - csvseparator ignored");
                }
            }
            try {
                if (!this.readCsv()) break block26;
                this.printLengthTreeMap();
                return true;
            }
            catch (IOException e8) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(name) + ": error in init - " + e8);
                }
                return false;
            }
        }
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(name) + ": error while loading configuration file");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readCsv() throws IOException {
        BufferedReader csvReader = new BufferedReader(new FileReader("esser/" + this.name + ".csv"));
        try {
            while (true) {
                String row;
                if ((row = csvReader.readLine()) == null) {
                    csvReader.close();
                    return true;
                }
                String[] data = row.split(this.csvseparator);
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": row = " + row);
                }
                if (Driver.isNumeric(data[0])) {
                    try {
                        Point p = new Point(data[1], data[2], data[3], data[4].toLowerCase(), data[5], data[6], "");
                        this.pointsList.put(Integer.parseInt(data[0]), p);
                        if (this.startupevent) {
                            this.ioWrite(String.valueOf(data[0]) + ".edp.type", p.getEdpType());
                            this.ioWrite(String.valueOf(data[0]) + ".desc", p.getSignal());
                        } else {
                            this.ioWriteNoEvents(String.valueOf(data[0]) + ".edp.type", p.getEdpType());
                            this.ioWriteNoEvents(String.valueOf(data[0]) + ".desc", p.getSignal());
                        }
                        if (this.gui) {
                            this.uiSet(String.valueOf(data[0]) + ".desc", "value", p.getSignal());
                        }
                        if (p.getEdpType().equalsIgnoreCase("5-d")) {
                            p.setZonePos("detector.p" + p.getPanel() + ".z" + p.getZoneCtrlLoop() + ".d" + p.getDetector());
                            this.dpsList.put(p.getZonePos(), p.getAddress());
                            if (p.getZonePos().length() <= 0) continue;
                            if (this.startupevent) {
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".desc", p.getSignal());
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".addr", p.getAddress());
                            } else {
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".desc", p.getSignal());
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".addr", p.getAddress());
                            }
                            if (!this.gui) continue;
                            this.uiSet(String.valueOf(p.getZoneCtrlLoop()) + ".d" + p.getDetector() + ".desc", "value", p.getSignal());
                            continue;
                        }
                        if (p.getEdpType().equalsIgnoreCase("3-c")) {
                            p.setZonePos("module.p" + p.getPanel() + "." + p.getZoneCtrlLoop());
                            this.dpsList.put(p.getZonePos(), p.getAddress());
                            if (p.getZonePos().length() <= 0) continue;
                            if (this.startupevent) {
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".desc", p.getSignal());
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".addr", p.getAddress());
                            } else {
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".desc", p.getSignal());
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".addr", p.getAddress());
                            }
                            if (!this.gui) continue;
                            this.uiSet(String.valueOf(p.getZoneCtrlLoop()) + ".desc", "value", p.getSignal());
                            continue;
                        }
                        if (p.getEdpType().equalsIgnoreCase("4-z")) {
                            this.dpsList.put("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop(), p.getAddress());
                            if (this.startupevent) {
                                this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".desc", p.getSignal());
                                this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".addr", p.getAddress());
                            } else {
                                this.ioWriteNoEvents("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".desc", p.getSignal());
                                this.ioWriteNoEvents("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".addr", p.getAddress());
                            }
                            if (!this.gui) continue;
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".desc", "value", p.getSignal());
                            continue;
                        }
                        if (!p.getEdpType().equalsIgnoreCase("2-l")) continue;
                        this.dpsList.put("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop(), p.getAddress());
                        if (this.startupevent) {
                            this.ioWrite("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".desc", p.getSignal());
                            this.ioWrite("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".addr", p.getAddress());
                        } else {
                            this.ioWriteNoEvents("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".desc", p.getSignal());
                            this.ioWriteNoEvents("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".addr", p.getAddress());
                        }
                        if (!this.gui) continue;
                        this.uiSet("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".desc", "value", p.getSignal());
                    }
                    catch (Exception e2) {
                        if (!this.isVerboseLog()) continue;
                        this.messageLog(String.valueOf(this.name) + ": parsing problem in row = " + row);
                    }
                    continue;
                }
                if (!this.isVerboseLog()) continue;
                this.messageLog(String.valueOf(this.name) + ": parsing problem in row = " + row + " | index is not a number");
            }
        }
        catch (Exception e3) {
            csvReader.close();
            return false;
        }
    }

    public boolean loop() {
        this.atLeastOneZoneInAlarm = false;
        this.atLeastOneZoneInPrealarm = false;
        this.atLeastOneZoneInTrouble = false;
        int i2 = 1;
        while (i2 <= this.pointsNumber) {
            if (i2 <= this.pointsNumber - 100) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": loop, read 100 registers starting from register: " + i2);
                }
                byte[] response = userBase.modbusReadHoldingRegisters(this.host, this.unitid, i2 - 1, 100);
                this.readPointsStatus(response, i2);
                i2 += 99;
            } else {
                int remaining = this.pointsNumber - i2 + 1;
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": loop, last read " + remaining + " registers starting from register: " + i2);
                }
                byte[] response = userBase.modbusReadHoldingRegisters(this.host, this.unitid, i2 - 1, remaining);
                this.readPointsStatus(response, i2);
                break;
            }
            ++i2;
        }
        if (this.loopErrorCounter == 0) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": loop,  end of loop ok ");
            }
            this.loopErrors = 0;
            if (this.online <= 0) {
                this.online = 1;
                this.ioWrite("connection", "online");
                if (this.gui) {
                    this.uiSet("connection.label.online", "visible", "true");
                    this.uiSet("connection.label.offline", "visible", "false");
                }
            }
            if (this.atLeastOneZoneInAlarm) {
                if (this.startupevent) {
                    this.ioWrite("global.alarm", "1");
                } else {
                    this.ioWriteNoEvents("global.alarm", "1");
                }
            } else if (this.startupevent) {
                this.ioWrite("global.alarm", "0");
            } else {
                this.ioWriteNoEvents("global.alarm", "0");
            }
            if (this.atLeastOneZoneInPrealarm) {
                if (this.startupevent) {
                    this.ioWrite("global.prealarm", "1");
                } else {
                    this.ioWriteNoEvents("global.prealarm", "1");
                }
            } else if (this.startupevent) {
                this.ioWrite("global.prealarm", "0");
            } else {
                this.ioWriteNoEvents("global.prealarm", "0");
            }
            if (this.atLeastOneZoneInTrouble) {
                if (this.startupevent) {
                    this.ioWrite("global.trouble", "1");
                } else {
                    this.ioWriteNoEvents("global.trouble", "1");
                }
            } else if (this.startupevent) {
                this.ioWrite("global.trouble", "0");
            } else {
                this.ioWriteNoEvents("global.trouble", "0");
            }
        } else {
            ++this.loopErrors;
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": number of loops with error " + this.loopErrors);
            }
            if (this.loopErrors >= this.loopErrorThreshold && this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": too many read errors, quit driver ");
            }
            return false;
        }
        this.loopErrorCounter = 0;
        this.sleep(this.pollingtime);
        return true;
    }

    private void readPointsStatus(byte[] response, int i2) {
        if (response != null) {
            String responseHex2 = Driver.bytesToHex(response);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  loop, modbus response: " + responseHex2 + " | length: " + responseHex2.length());
            }
            if (responseHex2.startsWith("03")) {
                int cAdd = i2;
                int j2 = 2;
                while (j2 < response.length) {
                    boolean bit6;
                    Point p = this.pointsList.get(cAdd);
                    byte myByteL = response[j2 + 1];
                    int val = myByteL;
                    if (this.isVerboseLog() && val > 0) {
                        this.messageLog(String.valueOf(this.name) + ":  loop, current address: " + cAdd + " | value: " + val + " | name: " + p.getSignal() + " | type: " + p.getEdpType());
                    }
                    if (this.startupevent) {
                        this.ioWrite(String.valueOf(cAdd) + ".value", String.valueOf(val));
                    } else {
                        this.ioWriteNoEvents(String.valueOf(cAdd) + ".value", String.valueOf(val));
                    }
                    boolean bit0 = (myByteL & 1) != 0;
                    boolean bit1 = (myByteL & 2) != 0;
                    boolean bit2 = (myByteL & 4) != 0;
                    boolean bit3 = (myByteL & 8) != 0;
                    boolean bit4 = (myByteL & 0x10) != 0;
                    boolean bit5 = (myByteL & 0x20) != 0;
                    boolean bl = bit6 = (myByteL & 0x40) != 0;
                    if (p.getEdpType().equalsIgnoreCase("5-d")) {
                        if (this.startupevent) {
                            this.ioWrite(String.valueOf(p.getZonePos()) + ".alarm", bit0 ? "1" : "0");
                            this.ioWrite(String.valueOf(p.getZonePos()) + ".prealarm", bit1 ? "1" : "0");
                            this.ioWrite(String.valueOf(p.getZonePos()) + ".trouble", bit2 ? "1" : "0");
                            this.ioWrite(String.valueOf(p.getZonePos()) + ".disconnect", bit3 ? "1" : "0");
                            this.ioWrite(String.valueOf(p.getZonePos()) + ".test", bit4 ? "1" : "0");
                            this.ioWrite(String.valueOf(p.getZonePos()) + ".tal", bit5 ? "1" : "0");
                            this.ioWrite(String.valueOf(p.getZonePos()) + ".active", bit6 ? "1" : "0");
                        } else {
                            this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".alarm", bit0 ? "1" : "0");
                            this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".prealarm", bit1 ? "1" : "0");
                            this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".trouble", bit2 ? "1" : "0");
                            this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".disconnect", bit3 ? "1" : "0");
                            this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".test", bit4 ? "1" : "0");
                            this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".tal", bit5 ? "1" : "0");
                            this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".active", bit6 ? "1" : "0");
                        }
                        if (this.gui) {
                            this.uiSet(String.valueOf(p.getZonePos()) + ".alarm", "visible", bit0 ? "true" : "false");
                            this.uiSet(String.valueOf(p.getZonePos()) + ".prealarm", "visible", bit1 ? "true" : "false");
                            this.uiSet(String.valueOf(p.getZonePos()) + ".trouble", "visible", bit2 ? "true" : "false");
                            this.uiSet(String.valueOf(p.getZonePos()) + ".disconnect", "visible", bit3 ? "true" : "false");
                            this.uiSet(String.valueOf(p.getZonePos()) + ".test", "visible", bit4 ? "true" : "false");
                            this.uiSet(String.valueOf(p.getZonePos()) + ".tal", "visible", bit5 ? "true" : "false");
                            this.uiSet(String.valueOf(p.getZonePos()) + ".active", "visible", bit6 ? "true" : "false");
                        }
                    } else if (p.getEdpType().equalsIgnoreCase("2-l")) {
                        if (this.startupevent) {
                            this.ioWrite("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".alarm", bit0 ? "1" : "0");
                            this.ioWrite("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".trouble", bit2 ? "1" : "0");
                            this.ioWrite("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".disconnect", bit3 ? "1" : "0");
                        } else {
                            this.ioWriteNoEvents("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".alarm", bit0 ? "1" : "0");
                            this.ioWriteNoEvents("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".trouble", bit2 ? "1" : "0");
                            this.ioWriteNoEvents("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".disconnect", bit3 ? "1" : "0");
                        }
                        if (this.gui) {
                            this.uiSet("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".alarm", "visible", bit0 ? "true" : "false");
                            this.uiSet("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".trouble", "visible", bit2 ? "true" : "false");
                            this.uiSet("loop.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + "disconnect", "visible", bit3 ? "true" : "false");
                        }
                    } else if (p.getEdpType().equalsIgnoreCase("3-c")) {
                        if (p.getZonePos().length() > 0) {
                            if (this.startupevent) {
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".trouble", bit2 ? "1" : "0");
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".disconnect", bit3 ? "1" : "0");
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".test", bit4 ? "1" : "0");
                                this.ioWrite(String.valueOf(p.getZonePos()) + ".active", bit6 ? "1" : "0");
                            } else {
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".trouble", bit2 ? "1" : "0");
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".disconnect", bit3 ? "1" : "0");
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".test", bit4 ? "1" : "0");
                                this.ioWriteNoEvents(String.valueOf(p.getZonePos()) + ".active", bit6 ? "1" : "0");
                            }
                            if (this.gui) {
                                this.uiSet(String.valueOf(p.getZonePos()) + ".trouble", "visible", bit2 ? "true" : "false");
                                this.uiSet(String.valueOf(p.getZonePos()) + ".disconnect", "visible", bit3 ? "true" : "false");
                                this.uiSet(String.valueOf(p.getZonePos()) + ".test", "visible", bit4 ? "true" : "false");
                                this.uiSet(String.valueOf(p.getZonePos()) + ".active", "visible", bit6 ? "true" : "false");
                            }
                        }
                    } else if (p.getEdpType().equalsIgnoreCase("4-z")) {
                        if (bit0) {
                            this.atLeastOneZoneInAlarm = true;
                        }
                        if (bit1) {
                            this.atLeastOneZoneInPrealarm = true;
                        }
                        if (bit2) {
                            this.atLeastOneZoneInTrouble = true;
                        }
                        if (this.startupevent) {
                            this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".alarm", bit0 ? "1" : "0");
                            this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".prealarm", bit1 ? "1" : "0");
                            this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".trouble", bit2 ? "1" : "0");
                            this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".disconnect", bit3 ? "1" : "0");
                            this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".test", bit4 ? "1" : "0");
                            this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".tal", bit5 ? "1" : "0");
                            this.ioWrite("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".active", bit6 ? "1" : "0");
                        } else {
                            this.ioWriteNoEvents("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".alarm", bit0 ? "1" : "0");
                            this.ioWriteNoEvents("zone.p" + p.getPanel() + p.getZoneCtrlLoop() + ".prealarm", bit1 ? "1" : "0");
                            this.ioWriteNoEvents("zone.p" + p.getPanel() + ".z" + p.getZoneCtrlLoop() + ".trouble", bit2 ? "1" : "0");
                            this.ioWriteNoEvents("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".disconnect", bit3 ? "1" : "0");
                            this.ioWriteNoEvents("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".test", bit4 ? "1" : "0");
                            this.ioWriteNoEvents("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".tal", bit5 ? "1" : "0");
                            this.ioWriteNoEvents("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".active", bit6 ? "1" : "0");
                        }
                        if (this.gui) {
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".alarm", "visible", bit0 ? "true" : "false");
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".prealarm", "visible", bit1 ? "true" : "false");
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".trouble", "visible", bit2 ? "true" : "false");
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".disconnect", "visible", bit3 ? "true" : "false");
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".test", "visible", bit4 ? "true" : "false");
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".tal", "visible", bit5 ? "true" : "false");
                            this.uiSet("zone.p" + p.getPanel() + "." + p.getZoneCtrlLoop() + ".active", "visible", bit6 ? "true" : "false");
                        }
                    }
                    ++cAdd;
                    ++j2;
                    ++j2;
                }
            } else {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": loop, response error code: " + responseHex2);
                }
                ++this.loopErrorCounter;
            }
        } else {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ":  loop, no MODBUS TCP response");
            }
            ++this.loopErrorCounter;
        }
    }

    public boolean end() {
        if (this.online != 0) {
            this.online = 0;
            this.ioWrite("connection", "offline");
            if (this.gui) {
                this.uiSet("connection.label.offline", "visible", "true");
                this.uiSet("connection.label.online", "visible", "false");
            }
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        if (name.contains("detector") || name.contains("module")) {
            String addr = this.dpsList.get(name);
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " command | dp: " + name + ", address: " + addr + ", set value: " + value);
            }
            int valueInt = Integer.valueOf(value);
            switch (valueInt) {
                case 0: {
                    byte[] cmd = new byte[2];
                    userBase.modbusWriteSingleRegister(this.host, this.unitid, Integer.parseInt(addr), cmd);
                    break;
                }
                case 1: {
                    byte[] byArray = new byte[2];
                    byArray[1] = 1;
                    byte[] cmd2 = byArray;
                    userBase.modbusWriteMultipleRegisters(this.host, this.unitid, Integer.parseInt(addr), cmd2);
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[2];
                    byArray[1] = 2;
                    byte[] cmd3 = byArray;
                    userBase.modbusWriteMultipleRegisters(this.host, this.unitid, Integer.parseInt(addr), cmd3);
                    break;
                }
                case 3: {
                    byte[] byArray = new byte[2];
                    byArray[1] = 3;
                    byte[] cmd4 = byArray;
                    userBase.modbusWriteMultipleRegisters(this.host, this.unitid, Integer.parseInt(addr), cmd4);
                    break;
                }
            }
        } else if (name.contains("addr")) {
            String[] spl = name.split("\\.");
            int val = Integer.parseInt(value);
            int addr = Integer.parseInt(spl[1]);
            if (val < 255 && addr <= this.pointsNumber) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + " command | address: " + addr + " | modbus register: " + (addr - 1) + ", set value: " + val);
                }
                byte[] byArray = new byte[2];
                byArray[1] = (byte)val;
                byte[] cmd = byArray;
                userBase.modbusWriteSingleRegister(this.host, this.unitid, addr - 1, cmd);
            }
        }
    }

    private void printLengthTreeMap() {
        boolean first = true;
        for (Map.Entry<Integer, Point> entry : this.pointsList.entrySet()) {
            ++this.pointsNumber;
            if (!first) continue;
            Integer register = entry.getKey();
            this.startingAddress = register;
            first = false;
        }
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(this.name) + ": number of registers: " + this.pointsNumber + " | starting address: " + this.startingAddress);
        }
    }

    public static String removeLastChars(String str, int chars) {
        return str.substring(0, str.length() - chars);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        return new String(hexChars);
    }

    public static String hexToAscii(String hex) {
        StringBuilder output = new StringBuilder();
        int i2 = 0;
        while (i2 < hex.length()) {
            String str = hex.substring(i2, i2 + 2);
            output.append((char)Integer.parseInt(str, 16));
            i2 += 2;
        }
        return output.toString();
    }

    public static int hex2decimal(String s) {
        String digits = "0123456789ABCDEF";
        s = s.toUpperCase();
        int val = 0;
        int i2 = 0;
        while (i2 < s.length()) {
            char c2 = s.charAt(i2);
            int d2 = digits.indexOf(c2);
            val = 16 * val + d2;
            ++i2;
        }
        return val;
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }
}

