/*
 * Decompiled with CFR 0.152.
 */
package drivers.duelux;

import com.hsyco.driverBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    public static final String[] WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage", "dimmer"};
    private static final String[] INPUT_TYPE_NAME;
    private static final int POLL_INTERVAL_MILLIS = 100;
    private static final int SETPOINT_DELAY_FADE_LOOP_INTERVAL_MILLIS = 10000;
    private static final int LAMP_ON_TIME_LOOP_INTERVAL_MILLIS = 60000;
    private static final int FAULT_STATE_LOOP_INTERVAL_MILLIS = 4000;
    private String name = null;
    private InetSocketAddress address = null;
    private Socket socket = null;
    private BufferedInputStream bin;
    private BufferedOutputStream bout;
    private boolean online = false;
    private boolean initialized = false;
    private boolean startupEvents = false;
    private boolean pollAreasSetpointAndDelayConfiguration = false;
    private boolean groupSystemtopoDiscovery = true;
    private boolean outputSystemtopoDiscovery = true;
    private boolean detectEvents = false;
    private boolean toolsProxy = false;
    private boolean readCommDump = false;
    private boolean writeCommDump = false;
    private long loopTimemillis = 0L;
    private long lampOnTimeLoopTimemillis = 0L;
    private long setpointDelayFadeLoopTimemillis = 0L;
    private long faultStateLoopTimemillis = 0L;
    private byte[][] inputType = new byte[64][9];
    private boolean[] lampsOnField = new boolean[64];
    private byte[] aiState = new byte[128];
    private byte[] diState = new byte[128];
    private byte[] cState = new byte[128];
    private byte[] oState = new byte[128];
    private byte[] gState = new byte[128];
    private byte[] gStop = new byte[2];
    private byte[] toState = new byte[256];
    private byte[] setpointState = new byte[256];
    private byte[] delayState = new byte[256];
    private byte[] autoState = new byte[16];
    private byte[] broadcastState = new byte[2];
    private byte[] fadeState = new byte[34];
    private byte[] iFault = new byte[128];
    private byte[] oFault = new byte[128];
    private Integer[] gValue = new Integer[64];
    private Integer[] oValue = new Integer[64];
    private Integer broadcastValue = null;

    static {
        String[] stringArray = new String[5];
        stringArray[1] = "push-button";
        stringArray[2] = "switch";
        stringArray[3] = "occupancy sensor";
        stringArray[4] = "light sensor";
        INPUT_TYPE_NAME = stringArray;
    }

    public boolean init(String name, HashMap<String, String> config) {
        block27: {
            super.init(name);
            this.name = name;
            int i2 = 0;
            while (i2 < this.aiState.length) {
                this.aiState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.diState.length) {
                this.diState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.cState.length) {
                this.cState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.oState.length) {
                this.oState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gState.length) {
                this.gState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gStop.length) {
                this.gStop[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.toState.length) {
                this.toState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.setpointState.length) {
                this.setpointState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.delayState.length) {
                this.delayState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.autoState.length) {
                this.autoState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.broadcastState.length) {
                this.broadcastState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.fadeState.length) {
                this.fadeState[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.iFault.length) {
                this.iFault[i2] = -1;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.oFault.length) {
                this.oFault[i2] = -1;
                ++i2;
            }
            String s = config.get("startupevents");
            if (s != null) {
                this.startupEvents = Boolean.parseBoolean(s);
            }
            if ((s = config.get("detectevents")) != null) {
                this.detectEvents = Boolean.parseBoolean(s);
            }
            if ((s = config.get("areasconfiguration")) != null) {
                this.pollAreasSetpointAndDelayConfiguration = Boolean.parseBoolean(s);
            }
            if ((s = config.get("groupdiscovery")) != null) {
                this.groupSystemtopoDiscovery = Boolean.parseBoolean(s);
            }
            if ((s = config.get("outputdiscovery")) != null) {
                this.outputSystemtopoDiscovery = Boolean.parseBoolean(s);
            }
            if ((s = config.get("toolsproxy")) != null && Boolean.parseBoolean(s)) {
                this.toolsProxy = true;
                this.registerDueluxHook(name, this, true);
            }
            if ((s = config.get("toolspassword")) != null) {
                this.registerDueluxFxpXtHook(String.valueOf(name) + ":" + s, this);
            }
            this.address = new InetSocketAddress(config.get("host"), Integer.parseInt(config.get("port")));
            if (this.readCommBytes(0) == null) break block27;
            if (new File("logs", String.valueOf(name) + ".readcomm.log").canWrite()) {
                this.readCommDump = true;
            }
            if (new File("logs", String.valueOf(name) + ".writecomm.log").canWrite()) {
                this.writeCommDump = true;
            }
            if (this.groupSystemtopoDiscovery || this.outputSystemtopoDiscovery) {
                this.enableSystemtopoDiscovery();
            }
            if (!this.inputDiscovery() || !this.outputDiscovery() || !this.loop()) break block27;
            this.online = true;
            this.ioWrite("connection", "online");
            return true;
        }
        try {
            this.online = false;
            this.ioWrite("connection", "offline");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean loop() {
        long now = System.currentTimeMillis();
        long sleepTime = this.loopTimemillis + 100L - now;
        if (sleepTime > 0L) {
            this.sleep(sleepTime);
            this.loopTimemillis += 100L;
        } else {
            this.loopTimemillis = now;
        }
        try {
            int idx;
            int i2;
            byte[] broadcast;
            int v;
            int j2;
            int i3;
            byte[] di = this.readRAM(8192, 128);
            int i4 = 0;
            while (i4 < 64) {
                int idx2 = i4 * 2 + 1;
                if (di[idx2] != this.diState[idx2]) {
                    this.diState[idx2] = di[idx2];
                    int j3 = 0;
                    while (j3 < 8) {
                        switch (this.inputType[i4][j3]) {
                            case 1: 
                            case 2: {
                                this.ioWrite("di" + (i4 + 1) + "." + (j3 + 1), (di[idx2] & 1 << j3) != 0 ? "1" : "0");
                                break;
                            }
                            case 3: {
                                this.ioWrite("di" + (i4 + 1) + ".1", (di[idx2] & 1) != 0 ? "1" : "0");
                            }
                        }
                        ++j3;
                    }
                }
                ++i4;
            }
            byte[] ai = this.readRAM(8320, 128);
            int i5 = 0;
            while (i5 < 64) {
                int idx3 = i5 * 2;
                if (ai[idx3] != this.aiState[idx3] || ai[idx3 + 1] != this.aiState[idx3 + 1]) {
                    this.aiState[idx3] = ai[idx3];
                    this.aiState[idx3 + 1] = ai[idx3 + 1];
                    switch (this.inputType[i5][0]) {
                        case 4: {
                            this.ioWrite("ai" + (i5 + 1) + ".1", Integer.toString(256 * (ai[idx3] & 0xFF) + (ai[idx3 + 1] & 0xFF)));
                        }
                    }
                }
                ++i5;
            }
            byte[] c2 = this.readRAM(8448, 128);
            int i6 = 0;
            while (i6 < 64) {
                int idx4 = i6 * 2 + 1;
                if (c2[idx4] != this.cState[idx4]) {
                    this.cState[idx4] = c2[idx4];
                    this.ioWrite("c" + (i6 + 1), (c2[idx4] & 1) != 0 ? "1" : "0");
                }
                ++i6;
            }
            byte[] ao = this.readRAM(8704, 128);
            int i7 = 0;
            while (i7 < 64) {
                int idx5;
                if (this.lampsOnField[i7] && (ao[idx5 = i7 * 2] != this.oState[idx5] || ao[idx5 + 1] != this.oState[idx5 + 1])) {
                    this.oState[idx5] = ao[idx5];
                    this.oState[idx5 + 1] = ao[idx5 + 1];
                    int v2 = ao[idx5 + 1] & 0xFF;
                    if (v2 > 0) {
                        this.oValue[i7] = v2;
                        this.ioWrite("o" + (i7 + 1), String.valueOf(v2) + "%");
                        if (this.outputSystemtopoDiscovery) {
                            this.deviceSet(11, "o" + (i7 + 1), String.valueOf(v2) + "%", this.initialized ? null : "O" + (i7 + 1));
                        }
                    } else {
                        this.ioWrite("o" + (i7 + 1), "off");
                        if (this.outputSystemtopoDiscovery) {
                            this.deviceSet(11, "o" + (i7 + 1), "off", this.initialized ? null : "O" + (i7 + 1));
                        }
                    }
                }
                ++i7;
            }
            if (now > this.faultStateLoopTimemillis + 4000L) {
                this.faultStateLoopTimemillis = now;
                byte[] aos = this.readRAM(10304, 64);
                i3 = 0;
                while (i3 < 64) {
                    if (this.lampsOnField[i3] && aos[i3] != this.oFault[i3]) {
                        this.oFault[i3] = aos[i3];
                        boolean lf = (aos[i3] & 2) > 0;
                        boolean cgf = (aos[i3] & 1) > 0;
                        this.ioWrite("o" + (i3 + 1) + ".lf", lf ? "1" : "0");
                        this.ioWrite("o" + (i3 + 1) + ".cgf", cgf ? "1" : "0");
                    }
                    ++i3;
                }
                byte[] ais = this.readRAM(10240, 64);
                int i8 = 0;
                while (i8 < 64) {
                    boolean analog = false;
                    boolean digital = false;
                    j2 = 0;
                    while (j2 < 9) {
                        switch (this.inputType[i8][j2]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                digital = true;
                                break;
                            }
                            case 4: {
                                analog = true;
                            }
                        }
                        ++j2;
                    }
                    if (analog || digital) {
                        boolean ide;
                        if (ais[i8] != this.iFault[i8]) {
                            this.iFault[i8] = ais[i8];
                        }
                        if (analog) {
                            ide = (ais[i8] & 1) > 0;
                            this.ioWrite("ai" + (i8 + 1) + ".ide", ide ? "1" : "0");
                        }
                        if (digital) {
                            ide = (ais[i8] & 1) > 0;
                            this.ioWrite("di" + (i8 + 1) + ".ide", ide ? "1" : "0");
                        }
                    }
                    ++i8;
                }
            }
            byte[] g2 = this.readRAM(8832, 32);
            i3 = 0;
            while (i3 < 16) {
                int idx6 = i3 * 2;
                if (g2[idx6] != this.gState[idx6] || g2[idx6 + 1] != this.gState[idx6 + 1]) {
                    this.gState[idx6] = g2[idx6];
                    this.gState[idx6 + 1] = g2[idx6 + 1];
                    v = g2[idx6 + 1] & 0xFF;
                    if (v > 0) {
                        this.gValue[i3] = v;
                        this.ioWrite("g" + (i3 + 1), String.valueOf(v) + "%");
                        if (this.groupSystemtopoDiscovery) {
                            this.deviceSet(11, "g" + (i3 + 1), String.valueOf(v) + "%", this.initialized ? null : "G" + (i3 + 1));
                        }
                    } else {
                        this.ioWrite("g" + (i3 + 1), "off");
                        if (this.groupSystemtopoDiscovery) {
                            this.deviceSet(11, "g" + (i3 + 1), "off", this.initialized ? null : "G" + (i3 + 1));
                        }
                    }
                }
                ++i3;
            }
            byte[] gs = this.readRAM(8866, 2);
            if (gs != null && gs.length == 2 && (gs[0] != this.gStop[0] || gs[1] != this.gStop[1])) {
                this.gStop[0] = gs[0];
                this.gStop[1] = gs[1];
                BitSet b2 = BitSet.valueOf(gs);
                int i9 = 1;
                while (i9 <= 8) {
                    this.ioWrite("g" + i9 + ".lock", b2.get(i9 + 7) ? "1" : "0");
                    ++i9;
                }
                i9 = 9;
                while (i9 <= 16) {
                    this.ioWrite("g" + i9 + ".lock", b2.get(i9 - 9) ? "1" : "0");
                    ++i9;
                }
            }
            if ((broadcast = this.readRAM(8896, 4))[0] != this.broadcastState[0] || broadcast[1] != this.broadcastState[1]) {
                this.broadcastState[0] = broadcast[0];
                this.broadcastState[1] = broadcast[1];
                v = this.broadcastState[1] & 0xFF;
                if (v > 0) {
                    this.broadcastValue = v;
                    this.ioWrite("broadcast", String.valueOf(v) + "%");
                    if (this.outputSystemtopoDiscovery) {
                        this.deviceSet(11, "broadcast", String.valueOf(v) + "%", this.initialized ? null : "BROADCAST");
                    }
                } else {
                    this.ioWrite("broadcast", "off");
                    if (this.groupSystemtopoDiscovery) {
                        this.deviceSet(11, "broadcast", "off", this.initialized ? null : "BROADCAST");
                    }
                }
            }
            if (broadcast[2] != this.fadeState[0] || broadcast[3] != this.fadeState[1]) {
                this.fadeState[0] = broadcast[2];
                this.fadeState[1] = broadcast[3];
                this.ioWrite("broadcast.fadetime", Integer.toString(((broadcast[2] & 0xFF) << 8) + (broadcast[3] & 0xFF)));
            }
            byte[] auto = this.readRAM(12112, 16);
            int i10 = 0;
            while (i10 < 16) {
                if (auto[i10] != this.autoState[i10]) {
                    this.autoState[i10] = auto[i10];
                    j2 = 0;
                    while (j2 < 8) {
                        this.ioWrite("a" + (i10 + 1) + ".s" + (j2 + 1) + ".auto", (auto[i10] & 1 << j2) != 0 ? "1" : "0");
                        ++j2;
                    }
                }
                ++i10;
            }
            if (now > this.lampOnTimeLoopTimemillis + 60000L) {
                this.lampOnTimeLoopTimemillis = now;
                byte[] to = this.readRAM(11776, 256);
                i2 = 0;
                while (i2 < 64) {
                    if (this.lampsOnField[i2] && (to[idx = i2 * 4] != this.toState[idx] || to[idx + 1] != this.toState[idx + 1] || to[idx + 2] != this.toState[idx + 2] || to[idx + 3] != this.toState[idx + 3])) {
                        this.toState[idx] = to[idx];
                        this.toState[idx + 1] = to[idx + 1];
                        this.toState[idx + 2] = to[idx + 2];
                        this.toState[idx + 3] = to[idx + 3];
                        this.ioWrite("o" + (i2 + 1) + ".time", Integer.toString(((to[idx] & 0xFF) << 24) + ((to[idx + 1] & 0xFF) << 16) + ((to[idx + 2] & 0xFF) << 8) + (to[idx + 3] & 0xFF)));
                    }
                    ++i2;
                }
            }
            if (now > this.setpointDelayFadeLoopTimemillis + 10000L) {
                this.setpointDelayFadeLoopTimemillis = now;
                byte[] fade = this.readRAM(8912, 32);
                i2 = 0;
                while (i2 < 16) {
                    idx = i2 * 2;
                    if (fade[idx] != this.fadeState[idx + 2] || fade[idx + 1] != this.fadeState[idx + 3]) {
                        this.fadeState[idx + 2] = fade[idx];
                        this.fadeState[idx + 3] = fade[idx + 1];
                        this.ioWrite("g" + (i2 + 1) + ".fadetime", Integer.toString(((fade[idx] & 0xFF) << 8) + (fade[idx + 1] & 0xFF)));
                    }
                    ++i2;
                }
                if (this.pollAreasSetpointAndDelayConfiguration) {
                    byte[] sp = this.readRAM(81408, 256);
                    int i11 = 0;
                    while (i11 < 16) {
                        int j4 = 0;
                        while (j4 < 8) {
                            int idx7 = i11 * 16 + j4 * 2;
                            if (sp[idx7] != this.setpointState[idx7] || sp[idx7 + 1] != this.setpointState[idx7 + 1]) {
                                this.setpointState[idx7] = sp[idx7];
                                this.setpointState[idx7 + 1] = sp[idx7 + 1];
                                this.ioWrite("a" + (i11 + 1) + ".s" + (j4 + 1) + ".setpoint", Integer.toString(((sp[idx7] & 0xFF) << 8) + (sp[idx7 + 1] & 0xFF)));
                            }
                            ++j4;
                        }
                        ++i11;
                    }
                    byte[] delay = this.readRAM(81664, 256);
                    int i12 = 0;
                    while (i12 < 16) {
                        int j5 = 0;
                        while (j5 < 8) {
                            int idx8 = i12 * 16 + j5 * 2;
                            if (delay[idx8] != this.delayState[idx8] || delay[idx8 + 1] != this.delayState[idx8 + 1]) {
                                this.delayState[idx8] = delay[idx8];
                                this.delayState[idx8 + 1] = delay[idx8 + 1];
                                this.ioWrite("a" + (i12 + 1) + ".s" + (j5 + 1) + ".delay", Integer.toString(((delay[idx8] & 0xFF) << 8) + (delay[idx8 + 1] & 0xFF)));
                            }
                            ++j5;
                        }
                        ++i12;
                    }
                }
            }
            if (!this.initialized) {
                this.initialized = true;
            }
            return true;
        }
        catch (Exception e2) {
            if (this.isVerboseLog()) {
                this.errorLog("Polling exception: " + e2);
            }
            return false;
        }
    }

    public boolean end() {
        if (this.toolsProxy) {
            this.registerDueluxHook(this.name, this, false);
        }
        if (this.online) {
            this.online = false;
            this.ioWrite("connection", "offline");
            this.closeComm();
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int i2 = id.lastIndexOf(46);
        if (i2 > 0) {
            try {
                this.command(id.substring(0, i2), id.substring(i2 + 1));
                return "";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void command(String name, String value) {
        block56: {
            try {
                name = name.toLowerCase();
                if (name.equals("clock")) {
                    if (value.equalsIgnoreCase("read")) {
                        Date d2 = this.readClock();
                        this.ioWrite("clock", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d2));
                        this.ioWrite("clock.delta", Long.toString((d2.getTime() - System.currentTimeMillis()) / 1000L));
                    } else if (value.equalsIgnoreCase("sync")) {
                        this.writeClock();
                        Date d3 = this.readClock();
                        this.ioWrite("clock", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d3));
                        this.ioWrite("clock.delta", Long.toString((d3.getTime() - System.currentTimeMillis()) / 1000L));
                    }
                    break block56;
                }
                if (name.startsWith("c")) {
                    int n2 = Integer.parseInt(name.substring(1));
                    if (n2 >= 1 && n2 <= 64) {
                        int address = 8449 + 2 * (n2 - 1);
                        if (value.equals("1") || value.equalsIgnoreCase("on")) {
                            this.writeRAM(address, true);
                            break block56;
                        }
                        if (value.equals("0") || value.equalsIgnoreCase("off")) {
                            this.writeRAM(address, false);
                            break block56;
                        }
                        throw new IllegalArgumentException("value error");
                    }
                    throw new IllegalArgumentException("name error");
                }
                if (name.startsWith("o")) {
                    String[] na = name.split("[.]");
                    if (na.length == 1) {
                        int n3 = Integer.parseInt(name.substring(1));
                        if (n3 >= 1 && n3 <= 64) {
                            if (this.lampsOnField[n3 - 1]) {
                                int index;
                                if (value.equalsIgnoreCase("off")) {
                                    this.writeRAM(8704 + 2 * (n3 - 1), 0);
                                    break block56;
                                }
                                if (value.equalsIgnoreCase("on")) {
                                    Integer lv = this.oValue[n3 - 1];
                                    if (lv != null && lv > 0) {
                                        this.writeRAM(8704 + 2 * (n3 - 1), lv);
                                    } else {
                                        this.writeRAM(8704 + 2 * (n3 - 1), 100);
                                    }
                                    break block56;
                                }
                                int v = value.endsWith("%") ? Short.parseShort(value.substring(0, value.length() - 1)) : ((index = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1))) : Short.parseShort(value));
                                if (v >= 0 && v <= 100) {
                                    this.writeRAM(8704 + 2 * (n3 - 1), v);
                                    break block56;
                                }
                                throw new IllegalArgumentException("value error");
                            }
                            throw new IllegalArgumentException("lamp not detected");
                        }
                        throw new IllegalArgumentException("name error");
                    }
                    if (na.length != 2 || !na[1].equals("time")) break block56;
                    int n4 = Integer.parseInt(na[0].substring(1));
                    if (n4 >= 1 && n4 <= 64) {
                        if (this.lampsOnField[n4 - 1]) {
                            long v = Long.parseLong(value);
                            if (v >= 0L) {
                                this.writeRAM(11776 + 4 * (n4 - 1), v);
                                this.lampOnTimeLoopTimemillis = 0L;
                            }
                            break block56;
                        }
                        throw new IllegalArgumentException("lamp not detected");
                    }
                    throw new IllegalArgumentException("name error");
                }
                if (name.startsWith("g")) {
                    if (name.endsWith(".fadetime")) {
                        int n5 = Integer.parseInt(name.substring(1, name.indexOf(46)));
                        if (n5 < 1 || n5 > 16) break block56;
                        int v = Integer.parseInt(value);
                        if (v >= 0 && v <= 65535) {
                            this.writeRAM(8912 + 2 * (n5 - 1), v);
                            this.setpointDelayFadeLoopTimemillis = 0L;
                            break block56;
                        }
                        throw new IllegalArgumentException("value error");
                    }
                    if (name.endsWith(".lock")) {
                        int n6 = Integer.parseInt(name.substring(1, name.indexOf(46)));
                        if (n6 >= 1 && n6 <= 16) {
                            if (value.equals("0")) {
                                this.writeRAM(8832 + 2 * (n6 - 1), 113);
                            } else if (value.equals("1")) {
                                this.writeRAM(8832 + 2 * (n6 - 1), 112);
                            }
                        }
                        break block56;
                    }
                    int n7 = Integer.parseInt(name.substring(1));
                    if (n7 >= 1 && n7 <= 16) {
                        int index;
                        if (value.equalsIgnoreCase("off")) {
                            this.writeRAM(8832 + 2 * (n7 - 1), 0);
                            break block56;
                        }
                        if (value.equalsIgnoreCase("on")) {
                            Integer lv = this.gValue[n7 - 1];
                            if (lv != null && lv > 0) {
                                this.writeRAM(8832 + 2 * (n7 - 1), lv);
                            } else {
                                this.writeRAM(8832 + 2 * (n7 - 1), 100);
                            }
                            break block56;
                        }
                        int v = value.endsWith("%") ? Short.parseShort(value.substring(0, value.length() - 1)) : ((index = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1))) : Short.parseShort(value));
                        if (v >= 0 && v <= 100) {
                            this.writeRAM(8832 + 2 * (n7 - 1), v);
                            break block56;
                        }
                        throw new IllegalArgumentException("value error");
                    }
                    throw new IllegalArgumentException("name error");
                }
                if (name.startsWith("broadcast")) {
                    int index;
                    if (name.endsWith(".fadetime")) {
                        int v = Integer.parseInt(value);
                        if (v >= 0 && v <= 65535) {
                            this.writeRAM(8898, v);
                            this.setpointDelayFadeLoopTimemillis = 0L;
                            break block56;
                        }
                        throw new IllegalArgumentException("value error");
                    }
                    if (value.equalsIgnoreCase("off")) {
                        this.writeRAM(8896, 0);
                        break block56;
                    }
                    if (value.equalsIgnoreCase("on")) {
                        if (this.broadcastValue != null && this.broadcastValue > 0) {
                            this.writeRAM(8896, this.broadcastValue);
                        } else {
                            this.writeRAM(8896, 100);
                        }
                        break block56;
                    }
                    int v = value.endsWith("%") ? Short.parseShort(value.substring(0, value.length() - 1)) : ((index = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1))) : Short.parseShort(value));
                    if (v >= 0 && v <= 100) {
                        this.writeRAM(8896, v);
                        break block56;
                    }
                    throw new IllegalArgumentException("value error");
                }
                if (!name.startsWith("a")) break block56;
                String[] na = name.split("[.]");
                if (na.length == 3) {
                    if (na[1].startsWith("s")) {
                        int a2 = Integer.parseInt(na[0].substring(1));
                        int s = Integer.parseInt(na[1].substring(1));
                        if (a2 < 1 || a2 > 16 || s < 1 || s > 8) break block56;
                        int v = Integer.parseInt(value);
                        if (v >= 0 && v <= 65535) {
                            if (na[2].equals("setpoint")) {
                                this.writeRAM(81408 + 16 * (a2 - 1) + 2 * (s - 1), v);
                                this.setpointDelayFadeLoopTimemillis = 0L;
                                break block56;
                            }
                            if (na[2].equals("delay")) {
                                this.writeRAM(81664 + 16 * (a2 - 1) + 2 * (s - 1), v);
                                this.setpointDelayFadeLoopTimemillis = 0L;
                                break block56;
                            }
                            throw new IllegalArgumentException("name error");
                        }
                        throw new IllegalArgumentException("value error");
                    }
                    throw new IllegalArgumentException("name error");
                }
                if (na.length == 4) {
                    if (na[1].startsWith("s") && na[2].startsWith("g")) {
                        int a3 = Integer.parseInt(na[0].substring(1));
                        int s = Integer.parseInt(na[1].substring(1));
                        int g2 = Integer.parseInt(na[2].substring(1));
                        if (a3 < 1 || a3 > 16 || s < 1 || s > 8 || g2 < 1 || g2 > 16) break block56;
                        int v = Integer.parseInt(value);
                        if (v >= 0 && v <= 255) {
                            int base = 65536 + 512 * (a3 - 1) + 64 * (s - 1) + 4 * (g2 - 1);
                            if (na[3].equals("activationvalue")) {
                                byte[] data = this.readRAM(base, 2);
                                this.writeRAM(base, ((v & 0xFF) << 8) + (data[1] & 0xFF));
                                data = this.readRAM(base, 2);
                                this.ioWrite(name, Integer.toString(data[0] & 0xFF));
                                break block56;
                            }
                            if (na[3].equals("deactivationvalue")) {
                                byte[] data = this.readRAM(base, 2);
                                this.writeRAM(base, ((data[0] & 0xFF) << 8) + (v & 0xFF));
                                data = this.readRAM(base, 2);
                                this.ioWrite(name, Integer.toString(data[1] & 0xFF));
                                break block56;
                            }
                            if (na[3].equals("commandonvalue")) {
                                byte[] data = this.readRAM(base += 2, 2);
                                this.writeRAM(base, ((v & 0xFF) << 8) + (data[1] & 0xFF));
                                data = this.readRAM(base, 2);
                                this.ioWrite(name, Integer.toString(data[0] & 0xFF));
                                break block56;
                            }
                            if (na[3].equals("commandoffvalue")) {
                                byte[] data = this.readRAM(base += 2, 2);
                                this.writeRAM(base, ((data[0] & 0xFF) << 8) + (v & 0xFF));
                                data = this.readRAM(base, 2);
                                this.ioWrite(name, Integer.toString(data[1] & 0xFF));
                                break block56;
                            }
                            throw new IllegalArgumentException("name error");
                        }
                        throw new IllegalArgumentException("value error");
                    }
                    throw new IllegalArgumentException("name error");
                }
                throw new IllegalArgumentException("name error");
            }
            catch (Exception e2) {
                this.errorLog("Command error: " + name + " = " + value + ": " + e2.getMessage());
            }
        }
    }

    public void toolsProxyGet(OutputStream raw, Writer out, String file) {
        InputStream instream = null;
        try {
            try {
                int b2;
                URL url = new URL("http", this.address.getHostString(), this.address.getPort(), file);
                HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                uc.setConnectTimeout(10000);
                uc.setReadTimeout(600000);
                uc.setRequestProperty("Set-Cookie", "login=admin");
                int i2 = 0;
                while (true) {
                    String k2 = uc.getHeaderFieldKey(i2);
                    String v = uc.getHeaderField(i2);
                    if (k2 != null) {
                        out.write(String.valueOf(k2) + ": " + v + "\r\n");
                    } else {
                        if (v == null) break;
                        out.write(String.valueOf(v) + "\r\n");
                    }
                    ++i2;
                }
                out.write("\r\n");
                out.flush();
                int code = uc.getResponseCode();
                InputStream inputStream = instream = code >= 200 && code < 300 ? uc.getInputStream() : uc.getErrorStream();
                while ((b2 = instream.read()) != -1) {
                    raw.write(b2);
                }
                raw.flush();
            }
            catch (Exception exception) {
                try {
                    instream.close();
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                instream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void toolsProxyPost(OutputStream raw, Writer out, String file, String contentType, byte[] data) {
        InputStream instream = null;
        OutputStream outstream = null;
        try {
            try {
                int b2;
                URL url = new URL("http", this.address.getHostString(), this.address.getPort(), file);
                HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                uc.setConnectTimeout(10000);
                uc.setReadTimeout(600000);
                uc.setRequestMethod("POST");
                uc.setDoOutput(true);
                uc.setRequestProperty("Set-Cookie", "login=admin");
                uc.setRequestProperty("Content-Type", contentType);
                uc.setRequestProperty("Content-Length", Integer.toString(data.length));
                outstream = uc.getOutputStream();
                outstream.write(data);
                outstream.flush();
                int i2 = 0;
                while (true) {
                    String k2 = uc.getHeaderFieldKey(i2);
                    String v = uc.getHeaderField(i2);
                    if (k2 != null) {
                        out.write(String.valueOf(k2) + ": " + v + "\r\n");
                    } else {
                        if (v == null) break;
                        out.write(String.valueOf(v) + "\r\n");
                    }
                    ++i2;
                }
                int code = uc.getResponseCode();
                instream = code >= 200 && code < 300 ? uc.getInputStream() : uc.getErrorStream();
                out.write("\r\n");
                out.flush();
                while ((b2 = instream.read()) != -1) {
                    raw.write(b2);
                }
                raw.flush();
            }
            catch (Exception exception) {
                try {
                    instream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    outstream.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                instream.close();
            }
            catch (Exception exception) {}
            try {
                outstream.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean inputDiscovery() {
        int address = 12096;
        try {
            byte[] p = this.readRAM(address, 2);
            address = ((p[0] & 0xFF) << 8) + (p[1] & 0xFF);
            int i2 = 0;
            while (i2 < 4) {
                byte[] b2 = this.readRAM(address + i2 * 256, 256);
                int k2 = 0;
                while (k2 < 16) {
                    int j2 = 0;
                    while (j2 < 9) {
                        byte v;
                        this.inputType[i2 * 16 + k2][j2] = v = b2[k2 * 16 + j2];
                        if (j2 < 8 && v != 0 && v != -1) {
                            switch (v) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.messageLog("ioMonitor - detected input device: di" + (i2 * 16 + k2 + 1) + "." + (j2 + 1) + " = " + INPUT_TYPE_NAME[v]);
                                    if (!this.detectEvents) break;
                                    this.ioWriteForced("detected.input.di" + (i2 * 16 + k2 + 1) + "." + (j2 + 1), INPUT_TYPE_NAME[v]);
                                    break;
                                }
                                case 4: {
                                    this.messageLog("ioMonitor - detected input device: ai" + (i2 * 16 + k2 + 1) + "." + (j2 + 1) + " = " + INPUT_TYPE_NAME[v]);
                                    if (!this.detectEvents) break;
                                    this.ioWriteForced("detected.input.ai" + (i2 * 16 + k2 + 1) + "." + (j2 + 1), INPUT_TYPE_NAME[v]);
                                }
                            }
                        }
                        ++j2;
                    }
                    ++k2;
                }
                ++i2;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean outputDiscovery() {
        int address = 12080;
        try {
            byte[] b2 = this.readRAM(address, 8);
            int i2 = 0;
            while (i2 < 8) {
                int j2 = 0;
                while (j2 < 8) {
                    if ((b2[i2] & 1 << j2) != 0) {
                        this.lampsOnField[i2 * 8 + j2] = true;
                        this.messageLog("ioMonitor - detected output device: o" + (i2 * 8 + j2 + 1));
                        if (this.detectEvents) {
                            this.ioWriteForced("detected.output.o" + (i2 * 8 + j2 + 1), "lamp");
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized byte[] readRAM(int address, int len) {
        byte[] byArray = new byte[9];
        byArray[1] = 127;
        byArray[2] = 4;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF0000) >>> 16);
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        command[6] = (byte)(len & 0xFF);
        this.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            this.readCommBytes(0);
            if (this.writeCommBytes(command) == command.length) {
                byte[] data = this.read(127);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            ++i2;
        }
        return null;
    }

    private synchronized void writeRAM(int address, boolean value) throws Exception {
        byte[] byArray = new byte[10];
        byArray[1] = 126;
        byArray[2] = 5;
        byArray[6] = 1;
        byte[] command = byArray;
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        if (value) {
            command[7] = 1;
        }
        this.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            if (this.writeCommBytes(command) == command.length) {
                byte[] data = this.read(126);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            ++i2;
        }
        throw new IOException();
    }

    private synchronized void writeRAM(int address, int value) throws Exception {
        byte[] byArray = new byte[11];
        byArray[1] = 126;
        byArray[2] = 6;
        byArray[6] = 2;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF0000) >>> 16);
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        command[7] = (byte)((value & 0xFF00) >>> 8);
        command[8] = (byte)(value & 0xFF);
        this.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            if (this.writeCommBytes(command) == command.length) {
                byte[] data = this.read(126);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            ++i2;
        }
        throw new IOException();
    }

    private synchronized void writeRAM(int address, long value) throws Exception {
        byte[] byArray = new byte[13];
        byArray[1] = 126;
        byArray[2] = 8;
        byArray[6] = 4;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF0000) >>> 16);
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        command[7] = (byte)((value & 0xFFFFFFFFFF000000L) >>> 24);
        command[8] = (byte)((value & 0xFF0000L) >>> 16);
        command[9] = (byte)((value & 0xFF00L) >>> 8);
        command[10] = (byte)(value & 0xFFL);
        this.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            if (this.writeCommBytes(command) == command.length) {
                byte[] data = this.read(126);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            ++i2;
        }
        throw new IOException();
    }

    private Date readClock() {
        Calendar cal = Calendar.getInstance();
        try {
            byte[] d2 = this.readRAM(12032, 14);
            cal.clear();
            cal.set(2000 + this.decodeBCD(d2[13]), this.decodeBCD(d2[11]) - 1, this.decodeBCD(d2[9]), this.decodeBCD(d2[1]), this.decodeBCD(d2[3]), this.decodeBCD(d2[5]));
            return cal.getTime();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private synchronized void writeClock() throws Exception {
        byte[] byArray = new byte[23];
        byArray[1] = 126;
        byArray[2] = 18;
        byArray[4] = 47;
        byArray[6] = 14;
        byte[] command = byArray;
        Calendar cal = Calendar.getInstance();
        command[8] = this.encodeBCD(cal.get(11));
        command[10] = this.encodeBCD(cal.get(12));
        command[12] = this.encodeBCD(cal.get(13));
        command[14] = this.encodeBCD(cal.get(7) - 1);
        command[16] = this.encodeBCD(cal.get(5));
        command[18] = this.encodeBCD(cal.get(2) + 1);
        command[20] = this.encodeBCD(cal.get(1) - 2000);
        this.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            if (this.writeCommBytes(command) == command.length) {
                byte[] data = this.read(126);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            ++i2;
        }
        throw new IOException();
    }

    public synchronized byte[] writeRawMessage(byte[] command) {
        try {
            byte[] header;
            this.readCommBytes(0);
            if (this.writeCommBytes(command) == command.length && (header = this.readCommBytes(3)) != null && header.length == 3) {
                int bodylength = (header[2] == 0 ? 256 : header[2] & 0xFF) + 2;
                byte[] body = this.readCommBytes(bodylength);
                byte[] response = Arrays.copyOf(header, header.length + body.length);
                System.arraycopy(body, 0, response, header.length, body.length);
                return response;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readCommBytes(int len) {
        ByteArrayOutputStream buffer = null;
        InetSocketAddress inetSocketAddress = this.address;
        synchronized (inetSocketAddress) {
            try {
                if (this.socket == null) {
                    this.socket = new Socket();
                    this.socket.connect(this.address, 3000);
                    this.socket.setSoTimeout(3000);
                    this.socket.setKeepAlive(true);
                    this.bin = new BufferedInputStream(this.socket.getInputStream());
                    this.bout = new BufferedOutputStream(this.socket.getOutputStream());
                }
            }
            catch (Exception e2) {
                this.closeComm();
                if (this.isVerboseLog()) {
                    this.errorLog("Socket not connected: " + e2.getLocalizedMessage());
                }
                return null;
            }
            try {
                if (len == 0) {
                    int a2 = this.bin.available();
                    if (a2 > 0) {
                        this.bin.skip(a2);
                    }
                    return new byte[0];
                }
                buffer = new ByteArrayOutputStream(len);
                byte[] bytes = new byte[len];
                int totr = 0;
                while (totr < len) {
                    int r = this.bin.read(bytes, 0, len - totr);
                    if (r <= 0) break;
                    totr += r;
                    buffer.write(bytes, 0, r);
                }
                byte[] ba = buffer.toByteArray();
                if (this.readCommDump) {
                    File f2 = new File("logs", String.valueOf(this.name) + ".readcomm.log");
                    if (f2.canWrite()) {
                        FileOutputStream fos = new FileOutputStream(f2, true);
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                        osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                        StringBuffer sb = new StringBuffer(ba.length);
                        int i2 = 0;
                        while (i2 < ba.length) {
                            String b2 = Integer.toHexString(ba[i2] & 0xFF).toUpperCase();
                            if (b2.length() == 1) {
                                sb.append('0');
                            }
                            sb.append(b2);
                            ++i2;
                        }
                        osw.write(sb.toString());
                        osw.write("\r\n");
                        osw.close();
                        fos.close();
                    } else {
                        this.readCommDump = false;
                    }
                }
                return ba;
            }
            catch (SocketTimeoutException e3) {
                return buffer == null ? new byte[]{} : buffer.toByteArray();
            }
            catch (Exception e4) {
                this.closeComm();
                if (this.isVerboseLog()) {
                    this.errorLog("Socket disconnected (read): " + e4.getLocalizedMessage());
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeCommBytes(byte[] data) {
        InetSocketAddress inetSocketAddress = this.address;
        synchronized (inetSocketAddress) {
            try {
                if (this.socket == null) {
                    this.socket = new Socket();
                    this.socket.connect(this.address, 3000);
                    this.socket.setSoTimeout(3000);
                    this.socket.setKeepAlive(true);
                    this.bin = new BufferedInputStream(this.socket.getInputStream());
                    this.bout = new BufferedOutputStream(this.socket.getOutputStream());
                }
            }
            catch (Exception e2) {
                this.closeComm();
                if (this.isVerboseLog()) {
                    this.errorLog("Socket not connected: " + e2.getLocalizedMessage());
                }
                return 0;
            }
            try {
                this.bout.write(data);
                this.bout.flush();
                if (this.writeCommDump) {
                    File f2 = new File("logs", "writecomm.log");
                    if (f2.canWrite()) {
                        FileOutputStream fos = new FileOutputStream(f2, true);
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                        osw.write(String.valueOf(System.currentTimeMillis()) + " ");
                        StringBuffer sb = new StringBuffer(data.length);
                        int i2 = 0;
                        while (i2 < data.length) {
                            String b2 = Integer.toHexString(data[i2] & 0xFF).toUpperCase();
                            if (b2.length() == 1) {
                                sb.append('0');
                            }
                            sb.append(b2);
                            ++i2;
                        }
                        osw.write(sb.toString());
                        osw.write("\r\n");
                        osw.close();
                        fos.close();
                    } else {
                        this.writeCommDump = false;
                    }
                }
                return data.length;
            }
            catch (Exception e3) {
                this.closeComm();
                if (this.isVerboseLog()) {
                    this.errorLog("Socket disconnected (write): " + e3.getLocalizedMessage());
                }
                return 0;
            }
        }
    }

    private void closeComm() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        this.sleep(100L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] read(int command) {
        byte address = 0;
        boolean waitforaddress = true;
        try {
            int i2 = 0;
            while (i2 < 1024) {
                byte[] b2 = this.readCommBytes(1);
                if (b2 != null && b2.length == 1) {
                    if (waitforaddress) {
                        address = b2[0];
                        waitforaddress = false;
                    } else {
                        if ((byte)(command & 0xFF) == b2[0]) break;
                        address = b2[0];
                        waitforaddress = true;
                    }
                } else {
                    return null;
                }
                ++i2;
            }
            byte[] sizeheader = this.readCommBytes(1);
            int size = sizeheader[0] == 0 ? 256 : sizeheader[0] & 0xFF;
            byte[] body = this.readCommBytes(size);
            byte[] checksum = this.readCommBytes(2);
            if (this.ckscheck(address, command, sizeheader[0], body, checksum)) {
                return body;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private boolean ckscheck(int address, int code, int size, byte[] body, byte[] checksum) {
        int cks = (address & 0xFF) + (code & 0xFF) + (size & 0xFF);
        int i2 = 0;
        while (i2 < body.length) {
            cks = cks + (body[i2] & 0xFF) & 0xFFFF;
            ++i2;
        }
        int c2 = ~(((checksum[0] & 0xFF) << 8) + (checksum[1] & 0xFF)) & 0xFFFF;
        return cks == c2;
    }

    private void cksfiller(byte[] data) {
        int cks = 0;
        int i2 = 0;
        while (i2 < data.length - 2) {
            cks = cks + (data[i2] & 0xFF) & 0xFFFF;
            ++i2;
        }
        data[data.length - 2] = (byte)(~cks >>> 8 & 0xFF);
        data[data.length - 1] = (byte)(~cks & 0xFF);
    }

    private byte encodeBCD(int data) {
        return (byte)(data / 10 << 4 | data % 10);
    }

    private int decodeBCD(byte data) {
        return ((data & 0xF0) >> 4) * 10 + (data & 0xF);
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void ioWrite(String message, String value) {
        if (this.initialized || this.startupEvents) {
            super.ioWrite(message, value);
        } else {
            super.ioWriteNoEvents(message, value);
        }
    }
}

