/*
 * Decompiled with CFR 0.152.
 */
package drivers.cradlepoint;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import com.hsyco.driverBase;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 22;
    public static final int COMMANDSQUEUESIZE = 32;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private final String DEFAULT_QUERY_PATH = "/status/wan/connection_state /status/system/wan_signal_strength /status/wan/stats";
    private final int MIN_POLL_TIME_MILLIS = 4000;
    private String host = null;
    private int port = 22;
    private Connection connection = null;
    private Session session = null;
    private InputStreamReader stdout = null;
    private OutputStreamWriter stdin = null;
    private String user = null;
    private String password = null;
    private boolean startupevents = false;
    private boolean initialized = false;
    private String initial_prefix = null;
    private String querycommand = null;

    public boolean init(String name, HashMap<String, String> config) {
        block16: {
            String s;
            super.init(name);
            this.host = config.get("host");
            try {
                this.port = Integer.parseInt(config.get("port"));
                if (this.port < 1 || this.port > 65535) {
                    this.port = 22;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.user = (s = config.get("user")) == null ? "admin" : s;
            s = config.get("password");
            this.password = s == null ? "" : s;
            s = config.containsKey("query") ? config.get("query").replaceAll(";", " ") : "/status/wan/connection_state /status/system/wan_signal_strength /status/wan/stats";
            this.querycommand = "get " + s;
            if (s.split(" ").length == 1 && !s.equals("/")) {
                this.initial_prefix = s;
            }
            if ((s = config.get("startupevents")) != null) {
                this.startupevents = Boolean.parseBoolean(s);
            }
            this.connection = new Connection(this.host, this.port);
            this.connection.connect(null, 6000, 6000);
            if (!this.connection.authenticateWithPassword(this.user, this.password)) break block16;
            this.session = this.connection.openSession();
            this.session.startShell();
            this.stdin = new OutputStreamWriter(this.session.getStdin(), "UTF-8");
            this.stdout = new InputStreamReader(this.session.getStdout(), "UTF-8");
            return true;
        }
        try {
            this.errorLog("ioMonitor - Authentication failed [" + name + "] - quit");
        }
        catch (Exception e2) {
            this.errorLog("ioMonitor - Connection error [" + name + "] - quit");
        }
        try {
            this.stdin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stdout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean loop() {
        int status = 0;
        StringBuffer jsonsb = new StringBuffer();
        try {
            long t = System.currentTimeMillis();
            this.stdin.write(String.valueOf(this.querycommand) + "\r\n");
            this.stdin.flush();
            while (status != 2) {
                String line = this.readOutLine(this.session, this.stdout);
                if (line.length() <= 0) continue;
                line = line.trim();
                if (status == 0) {
                    if (line.indexOf(this.querycommand) == -1) continue;
                    status = 1;
                    continue;
                }
                if (line.startsWith("[") && line.endsWith("$")) {
                    status = 2;
                    continue;
                }
                jsonsb.append(line);
            }
            if (jsonsb.length() > 0) {
                if (!this.initialized) {
                    this.initialized = true;
                    this.ioWrite("connection", "online");
                }
                if (jsonsb.charAt(0) == '{') {
                    this.browseJsonObject(this.initial_prefix, new JSONObject(jsonsb.toString()));
                } else {
                    this.browseJsonObject(this.initial_prefix, jsonsb.toString().replaceAll("[\"]", ""));
                }
                long sleeptime = 4000L - (System.currentTimeMillis() - t);
                if (sleeptime > 0L) {
                    this.sleep(sleeptime);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sleep(1000L);
        return false;
    }

    public boolean end() {
        if (this.initialized) {
            this.initialized = false;
            this.ioWrite("connection", "offline");
        }
        try {
            this.stdin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stdout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void command(String name, String value) {
        Connection commandconnection = null;
        Session session = null;
        InputStreamReader out = null;
        OutputStreamWriter in = null;
        int status = 0;
        if (this.initialized) {
            try {
                try {
                    commandconnection = new Connection(this.host, this.port);
                    commandconnection.connect(null, 30000, 30000);
                    if (commandconnection.authenticateWithPassword(this.user, this.password)) {
                        session = commandconnection.openSession();
                        session.startShell();
                        in = new OutputStreamWriter(session.getStdin(), "UTF-8");
                        out = new InputStreamReader(session.getStdout(), "UTF-8");
                        String command = "router".equalsIgnoreCase(name) && "reboot".equalsIgnoreCase(value) ? "reboot" : ("command".equalsIgnoreCase(name) ? value : null);
                        if (command != null) {
                            in.write(String.valueOf(command) + "\r\n");
                            in.flush();
                            while (status != 2) {
                                String line = this.readOutLine(session, out);
                                if (line.length() > 0) {
                                    line = line.trim();
                                    if (status == 0) {
                                        if (line.indexOf(command) == -1) continue;
                                        status = 1;
                                        continue;
                                    }
                                    if (!line.startsWith("[") || !line.endsWith("$")) continue;
                                    status = 2;
                                    continue;
                                }
                                status = 2;
                            }
                        }
                    } else {
                        this.sleep(10000L);
                    }
                }
                catch (Exception exception) {
                    try {
                        in.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        session.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                    try {
                        commandconnection.close();
                    }
                    catch (Exception exception5) {}
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                try {
                    out.close();
                }
                catch (Exception exception) {}
                try {
                    session.close();
                }
                catch (Exception exception) {}
                try {
                    commandconnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void browseJsonObject(String prefix, Object obj) throws Exception {
        String cname = obj.getClass().getName();
        if (cname.equals("org.json.JSONObject")) {
            Iterator<String> keys = ((JSONObject)obj).keys();
            while (keys.hasNext()) {
                String key = keys.next();
                this.browseJsonObject(prefix == null ? key : String.valueOf(prefix) + "." + key, ((JSONObject)obj).get(key));
            }
        } else if (cname.equals("org.json.JSONArray")) {
            int i2 = 0;
            while (i2 < ((JSONArray)obj).length()) {
                this.browseJsonObject(String.valueOf(prefix) + "[" + i2 + "]", ((JSONArray)obj).get(i2));
                ++i2;
            }
        } else if (cname.equals("java.lang.Boolean")) {
            this.ioWriteLocal(prefix, ((Boolean)obj).toString());
        } else if (cname.equals("java.lang.Double")) {
            this.ioWriteLocal(prefix, ((Double)obj).toString());
        } else if (cname.equals("java.lang.Integer")) {
            this.ioWriteLocal(prefix, ((Integer)obj).toString());
        } else if (cname.equals("java.lang.Long")) {
            this.ioWriteLocal(prefix, ((Long)obj).toString());
        } else if (cname.equals("java.lang.String")) {
            this.ioWriteLocal(prefix, (String)obj);
        }
    }

    private String readOutLine(Session session, InputStreamReader stdout) {
        StringBuffer sb = new StringBuffer();
        try {
            while (stdout.ready() || (session.waitForCondition(4, 30000L) & 4) != 0) {
                int ch = stdout.read();
                switch (ch) {
                    case -1: {
                        return sb.length() == 0 ? null : sb.toString();
                    }
                    case 10: {
                        return sb.toString();
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        sb.append((char)ch);
                    }
                }
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private void ioWriteLocal(String name, String value) {
        if ((name = name.replaceAll("[./]+", ".")).startsWith(".")) {
            name = name.substring(1);
        }
        if (this.initialized || this.startupevents) {
            this.ioWrite(name, value);
        } else {
            this.ioWriteNoEvents(name, value);
        }
    }
}

