/*
 * Decompiled with CFR 0.152.
 */
package drivers.avigilonweb;

import com.hsyco.hsyco;
import drivers.avigilonweb.Driver;
import drivers.avigilonweb.Utils;
import drivers.avigilonweb.apiCalls;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.http.NameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class apiUtils {
    public static JSONObject buildAPICallPOST(JSONObject params, String urlString, Driver driver) throws IOException, JSONException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setConnectTimeout(5000);
        conn.setDoOutput(true);
        try {
            OutputStream os = conn.getOutputStream();
            byte[] input = params.toString().getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        catch (Exception os) {
            // empty catch block
        }
        if (conn.getResponseCode() == 201 || conn.getResponseCode() == 200) {
            InputStream response = conn.getInputStream();
            String jsonReply = Utils.convertStreamToString(response);
            JSONObject o2 = new JSONObject(jsonReply);
            if (driver.verboseLog()) {
                hsyco.messageLog(String.valueOf(driver.name) + " - AVIGLION-WEB VERBOSE LOGS - " + o2.toString());
            }
            return o2;
        }
        driver.sendErrorLog("Error in " + urlString + " | Status code: " + conn.getResponseCode());
        return null;
    }

    public static JSONObject buildAPICallGET(List<NameValuePair> params, String url, Driver driver) throws MalformedURLException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("Content-Type", "application/json");
        if (params != null) {
            for (NameValuePair pair : params) {
                conn.addRequestProperty(pair.getName(), pair.getValue());
            }
        }
        JSONObject o2 = null;
        if (conn.getResponseCode() == 201 || conn.getResponseCode() == 200) {
            InputStream response = conn.getInputStream();
            String jsonReply = Utils.convertStreamToString(response);
            o2 = new JSONObject(jsonReply);
            if (driver.verboseLog()) {
                hsyco.messageLog(String.valueOf(driver.name) + " - AVIGLION-WEB VERBOSE LOGS - " + o2.toString());
            }
        } else {
            apiUtils.testSession(driver.getSession(), driver);
            apiUtils.buildAPICallGET(params, url, driver);
            driver.sendErrorLog("Error in " + url + " | Status code: " + conn.getResponseCode());
        }
        conn.disconnect();
        return o2;
    }

    public static boolean buildAPICallPUT(Driver driver, String url, String json) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException {
        OutputStream os = null;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        String tosend = json;
        os = conn.getOutputStream();
        os.write(tosend.getBytes());
        os.flush();
        JSONObject o2 = null;
        if (conn.getResponseCode() == 200) {
            InputStream response = conn.getInputStream();
            String jsonReply = Utils.convertStreamToString(response);
            o2 = new JSONObject(jsonReply);
            if (driver.verboseLog()) {
                hsyco.messageLog(String.valueOf(driver.name) + " - AVIGLION-WEB VERBOSE LOGS - " + o2.toString());
            }
            return true;
        }
        apiUtils.testSession(driver.getSession(), driver);
        apiUtils.buildAPICallPUT(driver, url, json);
        driver.sendErrorLog("Error in " + url + " | Status code: " + conn.getResponseCode());
        conn.disconnect();
        return false;
    }

    public static String testSession(String session, Driver driver) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException, JSONException {
        JSONObject testSessionobj = apiUtils.buildAPICallGET(null, String.valueOf(driver.getAddress()) + ":" + driver.getPort() + "/mt/api/rest/v1/sites?session=" + session, driver);
        if (!testSessionobj.getString("status").equals("success")) {
            session = apiCalls.AvigilonLogin(driver);
            driver.setSession(session);
        }
        return session;
    }

    public static void trustEveryone() {
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

