/*
 * Decompiled with CFR 0.152.
 */
package drivers.avigilonweb;

import drivers.avigilonweb.Driver;
import drivers.avigilonweb.Utils;
import drivers.avigilonweb.apiUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class apiCalls {
    public static String AvigilonLogin(Driver driver) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException {
        JSONObject params = new JSONObject();
        params.put("username", driver.getUsername());
        params.put("password", driver.getPassword());
        params.put("clientName", "HsycoClient");
        params.put("authorizationToken", Utils.genToken(driver.getUsernonce(), driver.getUserkey()));
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.getAddress()) + ":" + driver.getPort() + "/mt/api/rest/v1/login", driver);
        if (obj.getString("status").equals("success")) {
            String session = obj.getJSONObject("result").getString("session");
            return session;
        }
        return null;
    }

    public static void AvigilonLogout(Driver driver) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException {
        JSONObject params = new JSONObject();
        params.put("session", driver.getSession());
        apiUtils.buildAPICallPOST(params, String.valueOf(driver.getAddress()) + ":" + driver.getPort() + "/mt/api/rest/v1/logout", driver);
    }

    public static JSONArray getAlarms(Driver driver) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, ClientProtocolException, IOException, JSONException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new BasicNameValuePair("x-avg-session", driver.getSession()));
        JSONObject obj = apiUtils.buildAPICallGET(params, String.valueOf(driver.getAddress()) + ":" + driver.getPort() + "/mt/api/rest/v1/alarms", driver);
        JSONArray allAlarms = obj.getJSONObject("result").getJSONArray("alarms");
        return allAlarms;
    }

    public static boolean ackAlarm(Driver driver, String alarmId) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException, JSONException {
        String json = "{\n  \"session\": \"" + driver.getSession() + "\",\n" + "  \"id\": \"" + alarmId + "\",\n" + "  \"action\": \"ACKNOWLEDGE\",\n" + "  \"note\": \"Alarm acknowledged by Hsyco\",\n" + "  \"permission\": \"NORMAL\"\n" + "}";
        return apiUtils.buildAPICallPUT(driver, String.valueOf(driver.getAddress()) + ":" + driver.getPort() + "/mt/api/rest/v1/alarm", json);
    }

    public static boolean triggerAlarm(Driver driver, String alarmId) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException, JSONException {
        String json = "{\n  \"session\": \"" + driver.getSession() + "\",\n" + "  \"id\": \"" + alarmId + "\",\n" + "  \"action\": \"TRIGGER\",\n" + "  \"note\": \"Alarm triggered by Hsyco\",\n" + "  \"permission\": \"NORMAL\"\n" + "}";
        return apiUtils.buildAPICallPUT(driver, String.valueOf(driver.getAddress()) + ":" + driver.getPort() + "/mt/api/rest/v1/alarm", json);
    }
}

