/*
 * Decompiled with CFR 0.152.
 */
package drivers.avigilonweb;

import com.hsyco.driverBase;
import drivers.avigilonweb.Utils;
import drivers.avigilonweb.apiCalls;
import drivers.avigilonweb.apiUtils;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static int DEFAULTSOCKETPORT = 8443;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public String name = null;
    public String userNonce = null;
    public String userKey = null;
    public String username = null;
    public String password = null;
    private int pollingtime = 0;
    private long loopTimemillis = 0L;
    public String address = null;
    public String port = null;
    public String session = null;
    private Boolean genEvent = false;
    private String useSSL = "";
    private String startupevents = null;
    HashMap<String, String> nameIdMap = new HashMap();

    public String getUsernonce() {
        return this.userNonce;
    }

    public String getUserkey() {
        return this.userKey;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public boolean init(String name, HashMap<String, String> config) throws JSONException {
        super.init(name);
        this.name = name;
        this.loadConfig(config);
        this.address = this.useSSL == null || this.useSSL.equals("true") ? "https://" + this.address : "http://" + this.address;
        if (this.startupevents != null && this.startupevents.equals("true")) {
            this.genEvent = true;
        }
        if (this.pollingtime == 0) {
            this.pollingtime = 300;
        }
        if (this.port == null) {
            this.setPort(String.valueOf(DEFAULTSOCKETPORT));
        }
        if (this.isVerboseLog()) {
            this.messageLog(String.valueOf(name) + " - AVIGLION-WEB DRIVER STARTUP, " + " | genEvent: " + this.genEvent + " | pollingtime: " + this.pollingtime + " | port: " + this.port + " | host: " + this.address + " | userNonce: " + this.userNonce + " | userKey: " + this.userKey + " | username: " + this.username + " - driver version: 1.0");
        }
        if (this.userNonce == null || this.userKey == null || this.username == null || this.password == null) {
            this.sendErrorLog("Startup error: Some params are missing (Required params: userNonce, userKey, username, password)");
            this.genEvent = true;
            this.ioWrite("connection", "offline");
            return false;
        }
        try {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + " - AVIGLION-WEB DRIVER LOGS - Trusting certificate");
            }
            apiUtils.trustEveryone();
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(name) + " - AVIGLION-WEB DRIVER LOGS - Executing login function");
            }
            this.session = apiCalls.AvigilonLogin(this);
        }
        catch (Exception e2) {
            this.sendErrorLog("Startup error: " + e2.getMessage());
            this.genEvent = true;
            this.ioWrite("connection", "offline");
            return false;
        }
        return true;
    }

    public boolean loop() throws JSONException {
        try {
            long now = System.currentTimeMillis();
            long sleepTime = this.loopTimemillis + (long)this.pollingtime - now;
            if (sleepTime > 0L) {
                this.sleep(sleepTime);
                this.loopTimemillis += (long)this.pollingtime;
            } else {
                this.loopTimemillis = now;
            }
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + " - AVIGLION-WEB DRIVER LOGS - Getting alarms status");
            }
            JSONArray allAlarms = apiCalls.getAlarms(this);
            int i2 = 0;
            while (i2 < allAlarms.length()) {
                JSONObject o2;
                JSONObject alarmObj = o2 = allAlarms.getJSONObject(i2);
                String name = alarmObj.getString("name").replace(".", "_").replaceAll("\\s+", "_").toLowerCase();
                String state = alarmObj.getString("state");
                String alarmId = alarmObj.getString("id");
                String nameFixed = Utils.removeStrangeChars(name);
                if (nameFixed != null) {
                    if (!this.nameIdMap.containsKey(nameFixed)) {
                        this.nameIdMap.put(nameFixed, alarmId);
                    }
                    if (this.isVerboseLog()) {
                        this.messageLog(String.valueOf(nameFixed) + " - AVIGLION-WEB DRIVER LOGS - The alarm " + nameFixed + " is " + state);
                    }
                    this.ioWrite(String.valueOf(nameFixed) + ".state", state.toLowerCase());
                    if (state.equals("ACTIVE")) {
                        this.ioWrite(String.valueOf(nameFixed) + ".alarm", "1");
                    } else {
                        this.ioWrite(String.valueOf(nameFixed) + ".alarm", "0");
                    }
                    if (state.toLowerCase().contains("ack")) {
                        this.ioWrite(String.valueOf(nameFixed) + ".ack", "1");
                    } else {
                        this.ioWrite(String.valueOf(nameFixed) + ".ack", "0");
                    }
                }
                ++i2;
            }
            if (!this.genEvent.booleanValue()) {
                this.genEvent = true;
                this.ioWrite("connection", "online");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean end() throws JSONException {
        this.genEvent = true;
        this.ioWrite("connection", "offline");
        this.nameIdMap.clear();
        try {
            this.messageLog(String.valueOf(this.name) + " - AVIGLION-WEB DRIVER LOGS - Executing logout function");
            apiCalls.AvigilonLogout(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.genEvent.booleanValue()) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    private void loadConfig(HashMap<String, String> config) {
        try {
            this.userNonce = config.get("usernonce");
            this.userKey = config.get("userkey");
            this.username = config.get("username");
            this.password = config.get("password");
            this.address = config.get("host");
            this.port = config.get("port");
            this.startupevents = config.get("startupevents");
            this.useSSL = config.get("usessl");
            this.pollingtime = Integer.parseInt(config.get("pollingtime"));
        }
        catch (Exception e2) {
            this.sendErrorLog("WARN ioServersOption some params where ignored");
        }
    }

    public void sendErrorLog(String msg) {
        this.errorLog(String.valueOf(this.name) + ": " + msg);
    }

    public boolean verboseLog() {
        return this.isVerboseLog();
    }

    public void command(String name, String value) throws JSONException {
        if (name.contains("command")) {
            String[] fields = name.split("\\.");
            String alarmName = fields[0];
            String id = this.nameIdMap.get(alarmName);
            if (value.equalsIgnoreCase("ack")) {
                try {
                    boolean success = apiCalls.ackAlarm(this, id);
                    if (!success) {
                        this.sendErrorLog("ERROR ack to " + alarmName + " failed");
                    }
                }
                catch (Exception e2) {
                    this.sendErrorLog("Exception in request ackAlarm: " + e2.toString());
                }
            } else if (value.equalsIgnoreCase("trigger")) {
                try {
                    boolean success = apiCalls.triggerAlarm(this, id);
                    if (!success) {
                        this.sendErrorLog("ERROR trigger to " + alarmName + " failed");
                    }
                }
                catch (Exception e3) {
                    this.sendErrorLog("Exception in request triggerAlarm: " + e3.toString());
                }
            }
        }
    }
}

