/*
 * Decompiled with CFR 0.152.
 */
package drivers.artecoio;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    public static final String[] WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage"};
    private InetSocketAddress address = null;
    private String user = null;
    private String password = null;
    private boolean inputdiscovery = false;
    private boolean outputdiscovery = true;
    private int inputs = 8;
    private int outputs = 8;
    private boolean startupevents = false;
    private Socket sock;
    private BufferedReader in = null;
    private BufferedWriter out = null;
    private boolean header = false;
    private boolean initialized = false;
    private Boolean[] inputState = new Boolean[this.inputs];
    private Boolean[] outputState = new Boolean[this.outputs];

    public boolean init(String name, HashMap<String, String> config) {
        block14: {
            super.init(name);
            try {
                int n2;
                this.address = new InetSocketAddress(config.get("host"), Integer.parseInt(config.get("port")));
                String s = config.get("user");
                this.user = s == null ? "admin" : s;
                s = config.get("password");
                this.password = s == null ? "arteco" : s;
                s = config.get("inputdiscovery");
                if (s != null) {
                    this.inputdiscovery = Boolean.parseBoolean(s);
                }
                if ((s = config.get("outputdiscovery")) != null) {
                    this.outputdiscovery = Boolean.parseBoolean(s);
                }
                if ((s = config.get("inputs")) != null) {
                    try {
                        n2 = Integer.parseInt(s);
                        if (n2 >= 0 && n2 <= 8) {
                            this.inputs = n2;
                        }
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + name + "] - inputs ignored");
                    }
                }
                if ((s = config.get("outputs")) != null) {
                    try {
                        n2 = Integer.parseInt(s);
                        if (n2 >= 0 && n2 <= 8) {
                            this.outputs = n2;
                        }
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + name + "] - outputs ignored");
                    }
                }
                if ((s = config.get("startupevents")) != null) {
                    this.startupevents = Boolean.parseBoolean(s);
                }
                if (this.deviceCheck()) break block14;
                return false;
            }
            catch (Exception e4) {
                return false;
            }
        }
        this.deviceDiscovery();
        this.sock = new Socket();
        this.sock.connect(this.address, 6000);
        this.sock.setSoTimeout(30000);
        this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream()));
        this.out.write("GET /io.cgi?check HTTP/1.1\r\n");
        this.out.write("Host: ");
        this.out.write(this.address.getHostName());
        this.out.write(58);
        this.out.write(Integer.toString(this.address.getPort()));
        this.out.write("\r\n");
        this.out.write("Connection: keep-alive\r\n");
        this.out.write("Authorization: Basic " + Base64.encodeBase64String((String.valueOf(this.user) + ":" + this.password).getBytes()));
        this.out.write("\r\n\r\n");
        this.out.flush();
        return true;
    }

    public boolean loop() {
        String line;
        block33: {
            block35: {
                block34: {
                    line = this.in.readLine();
                    if (!this.header) break block33;
                    if (!line.startsWith("O")) break block34;
                    int i2 = Integer.parseInt(line.substring(1, line.length() - 1));
                    String fullname = "o" + i2;
                    if (line.endsWith("H")) {
                        if (this.outputState[i2] == null || !this.outputState[i2].booleanValue()) {
                            this.outputState[i2] = true;
                            if (this.outputdiscovery) {
                                this.deviceSet(100, fullname, "1", null);
                            }
                            if (this.initialized || this.startupevents) {
                                this.ioWrite(fullname, "1");
                            } else {
                                this.ioWriteNoEvents(fullname, "1");
                            }
                        }
                    } else if (line.endsWith("L") && (this.outputState[i2] == null || this.outputState[i2].booleanValue())) {
                        this.outputState[i2] = false;
                        if (this.outputdiscovery) {
                            this.deviceSet(100, fullname, "0", null);
                        }
                        if (this.initialized || this.startupevents) {
                            this.ioWrite(fullname, "0");
                        } else {
                            this.ioWriteNoEvents(fullname, "0");
                        }
                    }
                    return false;
                }
                if (!line.startsWith("I")) break block35;
                int i3 = Integer.parseInt(line.substring(1, line.length() - 1));
                String fullname = "i" + i3;
                if (line.endsWith("H")) {
                    if (this.inputState[i3] == null || !this.inputState[i3].booleanValue()) {
                        this.inputState[i3] = true;
                        if (this.inputdiscovery) {
                            this.deviceSet(100, fullname, "1", null);
                        }
                        if (this.initialized || this.startupevents) {
                            this.ioWrite(fullname, "1");
                        } else {
                            this.ioWriteNoEvents(fullname, "1");
                        }
                    }
                } else if (line.endsWith("L") && (this.inputState[i3] == null || this.inputState[i3].booleanValue())) {
                    this.inputState[i3] = false;
                    if (this.inputdiscovery) {
                        this.deviceSet(100, fullname, "0", null);
                    }
                    if (this.initialized || this.startupevents) {
                        this.ioWrite(fullname, "0");
                    } else {
                        this.ioWriteNoEvents(fullname, "0");
                    }
                }
                return false;
            }
            try {
                if (line.startsWith("--Arteco")) {
                    if (!this.initialized) {
                        this.initialized = true;
                        int i4 = 0;
                        while (i4 < this.inputs) {
                            if (this.inputState[i4] == null) {
                                this.initialized = false;
                                break;
                            }
                            ++i4;
                        }
                        i4 = 0;
                        while (i4 < this.outputs) {
                            if (this.outputState[i4] == null) {
                                this.initialized = false;
                                break;
                            }
                            ++i4;
                        }
                        if (this.initialized) {
                            this.ioWrite("connection", "online");
                        }
                    }
                    return this.initialized;
                }
                return false;
            }
            catch (Exception e2) {
                this.sleep(1000L);
                return false;
            }
        }
        if (line.startsWith("--Arteco")) {
            this.header = true;
            return false;
        }
        return false;
    }

    public boolean end() {
        if (this.initialized) {
            this.ioWrite("connection", "offline");
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void command(String name, String value) {
        block34: {
            try {
                int c2;
                String NAME;
                if (!this.initialized || !(NAME = name.toUpperCase()).startsWith("O") || (c2 = Integer.parseInt(name.substring(1))) < 0 || c2 >= this.outputs) break block34;
                String command = value.equals("0") || value.equalsIgnoreCase("off") ? "reset" : (value.equals("1") || value.equalsIgnoreCase("on") ? "set" : (value.equalsIgnoreCase("flip") ? "toggle" : value.toLowerCase()));
                boolean done = false;
                int r = 0;
                while (r < 4 && !done) {
                    block36: {
                        Socket sockc = new Socket();
                        BufferedReader inc = null;
                        BufferedWriter outc = null;
                        try {
                            try {
                                String line;
                                sockc.connect(this.address, 6000);
                                sockc.setSoTimeout(6000);
                                inc = new BufferedReader(new InputStreamReader(sockc.getInputStream()));
                                outc = new BufferedWriter(new OutputStreamWriter(sockc.getOutputStream()));
                                outc.write("GET /monitor.cgi?" + command + "=" + c2 + " HTTP/1.1\r\n");
                                outc.write("Host: ");
                                outc.write(this.address.getHostName());
                                outc.write(58);
                                outc.write(Integer.toString(this.address.getPort()));
                                outc.write("\r\n");
                                outc.write("Connection: keep-alive\r\n");
                                outc.write("Authorization: Basic " + Base64.encodeBase64String((String.valueOf(this.user) + ":" + this.password).getBytes()));
                                outc.write("\r\n\r\n");
                                outc.flush();
                                while ((line = inc.readLine()) != null) {
                                    String fullname;
                                    int i2;
                                    if (line.startsWith("O")) {
                                        i2 = Integer.parseInt(line.substring(1, line.length() - 1));
                                        fullname = "o" + i2;
                                        if (line.endsWith("H")) {
                                            if (this.outputState[i2] != null && this.outputState[i2].booleanValue()) continue;
                                            this.outputState[i2] = true;
                                            if (this.outputdiscovery) {
                                                this.deviceSet(100, fullname, "1", null);
                                            }
                                            this.ioWrite(fullname, "1");
                                            continue;
                                        }
                                        if (!line.endsWith("L") || this.outputState[i2] != null && !this.outputState[i2].booleanValue()) continue;
                                        this.outputState[i2] = false;
                                        if (this.outputdiscovery) {
                                            this.deviceSet(100, fullname, "0", null);
                                        }
                                        this.ioWrite(fullname, "0");
                                        continue;
                                    }
                                    if (line.startsWith("I")) {
                                        i2 = Integer.parseInt(line.substring(1, line.length() - 1));
                                        fullname = "i" + i2;
                                        if (line.endsWith("H")) {
                                            if (this.inputState[i2] != null && this.inputState[i2].booleanValue()) continue;
                                            this.inputState[i2] = true;
                                            if (this.inputdiscovery) {
                                                this.deviceSet(100, fullname, "1", null);
                                            }
                                            this.ioWrite(fullname, "1");
                                            continue;
                                        }
                                        if (!line.endsWith("L") || this.inputState[i2] != null && !this.inputState[i2].booleanValue()) continue;
                                        this.inputState[i2] = false;
                                        if (this.inputdiscovery) {
                                            this.deviceSet(100, fullname, "0", null);
                                        }
                                        this.ioWrite(fullname, "0");
                                        continue;
                                    }
                                    if (!line.startsWith("--Arteco")) continue;
                                    done = true;
                                }
                            }
                            catch (Exception exception) {
                                try {
                                    inc.close();
                                }
                                catch (Exception exception2) {
                                    // empty catch block
                                }
                                try {
                                    outc.close();
                                }
                                catch (Exception exception3) {
                                    // empty catch block
                                }
                                try {
                                    sockc.close();
                                }
                                catch (Exception exception4) {}
                                break block36;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                inc.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                outc.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                sockc.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            inc.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            outc.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            sockc.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++r;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean deviceCheck() {
        String line;
        boolean header = false;
        Socket sockd = new Socket();
        BufferedReader ind = null;
        BufferedWriter outd = null;
        sockd.connect(this.address, 6000);
        sockd.setSoTimeout(6000);
        ind = new BufferedReader(new InputStreamReader(sockd.getInputStream()));
        outd = new BufferedWriter(new OutputStreamWriter(sockd.getOutputStream()));
        outd.write("GET /monitor.cgi?check HTTP/1.1\r\n");
        outd.write("Host: ");
        outd.write(this.address.getHostName());
        outd.write(58);
        outd.write(Integer.toString(this.address.getPort()));
        outd.write("\r\n");
        outd.write("Connection: keep-alive\r\n");
        outd.write("Authorization: Basic " + Base64.encodeBase64String((String.valueOf(this.user) + ":" + this.password).getBytes()));
        outd.write("\r\n\r\n");
        outd.flush();
        while ((line = ind.readLine()) != null) {
            if (!line.startsWith("--Arteco")) continue;
            header = true;
        }
        boolean bl = header;
        try {
            ind.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            outd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sockd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
        catch (Exception e2) {
            try {
                ind.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                outd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sockd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    ind.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    outd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    sockd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void deviceDiscovery() {
        String fullname;
        int i2;
        if (this.inputdiscovery) {
            this.enableSystemtopoDiscovery();
            i2 = 0;
            while (i2 < this.inputs) {
                fullname = "i" + i2;
                this.deviceSet(100, fullname, null, "INPUT " + i2);
                ++i2;
            }
        }
        if (this.outputdiscovery) {
            this.enableSystemtopoDiscovery();
            i2 = 0;
            while (i2 < this.outputs) {
                fullname = "o" + i2;
                this.deviceSet(100, fullname, null, "OUTPUT " + i2);
                ++i2;
            }
        }
    }
}

