/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model.rule;

import com.philips.lighting.model.rule.PHRuleCondition;

public class PHSimpleRuleCondition
extends PHRuleCondition {
    private String resourceIdentifier = null;
    private PHSimpleRuleAttributeName attributeName = null;

    public PHSimpleRuleCondition(String resourceIdentifier, PHSimpleRuleAttributeName attributeName, PHRuleCondition.PHRuleConditionOperator operator2, Object value) {
        this.address = attributeName.isForBridgeConfiguration() ? attributeName.getAddressTemplate() : String.format(attributeName.getAddressTemplate(), resourceIdentifier);
        this.attributeName = attributeName;
        this.resourceIdentifier = resourceIdentifier;
        this.operator = operator2;
        if (this.operator != PHRuleCondition.PHRuleConditionOperator.OPERATOR_DX) {
            this.value = value;
        }
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public PHSimpleRuleAttributeName getAttributeName() {
        return this.attributeName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        result = 31 * result + (this.resourceIdentifier == null ? 0 : this.resourceIdentifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHSimpleRuleCondition other = (PHSimpleRuleCondition)obj;
        if (this.attributeName != other.attributeName) {
            return false;
        }
        return !(this.resourceIdentifier == null ? other.resourceIdentifier != null : !this.resourceIdentifier.equals(other.resourceIdentifier));
    }

    public static enum PHSimpleRuleAttributeName {
        ATTRIBUTE_CONFIG_UTC("/config/UTC", String.class),
        ATTRIBUTE_CONFIG_LOCALTIME("/config/localtime", String.class),
        ATTRIBUTE_SENSOR_STATE_LASTUPDATED("/sensors/%s/state/lastupdated", String.class),
        ATTRIBUTE_SENSOR_STATE_TEMPERATURE("/sensors/%s/state/temperature", Integer.TYPE),
        ATTRIBUTE_SENSOR_STATE_HUMIDITY("/sensors/%s/state/humidity", Integer.TYPE),
        ATTRIBUTE_SENSOR_STATE_DAYLIGHT("/sensors/%s/state/daylight", Boolean.TYPE),
        ATTRIBUTE_SENSOR_STATE_PRESENCE("/sensors/%s/state/presence", Boolean.TYPE),
        ATTRIBUTE_SENSOR_STATE_BUTTONEVENT("/sensors/%s/state/buttonevent", Integer.TYPE),
        ATTRIBUTE_SENSOR_STATE_OPEN("/sensors/%s/state/open", Boolean.TYPE),
        ATTRIBUTE_SENSOR_STATE_FLAG("/sensors/%s/state/flag", Boolean.TYPE),
        ATTRIBUTE_SENSOR_STATE_STATUS("/sensors/%s/state/status", Integer.TYPE),
        ATTRIBUTE_SENSOR_CONFIG_BATTERY("/sensors/%s/config/battery", Integer.TYPE),
        ATTRIBUTE_SENSOR_CONFIG_REACHABLE("/sensors/%s/config/reachable", Boolean.TYPE),
        ATTRIBUTE_SENSOR_CONFIG_ON("/sensors/%s/config/on", Boolean.TYPE),
        ATTRIBUTE_SENSOR_CONFIG_SUNRISEOFFSET("/sensors/%s/config/sunriseoffset", Integer.TYPE),
        ATTRIBUTE_SENSOR_CONFIG_SUNSETOFFSET("/sensors/%s/config/sunsetoffset", Integer.TYPE),
        ATTRIBUTE_SENSOR_CONFIG_MOTIONSENSITIVITY("/sensors/%s/config/motionsensitivity", Integer.TYPE),
        ATTRIBUTE_SENSOR_CONFIG_RADIUS("/sensors/%s/config/radius", Integer.TYPE);

        private String addressTemplate;
        private Class type;

        private PHSimpleRuleAttributeName(String addressTemplate, Class type) {
            this.addressTemplate = addressTemplate;
            this.type = type;
        }

        public String getAddressTemplate() {
            return this.addressTemplate;
        }

        public Class getType() {
            return this.type;
        }

        public static PHSimpleRuleAttributeName getByAddressTemplate(String template) {
            for (PHSimpleRuleAttributeName attrName : PHSimpleRuleAttributeName.values()) {
                if (!attrName.getAddressTemplate().equals(template)) continue;
                return attrName;
            }
            return null;
        }

        public boolean isForBridgeConfiguration() {
            return this.equals((Object)ATTRIBUTE_CONFIG_LOCALTIME) || this.equals((Object)ATTRIBUTE_CONFIG_UTC);
        }
    }
}

