/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.model;

import com.philips.lighting.model.PHBridgeResource;
import com.philips.lighting.model.PHLightState;
import java.util.Locale;

public class PHLight
extends PHBridgeResource {
    private static final String STR_ON_OFF = "on/off light";
    private static final String STR_ON_OFF_PLUGIN = "on/off plug-in unit";
    private static final String STR_DIMABLE = "dimmable light";
    private static final String STR_DIMABLE_PLUGIN = "dimmable plug-in unit";
    private static final String STR_COLOR_LIGHT = "color light";
    private static final String STR_CT_COLOR = "ctcolor light";
    private static final String STR_EXTENDED_COLOR = "extended color light";
    private static final String STR_CT_LIGHT = "ct light";
    private static final String STR_COLOR_TEMPERATURE = "color temperature light";
    private PHLightType type;
    private String versionNumber;
    private String modelNumber;
    private String manufacturerName;
    private String uniqueId;
    private String luminaireUniqueId;
    private PHLightState lastKnownLightState = null;

    public PHLight(String name, String identifier, String versionNumber, String modelNumber) {
        super(name, identifier);
        this.versionNumber = versionNumber;
        this.modelNumber = modelNumber;
    }

    public PHLight(PHLight light) {
        super(PHLight.isNull(light).getName(), PHLight.isNull(light).getIdentifier());
        this.lastKnownLightState = light.lastKnownLightState;
        this.modelNumber = light.modelNumber;
        this.type = light.type;
        this.versionNumber = light.versionNumber;
    }

    public PHLightType getLightType() {
        return this.type;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public PHLightState getLastKnownLightState() {
        return this.lastKnownLightState;
    }

    public void setLastKnownLightState(PHLightState lastKnownLightState) {
        this.lastKnownLightState = lastKnownLightState;
    }

    public boolean supportsColor() {
        switch (this.type) {
            case CT_COLOR_LIGHT: 
            case COLOR_LIGHT: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCT() {
        switch (this.type) {
            case CT_COLOR_LIGHT: 
            case CT_LIGHT: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsBrightness() {
        switch (this.type) {
            case ON_OFF_LIGHT: {
                return false;
            }
        }
        return true;
    }

    public void setLightType(String lightType) {
        this.type = lightType == null ? PHLightType.CT_COLOR_LIGHT : ((lightType = lightType.toLowerCase(Locale.US)).equals(STR_ON_OFF) || lightType.equals(STR_ON_OFF_PLUGIN) ? PHLightType.ON_OFF_LIGHT : (lightType.equals(STR_DIMABLE) || lightType.equals(STR_DIMABLE_PLUGIN) ? PHLightType.DIM_LIGHT : (lightType.equals(STR_COLOR_LIGHT) ? PHLightType.COLOR_LIGHT : (lightType.equals(STR_CT_COLOR) || lightType.equals(STR_EXTENDED_COLOR) ? PHLightType.CT_COLOR_LIGHT : (lightType.equals(STR_CT_LIGHT) || lightType.equals(STR_COLOR_TEMPERATURE) ? PHLightType.CT_LIGHT : PHLightType.ON_OFF_LIGHT)))));
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String toString() {
        String light = "Identifier: " + this.getIdentifier() + "\n";
        light = light + "Name: " + this.getName() + "\n";
        switch (this.type) {
            case COLOR_LIGHT: {
                light = light + "type: COLOR_LIGHT\n";
                break;
            }
            case CT_LIGHT: {
                light = light + "type: CT_LIGHT\n";
                break;
            }
            case CT_COLOR_LIGHT: {
                light = light + "type: CT_COLOR_LIGHT\n";
                break;
            }
            case DIM_LIGHT: {
                light = light + "type: DIM_LIGHT\n";
                break;
            }
            case ON_OFF_LIGHT: {
                light = light + "type: ON_OFF_LIGHT\n";
                break;
            }
            default: {
                light = light + "type: UNKNOWN\n";
            }
        }
        return light;
    }

    public String getLuminaireUniqueId() {
        return this.luminaireUniqueId;
    }

    public void setLuminaireUniqueId(String luminaireUniqueId) {
        this.luminaireUniqueId = luminaireUniqueId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.lastKnownLightState == null ? 0 : this.lastKnownLightState.hashCode());
        result = 31 * result + (this.modelNumber == null ? 0 : this.modelNumber.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.versionNumber == null ? 0 : this.versionNumber.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHLight other = (PHLight)obj;
        if (this.lastKnownLightState == null ? other.lastKnownLightState != null : !this.lastKnownLightState.equals(other.lastKnownLightState)) {
            return false;
        }
        if (this.modelNumber == null ? other.modelNumber != null : !this.modelNumber.equals(other.modelNumber)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.versionNumber == null ? other.versionNumber != null : !this.versionNumber.equals(other.versionNumber));
    }

    private static PHLight isNull(PHLight light) {
        if (light == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        return light;
    }

    public static enum PHLightEffectMode {
        EFFECT_UNKNOWN(null),
        EFFECT_NONE("none"),
        EFFECT_COLORLOOP("colorloop");

        private String value;

        private PHLightEffectMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PHLightEffectMode fromString(String value) {
            if (value.equals(EFFECT_COLORLOOP.getValue())) {
                return EFFECT_COLORLOOP;
            }
            if (value.equals(EFFECT_NONE.getValue())) {
                return EFFECT_NONE;
            }
            return EFFECT_UNKNOWN;
        }
    }

    public static enum PHLightAlertMode {
        ALERT_UNKNOWN(null),
        ALERT_NONE("none"),
        ALERT_SELECT("select"),
        ALERT_LSELECT("lselect");

        private String value;

        private PHLightAlertMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PHLightAlertMode fromString(String value) {
            if (value.equals(ALERT_SELECT.getValue())) {
                return ALERT_SELECT;
            }
            if (value.equals(ALERT_LSELECT.getValue())) {
                return ALERT_LSELECT;
            }
            if (value.equals(ALERT_NONE.getValue())) {
                return ALERT_NONE;
            }
            return ALERT_UNKNOWN;
        }
    }

    public static enum PHLightColorMode {
        COLORMODE_UNKNOWN(null),
        COLORMODE_NONE("none"),
        COLORMODE_CT("ct"),
        COLORMODE_HUE_SATURATION("hs"),
        COLORMODE_XY("xy");

        private String value;

        private PHLightColorMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PHLightColorMode fromString(String value) {
            if (value.equals(COLORMODE_CT.getValue())) {
                return COLORMODE_CT;
            }
            if (value.equals(COLORMODE_HUE_SATURATION.getValue())) {
                return COLORMODE_HUE_SATURATION;
            }
            if (value.equals(COLORMODE_XY.getValue())) {
                return COLORMODE_XY;
            }
            if (value.equals(COLORMODE_NONE.getValue())) {
                return COLORMODE_NONE;
            }
            return COLORMODE_UNKNOWN;
        }
    }

    public static enum PHLightType {
        UNKNOWN_LIGHT,
        CT_COLOR_LIGHT,
        COLOR_LIGHT,
        CT_LIGHT,
        DIM_LIGHT,
        ON_OFF_LIGHT;

    }
}

