/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.utilities.impl;

import com.philips.lighting.hue.sdk.utilities.impl.Color;
import com.philips.lighting.hue.sdk.utilities.impl.PHHueHelper;
import com.philips.lighting.hue.sdk.utilities.impl.PointF;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PHUtilitiesHelper {
    private static final int CPT_RED = 0;
    private static final int CPT_GREEN = 1;
    private static final int CPT_BLUE = 2;

    public int colorFromXY(float[] points, String model) {
        if (points == null || model == null) {
            throw new IllegalArgumentException("Input parameter can't be null");
        }
        PointF xy = new PointF(points[0], points[1]);
        List<PointF> colorPoints = this.colorPointsForModel(model);
        boolean inReachOfLamps = this.checkPointInLampsReach(xy, colorPoints);
        if (!inReachOfLamps) {
            PointF pAB = this.getClosestPointToPoints(colorPoints.get(0), colorPoints.get(1), xy);
            PointF pAC = this.getClosestPointToPoints(colorPoints.get(2), colorPoints.get(0), xy);
            PointF pBC = this.getClosestPointToPoints(colorPoints.get(1), colorPoints.get(2), xy);
            float dAB = this.getDistanceBetweenTwoPoints(xy, pAB);
            float dAC = this.getDistanceBetweenTwoPoints(xy, pAC);
            float dBC = this.getDistanceBetweenTwoPoints(xy, pBC);
            float lowest = dAB;
            PointF closestPoint = pAB;
            if (dAC < lowest) {
                lowest = dAC;
                closestPoint = pAC;
            }
            if (dBC < lowest) {
                lowest = dBC;
                closestPoint = pBC;
            }
            xy.x = closestPoint.x;
            xy.y = closestPoint.y;
        }
        float x = xy.x;
        float y = xy.y;
        float z = 1.0f - x - y;
        float y2 = 1.0f;
        float x2 = y2 / y * x;
        float z2 = y2 / y * z;
        float r = x2 * 3.2406f - y2 * 1.5372f - z2 * 0.4986f;
        float g2 = -x2 * 0.9689f + y2 * 1.8758f + z2 * 0.0415f;
        float b2 = x2 * 0.0557f - y2 * 0.204f + z2 * 1.057f;
        if (r > b2 && r > g2 && r > 1.0f) {
            g2 /= r;
            b2 /= r;
            r = 1.0f;
        } else if (g2 > b2 && g2 > r && g2 > 1.0f) {
            r /= g2;
            b2 /= g2;
            g2 = 1.0f;
        } else if (b2 > r && b2 > g2 && b2 > 1.0f) {
            r /= b2;
            g2 /= b2;
            b2 = 1.0f;
        }
        r = r <= 0.0031308f ? 12.92f * r : 1.055f * (float)Math.pow(r, 0.4166666567325592) - 0.055f;
        g2 = g2 <= 0.0031308f ? 12.92f * g2 : 1.055f * (float)Math.pow(g2, 0.4166666567325592) - 0.055f;
        float f2 = b2 = b2 <= 0.0031308f ? 12.92f * b2 : 1.055f * (float)Math.pow(b2, 0.4166666567325592) - 0.055f;
        if (r > b2 && r > g2) {
            if (r > 1.0f) {
                g2 /= r;
                b2 /= r;
                r = 1.0f;
            }
        } else if (g2 > b2 && g2 > r) {
            if (g2 > 1.0f) {
                r /= g2;
                b2 /= g2;
                g2 = 1.0f;
            }
        } else if (b2 > r && b2 > g2 && b2 > 1.0f) {
            r /= b2;
            g2 /= b2;
            b2 = 1.0f;
        }
        if (r < 0.0f) {
            r = 0.0f;
        }
        if (g2 < 0.0f) {
            g2 = 0.0f;
        }
        if (b2 < 0.0f) {
            b2 = 0.0f;
        }
        int r1 = (int)(r * 255.0f);
        int g1 = (int)(g2 * 255.0f);
        int b1 = (int)(b2 * 255.0f);
        return Color.rgb(r1, g1, b1);
    }

    public float[] calculateXYFromRGB(int red, int green, int blue, String model) {
        int rgb = Color.rgb(red, green, blue);
        return this.calculateXY(rgb, model);
    }

    public float[] calculateXY(int color, String model) {
        List<PointF> colorPoints;
        PointF xyPoint;
        boolean inReachOfLamps;
        float z;
        float y;
        float b2;
        float g2;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        red = (float)Color.red(color) / 255.0f;
        float r = red > 0.04045f ? (float)Math.pow((red + 0.055f) / 1.055f, 2.4f) : red / 12.92f;
        float x = r * 0.649926f + (g2 = (green = (float)Color.green(color) / 255.0f) > 0.04045f ? (float)Math.pow((green + 0.055f) / 1.055f, 2.4f) : green / 12.92f) * 0.103455f + (b2 = (blue = (float)Color.blue(color) / 255.0f) > 0.04045f ? (float)Math.pow((blue + 0.055f) / 1.055f, 2.4f) : blue / 12.92f) * 0.197109f;
        float[] xy = new float[]{x / (x + (y = r * 0.234327f + g2 * 0.743075f + b2 * 0.022598f) + (z = r * 0.0f + g2 * 0.053077f + b2 * 1.035763f)), y / (x + y + z)};
        if (Float.isNaN(xy[0])) {
            xy[0] = 0.0f;
        }
        if (Float.isNaN(xy[1])) {
            xy[1] = 0.0f;
        }
        if (!(inReachOfLamps = this.checkPointInLampsReach(xyPoint = new PointF(xy[0], xy[1]), colorPoints = this.colorPointsForModel(model)))) {
            PointF pAB = this.getClosestPointToPoints(colorPoints.get(0), colorPoints.get(1), xyPoint);
            PointF pAC = this.getClosestPointToPoints(colorPoints.get(2), colorPoints.get(0), xyPoint);
            PointF pBC = this.getClosestPointToPoints(colorPoints.get(1), colorPoints.get(2), xyPoint);
            float dAB = this.getDistanceBetweenTwoPoints(xyPoint, pAB);
            float dAC = this.getDistanceBetweenTwoPoints(xyPoint, pAC);
            float dBC = this.getDistanceBetweenTwoPoints(xyPoint, pBC);
            float lowest = dAB;
            PointF closestPoint = pAB;
            if (dAC < lowest) {
                lowest = dAC;
                closestPoint = pAC;
            }
            if (dBC < lowest) {
                lowest = dBC;
                closestPoint = pBC;
            }
            xy[0] = closestPoint.x;
            xy[1] = closestPoint.y;
        }
        xy[0] = PHHueHelper.precision(xy[0]);
        xy[1] = PHHueHelper.precision(xy[1]);
        return xy;
    }

    private boolean checkPointInLampsReach(PointF point, List<PointF> colorPoints) {
        if (point == null || colorPoints == null) {
            return false;
        }
        PointF red = colorPoints.get(0);
        PointF green = colorPoints.get(1);
        PointF blue = colorPoints.get(2);
        PointF v1 = new PointF(green.x - red.x, green.y - red.y);
        PointF v2 = new PointF(blue.x - red.x, blue.y - red.y);
        PointF q = new PointF(point.x - red.x, point.y - red.y);
        float s = this.crossProduct(q, v2) / this.crossProduct(v1, v2);
        float t = this.crossProduct(v1, q) / this.crossProduct(v1, v2);
        return s >= 0.0f && t >= 0.0f && s + t <= 1.0f;
    }

    private float getDistanceBetweenTwoPoints(PointF one, PointF two) {
        float dx = one.x - two.x;
        float dy = one.y - two.y;
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    private float crossProduct(PointF point1, PointF point2) {
        return point1.x * point2.y - point1.y * point2.x;
    }

    private List<PointF> colorPointsForModel(String model) {
        if (model == null) {
            model = " ";
        }
        ArrayList<PointF> colorPoints = new ArrayList<PointF>();
        ArrayList<String> multiSourceLuminaires = new ArrayList<String>();
        multiSourceLuminaires.add("HBL001");
        multiSourceLuminaires.add("HBL002");
        multiSourceLuminaires.add("HBL003");
        multiSourceLuminaires.add("HIL001");
        multiSourceLuminaires.add("HIL002");
        multiSourceLuminaires.add("HEL001");
        multiSourceLuminaires.add("HEL002");
        if (multiSourceLuminaires.contains(model)) {
            model = "LLM001";
        }
        ArrayList<String> hueBulbs = new ArrayList<String>();
        hueBulbs.add("LCT001");
        hueBulbs.add("LCT002");
        hueBulbs.add("LCT003");
        hueBulbs.add("LLM001");
        hueBulbs.add("LCT005");
        hueBulbs.add("LCT006");
        ArrayList<String> livingColors = new ArrayList<String>();
        livingColors.add("LLC001");
        livingColors.add("LLC005");
        livingColors.add("LLC006");
        livingColors.add("LLC007");
        livingColors.add("LLC010");
        livingColors.add("LLC011");
        livingColors.add("LLC012");
        livingColors.add("LLC014");
        livingColors.add("LLC013");
        livingColors.add("LST001");
        if (hueBulbs.contains(model)) {
            colorPoints.add(new PointF(0.674f, 0.322f));
            colorPoints.add(new PointF(0.408f, 0.517f));
            colorPoints.add(new PointF(0.168f, 0.041f));
        } else if (livingColors.contains(model)) {
            colorPoints.add(new PointF(0.703f, 0.296f));
            colorPoints.add(new PointF(0.214f, 0.709f));
            colorPoints.add(new PointF(0.139f, 0.081f));
        } else {
            colorPoints.add(new PointF(1.0f, 0.0f));
            colorPoints.add(new PointF(0.0f, 1.0f));
            colorPoints.add(new PointF(0.0f, 0.0f));
        }
        return colorPoints;
    }

    private PointF getClosestPointToPoints(PointF pointA, PointF pointB, PointF pointP) {
        if (pointA == null || pointB == null || pointP == null) {
            return null;
        }
        PointF pointAP = new PointF(pointP.x - pointA.x, pointP.y - pointA.y);
        PointF pointAB = new PointF(pointB.x - pointA.x, pointB.y - pointA.y);
        float apAb = pointAP.x * pointAB.x + pointAP.y * pointAB.y;
        float ab2 = pointAB.x * pointAB.x + pointAB.y * pointAB.y;
        float t = apAb / ab2;
        if (t < 0.0f) {
            t = 0.0f;
        } else if (t > 1.0f) {
            t = 1.0f;
        }
        PointF newPoint = new PointF(pointA.x + pointAB.x * t, pointA.y + pointAB.y * t);
        return newPoint;
    }

    public Date stringToDate(String dateString) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = null;
        try {
            date = dateFormate.parse(dateString);
        }
        catch (ParseException e2) {
            return null;
        }
        return date;
    }
}

