/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.model.sensor.PHTemperatureSensor;
import com.philips.lighting.model.sensor.PHTemperatureSensorConfiguration;
import com.philips.lighting.model.sensor.PHTemperatureSensorState;
import org.json.hue.JSONObject;

public class PHTemperatureSensorSerializer1
extends PHSensorSerializerBase1 {
    public static PHTemperatureSensor createFromJSON(JSONObject json, String identifier) {
        PHTemperatureSensor.Type type = PHTemperatureSensor.Type.CLIP;
        String sType = json.optString("type");
        if (sType != null && sType.equals(PHTemperatureSensor.Type.ZLL.getValue())) {
            type = PHTemperatureSensor.Type.ZLL;
        }
        PHTemperatureSensor sensor = new PHTemperatureSensor("", identifier, type);
        sensor = (PHTemperatureSensor)PHTemperatureSensorSerializer1.fillBasicSensor(sensor, json);
        sensor = PHTemperatureSensorSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHTemperatureSensorSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHTemperatureSensor createStateFromJSON(JSONObject json, PHTemperatureSensor sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHTemperatureSensorState state = new PHTemperatureSensorState();
            state = (PHTemperatureSensorState)PHTemperatureSensorSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("temperature")) {
                int parsedTemperature = sensorStateObject.optInt("temperature");
                state.setTemperature(parsedTemperature);
            } else {
                state.setTemperature(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHTemperatureSensor createConfigurationFromJSON(JSONObject json, PHTemperatureSensor sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHTemperatureSensorConfiguration config = new PHTemperatureSensorConfiguration();
            config = (PHTemperatureSensorConfiguration)PHTemperatureSensorSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHTemperatureSensor sensor) {
        JSONObject json = PHTemperatureSensorSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHTemperatureSensorSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHTemperatureSensorSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHTemperatureSensorState state) {
        if (state != null) {
            JSONObject json = PHTemperatureSensorSerializer1.getJSONSensorStateBase(state);
            String type = sensorObj.getString("type");
            if (!type.equals(PHTemperatureSensor.Type.ZLL.getValue())) {
                json.putOpt("temperature", state.getTemperature());
            }
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHTemperatureSensorConfiguration config) {
        if (config != null) {
            JSONObject json = PHTemperatureSensorSerializer1.getJSONSensorConfigurationBase(config);
            String type = sensorObj.getString("type");
            if (type.equals(PHTemperatureSensor.Type.ZLL.getValue())) {
                json.remove("battery");
            }
            sensorObj.put("config", json);
        }
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHTemperatureSensor sensor) {
        JSONObject sensorObj = PHTemperatureSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHTemperatureSensor sensor) {
        JSONObject sensorObj = PHTemperatureSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

