/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.hue.sdk.utilities.impl.PointD;
import com.philips.lighting.hue.sdk.utilities.impl.RectangleD;
import com.philips.lighting.model.sensor.PHSwitch;
import com.philips.lighting.model.sensor.PHSwitchConfiguration;
import com.philips.lighting.model.sensor.PHSwitchState;
import com.philips.lighting.model.sensor.metadata.PHSwitchButtonActionPair;
import com.philips.lighting.model.sensor.metadata.PHSwitchButtonInfo;
import com.philips.lighting.model.sensor.metadata.PHSwitchDeviceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.hue.JSONObject;

public class PHSwitchSerializer1
extends PHSensorSerializerBase1 {
    public static List<PHSwitchDeviceInfo> getKnowledgeBase() {
        ArrayList<PHSwitchDeviceInfo> knowledgeBase = new ArrayList<PHSwitchDeviceInfo>();
        ArrayList<Long> srcIdStartList = new ArrayList<Long>();
        srcIdStartList.add(0x400000L);
        ArrayList<Long> srcIdEndList = new ArrayList<Long>();
        srcIdEndList.add(4195327L);
        PHSwitchDeviceInfo tapDev1 = new PHSwitchDeviceInfo("hue TAP dev", "SWT001-DEV", "Philips", srcIdStartList, srcIdEndList, "SWT001-housing");
        PHSwitchButtonInfo tapDevBtn1 = new PHSwitchButtonInfo("1", 11, "SWT001-btn01", new PointD(0.0, 0.0), new RectangleD(10.0, 10.0, 230.0, 230.0));
        PHSwitchButtonInfo tapDevBtn2 = new PHSwitchButtonInfo("2", 15, "SWT001-btn02", new PointD(0.0, 0.0), new RectangleD(28.0, 92.0, 66.0, 66.0));
        PHSwitchButtonInfo tapDevBtn3 = new PHSwitchButtonInfo("3", 20, "SWT001-btn03", new PointD(0.0, 0.0), new RectangleD(90.0, 154.0, 66.0, 66.0));
        PHSwitchButtonInfo tapDevBtn4 = new PHSwitchButtonInfo("4", 25, "SWT001-btn04", new PointD(0.0, 0.0), new RectangleD(152.0, 92.0, 66.0, 66.0));
        ArrayList<PHSwitchButtonInfo> tapDevButtons = new ArrayList<PHSwitchButtonInfo>();
        tapDevButtons.add(tapDevBtn1);
        tapDevButtons.add(tapDevBtn2);
        tapDevButtons.add(tapDevBtn3);
        tapDevButtons.add(tapDevBtn4);
        tapDev1.setButtons(tapDevButtons);
        PHSwitchButtonActionPair actionDev1 = new PHSwitchButtonActionPair(tapDevBtn1, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actionsDev1 = new ArrayList<PHSwitchButtonActionPair>();
        actionsDev1.add(actionDev1);
        PHSwitchButtonActionPair actionDev2 = new PHSwitchButtonActionPair(tapDevBtn2, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actionsDev2 = new ArrayList<PHSwitchButtonActionPair>();
        actionsDev2.add(actionDev2);
        PHSwitchButtonActionPair actionDev3 = new PHSwitchButtonActionPair(tapDevBtn3, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actionsDev3 = new ArrayList<PHSwitchButtonActionPair>();
        actionsDev3.add(actionDev3);
        PHSwitchButtonActionPair actionDev4 = new PHSwitchButtonActionPair(tapDevBtn4, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actionsDev4 = new ArrayList<PHSwitchButtonActionPair>();
        actionsDev4.add(actionDev4);
        HashMap<Integer, List<PHSwitchButtonActionPair>> buttonDevMapping = new HashMap<Integer, List<PHSwitchButtonActionPair>>();
        buttonDevMapping.put(34, actionsDev1);
        buttonDevMapping.put(16, actionsDev2);
        buttonDevMapping.put(17, actionsDev3);
        buttonDevMapping.put(18, actionsDev4);
        tapDev1.setEventButtonMapping(buttonDevMapping);
        ArrayList<Long> srcIdStartListProd = new ArrayList<Long>();
        srcIdStartListProd.add(0x400400L);
        srcIdStartListProd.add(0x410000L);
        srcIdStartListProd.add(0x420000L);
        srcIdStartListProd.add(0x430000L);
        ArrayList<Long> srcIdEndListProd = new ArrayList<Long>();
        srcIdEndListProd.add(0x40FFFFL);
        srcIdEndListProd.add(0x41FFFFL);
        srcIdEndListProd.add(0x42FFFFL);
        srcIdEndListProd.add(0x43FFFFL);
        PHSwitchDeviceInfo tapProd = new PHSwitchDeviceInfo("hue TAP", "SWT001", "Philips", srcIdStartListProd, srcIdEndListProd, "SWT001-housing");
        PHSwitchButtonInfo tapBtn1 = new PHSwitchButtonInfo("1", 11, "SWT001-btn01", new PointD(0.0, 0.0), new RectangleD(10.0, 10.0, 230.0, 230.0));
        PHSwitchButtonInfo tapBtn2 = new PHSwitchButtonInfo("2", 15, "SWT001-btn02", new PointD(0.0, 0.0), new RectangleD(28.0, 92.0, 66.0, 66.0));
        PHSwitchButtonInfo tapBtn3 = new PHSwitchButtonInfo("3", 20, "SWT001-btn03", new PointD(0.0, 0.0), new RectangleD(90.0, 154.0, 66.0, 66.0));
        PHSwitchButtonInfo tapBtn4 = new PHSwitchButtonInfo("4", 25, "SWT001-btn04", new PointD(0.0, 0.0), new RectangleD(152.0, 92.0, 66.0, 66.0));
        ArrayList<PHSwitchButtonInfo> tapProdButtons = new ArrayList<PHSwitchButtonInfo>();
        tapProdButtons.add(tapBtn1);
        tapProdButtons.add(tapBtn2);
        tapProdButtons.add(tapBtn3);
        tapProdButtons.add(tapBtn4);
        tapProd.setButtons(tapProdButtons);
        PHSwitchButtonActionPair action1 = new PHSwitchButtonActionPair(tapBtn1, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actions1 = new ArrayList<PHSwitchButtonActionPair>();
        actions1.add(action1);
        PHSwitchButtonActionPair action2 = new PHSwitchButtonActionPair(tapBtn2, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actions2 = new ArrayList<PHSwitchButtonActionPair>();
        actions2.add(action2);
        PHSwitchButtonActionPair action3 = new PHSwitchButtonActionPair(tapBtn3, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actions3 = new ArrayList<PHSwitchButtonActionPair>();
        actions3.add(action3);
        PHSwitchButtonActionPair action4 = new PHSwitchButtonActionPair(tapBtn4, PHSwitchButtonActionPair.PHSwitchButtonAction.SHORT_PRESS);
        ArrayList<PHSwitchButtonActionPair> actions4 = new ArrayList<PHSwitchButtonActionPair>();
        actions4.add(action4);
        HashMap<Integer, List<PHSwitchButtonActionPair>> buttonProdMapping = new HashMap<Integer, List<PHSwitchButtonActionPair>>();
        buttonProdMapping.put(34, actions1);
        buttonProdMapping.put(16, actions2);
        buttonProdMapping.put(17, actions3);
        buttonProdMapping.put(18, actions4);
        tapProd.setEventButtonMapping(buttonProdMapping);
        knowledgeBase.add(tapDev1);
        knowledgeBase.add(tapProd);
        return knowledgeBase;
    }

    public static PHSwitch createFromJSON(JSONObject json, String identifier) {
        PHSwitch.Type type = PHSwitch.Type.CLIP;
        String sType = json.optString("type");
        if (sType != null) {
            if (sType.equals(PHSwitch.Type.ZLL.getValue())) {
                type = PHSwitch.Type.ZLL;
            } else if (sType.equals(PHSwitch.Type.ZGP.getValue())) {
                type = PHSwitch.Type.ZGP;
            }
        }
        PHSwitch sensor = new PHSwitch("", identifier, type);
        if ((sensor = (PHSwitch)PHSwitchSerializer1.fillBasicSensor(sensor, json)).getTypeAsString().equals(PHSwitch.Type.ZGP.getValue())) {
            String uniqueId = sensor.getUniqueId();
            String srcId = uniqueId.split("-")[0];
            if ((srcId = srcId.replaceAll(":", "")).length() > 8) {
                srcId = srcId.substring(srcId.length() - 8, srcId.length());
            }
            long sourceId = Long.parseLong(srcId, 16);
            block0: for (PHSwitchDeviceInfo devInfo : PHSwitchSerializer1.getKnowledgeBase()) {
                if (devInfo.getSrcIdStart() == null) continue;
                for (int i2 = 0; i2 < devInfo.getSrcIdStart().size(); ++i2) {
                    if (devInfo.getSrcIdStart().get(i2) > sourceId || devInfo.getSrcIdEnd().get(i2) < sourceId) continue;
                    sensor.setDeviceInfo(devInfo);
                    sensor.setModelId(sensor.getDeviceInfo().getModelId());
                    continue block0;
                }
            }
        } else if (sensor.getTypeAsString().equals(PHSwitch.Type.ZLL.getValue())) {
            for (PHSwitchDeviceInfo devInfo : PHSwitchSerializer1.getKnowledgeBase()) {
                if (devInfo.getSrcIdStart() != null || !devInfo.getModelId().equals(sensor.getModelId())) continue;
                sensor.setDeviceInfo(devInfo);
                break;
            }
        }
        sensor = PHSwitchSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHSwitchSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHSwitch createStateFromJSON(JSONObject json, PHSwitch sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHSwitchState state = new PHSwitchState();
            state = (PHSwitchState)PHSwitchSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("buttonevent")) {
                int parsedEvent = sensorStateObject.optInt("buttonevent");
                state.setButtonEvent(parsedEvent);
            } else {
                state.setButtonEvent(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHSwitch createConfigurationFromJSON(JSONObject json, PHSwitch sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHSwitchConfiguration config = new PHSwitchConfiguration();
            config = (PHSwitchConfiguration)PHSwitchSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHSwitch sensor) {
        JSONObject json = PHSwitchSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHSwitchSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHSwitchSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHSwitchState state) {
        if (state != null) {
            JSONObject json = PHSwitchSerializer1.getJSONSensorStateBase(state);
            String type = sensorObj.getString("type");
            if (!type.equals(PHSwitch.Type.ZLL.getValue()) && !type.equals(PHSwitch.Type.ZGP.getValue())) {
                json.putOpt("buttonevent", state.getButtonEvent());
            }
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHSwitchConfiguration config) {
        if (config != null) {
            JSONObject json = PHSwitchSerializer1.getJSONSensorConfigurationBase(config);
            String type = sensorObj.getString("type");
            if (type.equals(PHSwitch.Type.ZLL.getValue()) || type.equals(PHSwitch.Type.ZGP.getValue())) {
                json.remove("battery");
            }
            sensorObj.put("config", json);
        }
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHSwitch sensor) {
        JSONObject sensorObj = PHSwitchSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHSwitch sensor) {
        JSONObject sensorObj = PHSwitchSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

