/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.model.sensor.PHHumiditySensor;
import com.philips.lighting.model.sensor.PHHumiditySensorConfiguration;
import com.philips.lighting.model.sensor.PHHumiditySensorState;
import org.json.hue.JSONObject;

public class PHHumiditySensorSerializer1
extends PHSensorSerializerBase1 {
    public static PHHumiditySensor createFromJSON(JSONObject json, String identifier) {
        PHHumiditySensor.Type type = PHHumiditySensor.Type.CLIP;
        String sType = json.optString("type");
        if (sType != null && sType.equals(PHHumiditySensor.Type.ZLL.getValue())) {
            type = PHHumiditySensor.Type.ZLL;
        }
        PHHumiditySensor sensor = new PHHumiditySensor("", identifier, type);
        sensor = (PHHumiditySensor)PHHumiditySensorSerializer1.fillBasicSensor(sensor, json);
        sensor = PHHumiditySensorSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHHumiditySensorSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHHumiditySensor createStateFromJSON(JSONObject json, PHHumiditySensor sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHHumiditySensorState state = new PHHumiditySensorState();
            state = (PHHumiditySensorState)PHHumiditySensorSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("humidity")) {
                int parsedHumidity = sensorStateObject.optInt("humidity");
                state.setHumidity(parsedHumidity);
            } else {
                state.setHumidity(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHHumiditySensor createConfigurationFromJSON(JSONObject json, PHHumiditySensor sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHHumiditySensorConfiguration config = new PHHumiditySensorConfiguration();
            config = (PHHumiditySensorConfiguration)PHHumiditySensorSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHHumiditySensor sensor) {
        JSONObject json = PHHumiditySensorSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHHumiditySensorSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHHumiditySensorSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHHumiditySensorState state) {
        if (state != null) {
            JSONObject json = PHHumiditySensorSerializer1.getJSONSensorStateBase(state);
            String type = sensorObj.getString("type");
            if (!type.equals(PHHumiditySensor.Type.ZLL.getValue())) {
                json.putOpt("humidity", state.getHumidity());
            }
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHHumiditySensorConfiguration config) {
        if (config != null) {
            JSONObject json = PHHumiditySensorSerializer1.getJSONSensorConfigurationBase(config);
            String type = sensorObj.getString("type");
            if (type.equals(PHHumiditySensor.Type.ZLL.getValue())) {
                json.remove("battery");
            }
            sensorObj.put("config", json);
        }
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHHumiditySensor sensor) {
        JSONObject sensorObj = PHHumiditySensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHHumiditySensor sensor) {
        JSONObject sensorObj = PHHumiditySensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

