/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.model.sensor.PHGenericFlagSensor;
import com.philips.lighting.model.sensor.PHGenericFlagSensorConfiguration;
import com.philips.lighting.model.sensor.PHGenericFlagSensorState;
import org.json.hue.JSONObject;

public class PHGenericFlagSensorSerializer1
extends PHSensorSerializerBase1 {
    public static PHGenericFlagSensor createFromJSON(JSONObject json, String identifier) {
        PHGenericFlagSensor sensor = new PHGenericFlagSensor("", identifier);
        sensor = (PHGenericFlagSensor)PHGenericFlagSensorSerializer1.fillBasicSensor(sensor, json);
        sensor = PHGenericFlagSensorSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHGenericFlagSensorSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHGenericFlagSensor createStateFromJSON(JSONObject json, PHGenericFlagSensor sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHGenericFlagSensorState state = new PHGenericFlagSensorState();
            state = (PHGenericFlagSensorState)PHGenericFlagSensorSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("flag")) {
                Boolean parsedFlag = sensorStateObject.optBoolean("flag");
                state.setFlag(parsedFlag);
            } else {
                state.setFlag(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHGenericFlagSensor createConfigurationFromJSON(JSONObject json, PHGenericFlagSensor sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHGenericFlagSensorConfiguration config = new PHGenericFlagSensorConfiguration();
            config = (PHGenericFlagSensorConfiguration)PHGenericFlagSensorSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHGenericFlagSensor sensor) {
        JSONObject json = PHGenericFlagSensorSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHGenericFlagSensorSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHGenericFlagSensorSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHGenericFlagSensorState state) {
        if (state != null) {
            JSONObject json = PHGenericFlagSensorSerializer1.getJSONSensorStateBase(state);
            json.putOpt("flag", state.getFlag());
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHGenericFlagSensorConfiguration config) {
        JSONObject json = PHGenericFlagSensorSerializer1.getJSONSensorConfigurationBase(config);
        sensorObj.putOpt("config", json);
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHGenericFlagSensor sensor) {
        JSONObject sensorObj = PHGenericFlagSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHGenericFlagSensor sensor) {
        JSONObject sensorObj = PHGenericFlagSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

