/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation.sensors;

import com.philips.lighting.hue.sdk.clip.serialisation.sensors.PHSensorSerializerBase1;
import com.philips.lighting.model.sensor.PHDaylightSensor;
import com.philips.lighting.model.sensor.PHDaylightSensorConfiguration;
import com.philips.lighting.model.sensor.PHDaylightSensorState;
import org.json.hue.JSONObject;

public class PHDaylightSensorSerializer1
extends PHSensorSerializerBase1 {
    public static PHDaylightSensor createFromJSON(JSONObject json, String identifier) {
        PHDaylightSensor sensor = new PHDaylightSensor("", identifier);
        sensor = (PHDaylightSensor)PHDaylightSensorSerializer1.fillBasicSensor(sensor, json);
        sensor = PHDaylightSensorSerializer1.createConfigurationFromJSON(json, sensor);
        sensor = PHDaylightSensorSerializer1.createStateFromJSON(json, sensor);
        return sensor;
    }

    private static PHDaylightSensor createStateFromJSON(JSONObject json, PHDaylightSensor sensor) {
        JSONObject sensorStateObject = json.optJSONObject("state");
        if (sensorStateObject != null) {
            PHDaylightSensorState state = new PHDaylightSensorState();
            state = (PHDaylightSensorState)PHDaylightSensorSerializer1.fillBasicSensorState(state, sensorStateObject);
            if (sensorStateObject.has("daylight")) {
                Boolean parsedDaylight = sensorStateObject.optBoolean("daylight");
                state.setDaylight(parsedDaylight);
            } else {
                state.setDaylight(null);
            }
            sensor.setState(state);
        }
        return sensor;
    }

    private static PHDaylightSensor createConfigurationFromJSON(JSONObject json, PHDaylightSensor sensor) {
        JSONObject sensorConfigObject = json.optJSONObject("config");
        if (sensorConfigObject != null) {
            PHDaylightSensorConfiguration config = new PHDaylightSensorConfiguration();
            config = (PHDaylightSensorConfiguration)PHDaylightSensorSerializer1.fillBasicSensorConfiguration(config, sensorConfigObject);
            if (sensorConfigObject.has("lat")) {
                String lat = sensorConfigObject.optString("lat");
                config.setLatitude(lat);
            }
            if (sensorConfigObject.has("long")) {
                String lon = sensorConfigObject.optString("long");
                config.setLongitude(lon);
            }
            if (sensorConfigObject.has("sunriseoffset")) {
                int parsedSunriseOffset = sensorConfigObject.optInt("sunriseoffset");
                config.setSunriseOffset(parsedSunriseOffset);
            } else {
                config.setSunriseOffset(null);
            }
            if (sensorConfigObject.has("sunsetoffset")) {
                int parsedSunsetOffset = sensorConfigObject.optInt("sunsetoffset");
                config.setSunsetOffset(parsedSunsetOffset);
            } else {
                config.setSunsetOffset(null);
            }
            sensor.setConfiguration(config);
        }
        return sensor;
    }

    public static JSONObject getJSON(PHDaylightSensor sensor) {
        JSONObject json = PHDaylightSensorSerializer1.getJSONSensorBase(sensor);
        json.putOpt("type", sensor.getTypeAsString());
        json = PHDaylightSensorSerializer1.addSensorStateJSON(json, sensor.getState());
        json = PHDaylightSensorSerializer1.addSensorConfigurationJSON(json, sensor.getConfiguration());
        return json;
    }

    private static JSONObject addSensorStateJSON(JSONObject sensorObj, PHDaylightSensorState state) {
        if (state != null) {
            JSONObject json = PHDaylightSensorSerializer1.getJSONSensorStateBase(state);
            json.putOpt("daylight", state.getDaylight());
            sensorObj.put("state", json);
        }
        return sensorObj;
    }

    private static JSONObject addSensorConfigurationJSON(JSONObject sensorObj, PHDaylightSensorConfiguration config) {
        if (config != null) {
            JSONObject json = PHDaylightSensorSerializer1.getJSONSensorConfigurationBase(config);
            json.remove("battery");
            json.remove("url");
            json.putOpt("lat", config.getLatitude());
            json.putOpt("long", config.getLongitude());
            json.putOpt("sunriseoffset", config.getSunriseOffset());
            json.putOpt("sunsetoffset", config.getSunsetOffset());
            sensorObj.put("config", json);
        }
        return sensorObj;
    }

    public static JSONObject getStateJSON(PHDaylightSensor sensor) {
        JSONObject sensorObj = PHDaylightSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("state");
    }

    public static JSONObject getConfigurationJSON(PHDaylightSensor sensor) {
        JSONObject sensorObj = PHDaylightSensorSerializer1.getJSON(sensor);
        return sensorObj.getJSONObject("config");
    }
}

