/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHScheduleSerializer1;
import com.philips.lighting.hue.sdk.utilities.PHDateTimePattern;
import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import com.philips.lighting.model.PHSchedule;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHScheduleSerializer2
extends PHScheduleSerializer1 {
    private static PHScheduleSerializer2 schedulesSerialisation2;

    public static synchronized PHScheduleSerializer2 getInstance() {
        if (schedulesSerialisation2 == null) {
            schedulesSerialisation2 = new PHScheduleSerializer2();
        }
        return schedulesSerialisation2;
    }

    @Override
    public List<PHSchedule> parseSchedules(JSONObject rootObject, String sTimeZone) {
        JSONArray schedulesArray;
        ArrayList<PHSchedule> schedulesList = new ArrayList<PHSchedule>();
        JSONObject schedules = rootObject.optJSONObject("schedules");
        if (schedules == null) {
            schedules = rootObject;
        }
        if (schedules != null && (schedulesArray = schedules.names()) != null) {
            for (int i2 = 0; i2 < schedulesArray.length(); ++i2) {
                String scheduleIdentifier = schedulesArray.optString(i2);
                try {
                    String time;
                    Date createdDate;
                    JSONObject scheduleObject = schedules.optJSONObject(scheduleIdentifier);
                    if (scheduleObject == null) continue;
                    PHSchedule schedule = super.parseSingleSchedule(scheduleIdentifier, scheduleObject);
                    String created = scheduleObject.optString("created");
                    if (created != null && created.length() > 0 && (createdDate = PHUtilities.stringToDate(created, "UTC")) != null) {
                        schedule.setCreated(createdDate);
                    }
                    if ((time = scheduleObject.optString("time")) != null && time.length() > 0) {
                        PHDateTimePattern dateTimePattern = PHDateTimePattern.patternWithTimeString(time, TimeZone.getTimeZone("UTC"));
                        if (dateTimePattern != null) {
                            schedule.setDate(dateTimePattern.getDate());
                            schedule.setTimer(dateTimePattern.getTimer() != null ? dateTimePattern.getTimer() : 0);
                            schedule.setRecurringTimerInterval(dateTimePattern.getRecurringTimerInterval() != null ? dateTimePattern.getRecurringTimerInterval() : 0);
                            schedule.setRandomTime(dateTimePattern.getRandomTime() != null ? dateTimePattern.getRandomTime() : 0);
                            schedule.setRecurringDays(dateTimePattern.getRecurringDays());
                        } else {
                            throw new JSONException("JSON contains invalid data for time");
                        }
                    }
                    schedulesList.add(schedule);
                    continue;
                }
                catch (Exception e2) {
                    this.reportParsingError(64, scheduleIdentifier, "Schedule unparsable due to error: " + e2.getMessage(), schedules.optJSONObject(scheduleIdentifier));
                }
            }
        }
        return schedulesList;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone) throws JSONException {
        JSONObject toSend = super.createSchedulePacket(schedule, cmdAddress, method, timeZone);
        String timeTarget = "time";
        PHDateTimePattern dateTimePattern = new PHDateTimePattern();
        dateTimePattern.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (schedule.getRandomTime() != 0) {
            dateTimePattern.setRandomTime(schedule.getRandomTime());
        }
        if (schedule.getDate() != null) {
            dateTimePattern.setDate(schedule.getDate());
            if (schedule.getRecurringDays() != 0) {
                dateTimePattern.setRecurringDays(schedule.getRecurringDays());
            }
        } else if (schedule.getTimer() != 0) {
            dateTimePattern.setTimer(schedule.getTimer());
            if (schedule.getRecurringTimerInterval() >= 1 && schedule.getRecurringTimerInterval() <= 99 || schedule.getRecurringTimerInterval() == -1) {
                dateTimePattern.setRecurringTimerInterval(schedule.getRecurringTimerInterval());
            }
        }
        if (schedule.getLightState() == null && schedule.getSceneIdentifier() != null) {
            JSONObject activateScene = new JSONObject();
            activateScene.putOpt("scene", schedule.getSceneIdentifier());
            JSONObject command = toSend.optJSONObject("command");
            if (command != null) {
                command.putOpt("body", activateScene);
                toSend.put("command", command);
            }
        }
        toSend.remove("time");
        toSend.putOpt(timeTarget, dateTimePattern.patternAsString());
        return toSend;
    }

    @Override
    public JSONObject updateSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone) throws JSONException {
        return this.createSchedulePacket(schedule, cmdAddress, method, timeZone);
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method) throws JSONException {
        return this.createSchedulePacket(schedule, cmdAddress, method, "UTC");
    }

    @Override
    public JSONObject updateSchedulePacket(PHSchedule schedule, String cmdAddress, String method) throws JSONException {
        return this.updateSchedulePacket(schedule, cmdAddress, method, "UTC");
    }

    @Override
    public boolean validateAPI(PHSchedule schedule) {
        if (schedule.getRecurringDays() != PHSchedule.RecurringDay.RECURRING_NONE.getValue()) {
            return false;
        }
        if (schedule.getRandomTime() != 0) {
            return false;
        }
        return schedule.getLocalTime() == null || schedule.getLocalTime() == false;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }
}

