/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHRuleSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.exception.PHInvalidRuleException;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.utilities.PHDateTimePattern;
import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.rule.PHRule;
import com.philips.lighting.model.rule.PHRuleAction;
import com.philips.lighting.model.rule.PHRuleCondition;
import com.philips.lighting.model.rule.PHSimpleRuleAction;
import com.philips.lighting.model.rule.PHSimpleRuleCondition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHRuleSerializer1
extends PHCLIPParserBase
implements PHRuleSerializer {
    private static final String TAG = PHRuleSerializer1.class.getSimpleName();
    private static PHRuleSerializer1 ruleSerialisation1;

    public static synchronized PHRuleSerializer1 getInstance() {
        if (ruleSerialisation1 == null) {
            ruleSerialisation1 = new PHRuleSerializer1();
        }
        return ruleSerialisation1;
    }

    @Override
    public List<PHRule> parseRules(JSONObject rootObject) {
        JSONArray rulesArray;
        ArrayList<PHRule> rulesList = new ArrayList<PHRule>();
        JSONObject rules = rootObject.optJSONObject("rules");
        if (rules == null) {
            rules = rootObject;
        }
        if (rules != null && (rulesArray = rules.names()) != null) {
            for (int i2 = 0; i2 < rulesArray.length(); ++i2) {
                String identifier = rulesArray.getString(i2);
                try {
                    JSONObject ruleObject = rules.getJSONObject(identifier);
                    PHRule rule = null;
                    if (ruleObject != null) {
                        JSONArray actionsArray;
                        String name = ruleObject.optString("name");
                        String lasttriggered = ruleObject.optString("lasttriggered");
                        String creationtime = ruleObject.optString("created");
                        String owner = ruleObject.optString("owner");
                        String sStatus = ruleObject.optString("status");
                        PHRule.PHRuleStatus status = PHRule.PHRuleStatus.UNKNOWN;
                        if (sStatus != null) {
                            if (sStatus.equals("active") || sStatus.equals("enabled")) {
                                status = PHRule.PHRuleStatus.ENABLED;
                            }
                            if (sStatus.equals("disabled")) {
                                status = PHRule.PHRuleStatus.DISABLED;
                            }
                            if (sStatus.contains("resource") && sStatus.contains("deleted")) {
                                status = PHRule.PHRuleStatus.RESOURCE_DELETED;
                            }
                        }
                        Integer timesTriggered = ruleObject.optInt("timestriggered");
                        rule = new PHRule(name, identifier);
                        if (creationtime != null) {
                            Date creationTimeDt = PHUtilities.stringToDate(creationtime, "UTC");
                            rule.setCreationTime(creationTimeDt);
                        }
                        if (lasttriggered != null) {
                            Date lasttriggeredDt = PHUtilities.stringToDate(lasttriggered, "UTC");
                            rule.setLastTriggered(lasttriggeredDt);
                        }
                        rule.setOwner(owner);
                        rule.setStatus(status);
                        rule.setTimesTriggered(timesTriggered);
                        JSONArray conditionsArray = ruleObject.optJSONArray("conditions");
                        if (conditionsArray != null) {
                            ArrayList<PHRuleCondition> conditionsList = new ArrayList<PHRuleCondition>();
                            for (int c2 = 0; c2 < conditionsArray.length(); ++c2) {
                                JSONObject conditionObject;
                                block20: {
                                    String configJSON = conditionsArray.optString(c2);
                                    conditionObject = null;
                                    try {
                                        conditionObject = new JSONObject(configJSON);
                                    }
                                    catch (JSONException e2) {
                                        if (!PHLog.isLoggable()) break block20;
                                        PHLog.e(TAG, "JSONException: " + e2);
                                    }
                                }
                                String operator2 = conditionObject.optString("operator");
                                String address = conditionObject.optString("address");
                                String value = conditionObject.optString("value");
                                PHRuleCondition ruleCondition = this.parseRuleCondition(address, operator2, value, rootObject);
                                conditionsList.add(ruleCondition);
                            }
                            rule.setConditions(conditionsList);
                        }
                        if ((actionsArray = ruleObject.optJSONArray("actions")) != null) {
                            ArrayList<PHRuleAction> actionsList = new ArrayList<PHRuleAction>();
                            for (int c3 = 0; c3 < actionsArray.length(); ++c3) {
                                JSONObject actionObject;
                                block21: {
                                    String actionJSON = actionsArray.optString(c3);
                                    actionObject = null;
                                    try {
                                        actionObject = new JSONObject(actionJSON);
                                    }
                                    catch (JSONException e3) {
                                        if (!PHLog.isLoggable()) break block21;
                                        PHLog.e(TAG, "JSONException: " + e3);
                                    }
                                }
                                String method = actionObject.optString("method");
                                String address = actionObject.optString("address");
                                String body = actionObject.optString("body");
                                PHRuleAction ruleAction = this.parseRuleAction(method, address, body);
                                actionsList.add(ruleAction);
                            }
                            rule.setActions(actionsList);
                        }
                    }
                    rulesList.add(rule);
                    continue;
                }
                catch (Exception e4) {
                    this.reportParsingError(66, identifier, "Rule unparsable due to error: " + e4.getMessage(), rules.getJSONObject(identifier));
                }
            }
        }
        return rulesList;
    }

    public PHRuleAction parseRuleAction(String method, String address, Object body) {
        if (address == null) {
            throw new PHInvalidRuleException("JSON is missing key: address.");
        }
        String[] urlElements = address.split("/");
        if (urlElements.length < 3 || urlElements.length > 5) {
            throw new PHInvalidRuleException("JSON invalid rule condition format.");
        }
        String identifier = urlElements[2];
        if (address.startsWith("/groups/")) {
            JSONObject groupActionObject;
            PHSimpleRuleAction simpleRuleAction;
            block9: {
                simpleRuleAction = new PHSimpleRuleAction();
                groupActionObject = null;
                try {
                    groupActionObject = new JSONObject((String)body);
                }
                catch (JSONException e2) {
                    if (!PHLog.isLoggable()) break block9;
                    PHLog.e(TAG, "JSONException: " + e2);
                }
            }
            if (!groupActionObject.has("scene")) {
                PHRuleAction ruleAction = new PHRuleAction();
                ruleAction.setAddress(address);
                ruleAction.setMethod(method);
                ruleAction.setBody(body);
                return ruleAction;
            }
            String sceneId = groupActionObject.optString("scene");
            simpleRuleAction.setSceneIdentifier(sceneId);
            simpleRuleAction.setAddress(address);
            simpleRuleAction.setBody(body);
            simpleRuleAction.setMethod(method);
            simpleRuleAction.setGroupIdentifier(identifier);
            return simpleRuleAction;
        }
        if (address.startsWith("/lights/")) {
            JSONObject lightStateJson;
            PHSimpleRuleAction simpleRuleAction;
            block10: {
                simpleRuleAction = new PHSimpleRuleAction();
                simpleRuleAction.setMethod(method);
                simpleRuleAction.setLightIdentifier(identifier);
                lightStateJson = null;
                try {
                    lightStateJson = new JSONObject((String)body);
                }
                catch (JSONException e3) {
                    if (!PHLog.isLoggable()) break block10;
                    PHLog.e(TAG, "JSONException: " + e3);
                }
            }
            PHLightState lightState = PHBridgeVersionManager.getInstance().getLightSerializer().parseLightState(lightStateJson);
            simpleRuleAction.setLightState(lightState);
            return simpleRuleAction;
        }
        PHRuleAction ruleAction = new PHRuleAction();
        ruleAction.setAddress(address);
        ruleAction.setMethod(method);
        ruleAction.setBody(body);
        return ruleAction;
    }

    public PHRuleCondition parseRuleCondition(String address, String operator2, String value, JSONObject rootObject) {
        if (address == null) {
            throw new PHInvalidRuleException("JSON is missing key: address.");
        }
        PHRuleCondition.PHRuleConditionOperator parsedOperator = null;
        if (operator2 == null) {
            throw new PHInvalidRuleException("JSON contains invalid rule condition operator.");
        }
        parsedOperator = PHRuleCondition.getOperatorFromShortDesc(operator2);
        String resourceIdentifier = this.extractResourceIdentifierFromAddress(address);
        String addressTemplate = this.getAddressTemplate(address);
        PHSimpleRuleCondition.PHSimpleRuleAttributeName attributeName = PHSimpleRuleCondition.PHSimpleRuleAttributeName.getByAddressTemplate(addressTemplate);
        if (attributeName == null) {
            PHRuleCondition ruleCondition = new PHRuleCondition();
            ruleCondition.setAddress(address);
            ruleCondition.setOperator(PHRuleCondition.getOperatorFromShortDesc(operator2));
            ruleCondition.setValue(value);
            return ruleCondition;
        }
        if (parsedOperator != PHRuleCondition.PHRuleConditionOperator.OPERATOR_DX) {
            Class type = attributeName.getType();
            if (parsedOperator == PHRuleCondition.PHRuleConditionOperator.OPERATOR_DDX) {
                return new PHSimpleRuleCondition(resourceIdentifier, attributeName, parsedOperator, PHDateTimePattern.timeWithTruncatedTimeString(value));
            }
            if (type == Integer.TYPE) {
                return new PHSimpleRuleCondition(resourceIdentifier, attributeName, parsedOperator, Integer.parseInt(value));
            }
            if (type == Boolean.TYPE) {
                return new PHSimpleRuleCondition(resourceIdentifier, attributeName, parsedOperator, Boolean.parseBoolean(value));
            }
            return new PHSimpleRuleCondition(resourceIdentifier, attributeName, parsedOperator, value);
        }
        return new PHSimpleRuleCondition(resourceIdentifier, attributeName, parsedOperator, null);
    }

    private String extractResourceIdentifierFromAddress(String address) {
        if (PHSimpleRuleCondition.PHSimpleRuleAttributeName.getByAddressTemplate(address) != null) {
            return null;
        }
        String[] splitAddress = address.split("/");
        if (splitAddress.length > 3) {
            return splitAddress[2];
        }
        return null;
    }

    private String getAddressTemplate(String address) {
        String identifier = this.extractResourceIdentifierFromAddress(address);
        if (identifier == null) {
            return address;
        }
        return address.replace(identifier, "%s");
    }

    @Override
    public JSONObject createRule(PHRule rule) throws JSONException {
        JSONObject toSend = new JSONObject();
        toSend.putOpt("name", rule.getName());
        if (rule.getStatus() == PHRule.PHRuleStatus.ENABLED) {
            toSend.put("status", "enabled");
        } else if (rule.getStatus() == PHRule.PHRuleStatus.DISABLED) {
            toSend.put("status", "disabled");
        }
        JSONArray array = new JSONArray();
        List<PHRuleCondition> allConditions = rule.getConditions();
        for (PHRuleCondition condition : allConditions) {
            JSONObject conditionObj = new JSONObject();
            conditionObj.putOpt("address", condition.getAddress());
            conditionObj.putOpt("operator", condition.getOperator().getValue());
            if (condition.getValue() != null && !condition.getOperator().equals((Object)PHRuleCondition.PHRuleConditionOperator.OPERATOR_DX) && !condition.getOperator().equals((Object)PHRuleCondition.PHRuleConditionOperator.OPERATOR_DT)) {
                if (condition.getOperator().equals((Object)PHRuleCondition.PHRuleConditionOperator.OPERATOR_DDX)) {
                    PHDateTimePattern datePattern = new PHDateTimePattern();
                    datePattern.setTimer((Integer)condition.getValue());
                    conditionObj.putOpt("value", datePattern.patternAsString());
                } else {
                    conditionObj.putOpt("value", condition.getValue().toString());
                }
            }
            array.put(conditionObj);
        }
        toSend.putOpt("conditions", array);
        List<PHRuleAction> allActions = this.extractRuleActions(rule);
        array = new JSONArray();
        for (PHRuleAction action : allActions) {
            JSONObject actionObj = new JSONObject();
            actionObj.putOpt("address", action.getAddress());
            actionObj.putOpt("method", action.getMethod());
            if (action.getBody() != null) {
                actionObj.putOpt("body", new JSONObject(action.getBody().toString()));
            }
            array.put(actionObj);
        }
        toSend.putOpt("actions", array);
        return toSend;
    }

    @Override
    public JSONObject updateRule(PHRule rule) throws JSONException {
        return this.createRule(rule);
    }

    public List<PHRuleAction> extractRuleActions(PHRule rule) {
        ArrayList<PHRuleAction> allExtractedActions = new ArrayList<PHRuleAction>();
        if (rule.getActions() == null) {
            throw new PHInvalidRuleException("No actions extracted from Rule.");
        }
        for (PHRuleAction action : rule.getActions()) {
            if (action instanceof PHSimpleRuleAction) {
                PHRuleAction extractedAction;
                JSONObject lightStateJson;
                PHSimpleRuleAction simpleRuleAction = (PHSimpleRuleAction)action;
                if (simpleRuleAction.getLightIdentifier() != null && simpleRuleAction.getLightState() != null) {
                    try {
                        lightStateJson = PHBridgeVersionManager.getInstance().getLightSerializer().createLightStatePacket(simpleRuleAction.getLightState());
                    }
                    catch (JSONException e2) {
                        PHInvalidRuleException ne = new PHInvalidRuleException("No actions extracted from Rule.");
                        ne.initCause(e2);
                        throw ne;
                    }
                    extractedAction = new PHRuleAction();
                    extractedAction.setAddress("/lights/" + simpleRuleAction.getLightIdentifier() + "/state");
                    extractedAction.setMethod("PUT");
                    extractedAction.setBody(lightStateJson);
                    allExtractedActions.add(extractedAction);
                    continue;
                }
                if (simpleRuleAction.getGroupIdentifier() != null && simpleRuleAction.getLightState() != null) {
                    try {
                        lightStateJson = PHBridgeVersionManager.getInstance().getLightSerializer().createLightStatePacket(simpleRuleAction.getLightState());
                    }
                    catch (JSONException e3) {
                        PHInvalidRuleException ne = new PHInvalidRuleException("No actions extracted from Rule.");
                        ne.initCause(e3);
                        throw ne;
                    }
                    extractedAction = new PHRuleAction();
                    extractedAction.setAddress("/groups/" + simpleRuleAction.getGroupIdentifier() + "/action");
                    extractedAction.setMethod("PUT");
                    extractedAction.setBody(lightStateJson.toString());
                    allExtractedActions.add(extractedAction);
                    continue;
                }
                if (simpleRuleAction.getGroupIdentifier() != null && simpleRuleAction.getSceneIdentifier() != null) {
                    extractedAction = new PHRuleAction();
                    extractedAction.setAddress("/groups/" + simpleRuleAction.getGroupIdentifier() + "/action");
                    extractedAction.setMethod("PUT");
                    extractedAction.setBody("{\"scene\": \"" + simpleRuleAction.getSceneIdentifier() + "\"}");
                    allExtractedActions.add(extractedAction);
                    continue;
                }
                throw new PHInvalidRuleException("Invalid Action Supplied.  Either a LightIdentifier/LightState, GroupIdentifer/LightState or GroupIdentifier/SceneIdentifier should be supplied.");
            }
            allExtractedActions.add(action);
        }
        if (allExtractedActions.size() == 0) {
            throw new PHInvalidRuleException("No actions extracted from Rule.");
        }
        return allExtractedActions;
    }

    @Override
    public boolean validateAPI(PHRule rule) {
        return true;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean canFetchAll() {
        return true;
    }
}

