/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.ATON;
import com.hsyco.ATS;
import com.hsyco.Airzone;
import com.hsyco.Arduino;
import com.hsyco.AxisDecoder;
import com.hsyco.BACnet;
import com.hsyco.BentelDriver;
import com.hsyco.CSX75;
import com.hsyco.Configuration;
import com.hsyco.Contatto;
import com.hsyco.Daikin;
import com.hsyco.DigestParams;
import com.hsyco.Domino;
import com.hsyco.DriversWrapper;
import com.hsyco.DummyIO;
import com.hsyco.ELMO;
import com.hsyco.Elsner;
import com.hsyco.EscVP;
import com.hsyco.FP2000;
import com.hsyco.GKBus;
import com.hsyco.GSM;
import com.hsyco.Galaxy;
import com.hsyco.Guardall;
import com.hsyco.HESA;
import com.hsyco.Hephais;
import com.hsyco.HttpResponse;
import com.hsyco.INIM;
import com.hsyco.ISMG;
import com.hsyco.Knx;
import com.hsyco.KnxBaos;
import com.hsyco.MNet;
import com.hsyco.Modbus;
import com.hsyco.ModbusServer;
import com.hsyco.MyHome;
import com.hsyco.MyHomeSDK;
import com.hsyco.NOTIFIER;
import com.hsyco.Networx;
import com.hsyco.Nuvo;
import com.hsyco.ParadoxDriver;
import com.hsyco.PowerOne;
import com.hsyco.RIO;
import com.hsyco.RayControl;
import com.hsyco.SIP;
import com.hsyco.SSH;
import com.hsyco.SystemState;
import com.hsyco.SystemStatus;
import com.hsyco.TecnoalarmDriver;
import com.hsyco.Tlab;
import com.hsyco.Tridonic;
import com.hsyco.WXOnline;
import com.hsyco.Wyrestorm;
import com.hsyco.YamahaRX;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;

class ioMonitor
extends Thread {
    public long heartbeat = 0L;
    public boolean quit;
    private boolean initialized;
    public boolean dispatcher;
    public boolean comm = false;
    private int ioIndex;
    private Socket ioSocket;
    private InetSocketAddress ioInetAddress = null;
    private ArrayBlockingQueue<Byte> commQueueRx = null;
    private final String HIDEDGE_XML_GETLAST10EVENTS = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3AEventMessages%20action%3D%22LR%22%20%20recordOffset%3D%220%22%20recordCount%3D%2240%22%2F%3E%0A%3C%2FVertXMessage%3E";
    private final String HIDEDGE_XML_GETDOORSTATUS = "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22LR%22%20responseFormat%3D%22status%22%20%2F%3E%0A%3C%2FVertXMessage%3E";

    public ioMonitor(int ioIndex) {
        this.ioIndex = ioIndex;
        this.initialized = SystemState.ioServersInitializedGet(ioIndex);
    }

    @Override
    public void run() {
        int type = Configuration.ioServersType.elementAt(this.ioIndex);
        if (type == 1) {
            InputStream in = null;
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            int state = 0;
            try {
                this.ioInetAddress = Configuration.ioServersTCPAddress.elementAt(this.ioIndex);
                this.ioSocket = new Socket();
                this.ioSocket.connect(this.ioInetAddress, 3000);
                this.ioSocket.setSoTimeout(10000);
                in = this.ioSocket.getInputStream();
                SystemState.ioServersSocket[this.ioIndex] = this.ioSocket;
                this.quit = false;
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - Generic exception [" + this.ioIndex + "] - " + e2.getLocalizedMessage());
                this.quit = true;
            }
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e3) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e3);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
                events.eventsExec("IOSTART" + servername, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            int commIndex = Configuration.CommPortsId.indexOf("hwgio_" + servername);
            if (commIndex >= 0) {
                this.comm = true;
                this.commQueueRx = Configuration.CommPortsQueueRx.elementAt(commIndex);
            }
            this.dispatcher = true;
            hsyco.messageLog("ioMonitor [" + this.ioIndex + "] started");
            while (!this.quit) {
                try {
                    block28 : switch (state) {
                        case 0: {
                            int b2 = in.read();
                            if (b2 == 255) {
                                state = 1;
                                break;
                            }
                            if (commIndex < 0) break;
                            if (this.commQueueRx.remainingCapacity() == 0) {
                                this.commQueueRx.poll();
                            }
                            this.commQueueRx.put((byte)(b2 & 0xFF));
                            break;
                        }
                        case 1: {
                            int ib = in.read();
                            switch (ib) {
                                case 250: {
                                    state = 2;
                                    break block28;
                                }
                                case 255: {
                                    if (commIndex >= 0) {
                                        if (this.commQueueRx.remainingCapacity() == 0) {
                                            this.commQueueRx.poll();
                                        }
                                        this.commQueueRx.put((byte)-1);
                                    }
                                    state = 0;
                                    break block28;
                                }
                            }
                            state = 0;
                            break;
                        }
                        case 2: {
                            state = in.read() == 44 ? 3 : 0;
                            break;
                        }
                        case 3: {
                            int ib = in.read();
                            switch (ib) {
                                case 52: 
                                case 150: {
                                    state = 4;
                                    break block28;
                                }
                                case 151: {
                                    state = 5;
                                    break block28;
                                }
                                case 101: {
                                    state = 10;
                                    break block28;
                                }
                            }
                            state = 0;
                            break;
                        }
                        case 4: {
                            int ib = in.read();
                            if (Configuration.verboseLog || Configuration.eventsLog) {
                                hsyco.messageLog("MONITOR HWG I/O: " + this.ioIndex + " - IN=" + Integer.toHexString(ib).toUpperCase());
                            }
                            int i2 = 0;
                            while (i2 < 8) {
                                SystemState.ioWrite(String.valueOf(servername) + ".i" + (i2 + 1), (ib & 1) == 1 ? "0" : "1");
                                ib >>>= 1;
                                ++i2;
                            }
                            state = 6;
                            break;
                        }
                        case 5: {
                            int ib = in.read();
                            if (Configuration.verboseLog || Configuration.eventsLog) {
                                hsyco.messageLog("MONITOR HWG I/O: " + this.ioIndex + " - OUT=" + Integer.toHexString(ib).toUpperCase());
                            }
                            int i2 = 0;
                            while (i2 < 8) {
                                SystemState.ioWrite(String.valueOf(servername) + ".o" + (i2 + 1), Integer.toString(ib & 1));
                                ib >>>= 1;
                                ++i2;
                            }
                            if (!this.initialized) {
                                this.initialized = true;
                                SystemState.ioServersInitializedSet(this.ioIndex, true);
                            }
                            state = 6;
                            break;
                        }
                        case 6: {
                            state = in.read() == 255 ? 7 : 0;
                            break;
                        }
                        case 7: {
                            in.read();
                            Thread.sleep(5L);
                            state = 0;
                            break;
                        }
                        case 10: {
                            int i2 = 0;
                            while (i2 < 4) {
                                in.read();
                                ++i2;
                            }
                            state = 6;
                        }
                    }
                    this.heartbeat = System.currentTimeMillis();
                }
                catch (SocketTimeoutException e4) {
                    SystemState.ioDispatchRefresh(this.ioIndex);
                    state = 0;
                }
                catch (Exception e5) {
                    hsyco.errorLog("ioMonitor - Generic exception [" + this.ioIndex + "] - " + e5.getLocalizedMessage());
                    this.quit = true;
                }
            }
            SystemState.ioServersSocket[this.ioIndex] = null;
            try {
                this.ioSocket.close();
            }
            catch (Exception e5) {
                // empty catch block
            }
            SystemState.ioServersInitializedSet(this.ioIndex, false);
        } else if (type == 2) {
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            int pollinterval = 1000;
            SystemState.ioServersInitializedSet(this.ioIndex, false);
            try {
                String[] sa = Configuration.ioServersOptions.elementAt(this.ioIndex).split(",");
                int i3 = 0;
                while (i3 < sa.length) {
                    try {
                        String value;
                        String[] sb = sa[i3].split("=");
                        String param = sb[0].trim().toLowerCase();
                        String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                        if (param.equals("pollinterval")) {
                            pollinterval = Integer.parseInt(value);
                        }
                    }
                    catch (Exception e6) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + servername + "] - ignored");
                    }
                    ++i3;
                }
            }
            catch (Exception sa) {
                // empty catch block
            }
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e7) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e7);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
                events.eventsExec("IOSTART" + servername, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            this.dispatcher = true;
            SystemState.ioServersInitializedSet(this.ioIndex, true);
            hsyco.messageLog("ioMonitor [" + this.ioIndex + "] started");
            try {
                while (!this.quit) {
                    this.ioInetAddress = Configuration.ioServersTCPAddress.elementAt(this.ioIndex);
                    this.ioSocket = new Socket();
                    this.ioSocket.connect(this.ioInetAddress, 6000);
                    SystemState.ioServersSocket[this.ioIndex] = this.ioSocket;
                    ioMonitor.hwgGetValuesXml(this.ioSocket, servername);
                    long now = System.currentTimeMillis();
                    long t = (long)pollinterval - now + this.heartbeat;
                    if (t > 0L && t <= (long)pollinterval) {
                        this.heartbeat = now + t;
                        Thread.sleep(t);
                        continue;
                    }
                    this.heartbeat = now;
                }
            }
            catch (Exception e8) {
                hsyco.messageLog("ioMonitor [" + this.ioIndex + "] - Exception: " + e8);
            }
            SystemState.ioServersInitializedSet(this.ioIndex, false);
        } else if (type == 4) {
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            DigestParams authparams = null;
            String tagid = null;
            int state = 0;
            StringBuffer posBuffer = null;
            boolean safetyswitch = false;
            boolean menuitem = false;
            SystemState.ioServersInitializedSet(this.ioIndex, false);
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e9) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e9);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
                events.eventsExec("IOSTART" + servername, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            SystemState.ioServersInitializedSet(this.ioIndex, true);
            hsyco.messageLog("ioMonitor [" + this.ioIndex + "] started");
            this.dispatcher = true;
            try {
                this.ioInetAddress = Configuration.ioServersTCPAddress.elementAt(this.ioIndex);
                while (!this.quit) {
                    this.ioSocket = new Socket();
                    this.ioSocket.connect(this.ioInetAddress, 6000);
                    this.ioSocket.setSoTimeout(15000);
                    SystemState.ioServersSocket[this.ioIndex] = this.ioSocket;
                    BufferedReader in = new BufferedReader(new InputStreamReader(this.ioSocket.getInputStream()));
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.ioSocket.getOutputStream()));
                    out.write("GET /epe/pos/tagstream HTTP/1.1\r\n");
                    out.write("Host: ");
                    out.write(this.ioInetAddress.getHostName());
                    out.write(58);
                    out.write(Integer.toString(this.ioInetAddress.getPort()));
                    out.write("\r\n");
                    out.write("Connection: keep-alive\r\n");
                    if (authparams != null && (authparams = util.httpDigestAuth(authparams)) != null) {
                        out.write("Authorization: ");
                        out.write(authparams.authorization);
                        out.write("\r\n");
                    }
                    out.write("\r\n");
                    out.flush();
                    while (true) {
                        String line;
                        if ((line = in.readLine()) == null) {
                            this.quit = true;
                            break;
                        }
                        if (authparams == null) {
                            if (!line.toLowerCase().startsWith("www-authenticate: digest")) continue;
                            String u = Configuration.ioServersUser.elementAt(this.ioIndex);
                            String p = Configuration.ioServersPassword.elementAt(this.ioIndex);
                            authparams = util.httpDigestAuth(Arrays.asList(line.substring(18)), "GET", "/epe/pos/tagstream", u, p);
                            break;
                        }
                        if ((line = line.trim()).equals("<response>")) {
                            this.heartbeat = System.currentTimeMillis();
                            state = 1;
                        }
                        switch (state) {
                            case 1: {
                                if (!line.equals("<TAG>")) break;
                                state = 2;
                                safetyswitch = false;
                                menuitem = false;
                                posBuffer = new StringBuffer();
                                break;
                            }
                            case 2: {
                                int endindex;
                                int beginindex = line.indexOf("<tagid>");
                                if (beginindex == -1 || (endindex = line.indexOf("</tagid>")) == -1) break;
                                tagid = line.substring(beginindex + 7, endindex);
                                state = 3;
                                break;
                            }
                            case 3: {
                                int endindex;
                                int beginindex;
                                if (line.equals("</TAG>")) {
                                    state = 0;
                                    if (!safetyswitch) {
                                        SystemState.ioWrite(String.valueOf(servername) + "." + tagid + ".safetyswitch", "");
                                    }
                                    if (menuitem) {
                                        SystemState.ioWrite(String.valueOf(servername) + "." + tagid + ".menuitem", null);
                                    }
                                    if (posBuffer.length() > 0) {
                                        SystemState.ioWrite(String.valueOf(servername) + "." + tagid + ".pos", posBuffer.toString());
                                    }
                                } else {
                                    beginindex = line.indexOf("<");
                                    endindex = line.indexOf(">");
                                    String param = line.substring(beginindex + 1, endindex);
                                    String value = line.substring(endindex + 1, line.indexOf("</" + param + ">"));
                                    if (param.length() > 0 && value.length() > 0) {
                                        if (param.startsWith("pos")) {
                                            if (posBuffer.length() > 0) {
                                                posBuffer.append("; ");
                                            }
                                            posBuffer.append(param.substring(3));
                                            posBuffer.append('=');
                                            posBuffer.append(value);
                                        } else {
                                            SystemState.ioWrite(String.valueOf(servername) + "." + tagid + "." + param, value);
                                        }
                                        if (!safetyswitch && param.equals("safetyswitch")) {
                                            safetyswitch = true;
                                        } else if (!menuitem && param.equals("menuitem")) {
                                            menuitem = true;
                                        }
                                    }
                                }
                                if ((beginindex = line.indexOf("<tagid>")) == -1 || (endindex = line.indexOf("</tagid>")) == -1) break;
                                tagid = line.substring(beginindex + 7, endindex);
                            }
                        }
                    }
                    this.ioSocket.close();
                }
            }
            catch (Exception e10) {
                hsyco.errorLog("ioMonitor - Generic exception [" + this.ioIndex + "] - " + e10.getLocalizedMessage());
                this.quit = true;
            }
            SystemState.ioServersInitializedSet(this.ioIndex, false);
        } else if (type == 6) {
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            boolean connected = false;
            URL ioUrl = null;
            URLConnection uc = null;
            String username = null;
            String password = null;
            DigestParams authparams = null;
            InputStream instream = null;
            BufferedReader inreader = null;
            long sleepmillis = 1000L;
            String line = null;
            SystemState.ioServersInitializedSet(this.ioIndex, false);
            try {
                username = Configuration.ioServersUser.elementAt(this.ioIndex);
                password = Configuration.ioServersPassword.elementAt(this.ioIndex);
                String host = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getHostName();
                int port = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getPort();
                ioUrl = new URL("http", host, port, "/cgi-bin/control.cgi?msubmenu=analysis&action=monitor");
            }
            catch (Exception e11) {
                hsyco.errorLog("ioMonitor - Initialization exception [" + this.ioIndex + "] - " + e11.getLocalizedMessage());
                return;
            }
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e12) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e12);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
                events.eventsExec("IOSTART" + servername, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            SystemState.ioServersInitializedSet(this.ioIndex, false);
            hsyco.messageLog("ioMonitor [" + this.ioIndex + "] started");
            this.dispatcher = false;
            hsyco.messageLog("ioMonitor - started [" + this.ioIndex + "]");
            while (!this.quit) {
                try {
                    String eventtype;
                    int sep;
                    long t;
                    this.heartbeat = t = System.currentTimeMillis();
                    if (!connected) {
                        int code;
                        uc = ioUrl.openConnection();
                        uc.setConnectTimeout(6000);
                        uc.setReadTimeout(6000);
                        if (authparams != null && (authparams = util.httpDigestAuth(authparams)) != null) {
                            uc.setRequestProperty("Authorization", authparams.authorization);
                        }
                        if ((code = util.httpResponseCode(uc)) == 200) {
                            instream = uc.getInputStream();
                            inreader = new BufferedReader(new InputStreamReader(instream));
                            String contenttype = uc.getContentType();
                            if (contenttype.startsWith("multipart/x-mixed-replace")) {
                                connected = true;
                            } else {
                                int i4 = 0;
                                while (i4 < 100000 && instream.read() != -1) {
                                    ++i4;
                                }
                                instream.close();
                                sleepmillis = 30000L;
                            }
                        } else if (code == 401) {
                            if (authparams != null) {
                                Thread.sleep(1000L);
                            }
                            if ((authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "GET", ioUrl.getFile(), username, password)) != null) continue;
                            this.quit = true;
                        } else {
                            this.quit = true;
                        }
                    }
                    if (connected && (line = inreader.readLine()).startsWith("IV[") && (sep = line.indexOf("]:")) > 0 && (eventtype = line.substring(3, sep).toLowerCase().replaceAll(" ", "")).length() > 0) {
                        if (line.endsWith("H")) {
                            SystemState.ioWrite(String.valueOf(servername) + ".va." + eventtype, "1");
                        } else if (line.endsWith("L")) {
                            SystemState.ioWrite(String.valueOf(servername) + ".va." + eventtype, "0");
                        }
                    }
                }
                catch (Exception e13) {
                    hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.ioIndex + "] - " + e13.getLocalizedMessage());
                    this.quit = true;
                }
                if (connected) continue;
                try {
                    Thread.sleep(sleepmillis);
                }
                catch (Exception e13) {
                    // empty catch block
                }
            }
            try {
                int i5 = 0;
                while (i5 < 100000 && instream.read() != -1) {
                    ++i5;
                }
                instream.close();
            }
            catch (Exception i5) {
                // empty catch block
            }
            hsyco.errorLog("ioMonitor - quit [" + this.ioIndex + "]");
            SystemState.ioServersInitializedSet(this.ioIndex, false);
        } else if (type > 5000 && type < 6000) {
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            boolean connected = false;
            URL ioUrl = null;
            URLConnection uc = null;
            String username = null;
            String password = null;
            DigestParams authparams = null;
            InputStream instream = null;
            BufferedReader inreader = null;
            long sleepmillis = 1000L;
            String line = null;
            SystemState.ioServersInitializedSet(this.ioIndex, false);
            try {
                username = Configuration.ioServersUser.elementAt(this.ioIndex);
                password = Configuration.ioServersPassword.elementAt(this.ioIndex);
                String host = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getHostName();
                int port = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getPort();
                switch (type % 1000 / 100) {
                    case 1: {
                        ioUrl = new URL("http", host, port, "/cgi-bin/io?submenu=input&action=monitor");
                        break;
                    }
                    case 2: {
                        ioUrl = new URL("http", host, port, "/cgi-bin/control.cgi?msubmenu=input&action=monitor");
                    }
                }
            }
            catch (Exception e14) {
                hsyco.errorLog("ioMonitor - Initialization exception [" + this.ioIndex + "] - " + e14.getLocalizedMessage());
                return;
            }
            if (type % 10 != 0) {
                this.dispatcher = true;
                if (SystemState.ioServersSocket[this.ioIndex] == null) {
                    SystemState.ioServersSocket[this.ioIndex] = new Socket();
                }
            } else {
                this.dispatcher = false;
            }
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e15) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e15);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
                events.eventsExec("IOSTART" + servername, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            SystemState.ioServersInitializedSet(this.ioIndex, true);
            hsyco.messageLog("ioMonitor - started [" + this.ioIndex + "]");
            while (!this.quit) {
                block303: {
                    try {
                        int sep;
                        long t;
                        this.heartbeat = t = System.currentTimeMillis();
                        if (!connected) {
                            int code;
                            uc = ioUrl.openConnection();
                            uc.setConnectTimeout(6000);
                            uc.setReadTimeout(6000);
                            if (authparams != null && (authparams = util.httpDigestAuth(authparams)) != null) {
                                uc.setRequestProperty("Authorization", authparams.authorization);
                            }
                            if ((code = util.httpResponseCode(uc)) == 200) {
                                instream = uc.getInputStream();
                                inreader = new BufferedReader(new InputStreamReader(instream));
                                String contenttype = uc.getContentType();
                                if (contenttype.startsWith("multipart/x-mixed-replace")) {
                                    connected = true;
                                } else {
                                    int i6 = 0;
                                    while (i6 < 100000 && instream.read() != -1) {
                                        ++i6;
                                    }
                                    instream.close();
                                    sleepmillis = 30000L;
                                }
                            } else if (code == 401) {
                                if (authparams != null) {
                                    Thread.sleep(1000L);
                                }
                                if ((authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "GET", ioUrl.getFile(), username, password)) != null) continue;
                                this.quit = true;
                            } else {
                                this.quit = true;
                            }
                        }
                        if (!connected || !(line = inreader.readLine()).startsWith("IO") || (sep = line.indexOf(58)) <= 0) break block303;
                        try {
                            int n2 = Integer.parseInt(line.substring(2, sep));
                            if (line.endsWith("H")) {
                                SystemState.ioWrite(String.valueOf(servername) + ".i" + n2, "1");
                            } else if (line.endsWith("L")) {
                                SystemState.ioWrite(String.valueOf(servername) + ".i" + n2, "0");
                            }
                        }
                        catch (Exception n2) {}
                    }
                    catch (Exception e16) {
                        hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.ioIndex + "] - " + e16.getLocalizedMessage());
                        this.quit = true;
                    }
                }
                if (connected) continue;
                try {
                    Thread.sleep(sleepmillis);
                }
                catch (Exception e16) {
                    // empty catch block
                }
            }
            try {
                int i7 = 0;
                while (i7 < 100000 && instream.read() != -1) {
                    ++i7;
                }
                instream.close();
            }
            catch (Exception i7) {
                // empty catch block
            }
            hsyco.errorLog("ioMonitor - quit [" + this.ioIndex + "]");
            SystemState.ioServersInitializedSet(this.ioIndex, false);
        } else if (type == 7) {
            String servername = Configuration.ioServersName.elementAt(this.ioIndex);
            URL ioEventsUrl = null;
            URL ioStatesUrl = null;
            String username = null;
            String password = null;
            long sleepmillis = 1000L;
            String topEventTS = "";
            int topEventSeq = -1;
            boolean synched = false;
            int connection = -1;
            SystemState.ioServersInitializedSet(this.ioIndex, false);
            try {
                username = Configuration.ioServersUser.elementAt(this.ioIndex);
                password = Configuration.ioServersPassword.elementAt(this.ioIndex);
                String host = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getHostName();
                int port = Configuration.ioServersTCPAddress.elementAt(this.ioIndex).getPort();
                ioEventsUrl = new URL(port == 443 ? "https" : "http", host, port, "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3AEventMessages%20action%3D%22LR%22%20%20recordOffset%3D%220%22%20recordCount%3D%2240%22%2F%3E%0A%3C%2FVertXMessage%3E");
                ioStatesUrl = new URL(port == 443 ? "https" : "http", host, port, "/cgi-bin/vertx_xml.cgi?XML=%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%0A%3CVertXMessage%3E%0A%3Chid%3ADoors%20action%3D%22LR%22%20responseFormat%3D%22status%22%20%2F%3E%0A%3C%2FVertXMessage%3E");
            }
            catch (Exception e17) {
                hsyco.errorLog("ioMonitor - Initialization exception [" + this.ioIndex + "] - " + e17.getLocalizedMessage());
                return;
            }
            this.dispatcher = true;
            if (SystemState.ioServersSocket[this.ioIndex] == null) {
                SystemState.ioServersSocket[this.ioIndex] = new Socket();
            }
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e18) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e18);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
                events.eventsExec("IOSTART" + servername, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            SystemState.ioServersInitializedSet(this.ioIndex, true);
            hsyco.messageLog("ioMonitor - started [" + this.ioIndex + "]");
            while (!this.quit) {
                block304: {
                    try {
                        long t;
                        this.heartbeat = t = System.currentTimeMillis();
                        HttpResponse resp = util.httpGet(ioEventsUrl, username, password);
                        if (resp.code == 200) {
                            if (resp.content.startsWith("<?xml")) {
                                int idx = resp.content.length() - 1;
                                int seq = -1;
                                String ts = "";
                                while ((idx = resp.content.lastIndexOf("<hid:EventMessage ", idx - 1)) != -1) {
                                    try {
                                        String message = resp.content.substring(idx + 18, resp.content.indexOf("/>", idx + 18)).trim();
                                        String messagets = util.readParamString(message, "timestamp");
                                        if (ts.equals(messagets)) {
                                            ++seq;
                                        } else {
                                            seq = 0;
                                            ts = messagets;
                                        }
                                        int comp = topEventTS.compareTo(ts);
                                        if (comp > 0 || comp == 0 && topEventSeq >= seq) continue;
                                        topEventTS = ts;
                                        topEventSeq = seq;
                                        if (!synched) continue;
                                        int event = Integer.parseInt(util.readParamString(message, "eventType"));
                                        String s = util.readParamString(message, "readerAddress");
                                        String readeraddress = s != null ? "." + s : "";
                                        switch (event) {
                                            case 1022: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "card.notfound", util.readParamString(message, "rawCardNumber"));
                                                break;
                                            }
                                            case 1023: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "pin.notfound", util.readParamString(message, "rawCardNumber"));
                                                break;
                                            }
                                            case 2020: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "access.granted", util.readParamString(message, "surname"));
                                                break;
                                            }
                                            case 2021: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "access.granted.extended", util.readParamString(message, "surname"));
                                                break;
                                            }
                                            case 2024: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "access.denied.schedule", util.readParamString(message, "surname"));
                                                break;
                                            }
                                            case 2036: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "access.denied.expired", util.readParamString(message, "surname"));
                                                break;
                                            }
                                            case 2043: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "card.notassigned", util.readParamString(message, "rawCardNumber"));
                                                break;
                                            }
                                            case 2046: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "access.denied.pin.expired", util.readParamString(message, "surname"));
                                                break;
                                            }
                                            case 4034: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "alarm.acknowledged", util.readParamString(message, "ioState"));
                                                SystemState.ioWrite(String.valueOf(servername) + readeraddress + "." + "command.alarm", null);
                                                break;
                                            }
                                            case 4035: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "door.lock.schedule", util.readParamString(message, "ioState"));
                                                break;
                                            }
                                            case 4036: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "door.unlock.schedule", util.readParamString(message, "ioState"));
                                                break;
                                            }
                                            case 4041: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "alarm.door.forced", util.readParamString(message, "ioState"));
                                                break;
                                            }
                                            case 4042: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "alarm.open", util.readParamString(message, "ioState"));
                                                break;
                                            }
                                            case 4043: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "alarm.tamper", util.readParamString(message, "ioState"));
                                                break;
                                            }
                                            case 12031: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "access.granted.manual", util.readParamString(message, "commandStatus"));
                                                SystemState.ioWrite(String.valueOf(servername) + readeraddress + "." + "command.access", null);
                                                break;
                                            }
                                            case 12032: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "door.unlock", util.readParamString(message, "commandStatus"));
                                                SystemState.ioWrite(String.valueOf(servername) + readeraddress + "." + "command.door", null);
                                                break;
                                            }
                                            case 12033: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + "door.lock", util.readParamString(message, "commandStatus"));
                                                SystemState.ioWrite(String.valueOf(servername) + readeraddress + "." + "command.door", null);
                                                break;
                                            }
                                            case 7020: {
                                                break;
                                            }
                                            default: {
                                                SystemState.ioWriteForced(String.valueOf(servername) + readeraddress + "." + event, "1");
                                                hsyco.errorLog("ioMonitor - HID unknown event [" + this.ioIndex + "] - " + message);
                                                break;
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                synched = true;
                            }
                        } else {
                            this.quit = true;
                            break;
                        }
                        try {
                            Thread.sleep(sleepmillis / 10L);
                        }
                        catch (Exception idx) {
                            // empty catch block
                        }
                        resp = util.httpGet(ioStatesUrl, username, password);
                        if (resp.code == 200) {
                            if (!resp.content.startsWith("<?xml")) break block304;
                            int idx = resp.content.indexOf("<hid:Door ");
                            try {
                                String message = resp.content.substring(idx + 10, resp.content.indexOf(">", idx + 10)).trim();
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.name", util.readParamString(message, "doorName"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.alarm.tamper", util.readParamString(message, "tamperAlarmState"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.alarm.ac", util.readParamString(message, "acAlarmState"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.alarm.battery", util.readParamString(message, "batteryAlarmState"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.alarm.door.held", util.readParamString(message, "doorHeldAlarmState"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.alarm.door.forced", util.readParamString(message, "doorForcedAlarmState"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.relay", util.readParamString(message, "relayState"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.relay.aux", util.readParamString(message, "auxRelayState"));
                                SystemState.ioWrite(String.valueOf(servername) + "." + "state.relay.alert", util.readParamString(message, "relayAlertState"));
                                if (connection != 1) {
                                    connection = 1;
                                    SystemState.ioWrite(String.valueOf(servername) + "." + "connection", "online");
                                }
                                break block304;
                            }
                            catch (Exception exception) {}
                            break block304;
                        }
                        this.quit = true;
                        break;
                    }
                    catch (Exception e19) {
                        hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.ioIndex + "] - " + e19.getLocalizedMessage());
                        this.quit = true;
                    }
                }
                try {
                    Thread.sleep(sleepmillis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SystemState.ioWrite(String.valueOf(servername) + "." + "connection", "offline");
            hsyco.errorLog("ioMonitor - quit [" + this.ioIndex + "]");
            SystemState.ioServersInitializedSet(this.ioIndex, false);
        } else if (type == 8) {
            Domino driver = new Domino();
            driver.monitor(this.ioIndex, this);
        } else if (type == 10) {
            Nuvo driver = new Nuvo();
            driver.monitor(this.ioIndex, this);
        } else if (type == 11) {
            Elsner driver = new Elsner();
            driver.monitor(this.ioIndex, this);
        } else if (type == 12) {
            YamahaRX driver = new YamahaRX();
            driver.monitor(this.ioIndex, this);
        } else if (type == 13) {
            RayControl driver = new RayControl();
            driver.monitor(this.ioIndex, this);
        } else if (type == 14) {
            EscVP driver = new EscVP();
            driver.monitor(this.ioIndex, this);
        } else if (type == 15) {
            MNet driver = new MNet();
            driver.monitor(this.ioIndex, this);
        } else if (type == 16) {
            Contatto driver = new Contatto();
            driver.monitor(this.ioIndex, this);
        } else if (type == 17) {
            PowerOne driver = new PowerOne();
            driver.monitor(this.ioIndex, this);
        } else if (type == 18) {
            KnxBaos driver = new KnxBaos();
            driver.monitor(this.ioIndex, this);
        } else if (type == 19) {
            Knx driver = new Knx();
            driver.monitor(this.ioIndex, this);
        } else if (type == 9) {
            MyHome driver = new MyHome();
            driver.monitor(this.ioIndex, this);
        } else if (type == 48) {
            MyHomeSDK driver = new MyHomeSDK();
            driver.monitor(this.ioIndex, this);
        } else if (type == 21) {
            Airzone driver = new Airzone();
            driver.monitor(this.ioIndex, this);
        } else if (type == 22) {
            Tridonic driver = new Tridonic();
            driver.monitor(this.ioIndex, this);
        } else if (type == 23) {
            DummyIO driver = new DummyIO();
            driver.monitor(this.ioIndex, this);
        } else if (type == 24) {
            ISMG driver = new ISMG();
            driver.monitor(this.ioIndex, this);
        } else if (type == 25) {
            Daikin driver = new Daikin();
            driver.monitor(this.ioIndex, this);
        } else if (type == 26) {
            WXOnline driver = new WXOnline();
            driver.monitor(this.ioIndex, this);
        } else if (type == 27) {
            AxisDecoder driver = new AxisDecoder();
            driver.monitor(this.ioIndex, this);
        } else if (type == 28) {
            Guardall driver = new Guardall();
            driver.monitor(this.ioIndex, this);
        } else if (type == 29) {
            Tlab driver = new Tlab();
            driver.monitor(this.ioIndex, this);
        } else if (type == 30) {
            CSX75 driver = new CSX75();
            driver.monitor(this.ioIndex, this);
        } else if (type == 32) {
            FP2000 driver = new FP2000();
            SystemState.ioServersMonitorThreadSet(this.ioIndex, driver);
            driver.monitor(this.ioIndex, this);
            SystemState.ioServersMonitorThreadSet(this.ioIndex, null);
        } else if (type == 31) {
            RIO driver = new RIO();
            driver.monitor(this.ioIndex, this);
        } else if (type == 33) {
            ELMO driver = new ELMO();
            driver.monitor(this.ioIndex, this);
        } else if (type == 34) {
            BACnet driver = new BACnet();
            driver.monitor(this.ioIndex, this);
        } else if (type == 35) {
            ATS driver = new ATS();
            driver.monitor(this.ioIndex, this);
        } else if (type == 36) {
            ATON driver = new ATON();
            driver.monitor(this.ioIndex, this);
        } else if (type == 37) {
            GSM driver = new GSM();
            driver.monitor(this.ioIndex, this);
        } else if (type == 38) {
            SystemStatus driver = new SystemStatus();
            driver.monitor(this.ioIndex, this);
        } else if (type == 39) {
            INIM driver = new INIM();
            driver.monitor(this.ioIndex, this);
        } else if (type == 40) {
            Wyrestorm driver = new Wyrestorm();
            driver.monitor(this.ioIndex, this);
        } else if (type == 41) {
            SIP driver = new SIP();
            driver.monitor(this.ioIndex, this);
        } else if (type == 42) {
            NOTIFIER driver = new NOTIFIER();
            driver.monitor(this.ioIndex, this);
        } else if (type == 43) {
            Arduino driver = new Arduino();
            driver.monitor(this.ioIndex, this);
        } else if (type == 44) {
            Galaxy driver = new Galaxy();
            driver.monitor(this.ioIndex, this);
        } else if (type == 45) {
            GKBus driver = new GKBus();
            driver.monitor(this.ioIndex, this);
        } else if (type == 3) {
            Modbus driver = new Modbus();
            driver.monitor(this.ioIndex, this);
        } else if (type == 46) {
            ModbusServer driver = new ModbusServer();
            driver.monitor(this.ioIndex, this);
        } else if (type == 47) {
            Hephais driver = new Hephais();
            driver.monitor(this.ioIndex, this);
        } else if (type == 49) {
            ParadoxDriver driver = new ParadoxDriver();
            driver.monitor(this.ioIndex, this);
        } else if (type == 50) {
            BentelDriver driver = new BentelDriver();
            driver.monitor(this.ioIndex, this);
        } else if (type == 51) {
            TecnoalarmDriver driver = new TecnoalarmDriver();
            driver.monitor(this.ioIndex, this);
        } else if (type == 52) {
            SSH driver = new SSH();
            driver.monitor(this.ioIndex, this);
        } else if (type == 53) {
            HESA driver = new HESA();
            driver.monitor(this.ioIndex, this);
        } else if (type == 54) {
            Networx driver = new Networx();
            driver.monitor(this.ioIndex, this);
        } else if (type == 100) {
            DriversWrapper driver = new DriversWrapper();
            driver.monitor(this.ioIndex, this);
        }
    }

    static void hwgGetValuesXml(Socket sock, String servername) throws Exception {
        String sensorname = null;
        String sensorid = null;
        sock.setSoTimeout(6000);
        BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream()));
        out.write("GET /values.xml HTTP/1.0\r\n\r\n");
        out.flush();
        int state = 0;
        block7: while (state != -1) {
            String line = in.readLine();
            if (line != null) {
                try {
                    int endindex;
                    int beginindex;
                    String linelow = line.toLowerCase();
                    if (line.indexOf("<Entry>") != -1) {
                        state = 1;
                        sensorid = null;
                    }
                    if (state > 0 && (beginindex = linelow.indexOf("<id>")) != -1) {
                        endindex = linelow.indexOf("</id>");
                        sensorid = line.substring(beginindex + 4, endindex).replaceAll(" ", "");
                    }
                    switch (state) {
                        case 0: {
                            beginindex = linelow.indexOf("<model>");
                            if (beginindex == -1) continue block7;
                            endindex = linelow.indexOf("</model>");
                            SystemState.ioWrite(String.valueOf(servername) + ".model", line.substring(beginindex + 7, endindex).trim());
                            break;
                        }
                        case 1: {
                            beginindex = linelow.indexOf("<name>");
                            if (beginindex == -1) continue block7;
                            endindex = linelow.indexOf("</name>");
                            sensorname = line.substring(beginindex + 6, endindex).replaceAll(" ", "");
                            state = 2;
                            break;
                        }
                        case 2: {
                            beginindex = linelow.indexOf("<value>");
                            if (beginindex != -1) {
                                String key = (String.valueOf(servername) + "." + sensorname).toLowerCase();
                                endindex = linelow.indexOf("</value>");
                                if (sensorid != null && !SystemState.HwgMonitorNameIdMap.containsKey(key)) {
                                    SystemState.HwgMonitorNameIdMap.put(key, sensorid);
                                }
                                SystemState.ioWrite(String.valueOf(servername) + "." + sensorname, line.substring(beginindex + 7, endindex).trim());
                                break;
                            }
                            beginindex = linelow.indexOf("<counter>");
                            if (beginindex != -1) {
                                endindex = linelow.indexOf("</counter>");
                                SystemState.ioWrite(String.valueOf(servername) + "." + sensorname + ".cnt", line.substring(beginindex + 9, endindex).trim());
                                break;
                            }
                            beginindex = linelow.indexOf("<cnt>");
                            if (beginindex != -1) {
                                endindex = linelow.indexOf("</cnt>");
                                SystemState.ioWrite(String.valueOf(servername) + "." + sensorname + ".cnt", line.substring(beginindex + 5, endindex).trim());
                                break;
                            }
                            beginindex = linelow.indexOf("<units>");
                            if (beginindex == -1) continue block7;
                            endindex = linelow.indexOf("</units>");
                            SystemState.ioWrite(String.valueOf(servername) + "." + sensorname + ".units", line.substring(beginindex + 7, endindex).trim());
                        }
                    }
                }
                catch (Exception e2) {
                    hsyco.messageLog("ioMonitor [" + servername + "] - Exception:" + e2 + " at: " + line);
                }
                continue;
            }
            state = -1;
        }
        in.close();
        out.close();
    }
}

