/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.AudioServer;
import com.hsyco.Configuration;
import com.hsyco.DualSDTools;
import com.hsyco.HTTPServer;
import com.hsyco.HttpResponse;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.SystemTime;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.user;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class driverBase {
    private String driverName = "_NOTSET_";
    private String driverNamePrefix = "_NOTSET_.";
    ArrayBlockingQueue<String> ioqtx;
    protected static final int LIGHT = 1;
    protected static final int AUTOM = 2;
    protected static final int DIMMER = 11;
    protected static final int BINARY = 100;

    protected boolean init(String name) {
        this.driverName = new String(name);
        this.driverNamePrefix = String.valueOf(this.driverName) + ".";
        this.ioqtx = Configuration.ioQueueTx.elementAt(Configuration.ioServersName.indexOf(name));
        return false;
    }

    protected void enableSystemtopoDiscovery() {
        Configuration.systemtopoDiscovery = true;
    }

    protected boolean haActiveState() {
        return SystemState.haActiveStateGet();
    }

    protected long getNextSunrise(long now, boolean withoffset) {
        return util.getNextSunrise(now, withoffset);
    }

    protected long getNextSunset(long now, boolean withoffset) {
        return util.getNextSunset(now, withoffset);
    }

    protected void ioSet(String name, String value) {
        SystemState.ioSet(String.valueOf(this.driverNamePrefix) + name, value);
    }

    protected void ioWrite(String name, String value) {
        SystemState.ioWrite(String.valueOf(this.driverNamePrefix) + name, value);
    }

    protected void ioWriteNoLog(String name, String value) {
        SystemState.ioWriteNoLog(String.valueOf(this.driverNamePrefix) + name, value);
    }

    protected void ioWriteNoEvents(String name, String value) {
        SystemState.ioWriteNoEvents(String.valueOf(this.driverNamePrefix) + name, value);
    }

    protected void ioWriteNoEventsNoLog(String name, String value) {
        SystemState.ioWriteNoEventsNoLog(String.valueOf(this.driverNamePrefix) + name, value);
    }

    protected void ioWriteForced(String name, String value) {
        SystemState.ioWriteForced(String.valueOf(this.driverNamePrefix) + name, value);
    }

    protected void ioWriteForcedNoLog(String name, String value) {
        SystemState.ioWriteForcedNoLog(String.valueOf(this.driverNamePrefix) + name, value);
    }

    protected void deviceSet(int function, String device, String state, String comment) {
        SystemState.deviceSet(false, function, String.valueOf(this.driverNamePrefix) + device, state, comment);
    }

    protected void uiClear(String session) {
        SystemState.uiClear(session);
    }

    protected void uiSet(String session, String id, String attr, String value) {
        SystemState.uiSet(session, String.valueOf(this.driverNamePrefix) + id, attr, value);
    }

    protected void uiSet(String id, String attr, String value) {
        SystemState.uiSet(String.valueOf(this.driverNamePrefix) + id, attr, value);
    }

    protected void messageLog(String message) {
        hsyco.messageLog(message);
    }

    protected void errorLog(String message) {
        hsyco.errorLog(message);
    }

    protected void fileLog(String pathname, String message) {
        util.fileLog(pathname, message);
    }

    protected boolean isVerboseLog() {
        return Configuration.verboseLog;
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void sleepNano(long nanos) {
        try {
            Thread.sleep(nanos / 1000000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String readComm(String portName, int len) {
        return util.readComm(portName, len);
    }

    protected byte[] readCommBytes(String portName, int len) {
        return util.readCommBytes(portName, len);
    }

    protected int writeComm(String portName, String data) {
        return util.writeComm(portName, data);
    }

    protected int writeCommBytes(String portName, byte[] data) {
        return util.writeCommBytes(portName, data);
    }

    protected void closeComm(String portName) {
        util.closeComm(portName);
    }

    protected String varGet(String name) {
        return SystemState.varGet(name);
    }

    protected void varSet(String name, String value) {
        SystemState.varSet(name, value);
    }

    protected int sendMail(String to, String from, String subject, String body) {
        block3: {
            try {
                String[] ta = to.split("@");
                if (ta.length == 2 && ta[1].length() >= 4 && body != null) break block3;
                return -1;
            }
            catch (Exception e2) {
                return -1;
            }
        }
        Vector<String> bv = new Vector<String>();
        bv.add(body);
        return util.sendMail(to, from, subject, bv);
    }

    protected int sendMail(String to, String from, String subject, Vector<String> body) {
        block3: {
            try {
                String[] ta = to.split("@");
                if (ta.length == 2 && ta[1].length() >= 4 && body != null) break block3;
                return -1;
            }
            catch (Exception e2) {
                return -1;
            }
        }
        return util.sendMail(to, from, subject, body);
    }

    protected void user(String name, String param) {
        try {
            if (PluginsWrapper.interceptUserKeys(null, null, name, param, null) == null) {
                switch (Configuration.userCommandMode) {
                    case 1: {
                        user.userCommand(name, param);
                        break;
                    }
                    case 2: {
                        user.userCommand(null, name, param);
                        break;
                    }
                    case 3: {
                        user.userCommand(null, null, name, param);
                        break;
                    }
                    default: {
                        user.virtualRemote(name, param);
                    }
                }
                userCode.userCommand(null, null, name, param);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        events.eventsExec("USER" + name, 0, 0, param);
    }

    protected int audioPlay(String where, File file) {
        try {
            return AudioServer.file(where, file.getCanonicalPath());
        }
        catch (Exception e2) {
            return -1;
        }
    }

    protected int audioPlay(String where, String voice, String text) {
        return AudioServer.voice(where, voice, text);
    }

    protected boolean dateSet(int year, int month, int day, int hour, int minute, int second) {
        return SystemTime.execDate(year, month, day, hour, minute, second);
    }

    protected static String urlGet(String url, String user2, String password) {
        try {
            HttpResponse r = util.httpGet(new URL(url), user2, password);
            if (r.code != -1) {
                return String.valueOf(r.code) + ":" + r.content;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static String urlPost(String url, String contenttype, String data, String user2, String password) {
        try {
            HttpResponse r = util.httpPostRead(new URL(url), contenttype, data, user2, password);
            if (r.code != -1) {
                return String.valueOf(r.code) + ":" + r.content;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String commandPoll(int millis) {
        try {
            if (millis > 0) {
                return this.ioqtx.poll(millis, TimeUnit.MILLISECONDS);
            }
            return this.ioqtx.poll();
        }
        catch (Exception e2) {
            return null;
        }
    }

    protected void exit() {
        SystemState.exitRequest = true;
    }

    protected int ioLimitsReservationRequest(int n2) {
        return hsyco.ioLimitsReservationRequest(n2);
    }

    protected void registerMainLoopHeartbeat(boolean register) {
        String className = this.getClass().getCanonicalName();
        if (className.equals("drivers.ionopimax.Driver") || className.equals("drivers.strato.Driver")) {
            if (register) {
                hsyco.registerMainLoopHeatbeatHook(this);
            } else {
                hsyco.unregisterMainLoopHeatbeatHook(this);
            }
        }
    }

    protected void registerDualSdSync(boolean register) {
        String className = this.getClass().getCanonicalName();
        if (className.equals("drivers.ionopimax.Driver") || className.equals("drivers.strato.Driver")) {
            if (register) {
                DualSDTools.registerHook(this);
            } else {
                DualSDTools.unregisterHook(this);
            }
        }
    }

    protected void registerDueluxHook(String key, Object server, boolean register) {
        String className = this.getClass().getCanonicalName();
        if (className.equals("drivers.duelux.Driver")) {
            if (register) {
                HTTPServer.registerDueluxHook(key, server);
            } else {
                HTTPServer.registerDueluxHook(key, server);
            }
        }
    }

    protected void registerDueluxFxpXtHook(String key, Object server) {
        String className = this.getClass().getCanonicalName();
        if (className.equals("drivers.duelux.Driver")) {
            HTTPServer.registerDueluxFxpXtHook(key, server);
        }
    }
}

