/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.DualSDTools;
import com.hsyco.SunPosition;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class UserTimeCallServer
extends Thread {
    public long heartbeat = 0L;
    private static final Executor exec = Executors.newCachedThreadPool();
    private static long defragtime = System.currentTimeMillis();
    private static Boolean backupSemaphore = false;

    UserTimeCallServer() {
    }

    @Override
    public void run() {
        Calendar calNow = Calendar.getInstance();
        int oldAzimuth = -1;
        int oldElevation = -1;
        hsyco.messageLog("User Time Callback Server started");
        try {
            while (true) {
                int az;
                boolean elchange;
                boolean azchange;
                this.heartbeat = System.currentTimeMillis();
                calNow.setTimeInMillis(this.heartbeat);
                long wi = 500 + (60 - calNow.get(13)) * 1000 - calNow.get(14);
                Thread.sleep(wi);
                final long t = System.currentTimeMillis();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userCode.TimeEvent(t);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("Exception in user event call: TimeEvent()" + e2);
                        }
                        events.eventsExec("TIME", 0, 0, null);
                    }
                };
                exec.execute(task);
                SunPosition pos = new SunPosition(Configuration.Latitude, Configuration.Longitude);
                int azimuth = pos.getAzimuth();
                int elevation = pos.getElevation();
                if (azimuth != oldAzimuth) {
                    oldAzimuth = azimuth;
                    azchange = true;
                } else {
                    azchange = false;
                }
                if (elevation != oldElevation) {
                    oldElevation = elevation;
                    elchange = true;
                } else {
                    elchange = false;
                }
                if (azchange || elchange) {
                    SystemState.sunPositionSet(azimuth, elevation);
                    az = azimuth;
                    final int el = elevation;
                    Runnable sun = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.SunPositionEvent(az, el);
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("Exception in user event call: SunPositionEvent()" + e2);
                            }
                        }
                    };
                    exec.execute(sun);
                }
                if (azchange) {
                    az = azimuth;
                    Runnable sun = new Runnable(){

                        @Override
                        public void run() {
                            events.eventsExec("SUNAZIMUTH", az, 0, null);
                        }
                    };
                    exec.execute(sun);
                }
                if (elchange) {
                    final int el = elevation;
                    Runnable sun = new Runnable(){

                        @Override
                        public void run() {
                            events.eventsExec("SUNELEVATION", el, 0, null);
                        }
                    };
                    exec.execute(sun);
                }
                Runnable backup = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Boolean bl = backupSemaphore;
                        synchronized (bl) {
                            if (!backupSemaphore.booleanValue()) {
                                backupSemaphore = true;
                            }
                        }
                        if (backupSemaphore.booleanValue()) {
                            SystemState.hsycoDatabaseCheckPoint();
                            DualSDTools.mirror();
                            if (Configuration.RootBackupDay != null && hsyco.rootBackupTimeCheck()) {
                                SystemState.hsycoDatabaseHousekeeping();
                                defragtime = t;
                                if (Configuration.RootBackupDestinations != null) {
                                    hsyco.rootBackup();
                                }
                            }
                            if (t > defragtime + 86400000L) {
                                SystemState.hsycoDatabaseHousekeeping();
                                defragtime = t;
                            }
                            backupSemaphore = false;
                        }
                    }
                };
                exec.execute(backup);
                if (hsyco.databaseCompactTimeCheck()) {
                    FileOutputStream fos = new FileOutputStream(".dbcompact");
                    fos.write(66);
                    fos.close();
                    hsyco.messageLog("HSYCO Database: Initiating optimization procedure. HSYCO will restart shortly...");
                    SystemState.exitRequest = true;
                }
                Thread.sleep(30000L);
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Exception in user time server main loop");
            return;
        }
    }
}

