/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import java.util.Calendar;
import java.util.TimeZone;

public class SunPosition {
    private int azimuth = -1;
    private int elevation = -1;

    public SunPosition(double latitude, double longitude) {
        this.compute(System.currentTimeMillis(), TimeZone.getDefault(), latitude, longitude);
    }

    public SunPosition(Calendar cal, double latitude, double longitude) {
        this.compute(cal.getTimeInMillis(), cal.getTimeZone(), latitude, longitude);
    }

    private void compute(long time, TimeZone zone, double latitude, double longitude) {
        double szarad;
        double sza;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        double latrad = Math.toRadians(latitude);
        cal.setTimeInMillis(time);
        double hour = (double)cal.get(11) + (double)cal.get(12) / 60.0;
        double g2 = 0.9856262833675564 * ((double)cal.get(6) + hour / 24.0);
        double grad = Math.toRadians(g2);
        double drad = Math.toRadians(0.396372 - 22.91327 * Math.cos(grad) + 4.02543 * Math.sin(grad) - 0.387205 * Math.cos(2.0 * grad) + 0.051967 * Math.sin(2.0 * grad) - 0.154527 * Math.cos(3.0 * grad) + 0.084798 * Math.sin(3.0 * grad));
        double tc = 0.004297 + 0.107029 * Math.cos(grad) - 1.837877 * Math.sin(grad) - 0.837378 * Math.cos(2.0 * grad) - 2.340475 * Math.sin(2.0 * grad);
        double sha = (hour - 12.0) * 15.0 + longitude + tc;
        if (sha > 180.0) {
            sha -= 360.0;
        } else if (sha < -180.0) {
            sha += 360.0;
        }
        double szacos = Math.sin(latrad) * Math.sin(drad) + Math.cos(latrad) * Math.cos(drad) * Math.cos(Math.toRadians(sha));
        if (szacos > 1.0) {
            sza = 0.0;
            szarad = 0.0;
        } else if (szacos < -1.0) {
            sza = 180.0;
            szarad = Math.PI;
        } else {
            szarad = Math.acos(szacos);
            sza = Math.toDegrees(szarad);
        }
        this.elevation = 90 - Math.round((float)sza);
        double azcos = (Math.sin(drad) - Math.sin(latrad) * Math.cos(szarad)) / (Math.cos(latrad) * Math.sin(szarad));
        this.azimuth = sha < 0.0 ? Math.round((float)Math.toDegrees(Math.acos(azcos))) : 360 - Math.round((float)Math.toDegrees(Math.acos(azcos)));
    }

    public int getAzimuth() {
        return this.azimuth;
    }

    public int getElevation() {
        return this.elevation;
    }
}

