/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.SCPOutputStream;
import ch.ethz.ssh2.Session;
import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SSH {
    private static final int COMMAND_POLL_INTERVAL = 30000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static Hashtable<String, String> serverUser = new Hashtable();
    private static Hashtable<String, String> serverPassword = new Hashtable();
    ioMonitor me;
    private int ioIndex;
    private String serverName;
    private String serverHost;
    private int serverPort = 22;
    private int stdoutMode = 1;
    private boolean persistentconnection = true;
    private ArrayBlockingQueue<String> ioqtx;
    private Connection connection = null;
    private Session session = null;
    private InputStreamReader stdout = null;
    private InputStreamReader stderr = null;

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.me = me;
        this.ioIndex = ioIndex;
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim();
                if (param.equalsIgnoreCase("stdout")) {
                    if ("true".equalsIgnoreCase(value)) {
                        this.stdoutMode = 1;
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.stdoutMode = 0;
                    } else if ("line".equalsIgnoreCase(value)) {
                        this.stdoutMode = 2;
                    }
                } else if (param.equalsIgnoreCase("persistentconnection")) {
                    this.persistentconnection = Boolean.parseBoolean(value);
                }
            }
            ++i2;
        }
        try {
            InetSocketAddress a2 = Configuration.ioServersTCPAddress.elementAt(ioIndex);
            this.serverHost = a2.getAddress().getHostAddress();
            this.serverPort = a2.getPort();
            serverUser.put(this.serverName, Configuration.ioServersUser.elementAt(ioIndex));
            serverPassword.put(this.serverName, Configuration.ioServersPassword.elementAt(ioIndex));
            if (this.persistentconnection && !this.connect()) {
                hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
                return;
            }
            this.initialize();
        }
        catch (Exception e2) {
            hsyco.errorLog("ioMonitor - initialization error [" + this.serverName + "] : " + e2.getLocalizedMessage());
            hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
            return;
        }
        this.heartbeat();
        try {
            while (!me.quit) {
                String cmd = this.ioqtx.poll(30000L, TimeUnit.MILLISECONDS);
                if (cmd == null) {
                    if (this.persistentconnection) {
                        if (!this.echo()) continue;
                        this.heartbeat();
                        continue;
                    }
                    this.disconnect();
                    this.heartbeat();
                    continue;
                }
                if (!this.commandExecutor(cmd)) continue;
                this.heartbeat();
            }
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - main loop exception [" + this.serverName + "] : " + e3.getLocalizedMessage());
        }
        this.disconnect();
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
    }

    private boolean commandExecutor(String cmd) throws Exception {
        block14: {
            String value;
            String command;
            block16: {
                block15: {
                    int equalidx = cmd.indexOf(61);
                    if (equalidx <= 0) break block14;
                    command = cmd.substring(0, equalidx).toLowerCase();
                    value = cmd.substring(equalidx + 1).trim();
                    if (command.equals("exec")) {
                        if (!this.persistentconnection) {
                            this.connect();
                        }
                        return this.exec(value, 30000);
                    }
                    if (command.startsWith("exec.")) {
                        if (!this.persistentconnection) {
                            this.connect();
                        }
                        return this.exec(value, Integer.parseInt(command.substring(5)));
                    }
                    if (command.equals("get")) {
                        String[] files = this.splitFileNames(value);
                        if (!this.persistentconnection) {
                            this.connect();
                        }
                        return this.get(files[0], files[1]);
                    }
                    if (command.equals("put")) {
                        String[] files = this.splitFileNames(value);
                        if (!this.persistentconnection) {
                            this.connect();
                        }
                        return this.put(files[0], files[1]);
                    }
                    if (!command.equals("connection")) break block15;
                    if (value.equalsIgnoreCase("close")) {
                        this.disconnect();
                        return true;
                    }
                }
                if (!command.equals("user")) break block16;
                serverUser.put(this.serverName, value.length() > 0 ? value : Configuration.ioServersUser.elementAt(this.ioIndex));
                return true;
            }
            try {
                if (command.equals("password")) {
                    serverPassword.put(this.serverName, value.length() > 0 ? value : Configuration.ioServersPassword.elementAt(this.ioIndex));
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    boolean get(String source, String dest) {
        SCPClient scp = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            File df = new File(dest);
            if (df.getCanonicalPath().startsWith(new File(".").getCanonicalPath())) {
                byte[] buffer = new byte[8096];
                scp = this.connection.createSCPClient();
                os = new BufferedOutputStream(new FileOutputStream(df));
                is = new BufferedInputStream(scp.get(source));
                int counter = 0;
                int total = 0;
                while (counter != -1) {
                    counter = is.read(buffer);
                    if (counter <= 0) continue;
                    os.write(buffer, 0, counter);
                    total += counter;
                    this.heartbeat();
                }
                os.flush();
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".get", Integer.toString(total));
                return true;
            }
        }
        catch (Exception e2) {
            if (Configuration.verboseLog) {
                hsyco.errorLog("SSH get exception [" + this.serverName + "]: " + e2.getMessage());
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
        SystemState.ioWriteForced(String.valueOf(this.serverName) + ".get", "error");
        return false;
    }

    boolean put(String source, String dest) {
        SCPClient scp = null;
        InputStream is = null;
        OutputStream os = null;
        SCPOutputStream scpos = null;
        try {
            File sf = new File(source);
            if (sf.getCanonicalPath().startsWith(new File(".").getCanonicalPath())) {
                int sep = dest.lastIndexOf(47);
                byte[] buffer = new byte[8096];
                scp = this.connection.createSCPClient();
                scpos = sep > 0 ? scp.put(dest.substring(sep + 1), sf.length(), dest.substring(0, sep), null) : (sep == 0 ? scp.put(dest.substring(1), sf.length(), "/", null) : scp.put(dest.substring(sep + 1), sf.length(), "", null));
                os = new BufferedOutputStream(scpos);
                is = new BufferedInputStream(new FileInputStream(sf));
                int counter = 0;
                int total = 0;
                while (counter != -1) {
                    counter = is.read(buffer);
                    if (counter <= 0) continue;
                    os.write(buffer, 0, counter);
                    total += counter;
                    this.heartbeat();
                }
                os.flush();
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".put", Integer.toString(total));
                return true;
            }
        }
        catch (Exception e2) {
            if (Configuration.verboseLog) {
                hsyco.errorLog("SSH put exception [" + this.serverName + "]: " + e2.getMessage());
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                scpos.close();
            }
            catch (Exception exception) {}
        }
        SystemState.ioWriteForced(String.valueOf(this.serverName) + ".put", "error");
        return false;
    }

    String[] splitFileNames(String data) {
        StringBuffer f1 = new StringBuffer();
        StringBuffer f2 = new StringBuffer();
        int status = 0;
        boolean esc = false;
        try {
            int i2 = 0;
            while (i2 < data.length()) {
                char ch = data.charAt(i2);
                if (esc) {
                    esc = false;
                    switch (status) {
                        case 1: {
                            f1.append(ch);
                            break;
                        }
                        case 2: {
                            f2.append(ch);
                        }
                    }
                } else {
                    block5 : switch (ch) {
                        case ' ': {
                            switch (status) {
                                case 1: {
                                    status = -1;
                                    break;
                                }
                                case 2: {
                                    status = -2;
                                }
                            }
                            break;
                        }
                        case '\\': {
                            esc = true;
                            break;
                        }
                        default: {
                            switch (status) {
                                case 0: {
                                    status = 1;
                                }
                                case 1: {
                                    f1.append(ch);
                                    break block5;
                                }
                                case -1: {
                                    status = 2;
                                }
                                case 2: {
                                    f2.append(ch);
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
            String[] r = new String[]{f1.toString(), f2.toString()};
            return r;
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    boolean echo() {
        if (this.persistentconnection) {
            this.session = this.connection.openSession();
            this.session.execCommand("echo");
            boolean bl = (this.session.waitForCondition(32, 30000L) & 1) == 0;
            try {
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
            catch (Exception e2) {
                try {
                    this.session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
                catch (Throwable throwable) {
                    try {
                        this.session.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return true;
    }

    boolean exec(String command, int timeoutSeconds) {
        int timeoutMillis = timeoutSeconds * 1000;
        try {
            this.session = this.connection.openSession();
            this.stdout = new InputStreamReader(this.session.getStdout(), "UTF-8");
            this.stderr = new InputStreamReader(this.session.getStderr(), "UTF-8");
            this.session.execCommand(command);
            if (this.stdoutMode == 0) {
                while (this.readOutLine(timeoutMillis) != null) {
                }
                while (this.readErrLine(timeoutMillis) != null) {
                }
            } else if (this.stdoutMode == 2) {
                String line;
                while ((line = this.readOutLine(timeoutMillis)) != null) {
                    SystemState.ioWriteForced(String.valueOf(this.serverName) + ".out", line);
                    this.heartbeat();
                }
                while ((line = this.readErrLine(timeoutMillis)) != null) {
                    SystemState.ioWriteForced(String.valueOf(this.serverName) + ".err", line);
                    this.heartbeat();
                }
            } else {
                String line;
                StringBuffer out = new StringBuffer();
                StringBuffer err = new StringBuffer();
                while ((line = this.readOutLine(timeoutMillis)) != null) {
                    if (out.length() > 0) {
                        out.append("<br>");
                    }
                    out.append(line);
                    this.heartbeat();
                }
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".out", out.toString());
                while ((line = this.readErrLine(timeoutMillis)) != null) {
                    if (err.length() > 0) {
                        out.append("<br>");
                    }
                    err.append(line);
                    this.heartbeat();
                }
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".err", err.toString());
            }
            this.session.waitForCondition(32, timeoutSeconds);
            Integer status = this.session.getExitStatus();
            SystemState.ioWriteForced(String.valueOf(this.serverName) + ".exec", status != null ? Integer.toString(status) : "null");
            return true;
        }
        catch (Exception e2) {
            if (Configuration.verboseLog) {
                hsyco.errorLog("SSH exec exception [" + this.serverName + "]: " + e2.getMessage());
            }
            SystemState.ioWriteForced(String.valueOf(this.serverName) + ".exec", "error");
            return false;
        }
        finally {
            try {
                this.session.close();
            }
            catch (Exception exception) {}
            try {
                this.stdout.close();
            }
            catch (Exception exception) {}
            try {
                this.stderr.close();
            }
            catch (Exception exception) {}
        }
    }

    private String readOutLine(int timeoutMillis) {
        StringBuffer sb = new StringBuffer();
        try {
            while (this.stdout.ready() || (this.session.waitForCondition(4, timeoutMillis) & 4) != 0) {
                int ch = this.stdout.read();
                switch (ch) {
                    case -1: {
                        return sb.length() == 0 ? null : sb.toString();
                    }
                    case 10: {
                        return sb.toString();
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        sb.append((char)ch);
                    }
                }
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private String readErrLine(int timeoutMillis) {
        StringBuffer sb = new StringBuffer();
        try {
            while (this.stderr.ready() || (this.session.waitForCondition(8, timeoutMillis) & 8) != 0) {
                int ch = this.stderr.read();
                switch (ch) {
                    case -1: {
                        return sb.length() == 0 ? null : sb.toString();
                    }
                    case 10: {
                        return sb.toString();
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        sb.append((char)ch);
                    }
                }
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connect() throws Exception {
        try {
            if (this.connection != null) {
                return true;
            }
            this.connection = new Connection(this.serverHost, this.serverPort);
            this.connection.connect(null, 30000, 30000);
            String[] a2 = this.connection.getRemainingAuthMethods(serverUser.get(this.serverName));
            if (a2.length == 0) {
                if (this.connection.authenticateWithNone(serverUser.get(this.serverName))) {
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                    return true;
                }
                hsyco.errorLog("ioMonitor - SSH password authentication failed [" + this.serverName + "]");
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection = null;
                return false;
            }
            File pem = new File(serverPassword.get(this.serverName));
            boolean pemExists = pem.canRead();
            int i2 = 0;
            while (true) {
                if (i2 >= a2.length) {
                    hsyco.errorLog("ioMonitor - SSH authentication failed [" + this.serverName + "]");
                    return false;
                }
                if (a2[i2].equalsIgnoreCase("publickey") && pemExists) {
                    if (this.connection.authenticateWithPublicKey(serverUser.get(this.serverName), pem, null)) {
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                        return true;
                    }
                    hsyco.errorLog("ioMonitor - SSH password authentication failed [" + this.serverName + "]");
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connection = null;
                    return false;
                }
                if (a2[i2].equalsIgnoreCase("password") && !pemExists) {
                    if (this.connection.authenticateWithPassword(serverUser.get(this.serverName), serverPassword.get(this.serverName))) {
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                        return true;
                    }
                    hsyco.errorLog("ioMonitor - SSH password authentication failed [" + this.serverName + "]");
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connection = null;
                    return false;
                }
                if (a2[i2].equalsIgnoreCase("keyboard-interactive") && !pemExists) {
                    authenticationCallback cb = new authenticationCallback();
                    if (this.connection.authenticateWithKeyboardInteractive(serverUser.get(this.serverName), cb)) {
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                        return true;
                    }
                    hsyco.errorLog("ioMonitor - SSH keyboard-interactive authentication failed [" + this.serverName + "]");
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connection = null;
                    return false;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            hsyco.errorLog("ioMonitor - connection exception [" + this.serverName + "] - " + e2.getLocalizedMessage());
            this.connection = null;
            return false;
        }
    }

    private void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        }
    }

    private void initialize() throws Exception {
        SystemState.ioServersInitializedSet(this.ioIndex, true);
        try {
            userCode.IOStartupEvent(this.ioIndex);
        }
        catch (Exception e2) {
            hsyco.errorLog("ioMonitor - exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e2);
        }
        if (this.ioIndex > 0) {
            events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
    }

    private void heartbeat() {
        this.me.heartbeat = System.currentTimeMillis();
    }

    private class authenticationCallback
    implements InteractiveCallback {
        private authenticationCallback() {
        }

        @Override
        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) {
            String[] ret = new String[numPrompts];
            if (numPrompts == 1) {
                ret[0] = (String)serverPassword.get(SSH.this.serverName);
            }
            return ret;
        }
    }
}

