/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ParadoxDriver {
    static final String[] WebObjects = new String[]{"paradox"};
    private static final int COMMAND_DISPATCHER_HEARTBEAT = 30000;
    private String serverName = null;
    int ioIndex;
    private String commPort = null;
    private Object commandLock = new Object();
    private Object housekeepingLock = new Object();
    private final Executor exec = Executors.newCachedThreadPool();
    private boolean guiSupport = true;
    private int language = 0;
    private boolean zoneActivityLog = false;
    private boolean areaNameLog = true;
    private boolean userLogs = false;
    private String[] string = new String[200];
    private ArrayBlockingQueue<String> ioqtx;
    private long commandHeartbeat = 0L;
    CommandDispatcher commandDispatcher;
    private int commandMode = 0;
    private String userPanelCode = "";
    private String userCodeDefault = null;
    private boolean[] areaFlags;
    private boolean troubleFlag;
    private char[][] zoneStatus;
    private String[] zoneList;
    private boolean[] zoneInitialized;
    private char[][] areaStatus;
    private String[] areaList;
    private long[] areaStatusTime;
    private long[] zoneStatusTime;
    private int zoneLastNumber;
    private int zoneMax;
    private String[] zoneName;
    private String[] areaName;
    private String[] userName;
    private boolean[] zoneNameDef;
    private boolean[] areaNameDef;
    private boolean[] userNameDef;
    private LinkedList<String> logList;
    private int logSize;
    private long logTime;
    private long codeKeypadTime;
    private long commTime;
    private long eventTime;
    private short commError;
    private boolean startupCompleted;

    public ParadoxDriver() {
        boolean[] blArray = new boolean[9];
        blArray[1] = true;
        this.areaFlags = blArray;
        this.troubleFlag = false;
        this.zoneStatus = new char[193][5];
        this.zoneList = new String[193];
        this.zoneInitialized = new boolean[193];
        this.areaStatus = new char[9][7];
        this.areaList = new String[9];
        this.areaStatusTime = new long[9];
        this.zoneStatusTime = new long[193];
        this.zoneLastNumber = 0;
        this.zoneMax = 0;
        this.zoneName = new String[193];
        this.areaName = new String[9];
        this.userName = new String[1000];
        this.zoneNameDef = new boolean[193];
        this.areaNameDef = new boolean[9];
        this.userNameDef = new boolean[1000];
        this.logList = new LinkedList();
        this.logSize = 50;
        this.logTime = 0L;
        this.codeKeypadTime = 0L;
        this.eventTime = 0L;
        this.commError = (short)-1;
        this.startupCompleted = false;
    }

    static void migrateToIOServer() {
        Properties p = new Properties();
        Vector<String> names = new Vector<String>();
        Hashtable<String, String> comms = new Hashtable<String, String>();
        try {
            File paradoxfile = new File("paradox.ini");
            if (paradoxfile.canRead()) {
                p.load(new FileInputStream(paradoxfile));
                Enumeration<?> e2 = p.propertyNames();
                while (e2.hasMoreElements()) {
                    String name;
                    String key = e2.nextElement().toString();
                    if (!key.endsWith(".comm") || (name = key.substring(0, key.indexOf(46))).length() <= 0) continue;
                    if (!names.contains(name)) {
                        names.add(name);
                        comms.put(name, p.getProperty(key));
                        continue;
                    }
                    user.errorLog("PARADOX EVO DRIVER - Duplicate ID found and skipped converting paradox.ini to I/O Server: " + name);
                }
                if (names.size() > 0) {
                    String line;
                    String language = p.getProperty("language", null);
                    if (language != null) {
                        language = language.equalsIgnoreCase("it") ? "it" : "en";
                    }
                    String zoneActivityLog = p.getProperty("zoneactivitylog", null);
                    String areaNameLog = p.getProperty("areanamelog", null);
                    File hsycofile = new File("hsyco.ini");
                    BufferedReader hsycor = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(hsycofile), "UTF-8"));
                    Vector<String> hsyco2 = new Vector<String>();
                    int ioserversindex = -1;
                    String ioserverslist = null;
                    while ((line = hsycor.readLine()) != null) {
                        hsyco2.add(line);
                        int eqi = line.indexOf(61);
                        if (eqi <= 0 || !line.substring(0, eqi).trim().equalsIgnoreCase("ioservers")) continue;
                        ioserversindex = hsyco2.size() - 1;
                        ioserverslist = line.substring(eqi + 1).trim();
                    }
                    hsycor.close();
                    if (ioserversindex == -1) {
                        hsyco2.add("");
                        StringBuffer sb = new StringBuffer("ioServers = " + (String)names.elementAt(0));
                        int i2 = 1;
                        while (i2 < names.size()) {
                            sb.append(", ");
                            sb.append((String)names.elementAt(i2));
                            ++i2;
                        }
                        hsyco2.add(sb.toString());
                        ioserversindex = hsyco2.size() - 1;
                    } else {
                        String[] sa = ioserverslist.split("[ ,;]+");
                        int i3 = 0;
                        while (i3 < sa.length) {
                            if (names.contains(sa[i3])) {
                                names.remove(sa[i3]);
                                user.errorLog("PARADOX EVO DRIVER - Existing I/O Server ID found and skipped converting paradox.ini to I/O Server: " + sa[i3]);
                            }
                            ++i3;
                        }
                        if (names.size() > 0) {
                            StringBuffer sb = new StringBuffer((String)hsyco2.elementAt(ioserversindex));
                            int i4 = 0;
                            while (i4 < names.size()) {
                                sb.append(", ");
                                sb.append((String)names.elementAt(i4));
                                ++i4;
                            }
                            hsyco2.set(ioserversindex, sb.toString());
                        }
                    }
                    if (names.size() > 0) {
                        hsyco2.add(ioserversindex + 1, "");
                        int i5 = names.size() - 1;
                        while (i5 >= 0) {
                            String name = (String)names.elementAt(i5);
                            StringBuffer sb = new StringBuffer();
                            if (language != null) {
                                sb.append("language=" + language);
                            }
                            if (zoneActivityLog != null) {
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                sb.append("zoneactivitylog=" + zoneActivityLog);
                            }
                            if (areaNameLog != null) {
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                sb.append("areanamelog=" + areaNameLog);
                            }
                            if (sb.length() > 0) {
                                hsyco2.add(ioserversindex + 2, "ioServersOptions." + name + " = " + sb.toString());
                            }
                            hsyco2.add(ioserversindex + 2, "ioServersComm." + name + " = " + (String)comms.get(name));
                            hsyco2.add(ioserversindex + 2, "ioServersType." + name + " = PARADOX");
                            --i5;
                        }
                        File tempFile = new File(String.valueOf(util.isWindows ? "_" : ".~") + hsycofile.getName());
                        BufferedWriter hsycow = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
                        hsycow.write((String)hsyco2.elementAt(0));
                        int i6 = 1;
                        while (i6 < hsyco2.size()) {
                            hsycow.newLine();
                            hsycow.write((String)hsyco2.elementAt(i6));
                            ++i6;
                        }
                        hsycow.close();
                        if (util.isWindows) {
                            hsycofile.delete();
                        }
                        tempFile.renameTo(hsycofile);
                        hsycofile.setWritable(true, false);
                        user.messageLog("PARADOX EVO DRIVER - Conversion from paradox.ini to I/O Server completed");
                    }
                }
                paradoxfile.delete();
                user.messageLog("PARADOX EVO DRIVER - paradox.ini deleted");
            }
        }
        catch (Exception e3) {
            user.errorLog("PARADOX EVO DRIVER - Unrecoverable error converting paradox.ini to I/O Server: " + e3.getMessage());
        }
    }

    void monitor(int ioIndex, ioMonitor me) {
        Object sb;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioIndex = ioIndex;
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.language = Configuration.language == 1 ? 1 : 0;
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            sb = sa[i2].split("=");
            if (((String[])sb).length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = ((String[])sb).length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("language")) {
                    if ("it".equalsIgnoreCase(value)) {
                        this.language = 1;
                    } else if ("en".equalsIgnoreCase(value)) {
                        this.language = 0;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("maxzone")) {
                    try {
                        int n2 = Integer.parseInt(value);
                        if (n2 < 0 | n2 > 192) {
                            throw new Exception();
                        }
                        this.zoneMax = this.zoneLastNumber = n2;
                        int z = 1;
                        while (z <= this.zoneLastNumber) {
                            this.zoneStatusTime[z] = 1L;
                            ++z;
                        }
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("zoneactivitylog")) {
                    try {
                        this.zoneActivityLog = Boolean.parseBoolean(value);
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("areanamelog")) {
                    try {
                        this.areaNameLog = Boolean.parseBoolean(value);
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("code")) {
                    try {
                        Integer.parseInt(value);
                        this.userCodeDefault = value;
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("logsize")) {
                    try {
                        int l2 = Integer.parseInt(value);
                        if (l2 < 0) {
                            throw new Exception();
                        }
                        this.logSize = l2;
                    }
                    catch (Exception e6) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("userlogs")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.userLogs = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.userLogs = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                }
            }
            ++i2;
        }
        this.langugeInit();
        this.displayInit();
        this.areaKeysUpdate();
        this.showCodeKeypad(false);
        this.logRestore();
        PluginsWrapper.register(this.serverName, 49, this);
        this.zoneNameDef[0] = false;
        this.zoneName[0] = "";
        int zone = 1;
        while (zone <= 192) {
            this.zoneNameDef[zone] = true;
            this.zoneName[zone] = String.valueOf(this.string[0]) + zone;
            ++zone;
        }
        this.areaNameDef[0] = false;
        this.areaName[0] = "";
        int area = 1;
        while (area <= 8) {
            this.areaNameDef[area] = true;
            this.areaName[area] = String.valueOf(this.string[1]) + area;
            ++area;
        }
        this.userNameDef[0] = false;
        this.userName[0] = "";
        int user2 = 1;
        while (user2 < this.userName.length) {
            this.userNameDef[user2] = true;
            this.userName[user2] = String.valueOf(this.string[2]) + user2;
            ++user2;
        }
        this.commandDispatcher = new CommandDispatcher();
        this.commandDispatcher.start();
        Runnable housekeepingTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long logCleanTime = 0L;
                while (true) {
                    long now = System.currentTimeMillis();
                    try {
                        int a2;
                        if (now > ParadoxDriver.this.commTime + 30000L) {
                            ParadoxDriver.this.send("K");
                        }
                        if (ParadoxDriver.this.commTime > 0L && now > ParadoxDriver.this.commTime + 60000L) {
                            ParadoxDriver.this.commOfflineCondition();
                        }
                        if (now > ParadoxDriver.this.eventTime + 300000L) {
                            a2 = 1;
                            while (a2 <= 8) {
                                ParadoxDriver.this.send("RA00" + a2);
                                ++a2;
                            }
                        }
                        a2 = 1;
                        while (a2 <= 8) {
                            if (ParadoxDriver.this.areaStatusTime[a2] > 0L && now > ParadoxDriver.this.areaStatusTime[a2] + 1000L) {
                                ((ParadoxDriver)ParadoxDriver.this).areaStatusTime[a2] = 0L;
                                ParadoxDriver.this.send("RA00" + a2);
                            }
                            ++a2;
                        }
                        int z22 = 1;
                        while (z22 <= ParadoxDriver.this.zoneLastNumber) {
                            if (ParadoxDriver.this.zoneStatusTime[z22] > 0L && now > ParadoxDriver.this.zoneStatusTime[z22] + 1000L) {
                                ((ParadoxDriver)ParadoxDriver.this).zoneStatusTime[z22] = 0L;
                                StringBuffer sb = new StringBuffer("RZ");
                                if (z22 < 10) {
                                    sb.append("00");
                                } else if (z22 < 100) {
                                    sb.append('0');
                                }
                                sb.append(z22);
                                ParadoxDriver.this.send(sb.toString());
                            }
                            ++z22;
                        }
                        if (ParadoxDriver.this.guiSupport && logCleanTime != ParadoxDriver.this.logTime && now > ParadoxDriver.this.logTime + 10000L) {
                            logCleanTime = ParadoxDriver.this.logTime;
                            user.uiSet(String.valueOf(ParadoxDriver.this.serverName) + "log0", "value", "");
                        }
                        if (ParadoxDriver.this.guiSupport && ParadoxDriver.this.codeKeypadTime != 0L && now > ParadoxDriver.this.codeKeypadTime + 30000L) {
                            ParadoxDriver.this.commandMode = 0;
                            ParadoxDriver.this.userPanelCode = "";
                            ParadoxDriver.this.showCodeKeypad(false);
                            ParadoxDriver.this.showMainKeypad(true);
                        }
                        Object z22 = ParadoxDriver.this.housekeepingLock;
                        synchronized (z22) {
                            try {
                                ParadoxDriver.this.housekeepingLock.wait(5000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - status thread exception [" + ParadoxDriver.this.serverName + "] : " + e2.getLocalizedMessage());
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    break;
                }
            }
        };
        this.exec.execute(housekeepingTask);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        try {
            sb = new StringBuffer();
            while (!me.quit) {
                char c2;
                me.heartbeat = System.currentTimeMillis();
                String r = this.readComm(1);
                if (r == null) {
                    Thread.sleep(10000L);
                } else if (r.equals("0D")) {
                    this.Event(((StringBuffer)sb).toString());
                    this.commOnlineCondition();
                    sb = new StringBuffer();
                } else if (r.length() == 2 && !Character.isIdentifierIgnorable(c2 = (char)Integer.parseInt(r, 16))) {
                    ((StringBuffer)sb).append((char)Integer.parseInt(r, 16));
                }
                if (this.commandHeartbeat >= System.currentTimeMillis() - 60000L) continue;
                hsyco.errorLog("ioMonitor - commandDispatcher error [" + this.serverName + "] : timeout");
                me.quit = true;
            }
            Thread.sleep(5000L);
        }
        catch (Exception e7) {
            hsyco.errorLog("ioMonitor - main loop exception [" + this.serverName + "] : " + e7.getLocalizedMessage());
        }
        this.commandDispatcher.quit = true;
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHouseKeepingTask() {
        Object object = this.housekeepingLock;
        synchronized (object) {
            this.housekeepingLock.notify();
        }
    }

    private void showMainKeypad(boolean show) {
        if (this.guiSupport) {
            String visible = show ? "true" : "false";
            user.uiSet(String.valueOf(this.serverName) + "mainkeypad", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "status", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "trouble", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "mode", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "log", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "zone", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area1", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area2", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area3", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area4", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area5", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area6", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area7", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area8", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "arm", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "stay", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "inst", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "force", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "disarm", "visible", visible);
        }
    }

    private void showCodeKeypad(boolean show) {
        if (this.guiSupport) {
            String visible;
            if (show) {
                visible = "true";
                this.codeKeypadTime = System.currentTimeMillis();
            } else {
                visible = "false";
                this.codeKeypadTime = 0L;
            }
            this.codeDisplay();
            user.uiSet(String.valueOf(this.serverName) + "keycontainer", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + ".key", "focus", visible);
            user.uiSet(String.valueOf(this.serverName) + "code", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key1", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key2", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key3", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key4", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key5", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key6", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key7", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key8", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key9", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key0", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "keyc", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "keyk", "visible", visible);
        }
    }

    public void keypad(String session, String userId, String id) {
        if (this.guiSupport) {
            String key = id.toLowerCase();
            if (key.equals("arm")) {
                this.commandMode = 65;
                this.userPanelCode = "";
                this.showMainKeypad(false);
                this.showCodeKeypad(true);
            } else if (key.equals("stay")) {
                this.commandMode = 83;
                this.userPanelCode = "";
                this.showMainKeypad(false);
                this.showCodeKeypad(true);
            } else if (key.equals("inst")) {
                this.commandMode = 73;
                this.userPanelCode = "";
                this.showMainKeypad(false);
                this.showCodeKeypad(true);
            } else if (key.equals("force")) {
                this.commandMode = 70;
                this.userPanelCode = "";
                this.showMainKeypad(false);
                this.showCodeKeypad(true);
            } else if (key.equals("disarm")) {
                this.commandMode = 68;
                this.userPanelCode = "";
                this.showMainKeypad(false);
                this.showCodeKeypad(true);
            } else if (key.startsWith("area")) {
                int area = Integer.parseInt(id.substring(4));
                if (area > 0 && area < 9) {
                    this.areaFlags[area] = !this.areaFlags[area];
                    user.uiSet(String.valueOf(this.serverName) + "area" + area, "color", this.areaFlags[area] ? "highlight" : "");
                }
            } else if (key.startsWith("key.")) {
                String code = key.substring(4);
                if (code.length() == 6) {
                    this.execute(this.commandMode, code);
                }
                this.showCodeKeypad(false);
                this.showMainKeypad(true);
            } else if (key.startsWith("key")) {
                int keynum;
                this.codeKeypadTime = System.currentTimeMillis();
                if (key.charAt(3) == 'c') {
                    if (this.userPanelCode.length() > 0) {
                        this.userPanelCode = this.userPanelCode.substring(0, this.userPanelCode.length() - 1);
                        this.codeDisplay();
                    } else {
                        this.commandMode = 0;
                        this.userPanelCode = "";
                        this.showCodeKeypad(false);
                        this.showMainKeypad(true);
                    }
                } else if (key.charAt(3) == 'k') {
                    this.execute(this.commandMode, this.userPanelCode);
                    this.commandMode = 0;
                    this.userPanelCode = "";
                    this.showCodeKeypad(false);
                    this.showMainKeypad(true);
                } else if (key.length() == 4 && (keynum = key.charAt(3) - 48) >= 0 && keynum <= 9 && this.userPanelCode.length() < 6) {
                    this.userPanelCode = String.valueOf(this.userPanelCode) + Integer.toString(keynum);
                    this.codeDisplay();
                }
            }
        }
    }

    private void execute(int mode, String code) {
        try {
            int area = 1;
            while (area < 9) {
                if (this.areaFlags[area]) {
                    StringBuffer sb = new StringBuffer("A");
                    sb.append(mode == 68 ? (char)'D' : 'A');
                    sb.append("00");
                    sb.append(area);
                    if (mode != 68) {
                        sb.append((char)mode);
                    }
                    sb.append(code);
                    this.send(sb.toString());
                }
                ++area;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execute(int area, int mode, String code) {
        try {
            StringBuffer sb = new StringBuffer("A");
            sb.append(mode == 68 ? (char)'D' : 'A');
            sb.append("00");
            sb.append(area);
            if (mode != 68) {
                sb.append((char)mode);
            }
            sb.append(code);
            this.send(sb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setVirtualInput(int id, int state) {
        if ((state == 0 || state == 1) && id >= 1 && id <= 16) {
            try {
                StringBuffer sb = new StringBuffer("V");
                sb.append(state == 1 ? (char)'C' : 'O');
                sb.append("0");
                if (id < 10) {
                    sb.append("0");
                }
                sb.append(id);
                this.send(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(String command) {
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < command.length()) {
            String hex = Integer.toHexString(0xFF & command.charAt(i2));
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            ++i2;
        }
        sb.append("0D");
        Object object = this.commandLock;
        synchronized (object) {
            StringBuffer m2;
            if (this.writeComm(sb.toString()) > 0) {
                if (Configuration.verboseLog) {
                    m2 = new StringBuffer("ioMonitor - WRITE [" + this.serverName + "] - PORT ");
                    m2.append(this.commPort);
                    m2.append(" DATA ");
                    m2.append(command);
                    hsyco.messageLog(m2.toString());
                }
                user.sleep(100L);
            } else {
                if (Configuration.verboseLog) {
                    m2 = new StringBuffer("ioMonitor - WRITE ERROR [" + this.serverName + "] - PORT ");
                    m2.append(this.commPort);
                    m2.append(" DATA ");
                    m2.append(command);
                    hsyco.errorLog(m2.toString());
                }
                user.sleep(10000L);
            }
        }
    }

    private void requestAreaStatus(int area) {
        this.areaStatusTime[area] = System.currentTimeMillis();
        this.notifyHouseKeepingTask();
    }

    private void requestAreaLabel(int area) {
        if (this.areaNameDef[area]) {
            this.send("AL00" + area);
        }
    }

    private void requestZoneStatus(int zone) {
        if (zone > this.zoneLastNumber) {
            this.zoneLastNumber = zone;
        }
        this.zoneStatusTime[zone] = System.currentTimeMillis();
        this.notifyHouseKeepingTask();
    }

    private void requestZoneLabel(int zone) {
        if (this.zoneNameDef[zone]) {
            StringBuffer sb = new StringBuffer("ZL");
            if (zone < 10) {
                sb.append("00");
            } else if (zone < 100) {
                sb.append('0');
            }
            sb.append(zone);
            this.send(sb.toString());
        }
    }

    private void requestUserLabel(int user2) {
        if (this.userNameDef[user2]) {
            StringBuffer sb = new StringBuffer("UL");
            if (user2 < 10) {
                sb.append("00");
            } else if (user2 < 100) {
                sb.append('0');
            }
            sb.append(user2);
            this.send(sb.toString());
        }
    }

    private void codeDisplay() {
        if (this.guiSupport) {
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < this.userPanelCode.length()) {
                sb.append('*');
                ++i2;
            }
            i2 = this.userPanelCode.length();
            while (i2 < 6) {
                sb.append('-');
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "code", "value", sb.toString());
        }
    }

    private void Event(String event) {
        StringBuffer log = new StringBuffer();
        int zone = -1;
        int area = -1;
        int evouser = -1;
        if (Configuration.verboseLog) {
            StringBuffer m2 = new StringBuffer("ioMonitor - READ [" + this.serverName + "] - PORT ");
            m2.append(this.commPort);
            m2.append(" DATA ");
            m2.append(event);
            hsyco.messageLog(m2.toString());
        }
        if (event.length() > 1 && !event.endsWith("&ok") && !event.endsWith("&fail")) {
            this.eventTime = System.currentTimeMillis();
            try {
                if (event.startsWith("G000N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    this.zoneStatus[zone][0] = 67;
                    this.zoneStatusUpdate(zone);
                    if (this.zoneActivityLog) {
                        if (area >= 1 && area <= 8 && this.areaNameLog) {
                            log.append('[');
                            log.append(this.areaName[area]);
                            log.append("] ");
                        }
                        log.append(this.zoneName[zone]);
                        log.append(": ");
                        log.append(this.string[3]);
                    }
                } else if (event.startsWith("G001N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    this.zoneStatus[zone][0] = 79;
                    this.zoneStatusUpdate(zone);
                    if (this.zoneActivityLog) {
                        if (area >= 1 && area <= 8 && this.areaNameLog) {
                            log.append('[');
                            log.append(this.areaName[area]);
                            log.append("] ");
                        }
                        log.append(this.zoneName[zone]);
                        log.append(": ");
                        log.append(this.string[4]);
                    }
                } else if (event.startsWith("G002N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    this.zoneStatus[zone][0] = 84;
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[5]);
                } else if (event.startsWith("G003N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    this.zoneStatus[zone][0] = 70;
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[6]);
                } else if (event.startsWith("G004N")) {
                    int msgid = Integer.parseInt(event.substring(5, 8));
                    if (msgid <= 7) {
                        area = Integer.parseInt(event.substring(9, 12));
                        if (area >= 1 && area <= 8 && this.areaNameLog) {
                            log.append('[');
                            log.append(this.areaName[area]);
                            log.append("] ");
                        }
                        log.append(this.string[7 + msgid]);
                    }
                } else if (event.startsWith("G005N")) {
                    evouser = Integer.parseInt(event.substring(5, 8));
                    log.append(this.userName[evouser]);
                    log.append(": ");
                    log.append(this.string[15]);
                } else if (event.startsWith("G009N") || event.startsWith("G010N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    evouser = Integer.parseInt(event.substring(5, 8));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.userName[evouser]);
                    log.append(": ");
                    log.append(this.string[16]);
                } else if (event.startsWith("G011N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(Integer.parseInt(event.substring(5, 8)));
                    log.append(": ");
                    log.append(this.string[17]);
                } else if (event.startsWith("G012N004")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[18]);
                } else if (event.startsWith("G012N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[18]);
                } else if (event.startsWith("G013N") || event.startsWith("G014N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    evouser = Integer.parseInt(event.substring(5, 8));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.userName[evouser]);
                    log.append(": ");
                    log.append(this.string[19]);
                } else if (event.startsWith("G015N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(Integer.parseInt(event.substring(5, 8)));
                    log.append(": ");
                    log.append(this.string[20]);
                } else if (event.startsWith("G019N") || event.startsWith("G020N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    evouser = Integer.parseInt(event.substring(5, 8));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.userName[evouser]);
                    log.append(": ");
                    log.append(this.string[21]);
                } else if (event.startsWith("G021N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(Integer.parseInt(event.substring(5, 8)));
                    log.append(": ");
                    log.append(this.string[22]);
                } else if (event.startsWith("G022N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[23]);
                } else if (event.startsWith("G023N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[24]);
                } else if (event.startsWith("G024N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[25]);
                } else if (event.startsWith("G025N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[26]);
                } else if (event.startsWith("G026N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[27]);
                } else if (event.startsWith("G027N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[28]);
                } else if (event.startsWith("G028N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    evouser = Integer.parseInt(event.substring(5, 8));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.userName[evouser]);
                    log.append(": ");
                    log.append(this.string[29]);
                } else if (event.startsWith("G029N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    evouser = Integer.parseInt(event.substring(5, 8));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.userName[evouser]);
                    log.append(": ");
                    log.append(this.string[30]);
                } else if (event.startsWith("G030N000")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[31]);
                } else if (event.startsWith("G030N001")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[32]);
                } else if (event.startsWith("G030N002")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[33]);
                } else if (event.startsWith("G030N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[34]);
                } else if (event.startsWith("G031N")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    evouser = Integer.parseInt(event.substring(5, 8));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.userName[evouser]);
                    log.append(": ");
                    log.append(this.string[35]);
                } else if (event.startsWith("G032N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[36]);
                } else if (event.startsWith("G033N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[37]);
                } else if (event.startsWith("G034N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[38]);
                } else if (event.startsWith("G035N000")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[39]);
                } else if (event.startsWith("G036N")) {
                    int msgid = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (msgid <= 7) {
                        if (area >= 1 && area <= 8) {
                            if (this.areaNameLog) {
                                log.append('[');
                                log.append(this.areaName[area]);
                                log.append("] ");
                            }
                        } else {
                            area = 0;
                        }
                        log.append(this.string[40 + msgid]);
                    }
                } else if (event.startsWith("G037N")) {
                    int msgid = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (msgid <= 7) {
                        if (area >= 1 && area <= 8) {
                            if (this.areaNameLog) {
                                log.append('[');
                                log.append(this.areaName[area]);
                                log.append("] ");
                            }
                        } else {
                            area = 0;
                        }
                        log.append(this.string[48 + msgid]);
                    }
                } else if (event.startsWith("G038N")) {
                    log.append(this.string[56]);
                } else if (event.startsWith("G039N")) {
                    log.append(this.string[57]);
                } else if (event.startsWith("G040N")) {
                    log.append(this.string[58]);
                    log.append(": ");
                    log.append(Integer.parseInt(event.substring(5, 8)));
                } else if (event.startsWith("G041N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[59]);
                } else if (event.startsWith("G042N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[60]);
                } else if (event.startsWith("G043N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[61]);
                } else if (event.startsWith("G044N")) {
                    zone = Integer.parseInt(event.substring(5, 8));
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.zoneName[zone]);
                    log.append(": ");
                    log.append(this.string[62]);
                } else if (event.startsWith("G064N000")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8) {
                        if (this.areaNameLog) {
                            log.append('[');
                            log.append(this.areaName[area]);
                            log.append("] ");
                        }
                    } else {
                        area = 0;
                    }
                    log.append(this.string[63]);
                } else if (event.startsWith("G064N001")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[64]);
                } else if (event.startsWith("G064N002")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[65]);
                } else if (event.startsWith("G064N003")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[66]);
                } else if (event.startsWith("G064N004")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[77]);
                } else if (event.startsWith("G064N005")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[78]);
                } else if (event.startsWith("G064N006")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[79]);
                } else if (event.startsWith("G064N007")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[68]);
                } else if (event.startsWith("G065N000")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area < 1 || area > 8) {
                        area = 0;
                        int a2 = 1;
                        while (a2 <= 8) {
                            if (this.areaStatus[a2][3] == 'O') {
                                this.requestAreaStatus(a2);
                            }
                            ++a2;
                        }
                    }
                } else if (event.startsWith("G065N001")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[70]);
                } else if (event.startsWith("G065N002")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[71]);
                } else if (event.startsWith("G065N003")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (!this.troubleFlag) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                        log.append(this.string[72]);
                    }
                } else if (event.startsWith("G065N005")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[73]);
                } else if (event.startsWith("G065N006")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[74]);
                } else if (event.startsWith("G065N007")) {
                    area = Integer.parseInt(event.substring(9, 12));
                    if (area >= 1 && area <= 8 && this.areaNameLog) {
                        log.append('[');
                        log.append(this.areaName[area]);
                        log.append("] ");
                    }
                    log.append(this.string[75]);
                } else if (event.startsWith("AA00") && event.endsWith("&fail")) {
                    int a3 = Integer.parseInt(event.substring(2, 5));
                    log.append('[');
                    log.append(this.areaName[a3]);
                    log.append("] ");
                    log.append(this.string[100]);
                } else if (event.startsWith("AD00") && event.endsWith("&fail")) {
                    int a4 = Integer.parseInt(event.substring(2, 5));
                    log.append('[');
                    log.append(this.areaName[a4]);
                    log.append("] ");
                    log.append(this.string[101]);
                } else if (event.startsWith("RA00")) {
                    if (event.length() == 12) {
                        int a5 = Integer.parseInt(event.substring(2, 5));
                        int i2 = 0;
                        while (i2 < 7) {
                            this.areaStatus[a5][i2] = event.charAt(5 + i2);
                            ++i2;
                        }
                        this.areaStatusUpdate(a5);
                    }
                } else if (event.startsWith("RZ")) {
                    if (event.length() == 10) {
                        int z = Integer.parseInt(event.substring(2, 5));
                        int i3 = 0;
                        while (i3 < 5) {
                            this.zoneStatus[z][i3] = event.charAt(5 + i3);
                            ++i3;
                        }
                        this.zoneStatusUpdate(z);
                    }
                } else if (event.startsWith("AL")) {
                    int a6 = Integer.parseInt(event.substring(2, 5));
                    String l2 = event.substring(5);
                    if (l2.length() > 0) {
                        this.areaName[a6] = l2.trim();
                        this.areaNameDef[a6] = false;
                    }
                } else if (event.startsWith("ZL")) {
                    int z = Integer.parseInt(event.substring(2, 5));
                    String l3 = event.substring(5);
                    if (l3.length() > 0) {
                        this.zoneName[z] = l3.trim();
                        this.zoneNameDef[z] = false;
                    }
                } else if (event.startsWith("UL")) {
                    int u = Integer.parseInt(event.substring(2, 5));
                    String l4 = event.substring(5);
                    if (l4.length() > 0) {
                        this.userName[u] = l4.trim();
                        this.userNameDef[u] = false;
                    }
                } else if (event.startsWith("PGM")) {
                    int id = Integer.parseInt(event.substring(3, 5));
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".pgm." + id, event.substring(5).toLowerCase());
                } else if (event.startsWith("VO")) {
                    if (event.endsWith("&ok")) {
                        int id = Integer.parseInt(event.substring(2, 5));
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".input." + id, "open");
                    }
                } else if (event.startsWith("VC") && event.endsWith("&ok")) {
                    int id = Integer.parseInt(event.substring(2, 5));
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".input." + id, "closed");
                }
                if (log.length() > 0) {
                    this.logUpdate(log.toString());
                }
                if (zone > 0) {
                    this.requestZoneStatus(zone);
                    this.requestZoneLabel(zone);
                }
                if (area > 0) {
                    this.requestAreaStatus(area);
                    this.requestAreaLabel(area);
                }
                if (evouser > 0) {
                    this.requestUserLabel(evouser);
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - protocol error [" + this.serverName + "] : " + event);
            }
        }
    }

    private void logUpdate(String log) {
        StringBuffer persistentlog = new StringBuffer();
        long now = System.currentTimeMillis();
        SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd MMM HH:mm:ss");
        String logEntry = String.valueOf(displayDateFormat.format(now).toUpperCase()) + " " + log.toUpperCase();
        SystemState.ioWrite(String.valueOf(this.serverName) + ".log0", logEntry);
        if (this.guiSupport && this.logSize > 0) {
            StringBuffer logsb = new StringBuffer();
            if (this.logList.size() >= this.logSize) {
                this.logList.removeLast();
            }
            this.logList.addFirst(logEntry);
            int i2 = 0;
            while (i2 < this.logList.size()) {
                String line = this.logList.get(i2);
                if (logsb.length() > 0) {
                    logsb.append("<br>");
                }
                logsb.append(line);
                line = line.replace(";", ";;");
                if (line.length() > 0) {
                    if (persistentlog.length() > 0) {
                        persistentlog.append(';');
                    }
                    persistentlog.append(line);
                }
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "logs", "value", logsb.toString());
            if (this.userLogs) {
                this.logToUser(logsb.toString());
            }
            SystemState.varSet("__hsyco__paradox." + this.serverName + ".log!", persistentlog.toString());
            i2 = 20;
            while (i2 >= 2) {
                try {
                    user.uiSet(String.valueOf(this.serverName) + "log" + i2, "value", user.uiGet(String.valueOf(this.serverName) + "log" + (i2 - 1), "value"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "log1", "value", logEntry);
            if (logEntry.length() > 48) {
                user.uiSet(String.valueOf(this.serverName) + "log0", "value", String.valueOf(logEntry.substring(0, 48)) + "...");
            } else {
                user.uiSet(String.valueOf(this.serverName) + "log0", "value", logEntry);
            }
            this.logTime = now;
        }
        hsyco.securityLog(String.valueOf(this.serverName) + " - " + log);
    }

    private void logRestore() {
        int i2;
        StringBuffer sb = new StringBuffer();
        boolean semicolon = false;
        try {
            String persistentlog = SystemState.varGet("__hsyco__paradox." + this.serverName + ".log!");
            i2 = 0;
            while (i2 < persistentlog.length()) {
                char c2 = persistentlog.charAt(i2);
                if (semicolon) {
                    if (c2 == ';') {
                        sb.append(c2);
                    } else {
                        this.logList.add(sb.toString());
                        if (this.logList.size() >= this.logSize) break;
                        sb = new StringBuffer();
                        sb.append(c2);
                    }
                    semicolon = false;
                } else if (c2 == ';') {
                    semicolon = true;
                } else {
                    sb.append(c2);
                }
                ++i2;
            }
            if (this.logList.size() < this.logSize && sb.length() > 0) {
                this.logList.add(sb.toString());
            }
        }
        catch (Exception persistentlog) {
            // empty catch block
        }
        if (this.guiSupport && this.logSize > 0) {
            StringBuffer logsb = new StringBuffer();
            i2 = 0;
            while (i2 < this.logList.size()) {
                String line = this.logList.get(i2);
                if (logsb.length() > 0) {
                    logsb.append("<br>");
                }
                logsb.append(line);
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "logs", "value", logsb.toString());
            if (this.userLogs) {
                this.logToUser(logsb.toString());
            }
        }
    }

    private void logToUser(String data) {
        SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd MMM HH:mm:ss");
        SimpleDateFormat userDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer psb = new StringBuffer();
        StringBuffer lsb = new StringBuffer();
        Calendar calNow = Calendar.getInstance();
        Calendar calLog = Calendar.getInstance();
        try {
            String[] da = data.split("<br>|<BR>");
            int i2 = 0;
            while (i2 < da.length) {
                if (da[i2].length() > 0) {
                    if (psb.length() > 0) {
                        lsb.append(',');
                        psb.append(',');
                    }
                    lsb.append(da[i2].replace(",", "&#44;"));
                    calLog.setTime(displayDateFormat.parse(da[i2].substring(0, 15)));
                    if (calNow.get(2) < calLog.get(2)) {
                        calLog.set(1, calNow.get(1) - 1);
                    } else {
                        calLog.set(1, calNow.get(1));
                    }
                    psb.append(String.valueOf(userDateFormat.format(calLog.getTime())) + da[i2].substring(15).replaceAll(",", "&#44;"));
                }
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "userlogs", "parameters", psb.toString());
            user.uiSet(String.valueOf(this.serverName) + "userlogs", "labels", lsb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void areaKeysUpdate() {
        if (this.guiSupport) {
            int area = 1;
            while (area < 9) {
                user.uiSet(String.valueOf(this.serverName) + "area" + area, "color", this.areaFlags[area] ? "highlight" : "");
                ++area;
            }
        }
    }

    private void displayInit() {
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + "log0", "size", "10");
            int i2 = 1;
            while (i2 <= 20) {
                user.uiSet(String.valueOf(this.serverName) + "log" + i2, "size", "12");
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "status", "size", "24");
            user.uiSet(String.valueOf(this.serverName) + "mode", "size", "16");
            user.uiSet(String.valueOf(this.serverName) + "code", "size", "40");
            user.uiSet(String.valueOf(this.serverName) + ".key", "panel", "false");
        }
    }

    private void commOfflineCondition() {
        if (this.commError != 0) {
            this.commError = 0;
            SystemState.ioWrite(String.valueOf(this.serverName) + ".trouble", "offline");
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
            if (this.guiSupport) {
                user.uiSet(String.valueOf(this.serverName) + ".connection.label.online", "visible", "false");
                user.uiSet(String.valueOf(this.serverName) + ".connection.label.offline", "visible", "true");
                user.uiSet(String.valueOf(this.serverName) + "trouble", "value", this.string[110]);
            }
            this.logUpdate(this.string[110]);
        }
    }

    private void commOnlineCondition() {
        if (!this.startupCompleted) {
            this.startupCompleted = true;
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e2);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            SystemState.ioServersInitializedSet(this.ioIndex, true);
        }
        this.commTime = System.currentTimeMillis();
        if (this.commError != 1) {
            this.commError = 1;
            SystemState.ioWrite(String.valueOf(this.serverName) + ".trouble", "online");
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
            if (this.guiSupport) {
                user.uiSet(String.valueOf(this.serverName) + ".connection.label.offline", "visible", "false");
                user.uiSet(String.valueOf(this.serverName) + ".connection.label.online", "visible", "true");
                user.uiSet(String.valueOf(this.serverName) + "trouble", "value", this.troubleFlag ? this.string[80] : "");
            }
            this.logUpdate(this.string[111]);
        }
    }

    private void areaStatusUpdate(int area) {
        boolean areaTrouble = false;
        boolean areaProgramming = false;
        boolean areaAlarm = false;
        boolean areaStrobe = false;
        boolean areaDisarmed = false;
        boolean areaArmed = false;
        boolean areaForce = false;
        boolean areaStay = false;
        boolean areaInstant = false;
        StringBuffer sb = new StringBuffer();
        String ioHeader = String.valueOf(this.serverName) + ".area." + area + ".";
        if (this.areaStatus[area][4] == 'O') {
            if (this.areaStatus[area][0] != '\u0000') {
                sb.append(this.areaName[area]);
                sb.append(": ");
                switch (this.areaStatus[area][0]) {
                    case 'D': {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "mode", "disarmed");
                        sb.append(this.string[81]);
                        break;
                    }
                    case 'A': {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "mode", "armed");
                        sb.append(this.string[82]);
                        break;
                    }
                    case 'F': {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "mode", "force");
                        sb.append(this.string[84]);
                        break;
                    }
                    case 'S': {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "mode", "stay");
                        sb.append(this.string[83]);
                        break;
                    }
                    case 'I': {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "mode", "instant");
                        sb.append(this.string[85]);
                    }
                }
                if (this.areaStatus[area][5] == 'A') {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "status", "alarm");
                    sb.append(", ");
                    sb.append(this.string[90]);
                } else if (this.areaStatus[area][6] == 'S') {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "status", "strobe");
                    sb.append(", ");
                    sb.append(this.string[91]);
                } else {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "status", "reset");
                }
                if (this.areaStatus[area][2] == 'T') {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "trouble", "trouble");
                    sb.append(", ");
                    sb.append(this.string[80]);
                } else {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "trouble", "reset");
                }
                if (this.areaStatus[area][4] == 'P') {
                    sb.append(", ");
                    sb.append(this.string[92]);
                }
                if (this.guiSupport) {
                    String text = sb.toString().toUpperCase();
                    user.uiSet(String.valueOf(this.serverName) + "statusarea" + area, "value", text);
                    if (!this.areaNameDef[area]) {
                        this.areaList[area] = text;
                    }
                }
                this.eventsCall();
            }
            if (this.guiSupport) {
                sb = new StringBuffer();
                int a2 = 1;
                while (a2 <= 8) {
                    if (this.areaList[a2] != null) {
                        if (sb.length() > 0) {
                            sb.append("<br>");
                        }
                        sb.append(this.areaList[a2]);
                    }
                    switch (this.areaStatus[a2][0]) {
                        case 'D': {
                            areaDisarmed = true;
                            break;
                        }
                        case 'A': {
                            areaArmed = true;
                            break;
                        }
                        case 'F': {
                            areaForce = true;
                            break;
                        }
                        case 'S': {
                            areaStay = true;
                            break;
                        }
                        case 'I': {
                            areaInstant = true;
                        }
                    }
                    if (this.areaStatus[a2][2] == 'T') {
                        areaTrouble = true;
                    }
                    if (this.areaStatus[a2][4] == 'P') {
                        areaProgramming = true;
                    }
                    if (this.areaStatus[a2][5] == 'A') {
                        areaAlarm = true;
                    }
                    if (this.areaStatus[a2][6] == 'S') {
                        areaStrobe = true;
                    }
                    ++a2;
                }
                user.uiSet(String.valueOf(this.serverName) + "areas", "value", sb.toString());
                user.uiSet(String.valueOf(this.serverName) + ".area." + area + ".mode.label.disarmed", "visible", Boolean.toString(this.areaStatus[area][0] == 'D'));
                user.uiSet(String.valueOf(this.serverName) + ".area." + area + ".mode.label.armed", "visible", Boolean.toString(this.areaStatus[area][0] == 'A'));
                user.uiSet(String.valueOf(this.serverName) + ".area." + area + ".mode.label.force", "visible", Boolean.toString(this.areaStatus[area][0] == 'F'));
                user.uiSet(String.valueOf(this.serverName) + ".area." + area + ".mode.label.stay", "visible", Boolean.toString(this.areaStatus[area][0] == 'S'));
                user.uiSet(String.valueOf(this.serverName) + ".area." + area + ".mode.label.instant", "visible", Boolean.toString(this.areaStatus[area][0] == 'I'));
                user.uiSet(String.valueOf(this.serverName) + ".area." + area + ".status.label.alarm", "visible", Boolean.toString(this.areaStatus[area][5] == 'A' || this.areaStatus[area][6] == 'S'));
                user.uiSet(String.valueOf(this.serverName) + ".area." + area + ".trouble.label.trouble", "visible", Boolean.toString(this.areaStatus[area][2] == 'T'));
                if (areaStay) {
                    user.uiSet(String.valueOf(this.serverName) + "mode", "value", this.string[83]);
                } else if (areaInstant) {
                    user.uiSet(String.valueOf(this.serverName) + "mode", "value", this.string[85]);
                } else if (areaForce) {
                    user.uiSet(String.valueOf(this.serverName) + "mode", "value", this.string[84]);
                } else if (areaArmed) {
                    user.uiSet(String.valueOf(this.serverName) + "mode", "value", this.string[82]);
                } else if (areaDisarmed) {
                    user.uiSet(String.valueOf(this.serverName) + "mode", "value", this.string[81]);
                } else {
                    user.uiSet(String.valueOf(this.serverName) + "mode", "value", "");
                }
                if (areaAlarm) {
                    user.uiSet(String.valueOf(this.serverName) + "status", "value", this.string[90]);
                } else if (areaStrobe) {
                    user.uiSet(String.valueOf(this.serverName) + "status", "value", this.string[91]);
                } else if (areaProgramming) {
                    user.uiSet(String.valueOf(this.serverName) + "status", "value", this.string[92]);
                } else {
                    user.uiSet(String.valueOf(this.serverName) + "status", "value", "");
                }
                if (this.troubleFlag ^ areaTrouble) {
                    this.troubleFlag = areaTrouble;
                    user.uiSet(String.valueOf(this.serverName) + "trouble", "value", this.troubleFlag ? this.string[80] : "");
                }
            }
        }
    }

    private void zoneStatusUpdate(int zone) {
        StringBuffer sb = new StringBuffer();
        String ioHeader = String.valueOf(this.serverName) + ".zone." + zone + ".";
        if (this.zoneStatus[zone][0] != '\u0000') {
            boolean events2;
            if (this.zoneInitialized[zone]) {
                events2 = true;
            } else if (zone > this.zoneMax) {
                events2 = true;
                this.zoneInitialized[zone] = true;
            } else {
                events2 = false;
                this.zoneInitialized[zone] = true;
            }
            sb.append(this.zoneName[zone]);
            sb.append(": ");
            switch (this.zoneStatus[zone][0]) {
                case 'C': {
                    if (events2) {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "status", "closed");
                    } else {
                        SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "status", "closed");
                    }
                    sb.append(this.string[94]);
                    break;
                }
                case 'O': {
                    if (events2) {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "status", "open");
                    } else {
                        SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "status", "open");
                    }
                    sb.append(this.string[95]);
                    break;
                }
                case 'T': {
                    if (events2) {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "status", "tamper");
                    } else {
                        SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "status", "tamper");
                    }
                    sb.append(this.string[96]);
                    break;
                }
                case 'F': {
                    if (events2) {
                        SystemState.ioWrite(String.valueOf(ioHeader) + "status", "fireloop");
                    } else {
                        SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "status", "fireloop");
                    }
                    sb.append(this.string[97]);
                }
            }
            if (this.zoneStatus[zone][2] == 'F') {
                if (events2) {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "alarm", "fire");
                } else {
                    SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "alarm", "fire");
                }
            } else if (this.zoneStatus[zone][1] == 'A') {
                if (events2) {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "alarm", "alarm");
                } else {
                    SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "alarm", "alarm");
                }
            } else if (events2) {
                SystemState.ioWrite(String.valueOf(ioHeader) + "alarm", "reset");
            } else {
                SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "alarm", "reset");
            }
            if (this.zoneStatus[zone][1] == 'A') {
                sb.append(", ");
                sb.append(this.string[90]);
            }
            if (this.zoneStatus[zone][2] == 'F') {
                sb.append(", ");
                sb.append(this.string[97]);
            }
            if (this.zoneStatus[zone][3] == 'S') {
                if (events2) {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "trouble", "radio");
                } else {
                    SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "trouble", "radio");
                }
            } else if (this.zoneStatus[zone][4] == 'L') {
                if (events2) {
                    SystemState.ioWrite(String.valueOf(ioHeader) + "trouble", "battery");
                } else {
                    SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "trouble", "battery");
                }
            } else if (events2) {
                SystemState.ioWrite(String.valueOf(ioHeader) + "trouble", "reset");
            } else {
                SystemState.ioWriteNoEvents(String.valueOf(ioHeader) + "trouble", "reset");
            }
            if (this.zoneStatus[zone][3] == 'S') {
                sb.append(", ");
                sb.append(this.string[98]);
            }
            if (this.zoneStatus[zone][4] == 'L') {
                sb.append(", ");
                sb.append(this.string[99]);
            }
            if (this.guiSupport) {
                String text = sb.toString().toUpperCase();
                user.uiSet(String.valueOf(this.serverName) + "statuszone" + zone, "value", text);
                if (!this.zoneNameDef[zone]) {
                    this.zoneList[zone] = text;
                }
                sb = new StringBuffer();
                int z = 1;
                while (z < this.zoneList.length) {
                    if (this.zoneList[z] != null) {
                        if (sb.length() > 0) {
                            sb.append("<br>");
                        }
                        sb.append(this.zoneList[z]);
                    }
                    ++z;
                }
                user.uiSet(String.valueOf(this.serverName) + "zones", "value", sb.toString());
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".status.label.closed", "visible", Boolean.toString(this.zoneStatus[zone][0] == 'C'));
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".status.label.open", "visible", Boolean.toString(this.zoneStatus[zone][0] == 'O'));
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".status.label.tamper", "visible", Boolean.toString(this.zoneStatus[zone][0] == 'T'));
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".status.label.fireloop", "visible", Boolean.toString(this.zoneStatus[zone][0] == 'F'));
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".alarm.label.fire", "visible", Boolean.toString(this.zoneStatus[zone][2] == 'F'));
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".alarm.label.alarm", "visible", Boolean.toString(this.zoneStatus[zone][1] == 'A'));
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".trouble.label.radio", "visible", Boolean.toString(this.zoneStatus[zone][3] == 'S'));
                user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".trouble.label.battery", "visible", Boolean.toString(this.zoneStatus[zone][4] == 'L'));
            }
        }
    }

    private void eventsCall() {
        final String key = "SECURITY" + this.serverName;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    events.eventsExec(key, 0, 0, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.exec.execute(task);
    }

    private String readComm(int len) {
        return util.readComm(this.commPort, len);
    }

    private int writeComm(String data) {
        return util.writeComm(this.commPort, data);
    }

    private void langugeInit() {
        switch (this.language) {
            case 1: {
                this.string[0] = "Zona";
                this.string[1] = "Area";
                this.string[2] = "Utente";
                this.string[3] = "Chiusa";
                this.string[4] = "Aperta";
                this.string[5] = "Manomessa";
                this.string[6] = "Guasto antincendio";
                this.string[7] = "Guasto TLM";
                this.string[8] = "Reset rivelatore fumo";
                this.string[9] = "Inserimento istantaneo";
                this.string[10] = "Inserimento perimetrale";
                this.string[11] = "Inserimento away";
                this.string[12] = "Inserimento totale";
                this.string[13] = "Voice module access";
                this.string[14] = "Accesso remoto";
                this.string[15] = "Codice inserito";
                this.string[16] = "Inserito";
                this.string[17] = "Inserito con chiave";
                this.string[18] = "Inserito speciale";
                this.string[19] = "Disinserito";
                this.string[20] = "Disinserito con chiave";
                this.string[21] = "Fine allarme";
                this.string[22] = "Fine allarme con chiave";
                this.string[23] = "Disinserimento speciale";
                this.string[24] = "Esclusa";
                this.string[25] = "Allarme";
                this.string[26] = "Incendio";
                this.string[27] = "Allarme cancellato";
                this.string[28] = "Fine allarme incendio";
                this.string[29] = "Disinserito in anticipo";
                this.string[30] = "Disinserito in ritardo";
                this.string[31] = "Panico emergenza";
                this.string[32] = "Panico medico";
                this.string[33] = "Panico incendio";
                this.string[34] = "Allarme speciale";
                this.string[35] = "Allarme aggressione";
                this.string[36] = "Off";
                this.string[37] = "Manomissione";
                this.string[38] = "Fine manomissione";
                this.string[39] = "Manomissione speciale";
                this.string[40] = "Guasto TLM";
                this.string[41] = "Mancanza rete";
                this.string[42] = "Guasto batteria";
                this.string[43] = "Limite carico alimentazione aux";
                this.string[44] = "Limite carico alimentazione sirena";
                this.string[45] = "Guasto sirena";
                this.string[46] = "Guasto orologio";
                this.string[47] = "Guasto linea incendio";
                this.string[48] = "Fine guasto TLM";
                this.string[49] = "Rete ok";
                this.string[50] = "Batteria ok";
                this.string[51] = "Alimentazione aux ok";
                this.string[52] = "Alimentazione sirena ok";
                this.string[53] = "Sirena ok";
                this.string[54] = "Orologio ok";
                this.string[55] = "Linea incendio ok";
                this.string[56] = "Guasto modulo";
                this.string[57] = "Modulo ok";
                this.string[58] = "Errore chiamata telefono";
                this.string[59] = "Batteria scarica";
                this.string[60] = "Perdita supervisione radio";
                this.string[61] = "Batteria ok";
                this.string[62] = "Supervisione radio ok";
                this.string[63] = "Inserimento";
                this.string[64] = "Inserimento forzato";
                this.string[65] = "Inserimento perimetrale";
                this.string[66] = "Inserimento istantaneo";
                this.string[67] = "Allarme";
                this.string[68] = "Allarme incendio";
                this.string[69] = "Disinserito";
                this.string[70] = "Ritardo uscita";
                this.string[71] = "Ritardo ingresso";
                this.string[72] = "Guasto";
                this.string[73] = "Zone escluse";
                this.string[74] = "Programmazione sistema";
                this.string[75] = "Esclusione tastiera";
                this.string[76] = "Inserimento parziale";
                this.string[77] = "Allarme luminoso";
                this.string[78] = "Allarme silenzioso";
                this.string[79] = "Allarme acustico";
                this.string[80] = "GUASTO";
                this.string[81] = "DISINSERITO";
                this.string[82] = "INSERITO TOTALE";
                this.string[83] = "INSERITO PERIMETRALE";
                this.string[84] = "INSERITO FORZATO";
                this.string[85] = "INSERITO ISTANTANEO";
                this.string[90] = "ALLARME";
                this.string[91] = "ALLARME S.";
                this.string[92] = "PROGRAM.";
                this.string[93] = "ALLARME INCENDIO";
                this.string[94] = "CHIUSA";
                this.string[95] = "APERTA";
                this.string[96] = "MANOMISSIONE";
                this.string[97] = "GUASTO LINEA INCENDIO";
                this.string[98] = "NO RADIO";
                this.string[99] = "BATTERIA SCARICA";
                this.string[100] = "Errore inserimento area";
                this.string[101] = "Errore disinserimento area";
                this.string[110] = "ERRORE";
                this.string[111] = "OK";
                break;
            }
            default: {
                this.string[0] = "Zone";
                this.string[1] = "Area";
                this.string[2] = "User";
                this.string[3] = "Closed";
                this.string[4] = "Open";
                this.string[5] = "Tamper";
                this.string[6] = "Fire loop trouble";
                this.string[7] = "TLM trouble";
                this.string[8] = "Smoke detector reset";
                this.string[9] = "Arm with no entry delay";
                this.string[10] = "Arm in stay mode";
                this.string[11] = "Arm in away mode";
                this.string[12] = "Full arm when in stay mode";
                this.string[13] = "Voice module access";
                this.string[14] = "Remote control access";
                this.string[15] = "Code input";
                this.string[16] = "Arming";
                this.string[17] = "Arming with keyswitch";
                this.string[18] = "Special arming";
                this.string[19] = "Disarm";
                this.string[20] = "Disarm with keyswitch";
                this.string[21] = "Alarm off";
                this.string[22] = "Alarm off with keyswitch";
                this.string[23] = "Special disarm";
                this.string[24] = "Bypassed";
                this.string[25] = "Alarm";
                this.string[26] = "Fire alarm";
                this.string[27] = "Alarm off";
                this.string[28] = "Fire alarm off";
                this.string[29] = "Early to disarm";
                this.string[30] = "Late to disarm";
                this.string[31] = "Emergency panic";
                this.string[32] = "Medical panic";
                this.string[33] = "Fire panic";
                this.string[34] = "Special alarm";
                this.string[35] = "Duress alarm";
                this.string[36] = "Shutdown";
                this.string[37] = "Tamper";
                this.string[38] = "Tamper restore";
                this.string[39] = "Special tamper";
                this.string[40] = "TLM trouble";
                this.string[41] = "AC failure";
                this.string[42] = "Battery failure";
                this.string[43] = "Auxiliary current limit";
                this.string[44] = "Bell current limit";
                this.string[45] = "Bell absent";
                this.string[46] = "Clock trouble";
                this.string[47] = "Global fire loop trouble";
                this.string[48] = "TLM restore";
                this.string[49] = "AC restored";
                this.string[50] = "Battery restored";
                this.string[51] = "Auxiliary current restored";
                this.string[52] = "Bell current restored";
                this.string[53] = "Bell restore";
                this.string[54] = "Clock restore";
                this.string[55] = "Global fire loop restored";
                this.string[56] = "Module trouble";
                this.string[57] = "Module trouble restored";
                this.string[58] = "Failed phone call";
                this.string[59] = "low battery";
                this.string[60] = "supervision lost";
                this.string[61] = "battery restored";
                this.string[62] = "supervision restored";
                this.string[63] = "Armed";
                this.string[64] = "Force armed";
                this.string[65] = "Stay armed";
                this.string[66] = "Instant armed";
                this.string[67] = "Alarm";
                this.string[68] = "Fire alarm";
                this.string[69] = "Ready";
                this.string[70] = "Exit delay";
                this.string[71] = "Entry delay";
                this.string[72] = "System trouble";
                this.string[73] = "Zones bypassed";
                this.string[74] = "Programming";
                this.string[75] = "Keypad lockout";
                this.string[76] = "Partial arming";
                this.string[77] = "Strobe Alarm";
                this.string[78] = "Silent Alarm";
                this.string[79] = "Audible Alarm";
                this.string[80] = "TROUBLE";
                this.string[81] = "DISARMED";
                this.string[82] = "ARMED";
                this.string[83] = "STAY ARMED";
                this.string[84] = "FORCE ARMED";
                this.string[85] = "INSTANT ARMED";
                this.string[90] = "ALARM";
                this.string[91] = "STROBE ALARM";
                this.string[92] = "PROGRAM.";
                this.string[93] = "FIRE ALARM";
                this.string[94] = "CLOSED";
                this.string[95] = "OPEN";
                this.string[96] = "TAMPERED";
                this.string[97] = "FIRE LOOP TROUBLE";
                this.string[98] = "SUPERVISION LOST";
                this.string[99] = "LOW BATTERY";
                this.string[100] = "Area arm error";
                this.string[101] = "Area disarm error";
                this.string[110] = "ERROR";
                this.string[111] = "OK";
            }
        }
    }

    private class CommandDispatcher
    extends Thread {
        public boolean quit = false;

        private CommandDispatcher() {
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + ParadoxDriver.this.serverName + "]");
                ParadoxDriver.this.commandHeartbeat = System.currentTimeMillis();
                while (!this.quit) {
                    if (!this.commandExecutor((String)ParadoxDriver.this.ioqtx.poll(30000L, TimeUnit.MILLISECONDS))) continue;
                    ParadoxDriver.this.commandHeartbeat = System.currentTimeMillis();
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - commandDispatcher exception [" + ParadoxDriver.this.serverName + "] : " + e2.getLocalizedMessage());
            }
            hsyco.errorLog("commandDispatcher - quit [" + ParadoxDriver.this.serverName + "]");
        }

        private boolean commandExecutor(String cmd) throws InterruptedException {
            if (cmd == null) {
                return true;
            }
            try {
                int equalidx = cmd.indexOf(61);
                if (equalidx > 0) {
                    String name = cmd.substring(0, equalidx).trim().toLowerCase();
                    String value = cmd.substring(equalidx + 1).trim().toLowerCase();
                    if (name.startsWith("area.")) {
                        String code;
                        String command;
                        int area = Integer.parseInt(name.substring(5));
                        int i2 = value.indexOf(46);
                        if (i2 > 0) {
                            command = value.substring(0, i2);
                            code = value.substring(i2 + 1);
                        } else {
                            command = value;
                            code = ParadoxDriver.this.userCodeDefault;
                        }
                        if ("arm".equals(command)) {
                            ParadoxDriver.this.execute(area, 65, code);
                        } else if ("force".equals(command)) {
                            ParadoxDriver.this.execute(area, 70, code);
                        } else if ("stay".equals(command)) {
                            ParadoxDriver.this.execute(area, 83, code);
                        } else if ("instant".equals(command)) {
                            ParadoxDriver.this.execute(area, 73, code);
                        } else if ("disarm".equals(command)) {
                            ParadoxDriver.this.execute(area, 68, code);
                        }
                    } else if (name.startsWith("input.")) {
                        int input = Integer.parseInt(name.substring(6));
                        if ("0".equals(value) || "open".equals(value)) {
                            ParadoxDriver.this.setVirtualInput(input, 0);
                        } else if ("1".equals(value) || "close".equals(value) || "closed".equals(value)) {
                            ParadoxDriver.this.setVirtualInput(input, 1);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }
}

