/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioCommandDispatcher;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.net.Socket;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Nuvo {
    public static final String[] WebObjects = new String[]{"nuvo", "nuvomini"};
    private String commPort;
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx = null;
    private int[] zoneSource = new int[21];
    private String[] sourceName = new String[7];
    private String[] zoneName = new String[21];
    private boolean pageMode;
    private boolean guiSupport = true;
    private String nuvoVersion = "";
    private final long menuTimeoutMillis = 45000L;
    private long menuTime = 0L;
    private int menuLines = 10;
    private int menuSlaveZone = 0;
    private int menuLastSlaveZone = 0;
    private int menuSerialZone = 20;
    private boolean menuZoneSerialResponseWaitState = false;
    private boolean menuZoneSlaveResponseWaitState = false;
    private int menuFirstLineItemIndex;
    private int menuItemIndex;
    private String menuId = "0";
    private int menuSize;
    private int menuSelectedItemIndex;
    private int menuFirstBlockItemIndex;
    private String menuText = "";
    private boolean menuWaitFlag;
    private Hashtable<Integer, String> itemId = new Hashtable();
    private Hashtable<Integer, Integer> itemType = new Hashtable();
    private Hashtable<Integer, String> itemText = new Hashtable();

    void monitor(int ioIndex, ioMonitor me) {
        boolean online = false;
        boolean initialized = false;
        StringBuffer response = null;
        int state = 0;
        String errorlabel = null;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        me.dispatcher = true;
        SystemState.ioServersSocket[ioIndex] = new Socket();
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            try {
                int v;
                String value;
                errorlabel = null;
                String[] sb = sa[i2].split("=");
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("gui")) {
                    this.guiSupport = value.equals("true");
                } else if (param.equals("menuzone")) {
                    errorlabel = param;
                    v = Integer.parseInt(value);
                    if (v > 16 && v < 21) {
                        this.menuSerialZone = v;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - menuzone ignored");
                    }
                } else if (param.equals("menulines")) {
                    errorlabel = param;
                    v = Integer.parseInt(value);
                    if (v > 1 && v < 65) {
                        this.menuLines = v;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - menulines ignored");
                    }
                }
            }
            catch (Exception e2) {
                if (errorlabel == null) {
                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
                }
                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + errorlabel + "ignored");
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 10, this);
        }
        try {
            this.requestAllSourcesStatus();
            this.requestAllZonesStatus(false);
        }
        catch (Exception e4) {
            hsyco.errorLog("ioMonitor - Generic exception: IOStartupEvent(" + ioIndex + ") - " + e4);
            me.quit = true;
        }
        long startts = me.heartbeat = System.currentTimeMillis();
        while (!me.quit) {
            try {
                long ts;
                block39: {
                    block40: {
                        byte[] input;
                        block38: {
                            input = util.readCommBytes(this.commPort, 1);
                            ts = System.currentTimeMillis();
                            if (input != null) break block38;
                            hsyco.errorLog("ioMonitor - Unrecoverable error in thread loop [" + this.serverName + "] - Connection failed");
                            me.quit = true;
                            break block39;
                        }
                        if (input.length != 1) break block40;
                        switch (state) {
                            case 0: {
                                if (input[0] == 35) {
                                    state = 1;
                                    response = new StringBuffer();
                                    break;
                                }
                                break block39;
                            }
                            case 1: {
                                if (input[0] == 13 || input[0] == 10) {
                                    me.heartbeat = ts;
                                    if (!this.responseProcessor(response.toString())) {
                                        hsyco.errorLog("ioMonitor - Unrecoverable error in thread loop [" + this.serverName + "] - Response format error");
                                        me.quit = true;
                                    }
                                    state = 0;
                                    break;
                                }
                                response.append((char)input[0]);
                            }
                        }
                        break block39;
                    }
                    if (ts > me.heartbeat + 10000L) {
                        this.commandExecutor("system", "ver", null);
                        if (this.menuSlaveZone != 0 && this.menuTime + 45000L < System.currentTimeMillis()) {
                            this.commandMenuExit();
                            this.menuSlaveZone = 0;
                            this.menuId = "0";
                            this.displayMenuStatus();
                            SystemState.uiSet("*", "pageback", String.valueOf(this.serverName) + ".menupage");
                        }
                    }
                }
                if (initialized || ts <= startts + 10000L) continue;
                boolean nullstate = false;
                int sources = 0;
                int si = 1;
                while (si < this.sourceName.length) {
                    if (this.sourceName[si] == null) {
                        nullstate = true;
                    } else {
                        if (nullstate) {
                            hsyco.errorLog("ioMonitor - Unrecoverable error in thread loop [" + this.serverName + "] - Null source name for source: " + (si - 1));
                            me.quit = true;
                            break;
                        }
                        ++sources;
                    }
                    ++si;
                }
                if (sources == 0) {
                    hsyco.errorLog("ioMonitor - Unrecoverable error in thread loop [" + this.serverName + "] - No sources found");
                    me.quit = true;
                    continue;
                }
                if (me.quit) continue;
                online = true;
                initialized = true;
                this.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                SystemState.ioServersInitializedSet(ioIndex, true);
            }
            catch (Exception e5) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5.getLocalizedMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (online) {
            this.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        }
    }

    void commandDispatcher(int ioIndex, ioCommandDispatcher me) {
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioCommandDispatcher - started [" + this.serverName + "]");
        while (!me.quit) {
            try {
                me.heartbeat = System.currentTimeMillis();
                String item = this.ioqtx.poll(10L, TimeUnit.SECONDS);
                if (item == null) continue;
                int pointidx = item.indexOf(46);
                int equalidx = item.indexOf(61, pointidx);
                this.commandExecutor(item.substring(0, pointidx), item.substring(pointidx + 1, equalidx), item.substring(equalidx + 1));
            }
            catch (Exception e2) {
                hsyco.errorLog("ioCommandDispatcher - Exception in thread loop [" + this.serverName + "] - " + e2.getLocalizedMessage());
                me.quit = true;
            }
        }
        hsyco.errorLog("ioCommandDispatcher - quit [" + this.serverName + "]");
    }

    boolean responseProcessor(String response) {
        block74: {
            if (!this.menuZoneSerialResponseWaitState) break block74;
            if (response.equals("OK")) {
                this.menuZoneSerialResponseWaitState = false;
                break block74;
            }
            if (!response.equals("?")) break block74;
            this.menuZoneSerialResponseWaitState = false;
            hsyco.errorLog("ioMonitor - Handshake error [" + this.serverName + "] - could not redirect zone " + this.menuSerialZone + " to serial port");
            return false;
        }
        try {
            if (response.startsWith("VER")) {
                String ver = response.substring(response.indexOf(34) + 1, response.lastIndexOf(34));
                if (!ver.equals(this.nuvoVersion)) {
                    this.nuvoVersion = ver;
                    this.ioWrite(String.valueOf(this.serverName) + ".system.version", ver);
                }
            } else if (response.equals("ALLOFF")) {
                this.ioWrite(String.valueOf(this.serverName) + ".system.power", "0");
                this.requestAllZonesStatus(true);
            } else if (response.startsWith("MUTE")) {
                this.ioWrite(String.valueOf(this.serverName) + ".system.mute", Character.toString(response.charAt(4)));
                this.requestAllZonesStatus(true);
            } else if (response.startsWith("PAGE")) {
                if (response.charAt(4) == '1') {
                    this.ioWrite(String.valueOf(this.serverName) + ".system.page", "1");
                    this.pageMode = true;
                } else {
                    this.ioWrite(String.valueOf(this.serverName) + ".system.page", "0");
                    this.pageMode = false;
                }
                this.requestAllZonesStatus(true);
            } else if (response.startsWith("ZCFG")) {
                int zone = Character.isDigit(response.charAt(5)) ? Integer.parseInt(response.substring(4, 6)) : Integer.parseInt(response.substring(4, 5));
                String[] sa = response.split(",");
                if (sa.length > 2) {
                    String name;
                    this.zoneName[zone] = name = sa[2].substring(5, sa[2].length() - 1);
                    this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".name", name);
                } else {
                    this.zoneSource[zone] = -1;
                }
                if (zone == this.menuSerialZone) {
                    if (sa[1].equals("ENABLE1")) {
                        this.commandZoneSerial(zone);
                        this.menuZoneSerialResponseWaitState = true;
                        if (this.menuZoneSlaveResponseWaitState) {
                            this.menuTime = System.currentTimeMillis();
                            this.menuSlaveZone = Integer.parseInt(sa[3].substring(7));
                            this.menuZoneSlaveResponseWaitState = false;
                        }
                    } else {
                        this.commandZoneEnable(zone);
                    }
                }
                this.displayZoneStatus(zone);
            } else if (response.startsWith("Z")) {
                int zone = Character.isDigit(response.charAt(2)) ? Integer.parseInt(response.substring(1, 3)) : Integer.parseInt(response.substring(1, 2));
                if (this.zoneSource[zone] != -1) {
                    String[] sa = response.split(",");
                    if (sa.length > 1) {
                        if (sa[0].endsWith("MENU")) {
                            int s = Integer.parseInt(sa[4]);
                            int i2 = Integer.parseInt(sa[5]);
                            if (s == 65535) {
                                this.menuWaitFlag = true;
                            } else {
                                this.menuItemIndex = this.menuFirstBlockItemIndex = Integer.parseInt(sa[6]);
                                this.menuText = sa[8].substring(1, sa[8].length() - 1);
                                if (!sa[1].equals(this.menuId)) {
                                    if (i2 == 65535) {
                                        this.menuSelectedItemIndex = 0;
                                    }
                                    this.menuFirstLineItemIndex = this.menuFirstBlockItemIndex;
                                    this.itemId.clear();
                                    this.itemType.clear();
                                    this.itemText.clear();
                                }
                                this.menuId = sa[1];
                                if (this.menuId.equals("0x00000000")) {
                                    this.menuId = "0";
                                }
                                if (this.menuId.equals("0")) {
                                    this.menuSlaveZone = 0;
                                    SystemState.uiSet("*", "pageback", String.valueOf(this.serverName) + ".menupage");
                                }
                                this.menuWaitFlag = false;
                                this.menuSize = s;
                                if (i2 != 65535) {
                                    this.menuSelectedItemIndex = i2;
                                    if (i2 - this.menuFirstLineItemIndex > this.menuLines) {
                                        this.menuFirstLineItemIndex = 1 + i2 - this.menuLines;
                                    }
                                }
                            }
                            this.displayMenuStatus();
                        } else if (sa[0].endsWith("MENUITEM")) {
                            this.itemId.put(this.menuItemIndex, sa[1]);
                            this.itemType.put(this.menuItemIndex, Integer.parseInt(sa[2]));
                            this.itemText.put(this.menuItemIndex, sa[4].substring(1, sa[4].length() - 1));
                            ++this.menuItemIndex;
                            this.displayMenuStatus();
                        } else if (sa[1].equals("OFF")) {
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".power", "0");
                        } else if (sa[1].equals("ON")) {
                            int source;
                            this.zoneSource[zone] = source = sa[2].charAt(3) - 48;
                            this.ioWrite(String.valueOf(this.serverName) + ".system.power", "1");
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".power", "1");
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".source", Integer.toString(source));
                            if (sa[3].equals("MUTE")) {
                                this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".volume", "off");
                                this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".mute", "1");
                            } else {
                                int vol = Integer.parseInt(sa[3].substring(3));
                                this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".volume", String.valueOf(Integer.toString((int)(100.0 - (double)vol * 99.0 / 79.0))) + "%");
                                this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".mute", "0");
                            }
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".dnd", Character.toString(sa[4].charAt(3)));
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".lock", Character.toString(sa[5].charAt(4)));
                        }
                    } else {
                        int source;
                        this.zoneSource[zone] = source = response.charAt(zone < 10 ? 3 : 4) - 48;
                        this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".source", Integer.toString(source));
                        if (response.endsWith("PREV")) {
                            this.ioWriteForced(String.valueOf(this.serverName) + ".z" + zone + ".button", "prev");
                        } else if (response.endsWith("NEXT")) {
                            this.ioWriteForced(String.valueOf(this.serverName) + ".z" + zone + ".button", "next");
                        } else if (response.endsWith("PLAYPAUSE")) {
                            this.ioWriteForced(String.valueOf(this.serverName) + ".z" + zone + ".button", "playpause");
                        } else if (response.indexOf("MACRO") > 0) {
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zone + ".macro", response.substring(zone < 10 ? 9 : 10));
                        }
                    }
                }
                this.displayZoneStatus(zone);
            } else if (response.startsWith("SCFG")) {
                int source = Integer.parseInt(response.substring(4, 5));
                String[] sa = response.split(",");
                if (sa.length > 2) {
                    String name;
                    this.sourceName[source] = name = sa[2].substring(5, sa[2].length() - 1);
                    this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".name", name);
                } else {
                    this.sourceName[source] = null;
                }
                this.displaySourceStatus(source);
            } else if (response.startsWith("S")) {
                int source = Integer.parseInt(response.substring(1, 2));
                if (this.sourceName[source] != null) {
                    String[] sa = response.split(",");
                    if (sa[0].indexOf("DISPLINE") > 0) {
                        this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".displine." + sa[0].substring(10), sa[1].substring(1, sa[1].length() - 1));
                    } else if (sa[0].endsWith("DISPINFO")) {
                        this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".length", sa[1].substring(3));
                        this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".time", sa[2].substring(3));
                        switch (Integer.parseInt(sa[3].substring(6))) {
                            case 0: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "normal");
                                break;
                            }
                            case 1: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "idle");
                                break;
                            }
                            case 2: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "play");
                                break;
                            }
                            case 3: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "pause");
                                break;
                            }
                            case 4: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "ffd");
                                break;
                            }
                            case 5: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "rew");
                                break;
                            }
                            case 6: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "playshuffle");
                                break;
                            }
                            case 7: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "playrepeat");
                                break;
                            }
                            case 8: {
                                this.ioWrite(String.valueOf(this.serverName) + ".s" + source + ".status", "playshufflerepeat");
                            }
                        }
                    }
                }
                this.displaySourceStatus(source);
            } else if (!response.equals("OK")) {
                this.ioWriteForced(String.valueOf(this.serverName) + ".system.response", response);
            }
        }
        catch (Exception e2) {
            this.ioWriteForced(String.valueOf(this.serverName) + ".system.response", response);
        }
        return true;
    }

    public String keypad(String id) {
        String key = id.toLowerCase();
        if (key.startsWith("z")) {
            int sep = key.indexOf(46);
            String zoneaddress = key.substring(0, sep);
            int z = Integer.parseInt(key.substring(1, sep));
            if (key.endsWith(".menu")) {
                if (this.menuSlaveZone == 0) {
                    this.commandMenuZoneSlave(z);
                    this.requestMenuMain();
                } else if (z == this.menuSlaveZone) {
                    if (!this.menuId.equals("0xFFFFFFFF") && !this.menuId.equals("0")) {
                        this.requestMenuBack();
                    } else {
                        this.commandMenuExit();
                        this.menuSlaveZone = 0;
                        this.menuId = "0";
                        this.displayMenuStatus();
                    }
                }
            } else if (key.endsWith(".prev")) {
                if (z != this.menuSlaveZone) {
                    this.commandExecutor(zoneaddress, "button", "prev");
                } else {
                    this.menuFirstLineItemIndex = 0;
                    this.menuSelectedItemIndex = 0;
                    if (this.itemText.containsKey(0)) {
                        this.displayMenuStatus();
                    } else {
                        this.requestMenuHome();
                    }
                }
            } else if (key.endsWith(".next")) {
                if (z != this.menuSlaveZone) {
                    this.commandExecutor(zoneaddress, "button", "next");
                } else {
                    this.menuSelectedItemIndex = this.menuFirstLineItemIndex = this.menuSize - this.menuLines;
                    if (this.itemText.containsKey(this.menuSelectedItemIndex)) {
                        this.displayMenuStatus();
                    } else {
                        this.requestMenuEnd();
                    }
                }
            } else if (key.endsWith(".playpause")) {
                if (z != this.menuSlaveZone) {
                    this.commandExecutor(zoneaddress, "button", "playpause");
                } else {
                    this.commandMenuButton(2);
                }
            } else if (key.endsWith(".ok")) {
                if (z != this.menuSlaveZone) {
                    this.commandExecutor(zoneaddress, "source", "next");
                } else {
                    this.commandMenuButton(1);
                }
            } else if (key.endsWith(".source")) {
                this.commandExecutor(zoneaddress, "source", "next");
            } else if (key.indexOf(".source.") > 0) {
                this.commandExecutor(zoneaddress, "source", key.substring(key.lastIndexOf(46) + 1));
            } else if (key.endsWith(".power")) {
                String state = SystemState.ioGet(String.valueOf(this.serverName) + "." + key);
                if (state != null) {
                    if (state.equals("0")) {
                        this.commandExecutor(zoneaddress, "power", "on");
                    } else {
                        if (z == this.menuSlaveZone) {
                            this.commandMenuExit();
                            this.menuSlaveZone = 0;
                            this.menuId = "0";
                            this.displayMenuStatus();
                        }
                        this.commandExecutor(zoneaddress, "power", "off");
                    }
                } else {
                    this.commandExecutor(zoneaddress, "power", "off");
                }
            } else if (key.endsWith(".up") || key.endsWith(".+")) {
                if (z != this.menuSlaveZone) {
                    try {
                        int vol;
                        int newvol;
                        String state = SystemState.ioGet(String.valueOf(this.serverName) + "." + zoneaddress + ".volume");
                        if (state.equals("off")) {
                            this.commandExecutor(zoneaddress, "volume", "on");
                        } else if (state.endsWith("%") && (newvol = ((vol = Integer.parseInt(state.substring(0, state.length() - 1))) / 5 + 1) * 5) >= 0 && newvol <= 100) {
                            this.commandExecutor(zoneaddress, "volume", Integer.toString(newvol));
                        }
                    }
                    catch (Exception state) {}
                } else if (this.menuSelectedItemIndex > 0) {
                    if (this.itemText.containsKey(this.menuSelectedItemIndex - 1)) {
                        if (this.menuSelectedItemIndex == this.menuFirstLineItemIndex) {
                            --this.menuFirstLineItemIndex;
                        }
                        --this.menuSelectedItemIndex;
                        this.displayMenuStatus();
                    } else {
                        this.requestMenuPrevItems(this.menuSelectedItemIndex - 1);
                        --this.menuFirstLineItemIndex;
                        --this.menuSelectedItemIndex;
                    }
                }
            } else if (key.endsWith(".down") || key.endsWith(".-")) {
                if (z != this.menuSlaveZone) {
                    try {
                        int vol;
                        int newvol;
                        String state = SystemState.ioGet(String.valueOf(this.serverName) + "." + zoneaddress + ".volume");
                        if (state.equals("off")) {
                            this.commandExecutor(zoneaddress, "volume", "on");
                        } else if (state.endsWith("%") && (newvol = ((vol = Integer.parseInt(state.substring(0, state.length() - 1))) / 5 - 1) * 5) >= 0 && newvol <= 100) {
                            this.commandExecutor(zoneaddress, "volume", Integer.toString(newvol));
                        }
                    }
                    catch (Exception state) {}
                } else if (this.menuSelectedItemIndex < this.menuSize - 1) {
                    if (this.itemText.containsKey(this.menuSelectedItemIndex + 1)) {
                        if (this.menuSelectedItemIndex >= this.menuFirstLineItemIndex + this.menuLines - 1) {
                            ++this.menuFirstLineItemIndex;
                        }
                        ++this.menuSelectedItemIndex;
                        this.displayMenuStatus();
                    } else {
                        this.requestMenuNextItems(this.menuSelectedItemIndex + 1);
                        ++this.menuFirstLineItemIndex;
                        ++this.menuSelectedItemIndex;
                    }
                }
            } else if (key.indexOf(".volume.") > 0) {
                String command = key.substring(key.lastIndexOf(46) + 1);
                this.commandExecutor(zoneaddress, "volume", command);
            }
            return "";
        }
        if (key.equals("off")) {
            this.commandExecutor("system", "power", "off");
            return "";
        }
        if (key.equals("mute")) {
            this.commandExecutor("system", "mute", "on");
            return "";
        }
        if (key.equals("unmute")) {
            this.commandExecutor("system", "mute", "off");
            return "";
        }
        return "";
    }

    private void commandExecutor(String address, String function, String value) {
        String addresslow = address.toLowerCase();
        String functionlow = function.toLowerCase();
        try {
            if (addresslow.equals("system")) {
                if (functionlow.equals("ver")) {
                    util.writeCommBytes(this.commPort, "*VER\r".getBytes());
                } else if (functionlow.equals("mute")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("on") || valuelow.equals("1")) {
                        util.writeCommBytes(this.commPort, "*MUTE1\r".getBytes());
                    } else if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, "*MUTE0\r".getBytes());
                    }
                } else if (functionlow.equals("message")) {
                    util.writeCommBytes(this.commPort, ("*MSG\"" + value + "\"\r").getBytes());
                } else if (functionlow.equals("power")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, "*ALLOFF\r".getBytes());
                    }
                } else if (functionlow.equals("page")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("on") || valuelow.equals("1")) {
                        util.writeCommBytes(this.commPort, "*PAGE1\r".getBytes());
                    } else if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, "*PAGE0\r".getBytes());
                    }
                } else if (functionlow.equals("command")) {
                    util.writeCommBytes(this.commPort, ("*" + value + "\r").getBytes());
                }
            } else if (addresslow.startsWith("z")) {
                int zone = Integer.parseInt(address.substring(1));
                if (functionlow.equals("power")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("on") || valuelow.equals("1")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "ON\r").getBytes());
                    } else if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "OFF\r").getBytes());
                    }
                } else if (functionlow.equals("source")) {
                    if (value.equalsIgnoreCase("next")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "SRC+\r").getBytes());
                    } else {
                        int s = Integer.parseInt(value);
                        if (s > 0 && s < 7) {
                            util.writeCommBytes(this.commPort, ("*Z" + zone + "SRC" + s + "\r").getBytes());
                        }
                    }
                } else if (functionlow.equals("volume")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "MUTEON\r").getBytes());
                    } else if (valuelow.equals("on")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "MUTEOFF\r").getBytes());
                    } else if (valuelow.equals("up")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "VOL+\r").getBytes());
                    } else if (valuelow.equals("down")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "VOL-\r").getBytes());
                    } else {
                        int p;
                        int v = value.endsWith("%") ? (int)Double.parseDouble(value.substring(0, value.length() - 1)) : ((p = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, p)) / Double.parseDouble(value.substring(p + 1))) : (int)Double.parseDouble(value));
                        if (v >= 1 && v <= 100) {
                            util.writeCommBytes(this.commPort, ("*Z" + zone + "VOL" + 79.0 * (1.0 - (double)(v - 1) / 99.0) + "\r").getBytes());
                        } else if (v == 0) {
                            util.writeCommBytes(this.commPort, ("*Z" + zone + "MUTEON\r").getBytes());
                        }
                    }
                } else if (functionlow.equals("mute")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "MUTEOFF\r").getBytes());
                    } else if (valuelow.equals("on") || valuelow.equals("1")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "MUTEON\r").getBytes());
                    }
                } else if (functionlow.equals("button")) {
                    String valuelow = value.toLowerCase();
                    if (value.equalsIgnoreCase("playpause")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "PLAYPAUSE\r").getBytes());
                    } else if (value.equalsIgnoreCase("prev")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "PREV\r").getBytes());
                    } else if (value.equalsIgnoreCase("next")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "NEXT\r").getBytes());
                    }
                } else if (functionlow.equals("dnd")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "DNDOFF\r").getBytes());
                    } else if (valuelow.equals("on") || valuelow.equals("1")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "DNDON\r").getBytes());
                    }
                } else if (functionlow.equals("party")) {
                    String valuelow = value.toLowerCase();
                    if (valuelow.equals("off") || valuelow.equals("0")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "PARTY0\r").getBytes());
                    } else if (valuelow.equals("on") || valuelow.equals("1")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "PARTY1\r").getBytes());
                    }
                } else if (functionlow.equals("lock")) {
                    if (value.equalsIgnoreCase("on")) {
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "LOCKON\r").getBytes());
                    } else {
                        Integer.parseInt(value);
                        util.writeCommBytes(this.commPort, ("*Z" + zone + "LOCKOFF\"" + value + "\"\r").getBytes());
                    }
                } else if (functionlow.equals("playlist")) {
                    int f2 = Integer.parseInt(value);
                    util.writeCommBytes(this.commPort, ("*Z" + zone + "FAV" + f2 + "\r").getBytes());
                } else if (functionlow.equals("bright")) {
                    int x = Integer.parseInt(value);
                    util.writeCommBytes(this.commPort, ("*ZCFG" + zone + "BRIGHT" + x + "\r").getBytes());
                }
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("NUVO COMMAND ERROR: " + this.serverName + "." + address + "." + function + "=" + value);
        }
    }

    private void requestAllSourcesStatus() {
        int s = 1;
        while (s < 7) {
            this.requestSourceStatus(s);
            ++s;
        }
    }

    private void requestSourceStatus(int source) {
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        util.writeCommBytes(this.commPort, ("*SCFG" + source + "STATUS?\r").getBytes());
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        util.writeCommBytes(this.commPort, ("*S" + source + "DISPINFO?\r").getBytes());
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        util.writeCommBytes(this.commPort, ("*S" + source + "DISPLINE?\r").getBytes());
    }

    private void requestAllZonesStatus(boolean enabledonly) {
        int z = 1;
        while (z < 21) {
            if (!enabledonly || this.zoneSource[z] != -1) {
                this.requestZoneStatus(z);
            }
            ++z;
        }
    }

    private void requestZoneStatus(int zone) {
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        util.writeCommBytes(this.commPort, ("*ZCFG" + zone + "STATUS?\r").getBytes());
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        util.writeCommBytes(this.commPort, ("*Z" + zone + "STATUS?\r").getBytes());
    }

    private void requestMenuMain() {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "MENUREQ,0xFFFFFFFF,0,0,0\r").getBytes());
    }

    private void requestMenuBack() {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "MENUREQ," + this.menuId + ",1,0,0\r").getBytes());
    }

    private void requestMenuHome() {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "MENUREQ," + this.menuId + ",0,0,0\r").getBytes());
    }

    private void requestMenuEnd() {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "MENUREQ," + this.menuId + ",0,1,0\r").getBytes());
    }

    private void requestMenuNextItems(int itemindex) {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "MENUREQ," + this.menuId + ",0,2," + itemindex + "\r").getBytes());
    }

    private void requestMenuPrevItems(int itemindex) {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "MENUREQ," + this.menuId + ",0,3," + itemindex + "\r").getBytes());
    }

    private void commandZoneEnable(int zone) {
        util.writeCommBytes(this.commPort, ("*ZCFG" + zone + "ENABLE1\r").getBytes());
    }

    private void commandZoneSerial(int zone) {
        util.writeCommBytes(this.commPort, ("*Z" + zone + "SERIAL1\r").getBytes());
    }

    private void commandMenuZoneSlave(int slaveto) {
        this.menuZoneSlaveResponseWaitState = true;
        util.writeCommBytes(this.commPort, ("*ZCFG" + this.menuSerialZone + "SLAVETO" + slaveto + "\r").getBytes());
    }

    private void commandMenuButton(int button) {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "BUTTON" + button + ",0," + this.menuId + "," + this.itemId.get(this.menuSelectedItemIndex) + "," + this.menuSelectedItemIndex + "\r").getBytes());
    }

    private void commandMenuExit() {
        util.writeCommBytes(this.commPort, ("*Z" + this.menuSerialZone + "MENUACTIVE," + this.menuId + ",1\r").getBytes());
    }

    private void displayZoneStatus(int zone) {
        if (this.guiSupport) {
            String zonepfx = String.valueOf(this.serverName) + ".z" + zone;
            try {
                if (this.zoneName[zone] != null) {
                    SystemState.uiSet(String.valueOf(zonepfx) + ".name", "value", this.zoneName[zone]);
                }
                if (zone == this.menuSlaveZone) {
                    SystemState.uiSet(String.valueOf(zonepfx) + ".zonedisplay", "visible", "false");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".menudisplay", "visible", "true");
                } else {
                    SystemState.uiSet(String.valueOf(zonepfx) + ".zonedisplay", "visible", "true");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".menudisplay", "visible", "false");
                }
                if (SystemState.ioGet(String.valueOf(zonepfx) + ".power").equals("0")) {
                    SystemState.uiSet(String.valueOf(zonepfx) + ".status", "value", "OFF");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".volume", "value", "0");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".volume.status", "visible", "false");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".source", "visible", "false");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.1", "visible", "false");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.2", "visible", "false");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.3", "visible", "false");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.4", "visible", "false");
                } else {
                    String vol = SystemState.ioGet(String.valueOf(zonepfx) + ".volume");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".volume", "value", vol);
                    SystemState.uiSet(String.valueOf(zonepfx) + ".volume.status", "value", "off".equals(vol) ? "MUTE" : vol);
                    this.displaySourceStatus(this.zoneSource[zone]);
                    SystemState.uiSet(String.valueOf(zonepfx) + ".source", "visible", "true");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".volume.status", "visible", "true");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.1", "visible", "true");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.2", "visible", "true");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.3", "visible", "true");
                    SystemState.uiSet(String.valueOf(zonepfx) + ".displine.4", "visible", "true");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void displaySourceStatus(int source) {
        if (this.guiSupport) {
            String sourcepfx = String.valueOf(this.serverName) + ".s" + source + ".";
            try {
                int z = 1;
                while (z < 21) {
                    String zonepfx;
                    if (this.zoneSource[z] == source && this.sourceName[source] != null && SystemState.ioGet(String.valueOf(zonepfx = String.valueOf(this.serverName) + ".z" + z + ".") + "power").equals("1")) {
                        if (this.pageMode) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "source", "value", String.valueOf(source) + ". " + this.sourceName[source] + " [PAGE]");
                        } else {
                            SystemState.uiSet(String.valueOf(zonepfx) + "source", "value", String.valueOf(source) + ". " + this.sourceName[source]);
                        }
                        SystemState.uiSet(String.valueOf(zonepfx) + "displine.1", "value", SystemState.ioGet(String.valueOf(sourcepfx) + "displine.1"));
                        SystemState.uiSet(String.valueOf(zonepfx) + "displine.2", "value", SystemState.ioGet(String.valueOf(sourcepfx) + "displine.2"));
                        SystemState.uiSet(String.valueOf(zonepfx) + "displine.3", "value", SystemState.ioGet(String.valueOf(sourcepfx) + "displine.3"));
                        SystemState.uiSet(String.valueOf(zonepfx) + "displine.4", "value", SystemState.ioGet(String.valueOf(sourcepfx) + "displine.4"));
                        String status = SystemState.ioGet(String.valueOf(sourcepfx) + "status");
                        if (status.equals("normal") || status.equals("idle")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "ON");
                        } else if (status.equals("play")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "PLAY");
                        } else if (status.equals("pause")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "PAUSE");
                        } else if (status.equals("ffd")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "FAST FORWARD");
                        } else if (status.equals("rew")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "REWIND");
                        } else if (status.equals("playshuffle")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "PLAY [SH]");
                        } else if (status.equals("playrepeat")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "PLAY [REP]");
                        } else if (status.equals("playshufflerepeat")) {
                            SystemState.uiSet(String.valueOf(zonepfx) + "status", "value", "PLAY [SH][REP]");
                        }
                    }
                    ++z;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void displayMenuStatus() {
        if (this.guiSupport) {
            String prefix = String.valueOf(this.serverName) + ".menu.";
            if (this.menuId.equals("0")) {
                SystemState.uiSet(String.valueOf(prefix) + "name", "value", "");
                SystemState.uiSet(String.valueOf(prefix) + "wait", "visible", "false");
                SystemState.uiSet(String.valueOf(prefix) + "line.header", "value", "");
                SystemState.uiSet(String.valueOf(prefix) + "line.footer", "value", "");
                int i2 = 1;
                while (i2 <= this.menuLines) {
                    SystemState.uiSet(String.valueOf(prefix) + "line." + i2, "value", "");
                    ++i2;
                }
                if (this.menuLastSlaveZone != 0) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + this.menuLastSlaveZone + ".menudisplay", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + this.menuLastSlaveZone + ".zonedisplay", "visible", "true");
                    this.menuLastSlaveZone = 0;
                }
            } else {
                if (this.menuLastSlaveZone != this.menuSlaveZone) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + this.menuSlaveZone + ".zonedisplay", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + this.menuSlaveZone + ".menudisplay", "visible", "true");
                    this.menuLastSlaveZone = this.menuSlaveZone;
                }
                this.menuTime = System.currentTimeMillis();
                SystemState.uiSet(String.valueOf(prefix) + "name", "value", this.menuText);
                SystemState.uiSet(String.valueOf(prefix) + "wait", "visible", this.menuWaitFlag ? "true" : "false");
                SystemState.uiSet(String.valueOf(prefix) + "line.header", "value", this.menuFirstLineItemIndex > 0 ? "....." : "");
                SystemState.uiSet(String.valueOf(prefix) + "line.footer", "value", this.menuFirstLineItemIndex + this.menuLines < this.menuSize ? "....." : "");
                int i3 = 0;
                while (i3 < this.menuLines) {
                    int lineindex = i3 + this.menuFirstLineItemIndex;
                    if (this.itemText.containsKey(lineindex)) {
                        if (lineindex == this.menuSelectedItemIndex) {
                            SystemState.uiSet(String.valueOf(prefix) + "line." + (i3 + 1), "value", "> " + this.itemText.get(lineindex));
                        } else {
                            SystemState.uiSet(String.valueOf(prefix) + "line." + (i3 + 1), "value", this.itemText.get(lineindex));
                        }
                    } else {
                        SystemState.uiSet(String.valueOf(prefix) + "line." + (i3 + 1), "value", "");
                    }
                    ++i3;
                }
            }
        }
    }

    private void ioWrite(String name, String value) {
        SystemState.ioWrite(name, value);
    }

    private void ioWriteForced(String name, String value) {
        SystemState.ioWriteForced(name, value);
    }
}

