/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.fazecast.jSerialComm.SerialPort;
import com.hsyco.Configuration;
import com.hsyco.user;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class Netstreams {
    private static boolean initialized = false;
    private static final Executor exec = Executors.newCachedThreadPool();
    private static SerialPort NetstreamsPort;
    private static BufferedInputStream NetstreamsIn;
    private static BufferedOutputStream NetstreamsOut;
    private static Properties p;
    private static String[] sourceNames;
    private static int[] zoneSourceMemory;
    private static int[] zoneSource;
    private static int[] zoneVolume;
    private static int[] zoneMute;
    private static int[] zoneFrequency;
    private static int[] zoneMode;
    private static int[] zoneMemory;

    static {
        p = new Properties();
        sourceNames = new String[6];
        zoneSourceMemory = new int[]{-1, -1, -1, -1, -1, -1};
        zoneSource = new int[]{-1, -1, -1, -1, -1, -1};
        zoneVolume = new int[]{-1, -1, -1, -1, -1, -1};
        zoneMute = new int[]{-1, -1, -1, -1, -1, -1};
        zoneFrequency = new int[]{-1, -1, -1, -1, -1, -1};
        zoneMode = new int[]{-1, -1, -1, -1, -1, -1};
        zoneMemory = new int[]{-1, -1, -1, -1, -1, -1};
    }

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            user.messageLog("HSYCO ADDON MODULE - NETSTREAMS MUSICA MU5066 DRIVER - V.1.2.0");
            try {
                NetstreamsPort = Configuration.CommPortsSerial.elementAt(Configuration.CommPorts.indexOf("Netstreams"));
                NetstreamsIn = new BufferedInputStream(NetstreamsPort.getInputStream());
                NetstreamsOut = new BufferedOutputStream(NetstreamsPort.getOutputStream());
            }
            catch (Exception e2) {
                NetstreamsPort = null;
                user.errorLog("NETSTREAMS DRIVER - Serial Port Error: " + e2.getLocalizedMessage());
                return;
            }
            try {
                p.load(new FileInputStream(new File("netstreams.ini")));
                Netstreams.sourceNames[0] = p.getProperty("source.tuner", "FM");
                Netstreams.sourceNames[1] = p.getProperty("source.1", "S1");
                Netstreams.sourceNames[2] = p.getProperty("source.2", "S2");
                Netstreams.sourceNames[3] = p.getProperty("source.3", "S3");
                Netstreams.sourceNames[4] = p.getProperty("source.4", "S4");
                Netstreams.sourceNames[5] = p.getProperty("source.ext", "EXT");
            }
            catch (Exception e3) {
                Netstreams.sourceNames[0] = "FM";
                Netstreams.sourceNames[1] = "S1";
                Netstreams.sourceNames[2] = "S2";
                Netstreams.sourceNames[3] = "S3";
                Netstreams.sourceNames[4] = "S4";
                Netstreams.sourceNames[5] = "EXT";
            }
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    StringBuffer sb = new StringBuffer();
                    while (true) {
                        try {
                            while (true) {
                                int data;
                                if ((data = NetstreamsIn.read()) == 13) {
                                    if (sb.length() <= 0) continue;
                                    Netstreams.NetstreamsEvent(sb.toString());
                                    sb = new StringBuffer();
                                    continue;
                                }
                                if (data <= 0) continue;
                                sb.append((char)data);
                            }
                        }
                        catch (Exception e2) {
                            user.errorLog("NETSTREAMS DRIVER - Exception: " + e2.getLocalizedMessage());
                            continue;
                        }
                        break;
                    }
                }
            };
            exec.execute(task);
            Netstreams.NetstreamsEventsSubscribe();
        }
    }

    public static void command(String command) {
        Netstreams.NetstreamsCommand(command);
    }

    public static void source(int zone, int source) {
        if (zone < 0 || zone > 6 || source < 0 || source > 5) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: source(" + zone + "," + source + ")");
        } else {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: source(" + zone + "," + source + ")");
            switch (source) {
                case 0: {
                    Netstreams.NetstreamsCommand("ChangeSrc/" + zone + "/F");
                    break;
                }
                case 5: {
                    Netstreams.NetstreamsCommand("ChangeSrc/" + zone + "/E");
                    break;
                }
                default: {
                    Netstreams.NetstreamsCommand("ChangeSrc/" + zone + "/" + source);
                }
            }
        }
    }

    public static int sourceGet(int zone) {
        if (zone < 0 || zone > 6) {
            return -1;
        }
        return zoneSource[zone - 1];
    }

    public static void frequency(int zone, int frequency) {
        if (zone < 1 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: frequency(" + zone + "," + frequency + ")");
        } else {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: frequency(" + zone + "," + frequency + ")");
            Netstreams.NetstreamsCommand("ChangeFreq/" + zone + "/" + frequency);
        }
    }

    public static int frequencyGet(int zone) {
        if (zone < 1 || zone > 6) {
            return -1;
        }
        return zoneFrequency[zone - 1];
    }

    public static void frequency(int zone, boolean up) {
        if (zone < 1 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: frequency(" + zone + "," + up + ")");
        } else {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: frequency(" + zone + "," + up + ")");
            Netstreams.NetstreamsCommand("NudgeTune/" + zone + (up ? "/1" : "/0"));
        }
    }

    public static void memory(int zone, int memory) {
        if (zone < 1 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: memory(" + zone + "," + memory + ")");
        } else {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: memory(" + zone + "," + memory + ")");
            Netstreams.NetstreamsCommand("Chang/44/" + zone + "/" + memory);
        }
    }

    public static int memoryGet(int zone) {
        if (zone < 1 || zone > 6) {
            return -1;
        }
        return zoneMemory[zone - 1];
    }

    public static void off(int zone) {
        if (zone < 0 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: off(" + zone + ")");
        } else {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: off(" + zone + ")");
            Netstreams.NetstreamsCommand("ChangeSrc/" + zone + "/0");
        }
    }

    public static void on(int zone) {
        if (zone < 0 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: on(" + zone + ")");
        } else if (zone == 0) {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: on(" + zone + ")");
            Netstreams.NetstreamsCommand("AllOn");
        } else {
            Netstreams.source(zone, zoneSourceMemory[zone - 1] == -1 ? 1 : zoneSourceMemory[zone - 1]);
        }
    }

    public static void volume(int zone, int level, int delta) {
        if (delta == 0) {
            if (zone < 0 || zone > 6 || level < 0 || level > 35) {
                user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: volume(" + zone + "," + level + "," + delta + ")");
            } else {
                user.messageLog("NETSTREAMS DRIVER - COMMAND: volume(" + zone + "," + level + "," + delta + ")");
                Netstreams.NetstreamsCommand("ChangeVol/" + zone + "/" + level);
            }
        } else if (zone < 1 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: volume(" + zone + "," + level + "," + delta + ")");
        } else {
            int vol;
            user.messageLog("NETSTREAMS DRIVER - COMMAND: volume(" + zone + "," + level + "," + delta + ")");
            int n2 = vol = zoneVolume[zone - 1] == -1 ? 0 : zoneVolume[zone - 1];
            if (vol + delta > 35) {
                Netstreams.NetstreamsCommand("ChangeVol/" + zone + "/35");
            } else if (vol + delta < 0) {
                Netstreams.NetstreamsCommand("ChangeVol/" + zone + "/0");
            } else {
                Netstreams.NetstreamsCommand("ChangeVol/" + zone + "/" + (vol + delta));
            }
        }
    }

    public static void mute(int zone, boolean mute) {
        if (zone < 0 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: mute(" + zone + "," + mute + ")");
        } else {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: mute(" + zone + "," + mute + ")");
            Netstreams.NetstreamsCommand("ChangeMute/" + zone + (mute ? "/1" : "/0"));
        }
    }

    public static void mute(int zone) {
        if (zone < 1 || zone > 6) {
            user.errorLog("NETSTREAMS DRIVER - COMMAND ERROR: mute(" + zone + ")");
        } else {
            user.messageLog("NETSTREAMS DRIVER - COMMAND: mute(" + zone + ")");
            Netstreams.NetstreamsCommand("ChangeMute/" + zone + (zoneMute[zone - 1] == 1 ? "/0" : "/1"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void NetstreamsCommand(String command) {
        BufferedOutputStream bufferedOutputStream = NetstreamsOut;
        synchronized (bufferedOutputStream) {
            try {
                int i2 = 0;
                while (i2 < command.length()) {
                    NetstreamsOut.write(command.charAt(i2));
                    ++i2;
                }
                NetstreamsOut.write(13);
                NetstreamsOut.flush();
                user.sleep(600L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void NetstreamsEvent(String event) {
        user.messageLog("NETSTREAMS DRIVER - EVENT: " + event);
        try {
            String[] sa;
            int zone;
            if (event.startsWith("StatVer")) {
                Netstreams.NetstreamsEventsSubscribe();
            } else if (event.startsWith("EventSrc")) {
                String[] sa2 = event.split("/");
                int i2 = 1;
                while (i2 < 7) {
                    switch (sa2[i2].charAt(0)) {
                        case '0': {
                            Netstreams.zoneSource[i2 - 1] = -1;
                            Netstreams.NetstreamsDisplay(i2);
                            break;
                        }
                        case 'F': {
                            Netstreams.zoneSource[i2 - 1] = 0;
                            Netstreams.zoneSourceMemory[i2 - 1] = 0;
                            Netstreams.NetstreamsDisplay(i2);
                            break;
                        }
                        case 'E': {
                            Netstreams.zoneSource[i2 - 1] = 5;
                            Netstreams.zoneSourceMemory[i2 - 1] = 5;
                            Netstreams.NetstreamsDisplay(i2);
                            break;
                        }
                        case 'X': {
                            Netstreams.zoneSource[i2 - 1] = -1;
                            Netstreams.zoneSourceMemory[i2 - 1] = -1;
                            break;
                        }
                        default: {
                            int n2 = Integer.parseInt(sa2[i2]);
                            Netstreams.zoneSource[i2 - 1] = n2;
                            Netstreams.zoneSourceMemory[i2 - 1] = n2;
                            Netstreams.NetstreamsDisplay(i2);
                        }
                    }
                    ++i2;
                }
            } else if (event.startsWith("EventData")) {
                String[] sa3 = event.split("/");
                int zone2 = Integer.parseInt(sa3[1]);
                if (zone2 > 0) {
                    Netstreams.zoneVolume[zone2 - 1] = Integer.parseInt(sa3[2]);
                    Netstreams.zoneMute[zone2 - 1] = Integer.parseInt(sa3[7]);
                    Netstreams.NetstreamsDisplay(zone2);
                }
            } else if (event.startsWith("EventTuner") && (zone = Integer.parseInt((sa = event.split("/"))[1])) > 0) {
                Netstreams.zoneFrequency[zone - 1] = Integer.parseInt(sa[2]);
                Netstreams.zoneMode[zone - 1] = Integer.parseInt(sa[3]);
                Netstreams.zoneMemory[zone - 1] = sa[4].equalsIgnoreCase("X") ? -1 : Integer.parseInt(sa[4]);
                Netstreams.NetstreamsDisplay(zone);
            }
        }
        catch (Exception e2) {
            user.errorLog("NETSTREAMS DRIVER - PARSE ERROR: " + event);
        }
    }

    private static void NetstreamsDisplay(int zone) {
        switch (zoneSource[zone - 1]) {
            case -1: {
                user.uiSet("netstreams-" + zone + "-source", "value", "OFF");
                user.uiSet("netstreams-" + zone + "-volume", "value", "");
                user.uiSet("netstreams-" + zone + "-frequency", "value", "");
                user.uiSet("netstreams-" + zone + "-mode", "value", "");
                user.uiSet("netstreams-" + zone + "-memory", "value", "");
                user.uiSet("netstreams-" + zone + "-summary", "value", "OFF");
                break;
            }
            case 0: {
                String summary = new String(sourceNames[0]);
                user.uiSet("netstreams-" + zone + "-source", "value", sourceNames[0]);
                if (zoneFrequency[zone - 1] != -1) {
                    String freq = String.valueOf(zoneFrequency[zone - 1] / 100) + "." + zoneFrequency[zone - 1] % 100;
                    user.uiSet("netstreams-" + zone + "-frequency", "value", freq);
                    summary = String.valueOf(summary) + " " + freq + " MHz";
                }
                if (zoneVolume[zone - 1] == 0 || zoneMute[zone - 1] == 1) {
                    user.uiSet("netstreams-" + zone + "-volume", "value", "MUTE");
                    summary = String.valueOf(summary) + " - MUTE";
                } else if (zoneVolume[zone - 1] != -1) {
                    user.uiSet("netstreams-" + zone + "-volume", "value", Integer.toString(zoneVolume[zone - 1]));
                    summary = String.valueOf(summary) + " - VOL." + zoneVolume[zone - 1];
                }
                if (zoneMode[zone - 1] != -1) {
                    user.uiSet("netstreams-" + zone + "-mode", "value", zoneMode[zone - 1] == 1 ? "STEREO" : "MONO");
                }
                if (zoneMemory[zone - 1] != -1) {
                    user.uiSet("netstreams-" + zone + "-memory", "value", "P" + zoneMemory[zone - 1]);
                } else {
                    user.uiSet("netstreams-" + zone + "-memory", "value", "");
                }
                user.uiSet("netstreams-" + zone + "-summary", "value", summary);
                break;
            }
            default: {
                String summary = new String(sourceNames[zoneSource[zone - 1]]);
                user.uiSet("netstreams-" + zone + "-source", "value", sourceNames[zoneSource[zone - 1]]);
                if (zoneVolume[zone - 1] == 0 || zoneMute[zone - 1] == 1) {
                    user.uiSet("netstreams-" + zone + "-volume", "value", "MUTE");
                    summary = String.valueOf(summary) + " - MUTE";
                } else if (zoneVolume[zone - 1] != -1) {
                    user.uiSet("netstreams-" + zone + "-volume", "value", Integer.toString(zoneVolume[zone - 1]));
                    summary = String.valueOf(summary) + " - VOL." + zoneVolume[zone - 1];
                }
                user.uiSet("netstreams-" + zone + "-frequency", "value", "");
                user.uiSet("netstreams-" + zone + "-mode", "value", "");
                user.uiSet("netstreams-" + zone + "-memory", "value", "");
                user.uiSet("netstreams-" + zone + "-summary", "value", summary);
            }
        }
    }

    private static void NetstreamsEventsSubscribe() {
        Netstreams.NetstreamsCommand("EventSrc/1");
        Netstreams.NetstreamsCommand("EventData/0/1");
        Netstreams.NetstreamsCommand("EventTuner/1");
        Netstreams.NetstreamsCommand("EventPress/1");
    }
}

