/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.fazecast.jSerialComm.SerialPort;
import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class MyHomeSDK {
    public static final String[] WebObjects = new String[]{"3button", "button", "buttonicon", "buttonimage", "dimmer", "tempmini"};
    private static final int SCENE = 0;
    private static final int LIGHT = 1;
    private static final int AUTOM = 2;
    private static final int DIMMER = 11;
    private static final int SECURITY = 5;
    private static final int TEMP = 4;
    private static final int AUX = 9;
    private static final int CEN = 15;
    private static final int CENPLUS = 25;
    private static final int UNDEF = -1;
    private static Hashtable<String, SerialPort> serialPortsCache = new Hashtable();
    private String serverName;
    private int language = Configuration.language <= 2 ? Configuration.language : 0;
    int ioIndex;
    private ArrayBlockingQueue<String> ioqtx = null;
    ioMonitor me;
    private SerialPort serial = null;
    private OpenBufferedReader in = null;
    private PrintWriter out = null;
    private boolean startupevents = false;
    private boolean discovery = true;
    private boolean online = false;
    private AtomicInteger commandStatus = new AtomicInteger(-1);
    private int commandNackReason = -1;
    private Hashtable<String, String> states = new Hashtable();
    private Hashtable<String, Long> scenesResetTime = new Hashtable();
    private HashSet<String> securityAlarms = new HashSet();
    private boolean securityDelayEndFlag = false;
    private int tempCentralUnitAddress = 0;
    private int tempMode = -1;
    private boolean tempIgnoreLocalOffsetOnWrite = false;
    private BitSet tempZones = new BitSet();
    private BitSet tempZonesFanUISet = new BitSet();
    private BitSet tempZonesFanUIPresent = new BitSet();
    private tempZone[] tempZonesStatus = null;
    private int tempCentralUnitLastManualSetpoint = -200;
    private long tempCentralUnitLastManualSetpointTime = 0L;
    private int tempCentralUnitLastAwaySetpoint = -1;
    private long tempCentralUnitLastAwaySetpointTime = 0L;
    private Properties myHomeFileProperties = new Properties();
    private long myHomeFileLastModified = 0L;
    private static final String[][] TEXT = new String[][]{{"ON", "OFF", "SUMMER", "WINTER", "AUTO", "MAN", "PROT", "FAULT", "MIN", "MED", "MAX", "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN", "SCENE", "AWAY", "HOLIDAY", "DAYS", "WEEKLY", "MAINTENANCE", "ARMED", "DISARMED", "END OF DELAY", "BATTERY FAULT", "BATTERY OK", "AC POWER FAULT", "AC POWER OK", "ZONE", "AUX", "SENSOR", "ALARM", "TAMPER", "PANIC", "PROGRAMMING", "TECHNICAL"}, {"ON", "OFF", "ESTATE", "INVERNO", "AUTO", "MAN", "PROT", "GUASTO", "MIN", "MED", "MAX", "LUN", "MAR", "MER", "GIO", "VEN", "SAB", "DOM", "SCENARIO", "FERIE", "FESTIVO", "GIORNI", "SETTIMANALE", "MANUTENZIONE", "INSERITO", "DISINSERITO", "FINE RITARDO", "GUASTO BATTERIA", "BATTERIA OK", "MANCANZA RETE", "RETE OK", "ZONA", "AUX", "SENSORE", "ALLARME", "TAMPER", "PANICO", "PROGRAMMAZIONE", "TECNICO"}, {"ON", "OFF", "&Eacute;T&Eacute;", "HIVER", "AUTO", "MAN", "PROT", "FAUTE", "MIN", "MED", "MAX", "LUN", "MAR", "MER", "JEU", "VEN", "SAM", "DIM", "SCENE", "SUITE", "VACANCES", "JOURS", "SEMAINE", "MAINTENANCE", "ARME'", "DESARME'", "FIN DE RETARD", "DEFAUT BATTERIE", "BATTERIE OK", "PANNE D'ALIMENTATION", "PUISSANCE OK", "ZONE", "AUX", "DETECTEUR", "ALARME", "TAMPER", "PANIQUE", "PROGRAMMATION", "TECHNIQUE"}};

    MyHomeSDK() {
    }

    /*
     * Exception decompiling
     */
    private boolean sendCommand(String frameString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 9[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendCommandNoWait(String frameString) {
        try {
            SerialPort serialPort = this.serial;
            synchronized (serialPort) {
                this.out.print(frameString);
                this.out.flush();
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void monitor(int ioIndex, ioMonitor me) {
        long housekeepingTime = 0L;
        this.me = me;
        this.ioIndex = ioIndex;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        String port = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            block52: {
                try {
                    String value;
                    String[] sb = sa[i2].split("=");
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                    if (param.equals("startupevents")) {
                        this.startupevents = value.equals("true");
                        break block52;
                    }
                    if (param.equals("discovery")) {
                        this.discovery = value.equals("true");
                        break block52;
                    }
                    if (param.equals("tempignorelocaloffset")) {
                        this.tempIgnoreLocalOffsetOnWrite = value.equals("true");
                        break block52;
                    }
                    if (param.equalsIgnoreCase("tempzones")) {
                        String[] st = value.split("[ ;]+");
                        int x = 0;
                        while (x < st.length) {
                            try {
                                int z;
                                if (st[x].startsWith("(") && st[x].endsWith(")")) {
                                    this.tempCentralUnitAddress = z = Integer.parseInt(st[x].substring(1, st[x].length() - 1));
                                } else {
                                    z = Integer.parseInt(st[x]);
                                }
                                if (z > 0 && z < 100) {
                                    this.tempZones.set(z);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++x;
                        }
                        if (this.tempZones.length() > 0) {
                            this.tempZonesStatus = new tempZone[this.tempZones.length()];
                            int z = 1;
                            while (z < this.tempZonesStatus.length) {
                                if (this.tempZones.get(z)) {
                                    this.tempZonesStatus[z] = new tempZone();
                                }
                                ++z;
                            }
                        }
                        break block52;
                    }
                    if (param.equals("language")) {
                        if (value.equalsIgnoreCase("en")) {
                            this.language = 0;
                        } else if (value.equalsIgnoreCase("it")) {
                            this.language = 1;
                        } else if (value.equalsIgnoreCase("fr")) {
                            this.language = 2;
                        }
                    }
                }
                catch (Exception e2) {
                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
                }
            }
            ++i2;
        }
        if (this.discovery) {
            Configuration.systemtopoDiscovery = true;
        }
        try {
            if (serialPortsCache.containsKey(port)) {
                this.serial = serialPortsCache.get(port);
            } else {
                this.serial = util.openComm(port, 115200, 8, 1, 0, 0, 2000);
                serialPortsCache.put(port, this.serial);
            }
            this.out = new PrintWriter(this.serial.getOutputStream(), true);
            this.in = new OpenBufferedReader(new InputStreamReader(this.serial.getInputStream()));
            this.in.flush();
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + e3.getLocalizedMessage());
            try {
                this.out.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            return;
        }
        PluginsWrapper.register(this.serverName, 48, this);
        CommandDispatcher commandDispatcher2 = new CommandDispatcher();
        this.ioqtx.clear();
        commandDispatcher2.start();
        SystemState.ioSet(String.valueOf(this.serverName) + ".status", "all_at_monitor_init");
        me.heartbeat = System.currentTimeMillis();
        while (!me.quit) {
            try {
                String fs;
                if (this.online && housekeepingTime < me.heartbeat) {
                    housekeepingTime = me.heartbeat + 5000L;
                    if (this.tempZonesStatus != null) {
                        int i3 = 1;
                        while (i3 < this.tempZonesStatus.length) {
                            if (this.tempZonesStatus[i3] != null && this.tempZonesStatus[i3].refreshtime > 0L && this.tempZonesStatus[i3].refreshtime < me.heartbeat) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + i3, "actuator_refresh");
                                this.tempZonesStatus[i3].refreshtime = -1L;
                            }
                            ++i3;
                        }
                    }
                    Enumeration<String> e4 = this.scenesResetTime.keys();
                    while (e4.hasMoreElements()) {
                        String key = e4.nextElement();
                        if (this.scenesResetTime.get(key) >= me.heartbeat) continue;
                        this.ioWrite(true, true, 0, key, "0");
                        this.scenesResetTime.remove(key);
                    }
                }
                if ((fs = this.in.readOpenFrame()) != null) {
                    OpenParser frame = new OpenParser(fs);
                    me.heartbeat = System.currentTimeMillis();
                    this.deviceStateWrite(this.online || this.startupevents, frame);
                } else if (me.heartbeat < System.currentTimeMillis() - 10000L) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".keepalive", null);
                }
                if (!commandDispatcher2.isAlive()) {
                    throw new Exception("command dispatcher not alive");
                }
                if (!this.online || commandDispatcher2.heartbeat >= me.heartbeat - 40000L) continue;
                throw new Exception("no command dispatcher heartbeat");
            }
            catch (Exception e5) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5.getMessage());
                me.quit = true;
            }
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            commandDispatcher2.quit = true;
            AtomicInteger atomicInteger = this.commandStatus;
            synchronized (atomicInteger) {
                this.commandStatus.set(-1);
                this.commandStatus.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    public String keypad(String id) {
        String key = id.toLowerCase();
        try {
            String[] sa = key.split("[.]+");
            if (sa[0].equals("temp")) {
                if (sa[1].equals("command")) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".temp.command", key.substring(13));
                } else if (sa[2].equals("setpoint")) {
                    if (sa[3].equals("temp")) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", sa[4]);
                    } else if (sa[3].equals("mode")) {
                        String mode = SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint.mode");
                        String cumode = SystemState.ioGet(String.valueOf(this.serverName) + ".temp.setpoint.mode");
                        if (mode.equals("man")) {
                            if (cumode.equals("man")) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "protection");
                            } else {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "auto");
                            }
                        } else if (mode.equals("auto")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "protection");
                        } else if (mode.equals("protection")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "off");
                        } else if (mode.equals("off")) {
                            if (cumode.equals("off") || cumode.equals("protection")) {
                                int temp = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".temp")) / 5 * 5;
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", Integer.toString(temp));
                            } else {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "auto");
                            }
                        }
                    }
                } else if (sa[2].equals("unlock")) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1], "unlock");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private boolean commandExecutor(String id, String value) {
        boolean error = true;
        String ext = null;
        String what = null;
        String where = null;
        String who = null;
        try {
            String lid = id.toLowerCase();
            if (lid.equals("frame")) {
                error = !this.sendCommand(value);
            } else if (lid.equals("keepalive")) {
                error = !this.sendCommandNoWait("*#13**15##");
            } else if (lid.equals("status")) {
                if (value.equalsIgnoreCase("all_at_monitor_init")) {
                    if (this.statusRequest()) {
                        error = false;
                        try {
                            userCode.IOStartupEvent(this.ioIndex);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("ioCommandDispatcher - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e2);
                        }
                        if (this.ioIndex > 0) {
                            events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
                        } else {
                            events.eventsExec("IOSTART", 0, 0, null);
                        }
                        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                        SystemState.ioServersInitializedSet(this.ioIndex, true);
                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.panel.myhome", "visible", "true");
                        this.online = true;
                    } else {
                        this.online = false;
                        hsyco.errorLog("ioCommandDispatcher - Error [" + this.serverName + "] - Failed to initialize status");
                    }
                }
            } else if (lid.equals("monitor")) {
                this.ioWrite(false, false, -1, "monitor", value.toLowerCase());
                error = false;
            } else if (lid.startsWith("scene")) {
                String[] ida = lid.split("[.]");
                if (ida.length == 2 || ida.length == 3 && (ida[1].charAt(0) == 'l' || ida[1].charAt(0) == 'L')) {
                    String string = where = ida.length == 2 ? ida[1] : String.valueOf(ida[2]) + "#4#" + ida[1].substring(1);
                    if (value.equalsIgnoreCase("erase")) {
                        what = "42";
                    } else if (value.equalsIgnoreCase("lock")) {
                        what = "43";
                    } else if (value.equalsIgnoreCase("unlock")) {
                        what = "44";
                    }
                } else if (ida.length == 3 && ida[1].length() > 1) {
                    where = ida[1];
                    if (value.equals("1") || value.equalsIgnoreCase("on") || value.equals("0") || value.equalsIgnoreCase("off")) {
                        what = ida[2];
                    } else if (value.equals("record")) {
                        what = "40#" + ida[2];
                    } else if (value.equals("end")) {
                        what = "41#" + ida[2];
                    } else if (value.equals("erase")) {
                        what = "42#" + ida[2];
                    }
                } else if (ida.length == 4) {
                    where = String.valueOf(ida[2]) + "#4#" + ida[1].substring(1);
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        what = ida[3];
                    } else if (value.equals("0") || value.equalsIgnoreCase("off")) {
                        this.ioWrite(true, true, 0, String.valueOf(where) + "." + ida[3], "0");
                        what = String.valueOf(ida[3]) + "#0";
                    } else if (value.equalsIgnoreCase("clear")) {
                        this.ioWrite(true, true, 0, String.valueOf(where) + "." + ida[3], "0");
                        error = false;
                    } else if (value.equals("record")) {
                        what = "40#" + ida[3];
                    } else if (value.equals("end")) {
                        what = "41#" + ida[3];
                    } else if (value.equals("erase")) {
                        what = "42#" + ida[3];
                    }
                }
                if (what != null && where != null) {
                    error = !this.sendCommand("*0*" + what + "*" + where + "##");
                }
            } else if (lid.startsWith("light")) {
                String[] ida = lid.split("[.]");
                who = "1";
                switch (ida.length) {
                    case 2: {
                        where = ida[1];
                        break;
                    }
                    case 3: {
                        where = String.valueOf(ida[2]) + "#4#" + ida[1].substring(1);
                    }
                }
                if (where.charAt(0) == 'g') {
                    where = "#" + where.substring(1);
                }
                if (value.equals("0") || value.equalsIgnoreCase("off")) {
                    what = "0";
                } else if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    what = "1";
                } else if (value.endsWith("%")) {
                    int level = Integer.parseInt(value.substring(0, value.length() - 1));
                    if (level >= 20 && level <= 100) {
                        what = Integer.toString(level / 10);
                    } else if (level > 0 && level < 20) {
                        what = "2";
                    } else if (level == 0) {
                        what = "0";
                    }
                } else if (value.equals("lock")) {
                    who = "14";
                    what = "0";
                } else if (value.equals("unlock")) {
                    who = "14";
                    what = "1";
                } else {
                    int index = value.indexOf(47);
                    if (index > 0) {
                        int level = 10 * Integer.parseInt(value.substring(0, index)) / Integer.parseInt(value.substring(index + 1));
                        if (level >= 2 && level <= 10) {
                            what = Integer.toString(level);
                        }
                    } else {
                        try {
                            int level = Integer.parseInt(value);
                            if (level >= 1 && level <= 20) {
                                what = "2";
                            } else if (level <= 100) {
                                what = Integer.toString(level / 10);
                            }
                        }
                        catch (Exception e3) {
                            what = value;
                        }
                    }
                }
                if (what != null && where != null) {
                    error = !this.sendCommand("*" + who + "*" + what + "*" + where + "##");
                }
            } else if (lid.startsWith("autom")) {
                String[] ida = lid.split("[.]");
                who = "2";
                switch (ida.length) {
                    case 2: {
                        where = ida[1];
                        break;
                    }
                    case 3: {
                        where = String.valueOf(ida[2]) + "#4#" + ida[1].substring(1);
                    }
                }
                if (where.charAt(0) == 'g') {
                    where = "#" + where.substring(1);
                }
                if (value.equals("stop") || value.equals("off") || value.equals("0")) {
                    what = "0";
                } else if (value.equals("up")) {
                    what = "1";
                } else if (value.equals("down")) {
                    what = "2";
                } else if (value.equals("lock")) {
                    who = "14";
                    what = "0";
                } else if (value.equals("unlock")) {
                    who = "14";
                    what = "1";
                }
                if (what != null && where != null) {
                    error = !this.sendCommand("*" + who + "*" + what + "*" + where + "##");
                }
            } else if (lid.startsWith("temp")) {
                String[] ida = lid.split("[.]");
                if (value.equalsIgnoreCase("refresh")) {
                    switch (ida.length) {
                        case 1: {
                            error = !this.tempCentralUnitStatusRequest() || !this.tempZonesStatusRequest();
                            break;
                        }
                        case 2: {
                            error = !this.tempZoneStatusRequest(Integer.parseInt(ida[1]));
                        }
                    }
                } else if (value.equalsIgnoreCase("actuator_refresh")) {
                    if (ida.length == 2) {
                        error = !this.tempZoneActuatorRequest(Integer.parseInt(ida[1]));
                    }
                } else if (lid.equals("temp.mode")) {
                    if (value.equalsIgnoreCase("winter")) {
                        who = "#4";
                        where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                        what = "0";
                    } else if (value.equalsIgnoreCase("summer")) {
                        who = "#4";
                        where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                        what = "1";
                    }
                } else if (lid.equals("temp.command")) {
                    if (value.equals("1") || value.equals("2") || value.equals("3")) {
                        who = "4";
                        where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                        what = "310" + value;
                    } else if (value.startsWith("holiday")) {
                        who = "4";
                        where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                        what = value.length() == 9 && value.charAt(7) == '.' ? "315#310" + value.substring(8) : "315#3101";
                    } else if (value.equals("off")) {
                        who = "4";
                        where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                        what = "303";
                    } else if (value.equals("protection")) {
                        who = "4";
                        where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                        what = "winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".temp.mode")) ? "102" : "202";
                    } else if (value.startsWith("away")) {
                        int endprogram;
                        int days;
                        if (value.length() == 4) {
                            days = 1;
                            endprogram = 1;
                        } else if (value.length() == 13 || value.length() == 15) {
                            endprogram = value.length() == 15 && value.charAt(13) == '.' ? Integer.parseInt(value.substring(14)) : 1;
                            String sdate = Integer.toString(100000000 + Integer.parseInt(value.substring(5, 13)));
                            Calendar now = Calendar.getInstance();
                            now.setTimeInMillis(System.currentTimeMillis());
                            now.clear(13);
                            now.clear(14);
                            int y = Integer.parseInt(sdate.substring(1, 5));
                            int m2 = Integer.parseInt(sdate.substring(5, 7));
                            int d2 = Integer.parseInt(sdate.substring(7, 9));
                            Calendar ymd = Calendar.getInstance();
                            ymd.setLenient(false);
                            ymd.set(y > 0 ? y : now.get(1), m2 > 0 ? m2 - 1 : now.get(2), d2 > 0 ? d2 : now.get(5));
                            days = (int)(ymd.getTimeInMillis() - now.getTimeInMillis()) / 86400000;
                        } else {
                            int x = value.indexOf(46, 5);
                            if (x == -1) {
                                char sign = value.charAt(5);
                                if (Character.isDigit(sign)) {
                                    days = Integer.parseInt(value.substring(5)) - 1;
                                    endprogram = 1;
                                } else {
                                    int d3;
                                    String cumode;
                                    int l2 = this.tempCentralUnitLastAwaySetpointTime + 10000L < System.currentTimeMillis() ? ("away".equals(cumode = SystemState.ioGet(String.valueOf(this.serverName) + ".temp.setpoint.mode")) ? Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".temp.setpoint")) : 0) : Math.abs(this.tempCentralUnitLastAwaySetpoint);
                                    switch (sign) {
                                        case '+': {
                                            d3 = l2 + Integer.parseInt(value.substring(6));
                                            break;
                                        }
                                        case '-': {
                                            d3 = l2 - Integer.parseInt(value.substring(6));
                                            break;
                                        }
                                        default: {
                                            d3 = 0;
                                        }
                                    }
                                    if (d3 == 1) {
                                        this.tempCentralUnitLastAwaySetpoint = 2;
                                        this.tempCentralUnitLastAwaySetpointTime = System.currentTimeMillis() + 4000L;
                                        this.tempCentralUnitUIUpdate("away", "2");
                                    } else if (d3 > 1 && d3 < 256) {
                                        this.tempCentralUnitLastAwaySetpoint = d3;
                                        this.tempCentralUnitLastAwaySetpointTime = System.currentTimeMillis() + 4000L;
                                        this.tempCentralUnitUIUpdate("away", Integer.toString(d3));
                                    }
                                    days = 0;
                                    endprogram = 1;
                                    error = false;
                                }
                            } else {
                                days = Integer.parseInt(value.substring(5, x)) - 1;
                                endprogram = Integer.parseInt(value.substring(x + 1));
                            }
                        }
                        if (days > 0 && days <= 255) {
                            this.tempCentralUnitLastAwaySetpoint = -(days + 1);
                            who = "4";
                            where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                            what = "33" + Integer.toString(1000 + days).substring(1) + "#310" + endprogram;
                        }
                    } else if (value.equals("up")) {
                        int temp = (Math.abs(this.tempCentralUnitLastManualSetpoint) / 5 + 1) * 5;
                        if (temp >= 50 && temp < 400) {
                            this.tempCentralUnitLastManualSetpoint = temp;
                            this.tempCentralUnitLastManualSetpointTime = System.currentTimeMillis() + 2000L;
                            this.tempCentralUnitUIUpdate(null, Integer.toString(temp));
                        }
                        error = false;
                    } else if (value.equals("down")) {
                        int temp = (Math.abs(this.tempCentralUnitLastManualSetpoint) / 5 - 1) * 5;
                        if (temp >= 50 && temp < 400) {
                            this.tempCentralUnitLastManualSetpoint = temp;
                            this.tempCentralUnitLastManualSetpointTime = System.currentTimeMillis() + 2000L;
                            this.tempCentralUnitUIUpdate(null, Integer.toString(temp));
                        }
                        error = false;
                    } else if (value.startsWith("scenario.")) {
                        int scene = Integer.parseInt(value.substring(9));
                        if (scene >= 1 && scene <= 16) {
                            who = "4";
                            where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                            what = "32" + Integer.toString(100 + scene).substring(1);
                        }
                    } else {
                        int temp = Integer.parseInt(value);
                        if (temp >= 50 && temp < 100) {
                            who = "#4";
                            where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                            ext = "#14*00" + temp + "*3";
                        } else if (temp >= 100 && temp <= 400) {
                            who = "#4";
                            where = this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress;
                            ext = "#14*0" + temp + "*3";
                        }
                    }
                } else if (ida.length == 2) {
                    if (value.equals("unlock")) {
                        int zone = Integer.parseInt(ida[1]);
                        where = Integer.toString(zone);
                        who = "4";
                        what = "40";
                        this.ioWrite(true, true, 4, Integer.toString(zone), "unlock");
                    }
                } else if (ida.length == 3 && ida[2].equals("setpoint")) {
                    int zone = Integer.parseInt(ida[1]);
                    if (this.tempCentralUnitAddress == 0 && zone > 0 && zone < 100) {
                        where = "#" + zone;
                        if (value.equalsIgnoreCase("0") || value.equalsIgnoreCase("off")) {
                            who = "4";
                            what = "303";
                        } else if (value.equalsIgnoreCase("auto")) {
                            who = "4";
                            what = "311";
                        } else if (value.equalsIgnoreCase("protection")) {
                            who = "4";
                            what = "302";
                        } else if (value.equalsIgnoreCase("up")) {
                            try {
                                String setpoint;
                                int temp = this.tempZonesStatus[zone].tempman == -1 ? ((setpoint = SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint")) != null ? Integer.parseInt(setpoint) : 200) : this.tempZonesStatus[zone].tempman;
                                temp = (temp / 5 + 1) * 5;
                                if (temp >= 50 && temp < 400) {
                                    this.tempZonesStatus[zone].tempmants = System.currentTimeMillis() + 4000L;
                                    this.tempZonesStatus[zone].tempman = temp;
                                    try {
                                        int local = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.local"));
                                        if (local > 0) {
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0 - (double)local) + "+" + local + " &deg;C");
                                        } else if (local < 0) {
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0 - (double)local) + local + " &deg;C");
                                        } else {
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0) + " &deg;C");
                                        }
                                    }
                                    catch (Exception e4) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0) + " &deg;C");
                                    }
                                }
                                error = false;
                            }
                            catch (Exception e4) {}
                        } else if (value.equalsIgnoreCase("down")) {
                            try {
                                String setpoint;
                                int temp = this.tempZonesStatus[zone].tempman == -1 ? ((setpoint = SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint")) != null ? Integer.parseInt(setpoint) : 200) : this.tempZonesStatus[zone].tempman;
                                temp = (temp / 5 - 1) * 5;
                                if (temp >= 50 && temp < 400) {
                                    this.tempZonesStatus[zone].tempmants = System.currentTimeMillis() + 4000L;
                                    this.tempZonesStatus[zone].tempman = temp;
                                    try {
                                        int local = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.local"));
                                        if (local > 0) {
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0 - (double)local) + "+" + local + " &deg;C");
                                        } else if (local < 0) {
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0 - (double)local) + local + " &deg;C");
                                        } else {
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0) + " &deg;C");
                                        }
                                    }
                                    catch (Exception e5) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", String.valueOf((double)temp / 10.0) + " &deg;C");
                                    }
                                }
                                error = false;
                            }
                            catch (Exception e5) {}
                        } else {
                            try {
                                int local;
                                try {
                                    local = this.tempIgnoreLocalOffsetOnWrite ? 0 : Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.local"));
                                }
                                catch (Exception e6) {
                                    local = 0;
                                }
                                int temp = Integer.parseInt(value) - 10 * local;
                                if (temp >= 50 && temp < 100) {
                                    who = "#4";
                                    ext = "#14*00" + temp + "*3";
                                } else if (temp >= 100 && temp <= 400) {
                                    who = "#4";
                                    ext = "#14*0" + temp + "*3";
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (what != null && where != null) {
                    error = !this.sendCommand("*" + who + "*" + what + "*" + where + "##");
                } else if (ext != null && where != null) {
                    error = !this.sendCommand("*" + who + "*" + where + "*" + ext + "##");
                }
            } else if (lid.startsWith("aux")) {
                String[] ida = lid.split("[.]");
                if (ida.length == 2) {
                    if (value.equals("0") || value.equalsIgnoreCase("off")) {
                        what = "0";
                    } else if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        what = "1";
                    }
                    if (what != null) {
                        String fs = "*9*" + what + "*" + ida[1] + "##";
                        boolean bl = error = !this.sendCommand(fs);
                        if (!error) {
                            this.deviceStateWrite(true, new OpenParser(fs));
                        }
                    }
                }
            } else if (lid.startsWith("cenplus")) {
                String[] ida = lid.split("[.]");
                if (ida[1].charAt(0) == 'l' || ida[1].charAt(0) == 'L') {
                    where = String.valueOf(ida[2]) + "#4#" + ida[1].substring(1);
                    if (ida.length == 3) {
                        if (value.equalsIgnoreCase("on")) {
                            what = "31#1";
                        } else if (value.equalsIgnoreCase("off")) {
                            what = "32#1";
                        } else if (value.equalsIgnoreCase("request")) {
                            error = !this.sendCommand("*#25*" + where + "##");
                        }
                    } else if (ida.length == 4) {
                        if (value.equalsIgnoreCase("on")) {
                            what = "21#" + ida[3];
                        } else if (value.equalsIgnoreCase("onlong")) {
                            what = "22#" + ida[3];
                        } else if (value.equalsIgnoreCase("onrepeat")) {
                            what = "23#" + ida[3];
                        } else if (value.equalsIgnoreCase("offlong")) {
                            what = "24#" + ida[3];
                        }
                    }
                } else {
                    where = ida[1];
                    if (ida.length == 2) {
                        if (value.equalsIgnoreCase("on")) {
                            what = "31#1";
                        } else if (value.equalsIgnoreCase("off")) {
                            what = "32#1";
                        } else if (value.equalsIgnoreCase("request")) {
                            error = !this.sendCommand("*#25*" + where + "##");
                        }
                    } else if (ida.length == 3) {
                        if (value.equalsIgnoreCase("on")) {
                            what = "21#" + ida[2];
                        } else if (value.equalsIgnoreCase("onlong")) {
                            what = "22#" + ida[2];
                        } else if (value.equalsIgnoreCase("onrepeat")) {
                            what = "23#" + ida[2];
                        } else if (value.equalsIgnoreCase("offlong")) {
                            what = "24#" + ida[2];
                        }
                    }
                }
                if (what != null && where != null) {
                    error = !this.sendCommand("*25*" + what + "*" + where + "##");
                }
            } else if (lid.startsWith("cen")) {
                String[] ida = lid.split("[.]");
                if (ida[1].charAt(0) == 'l' || ida[1].charAt(0) == 'L') {
                    where = String.valueOf(ida[2]) + "#4#" + ida[1].substring(1);
                    if (ida.length == 4) {
                        if (value.equalsIgnoreCase("on")) {
                            what = ida[3];
                        } else if (value.equalsIgnoreCase("off")) {
                            what = String.valueOf(ida[3]) + "#1";
                        } else if (value.equalsIgnoreCase("offlong")) {
                            what = String.valueOf(ida[3]) + "#2";
                        } else if (value.equalsIgnoreCase("onrepeat")) {
                            what = String.valueOf(ida[3]) + "#3";
                        }
                    }
                } else {
                    where = ida[1];
                    if (ida.length == 3) {
                        if (value.equalsIgnoreCase("on")) {
                            what = ida[2];
                        } else if (value.equalsIgnoreCase("off")) {
                            what = String.valueOf(ida[2]) + "#1";
                        } else if (value.equalsIgnoreCase("offlong")) {
                            what = String.valueOf(ida[2]) + "#2";
                        } else if (value.equalsIgnoreCase("onrepeat")) {
                            what = String.valueOf(ida[2]) + "#3";
                        }
                    }
                }
                if (what != null && where != null) {
                    error = !this.sendCommand("*15*" + what + "*" + where + "##");
                }
            } else if (lid.startsWith("load")) {
                String command = null;
                String[] ida = lid.split("[.]");
                if (ida[1].equals("power") && value.equalsIgnoreCase("refresh")) {
                    command = "*#3*10*3##";
                } else if (ida[1].equals("voltage") && value.equalsIgnoreCase("refresh")) {
                    command = "*#3*10*1##";
                } else if (ida[1].equals("current") && value.equalsIgnoreCase("refresh")) {
                    command = "*#3*10*2##";
                } else if (ida[1].equals("energy") && value.equalsIgnoreCase("refresh")) {
                    command = "*#3*10*4##";
                }
                error = command != null ? !this.sendCommand(command) : true;
            }
            if (error) {
                if (!"status".equals(id)) {
                    hsyco.errorLog("ioCommandDispatcher - Command error [" + this.serverName + "] - NACK or invalid format: " + id + "=" + value);
                }
                return false;
            }
            return true;
        }
        catch (Exception e7) {
            hsyco.errorLog("ioCommandDispatcher - Command Exception [" + this.serverName + "] - " + e7.getLocalizedMessage());
            return false;
        }
    }

    private boolean statusRequest() {
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (this.sendCommandNoWait("*#13**16##")) break block6;
                            hsyco.errorLog("ioMonitor - Failed to retrieve firmware version [" + this.serverName + "] - light");
                            return false;
                        }
                        catch (Exception e2) {
                            return false;
                        }
                    }
                    if (this.sendCommand("*#1*0##")) break block7;
                    hsyco.errorLog("ioMonitor - Failed to retrieve status [" + this.serverName + "] - light");
                    return false;
                }
                if (this.sendCommand("*#2*0##")) break block8;
                hsyco.errorLog("ioMonitor - Failed to retrieve status [" + this.serverName + "] - autom");
                return false;
            }
            this.securityAlarmsReset(false);
            if (this.tempCentralUnitStatusRequest()) break block9;
            return false;
        }
        return this.tempZonesStatusRequest();
    }

    private boolean tempCentralUnitStatusRequest() {
        try {
            if (!this.tempZones.isEmpty() && !this.sendCommand(this.tempCentralUnitAddress == 0 ? "*#4*#0##" : "*#4*#0#" + this.tempCentralUnitAddress + "##")) {
                hsyco.errorLog("ioMonitor - Failed to retrieve status [" + this.serverName + "] - temperature control unit");
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean tempZonesStatusRequest() {
        try {
            if (!this.tempZones.isEmpty()) {
                int i2 = 1;
                while (i2 <= 99) {
                    if (this.tempZones.get(i2)) {
                        this.tempZoneStatusRequest(i2);
                    }
                    ++i2;
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean tempZoneStatusRequest(int zone) {
        block3: {
            block4: {
                boolean error = false;
                int WAIT = 200;
                try {
                    if (this.tempZones.isEmpty() || !this.tempZones.get(zone)) break block3;
                    Thread.sleep(200L);
                    error |= !this.sendCommand("*#4*#" + zone + "##");
                    Thread.sleep(200L);
                    error |= !this.sendCommand("*#4*" + zone + "*0##");
                    Thread.sleep(200L);
                    error |= !this.sendCommand("*#4*" + zone + "*11##");
                    Thread.sleep(200L);
                    error |= !this.sendCommand("*#4*" + zone + "*12##");
                    Thread.sleep(200L);
                    error |= !this.sendCommand("*#4*" + zone + "*13##");
                    Thread.sleep(200L);
                    boolean bl = !this.sendCommand("*#4*" + zone + "*14##");
                    Thread.sleep(200L);
                    if (!(error |= bl)) break block4;
                    hsyco.errorLog("ioMonitor - Failed to retrieve status [" + this.serverName + "] - temperature zone " + zone);
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            this.tempZoneActuatorRequest(zone);
        }
        return true;
    }

    private boolean tempZoneActuatorRequest(int zone) {
        try {
            if (!this.tempZones.isEmpty() && this.tempZones.get(zone) && !this.sendCommand("*#4*" + zone + "*19##")) {
                hsyco.errorLog("ioMonitor - Failed to retrieve status [" + this.serverName + "] - temperature actuator zone " + zone);
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private void tempZonesFanUI(String where, boolean fan) {
        try {
            int zone = Integer.parseInt(where);
            boolean set = this.tempZonesFanUISet.get(zone);
            boolean present = this.tempZonesFanUIPresent.get(zone);
            if (!set || set && fan ^ present) {
                this.tempZonesFanUIPresent.set(zone, fan);
                this.tempZonesFanUISet.set(zone);
                if (fan) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.button", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.group", "visible", "true");
                } else {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.group", "visible", "false");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String ioRead(int function, String id) {
        StringBuffer sb = new StringBuffer(this.functionToPrefix(function));
        int i2 = id.indexOf("#4#");
        if (i2 > 0) {
            sb.append('l');
            sb.append(id.substring(i2 + 3));
            sb.append('.');
            sb.append(id.substring(0, i2));
        } else {
            sb.append(id);
        }
        return this.states.get(sb.toString());
    }

    private boolean ioWrite(boolean events2, boolean forced, int function, String id, String value) {
        StringBuffer sb = new StringBuffer(this.functionToPrefix(function));
        int i2 = id.indexOf("#4#");
        if (i2 > 0) {
            sb.append('l');
            int j2 = id.indexOf(46, i2 + 3);
            if (j2 > 0) {
                sb.append(id.substring(i2 + 3, j2));
                sb.append('.');
                sb.append(id.substring(0, i2));
                sb.append('.');
                sb.append(id.substring(j2 + 1));
            } else {
                sb.append(id.substring(i2 + 3));
                sb.append('.');
                sb.append(id.substring(0, i2));
            }
        } else {
            sb.append(id);
        }
        String name = sb.toString();
        String fullname = String.valueOf(this.serverName) + "." + name;
        String state = this.states.get(name);
        if (state == null || !state.equals(value)) {
            this.states.put(name, value);
            if (this.discovery) {
                switch (function) {
                    case 1: {
                        if (SystemState.deviceFunctionGet(fullname) == 11) {
                            SystemState.deviceSet(false, 11, fullname, value, "");
                            break;
                        }
                        SystemState.deviceSet(false, 1, fullname, value, "");
                        break;
                    }
                    case 0: {
                        SystemState.deviceSet(false, 1, fullname, value, "");
                        break;
                    }
                    case 11: {
                        SystemState.deviceSet(false, 11, fullname, value, "DIMMER");
                        break;
                    }
                    case 2: {
                        SystemState.deviceSet(false, 2, fullname, value, "");
                        break;
                    }
                    case 9: {
                        SystemState.deviceSet(false, 1, fullname, value, "AUX");
                    }
                }
            }
            if (!events2) {
                SystemState.ioWriteNoEvents(fullname, value);
            } else if (forced) {
                SystemState.ioWriteForced(fullname, value);
            } else {
                SystemState.ioWrite(fullname, value);
            }
            return true;
        }
        if (forced) {
            SystemState.ioWriteForced(fullname, value);
            return false;
        }
        return false;
    }

    private String functionToPrefix(int function) {
        StringBuffer sb = new StringBuffer();
        switch (function) {
            case 1: 
            case 11: {
                sb.append("light.");
                break;
            }
            case 2: {
                sb.append("autom.");
                break;
            }
            case 0: {
                sb.append("scene.");
                break;
            }
            case 4: {
                sb.append("temp.");
                break;
            }
            case 9: {
                sb.append("aux.");
                break;
            }
            case 15: {
                sb.append("cen.");
                break;
            }
            case 25: {
                sb.append("cenplus.");
                break;
            }
            case 5: {
                sb.append("security.");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deviceStateWrite(boolean events2, OpenParser frame) {
        block244: {
            int monitorMode = 0;
            try {
                String monitorModeString = SystemState.ioGet(String.valueOf(this.serverName) + ".monitor");
                if (monitorModeString == null || "none".equalsIgnoreCase(monitorModeString)) {
                    monitorMode = 0;
                } else if ("ignored".equalsIgnoreCase(monitorModeString)) {
                    monitorMode = 1;
                } else if ("all".equalsIgnoreCase(monitorModeString)) {
                    monitorMode = 2;
                    this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                }
                block5 : switch (frame.getType()) {
                    case 1: {
                        AtomicInteger atomicInteger = this.commandStatus;
                        synchronized (atomicInteger) {
                            this.commandStatus.set(1);
                            this.commandStatus.notify();
                            break;
                        }
                    }
                    case 0: {
                        AtomicInteger atomicInteger = this.commandStatus;
                        synchronized (atomicInteger) {
                            this.commandStatus.set(0);
                            this.commandStatus.notify();
                            break;
                        }
                    }
                    case 7: {
                        this.commandNackReason = Integer.parseInt(frame.getWhat());
                        break;
                    }
                    case 2: {
                        if (frame.getWho().equals("0")) {
                            String what = frame.getWhat();
                            String where = frame.getWhere();
                            int i2 = what.indexOf(35);
                            if (i2 == -1) {
                                int whatn = Integer.parseInt(what);
                                if (whatn >= 1 && whatn <= 32) {
                                    this.ioWrite(events2, true, 0, String.valueOf(where) + "." + what, "1");
                                    this.scenesResetTime.put(String.valueOf(where) + "." + what, System.currentTimeMillis() + 30000L);
                                    break;
                                }
                                if (whatn == 42) {
                                    this.ioWrite(events2, true, -1, "scene." + where, "erase");
                                    break;
                                }
                                if (whatn == 43) {
                                    this.ioWrite(events2, true, -1, "scene." + where, "lock");
                                    break;
                                }
                                if (whatn == 44) {
                                    this.ioWrite(events2, true, -1, "scene." + where, "unlock");
                                    break;
                                }
                                if (whatn == 45) {
                                    this.ioWrite(events2, true, -1, "scene." + where, "unavailable");
                                    break;
                                }
                                if (whatn == 46) {
                                    this.ioWrite(events2, true, -1, "scene." + where, "full");
                                    break;
                                }
                                if (monitorMode == 1) {
                                    this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                                }
                            } else {
                                int whatl = Integer.parseInt(what.substring(0, i2));
                                int whatr = Integer.parseInt(what.substring(i2 + 1));
                                if (whatr == 0) {
                                    this.ioWrite(events2, true, 0, String.valueOf(where) + "." + whatl, "0");
                                    break;
                                }
                                if (whatl == 40) {
                                    this.ioWrite(events2, true, -1, "scene." + where + "." + whatr, "record");
                                    break;
                                }
                                if (whatl == 41) {
                                    this.ioWrite(events2, true, -1, "scene." + where + "." + whatr, "end");
                                    break;
                                }
                                if (whatl == 42) {
                                    this.ioWrite(events2, true, -1, "scene." + where + "." + whatr, "erase");
                                    break;
                                }
                                if (monitorMode == 1) {
                                    this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                                }
                            }
                            break;
                        }
                        if (frame.getWho().equals("1")) {
                            int what = Integer.parseInt(frame.getWhat());
                            String where = frame.getWhere();
                            if (where.charAt(0) == '#') {
                                where = "g" + where.substring(1);
                            }
                            if (what == 0 || what == 1) {
                                this.ioWrite(events2, false, 1, where, frame.getWhat());
                                break;
                            }
                            if (what >= 2 && what <= 10) {
                                this.ioWrite(events2, false, 11, where, String.valueOf(frame.getWhat()) + "0%");
                                break;
                            }
                            if (what == 19) {
                                this.ioWrite(events2, false, 11, where, "fault");
                                break;
                            }
                            if (monitorMode == 1) {
                                this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                            }
                            break;
                        }
                        if (frame.getWho().equals("2")) {
                            String where = frame.getWhere();
                            if (where.charAt(0) == '#') {
                                where = "g" + where.substring(1);
                            }
                            switch (Integer.parseInt(frame.getWhat())) {
                                case 0: {
                                    String state = this.ioRead(2, where);
                                    if (state == null) {
                                        this.ioWrite(events2, false, 2, where, "unknown");
                                        break;
                                    }
                                    if (state.equals("up")) {
                                        this.ioWrite(events2, false, 2, where, "offup");
                                        break;
                                    }
                                    if (state.equals("down")) {
                                        this.ioWrite(events2, false, 2, where, "offdown");
                                        break;
                                    }
                                    break block244;
                                }
                                case 1: {
                                    this.ioWrite(events2, false, 2, where, "up");
                                    break;
                                }
                                case 2: {
                                    this.ioWrite(events2, false, 2, where, "down");
                                    break;
                                }
                                default: {
                                    if (monitorMode == 1) {
                                        this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                                        break;
                                    }
                                    break block244;
                                }
                            }
                            break;
                        }
                        if (frame.getWho().equals("4")) {
                            String where = frame.getWhere();
                            String what = frame.getWhat();
                            if (where.equals(this.tempCentralUnitAddress == 0 ? "#0" : "#0#" + this.tempCentralUnitAddress)) {
                                if (what.equals("20")) {
                                    this.ioWrite(events2, false, 4, "control", "0");
                                    break;
                                }
                                if (what.equals("21")) {
                                    this.ioWrite(events2, false, 4, "control", "1");
                                    break;
                                }
                                if (what.equals("22")) {
                                    this.ioWrite(events2, true, 4, "zone.off", "1");
                                    break;
                                }
                                if (what.equals("23")) {
                                    this.ioWrite(events2, true, 4, "zone.protection", "1");
                                    break;
                                }
                                if (what.equals("24")) {
                                    this.ioWrite(events2, true, 4, "zone.manual", "1");
                                    break;
                                }
                                if (what.equals("30")) {
                                    this.ioWrite(events2, true, 4, "fault", "1");
                                    break;
                                }
                                if (what.equals("31")) {
                                    this.ioWrite(events2, true, 4, "battery.fault", "1");
                                    break;
                                }
                                if (what.equals("103")) {
                                    this.tempMode = 0;
                                    this.ioWrite(events2, false, 4, "mode", "winter");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "off");
                                    this.ioWrite(events2, false, 4, "setpoint", "off");
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.equals("203")) {
                                    this.tempMode = 1;
                                    this.ioWrite(events2, false, 4, "mode", "summer");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "off");
                                    this.ioWrite(events2, false, 4, "setpoint", "off");
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.equals("102")) {
                                    this.tempMode = 0;
                                    this.ioWrite(events2, false, 4, "mode", "winter");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "protection");
                                    this.ioWrite(events2, false, 4, "setpoint", "protection");
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.equals("202")) {
                                    this.tempMode = 1;
                                    this.ioWrite(events2, false, 4, "mode", "summer");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "protection");
                                    this.ioWrite(events2, false, 4, "setpoint", "protection");
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("110#")) {
                                    this.tempMode = 0;
                                    this.ioWrite(events2, false, 4, "mode", "winter");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "man");
                                    this.tempCentralUnitLastManualSetpoint = Integer.parseInt(what.substring(4));
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(this.tempCentralUnitLastManualSetpoint));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("210#")) {
                                    this.tempMode = 1;
                                    this.ioWrite(events2, false, 4, "mode", "summer");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "man");
                                    this.tempCentralUnitLastManualSetpoint = Integer.parseInt(what.substring(4));
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(this.tempCentralUnitLastManualSetpoint));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("110")) {
                                    this.tempMode = 0;
                                    this.ioWrite(events2, false, 4, "mode", "winter");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "auto");
                                    this.ioWrite(events2, false, 4, "setpoint", what.substring(3));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("210")) {
                                    this.tempMode = 1;
                                    this.ioWrite(events2, false, 4, "mode", "summer");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "auto");
                                    this.ioWrite(events2, false, 4, "setpoint", what.substring(3));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("12")) {
                                    this.tempMode = 0;
                                    this.ioWrite(events2, false, 4, "mode", "winter");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "scenario");
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(Integer.parseInt(what.substring(2))));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("22")) {
                                    this.tempMode = 1;
                                    this.ioWrite(events2, false, 4, "mode", "summer");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "scenario");
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(Integer.parseInt(what.substring(2))));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("13")) {
                                    this.tempMode = 0;
                                    this.ioWrite(events2, false, 4, "mode", "winter");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "away");
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(Integer.parseInt(what.substring(2))));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("23")) {
                                    this.tempMode = 1;
                                    this.ioWrite(events2, false, 4, "mode", "summer");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "away");
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(Integer.parseInt(what.substring(2))));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("115#")) {
                                    this.tempMode = 0;
                                    this.ioWrite(events2, false, 4, "mode", "winter");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "holiday");
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(Integer.parseInt(what.substring(4))));
                                    this.tempCentralUnitUIUpdate(null, null);
                                    break;
                                }
                                if (what.startsWith("215#")) {
                                    this.tempMode = 1;
                                    this.ioWrite(events2, false, 4, "mode", "summer");
                                    this.ioWrite(events2, false, 4, "setpoint.mode", "holiday");
                                    this.ioWrite(events2, false, 4, "setpoint", Integer.toString(Integer.parseInt(what.substring(4))));
                                    this.tempCentralUnitUIUpdate(null, null);
                                }
                            } else if (where.charAt(0) == '#') {
                                where = this.tempCentralUnitAddress == 0 ? where.substring(1) : where.substring(1, where.lastIndexOf("#" + this.tempCentralUnitAddress));
                                int z = Integer.parseInt(where);
                                int m2 = Integer.parseInt(frame.getWhat());
                                if (this.tempZonesStatus[z].cumode != m2) {
                                    this.tempZonesStatus[z].cumode = m2;
                                    this.tempZoneUpdate(events2, z, -1);
                                    this.tempZonesRefresh(z);
                                }
                            } else {
                                int z = Integer.parseInt(where);
                                int m3 = Integer.parseInt(frame.getWhat());
                                if (this.tempZonesStatus[z].mode != m3) {
                                    this.tempZonesStatus[z].mode = m3;
                                    this.tempZoneUpdate(events2, z, -1);
                                    this.tempZonesRefresh(z);
                                }
                            }
                            break;
                        }
                        if (frame.getWho().equals("5")) {
                            String where = frame.getWhere();
                            int what = Integer.parseInt(frame.getWhat());
                            switch (what) {
                                case 0: {
                                    if (this.ioWrite(events2, false, 5, "maintenance", "1")) {
                                        this.securityLog(TEXT[this.language][23]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.maintenance", "visible", "true");
                                        break;
                                    }
                                    break block244;
                                }
                                case 1: {
                                    this.ioWrite(events2, false, 5, "active", "1");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.active", "visible", "true");
                                    if (this.ioWrite(events2, false, 5, "maintenance", "0")) {
                                        this.securityLog(TEXT[this.language][0]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.maintenance", "visible", "false");
                                        break;
                                    }
                                    break block244;
                                }
                                case 2: {
                                    this.ioWrite(events2, false, 5, "active", "0");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.active", "visible", "false");
                                    break;
                                }
                                case 3: {
                                    this.ioWrite(events2, true, 5, "delay", "end");
                                    if (!this.securityDelayEndFlag) {
                                        this.securityDelayEndFlag = true;
                                        this.securityLog(TEXT[this.language][26]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 4: 
                                case 10: {
                                    if (this.ioWrite(events2, false, 5, "lowbattery", "1")) {
                                        this.securityLog(TEXT[this.language][27]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.lowbattery.label", "visible", "true");
                                        break;
                                    }
                                    break block244;
                                }
                                case 5: {
                                    if (this.ioWrite(events2, false, 5, "lowbattery", "0")) {
                                        this.securityLog(TEXT[this.language][28]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.lowbattery.label", "visible", "false");
                                        break;
                                    }
                                    break block244;
                                }
                                case 6: {
                                    if (this.ioWrite(events2, false, 5, "nopower", "1")) {
                                        this.securityLog(TEXT[this.language][29]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.acfault.label", "visible", "true");
                                        break;
                                    }
                                    break block244;
                                }
                                case 7: {
                                    if (this.ioWrite(events2, false, 5, "nopower", "0")) {
                                        this.securityLog(TEXT[this.language][30]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.acfault.label", "visible", "false");
                                        break;
                                    }
                                    break block244;
                                }
                                case 8: {
                                    this.securityDelayEndFlag = false;
                                    if (this.ioWrite(events2, false, 5, "status", "armed")) {
                                        this.securityLog(TEXT[this.language][24]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.armed", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status", "value", TEXT[this.language][24]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.intrusion", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.tamper", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.panic", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.aux", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", "");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", "");
                                        break;
                                    }
                                    break block244;
                                }
                                case 9: {
                                    if (this.ioWrite(events2, false, 5, "status", "off")) {
                                        this.securityLog(TEXT[this.language][25]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.armed", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status", "value", TEXT[this.language][25]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.intrusion", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.tamper", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.panic", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.aux", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", "");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", "");
                                    }
                                    this.ioWrite(events2, false, 5, "alarm", "0");
                                    this.securityAlarmsReset(events2);
                                    break;
                                }
                                case 26: {
                                    if (this.ioWrite(events2, false, 5, "programming", "1")) {
                                        this.securityLog(String.valueOf(TEXT[this.language][37]) + " " + TEXT[this.language][0]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 27: {
                                    if (this.ioWrite(events2, false, 5, "programming", "0")) {
                                        this.securityLog(String.valueOf(TEXT[this.language][37]) + " " + TEXT[this.language][1]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 11: {
                                    if (this.ioWrite(events2, false, 5, "zone." + where.substring(1) + ".active", "1")) {
                                        this.securityLog(String.valueOf(this.securityNames("zone." + where.substring(1))) + ": " + TEXT[this.language][0]);
                                        this.securityZonesModeUI();
                                        break;
                                    }
                                    break block244;
                                }
                                case 12: {
                                    this.securityAlarms.add("aux." + where.substring(1) + ".alarm");
                                    if (this.ioWrite(events2, true, 5, "aux." + where.substring(1) + ".alarm", "1")) {
                                        this.securityLog(String.valueOf(this.securityNames("aux." + where.substring(1))) + ": " + TEXT[this.language][34]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.aux", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", TEXT[this.language][34]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", TEXT[this.language][38]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 13: {
                                    if (this.ioWrite(events2, false, 5, "aux." + where.substring(1) + ".alarm", "0")) {
                                        this.securityLog(String.valueOf(this.securityNames("aux." + where.substring(1))) + ": " + TEXT[this.language][34] + " " + TEXT[this.language][1]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.aux", "visible", "false");
                                        break;
                                    }
                                    break block244;
                                }
                                case 14: {
                                    if (this.ioWrite(events2, true, 5, "sensor." + where + ".fault", "1")) {
                                        this.securityLog(String.valueOf(this.securityNames("sensor." + where)) + ": " + TEXT[this.language][7]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 15: {
                                    this.ioWrite(events2, false, 5, "alarm", "1");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.intrusion", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", TEXT[this.language][34]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", "");
                                    this.securityAlarms.add("zone." + where.substring(1) + ".alarm");
                                    if (this.ioWrite(events2, false, 5, "zone." + where.substring(1) + ".alarm", "1")) {
                                        this.securityLog(String.valueOf(this.securityNames("zone." + where.substring(1))) + ": " + TEXT[this.language][34]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 16: {
                                    this.ioWrite(events2, false, 5, "alarm", "1");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.tamper", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", TEXT[this.language][34]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", TEXT[this.language][35]);
                                    this.securityAlarms.add("zone." + where.substring(1) + ".tamper");
                                    if (this.ioWrite(events2, false, 5, "zone." + where.substring(1) + ".tamper", "1")) {
                                        this.securityLog(String.valueOf(this.securityNames("zone." + where.substring(1))) + ": " + TEXT[this.language][35]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 17: {
                                    this.ioWrite(events2, false, 5, "alarm", "1");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.panic", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", TEXT[this.language][34]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", TEXT[this.language][36]);
                                    this.securityAlarms.add("zone." + where.substring(1) + ".panic");
                                    if (this.ioWrite(events2, false, 5, "zone." + where.substring(1) + ".panic", "1")) {
                                        this.securityLog(String.valueOf(this.securityNames("zone." + where.substring(1))) + ": " + TEXT[this.language][36]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 18: {
                                    if (this.ioWrite(events2, false, 5, "zone." + where.substring(1) + ".active", "0")) {
                                        this.securityLog(String.valueOf(this.securityNames("zone." + where.substring(1))) + ": " + TEXT[this.language][1]);
                                        this.securityZonesModeUI();
                                        break;
                                    }
                                    break block244;
                                }
                                case 31: {
                                    if (this.ioWrite(events2, false, 5, "aux." + where.substring(1) + ".active", "1")) {
                                        this.securityLog(String.valueOf(this.securityNames("aux." + where.substring(1))) + ": " + TEXT[this.language][34]);
                                        break;
                                    }
                                    break block244;
                                }
                                default: {
                                    if (monitorMode == 1) {
                                        this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                                        break;
                                    }
                                    break block244;
                                }
                            }
                            break;
                        }
                        if (frame.getWho().equals("9")) {
                            this.ioWrite(events2, true, 9, frame.getWhere(), frame.getWhat());
                            break;
                        }
                        if (frame.getWho().equals("15")) {
                            String what = frame.getWhat();
                            String where = frame.getWhere();
                            int i3 = what.indexOf(35);
                            if (i3 == -1) {
                                this.ioWrite(events2, true, 15, String.valueOf(where) + "." + what, "on");
                                break;
                            }
                            String whatl = what.substring(0, i3);
                            String whatr = what.substring(i3 + 1);
                            if (whatr.equals("1")) {
                                this.ioWrite(events2, true, 15, String.valueOf(where) + "." + whatl, "off");
                                break;
                            }
                            if (whatr.equals("2")) {
                                this.ioWrite(events2, true, 15, String.valueOf(where) + "." + whatl, "offlong");
                                break;
                            }
                            if (whatr.equals("3")) {
                                this.ioWrite(events2, true, 15, String.valueOf(where) + "." + whatl, "onrepeat");
                            }
                        } else if (frame.getWho().equals("25")) {
                            String what = frame.getWhat();
                            String where = frame.getWhere();
                            int i4 = what.indexOf(35);
                            if (i4 != -1) {
                                String whatl = what.substring(0, i4);
                                String whatr = what.substring(i4 + 1);
                                if (whatl.equals("21")) {
                                    this.ioWrite(events2, true, 25, String.valueOf(where) + "." + whatr, "on");
                                    break;
                                }
                                if (whatl.equals("22")) {
                                    this.ioWrite(events2, true, 25, String.valueOf(where) + "." + whatr, "onlong");
                                    break;
                                }
                                if (whatl.equals("23")) {
                                    this.ioWrite(events2, true, 25, String.valueOf(where) + "." + whatr, "onrepeat");
                                    break;
                                }
                                if (whatl.equals("24")) {
                                    this.ioWrite(events2, true, 25, String.valueOf(where) + "." + whatr, "offlong");
                                    break;
                                }
                                if (whatl.equals("31")) {
                                    this.ioWrite(events2, whatr.equals("1"), 25, where, "on");
                                    break;
                                }
                                if (whatl.equals("32")) {
                                    this.ioWrite(events2, whatr.equals("1"), 25, where, "off");
                                }
                            }
                        } else if (monitorMode == 1) {
                            this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                        }
                        break;
                    }
                    case 3: {
                        if (frame.getWho().equals("5")) {
                            int where = Integer.parseInt(frame.getWhere());
                            switch (where) {
                                case 0: {
                                    if (this.ioWrite(events2, false, 5, "maintenance", "1")) {
                                        this.securityLog(TEXT[this.language][23]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.maintenance", "visible", "true");
                                        break;
                                    }
                                    break block244;
                                }
                                case 1: {
                                    this.ioWrite(events2, false, 5, "active", "1");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.active", "visible", "true");
                                    if (this.ioWrite(events2, false, 5, "maintenance", "0")) {
                                        this.securityLog(TEXT[this.language][0]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.maintenance", "visible", "false");
                                        break;
                                    }
                                    break block244;
                                }
                                case 2: {
                                    this.ioWrite(events2, false, 5, "active", "0");
                                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.active", "visible", "false");
                                    break;
                                }
                                case 3: {
                                    this.ioWrite(events2, true, 5, "delay", "end");
                                    if (!this.securityDelayEndFlag) {
                                        this.securityDelayEndFlag = true;
                                        this.securityLog(TEXT[this.language][26]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 4: 
                                case 10: {
                                    if (this.ioWrite(events2, false, 5, "lowbattery", "1")) {
                                        this.securityLog(TEXT[this.language][27]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.lowbattery.label", "visible", "true");
                                        break;
                                    }
                                    break block244;
                                }
                                case 5: {
                                    if (this.ioWrite(events2, false, 5, "lowbattery", "0")) {
                                        this.securityLog(TEXT[this.language][28]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.lowbattery.label", "visible", "false");
                                        break;
                                    }
                                    break block244;
                                }
                                case 6: {
                                    if (this.ioWrite(events2, false, 5, "nopower", "1")) {
                                        this.securityLog(TEXT[this.language][29]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.acfault.label", "visible", "true");
                                        break;
                                    }
                                    break block244;
                                }
                                case 7: {
                                    if (this.ioWrite(events2, false, 5, "nopower", "0")) {
                                        this.securityLog(TEXT[this.language][30]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.acfault.label", "visible", "false");
                                        break;
                                    }
                                    break block244;
                                }
                                case 8: {
                                    this.securityDelayEndFlag = false;
                                    if (this.ioWrite(events2, false, 5, "status", "armed")) {
                                        this.securityLog(TEXT[this.language][24]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.armed", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status", "value", TEXT[this.language][24]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.intrusion", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.tamper", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.panic", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.aux", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", "");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", "");
                                        break;
                                    }
                                    break block244;
                                }
                                case 9: {
                                    if (this.ioWrite(events2, false, 5, "status", "off")) {
                                        this.securityLog(TEXT[this.language][25]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status.label.armed", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.status", "value", TEXT[this.language][25]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.intrusion", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.tamper", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.panic", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.label.aux", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm", "value", "");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".security.alarm.type", "value", "");
                                    }
                                    this.ioWrite(events2, false, 5, "alarm", "0");
                                    this.securityAlarmsReset(events2);
                                    break;
                                }
                                case 26: {
                                    if (this.ioWrite(events2, false, 5, "programming", "1")) {
                                        this.securityLog(String.valueOf(TEXT[this.language][37]) + " " + TEXT[this.language][0]);
                                        break;
                                    }
                                    break block244;
                                }
                                case 27: {
                                    if (this.ioWrite(events2, false, 5, "programming", "0")) {
                                        this.securityLog(String.valueOf(TEXT[this.language][37]) + " " + TEXT[this.language][1]);
                                        break;
                                    }
                                    break block244;
                                }
                                default: {
                                    if (monitorMode == 1) {
                                        this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                                        break;
                                    }
                                    break block244;
                                }
                            }
                            break;
                        }
                        if (monitorMode == 1) {
                            this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                        }
                        break;
                    }
                    case 4: {
                        if (monitorMode == 1) {
                            this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                        }
                        break;
                    }
                    case 6: {
                        if (frame.getWho().equals("4")) {
                            String where = frame.getWhere();
                            String[] vals = frame.getVals();
                            if ("0".equals(vals[0])) {
                                String t = vals[1].substring(vals[1].charAt(1) == '0' ? 2 : 1);
                                if (where.length() == 3) {
                                    int zone = Integer.parseInt(where.substring(1, 3));
                                    if (this.ioWrite(events2, false, 4, String.valueOf(zone) + "." + where.substring(0, 1) + ".temp", t)) {
                                        this.tempZonesRefresh(zone);
                                    }
                                } else {
                                    int zone = Integer.parseInt(where);
                                    this.tempZonesStatus[zone].temp = Integer.parseInt(t);
                                    if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".temp", t)) {
                                        this.tempZonesRefresh(zone);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".temp", "value", String.valueOf((double)Integer.parseInt(t) / 10.0) + " &deg;C");
                                    }
                                }
                                break;
                            }
                            if ("12".equals(vals[0])) {
                                int z = Integer.parseInt(where);
                                int t = Integer.parseInt(vals[1]);
                                if (this.tempZonesStatus[z].set12 != t) {
                                    this.tempZonesStatus[z].set12 = t;
                                    this.tempZoneUpdate(events2, z, 12);
                                    this.tempZonesRefresh(z);
                                }
                                break;
                            }
                            if ("13".equals(vals[0])) {
                                int z = Integer.parseInt(where);
                                int m4 = Integer.parseInt(vals[1]);
                                if (this.tempZonesStatus[z].set13 != m4) {
                                    if (m4 == 4 || m4 == 5) {
                                        this.ioWrite(true, true, 4, Integer.toString(z), "lock");
                                    }
                                    this.tempZonesStatus[z].set13 = m4;
                                    this.tempZoneUpdate(events2, z, 13);
                                    this.tempZonesRefresh(z);
                                }
                                break;
                            }
                            if ("14".equals(vals[0])) {
                                int z = Integer.parseInt(where);
                                int t = Integer.parseInt(vals[1]);
                                if (this.tempZonesStatus[z].set14 != t) {
                                    this.tempZonesStatus[z].set14 = t;
                                    this.tempZoneUpdate(events2, z, 14);
                                    this.tempZonesRefresh(z);
                                }
                                break;
                            }
                            if ("19".equals(vals[0])) {
                                int cstatus = -1;
                                int hstatus = -1;
                                switch (Integer.parseInt(vals[1])) {
                                    case 0: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "0")) break;
                                        cstatus = 0;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 1: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "1")) break;
                                        cstatus = 1;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 2: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "opening")) break;
                                        cstatus = 1;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 3: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "closing")) break;
                                        cstatus = 0;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 4: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "stop")) break;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 5: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "0")) {
                                            cstatus = 0;
                                        }
                                        if (!"summer".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "off")) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][1]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "false");
                                        break;
                                    }
                                    case 6: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "1")) {
                                            cstatus = 1;
                                        }
                                        if (!"summer".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "min")) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][8]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "false");
                                        break;
                                    }
                                    case 7: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "1")) {
                                            cstatus = 1;
                                        }
                                        if (!"summer".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "med")) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][9]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "false");
                                        break;
                                    }
                                    case 8: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".cooling.status", "1")) {
                                            cstatus = 1;
                                        }
                                        if (!"summer".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "max")) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][10]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "true");
                                    }
                                }
                                switch (Integer.parseInt(vals[2])) {
                                    case 0: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "0")) break;
                                        hstatus = 0;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 1: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "1")) break;
                                        hstatus = 1;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 2: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "opening")) break;
                                        hstatus = 1;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 3: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "closing")) break;
                                        hstatus = 0;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 4: {
                                        if (!this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "stop")) break;
                                        this.tempZonesFanUI(where, false);
                                        break;
                                    }
                                    case 5: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "0")) {
                                            hstatus = 0;
                                        }
                                        if (!"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "off") || !"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][1]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "false");
                                        break;
                                    }
                                    case 6: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "1")) {
                                            hstatus = 1;
                                        }
                                        if (!"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "min") || !"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][8]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "false");
                                        break;
                                    }
                                    case 7: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "1")) {
                                            hstatus = 1;
                                        }
                                        if (!"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "med") || !"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][9]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "false");
                                        break;
                                    }
                                    case 8: {
                                        if (this.ioWrite(events2, false, 4, String.valueOf(where) + ".heating.status", "1")) {
                                            hstatus = 1;
                                        }
                                        if (!"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode")) || !this.ioWrite(events2, false, 4, String.valueOf(where) + ".fan", "max") || !"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) break;
                                        this.tempZonesFanUI(where, true);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan", "value", TEXT[this.language][10]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.min", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.med", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".fan.label.max", "visible", "true");
                                    }
                                }
                                switch (cstatus) {
                                    case 0: {
                                        if (!"summer".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) break;
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status", "value", TEXT[this.language][1]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.off", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.heating", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.cooling", "visible", "false");
                                        break;
                                    }
                                    case 1: {
                                        if (!"summer".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) break;
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status", "value", TEXT[this.language][0]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.off", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.heating", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.cooling", "visible", "true");
                                    }
                                }
                                switch (hstatus) {
                                    case 0: {
                                        if ("winter".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) {
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status", "value", TEXT[this.language][1]);
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.off", "visible", "true");
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.heating", "visible", "false");
                                            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.cooling", "visible", "false");
                                            break;
                                        }
                                        break block244;
                                    }
                                    case 1: {
                                        if (!"winter".equals(this.ioRead(4, String.valueOf(where) + ".mode"))) break block244;
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status", "value", TEXT[this.language][0]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.off", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.heating", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + where + ".status.label.cooling", "visible", "false");
                                    }
                                    default: {
                                        break;
                                    }
                                }
                                break;
                            }
                            if (monitorMode == 1) {
                                this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                            }
                            break;
                        }
                        if (frame.getWho().equals("3")) {
                            if (frame.getWhere().equals("10")) {
                                String[] vals = frame.getVals();
                                switch (Integer.parseInt(vals[0])) {
                                    case 1: {
                                        this.ioWrite(events2, true, -1, "load.voltage", vals[1]);
                                        break block5;
                                    }
                                    case 2: {
                                        this.ioWrite(events2, true, -1, "load.current", vals[1]);
                                        break block5;
                                    }
                                    case 3: {
                                        this.ioWrite(events2, true, -1, "load.power", vals[1]);
                                        break block5;
                                    }
                                    case 4: {
                                        this.ioWrite(events2, true, -1, "load.energy", vals[1]);
                                    }
                                }
                            }
                        } else if (frame.getWho().equals("13")) {
                            String[] vals = frame.getVals();
                            if (vals != null && vals[0].equals("22")) {
                                Calendar cal = Calendar.getInstance();
                                cal.clear();
                                cal.set(Integer.parseInt(vals[8]), Integer.parseInt(vals[7]) - 1, Integer.parseInt(vals[6]), Integer.parseInt(vals[1]), Integer.parseInt(vals[2]), Integer.parseInt(vals[3]));
                                this.ioWrite(events2, false, -1, "clock", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cal.getTime()));
                                this.ioWrite(events2, false, -1, "clock.delta", Long.toString((cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L));
                                break;
                            }
                            if (vals != null && vals[0].equals("16")) {
                                hsyco.messageLog("ioMonitor - L4686SDK firmware version: " + vals[1] + "." + vals[2] + "." + vals[3] + " [" + this.serverName + "]");
                            }
                        } else if (monitorMode == 1) {
                            this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                        }
                        break;
                    }
                    default: {
                        if (monitorMode == 1) {
                            this.ioWrite(events2, true, -1, "frame", frame.getFrame());
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void tempCentralUnitUIUpdate(String forcedSetpointMode, String forcedSetpoint) {
        String setpoint;
        String setpointmode;
        StringBuffer sb = new StringBuffer();
        boolean forced = false;
        String mode = this.ioRead(4, "mode");
        if (forcedSetpointMode != null) {
            setpointmode = forcedSetpointMode;
            setpoint = forcedSetpoint;
            forced = true;
        } else if (forcedSetpoint != null) {
            setpointmode = "man";
            setpoint = forcedSetpoint;
            forced = true;
        } else {
            setpointmode = this.ioRead(4, "setpoint.mode");
            setpoint = this.ioRead(4, "setpoint");
        }
        if ("summer".equals(mode)) {
            sb.append(TEXT[this.language][2]);
            sb.append(' ');
        } else if ("winter".equals(mode)) {
            sb.append(TEXT[this.language][3]);
            sb.append(' ');
        }
        if ("off".equals(setpointmode)) {
            sb.append(TEXT[this.language][1]);
        } else if ("protection".equals(setpointmode)) {
            sb.append(TEXT[this.language][6]);
        } else if ("man".equals(setpointmode)) {
            sb.append(TEXT[this.language][5]);
            sb.append(' ');
            sb.append((double)Integer.parseInt(setpoint) / 10.0);
            sb.append(" &deg;C");
        } else if ("auto".equals(setpointmode)) {
            sb.append(TEXT[this.language][22]);
            sb.append(' ');
            sb.append(setpoint);
        } else if ("scenario".equals(setpointmode)) {
            sb.append(TEXT[this.language][18]);
            sb.append(' ');
            sb.append(setpoint);
        } else if ("away".equals(setpointmode)) {
            sb.append(TEXT[this.language][19]);
            sb.append(' ');
            sb.append(setpoint);
            sb.append(' ');
            sb.append(TEXT[this.language][21]);
        } else if ("holiday".equals(setpointmode)) {
            sb.append(TEXT[this.language][20]);
            if (!setpoint.equals("1")) {
                sb.append(' ');
                sb.append(setpoint);
            }
        }
        if (forced) {
            sb.append(" *");
        }
        SystemState.uiSet(String.valueOf(this.serverName) + ".temp.status", "value", sb.toString());
    }

    private void tempZoneUpdate(boolean events2, int zone, int what) {
        boolean setpointValidity = true;
        boolean setpointForcedLocally = false;
        String humanSetpoint = "";
        int mode = this.tempMode;
        if (what == 12) {
            switch (this.tempZonesStatus[zone].set13) {
                case 0: 
                case 4: 
                case 5: {
                    this.tempZonesStatus[zone].set14 = this.tempZonesStatus[zone].set12;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.tempZonesStatus[zone].set14 = this.tempZonesStatus[zone].set12 - 10 * this.tempZonesStatus[zone].set13;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.tempZonesStatus[zone].set14 = this.tempZonesStatus[zone].set12 + 10 * (this.tempZonesStatus[zone].set13 - 10);
                }
            }
        }
        switch (this.tempZonesStatus[zone].set13) {
            case 4: {
                if ("unlock".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + zone))) {
                    this.tempZonesStatus[zone].set13 = 0;
                    break;
                }
                setpointForcedLocally = true;
                if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.local", "off")) break;
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", TEXT[this.language][1]);
                break;
            }
            case 5: {
                if ("unlock".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + zone))) {
                    this.tempZonesStatus[zone].set13 = 0;
                    break;
                }
                setpointForcedLocally = true;
                if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.local", "protection")) break;
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", TEXT[this.language][6]);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.local", Integer.toString(this.tempZonesStatus[zone].set13));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.local", "-" + (this.tempZonesStatus[zone].set13 - 10));
            }
        }
        switch (this.tempZonesStatus[zone].mode) {
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 0;
                break;
            }
            case 102: {
                mode = 0;
                setpointValidity = false;
                this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "protection");
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][6]);
                break;
            }
            case 202: {
                mode = 1;
                setpointValidity = false;
                this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "protection");
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][6]);
            }
        }
        if (setpointValidity) {
            switch (this.tempZonesStatus[zone].cumode) {
                case 110: {
                    mode = 0;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "man")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][5]);
                    break;
                }
                case 210: {
                    mode = 1;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "man")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][5]);
                    break;
                }
                case 111: {
                    mode = 0;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "auto")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][4]);
                    break;
                }
                case 211: {
                    mode = 1;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "auto")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][4]);
                    break;
                }
                case 103: {
                    setpointValidity = false;
                    mode = 0;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "off")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][1]);
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", "");
                    break;
                }
                case 203: {
                    setpointValidity = false;
                    mode = 1;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "off")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][1]);
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", "");
                    break;
                }
                case 303: {
                    setpointValidity = false;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "off")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][1]);
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", "");
                    break;
                }
                case 102: {
                    setpointValidity = false;
                    mode = 0;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "protection")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][6]);
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", "");
                    break;
                }
                case 202: {
                    setpointValidity = false;
                    mode = 1;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "protection")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][6]);
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", "");
                    break;
                }
                case 302: {
                    setpointValidity = false;
                    if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint.mode", "off")) break;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.mode", "value", TEXT[this.language][1]);
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", "");
                }
            }
        }
        switch (mode) {
            case 0: {
                if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".mode", "winter")) break;
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".mode", "value", TEXT[this.language][3]);
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".mode.label.summer", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".mode.label.winter", "visible", "true");
                break;
            }
            case 1: {
                if (!this.ioWrite(events2, false, 4, String.valueOf(zone) + ".mode", "summer")) break;
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".mode", "value", TEXT[this.language][2]);
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".mode.label.summer", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".mode.label.winter", "visible", "false");
            }
        }
        if (setpointValidity) {
            if (this.tempZonesStatus[zone].set14 != -1 && this.tempZonesStatus[zone].set13 != -1) {
                switch (this.tempZonesStatus[zone].set13) {
                    case 0: {
                        humanSetpoint = String.valueOf((double)this.tempZonesStatus[zone].set14 / 10.0) + " &deg;C";
                        this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint", Integer.toString(this.tempZonesStatus[zone].set14));
                        break;
                    }
                    case 1: {
                        humanSetpoint = String.valueOf((double)this.tempZonesStatus[zone].set14 / 10.0) + "+1 &deg;C";
                        this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint", Integer.toString(this.tempZonesStatus[zone].set14 + 10));
                        break;
                    }
                    case 11: {
                        humanSetpoint = String.valueOf((double)this.tempZonesStatus[zone].set14 / 10.0) + "-1 &deg;C";
                        this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint", Integer.toString(this.tempZonesStatus[zone].set14 - 10));
                        break;
                    }
                    case 2: {
                        humanSetpoint = String.valueOf((double)this.tempZonesStatus[zone].set14 / 10.0) + "+2 &deg;C";
                        this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint", Integer.toString(this.tempZonesStatus[zone].set14 + 20));
                        break;
                    }
                    case 12: {
                        humanSetpoint = String.valueOf((double)this.tempZonesStatus[zone].set14 / 10.0) + "-2 &deg;C";
                        this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint", Integer.toString(this.tempZonesStatus[zone].set14 - 20));
                        break;
                    }
                    case 3: {
                        humanSetpoint = String.valueOf((double)this.tempZonesStatus[zone].set14 / 10.0) + "+3 &deg;C";
                        this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint", Integer.toString(this.tempZonesStatus[zone].set14 + 30));
                        break;
                    }
                    case 13: {
                        humanSetpoint = String.valueOf((double)this.tempZonesStatus[zone].set14 / 10.0) + "-3 &deg;C";
                        this.ioWrite(events2, false, 4, String.valueOf(zone) + ".setpoint", Integer.toString(this.tempZonesStatus[zone].set14 - 30));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (!humanSetpoint.equals(SystemState.uiGet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value"))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", humanSetpoint);
                }
            }
        } else if (!setpointForcedLocally) {
            SystemState.uiSet(String.valueOf(this.serverName) + ".temp." + zone + ".setpoint.temp", "value", "");
        }
    }

    private void tempZonesRefresh(int zone) {
        this.tempZonesStatus[zone].refreshtime = System.currentTimeMillis() + 15000L;
    }

    void securityAlarmsReset(boolean events2) {
        for (String key : this.securityAlarms) {
            if (!"1".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".security." + key))) continue;
            this.ioWrite(events2, false, 5, key, "0");
        }
    }

    void securityZonesModeUI() {
        StringBuffer sb = new StringBuffer();
        int z = 1;
        while (z <= 8) {
            if ("1".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".security.zone." + z + ".active"))) {
                sb.append(z);
            } else {
                sb.append('-');
            }
            ++z;
        }
        SystemState.uiSet(String.valueOf(this.serverName) + ".security.zones", "value", sb.toString());
    }

    void securityLog(String message) {
        SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd/MM HH:mm");
        if (this.online) {
            hsyco.securityLog(String.valueOf(this.serverName) + " - " + message);
            int i2 = 20;
            while (i2 >= 2) {
                try {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".security.log." + i2, "value", SystemState.uiGet(String.valueOf(this.serverName) + ".security.log." + (i2 - 1), "value"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i2;
            }
            SystemState.uiSet(String.valueOf(this.serverName) + ".security.log.1", "value", String.valueOf(displayDateFormat.format(System.currentTimeMillis()).toUpperCase()) + " " + message);
        }
    }

    String securityNames(String key) {
        try {
            String name;
            File f2 = new File("myhome.ini");
            long t = f2.lastModified();
            if (t != 0L && t != this.myHomeFileLastModified) {
                this.myHomeFileProperties.clear();
                FileInputStream fis = new FileInputStream(f2);
                this.myHomeFileProperties.load(fis);
                fis.close();
                this.myHomeFileLastModified = t;
            }
            if ((name = this.myHomeFileProperties.getProperty(String.valueOf(this.serverName) + ".security." + key + ".name")) != null) {
                return name.toUpperCase();
            }
        }
        catch (Exception f2) {
            // empty catch block
        }
        String[] sa = key.split("\\.");
        StringBuffer sb = new StringBuffer();
        if (sa[0].equals("zone")) {
            sb.append(TEXT[this.language][31]);
            sb.append(' ');
            sb.append(sa[1]);
        } else if (sa[0].equals("aux")) {
            sb.append(TEXT[this.language][32]);
            sb.append(' ');
            sb.append(sa[1]);
        } else if (sa[0].equals("sensor")) {
            sb.append(TEXT[this.language][33]);
            sb.append(' ');
            sb.append(sa[1]);
        } else {
            sb.append(sa[0]);
            sb.append(' ');
            sb.append(sa[1]);
        }
        return sb.toString().toUpperCase();
    }

    private class CommandDispatcher
    extends Thread {
        private long heartbeat = System.currentTimeMillis();
        private boolean quit = false;
        private static final int POLL_INTERVAL = 10000;

        @Override
        public void run() {
            String cmd = null;
            hsyco.messageLog("ioCommandDispatcher - started [" + MyHomeSDK.this.serverName + "]");
            try {
                while (!this.quit) {
                    long now;
                    cmd = (String)MyHomeSDK.this.ioqtx.poll(10000L, TimeUnit.MILLISECONDS);
                    if (cmd != null) {
                        int counter = 0;
                        do {
                            this.heartbeat = now = System.currentTimeMillis();
                            int eq = cmd.indexOf(61);
                            boolean ret = MyHomeSDK.this.commandExecutor(cmd.substring(0, eq), cmd.substring(eq + 1));
                            if (Configuration.verboseLog) {
                                if (ret) {
                                    hsyco.messageLog("ioCommandDispatcher - " + cmd + " [" + MyHomeSDK.this.serverName + "] - executed in " + (System.currentTimeMillis() - now) + "ms");
                                } else {
                                    hsyco.messageLog("ioCommandDispatcher - " + cmd + " [" + MyHomeSDK.this.serverName + "] - failed in " + (System.currentTimeMillis() - now) + "ms");
                                }
                            }
                            Thread.sleep(100L);
                        } while (counter++ < 10 && (cmd = (String)MyHomeSDK.this.ioqtx.poll()) != null);
                    }
                    this.heartbeat = now = System.currentTimeMillis();
                    if (MyHomeSDK.this.tempZones.length() <= 0) continue;
                    if (MyHomeSDK.this.tempCentralUnitLastManualSetpoint > 0 && MyHomeSDK.this.tempCentralUnitLastManualSetpointTime < now) {
                        SystemState.ioSet(String.valueOf(MyHomeSDK.this.serverName) + ".temp.command", Integer.toString(MyHomeSDK.this.tempCentralUnitLastManualSetpoint));
                        MyHomeSDK.this.tempCentralUnitLastManualSetpoint = -MyHomeSDK.this.tempCentralUnitLastManualSetpoint;
                    }
                    if (MyHomeSDK.this.tempCentralUnitLastAwaySetpoint > 0 && MyHomeSDK.this.tempCentralUnitLastAwaySetpointTime < now) {
                        SystemState.ioSet(String.valueOf(MyHomeSDK.this.serverName) + ".temp.command", "away." + MyHomeSDK.this.tempCentralUnitLastAwaySetpoint);
                        MyHomeSDK.this.tempCentralUnitLastAwaySetpoint = -MyHomeSDK.this.tempCentralUnitLastAwaySetpoint;
                    }
                    int i2 = 1;
                    while (i2 < MyHomeSDK.this.tempZonesStatus.length) {
                        if (MyHomeSDK.this.tempZonesStatus[i2] != null && ((MyHomeSDK)MyHomeSDK.this).tempZonesStatus[i2].tempman != -1 && ((MyHomeSDK)MyHomeSDK.this).tempZonesStatus[i2].tempmants < now) {
                            SystemState.ioSet(String.valueOf(MyHomeSDK.this.serverName) + ".temp." + i2 + ".setpoint", Integer.toString(((MyHomeSDK)MyHomeSDK.this).tempZonesStatus[i2].tempman));
                            ((MyHomeSDK)MyHomeSDK.this).tempZonesStatus[i2].tempman = -1;
                        }
                        ++i2;
                    }
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioCommandDispatcher - Exception in thread loop [" + MyHomeSDK.this.serverName + "] - " + e2.getLocalizedMessage());
            }
            hsyco.errorLog("ioCommandDispatcher - quit [" + MyHomeSDK.this.serverName + "]");
            MyHomeSDK.this.me.quit = true;
        }
    }

    class OpenBufferedReader
    extends BufferedReader {
        public OpenBufferedReader(Reader in, int sz) {
            super(in, sz);
        }

        public OpenBufferedReader(Reader in) {
            super(in);
        }

        public String readOpenFrame() throws IOException {
            String openFrame = "";
            boolean endOfFrame = false;
            try {
                int ch;
                while ((ch = this.read()) != -1) {
                    char c2;
                    if (ch == 35) {
                        ch = this.read();
                        if (ch == -1) break;
                        if (ch == 35) {
                            openFrame = String.valueOf(openFrame) + "##";
                            endOfFrame = true;
                            break;
                        }
                        openFrame = String.valueOf(openFrame) + "#";
                        c2 = (char)ch;
                        openFrame = String.valueOf(openFrame) + Character.toString(c2);
                        continue;
                    }
                    c2 = (char)ch;
                    openFrame = String.valueOf(openFrame) + Character.toString(c2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (endOfFrame) {
                if (Configuration.verboseLog) {
                    hsyco.messageLog("ioMonitor - frame: " + openFrame + " [" + MyHomeSDK.this.serverName + "]");
                }
                return openFrame;
            }
            return null;
        }

        @Override
        public String readLine() throws IOException {
            return this.readOpenFrame();
        }

        public void flush() {
            try {
                while (this.read() != -1) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class OpenParser {
        private static final int TYPE_NACK = 0;
        private static final int TYPE_ACK = 1;
        private static final int TYPE_IDENTIFICATION_REQUEST = 100;
        private static final int TYPE_STANDARD = 2;
        private static final int TYPE_STATUS_REQUEST = 3;
        private static final int TYPE_DIMENSION_REQUEST = 4;
        private static final int TYPE_GENERIC = 5;
        private static final int TYPE_GENERIC_EXTENDED = 6;
        private static final int TYPE_NACK_REASON = 7;
        private String frame;
        private int type;
        private String who;
        private String what;
        private String where;
        private String dimension;
        private String[] vals;

        String getFrame() {
            return this.frame;
        }

        int getType() {
            return this.type;
        }

        String getWho() {
            return this.who;
        }

        String getWhat() {
            return this.what;
        }

        String getWhere() {
            return this.where;
        }

        String getDimension() {
            return this.dimension;
        }

        String[] getVals() {
            return this.vals;
        }

        boolean isNull() {
            return this.frame == null;
        }

        boolean isData() {
            return this.frame != null && this.type != 1 && this.type != 0;
        }

        OpenParser(String frame) {
            block15: {
                this.type = -1;
                this.who = null;
                this.what = null;
                this.where = null;
                this.dimension = null;
                this.vals = null;
                try {
                    this.frame = new String(frame);
                    int framelength = frame.length();
                    if (frame.charAt(0) != '*' || frame.charAt(framelength - 2) != '#' || frame.charAt(framelength - 1) != '#') break block15;
                    String[] frametags = frame.substring(1, framelength - 2).split("\\*");
                    switch (frametags.length) {
                        case 1: {
                            if (frametags[0].charAt(0) == '#') {
                                Integer.parseInt(frametags[0].substring(1));
                                this.type = 100;
                                break;
                            }
                            return;
                        }
                        case 2: {
                            if (frametags[0].equals("#")) {
                                if (frametags[1].equals("1")) {
                                    this.type = 1;
                                    break;
                                }
                                if (frametags[1].equals("0")) {
                                    this.type = 0;
                                    break;
                                }
                                this.type = 7;
                                this.what = frametags[1];
                                break;
                            }
                            this.type = 3;
                            this.who = frametags[0];
                            this.where = frametags[1];
                            break;
                        }
                        case 3: {
                            if (frametags[0].charAt(0) == '#') {
                                this.type = 4;
                                this.who = frametags[0].substring(1);
                                this.where = frametags[1];
                                this.dimension = frametags[2];
                                break;
                            }
                            this.type = 2;
                            this.who = frametags[0];
                            this.what = frametags[1];
                            this.where = frametags[2];
                            break;
                        }
                        default: {
                            if (frametags[0].charAt(0) == '#') {
                                this.type = 6;
                                this.who = frametags[0].substring(1);
                            } else {
                                this.type = 5;
                                this.who = frametags[0];
                            }
                            this.where = frametags[1];
                            this.vals = new String[frametags.length - 2];
                            int i2 = 0;
                            while (i2 < this.vals.length) {
                                this.vals[i2] = new String(frametags[2 + i2]);
                                ++i2;
                            }
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class tempZone {
        int temp = -1;
        int set12 = -1;
        int set13 = -1;
        int set14 = -1;
        int mode = -1;
        int cumode = -1;
        int tempman = -1;
        long tempmants = -1L;
        long refreshtime = -1L;

        tempZone() {
        }
    }
}

