/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.Leak;
import com.hsyco.hsyco;
import java.util.Hashtable;

public class LeakDetector {
    private static Hashtable<String, Leak> data = new Hashtable();

    public static void clear(String name) {
        try {
            LeakDetector.clear(LeakDetector.get(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clear(Leak leak) {
        try {
            Leak leak2 = leak;
            synchronized (leak2) {
                leak.valueTimestamp = 0L;
                leak.value = 0.0;
                leak.stableTimestamp = 0L;
                leak.quantity = 0;
                leak.time = 0L;
                leak.stable = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean options(String name, String param, String value) {
        try {
            if (param.equals("period")) {
                int speriod = Integer.parseInt(value);
                if (speriod > 0) {
                    Leak leak = LeakDetector.get(name);
                    leak.period = speriod * 1000;
                    if (!Configuration.verboseLog) return true;
                    hsyco.messageLog("Leak Detector [" + name + "] - Period set to : " + speriod + " seconds");
                    return true;
                }
                Leak leak = LeakDetector.get(name);
                leak.period = 0;
                LeakDetector.clear(leak);
                if (!Configuration.verboseLog) return false;
                hsyco.messageLog("Leak Detector [" + name + "] - Disabled");
                return false;
            }
            if (!param.equals("deviation")) return false;
            float deviation = Float.parseFloat(value);
            if (deviation > 0.0f) {
                LeakDetector.get((String)name).deviation = 4.0f * (deviation / 100.0f);
                if (!Configuration.verboseLog) return true;
                hsyco.messageLog("Leak Detector [" + name + "] - Deviation set to : " + deviation);
                return true;
            }
            Leak leak = LeakDetector.get(name);
            leak.deviation = 0.0f;
            LeakDetector.clear(leak);
            if (!Configuration.verboseLog) return false;
            hsyco.messageLog("Leak Detector [" + name + "] - Disabled");
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean update(String name, double value) {
        boolean lastActive;
        Leak leak;
        long now;
        block37: {
            now = System.currentTimeMillis();
            leak = null;
            try {
                leak = LeakDetector.get(name);
                if (leak.deviation != 0.0f && leak.period != 0) break block37;
                if (leak.active) {
                    leak.active = false;
                    return false;
                }
                return null;
            }
            catch (Exception e2) {
                if (leak != null) {
                    hsyco.messageLog("Leak Detector [" + leak.name + "] - Exception : " + e2);
                }
                return null;
            }
        }
        Leak leak2 = leak;
        synchronized (leak2) {
            lastActive = leak.active;
            if (leak.sampleTimestamp != 0L) {
                int newSampleInterval = 1000 * (int)Math.round((double)(now - leak.sampleTimestamp) / 1000.0);
                if (newSampleInterval != leak.sampleInterval) {
                    if (leak.sampleDeviationCounter > 2) {
                        leak.sampleDeviationCounter = 0;
                        leak.sampleInterval = newSampleInterval;
                        LeakDetector.clear(leak);
                        leak.active = false;
                        if (Configuration.verboseLog) {
                            hsyco.messageLog("Leak Detector [" + leak.name + "] - Sample interval reset to : " + leak.sampleInterval + " milliseconds");
                        }
                    } else {
                        ++leak.sampleDeviationCounter;
                    }
                } else {
                    leak.sampleDeviationCounter = 0;
                }
            }
            leak.sampleTimestamp = now;
            if (value > 0.0) {
                if (leak.valueTimestamp > 0L) {
                    int quantity = (int)(value - leak.value);
                    if (quantity > 0) {
                        long time = now - leak.valueTimestamp;
                        if (leak.quantity == 0) {
                            leak.quantity = quantity;
                            leak.time = time;
                        } else if ((float)Math.abs(leak.quantity - quantity) > leak.deviation / 2.0f) {
                            if (leak.stable && Configuration.verboseLog) {
                                hsyco.messageLog("Leak Detector [" + leak.name + "] - Reset on quantity fluctuation");
                            }
                            LeakDetector.clear(leak);
                            leak.active = false;
                        } else if ((float)Math.abs(leak.time - time) > leak.deviation * (float)leak.sampleInterval) {
                            if (leak.stable && Configuration.verboseLog) {
                                hsyco.messageLog("Leak Detector [" + leak.name + "] - Reset on period fluctuation");
                            }
                            LeakDetector.clear(leak);
                            leak.active = false;
                        } else if (leak.stable) {
                            if (now - leak.stableTimestamp > (long)leak.period && !leak.active) {
                                leak.active = true;
                            }
                        } else {
                            if (Configuration.verboseLog) {
                                hsyco.messageLog("Leak Detector [" + leak.name + "] - Stable: " + leak.quantity + "/" + leak.time);
                            }
                            leak.stable = true;
                            leak.stableTimestamp = now;
                        }
                        leak.valueTimestamp = now;
                        leak.value = value;
                    } else if (leak.active && quantity == 0 && now - leak.valueTimestamp > 2L * leak.time) {
                        if (leak.stable && Configuration.verboseLog) {
                            hsyco.messageLog("Leak Detector [" + leak.name + "] - Reset on no change");
                        }
                        LeakDetector.clear(leak);
                        leak.active = false;
                    } else if (quantity < 0) {
                        LeakDetector.clear(leak);
                        leak.active = false;
                        if (Configuration.verboseLog) {
                            hsyco.messageLog("Leak Detector [" + leak.name + "] - Reset on negative input value change");
                        }
                    }
                } else {
                    leak.valueTimestamp = now;
                    leak.value = value;
                }
            }
        }
        if (leak.active ^ lastActive) {
            hsyco.messageLog("Leak Detector [" + leak.name + "] - " + (leak.active ? "Active" : "Standby"));
            return leak.active;
        }
        return null;
    }

    public static boolean isactive(String name) {
        try {
            return LeakDetector.get((String)name).active;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Leak get(String name) {
        Hashtable<String, Leak> hashtable = data;
        synchronized (hashtable) {
            if (!data.containsKey(name)) {
                Leak l2 = new Leak(name);
                data.put(name, l2);
                return l2;
            }
            return data.get(name);
        }
    }
}

