/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userCode;

public class ISMG {
    private String serverName;
    private String commPort;
    private boolean guiSupport = true;
    private long pollInterval = 20000L;
    private int address = 64;
    private int online = -1;

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        this.pollInterval = Integer.parseInt(value) * 1000;
                        if (this.pollInterval < 1L) {
                            this.pollInterval = 20000L;
                            throw new Exception();
                        }
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("addr")) {
                    try {
                        this.address = Integer.parseInt(value);
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - addr ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e4) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e4);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.initRead()) {
            this.online = 1;
            this.ioWrite("connection", "online");
            SystemState.uiSet(String.valueOf(this.serverName) + ".connection.label", "visible", "false");
            SystemState.ioServersInitializedSet(ioIndex, true);
            me.heartbeat = System.currentTimeMillis();
        } else {
            me.quit = true;
        }
        while (!me.quit) {
            try {
                if (this.readRegisters()) {
                    me.heartbeat = System.currentTimeMillis();
                }
                ioMonitor.sleep(this.pollInterval);
            }
            catch (Exception e5) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5);
                me.quit = true;
            }
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.online != 0) {
            this.online = 0;
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.ioWrite("connection", "offline");
            SystemState.uiSet(String.valueOf(this.serverName) + ".connection.label", "visible", "true");
        }
    }

    private boolean initRead() {
        boolean ok = true;
        byte[] data = user.modbusReadHoldingRegisters(this.commPort, this.address, 18, 4);
        if (data != null && data.length == 10 && data[0] == 3) {
            this.ioWrite("typeno", this.toIntString16u(data, 2));
            this.ioWrite("baudrate", this.toIntString16u(data, 4));
            this.ioWrite("language", this.toIntString16u(data, 8));
        } else {
            ok = false;
        }
        data = user.modbusReadHoldingRegisters(this.commPort, this.address, 265, 6);
        if (data != null && data.length == 14 && data[0] == 3) {
            this.ioWrite("modelname", this.toIntString16u(data, 2));
            this.ioWrite("snhigh", this.toIntString16u(data, 4));
            this.ioWrite("snlow", this.toIntString16u(data, 6));
            this.ioWrite("devicever", this.toIntString16u(data, 8));
            this.ioWrite("versionsequ", this.toIntString16u(data, 10));
            this.ioWrite("versioncurr", this.toIntString16u(data, 12));
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean readRegisters() {
        int val;
        boolean ok = true;
        byte[] data = user.modbusReadHoldingRegisters(this.commPort, this.address, 1, 15);
        if (data != null && data.length == 32 && data[0] == 3) {
            this.ioWrite("fachtrip", this.toIntString16u(data, 2));
            this.ioWrite("fachcycle", this.toIntString16u(data, 4));
            this.ioWrite("facltrip", this.toIntString16u(data, 6));
            this.ioWrite("faclcycle", this.toIntString16u(data, 8));
            this.ioWrite("vachtrip", this.toIntString16u(data, 10));
            this.ioWrite("vachcycle", this.toIntString16u(data, 12));
            this.ioWrite("vacltrip", this.toIntString16u(data, 14));
            this.ioWrite("vaclcycle", this.toIntString16u(data, 16));
            this.ioWrite("deltazactrip", this.toIntString16u(data, 18));
            this.ioWrite("zactrip", this.toIntString16u(data, 20));
            this.ioWrite("fastiearthtrip", this.toIntString16u(data, 22));
            this.ioWrite("slowiearthtrip", this.toIntString16u(data, 24));
            this.ioWrite("risotrip", this.toIntString16u(data, 26));
            this.ioWrite("vpvstart", this.toIntString16u(data, 28));
            this.ioWrite("ongriddelay", this.toIntString16u(data, 30));
        } else {
            ok = false;
        }
        data = user.modbusReadHoldingRegisters(this.commPort, this.address, 25, 16);
        if (data != null && data.length == 34 && data[0] == 3) {
            int br = this.toInt16u(data, 2) * 65536 + this.toInt16u(data, 4);
            this.ioWrite("bridgerelayonnum", Integer.toString(br));
            this.ioWrite("operationtime", String.valueOf(this.toIntString16u(data, 6)) + ":" + this.toIntString16u(data, 8) + ":" + this.toIntString16u(data, 10));
            val = this.toInt16u(data, 12) * 1000000 + this.toInt16u(data, 14) * 100;
            this.ioWrite("eac", Integer.toString(val));
            this.uiSet("eac", String.valueOf(Float.toString((float)val / 1000.0f)) + " kWh");
            int valA = this.toInt16u(data, 18) * 1000000 + this.toInt16u(data, 20) * 100;
            this.ioWrite("a.epv", Integer.toString(valA));
            this.uiSet("a.epv", String.valueOf(Float.toString((float)valA / 1000.0f)) + " kWh");
            int valB = this.toInt16u(data, 24) * 1000000 + this.toInt16u(data, 26) * 100;
            this.ioWrite("b.epv", Integer.toString(valB));
            this.uiSet("b.epv", String.valueOf(Float.toString((float)valB / 1000.0f)) + " kWh");
            int valC = this.toInt16u(data, 30) * 1000000 + this.toInt16u(data, 32) * 100;
            this.ioWrite("c.epv", Integer.toString(valC));
            this.uiSet("c.epv", String.valueOf(Float.toString((float)valC / 1000.0f)) + " kWh");
            int valABC = valA + valB + valC;
            this.ioWrite("epv", Integer.toString(valABC));
            this.uiSet("epv", String.valueOf(Float.toString((float)valABC / 1000.0f)) + " kWh");
        } else {
            ok = false;
        }
        data = user.modbusReadHoldingRegisters(this.commPort, this.address, 87, 1);
        if (data != null && data.length == 4 && data[0] == 3) {
            if (this.toInt16u(data, 2) == 21845) {
                this.ioWrite("zacoffsw", "0");
            } else {
                this.ioWrite("zacoffsw", "1");
            }
        } else {
            ok = false;
        }
        data = user.modbusReadHoldingRegisters(this.commPort, this.address, 181, 15);
        if (data != null && data.length == 32 && data[0] == 3) {
            String st = this.getStateMsg(this.toInt16u(data, 2));
            if (st != null) {
                this.ioWrite("state", st);
            } else {
                ok = false;
            }
            this.ioWrite("errorcode1", this.toIntString16u(data, 4));
            this.ioWrite("errorcode2", this.toIntString16u(data, 6));
            this.ioWrite("errorcode3", this.toIntString16u(data, 8));
            this.ioWrite("errorcode4", this.toIntString16u(data, 10));
            val = this.toInt16u(data, 12);
            this.ioWrite("a.vpv", Integer.toString(val));
            this.uiSet("a.vpv", String.valueOf(Float.toString((float)val / 10.0f)) + " V");
            val = this.toInt16u(data, 14);
            this.ioWrite("b.vpv", Integer.toString(val));
            this.uiSet("b.vpv", String.valueOf(Float.toString((float)val / 10.0f)) + " V");
            val = this.toInt16u(data, 16);
            this.ioWrite("c.vpv", Integer.toString(val));
            this.uiSet("c.vpv", String.valueOf(Float.toString((float)val / 10.0f)) + " V");
            val = this.toInt16u(data, 18);
            this.ioWrite("a.ppv", Integer.toString(val));
            this.uiSet("a.ppv", String.valueOf(Float.toString((float)val / 1000.0f)) + " kW");
            val = this.toInt16u(data, 20);
            this.ioWrite("b.ppv", Integer.toString(val));
            this.uiSet("b.ppv", String.valueOf(Float.toString((float)val / 1000.0f)) + " kW");
            val = this.toInt16u(data, 22);
            this.ioWrite("c.ppv", Integer.toString(val));
            this.uiSet("c.ppv", String.valueOf(Float.toString((float)val / 1000.0f)) + " kW");
            val = this.toInt16u(data, 24);
            this.ioWrite("vac", Integer.toString(val));
            this.uiSet("vac", String.valueOf(Float.toString((float)val / 10.0f)) + " V");
            val = this.toInt16u(data, 26);
            this.ioWrite("pac", Integer.toString(val));
            this.uiSet("pac", String.valueOf(Float.toString((float)val / 1000.0f)) + " kW");
            val = this.toInt16u(data, 28);
            this.ioWrite("iac", Integer.toString(val));
            this.uiSet("iac", String.valueOf(Float.toString((float)val / 10.0f)) + " A");
            this.ioWrite("fac", this.toIntString16u(data, 30));
        } else {
            ok = false;
        }
        data = user.modbusReadHoldingRegisters(this.commPort, this.address, 196, 16);
        if (data != null && data.length == 34 && data[0] == 3) {
            this.ioWrite("ires", this.toIntString16u(data, 20));
            this.ioWrite("heatsinktemp", this.toIntString16u(data, 22));
            this.ioWrite("zac", this.toIntString16u(data, 24));
            this.ioWrite("riso", this.toIntString16u(data, 26));
        } else {
            ok = false;
        }
        data = user.modbusReadHoldingRegisters(this.commPort, this.address, 212, 4);
        if (data != null && data.length == 10 && data[0] == 3) {
            this.ioWrite("vactrip", this.toIntString16u(data, 6));
            this.ioWrite("factrip", this.toIntString16u(data, 8));
        } else {
            ok = false;
        }
        return ok;
    }

    private String toIntString16u(byte[] data, int index) {
        int val = data[index] & 0xFF;
        val <<= 8;
        return Integer.toString(val += data[index + 1] & 0xFF);
    }

    private String getStateMsg(int code) {
        switch (code) {
            case 10: {
                return "initialize";
            }
            case 11: {
                return "detect";
            }
            case 20: {
                return "renew";
            }
            case 30: {
                return "wait";
            }
            case 40: {
                return "monitoring";
            }
            case 50: {
                return "output";
            }
            case 60: {
                return "fault";
            }
            case 61: {
                return "idle";
            }
            case 70: {
                return "default";
            }
            case 80: {
                return "stop";
            }
            case 91: {
                return "calibrate";
            }
        }
        return null;
    }

    private int toInt16u(byte[] data, int index) {
        int val = data[index] & 0xFF;
        val <<= 8;
        return val += data[index + 1] & 0xFF;
    }

    private void ioWrite(String name, String value) {
        SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
    }

    private void uiSet(String name, String value) {
        if (this.guiSupport) {
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
        }
    }
}

