/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.hsyco;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;

public class IRCache {
    public String name;
    public long timestamp;
    public Hashtable<String, String> commands;

    public IRCache(String name) {
        this.name = name;
        this.commands = new Hashtable();
        this.timestamp = 0L;
    }

    public String getHexData(String command) {
        if (this.timestamp > 0L) {
            return this.commands.get(command);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean load() {
        long now = System.currentTimeMillis();
        if (this.timestamp + 10000L < now) {
            File rem = new File("ir/" + this.name + ".ccfhex");
            if (rem.canRead()) {
                long filetime = rem.lastModified();
                if (filetime == this.timestamp) {
                    return false;
                }
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(rem));
                    int linenum = 0;
                    String command = null;
                    StringBuffer hex = null;
                    int hexseparatorcounter = 0;
                    while ((line = in.readLine()) != null) {
                        char ch;
                        int i2;
                        ++linenum;
                        if ((line = line.trim()).length() <= 0) continue;
                        int eqidx = line.indexOf(61);
                        if (eqidx == 0) {
                            this.error(linenum);
                            return false;
                        }
                        if (eqidx == -1) {
                            if (hex == null) {
                                this.error(linenum);
                                return false;
                            }
                            i2 = 0;
                            while (i2 < line.length()) {
                                if (hexseparatorcounter == 4) {
                                    hex.append(' ');
                                    hexseparatorcounter = 0;
                                }
                                if (Character.isDigit(ch = line.charAt(i2)) || ch >= 'A' && ch <= 'F') {
                                    hex.append(ch);
                                    ++hexseparatorcounter;
                                } else if (ch >= 'a' && ch <= 'f') {
                                    hex.append(Character.toUpperCase(ch));
                                    ++hexseparatorcounter;
                                } else if (!Character.isSpaceChar(ch)) {
                                    this.error(linenum);
                                    return false;
                                }
                                ++i2;
                            }
                            continue;
                        }
                        if (hex != null) {
                            if (hex.length() > 0) {
                                this.commands.put(command, hex.toString());
                            } else {
                                this.error(linenum);
                                return false;
                            }
                        }
                        command = line.substring(0, eqidx).trim();
                        hex = new StringBuffer();
                        hexseparatorcounter = 0;
                        i2 = eqidx + 1;
                        while (i2 < line.length()) {
                            if (hexseparatorcounter == 4) {
                                hex.append(' ');
                                hexseparatorcounter = 0;
                            }
                            if (Character.isDigit(ch = line.charAt(i2)) || ch >= 'A' && ch <= 'F') {
                                hex.append(ch);
                                ++hexseparatorcounter;
                            } else if (ch >= 'a' && ch <= 'f') {
                                hex.append(Character.toUpperCase(ch));
                                ++hexseparatorcounter;
                            } else if (!Character.isSpaceChar(ch)) {
                                this.error(linenum);
                                return false;
                            }
                            ++i2;
                        }
                    }
                    if (hex != null) {
                        if (hex.length() > 0) {
                            this.commands.put(command, hex.toString());
                        } else {
                            this.error(linenum);
                            return false;
                        }
                    }
                    if (this.commands.size() > 0) {
                        this.timestamp = filetime;
                        return true;
                    }
                    this.error();
                    return false;
                }
                catch (Exception e2) {
                    this.error();
                    return false;
                }
            }
            if (this.timestamp == 0L) {
                return false;
            }
            this.timestamp = 0L;
            this.commands = new Hashtable();
            return true;
        }
        return false;
    }

    private void error() {
        hsyco.errorLog("IR Parser [" + this.name + ".ccfhex]: Error");
        this.timestamp = 0L;
    }

    private void error(int linenum) {
        hsyco.errorLog("IR Parser [" + this.name + ".ccfhex]: Syntax Error, line: " + linenum);
        this.timestamp = 0L;
    }
}

