/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.hsyco;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;

public class HsycoSecurity {
    public static final int MASTER = 0;
    public static final int TAMPER = 1;
    public static final int PANIC = 2;
    public static final int AUX = 3;
    private int _id;
    private int _status = 0;
    private int _mode = 0;
    private int _battery = 0;
    private int _power = 0;
    private int _delay = 0;
    private int _alarm_silent = 0;
    private int[] _zone = new int[10];
    private int[] _alarm_master = new int[10];
    private int[] _alarm_tamper = new int[10];
    private int[] _alarm_panic = new int[10];
    private int[] _alarm_aux = new int[10];
    private static LinkedList<String> _events_log = new LinkedList();
    public static final int log_size = 5;
    private long _timestamp;

    public HsycoSecurity(int id) {
        this._id = id;
        this._timestamp = 1L;
    }

    private synchronized void log(int zone, int param, int[] zones) {
        Calendar calNow = Calendar.getInstance();
        long now = calNow.getTimeInMillis();
        SimpleDateFormat dfclient = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer sc = new StringBuffer();
        StringBuffer sf = new StringBuffer();
        if (zone == 0) {
            sc.append(dfclient.format(now));
            sc.append("-0-");
            sc.append(param);
            sc.append("-");
            sf.append(param == 1 ? "ON - ZONES " : "OFF - ZONES ");
            int j2 = 0;
            while (j2 < zones.length) {
                sc.append(zones[j2]);
                if (zones[j2] == 1) {
                    sf.append(j2);
                }
                ++j2;
            }
            _events_log.addFirst(sc.toString());
        } else {
            _events_log.addFirst(String.valueOf(dfclient.format(now)) + "-" + zone + "-" + param);
            sf.append("ALARM - ");
            switch (param) {
                case 0: {
                    sf.append("INTRUSION");
                    break;
                }
                case 1: {
                    sf.append("TAMPER");
                    break;
                }
                case 2: {
                    sf.append("PANIC");
                    break;
                }
                case 3: {
                    sf.append("AUX");
                    break;
                }
                default: {
                    sf.append("UNKNOWN");
                }
            }
            sf.append(" - ZONE ");
            sf.append(zone);
        }
        while (_events_log.size() > 5) {
            _events_log.removeLast();
        }
        hsyco.securityLog("[" + this._id + "] " + sf.toString());
    }

    public boolean setStatus(int value, long timestamp) {
        if (this._status == value) {
            return false;
        }
        this._status = value;
        this._timestamp = timestamp;
        if (value == 0) {
            int i2 = 0;
            while (i2 < this._alarm_master.length) {
                this._alarm_master[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this._alarm_tamper.length) {
                this._alarm_tamper[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this._alarm_panic.length) {
                this._alarm_panic[i2] = 0;
                ++i2;
            }
        }
        return true;
    }

    public boolean setMode(int value, long timestamp) {
        int i2;
        if (this._mode == value) {
            return false;
        }
        this.log(0, value, this._zone);
        this._mode = value;
        this._timestamp = timestamp;
        if (value == 0) {
            i2 = 0;
            while (i2 < this._alarm_master.length) {
                this._alarm_master[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this._alarm_tamper.length) {
                this._alarm_tamper[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this._alarm_panic.length) {
                this._alarm_panic[i2] = 0;
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < this._alarm_aux.length) {
            this._alarm_aux[i2] = 0;
            ++i2;
        }
        return true;
    }

    public boolean setBattery(int value, long timestamp) {
        if (this._battery == value) {
            return false;
        }
        this._battery = value;
        this._timestamp = timestamp;
        return true;
    }

    public boolean setPower(int value, long timestamp) {
        if (this._power == value) {
            return false;
        }
        this._power = value;
        this._timestamp = timestamp;
        return true;
    }

    public boolean setDelay(int value, long timestamp) {
        if (this._delay == value) {
            return false;
        }
        this._delay = value;
        this._timestamp = timestamp;
        return true;
    }

    public boolean setSilent(int value, long timestamp) {
        if (this._alarm_silent == value) {
            return false;
        }
        this._alarm_silent = value;
        this._timestamp = timestamp;
        return true;
    }

    public boolean setZones(int zone, int value, long timestamp) {
        if (this._zone[zone] == value) {
            return false;
        }
        this._zone[zone] = value;
        this._timestamp = timestamp;
        return true;
    }

    public boolean setAlarms(int type, int zone, int value, long timestamp) {
        if (this._status == 1 && (type == 3 || this._mode == 1)) {
            if (value == 1) {
                this.log(zone, type, null);
            }
            switch (type) {
                case 0: {
                    this._alarm_master[zone] = value;
                    break;
                }
                case 1: {
                    this._alarm_tamper[zone] = value;
                    break;
                }
                case 2: {
                    this._alarm_panic[zone] = value;
                    break;
                }
                case 3: {
                    this._alarm_aux[zone] = value;
                }
            }
            this._timestamp = timestamp;
            return true;
        }
        return false;
    }

    public int getId() {
        return this._id;
    }

    public int getStatus() {
        return this._status;
    }

    public int getMode() {
        return this._mode;
    }

    public int getBattery() {
        return this._battery;
    }

    public int getPower() {
        return this._power;
    }

    public int getDelay() {
        return this._delay;
    }

    public int getSilent() {
        return this._alarm_silent;
    }

    public int[] getZones() {
        return this._zone;
    }

    public int[] getAlarms(int type) {
        switch (type) {
            case 0: {
                return this._alarm_master;
            }
            case 1: {
                return this._alarm_tamper;
            }
            case 2: {
                return this._alarm_panic;
            }
            case 3: {
                return this._alarm_aux;
            }
        }
        return null;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._status);
        sb.append(",");
        sb.append(this._mode);
        sb.append(",");
        sb.append(this._battery);
        sb.append(",");
        sb.append(this._power);
        sb.append(",");
        sb.append(this._delay);
        sb.append(",");
        sb.append(this._alarm_silent);
        sb.append(",\"");
        int j2 = 0;
        while (j2 < this._zone.length) {
            sb.append(this._zone[j2]);
            ++j2;
        }
        sb.append("\",\"");
        j2 = 0;
        while (j2 < this._alarm_master.length) {
            sb.append(this._alarm_master[j2]);
            ++j2;
        }
        sb.append("\",\"");
        j2 = 0;
        while (j2 < this._alarm_tamper.length) {
            sb.append(this._alarm_tamper[j2]);
            ++j2;
        }
        sb.append("\",\"");
        j2 = 0;
        while (j2 < this._alarm_aux.length) {
            sb.append(this._alarm_aux[j2]);
            ++j2;
        }
        sb.append("\",\"");
        j2 = 0;
        while (j2 < this._alarm_panic.length) {
            sb.append(this._alarm_panic[j2]);
            ++j2;
        }
        sb.append("\",\"");
        j2 = 0;
        while (j2 < _events_log.size() && j2 < 5) {
            if (j2 > 0) {
                sb.append(";");
            }
            sb.append(_events_log.get(j2));
            ++j2;
        }
        sb.append("\"");
        return sb.toString();
    }
}

