/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class HsycoFile {
    private byte[] theData = null;
    private File theFile;
    private long lastModified = 0L;
    private boolean isLink = false;
    private static File jf = new File("hsyco.jar");
    private static String basePath;
    private static JarFile jar;
    private static Hashtable<String, String> pluginsWwwDirs;
    private static String wwwCanonicalPath;
    private static Hashtable<String, String> uiLinks;

    static {
        jar = null;
        pluginsWwwDirs = null;
        wwwCanonicalPath = null;
        uiLinks = new Hashtable();
    }

    public HsycoFile(String root, String name) {
        this(new File(root), name);
    }

    public HsycoFile(File root, String name) {
        this(root, name, true);
    }

    public HsycoFile(File root, String name, boolean readData) {
        File file = name == null ? root : new File(root, name);
        try {
            this.HsycoFileInternal(root, file, name, readData);
        }
        catch (Exception e2) {
            this.theFile = null;
            this.theData = null;
        }
    }

    private void HsycoFileInternal(File root, File file, String name, boolean readData) throws Exception {
        this.theFile = file;
        if (!this.theFile.isDirectory()) {
            boolean found;
            if (this.theFile.canRead()) {
                found = true;
            } else if (root.getPath().equals("www")) {
                String fn = file.getName();
                String pn = name.substring(0, name.length() - fn.length());
                String target = uiLinks.get(pn);
                if (target != null) {
                    this.theFile = new File(target, fn);
                    if (this.theFile.canRead()) {
                        this.isLink = true;
                        found = true;
                    } else {
                        this.theFile = file;
                        found = false;
                    }
                } else {
                    found = false;
                }
            } else {
                found = false;
            }
            if (found) {
                DataInputStream fis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.theFile)));
                if (readData) {
                    this.theData = new byte[(int)this.theFile.length()];
                    fis.readFully(this.theData);
                    fis.close();
                }
                this.lastModified = this.theFile.lastModified();
                return;
            }
            if (pluginsWwwDirs != null) {
                String key;
                String to;
                int sep;
                String fcp;
                if (wwwCanonicalPath == null) {
                    wwwCanonicalPath = new File("www").getCanonicalPath();
                }
                if ((fcp = file.getCanonicalPath()).startsWith(wwwCanonicalPath) && (sep = fcp.indexOf(File.separatorChar, wwwCanonicalPath.length() + 1)) > 0 && (to = pluginsWwwDirs.get(key = fcp.substring(wwwCanonicalPath.length() + 1, sep))) != null) {
                    StringBuffer sb = new StringBuffer(fcp);
                    sb.insert(wwwCanonicalPath.length() - 3, "plugins" + File.separatorChar + to + File.separatorChar);
                    File redirectedFile = new File(sb.toString());
                    if (redirectedFile.canRead()) {
                        if (readData) {
                            DataInputStream fis = new DataInputStream(new BufferedInputStream(new FileInputStream(redirectedFile)));
                            this.theData = new byte[(int)redirectedFile.length()];
                            fis.readFully(this.theData);
                            fis.close();
                        }
                        this.lastModified = redirectedFile.lastModified();
                        return;
                    }
                }
            }
            this.jarInit();
            if (root.getAbsolutePath().startsWith(basePath)) {
                JarEntry e2;
                StringBuffer sb = new StringBuffer(root.getAbsolutePath().substring(basePath.length() + 1));
                if (name != null) {
                    if (!name.startsWith("/")) {
                        sb.append("/");
                    }
                    sb.append(name);
                }
                if ((e2 = jar.getJarEntry(sb.toString().replace('\\', '/'))) == null) {
                    throw new FileNotFoundException("Not found in Jar");
                }
                if (readData) {
                    InputStream is = jar.getInputStream(e2);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    int read = 0;
                    while ((read = is.read(buffer)) != -1) {
                        baos.write(buffer, 0, read);
                    }
                    this.theData = baos.size() > 0 ? baos.toByteArray() : new byte[0];
                    is.close();
                }
                this.lastModified = jf.lastModified();
            }
        }
    }

    public byte[] getBytes() {
        return this.theData;
    }

    public String getString() {
        return this.theData != null ? new String(this.theData) : null;
    }

    public File getFile() {
        return this.theFile;
    }

    public String getName() {
        return this.theFile.getName();
    }

    public long lastModified() {
        return this.lastModified;
    }

    public boolean exists() {
        return this.lastModified != 0L;
    }

    public boolean isLink() {
        return this.isLink;
    }

    static void uiLink(String source, String target) {
        if (target == null) {
            uiLinks.remove(source);
        } else if (source != null) {
            target = target.replaceAll("^/+", "").replaceAll("/+$", "");
            if (!source.startsWith("/")) {
                source = "/" + source;
            }
            if (!source.endsWith("/")) {
                source = String.valueOf(source) + "/";
            }
            uiLinks.put(source, target);
        }
    }

    static void registerWwwDir(String from, String to) {
        if (pluginsWwwDirs == null) {
            pluginsWwwDirs = new Hashtable();
        }
        pluginsWwwDirs.put(from, to);
    }

    static Vector<File> getPluginsWwwDirs() {
        try {
            if (pluginsWwwDirs != null) {
                Vector<File> v = new Vector<File>();
                Enumeration<String> e2 = pluginsWwwDirs.keys();
                while (e2.hasMoreElements()) {
                    String key = e2.nextElement();
                    File dir = new File("plugins" + File.separator + pluginsWwwDirs.get(key) + File.separator + "www" + File.separator + key);
                    if (!dir.isDirectory()) continue;
                    v.add(dir);
                }
                return v;
            }
            return null;
        }
        catch (Exception e3) {
            return null;
        }
    }

    public static boolean exists(File root, String name) {
        return HsycoFile.getTimestamp(root, name) != 0L;
    }

    public static long getTimestamp(File root, String name) {
        HsycoFile file = new HsycoFile(root, name, false);
        return file.lastModified();
    }

    private synchronized void jarInit() throws Exception {
        if (jar == null) {
            jar = new JarFile(jf, false, 1);
            basePath = jf.getCanonicalFile().getParent();
        }
    }
}

