/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioCommandDispatcher;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.IOException;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class FP2000 {
    public static final String[] WebObjects = new String[]{"fp2000", "fp2000small"};
    private byte[] serial_initialization_req;
    private byte[] network_map_resp;
    private byte[] access_req;
    private byte[] configuration_req;
    private byte[] nv_loop_data_req;
    private byte[] nv_sensor_data_req;
    private byte[] nv_zone_data_req;
    private byte[] nv_area_data_req;
    private byte[] nv_input_data_req;
    private byte[] nv_output_data_req;
    private byte[] ACK;
    private byte[] NAK;
    private byte[] network_watchdog;
    private byte[] emulation_cmd_start;
    private byte[] emulation_cmd_stop;
    private byte[] emulation_cmd_key;
    private byte[] status_req;
    private byte[] v_sensor_data_req;
    private byte[] v_zone_data_req;
    private byte[] v_area_data_req;
    private byte[] time_req;
    private byte[] set_time_req;
    private byte[] v_input_data_req;
    private byte[] v_output_data_req;
    private Properties prop;
    private final Display display;
    private int loops_num;
    private int areas_num;
    private byte start_zone;
    private int end_zone;
    private int inputs_num;
    private int outputs_num;
    private HashMap<Integer, Loop> loops;
    private Iterator<Loop> loops_iterator;
    private Iterator<Sensor> sensors_iterator;
    private HashMap<Integer, Zone> zones;
    private Iterator<Zone> zones_iterator;
    private HashMap<Integer, Area> areas;
    private Iterator<Area> areas_iterator;
    private HashMap<Integer, Output> outputs;
    private Iterator<Output> outputs_iterator;
    private HashMap<Integer, Input> inputs;
    private Iterator<Input> inputs_iterator;
    private long logTime;
    private Vector<byte[]> reset_list_temp;
    private Vector<byte[]> reset_list;
    private Vector<String> logs;
    private int language;
    private static final String[] ACTION = new String[]{"Action", "Azione", "Action"};
    private static final String[] FIRE = new String[]{"Fire", "Incendio", "Feu"};
    private static final String[] FAULT = new String[]{"Fault", "Guasto", "Faute"};
    private static final String[] CONDITION = new String[]{"Condition", "Condizione", "Circonstance"};
    private static final String[] UNKNOWN = new String[]{"Unknown", "Sconosciuto", "Inconnu"};
    private static final String[] SENSOR_SOAK = new String[]{"Sensor soak", "Soak sensore", "Soak capteur"};
    private static final String[] AREA = new String[]{"Area", "Area", "Aire"};
    private static final String[] ZONE = new String[]{"Zone", "Zona", "Zone"};
    private static final String[] SENSOR = new String[]{"Sensor", "Sensore", "Capteur"};
    private static final String[] SENSOR_TYPE = new String[]{"Sensor type", "Tipo sensore", "Type de capteur"};
    private static final String[] GENERAL = new String[]{"General", "Generale", "General"};
    private static final String[] OUTPUT = new String[]{"Output", "Uscita", "Sortie"};
    private static final String[] INPUT = new String[]{"Input", "Ingresso", "Contribution"};
    private static final String[] LOOP = new String[]{"Loop", "Loop", "Loop"};
    private static final String[] LON = new String[]{"LON", "LON", "LON"};
    private static final String[] NUMBER = new String[]{"Number", "Numero", "Numero"};
    private static final String[] OUTPUT_NOT_SWITCHED = new String[]{"Output not switched", "Uscita non commutata", "Sortie non commutee"};
    private static final String[] OUTPUT_SWITCHED = new String[]{"Output switched", "Uscita commutata", "Sortie commutee"};
    private static final String[] INPUT_NOT_SWITCHED = new String[]{"Input not switched", "Ingresso non commutato", "Entree non commutee"};
    private static final String[] INPUT_SWITCHED = new String[]{"Input switched", "Ingresso commutato", "Entree commutee"};
    private static final String[] PASSIVE = new String[]{"Passive", "Passivo", "Passif"};
    private static final String[] ACTIVE = new String[]{"Active", "Attivo", "Actif"};
    private static final String[] ACCEPTED = new String[]{"Accepted", "Accettato", "Accepte"};
    private static final String[] LOGGED = new String[]{"Logged", "Connesso", "Connecte"};
    private static final String[][] GENERAL_ALARM = new String[][]{{"Common fire", "Incendio comune", "Feu commun"}, {"External fire", "Incendio esterno", "Feu exterieur"}, {"LA triggered", "LA attivato", "LA declenche"}, {"Zone allocation fault", "Errore assegnazione zona", "Defaut d'allocation de la zone"}, {"", "", ""}, {"Common condition", "Condizione comune", "Condition commun"}, {"Common coincidence", "Coincidenza comune", "Coincidence commun"}, {"Maintenance condition", "Condizione manutenzione", "Etat d'entretien"}, {"Pre Warning condition", "Condizione pre allarme", "Etat d'alerte pre"}, {"", "", ""}, {"Common fault", "Guasto comune", "Faute commun"}, {"Watchdog time-out", "Watchdog time-out", "Watchdog time-out"}, {"Service mode on", "Modalita servizio on", "Mode de service on"}, {"Memory unlocked", "Memoria sbloccata", "Memoire deverrouille"}, {"", "", ""}, {"", "", ""}, {"Tamper switch on", "Manomissione on", "Interrupteur de securite sur"}, {"Mains off", "Rete off", "Reseau off"}, {"Battery disconnected", "Batteria disconnessa", "Batterie deconnecte"}, {"Low battery", "Batteria scarica", "Batterie faible"}, {"Charger fault", "Caricabatterie guasto", "defaut chargeur"}, {"Earth fault", "Terra guasta", "defaut a la terre"}, {"Incomplete NET1 set-up", "Set-up NET1 incompleto", "Incomplete NET1 set-up"}, {"Printer disconnected", "Stampante disconnessa", "Imprimante deconnectee"}, {"Wrong time/date", "Ora/data errata", "Mauvais heure/date"}, {"Configuration fault", "Errore configurazione", "Defaut de configuration"}, {"Sounder disabled", "Sirena disabilitata", "Sondeur desactive"}, {"Fire brigade disabled", "Vigili del fuoco disabilitato", "Pompiers faute"}, {"Sounder fault", "Sirena guasta", "faute Sondeur"}, {"Fire brigade fault", "Errore vigili del fuoco", "Pompiers desactivee"}, {"External fault", "Guasto esterno", "defaut externe"}, {"External supply fault", "Guasto alimentazione esterna", "Defaut d'alimentation externe"}, {"Sounder test", "Test sirena", "Test de sirene"}, {"Fire brigade test", "Test vigili del fuoco", "Test pompiers"}, {"Checksum fault for non-volatile memory", "Errore checksum per memoria non-volatile", "Checksum defaut pour une memoire non-volatile"}, {"Local repeater fault", "Ripetitore locale guasto", "Faute repeteur local"}, {"Acces fault", "Errore accesso", "faute d'acces"}, {"Battery failed", "Errore batteria", "batterie echoue"}, {"Emulation disconnected", "Emulazione terminata", "Emulation deconnecte"}, {"Logic disabled", "Logica disattivata", "Logique desactive"}, {"Logic error", "Errore logica", "Erreur logique"}, {"Hardware test failed", "Test Hardware fallito", "Test materiel a echoue"}, {"Checksum fault for protected memory", "Errore checksum per memoria protetta", "Checksum defaut pour la memoire protegee"}, {"Fire panel fault", "Pannello guasto", "Faute panneau"}, {"Global repeater fault", "Ripetitore globale guasto", "Faute repeteur mondial"}, {"No checksums calculated", "Nessun checksum calcolato", "No checksum calculees"}, {"Input fault", "Ingresso guasto", "faute d'entree"}, {"Output fault", "Uscita guasta", "faute de sortie"}, {"Fault routing fault", "Guasto routing guasto", "Defaut de routage faute"}, {"Fire protection fault", "Protezione incendio guasto", "Faute de protection incendie"}, {"No fire brigade feedback", "No retroazione incendio", "Pas de commentaires pompiers"}, {"Fault routine disabled", "Routine guasto disattivato", "Programme de defaut desactive"}, {"Soak test", "Soak Test", "Soak Test"}, {"Zone test", "Test zone", "Test zone"}, {"Fire protection disabled", "Protezione incendio disattivato", "Protection contre l'incendie desactive"}, {"Fault routing test", "Test guasto routing", "Test defaut de routage"}, {"Fire protection test", "Test protezione incendio", "Test de protection incendies"}, {"Fault routing return fault", "Guasto routing", "Faute de retour de defaut de routage"}, {"Fire protection return fault", "Guasto protezione incendio", "Faute de retour de protection incendie"}, {"Fire brigade return fault", "Guasto vigili del fuoco", "Faute de retour Pompiers"}, {"Modem fault", "Guasto modem", "faute Modem"}, {"VDU disconnected", "VDU disconnesso", "VDU deconnecte"}, {"Loop test", "Test loop", "Test loop"}, {"Modem report fault", "Errore modem report", "Faute rapport modem"}, {"Fire protection equipment fault", "Guasto attrezzatura protezione incendio", "Defaut equipement de protection incendie"}, {"Fault routing equipment fault", "Guasto attrezzatura routing", "Anomalie de l'appareil de defaut de routage"}, {"Port fault", "Guasto porta", "Port faute"}, {"Incomplete NET2 set-up", "set-up NET2 incompleo", "Incomplete NET2 set-up"}, {"Network Line faulty", "Linea di rete difettosa", "Ligne reseau defectueuse"}, {"Duplicate Node ID", "ID nodo duplicato", "ID noeud duplique"}, {"Auxiliary supply fault", "Alimentazione ausiliaria guasta", "Defaut d'alimentation auxiliaire"}, {"Third source fault", "Terza fonte guasta", "Troisieme source de defaut"}, {"", "", ""}, {"FSK release", "FSK rilasciato", "FSK communique"}, {"FSE input fault", "FSE ingresso guasto", "Faute d'entree FSE"}, {"FSE input active", "FSE ingresso attivo", "FSE entree active"}, {"EMZ FSK door release input fault", "EMZ FSK rilascio porta ingresso guasto", "EMZ FSK porte communique erreur d'entree"}, {"EMZ FSK door release request", "EMZ FSK rilascio porta richiesto", "EMZ FSK demande d'ouverture de porte"}, {"", "", ""}, {"FSK door open", "FSK porta aperta", "Porte ouverte FSK"}, {"FSK security fault", "FSK guasto sicurezza", "FSK de securite faute"}, {"", "", ""}, {"FSK heater fault", "FSK riscaldatore guasto", "Faute chauffe FSK"}, {"BFS disabled", "BFS disattivato", "BFS desactive"}, {"External alarm (Hauptmelder)", "Allarme esterno (Hauptmelder)", "Alarme externe (Hauptmelder)"}, {"Fire brigade trigger from FBF", "Incendio innescato da FBF", "Declenchement Pompiers de la FBF"}, {"No communication with CMSI (SDI A)", "Nessuna comunicazione con CMSI (SDI A)", "Pas de communication avec CMSI (SDI A)"}, {"LON device communication  fault", "LON dispositivo comunicazione guasto", "Faute de communication LON dispositif"}, {"LON controller fault", "LON controller guasto", "LON controleur de la faute"}, {"LON device fault", "LON dispositivo guasto", "Defaut de l'appareil LON"}, {"No communication with CMSI (SDI B)", "Nessuna comunicazione con CMSI (SDI B)", "Pas de communication avec CMSI (SDI B)"}, {"LON device disabled", "LON dispositivo disattivato", "Appareil LON desactive"}, {"2nd Sounder fault", "Seconda sirena guasto", "Faute sondeur secondes"}, {"MCP FB fault (NEN)", "MCP FB guasto (NEN)", "MCP FB defaut (NEN)"}, {"MCP FB disable (NEN)", "MCP FB disattivato (NEN)", "MCP FB desactiver (NEN)"}, {"MCP FB Test (NEN)", "MCP FB test (NEN)", "MCP FB test (NEN)"}, {"DIP Switch setting error", "Errore DIP switch setting", "DIP erreur de reglage interrupteur"}, {"LA input return", "LA ritorno ingresso", "De retour d'entree LA"}, {"LA fault", "LA guasto", "LA faute"}, {"LA fault return", "LA ritorno guasto", "Retour faute LA"}, {"Pager communication fault", "Errore pager communication", "Pager defaut de communication"}, {"Unknown pager address", "Indirizzo pager sconosciuto", "Adresse inconnue pager"}, {"No pager dongle", "No pager dongle", "Pas de dongle pager"}, {"LON redundancy fault", "LON ridondanza guasta", "LON redondance faute"}, {"Loop Card (Kilsen)", "Loop card (Kilsen)", "Carte loop (Kilsen)"}, {"Memory size (Kilsen)", "Dimensione memoria (Kilsen)", "Taille de la memoire (Kilsen)"}, {"House alarm", "Allarme casa", "Alarme de maison"}, {"LA alarm", "LA allarme", "Alarme LA"}, {"Sprinkler alarm", "Allarme spruzzatore", "Alarme de gicleurs"}, {"BFS triggered", "BFS attivato", "BFS declenche"}, {"FB triggered", "FB attivato", "FB declenche"}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"Flash memory modified", "Memoria flash modificata", "Memoire Flash modification"}, {"Missing Equipment", "Attrezzatura mancante", "Manque d'equipement"}, {"Invalid LON controller HW revision", "Revisione HW LON controller invalida", "Blancs LON controleur HW revision"}, {"Invalid LON controller OEM", "OEM LON controller invalido", "Blancs LON controleur OEM"}, {"Invalid LON controller PC", "PC LON controller invalido", "Blancs PC controleur LON"}, {"Invalid LON controller CFG", "CFG LON controller invalido", "Blancs CFG controleur LON"}, {"Invalid LON controller SW revision", "Revisione SW LON controller invalida", "Blancs LON controleur SW revision"}, {"Missing Output Equipment", "Attrezzatura uscita mancante", "Manque d'equipement de sortie"}, {"Missing Input Equipment", "Attrezzatura ingresso mancante", "Manque d'equipement d'entree"}, {"", "", ""}};
    private static final String[][] ACTION_LIST = new String[][]{{"Restart", "Restart", "Restart"}, {"Reset", "Reset", "Reset"}, {"Silence buzzer", "Buzzer silenziato", "Silence buzzer"}, {"Sounder on", "Sirena on", "Sounder sur"}, {"Sounder silenced", "Sirena silenziata", "Sondeur silence"}, {"Sounder delay on", "Ritardo sirena on", "Retard sur le sondeur"}, {"Sounder delay off", "Ritardo sirena off", "Sondeur de retarder hors"}, {"Sounder enabled", "Sirena attivata", "Sondeur permis"}, {"Fire brigade delay on", "Ritardo vigili del fuoco on", "Retard pompiers on"}, {"Fire brigade delay off", "Ritardo vigili del fuoco off", "Retard pompiers off"}, {"Fire brigade enabled", "Vigili del fuoco abilitato", "Pompiers permis"}, {"Fire brigade stop", "Vigili del fuoco stop", "Pompiers arr\ufffdt"}, {"Event buffer cleared", "Buffer eventi cancellato", "Buffer des evenements effaces"}, {"Memory locked", "Memoria bloccata", "Memoire verrouillee"}, {"Service mode off", "Modalita servizio on", "Mode de service hors"}, {"Tamper switch off", "Interruttore manumission off", "Tamper eteignez"}, {"Key lock disabled", "Key lock disattivata", "Key lock desactive"}, {"Mains on", "Rete on", "Mains sur"}, {"Day mode", "Modalita giorno", "mode Jour"}, {"Night mode", "Modalita notte", "Le mode Nuit"}, {"School bells on", "Campanella scuola on", "Cloches ecole sur"}, {"School bells off", "Campanella scull off", "Cloches ecole hors"}, {"Sounder test off", "Test sirena off", "Sondeur de test hors"}, {"Fire brigade test off", "Test pompieri off", "Pompiers test hors"}, {"Soak test off", "Soak test off", "Soak Test hors"}, {"Zone test off", "Test zona off", "Test de la zone hors"}, {"Maintenance reminder", "Promemoria manutenzione", "Memoire d'entretien"}, {"Access enabled", "Accesso attivato", "Acces permis"}, {"Access disabled", "Accesso disattivato", "Acces desactive"}, {"Battery connected", "Batteria connessa", "Batterie connectee"}, {"Battery detected", "Batteria rilevata", "Batterie detectee"}, {"Local Repeater OK", "Ripetitore locale OK", "OK repeteur local"}, {"Logic enabled", "Logica attiva", "Logic permis"}, {"External fault OK", "Guasto esterno OK", "OK defaut externe"}, {"Modem OK", "Modem OK", "Modem OK"}, {"Time changed", "Ora cambiata", "Temps change"}, {"Synchronise time", "Sincronizzazione ora", "Synchronisez le temps"}, {"Fire Panel OK", "Pannello OK", "Panneau OK"}, {"Global Repeater OK", "Ripetitore globale OK", "OK repeteur mondial"}, {"Fire brigade signal", "Segnale vigili del fuoco", "Pompiers du signal"}, {"Low battery OK", "Batteria scarica OK", "OK batterie faible"}, {"Charger OK", "Caricabatterie OK", "Chargeur OK"}, {"Earth OK", "Terra OK", "Terre OK"}, {"Zones on", "Zone on", "Zones sur"}, {"Zones off", "Zone off", "Zones hors"}, {"Event buffer full", "Buffer eventi pieno", "Buffer evenements pleine"}, {"External supply OK", "Alimentazione esterna OK", "OK alimentation externe"}, {"Fault OK", "Guasto OK", "OK defaut"}, {"Condition OK", "Condizione OK", "OK Condition"}, {"Key lock enabled", "Key lock attivo", "Key lock enabled"}, {"Hardware test start", "Test Hardware inizio", "Debut de l'essai du materiel"}, {"Hardware test end", "Test Hardware fine", "Fin de l'essai du materiel"}, {"Fire Panel disconnected", "Pannello disconnesso", "Centrale Incendie deconnecte"}, {"Local Repeater disconnected", "Ripetitore locale disconnesso", "Repeteur local deconnecte"}, {"Global Repeater disconnected", "Ripetitore globale disconnesso", "Repeteur mondial deconnecte"}, {"Reserved", "Riservato", "Reserve"}, {"Fault routing on", "Guasto routing on", "Defaut de routage sur"}, {"Fault routing silenced", "Guasto routing silenziato", "Defaut de routage reduits au silence"}, {"Fault routing delay on", "Ritardo guasto routing on", "Defaut de routage retard sur"}, {"Fault routing delay off", "Ritardo guasto routing off", "Defaut de routage de retarder hors"}, {"Fault routing enabled", "Guasto routing attivo", "Defaut de routage active"}, {"Fire protection on", "Protezione incendio on", "Protection contre les incendies sur les"}, {"Fire protection silenced", "Protezione incendio silenziata", "Protection contre les incendies reduits au silence"}, {"Fire protection delay on", "Ritardo protezione incendio on", "Retard pour la protection incendie sur"}, {"Fire protection dealay off", "Ritardo protezione incendio off", "Protection contre l'incendie dealay hors"}, {"Fire protection enabled", "Protezione incendio attiva", "Protection contre l'incendie a permis"}, {"Fault routing test off", "Test guasto routing off", "Defaut de routage test hors"}, {"Fire protection test off", "Test protezione incendio off", "Test de protection contre les incendies hors"}, {"User log", "User log", "User log"}, {"Loop test off", "Loop test off", "Loop test off"}, {"Modem test", "Modem test", "Modem test"}, {"Printer on", "Stampante on", "Imprimante sur"}, {"Network Like OK", "Rete OK", "Reseau Comme OK"}, {"Auxiliary supply OK", "Alimentatore ausiliare OK", "OK d'alimentation auxiliaire"}, {"Third source ok", "Terza fonte OK", "OK Troisieme source"}, {"Fire brigade feedback", "Retroazione vigili del fuoco", "Pompiers commentaires"}, {"Clear all event buffers", "Cancella tutti i buffer eventi", "Effacer tous les memoires tampons d'evenements"}, {"Call on line 1", "Chiamata su linea 1", "Appelez la ligne 1"}, {"Call on line 2", "Chiamata su linea 2", "Appelez la ligne 2"}, {"Call on line 3", "Chiamata su linea 3", "Appelez la ligne 3"}, {"Call on line 4", "Chiamata su linea 4", "Appelez la ligne 4"}, {"End of call line 1", "Chiamata terminata linea 1", "Fin de la 1 ligne d'appel"}, {"End of call line 2", "Chiamata terminata linea 2", "Fin de la 2 ligne d'appel"}, {"End of call line 3", "Chiamata terminata linea 3", "Fin de la 3 ligne d'appel"}, {"End of call line 4", "Chiamata terminata linea 4", "Fin de la 4 ligne d'appel"}, {"BFS enabled", "BFS attivo", "BFS permis"}, {"FSK locked from EMZ", "FSK bloccato da EMZ", "FSK verrouillee de EMZ"}, {"FSK door closed", "FSK chiusura porta", "Porte fermee FSK"}, {"FSK locked", "FSK bloccato", "FSK verrouille"}, {"Communication with CMSI (SDI A) ok", "Comunicazione con CMSI (SDI A) ok", "Communication avec CMSI (SDI A) ok"}, {"LON device communication ok", "LON comunicazione dispositivi ok", "Ok LON dispositif de communication"}, {"LON device fault ok", "LON guasto dispositivi ok", "Ok LON defaut de l'appareil"}, {"LON controller fault ok", "Controller LON guasto ok", "LON controleur faute ok"}, {"Communication with CMSI (SDI B) ok", "Comunicazione con COMSI (SDI B) ok", "Communication avec CMSI (SDI B) ok"}, {"LON device enabled", "Dispositivo LON attivi", "Dispositif de Lon permis"}, {"LA reset", "LA reset", "LA reset"}, {"MCP FB test off (NEN)", "MCP FB test off (NEN)", "MCP FB test hors (NEN)"}, {"MCP FB on (NEN)", "MCP FB on (NEN)", "MCP FB (NEN)"}, {"MCP FB enable (NEN)", "MCP FB attivo (NEN)", "MCP FB de validation (NEN)"}, {"Fault O/P to FB (Finland)", "Guasto O/P a FB (Finlandia)", "Defaut O / P a FB (Finlande)"}, {"Pager communication ok", "Comunicazione pager ok", "Pager communication ok"}, {"Access enabled (ext)", "Accesso attivato (ext)", "Acces est active (ext)"}, {"Access disabled (ext)", "Accesso disattivato (ext)", "Acces handicapes (ext)"}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"", "", ""}, {"Automatic Evacuation", "Evacuazione automatica", "Evacuation automatique"}, {"Manual Evacuation", "Evacuazione manuale", "Evacuation manuelle"}, {"", "", ""}, {"", "", ""}, {"Evacuation Reset", "Reset evacuazione", "Reinitialiser evacuation"}};
    private static final String[][] LON_ALARM = new String[][]{{"Sounder fault", "Sirena guasta", "faute Sondeur"}, {"Automatic Fire Brigade fault", "Guasto vigili del fuoco", "Automatique faute pompiers"}, {"Fire Protection fault", "Protezione incendio guasto", "Faute protection contre les incendies"}, {"Fault Routing fault", "Routing guasto", "Defaut de routage faute"}, {"Earth fault", "Terra guasta", "Defaut a la terre"}, {"Low Battery fault", "Errore batteria scarica", "Faute de batterie faible"}, {"Mains fault", "Rete guasta", "defaut reseau"}, {"Communication fault", "Comunicazione guasta", "Defaut de communication"}, {"Disabled", "Disattivo", "Desactive"}, {"Charger fault", "Caricabatterie guasto", "defaut chargeur"}, {"Supply fault", "Alimentatore guasto", "Fourniture de defaut"}, {"Fault", "Guasto", "Faute"}, {"MCP Fire Brigade fault", "MCP incendio guasto", "MCP Fire Brigade faute"}, {"Output fault", "Uscita guasta", "Faute de sortie"}, {"Input fault", "Ingresso guasto", "Faute d'entree"}, {"Auxiliary fault", "Guasto ausiliare", "Faute auxiliaire"}, {"3rd Source fault", "Terza fonte guasta", "Faute trois source"}, {"Battery Test fault", "Errore test batteria", "Faute de test de batterie"}, {"Local Evacuation", "Evacuazione locale", "evacuation locale"}, {"Open Network Ring A", "Network Ring A aperto", "Ouvrez reseau en anneau A"}, {"Open Netword Ring B", "Network Ring B aperto", "Ouvrez reseau en anneau B"}, {"Invalid Hardware Revision", "Revisione Hardware invalida", "Revision du materiel non valide"}, {"Invalid OEM Code", "Codice OEM invalido", "Blancs de codes OEM"}, {"Invalid Product Code", "Codice prodotto invalido", "Code de produit non valide"}, {"Invalid Configuration", "Configurazione invalida", "Configuration invalide"}, {"Invalid Software Revision", "Revisione software invalida", "Revision du logiciel non valide"}};
    private static final HashMap<Integer, String> ledEvents = new HashMap();

    static {
        ledEvents.put(19, "led.general.fire.1");
        ledEvents.put(20, "led.general.fire.2");
        ledEvents.put(21, "led.general.processor");
        ledEvents.put(22, "led.general.supply.fault");
        ledEvents.put(23, "led.general.disabled");
        ledEvents.put(24, "led.general.fault");
        ledEvents.put(25, "led.general.supply");
        ledEvents.put(44, "led.general.system.fault");
        ledEvents.put(29, "led.brigade.delay.off");
        ledEvents.put(30, "led.brigade.delay.on");
        ledEvents.put(31, "led.brigade.stop");
        ledEvents.put(32, "led.brigade.fault");
        ledEvents.put(34, "led.brigade.signal");
        ledEvents.put(35, "led.sounder.delay.on");
        ledEvents.put(39, "led.sounder.silence");
        ledEvents.put(40, "led.sounder.fault");
        ledEvents.put(42, "led.sounder.sound");
        ledEvents.put(43, "led.sounder.delay.off");
        ledEvents.put(47, "led.control.test");
        ledEvents.put(48, "led.control.disabled");
        ledEvents.put(50, "led.control.silence.buzzer");
        ledEvents.put(36, "led.all");
        ledEvents.put(37, "led.panel");
    }

    public FP2000() {
        byte[] byArray = new byte[9];
        byArray[0] = -2;
        byArray[1] = -64;
        byArray[8] = -2;
        this.serial_initialization_req = byArray;
        byte[] byArray2 = new byte[41];
        byArray2[0] = -2;
        byArray2[1] = -64;
        byArray2[5] = 6;
        byArray2[6] = 2;
        byArray2[40] = -2;
        this.network_map_resp = byArray2;
        byte[] byArray3 = new byte[11];
        byArray3[0] = -2;
        byArray3[5] = 1;
        byArray3[10] = -2;
        this.access_req = byArray3;
        byte[] byArray4 = new byte[9];
        byArray4[0] = -2;
        byArray4[5] = -122;
        byArray4[8] = -2;
        this.configuration_req = byArray4;
        byte[] byArray5 = new byte[10];
        byArray5[0] = -2;
        byArray5[5] = -118;
        byArray5[9] = -2;
        this.nv_loop_data_req = byArray5;
        byte[] byArray6 = new byte[11];
        byArray6[0] = -2;
        byArray6[5] = -121;
        byArray6[10] = -2;
        this.nv_sensor_data_req = byArray6;
        byte[] byArray7 = new byte[10];
        byArray7[0] = -2;
        byArray7[5] = -120;
        byArray7[9] = -2;
        this.nv_zone_data_req = byArray7;
        byte[] byArray8 = new byte[10];
        byArray8[0] = -2;
        byArray8[5] = -119;
        byArray8[9] = -2;
        this.nv_area_data_req = byArray8;
        byte[] byArray9 = new byte[11];
        byArray9[0] = -2;
        byArray9[5] = -117;
        byArray9[10] = -2;
        this.nv_input_data_req = byArray9;
        byte[] byArray10 = new byte[11];
        byArray10[0] = -2;
        byArray10[5] = -116;
        byArray10[10] = -2;
        this.nv_output_data_req = byArray10;
        byte[] byArray11 = new byte[8];
        byArray11[0] = -2;
        byArray11[1] = 64;
        byArray11[7] = -2;
        this.ACK = byArray11;
        byte[] byArray12 = new byte[8];
        byArray12[0] = -2;
        byArray12[1] = -128;
        byArray12[7] = -2;
        this.NAK = byArray12;
        byte[] byArray13 = new byte[9];
        byArray13[0] = -2;
        byArray13[5] = 47;
        byArray13[8] = -2;
        this.network_watchdog = byArray13;
        byte[] byArray14 = new byte[10];
        byArray14[0] = -2;
        byArray14[5] = 39;
        byArray14[9] = -2;
        this.emulation_cmd_start = byArray14;
        byte[] byArray15 = new byte[10];
        byArray15[0] = -2;
        byArray15[5] = 39;
        byArray15[6] = 1;
        byArray15[9] = -2;
        this.emulation_cmd_stop = byArray15;
        byte[] byArray16 = new byte[12];
        byArray16[0] = -2;
        byArray16[5] = 39;
        byArray16[6] = 3;
        byArray16[11] = -2;
        this.emulation_cmd_key = byArray16;
        byte[] byArray17 = new byte[9];
        byArray17[0] = -2;
        byArray17[5] = -74;
        byArray17[8] = -2;
        this.status_req = byArray17;
        byte[] byArray18 = new byte[11];
        byArray18[0] = -2;
        byArray18[5] = -104;
        byArray18[10] = -2;
        this.v_sensor_data_req = byArray18;
        byte[] byArray19 = new byte[10];
        byArray19[0] = -2;
        byArray19[5] = -103;
        byArray19[9] = -2;
        this.v_zone_data_req = byArray19;
        byte[] byArray20 = new byte[10];
        byArray20[0] = -2;
        byArray20[5] = -102;
        byArray20[9] = -2;
        this.v_area_data_req = byArray20;
        byte[] byArray21 = new byte[9];
        byArray21[0] = -2;
        byArray21[5] = -84;
        byArray21[8] = -2;
        this.time_req = byArray21;
        byte[] byArray22 = new byte[15];
        byArray22[0] = -2;
        byArray22[5] = 44;
        byArray22[14] = -2;
        this.set_time_req = byArray22;
        byte[] byArray23 = new byte[11];
        byArray23[0] = -2;
        byArray23[5] = -97;
        byArray23[10] = -2;
        this.v_input_data_req = byArray23;
        byte[] byArray24 = new byte[11];
        byArray24[0] = -2;
        byArray24[5] = -94;
        byArray24[10] = -2;
        this.v_output_data_req = byArray24;
        this.display = new Display();
        this.loops_num = 0;
        this.areas_num = 0;
        this.start_zone = 0;
        this.end_zone = 0;
        this.inputs_num = 0;
        this.outputs_num = 0;
        this.loops = new HashMap();
        this.zones = new HashMap();
        this.areas = new HashMap();
        this.outputs = new HashMap();
        this.inputs = new HashMap();
        this.reset_list_temp = new Vector();
        this.reset_list = new Vector();
    }

    void monitor(int ioIndex, ioMonitor me) {
        this.prop = new Properties();
        SystemState.ioServersInitializedSet(ioIndex, false);
        SystemState.ioServersSocket[ioIndex] = new Socket();
        this.prop.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.prop.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.prop.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.prop.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.prop.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.prop.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.prop.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.prop.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.prop.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("accesscode")) {
                    try {
                        int ac = Integer.parseInt(value);
                        if (ac < 0 || ac > 9999) {
                            throw new Exception();
                        }
                        this.prop.accessCode = ac;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.prop.serverName + "] - accesscode ignored");
                    }
                } else if (param.equalsIgnoreCase("keypaddisable")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.prop.keypadDisable = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.prop.keypadDisable = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.prop.serverName + "] - keypaddisable ignored");
                    }
                } else if (param.equalsIgnoreCase("controlsdisable")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.prop.controlsDisable = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.prop.controlsDisable = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.prop.serverName + "] - controlsdisable ignored");
                    }
                } else if (param.equalsIgnoreCase("displayhlcolor")) {
                    try {
                        int c2 = Integer.parseInt(value, 16);
                        if (c2 < 0 || c2 > 0xFFFFFF) {
                            throw new Exception();
                        }
                        this.display.dsplHLColor = "" + c2;
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.prop.serverName + "] - displayhlcolor ignored");
                    }
                } else if (param.equalsIgnoreCase("logsize")) {
                    try {
                        int l2 = Integer.parseInt(value);
                        if (l2 < 0) {
                            throw new Exception();
                        }
                        this.prop.logSize = l2;
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.prop.serverName + "] - logsize ignored");
                    }
                }
            }
            ++i2;
        }
        switch (Configuration.language) {
            case 1: {
                this.prop.dateFormat = new SimpleDateFormat("dd MMM HH:mm", Locale.ITALIAN);
                this.language = 1;
                break;
            }
            case 2: {
                this.prop.dateFormat = new SimpleDateFormat("dd MMM HH:mm", Locale.FRENCH);
                this.language = 2;
                break;
            }
            default: {
                this.prop.dateFormat = new SimpleDateFormat("dd MMM HH:mm", Locale.ENGLISH);
                this.language = 0;
            }
        }
        this.loadLogs();
        if (this.prop.guiSupport) {
            PluginsWrapper.register(this.prop.serverName, 32, this);
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            me.dispatcher = true;
            while (!me.quit && this.prop.initialization_status > 0) {
                this.processInitResponse(me, this.read(me));
            }
            if (!me.quit) {
                SystemState.ioServersInitializedSet(ioIndex, true);
                this.ioWrite(true, "connection", "online");
                Logger.log(Logger.Mode.SECURITY, "HSYCO online", this.prop.serverName);
                this.uiSet("log", "HSYCO online");
                try {
                    userCode.IOStartupEvent(ioIndex);
                }
                catch (Exception e5) {
                    hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e5);
                }
                if (ioIndex > 0) {
                    events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
                } else {
                    events.eventsExec("IOSTART", 0, 0, null);
                }
                events.eventsExec("IOSTART" + this.prop.serverName, 0, 0, null);
                this.prop.genEvents = true;
            }
            while (!me.quit) {
                this.processResponse(this.read(me), me);
            }
        }
        catch (Exception e6) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e6.getLocalizedMessage(), this.prop.serverName);
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.prop.serverName + "]");
        this.ioWrite(true, "connection", "offline");
    }

    private void loadLogs() {
        try {
            StringBuilder sb = new StringBuilder();
            this.logs = new Vector(this.prop.logSize);
            String persistentlog = SystemState.varGet("__hsyco__fp2000." + this.prop.serverName + ".log!");
            if (persistentlog != null) {
                int i2 = 0;
                while (i2 < persistentlog.length()) {
                    char c2 = persistentlog.charAt(i2);
                    if (c2 != ';') {
                        sb.append(c2);
                    } else if (i2 + 1 < persistentlog.length() && persistentlog.charAt(i2 + 1) == ';') {
                        sb.append(c2);
                        ++i2;
                    } else {
                        this.logs.add(sb.toString());
                        if (this.logs.size() >= this.prop.logSize) break;
                        sb = new StringBuilder();
                    }
                    ++i2;
                }
                if (this.logs.size() < this.prop.logSize && sb.length() > 0) {
                    this.logs.add(sb.toString());
                }
            }
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "Error loading saved logs", this.prop.serverName);
        }
    }

    private void saveLogs() {
        try {
            StringBuilder persistentlog = new StringBuilder();
            int i2 = 0;
            while (i2 < this.logs.size()) {
                String line = this.logs.get(i2).replace(";", ";;");
                if (line.length() > 0) {
                    if (persistentlog.length() > 0) {
                        persistentlog.append(';');
                    }
                    persistentlog.append(line);
                }
                ++i2;
            }
            SystemState.varSet("__hsyco__fp2000." + this.prop.serverName + ".log!", persistentlog.toString());
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "Error saving logs", this.prop.serverName);
        }
    }

    private Vector<Byte> read(ioMonitor me) {
        Vector<Byte> resp = new Vector<Byte>();
        boolean ntf = false;
        while (!me.quit) {
            byte[] b2 = util.readCommBytes(this.prop.commPort, 1);
            if (b2 == null || b2.length != 1) continue;
            if (b2[0] == -2) {
                if (resp.size() <= 0) continue;
                break;
            }
            if (b2[0] == -3) {
                ntf = true;
                continue;
            }
            if (ntf) {
                resp.add((byte)(b2[0] + 128));
                ntf = false;
                continue;
            }
            resp.add(b2[0]);
        }
        return resp;
    }

    private void processInitResponse(ioMonitor me, Vector<Byte> resp) throws IOException {
        if (resp.size() > 5) {
            this.prop.pkt = (byte)(resp.get(0) & 0x3F);
            if (!FP2000.checksum(resp)) {
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - checksum error", this.prop.serverName);
                this.write(this.NAK);
            }
            if (resp.get(0) == 64) {
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - ACK received", this.prop.serverName);
                if (this.prop.initialization_status == 1 && resp.get(1) == (byte)this.prop.typ) {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Serial initialization acknowledged", this.prop.serverName);
                    this.prop.panelIDAddr = resp.get(3);
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - Connection established - Panel ID Addr: " + (this.prop.panelIDAddr & 0xFF), this.prop.serverName);
                    me.heartbeat = System.currentTimeMillis();
                    this.prop.initialization_status = 2;
                } else if (this.prop.initialization_status == 3 && resp.get(1) == (byte)this.prop.typ) {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Initialization sequence complete", this.prop.serverName);
                    this.access_req[6] = (byte)(this.prop.accessCode >>> 8 & 0xFF);
                    this.access_req[7] = (byte)(this.prop.accessCode & 0xFF);
                    this.write(this.access_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Access request sent", this.prop.serverName);
                    me.heartbeat = System.currentTimeMillis();
                    this.prop.initialization_status = 4;
                }
            } else if (this.prop.initialization_status == 2 && (resp.get(0) & 0xC0) == 192 && resp.get(4) == 10) {
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Network Map Request received", this.prop.serverName);
                this.write(this.network_map_resp);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Network Map sent", this.prop.serverName);
                me.heartbeat = System.currentTimeMillis();
                this.prop.initialization_status = 3;
            } else if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 35) {
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Set up reply received", this.prop.serverName);
                if (this.prop.initialization_status == 4) {
                    if (resp.get(5) == 0) {
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Access granted", this.prop.serverName);
                        this.write(this.configuration_req);
                        me.heartbeat = System.currentTimeMillis();
                        this.prop.initialization_status = 5;
                    } else {
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Access denied", this.prop.serverName);
                        this.prop.accessCode = 0;
                        me.heartbeat = System.currentTimeMillis();
                        this.write(this.status_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Status request sent", this.prop.serverName);
                        this.prop.initialization_status = 17;
                    }
                } else if (this.prop.initialization_status == 7 && resp.get(5) == 19) {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Sensor max addr reached on loop " + (this.nv_sensor_data_req[6] & 0xFF), this.prop.serverName);
                    if (this.loops_iterator.hasNext()) {
                        this.nv_sensor_data_req[6] = (byte)this.loops_iterator.next().idx;
                        this.nv_sensor_data_req[7] = 1;
                        this.write(this.nv_sensor_data_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Sensor data request sent [" + (this.nv_sensor_data_req[6] & 0xFF) + ",1]", this.prop.serverName);
                    } else {
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Loop max addr reached", this.prop.serverName);
                        this.nv_area_data_req[6] = 1;
                        this.write(this.nv_area_data_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Area data request sent [" + (this.nv_area_data_req[6] & 0xFF) + "]", this.prop.serverName);
                        me.heartbeat = System.currentTimeMillis();
                        this.prop.initialization_status = 8;
                    }
                }
            } else if (this.prop.initialization_status == 5 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 6) {
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Configuration received", this.prop.serverName);
                this.loops_num = resp.get(47) & 0xFF;
                this.areas_num = resp.get(50) & 0xFF;
                this.start_zone = resp.get(48);
                this.end_zone = resp.get(49) & 0xFF;
                byte b1 = resp.get(15);
                byte b2 = resp.get(16);
                this.inputs_num = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                b1 = resp.get(17);
                b2 = resp.get(18);
                this.outputs_num = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                this.nv_loop_data_req[6] = 1;
                this.write(this.nv_loop_data_req);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Loop data request sent [1]", this.prop.serverName);
                me.heartbeat = System.currentTimeMillis();
                this.prop.initialization_status = 6;
            } else if (this.prop.initialization_status == 6 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 10) {
                int idx = resp.get(5) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Loop data received [" + idx + "]", this.prop.serverName);
                if ((resp.get(6) & 1) == 1) {
                    this.loops.put(idx, new Loop(idx));
                }
                if ((this.nv_loop_data_req[6] & 0xFF) < this.loops_num) {
                    this.nv_loop_data_req[6] = (byte)(this.nv_loop_data_req[6] + 1);
                    this.write(this.nv_loop_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Loop data request sent [" + (this.nv_loop_data_req[6] & 0xFF) + "]", this.prop.serverName);
                } else if (this.loops.size() > 0) {
                    this.loops_iterator = this.loops.values().iterator();
                    this.nv_sensor_data_req[6] = (byte)this.loops_iterator.next().idx;
                    this.nv_sensor_data_req[7] = 1;
                    this.write(this.nv_sensor_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Sensor data request sent [" + (this.nv_sensor_data_req[6] & 0xFF) + ",1]", this.prop.serverName);
                    me.heartbeat = System.currentTimeMillis();
                    this.prop.initialization_status = 7;
                } else {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - no loops enabled", this.prop.serverName);
                    this.nv_area_data_req[6] = 1;
                    this.write(this.nv_area_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Area data request sent [" + (this.nv_area_data_req[6] & 0xFF) + "]", this.prop.serverName);
                    me.heartbeat = System.currentTimeMillis();
                    this.prop.initialization_status = 8;
                }
            } else if (this.prop.initialization_status == 7 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 7) {
                int loopIdx = resp.get(5) & 0xFF;
                int sensIdx = resp.get(6) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Sensor data received [" + loopIdx + "," + sensIdx + "]", this.prop.serverName);
                if ((resp.get(7) & 1) == 1) {
                    int str1len = resp.get(11) & 0xFF;
                    int str2len = resp.get(12 + str1len) & 0xFF;
                    StringBuilder text1 = new StringBuilder();
                    if (str1len > 0) {
                        int i2 = 12;
                        while (i2 <= 12 + str1len) {
                            text1.append((char)resp.get(i2).byteValue());
                            ++i2;
                        }
                    }
                    StringBuilder text2 = new StringBuilder();
                    if (str2len > 0) {
                        int i3 = 13 + str1len;
                        while (i3 <= 13 + str1len + str2len) {
                            text2.append((char)resp.get(i3).byteValue());
                            ++i3;
                        }
                    }
                    this.loops.get(loopIdx).addSensor(sensIdx, (int)(resp.get(9) & 0xFF), text1.toString(), text2.toString());
                }
                this.nv_sensor_data_req[7] = (byte)(this.nv_sensor_data_req[7] + 1);
                this.write(this.nv_sensor_data_req);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Sensor data request sent [" + (this.nv_sensor_data_req[6] & 0xFF) + "," + (this.nv_sensor_data_req[7] & 0xFF) + "]", this.prop.serverName);
                me.heartbeat = System.currentTimeMillis();
            } else if (this.prop.initialization_status == 8 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 9) {
                int idx = resp.get(5) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Area data received [" + idx + "]", this.prop.serverName);
                if ((resp.get(6) & 1) == 1) {
                    int strlen = resp.get(12) & 0xFF;
                    StringBuilder text = new StringBuilder();
                    if (strlen > 0) {
                        int i4 = 13;
                        while (i4 <= 13 + strlen) {
                            text.append((char)resp.get(i4).byteValue());
                            ++i4;
                        }
                    }
                    this.areas.put(idx, new Area(idx, text.toString()));
                }
                if ((this.nv_area_data_req[6] & 0xFF) < this.areas_num) {
                    this.nv_area_data_req[6] = (byte)(this.nv_area_data_req[6] + 1);
                    this.write(this.nv_area_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Area data request sent [" + (this.nv_area_data_req[6] & 0xFF) + "]", this.prop.serverName);
                } else {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Area max addr reached", this.prop.serverName);
                    this.nv_zone_data_req[6] = this.start_zone;
                    this.write(this.nv_zone_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Zone data request sent [" + (this.nv_zone_data_req[6] & 0xFF) + "]", this.prop.serverName);
                    this.prop.initialization_status = 9;
                }
                me.heartbeat = System.currentTimeMillis();
            } else if (this.prop.initialization_status == 9 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 8) {
                int idx = resp.get(5) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Zone data received [" + idx + "]", this.prop.serverName);
                if ((resp.get(6) & 1) == 1) {
                    int strlen = resp.get(8) & 0xFF;
                    StringBuilder text = new StringBuilder();
                    if (strlen > 0) {
                        int i5 = 9;
                        while (i5 <= 9 + strlen) {
                            text.append((char)resp.get(i5).byteValue());
                            ++i5;
                        }
                    }
                    int area = resp.get(7) & 0xFF;
                    this.zones.put(idx, new Zone(idx, area, text.toString()));
                }
                if ((this.nv_zone_data_req[6] & 0xFF) < this.end_zone) {
                    this.nv_zone_data_req[6] = (byte)(this.nv_zone_data_req[6] + 1);
                    this.write(this.nv_zone_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Zone data request sent [" + (this.nv_zone_data_req[6] & 0xFF) + "]", this.prop.serverName);
                } else {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Zone max addr reached", this.prop.serverName);
                    this.nv_input_data_req[6] = 0;
                    this.nv_input_data_req[7] = 1;
                    this.write(this.nv_input_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Input data request sent [1]", this.prop.serverName);
                    this.prop.initialization_status = 10;
                }
                me.heartbeat = System.currentTimeMillis();
            } else if (this.prop.initialization_status == 10 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 11) {
                byte b1 = resp.get(5);
                byte b2 = resp.get(6);
                int idx = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Input data received [" + idx + "]", this.prop.serverName);
                int strlen = resp.get(12) & 0xFF;
                StringBuilder text = new StringBuilder();
                if (strlen > 0) {
                    int i6 = 13;
                    while (i6 <= 13 + strlen) {
                        text.append((char)resp.get(i6).byteValue());
                        ++i6;
                    }
                }
                this.inputs.put(idx, new Input(idx, text.toString()));
                if (idx < this.inputs_num) {
                    this.nv_input_data_req[6] = (byte)(++idx >>> 8);
                    this.nv_input_data_req[7] = (byte)idx;
                    this.write(this.nv_input_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Input data request sent [" + idx + "]", this.prop.serverName);
                } else {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Input max addr reached", this.prop.serverName);
                    this.nv_output_data_req[6] = 0;
                    this.nv_output_data_req[7] = 1;
                    this.write(this.nv_output_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Output data request sent [1]", this.prop.serverName);
                    this.prop.initialization_status = 11;
                }
            } else if (this.prop.initialization_status == 11 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 12) {
                byte b1 = resp.get(5);
                byte b2 = resp.get(6);
                int idx = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Output data received [" + idx + "]", this.prop.serverName);
                int strlen = resp.get(13) & 0xFF;
                StringBuilder text = new StringBuilder();
                if (strlen > 0) {
                    int i7 = 14;
                    while (i7 <= 14 + strlen) {
                        text.append((char)resp.get(i7).byteValue());
                        ++i7;
                    }
                }
                this.outputs.put(idx, new Output(idx, text.toString()));
                if (idx < this.outputs_num) {
                    this.nv_output_data_req[6] = (byte)(++idx >>> 8);
                    this.nv_output_data_req[7] = (byte)idx;
                    this.write(this.nv_output_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Output data request sent [" + idx + "]", this.prop.serverName);
                } else {
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Output max addr reached", this.prop.serverName);
                    this.loops_iterator = this.loops.values().iterator();
                    if (this.loops_iterator.hasNext()) {
                        Loop l2 = this.loops_iterator.next();
                        this.sensors_iterator = l2.sensors.values().iterator();
                        if (this.sensors_iterator.hasNext()) {
                            Sensor s = this.sensors_iterator.next();
                            this.v_sensor_data_req[6] = (byte)l2.idx;
                            this.v_sensor_data_req[7] = (byte)s.idx;
                            this.write(this.v_sensor_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Sensor Data request sent [" + l2.idx + "," + s.idx + "]", this.prop.serverName);
                            this.prop.initialization_status = 12;
                        }
                    } else {
                        this.zones_iterator = this.zones.values().iterator();
                        if (this.zones_iterator.hasNext()) {
                            Zone z = this.zones_iterator.next();
                            this.v_zone_data_req[6] = (byte)z.idx;
                            this.write(this.v_zone_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Zone Data request sent [" + z.idx + "]", this.prop.serverName);
                            this.prop.initialization_status = 13;
                        } else {
                            this.areas_iterator = this.areas.values().iterator();
                            if (this.areas_iterator.hasNext()) {
                                Area a2 = this.areas_iterator.next();
                                this.v_area_data_req[6] = (byte)a2.idx;
                                this.write(this.v_area_data_req);
                                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Area Data request sent [" + a2.idx + "]", this.prop.serverName);
                                this.prop.initialization_status = 14;
                            } else {
                                this.inputs_iterator = this.inputs.values().iterator();
                                if (this.inputs_iterator.hasNext()) {
                                    Input i8 = this.inputs_iterator.next();
                                    this.v_input_data_req[6] = (byte)(i8.idx >>> 8);
                                    this.v_input_data_req[7] = (byte)i8.idx;
                                    this.write(this.v_input_data_req);
                                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Input Data request sent [" + i8.idx + "]", this.prop.serverName);
                                    this.prop.initialization_status = 15;
                                } else {
                                    this.outputs_iterator = this.outputs.values().iterator();
                                    if (this.outputs_iterator.hasNext()) {
                                        Output o2 = this.outputs_iterator.next();
                                        this.v_output_data_req[6] = (byte)(o2.idx >>> 8);
                                        this.v_output_data_req[7] = (byte)o2.idx;
                                        this.write(this.v_output_data_req);
                                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data request sent [" + o2.idx + "]", this.prop.serverName);
                                        this.prop.initialization_status = 16;
                                    } else {
                                        this.write(this.status_req);
                                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Status request sent", this.prop.serverName);
                                        this.prop.initialization_status = 17;
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (this.prop.initialization_status == 12 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 24) {
                int loopIdx = resp.get(5) & 0xFF;
                int sensIdx = resp.get(6) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Sensor Data received [" + loopIdx + "," + sensIdx + "]", this.prop.serverName);
                ((Sensor)this.loops.get(loopIdx).sensors.get(sensIdx)).setStatus(resp);
                if (this.sensors_iterator.hasNext()) {
                    Sensor s = this.sensors_iterator.next();
                    this.v_sensor_data_req[7] = (byte)s.idx;
                    this.write(this.v_sensor_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Sensor Data request sent [" + (this.v_sensor_data_req[6] & 0xFF) + "," + s.idx + "]", this.prop.serverName);
                } else if (this.loops_iterator.hasNext()) {
                    Loop l3 = this.loops_iterator.next();
                    this.sensors_iterator = l3.sensors.values().iterator();
                    if (this.sensors_iterator.hasNext()) {
                        Sensor s = this.sensors_iterator.next();
                        this.v_sensor_data_req[6] = (byte)l3.idx;
                        this.v_sensor_data_req[7] = (byte)s.idx;
                        this.write(this.v_sensor_data_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Sensor Data request sent [" + l3.idx + "," + s.idx + "]", this.prop.serverName);
                    }
                } else {
                    this.zones_iterator = this.zones.values().iterator();
                    if (this.zones_iterator.hasNext()) {
                        Zone z = this.zones_iterator.next();
                        this.v_zone_data_req[6] = (byte)z.idx;
                        this.write(this.v_zone_data_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Zone Data request sent [" + z.idx + "]", this.prop.serverName);
                        this.prop.initialization_status = 13;
                    } else {
                        this.areas_iterator = this.areas.values().iterator();
                        if (this.areas_iterator.hasNext()) {
                            Area a3 = this.areas_iterator.next();
                            this.v_area_data_req[6] = (byte)a3.idx;
                            this.write(this.v_area_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Area Data request sent [" + a3.idx + "]", this.prop.serverName);
                            this.prop.initialization_status = 14;
                        } else {
                            this.inputs_iterator = this.inputs.values().iterator();
                            if (this.inputs_iterator.hasNext()) {
                                Input i9 = this.inputs_iterator.next();
                                this.v_input_data_req[6] = (byte)(i9.idx >>> 8);
                                this.v_input_data_req[7] = (byte)i9.idx;
                                this.write(this.v_input_data_req);
                                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Input Data request sent [" + i9.idx + "]", this.prop.serverName);
                                this.prop.initialization_status = 15;
                            } else {
                                this.outputs_iterator = this.outputs.values().iterator();
                                if (this.outputs_iterator.hasNext()) {
                                    Output o3 = this.outputs_iterator.next();
                                    this.v_output_data_req[6] = (byte)(o3.idx >>> 8);
                                    this.v_output_data_req[7] = (byte)o3.idx;
                                    this.write(this.v_output_data_req);
                                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data request sent [" + o3.idx + "]", this.prop.serverName);
                                    this.prop.initialization_status = 16;
                                } else {
                                    this.write(this.status_req);
                                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Status request sent", this.prop.serverName);
                                    this.prop.initialization_status = 17;
                                }
                            }
                        }
                    }
                }
                me.heartbeat = System.currentTimeMillis();
            } else if (this.prop.initialization_status == 13 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 25) {
                int idx = resp.get(5) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Zone Data received [" + idx + "]", this.prop.serverName);
                this.zones.get(idx).setStatus(resp);
                if (this.zones_iterator.hasNext()) {
                    Zone z = this.zones_iterator.next();
                    this.v_zone_data_req[6] = (byte)z.idx;
                    this.write(this.v_zone_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Zone Data request sent [" + z.idx + "]", this.prop.serverName);
                } else {
                    this.areas_iterator = this.areas.values().iterator();
                    if (this.areas_iterator.hasNext()) {
                        Area a4 = this.areas_iterator.next();
                        this.v_area_data_req[6] = (byte)a4.idx;
                        this.write(this.v_area_data_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Area Data request sent [" + a4.idx + "]", this.prop.serverName);
                        this.prop.initialization_status = 14;
                    } else {
                        this.inputs_iterator = this.inputs.values().iterator();
                        if (this.inputs_iterator.hasNext()) {
                            Input i10 = this.inputs_iterator.next();
                            this.v_input_data_req[6] = (byte)(i10.idx >>> 8);
                            this.v_input_data_req[7] = (byte)i10.idx;
                            this.write(this.v_input_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Input Data request sent [" + i10.idx + "]", this.prop.serverName);
                            this.prop.initialization_status = 15;
                        } else {
                            this.outputs_iterator = this.outputs.values().iterator();
                            if (this.outputs_iterator.hasNext()) {
                                Output o4 = this.outputs_iterator.next();
                                this.v_output_data_req[6] = (byte)(o4.idx >>> 8);
                                this.v_output_data_req[7] = (byte)o4.idx;
                                this.write(this.v_output_data_req);
                                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data request sent [" + o4.idx + "]", this.prop.serverName);
                                this.prop.initialization_status = 16;
                            } else {
                                this.write(this.status_req);
                                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Status request sent", this.prop.serverName);
                                this.prop.initialization_status = 17;
                            }
                        }
                    }
                }
                me.heartbeat = System.currentTimeMillis();
            } else if (this.prop.initialization_status == 14 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 26) {
                int idx = resp.get(5) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Area Data received [" + idx + "]", this.prop.serverName);
                this.areas.get(idx).setStatus(resp);
                if (this.areas_iterator.hasNext()) {
                    Area a5 = this.areas_iterator.next();
                    this.v_area_data_req[6] = (byte)a5.idx;
                    this.write(this.v_area_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Area Data request sent [" + a5.idx + "]", this.prop.serverName);
                } else {
                    this.inputs_iterator = this.inputs.values().iterator();
                    if (this.inputs_iterator.hasNext()) {
                        Input i11 = this.inputs_iterator.next();
                        this.v_input_data_req[6] = (byte)(i11.idx >>> 8);
                        this.v_input_data_req[7] = (byte)i11.idx;
                        this.write(this.v_input_data_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Input Data request sent [" + i11.idx + "]", this.prop.serverName);
                        this.prop.initialization_status = 15;
                    } else {
                        this.outputs_iterator = this.outputs.values().iterator();
                        if (this.outputs_iterator.hasNext()) {
                            Output o5 = this.outputs_iterator.next();
                            this.v_output_data_req[6] = (byte)(o5.idx >>> 8);
                            this.v_output_data_req[7] = (byte)o5.idx;
                            this.write(this.v_output_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data request sent [" + o5.idx + "]", this.prop.serverName);
                            this.prop.initialization_status = 16;
                        } else {
                            this.write(this.status_req);
                            Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Status request sent", this.prop.serverName);
                            this.prop.initialization_status = 17;
                        }
                    }
                }
                me.heartbeat = System.currentTimeMillis();
            } else if (this.prop.initialization_status == 15 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 31) {
                byte b1 = resp.get(5);
                byte b2 = resp.get(6);
                int idx = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Input Data received [" + idx + "]", this.prop.serverName);
                this.inputs.get(idx).setStatus(resp.get(7).byteValue());
                if (this.inputs_iterator.hasNext()) {
                    Input i12 = this.inputs_iterator.next();
                    this.v_input_data_req[6] = (byte)(i12.idx >>> 8);
                    this.v_input_data_req[7] = (byte)i12.idx;
                    this.write(this.v_input_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Input Data request sent [" + i12.idx + "]", this.prop.serverName);
                    this.prop.initialization_status = 15;
                } else {
                    this.outputs_iterator = this.outputs.values().iterator();
                    if (this.outputs_iterator.hasNext()) {
                        Output o6 = this.outputs_iterator.next();
                        this.v_output_data_req[6] = (byte)(o6.idx >>> 8);
                        this.v_output_data_req[7] = (byte)o6.idx;
                        this.write(this.v_output_data_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data request sent [" + o6.idx + "]", this.prop.serverName);
                        this.prop.initialization_status = 16;
                    } else {
                        this.write(this.status_req);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Status request sent", this.prop.serverName);
                        this.prop.initialization_status = 17;
                    }
                }
                me.heartbeat = System.currentTimeMillis();
            } else if (this.prop.initialization_status == 16 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 34) {
                byte b1 = resp.get(5);
                byte b2 = resp.get(6);
                int idx = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data received [" + idx + "]", this.prop.serverName);
                this.outputs.get(idx).setStatus(resp.get(7).byteValue());
                if (this.outputs_iterator.hasNext()) {
                    Output o7 = this.outputs_iterator.next();
                    this.v_output_data_req[6] = (byte)(o7.idx >>> 8);
                    this.v_output_data_req[7] = (byte)o7.idx;
                    this.write(this.v_output_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data request sent [" + o7.idx + "]", this.prop.serverName);
                    this.prop.initialization_status = 16;
                } else {
                    this.write(this.status_req);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Status request sent", this.prop.serverName);
                    this.prop.initialization_status = 17;
                }
            } else if ((resp.get(0) & 0xC0) == 0 && (resp.get(4) == 54 || resp.get(4) == 28)) {
                this.processResponse(resp, me);
                if (this.prop.initialization_status == 17) {
                    this.write(this.emulation_cmd_start);
                    Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Emulation command (Start) sent", this.prop.serverName);
                    this.prop.initialization_status = 18;
                }
            } else if (this.prop.initialization_status == 18 && (resp.get(0) & 0xC0) == 0 && resp.get(4) == 39) {
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Emulation Command received", this.prop.serverName);
                if (resp.get(5) == 2) {
                    this.ioWrite(this.prop.genEvents, "emulation", "1");
                    this.prop.emulation = true;
                } else {
                    this.ioWrite(this.prop.genEvents, "emulation", "0");
                    this.prop.emulation = false;
                }
                this.prop.initialization_status = 0;
            } else if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 47) {
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Watchdog received", this.prop.serverName);
                if (this.prop.initialization_status != 1) {
                    try {
                        this.write(this.network_watchdog);
                        Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Watchdog sent", this.prop.serverName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Unknown message: " + (resp.get(4) & 0xFF) + ", " + (resp.get(5) & 0xFF), this.prop.serverName);
                if (this.prop.initialization_status != 1) {
                    this.write(this.ACK);
                }
            }
        }
    }

    private boolean processResponse(Vector<Byte> resp, ioMonitor me) {
        byte b1;
        if (!FP2000.checksum(resp)) {
            Logger.log(Logger.Mode.VERBOSE, "processResponse - checksum error", this.prop.serverName);
            try {
                this.write(this.NAK);
                Logger.log(Logger.Mode.VERBOSE, "processResponse - NAK sent", this.prop.serverName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        this.prop.pkt = (byte)(resp.get(0) & 0x3F);
        if (resp.get(0) == -128) {
            Logger.log(Logger.Mode.VERBOSE, "processResponse - NAK received", this.prop.serverName);
            return false;
        }
        if (resp.get(0) == 64) {
            Logger.log(Logger.Mode.VERBOSE, "processResponse - ACK received", this.prop.serverName);
            return true;
        }
        if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 47) {
            Logger.log(Logger.Mode.VERBOSE, "processResponse - Watchdog received", this.prop.serverName);
            me.heartbeat = System.currentTimeMillis();
            try {
                this.write(this.network_watchdog);
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Watchdog sent", this.prop.serverName);
            }
            catch (IOException e2) {
                return false;
            }
            return true;
        }
        if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 39) {
            Logger.log(Logger.Mode.VERBOSE, "processResponse - Emulation Command received", this.prop.serverName);
            if (resp.get(5) == 2) {
                this.ioWrite(this.prop.genEvents, "emulation", "1");
                this.prop.emulation = true;
            } else if (resp.get(5) == 4) {
                int i2 = 6;
                while (i2 < resp.size() - 2) {
                    if (resp.get(i2) == 27) {
                        if (resp.get(++i2) == 89) {
                            byte r = resp.get(++i2);
                            byte c2 = resp.get(++i2);
                            this.display.setCursor(r, c2);
                        } else if (resp.get(i2) == 75) {
                            this.display.clearToEndOfLine();
                        } else if (resp.get(i2) == 43) {
                            this.display.clearScreen();
                        } else if (resp.get(i2) != -128 && resp.get(i2) != 124 && resp.get(i2) != 63) {
                            if (resp.get(i2) == 126) {
                                ++i2;
                            } else if (resp.get(i2) == 94) {
                                i2 += 4;
                            } else if (resp.get(i2) == 37) {
                                i2 += 7;
                            } else if (resp.get(i2) == 38) {
                                i2 += 7;
                            } else if (resp.get(i2) == 71) {
                                byte attr = resp.get(++i2);
                                this.display.setAttribute(attr);
                            } else {
                                i2 = resp.get(i2) == 96 ? ++i2 : (resp.get(i2) == 64 ? ++i2 : (i2 += 8));
                            }
                        }
                    } else {
                        this.display.setChar(resp.get(i2));
                    }
                    ++i2;
                }
                this.display.print();
            } else if (resp.get(5) == 5) {
                if (this.prop.emulation) {
                    try {
                        this.write(this.emulation_cmd_start);
                    }
                    catch (IOException e3) {
                        this.ioWrite(this.prop.genEvents, "emulation", "0");
                        this.prop.emulation = false;
                        return false;
                    }
                } else {
                    this.ioWrite(this.prop.genEvents, "emulation", "0");
                }
                return true;
            }
        } else if ((resp.get(0) & 0xC0) == 0 && (resp.get(4) == 54 || resp.get(4) == 28)) {
            Logger.log(Logger.Mode.VERBOSE, "processResponse - Status received [" + (resp.get(4) & 0xFF) + "]", this.prop.serverName);
            b1 = resp.get(5);
            byte b2 = resp.get(6);
            int val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            if (this.prop.status_event_count != val) {
                this.prop.status_event_count = val;
                this.ioWrite(this.prop.genEvents, "status.event.count", "" + val);
            }
            b1 = resp.get(7);
            b2 = resp.get(8);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            if (this.prop.status_alarm_count != val) {
                this.prop.status_alarm_count = val;
                this.ioWrite(this.prop.genEvents, "status.alarm.count", "" + val);
            }
            b1 = resp.get(9);
            b2 = resp.get(10);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            if (this.prop.status_fault_count != val) {
                this.prop.status_fault_count = val;
                this.ioWrite(this.prop.genEvents, "status.fault.count", "" + val);
            }
            b1 = resp.get(11);
            b2 = resp.get(12);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            if (this.prop.status_condition_count != val) {
                this.prop.status_condition_count = val;
                this.ioWrite(this.prop.genEvents, "status.condition.count", "" + val);
            }
            b1 = resp.get(13);
            b2 = resp.get(14);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            if (this.prop.status_coincidence_count != val) {
                this.prop.status_coincidence_count = val;
                this.ioWrite(this.prop.genEvents, "status.coincidence.count", "" + val);
            }
            b1 = resp.get(15);
            b2 = resp.get(16);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            if (this.prop.status_isolated_count != val) {
                this.prop.status_isolated_count = val;
                this.ioWrite(this.prop.genEvents, "status.isolated.count", "" + val);
            }
            b1 = resp.get(17);
            b2 = resp.get(18);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            if (this.prop.status_detector_count != val) {
                this.prop.status_detector_count = val;
                this.ioWrite(this.prop.genEvents, "status.detector.count", "" + val);
            }
            for (int l2 : ledEvents.keySet()) {
                byte b3 = resp.get(l2);
                if (b3 == 0) {
                    this.ioWrite(this.prop.genEvents, ledEvents.get(l2), "off");
                    continue;
                }
                if (b3 == 1) {
                    this.ioWrite(this.prop.genEvents, ledEvents.get(l2), "on");
                    continue;
                }
                if (b3 != 2) continue;
                this.ioWrite(this.prop.genEvents, ledEvents.get(l2), "blink");
            }
            if (resp.get(4) == 28) {
                b1 = resp.get(51);
                b2 = resp.get(52);
                int evClass = resp.get(53) & 0xFF;
                int evType = resp.get(54) & 0xFF;
                int evStatus = resp.get(55) & 0xFF;
                int evYear = resp.get(56) & 0xFF;
                evYear = evYear <= 93 ? (evYear += 2000) : (evYear += 1900);
                int evMonth = resp.get(57) & 0xFF;
                int evDay = resp.get(58) & 0xFF;
                int evHour = resp.get(59) & 0xFF;
                int evMin = resp.get(60) & 0xFF;
                int evSec = resp.get(61) & 0xFF;
                b1 = resp.get(62);
                b2 = resp.get(63);
                int evCount = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                b1 = resp.get(64);
                b2 = resp.get(65);
                b1 = resp.get(66);
                b2 = resp.get(67);
                int evPar1 = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                int evPar2 = resp.get(68) & 0xFF;
                int evPar3 = resp.get(69) & 0xFF;
                int evPar4 = resp.get(70) & 0xFF;
                int evPar5 = resp.get(71) & 0xFF;
                int evPar6 = resp.get(72) & 0xFF;
                int str1len = resp.get(74) & 0xFF;
                int str2len = resp.get(75 + str1len) & 0xFF;
                StringBuilder evText1 = new StringBuilder();
                if (str1len > 0) {
                    int i3 = 75;
                    while (i3 <= 75 + str1len) {
                        evText1.append((char)resp.get(i3).byteValue());
                        ++i3;
                    }
                }
                StringBuilder evText2 = new StringBuilder();
                if (str2len > 0) {
                    int i4 = 76 + str1len;
                    while (i4 <= 76 + str1len + str2len) {
                        evText2.append((char)resp.get(i4).byteValue());
                        ++i4;
                    }
                }
                if (evCount != this.prop.last_event_num) {
                    this.prop.last_event_num = evCount;
                    StringBuilder ev = new StringBuilder();
                    StringBuilder evUI = new StringBuilder();
                    ev.append(evCount).append(",");
                    ev.append(evYear).append("/").append(evMonth).append("/").append(evDay);
                    ev.append(",");
                    ev.append(evHour).append(":").append(evMin).append(":").append(evSec);
                    ev.append(",");
                    String eventClass = null;
                    if (evClass == 0) {
                        ev.append(ACTION[this.language]);
                        evUI.append(ACTION[this.language]);
                        eventClass = "action";
                    } else if (evClass == 1) {
                        ev.append(FIRE[this.language]);
                        evUI.append(FIRE[this.language]);
                        eventClass = "fire";
                    } else if (evClass == 2) {
                        ev.append(FAULT[this.language]);
                        evUI.append(FAULT[this.language]);
                        eventClass = "fault";
                    } else if (evClass == 3) {
                        ev.append(CONDITION[this.language]);
                        evUI.append(CONDITION[this.language]);
                        eventClass = "condition";
                    } else {
                        ev.append(UNKNOWN[this.language]);
                        evUI.append(UNKNOWN[this.language]);
                    }
                    ev.append(",");
                    evUI.append(" - ");
                    if (evType == 0 || evType == 3) {
                        Loop l3;
                        if ((evPar1 & 1) == 1) {
                            ev.append("Fire;");
                            evUI.append("Fire;");
                        }
                        if ((evPar1 >>> 1 & 1) == 1) {
                            ev.append("No communication;");
                            evUI.append("No communication;");
                        }
                        if ((evPar1 >>> 2 & 1) == 1) {
                            ev.append("Fault;");
                            evUI.append("Fault;");
                        }
                        if ((evPar1 >>> 3 & 1) == 1) {
                            ev.append("Disabled;");
                            evUI.append("Disabled;");
                        }
                        if ((evPar1 >>> 4 & 1) == 1) {
                            ev.append("Wrong type;");
                            evUI.append("Wrong type;");
                        }
                        if ((evPar1 >>> 5 & 1) == 1) {
                            ev.append("Double address;");
                            evUI.append("Double address;");
                        }
                        if ((evPar1 >>> 6 & 1) == 1) {
                            ev.append("Pre condition;");
                            evUI.append("Pre condition;");
                        }
                        if ((evPar1 >>> 7 & 1) == 1) {
                            ev.append("Maintenance;");
                            evUI.append("Maintenance;");
                        }
                        if ((evPar1 >>> 8 & 1) == 1) {
                            ev.append("No type");
                            evUI.append("No type");
                        }
                        if ((evPar1 >>> 9 & 1) == 1) {
                            ev.append("Enabled;");
                            evUI.append("Enabled;");
                        }
                        if ((evPar1 >>> 10 & 1) == 1) {
                            ev.append("Two set;");
                            evUI.append("Two set;");
                        }
                        if ((evPar1 >>> 11 & 1) == 1) {
                            ev.append("7 Segment;");
                            evUI.append("7 Segment;");
                        }
                        if ((evPar1 >>> 12 & 1) == 1) {
                            ev.append("LED;");
                            evUI.append("LED;");
                        }
                        if ((evPar1 >>> 13 & 1) == 1) {
                            ev.append("7 Segment continuous;");
                            evUI.append("7 Segment continuous;");
                        }
                        if ((evPar1 >>> 14 & 1) == 1) {
                            ev.append("Flag;");
                            evUI.append("Flag;");
                        }
                        if ((evPar1 >>> 15 & 1) == 1) {
                            ev.append("Alarm pending;");
                            evUI.append("Alarm pending;");
                        }
                        ev.deleteCharAt(ev.length() - 1);
                        evUI.deleteCharAt(evUI.length() - 1);
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        ev.append(LOOP[this.language]).append(" = ").append(evPar2);
                        ev.append(",");
                        ev.append(SENSOR[this.language]).append(" = ").append(evPar3);
                        ev.append(",");
                        ev.append(SENSOR_TYPE[this.language]).append(" = ").append(evPar4);
                        ev.append(",");
                        ev.append(ZONE[this.language]).append(" = ").append(evPar5);
                        ev.append(",");
                        ev.append(AREA[this.language]).append(" = ").append(evPar6);
                        ev.append(",");
                        if (evType == 0) {
                            ev.append(SENSOR_SOAK[this.language]);
                        } else {
                            ev.append(SENSOR[this.language]);
                        }
                        ev.append(",");
                        if (this.loops.containsKey(evPar2)) {
                            l3 = this.loops.get(evPar2);
                        } else {
                            l3 = new Loop(evPar2);
                            this.loops.put(evPar2, l3);
                        }
                        if (l3.sensors.containsKey(evPar3)) {
                            ((Sensor)l3.sensors.get(evPar3)).setAlarm(evPar1);
                        } else {
                            Sensor s = new Sensor(evPar3, evPar2, evPar5, null, null);
                            l3.sensors.put(evPar3, s);
                            s.setAlarm(evPar1);
                        }
                        try {
                            this.v_sensor_data_req[6] = (byte)evPar2;
                            this.v_sensor_data_req[7] = (byte)evPar3;
                            this.write(this.v_sensor_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Sensor Data request sent [" + evPar2 + "," + evPar3 + "]", this.prop.serverName);
                            this.reset_list_temp.add((byte[])this.v_sensor_data_req.clone());
                        }
                        catch (IOException s) {}
                    } else if (evType == 1) {
                        if ((evPar1 & 1) == 1) {
                            ev.append("Fire;");
                            evUI.append("Fire;");
                        }
                        if ((evPar1 >>> 1 & 1) == 1) {
                            ev.append("Fault;");
                            evUI.append("Fault;");
                        }
                        if ((evPar1 >>> 2 & 1) == 1) {
                            ev.append("Coincidence;");
                            evUI.append("Coincidence;");
                        }
                        if ((evPar1 >>> 3 & 1) == 1) {
                            ev.append("Isolated;");
                            evUI.append("Isolated;");
                        }
                        if ((evPar1 >>> 4 & 1) == 1) {
                            ev.append("Condition;");
                            evUI.append("Condition;");
                        }
                        if ((evPar1 >>> 5 & 1) == 1) {
                            ev.append("Enabled;");
                            evUI.append("Enabled;");
                        }
                        if ((evPar1 >>> 6 & 1) == 1) {
                            ev.append("Area Action;");
                            evUI.append("Area Action;");
                        }
                        if ((evPar1 >>> 7 & 1) == 1) {
                            ev.append("Test;");
                            evUI.append("Test;");
                        }
                        if ((evPar1 >>> 8 & 1) == 1) {
                            ev.append("Pre warning");
                            evUI.append("Pre warning");
                        }
                        if ((evPar1 >>> 9 & 1) == 1) {
                            ev.append("Sounder Test;");
                            evUI.append("Sounder Test;");
                        }
                        if ((evPar1 >>> 10 & 1) == 1) {
                            ev.append("Sounder Evacuation;");
                            evUI.append("Sounder Evacuation;");
                        }
                        if ((evPar1 >>> 11 & 1) == 1) {
                            ev.append("Security alarm;");
                            evUI.append("Security alarm;");
                        }
                        if ((evPar1 >>> 12 & 1) == 1) {
                            ev.append("Sounder disable;");
                            evUI.append("Sounder disable;");
                        }
                        ev.deleteCharAt(ev.length() - 1);
                        evUI.deleteCharAt(evUI.length() - 1);
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        ev.append(AREA[this.language]).append(" = ").append(evPar2);
                        ev.append(",");
                        if ((evPar1 >>> 6 & 1) == 1) {
                            ev.append(ACTION[this.language]).append(" = ");
                            if (evPar3 == 0) {
                                ev.append("Sounder off");
                            } else if (evPar3 == 1) {
                                ev.append("Sounder on");
                            } else if (evPar3 == 2) {
                                ev.append("Sounder Test on");
                            } else if (evPar3 == 3) {
                                ev.append("Sounder silenced");
                            } else if (evPar3 == 4) {
                                ev.append("Sounder Test off");
                            } else if (evPar3 == 5) {
                                ev.append("Fire brigade off");
                            } else if (evPar3 == 6) {
                                ev.append("Fire brigade on");
                            } else if (evPar3 == 7) {
                                ev.append("Fire brigade Test on");
                            } else if (evPar3 == 8) {
                                ev.append("Fire brigade stopped");
                            } else if (evPar3 == 9) {
                                ev.append("Fire brigade Test off");
                            } else if (evPar3 == 10) {
                                ev.append("Fault Routing off");
                            } else if (evPar3 == 11) {
                                ev.append("Fault Routing on");
                            } else if (evPar3 == 12) {
                                ev.append("Fault Routing Test on");
                            } else if (evPar3 == 13) {
                                ev.append("Fault Routing stopped");
                            } else if (evPar3 == 14) {
                                ev.append("Fault Routing Test off");
                            } else if (evPar3 == 15) {
                                ev.append("Fire Protection off");
                            } else if (evPar3 == 16) {
                                ev.append("Fire Protection on");
                            } else if (evPar3 == 17) {
                                ev.append("Fire Protection Test on");
                            } else if (evPar3 == 18) {
                                ev.append("Fire Protection stopped");
                            } else if (evPar3 == 19) {
                                ev.append("Fire Protection Test off");
                            }
                        }
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(AREA[this.language]);
                        ev.append(",");
                        if (this.areas.containsKey(evPar2)) {
                            this.areas.get(evPar2).setAlarm(evPar1);
                        } else {
                            Area a2 = new Area(evPar2, null);
                            this.areas.put(evPar2, a2);
                            a2.setAlarm(evPar1);
                        }
                        try {
                            this.v_area_data_req[6] = (byte)evPar2;
                            this.write(this.v_area_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Area Data request sent [" + evPar2 + "]", this.prop.serverName);
                            this.reset_list_temp.add((byte[])this.v_area_data_req.clone());
                        }
                        catch (IOException a2) {}
                    } else if (evType == 2) {
                        if ((evPar1 & 1) == 1) {
                            ev.append("MCP Fire;");
                            evUI.append("MCP Fire;");
                        }
                        if ((evPar1 >>> 1 & 1) == 1) {
                            ev.append("Fault;");
                            evUI.append("Fault;");
                        }
                        if ((evPar1 >>> 2 & 1) == 1) {
                            ev.append("Coincidence;");
                            evUI.append("Coincidence;");
                        }
                        if ((evPar1 >>> 3 & 1) == 1) {
                            ev.append("Isolated;");
                            evUI.append("Isolated;");
                        }
                        if ((evPar1 >>> 4 & 1) == 1) {
                            ev.append("Test;");
                            evUI.append("Test;");
                        }
                        if ((evPar1 >>> 5 & 1) == 1) {
                            ev.append("Condition;");
                            evUI.append("Condition;");
                        }
                        if ((evPar1 >>> 6 & 1) == 1) {
                            ev.append("Enabled;");
                            evUI.append("Enabled;");
                        }
                        if ((evPar1 >>> 7 & 1) == 1) {
                            ev.append("Auto fire;");
                            evUI.append("Auto fire;");
                        }
                        if ((evPar1 >>> 8 & 1) == 1) {
                            ev.append("Zone Action;");
                            evUI.append("Zone Action;");
                        }
                        if ((evPar1 >>> 9 & 1) == 1) {
                            ev.append("Maintenance");
                            evUI.append("Maintenance");
                        }
                        if ((evPar1 >>> 10 & 1) == 1) {
                            ev.append("Fire test;");
                            evUI.append("Fire test;");
                        }
                        if ((evPar1 >>> 11 & 1) == 1) {
                            ev.append("Sounder test;");
                            evUI.append("Sounder test;");
                        }
                        if ((evPar1 >>> 12 & 1) == 1) {
                            ev.append("Sounder disabled;");
                            evUI.append("Sounder disabled;");
                        }
                        if ((evPar1 >>> 13 & 1) == 1) {
                            ev.append("Pre warning;");
                            evUI.append("Pre warning;");
                        }
                        ev.deleteCharAt(ev.length() - 1);
                        evUI.deleteCharAt(evUI.length() - 1);
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        ev.append(ZONE[this.language]).append(" = ").append(evPar2);
                        ev.append(",");
                        if ((evPar1 >>> 8 & 1) == 1) {
                            ev.append(ACTION[this.language]).append(" = ");
                            if (evPar3 == 0) {
                                ev.append("Sounder off");
                            } else if (evPar3 == 1) {
                                ev.append("Sounder on");
                            } else if (evPar3 == 2) {
                                ev.append("Sounder Test on");
                            } else if (evPar3 == 3) {
                                ev.append("Sounder silenced");
                            } else if (evPar3 == 4) {
                                ev.append("Sounder Test off");
                            } else if (evPar3 == 5) {
                                ev.append("Fire brigade off");
                            } else if (evPar3 == 6) {
                                ev.append("Fire brigade on");
                            } else if (evPar3 == 7) {
                                ev.append("Fire brigade Test on");
                            } else if (evPar3 == 8) {
                                ev.append("Fire brigade stopped");
                            } else if (evPar3 == 9) {
                                ev.append("Fire brigade Test off");
                            } else if (evPar3 == 10) {
                                ev.append("Fault Routing off");
                            } else if (evPar3 == 11) {
                                ev.append("Fault Routing on");
                            } else if (evPar3 == 12) {
                                ev.append("Fault Routing Test on");
                            } else if (evPar3 == 13) {
                                ev.append("Fault Routing stopped");
                            } else if (evPar3 == 14) {
                                ev.append("Fault Routing Test off");
                            } else if (evPar3 == 15) {
                                ev.append("Fire Protection off");
                            } else if (evPar3 == 16) {
                                ev.append("Fire Protection on");
                            } else if (evPar3 == 17) {
                                ev.append("Fire Protection Test on");
                            } else if (evPar3 == 18) {
                                ev.append("Fire Protection stopped");
                            } else if (evPar3 == 19) {
                                ev.append("Fire Protection Test off");
                            } else if (evPar3 == 20) {
                                ev.append("Two fire on");
                            } else if (evPar3 == 21) {
                                ev.append("Two fire off");
                            }
                        }
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(AREA[this.language]).append(" = ").append(evPar6);
                        ev.append(",");
                        ev.append(ZONE[this.language]);
                        ev.append(",");
                        if (this.zones.containsKey(evPar2)) {
                            this.zones.get(evPar2).setAlarm(evPar1);
                        } else {
                            Zone z = new Zone(evPar2, evPar6, null);
                            this.zones.put(evPar2, z);
                            z.setAlarm(evPar1);
                        }
                        try {
                            this.v_zone_data_req[6] = (byte)evPar2;
                            this.write(this.v_zone_data_req);
                            Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Zone Data request sent [" + evPar2 + "]", this.prop.serverName);
                            this.reset_list_temp.add((byte[])this.v_zone_data_req.clone());
                        }
                        catch (IOException z) {}
                    } else if (evType == 4) {
                        ev.append(GENERAL_ALARM[evPar1][this.language]);
                        evUI.append(GENERAL_ALARM[evPar1][this.language]);
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        int gen_al_num = ((evPar2 & 0xFF) << 8) + (evPar3 & 0xFF);
                        ev.append(NUMBER[this.language]).append(" = ").append(gen_al_num);
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(GENERAL[this.language]);
                        ev.append(",");
                    } else if (evType == 5) {
                        if ((evPar1 & 1) == 0) {
                            ev.append(OUTPUT_NOT_SWITCHED[this.language]);
                            evUI.append(OUTPUT_NOT_SWITCHED[this.language]);
                        } else {
                            ev.append(OUTPUT_SWITCHED[this.language]);
                            evUI.append(OUTPUT_SWITCHED[this.language]);
                        }
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        int output = ((evPar2 & 0xFF) << 8) + (evPar3 & 0xFF);
                        ev.append(OUTPUT[this.language]).append(" = ").append(output);
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(OUTPUT[this.language]);
                        ev.append(",");
                        if (this.outputs.containsKey(output)) {
                            this.outputs.get(output).setStatus(evPar1);
                        } else {
                            Output o2 = new Output(output, null);
                            this.outputs.put(output, o2);
                            o2.setStatus(evPar1);
                        }
                        this.v_output_data_req[6] = (byte)evPar2;
                        this.v_output_data_req[7] = (byte)evPar3;
                        this.reset_list_temp.add((byte[])this.v_output_data_req.clone());
                    } else if (evType == 6) {
                        if ((evPar1 & 1) == 0) {
                            ev.append(INPUT_NOT_SWITCHED[this.language]);
                            evUI.append(INPUT_NOT_SWITCHED[this.language]);
                        } else {
                            ev.append(INPUT_SWITCHED[this.language]);
                            evUI.append(INPUT_SWITCHED[this.language]);
                        }
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        int input = ((evPar2 & 0xFF) << 8) + (evPar3 & 0xFF);
                        ev.append(INPUT[this.language]).append(" = ").append(input);
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(INPUT[this.language]);
                        ev.append(",");
                        if (this.inputs.containsKey(input)) {
                            this.inputs.get(input).setStatus(evPar1);
                        } else {
                            Input i5 = new Input(input, null);
                            this.inputs.put(input, i5);
                            i5.setStatus(evPar1);
                        }
                        this.v_input_data_req[6] = (byte)evPar2;
                        this.v_input_data_req[7] = (byte)evPar3;
                        this.reset_list_temp.add((byte[])this.v_input_data_req.clone());
                    } else if (evType == 7) {
                        ev.append(ACTION_LIST[evPar1 - 100][this.language]);
                        evUI.append(ACTION_LIST[evPar1 - 100][this.language]);
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        int action_num = ((evPar2 & 0xFF) << 8) + (evPar3 & 0xFF);
                        ev.append(NUMBER[this.language]).append(" = ").append(action_num);
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(ACTION[this.language]);
                        ev.append(",");
                        if (evPar1 == 101) {
                            this.reset_list.addAll(this.reset_list_temp);
                            this.reset_list_temp = new Vector();
                            for (Input i6 : this.inputs.values()) {
                                i6.setStatus(0);
                            }
                            for (Output o3 : this.outputs.values()) {
                                o3.setStatus(0);
                            }
                        }
                    } else if (evType == 8) {
                        ev.append(",");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        ev.append(LOOP[this.language]).append(" = ").append(evPar2);
                        ev.append(",");
                        if ((evPar3 & 1) == 1) {
                            ev.append("Overload A;");
                            evUI.append("Overload A;");
                        }
                        if ((evPar3 >>> 1 & 1) == 1) {
                            ev.append("Overload B;");
                            evUI.append("Overload B;");
                        }
                        if ((evPar3 >>> 2 & 1) == 1) {
                            ev.append("Open loop;");
                            evUI.append("Open loop;");
                        }
                        if ((evPar3 >>> 3 & 1) == 1) {
                            ev.append("Loop partially isolated;");
                            evUI.append("Loop partially isolated;");
                        }
                        if ((evPar3 >>> 4 & 1) == 1) {
                            ev.append("Isolated;");
                            evUI.append("Isolated;");
                        }
                        ev.deleteCharAt(ev.length() - 1);
                        evUI.deleteCharAt(evUI.length() - 1);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(LOOP[this.language]);
                        ev.append(",");
                    } else if (evType == 10) {
                        ev.append(LON_ALARM[evPar1][this.language]);
                        evUI.append(LON_ALARM[evPar1][this.language]);
                        ev.append(",");
                        evUI.append(" - ");
                        String evText = (evText1 + " " + evText2).trim();
                        ev.append(evText);
                        ev.append(",");
                        if (evText.length() > 0) {
                            evUI.append(" - ");
                            evUI.append(evText);
                        }
                        ev.append(LON[this.language]).append(" = ").append(evPar2);
                        ev.append(",");
                        ev.append(NUMBER[this.language]).append(" = ").append(evPar3);
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(",");
                        ev.append(LON[this.language]);
                        ev.append(",");
                    } else {
                        ev.append(evPar1).append(",");
                        ev.append((evText1 + " " + evText2).trim()).append(",");
                        ev.append(evPar2).append(",");
                        ev.append(evPar3).append(",");
                        ev.append(evPar4).append(",");
                        ev.append(evPar5).append(",");
                        ev.append(evPar6).append(",");
                        ev.append(UNKNOWN[this.language]).append(" [").append(evType).append("]");
                        evUI.append(UNKNOWN[this.language]).append(" [").append(evType).append("]");
                        ev.append(",");
                    }
                    if (evStatus == 0) {
                        ev.append(PASSIVE[this.language]);
                    } else if (evStatus == 1) {
                        ev.append(ACTIVE[this.language]);
                    } else if (evStatus == 2) {
                        ev.append(ACCEPTED[this.language]);
                    } else if (evStatus == 3) {
                        ev.append(LOGGED[this.language]);
                    }
                    Logger.log(Logger.Mode.SECURITY, ev.toString(), this.prop.serverName);
                    this.uiSet("log", evUI.toString());
                    if (eventClass != null) {
                        this.ioWriteForced(this.prop.genEvents, "event." + eventClass + ".text", evUI.toString());
                    }
                }
            }
        } else {
            if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 24) {
                int loopIdx = resp.get(5) & 0xFF;
                int sensIdx = resp.get(6) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Sensor Data received [" + loopIdx + "," + sensIdx + "]", this.prop.serverName);
                Sensor s = (Sensor)this.loops.get(loopIdx).sensors.get(sensIdx);
                s.setStatus(resp);
                try {
                    this.v_zone_data_req[6] = (byte)s.zone;
                    this.write(this.v_zone_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Zone Data request sent [" + s.zone + "]", this.prop.serverName);
                    return true;
                }
                catch (IOException e4) {
                    return false;
                }
            }
            if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 25) {
                int idx = resp.get(5) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Zone Data received [" + idx + "]", this.prop.serverName);
                Zone z = this.zones.get(idx);
                z.setStatus(resp);
                try {
                    this.v_area_data_req[6] = (byte)z.area;
                    this.write(this.v_area_data_req);
                    Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Area Data request sent [" + z.area + "]", this.prop.serverName);
                    return true;
                }
                catch (IOException e5) {
                    return false;
                }
            }
            if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 26) {
                int idx = resp.get(5) & 0xFF;
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Area Data received [" + idx + "]", this.prop.serverName);
                this.areas.get(idx).setStatus(resp);
            } else if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 31) {
                b1 = resp.get(5);
                byte b2 = resp.get(6);
                int idx = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Input Data received [" + idx + "]", this.prop.serverName);
                this.inputs.get(idx).setStatus(resp.get(7).byteValue());
            } else if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 34) {
                b1 = resp.get(5);
                byte b2 = resp.get(6);
                int idx = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Volatile Output Data received [" + idx + "]", this.prop.serverName);
                this.outputs.get(idx).setStatus(resp.get(7).byteValue());
            } else if ((resp.get(0) & 0xC0) == 0 && resp.get(4) == 44) {
                int year = resp.get(5) & 0xFF;
                year = year <= 93 ? (year += 2000) : (year += 1900);
                int month = resp.get(6) & 0xFF;
                int day = resp.get(7) & 0xFF;
                int hr = resp.get(8) & 0xFF;
                int min = resp.get(9) & 0xFF;
                int sec = resp.get(10) & 0xFF;
                String val = String.valueOf(year) + "/" + month + "/" + day + "-" + hr + ":" + min + ":" + sec;
                this.ioWrite(this.prop.genEvents, "clock", val);
            } else {
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Unkwown message: " + (resp.get(4) & 0xFF) + ", " + (resp.get(5) & 0xFF), this.prop.serverName);
            }
        }
        try {
            if (this.reset_list.isEmpty()) {
                this.write(this.ACK);
                Logger.log(Logger.Mode.VERBOSE, "processResponse - ACK sent", this.prop.serverName);
            } else {
                byte[] req = this.reset_list.remove(0);
                this.write(req);
                Logger.log(Logger.Mode.VERBOSE, "processResponse - Status request from reset list sent", this.prop.serverName);
            }
        }
        catch (IOException e6) {
            return false;
        }
        return true;
    }

    void commandDispatcher(int ioIndex, ioCommandDispatcher me) {
        Object monitor = SystemState.ioServersMonitorThreadGet(ioIndex);
        this.prop = ((FP2000)SystemState.ioServersMonitorThreadGet((int)ioIndex)).prop;
        ArrayBlockingQueue<String> ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioCommandDispatcher - started [" + this.prop.serverName + "]");
        try {
            me.heartbeat = System.currentTimeMillis();
            this.init(me, monitor, ioIndex);
            String cmd = null;
            while (!me.quit && monitor == SystemState.ioServersMonitorThreadGet(ioIndex)) {
                cmd = ioqtx.poll(10L, TimeUnit.SECONDS);
                if (cmd != null) {
                    do {
                        this.processCommand(cmd);
                        me.heartbeat = System.currentTimeMillis();
                        Thread.sleep(200L);
                    } while ((cmd = ioqtx.poll()) != null);
                }
                this.write(this.status_req);
                Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - Status request sent", this.prop.serverName);
                Thread.sleep(200L);
                this.uiUpdate();
                me.heartbeat = System.currentTimeMillis();
            }
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "commandDispatcher - Exception - " + e2.getLocalizedMessage(), this.prop.serverName);
        }
        hsyco.errorLog("ioCommandDispatcher - quit [" + this.prop.serverName + "]");
    }

    private void init(ioCommandDispatcher me, Object monitor, int ioIndex) throws IOException {
        while (!me.quit && this.prop.initialization_status == 1 && monitor == SystemState.ioServersMonitorThreadGet(ioIndex)) {
            this.write(this.serial_initialization_req);
            Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - Serial initialization request sent", this.prop.serverName);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (!me.quit && monitor == SystemState.ioServersMonitorThreadGet(ioIndex) && this.prop.initialization_status != 0) {
            me.heartbeat = System.currentTimeMillis();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void write(byte[] data) throws IOException {
        data[2] = this.prop.pkt;
        data[3] = this.prop.panelIDAddr;
        data[4] = this.prop.sor;
        if (data[1] != 64 && data[1] != -128) {
            Properties properties = this.prop;
            properties.typ = properties.typ + 1;
            if (this.prop.typ > 63) {
                this.prop.typ = 0;
            }
            data[1] = (byte)(data[1] & 0xC0 | this.prop.typ & 0x3F);
        }
        FP2000.addChecksum(data);
        data = FP2000.NTFExpansion(data);
        Logger.log(Logger.Mode.VERBOSE, "sending data", this.prop.serverName);
        if (util.writeCommBytes(this.prop.commPort, data) != data.length) {
            throw new IOException("write comm error");
        }
    }

    private static byte[] NTFExpansion(byte[] data) {
        Vector<Byte> v = new Vector<Byte>();
        v.add(data[0]);
        int i2 = 1;
        while (i2 < data.length - 1) {
            if (data[i2] == -3) {
                v.add((byte)-3);
                v.add((byte)125);
            } else if (data[i2] == -2) {
                v.add((byte)-3);
                v.add((byte)126);
            } else {
                v.add(data[i2]);
            }
            ++i2;
        }
        v.add(data[data.length - 1]);
        byte[] ret = new byte[v.size()];
        int i3 = 0;
        while (i3 < ret.length) {
            ret[i3] = (Byte)v.get(i3);
            ++i3;
        }
        return ret;
    }

    private static void addChecksum(byte[] data) {
        int ck = 0;
        int i2 = 1;
        while (i2 < data.length - 3) {
            ck += data[i2] & 0xFF;
            ++i2;
        }
        data[data.length - 3] = (byte)(ck >>> 8);
        data[data.length - 2] = (byte)ck;
    }

    private static boolean checksum(Vector<Byte> data) {
        int ck = 0;
        int i2 = 0;
        while (i2 < data.size() - 2) {
            ck += data.get(i2) & 0xFF;
            ++i2;
        }
        return data.get(data.size() - 2) == (byte)(ck >>> 8) && data.get(data.size() - 1) == (byte)ck;
    }

    public String keypad(String id) {
        if (this.prop.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.prop.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                SystemState.ioSet(String.valueOf(this.prop.serverName) + "." + name, value);
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.prop.serverName);
                return null;
            }
        }
        return "";
    }

    private void processCommand(String cmd) {
        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - processing command: " + cmd, this.prop.serverName);
        cmd = cmd.toLowerCase();
        try {
            String[] id_val = cmd.split("=");
            String id = id_val[0];
            String val = id_val[1];
            this.commandExecutor(id, val);
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e2.getLocalizedMessage(), this.prop.serverName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commandExecutor(String function, String value) throws IOException {
        if (function.equals("key")) {
            int v = Integer.parseInt(value);
            if (!(v >= 1 && v <= 31 || v >= 48 && v <= 57) && (v < 211 || v > 239)) throw new IllegalArgumentException("invalid value");
            if (this.prop.controlsDisable && (v == 9 || v == 11 || v == 12 || v >= 14 && v <= 20 || v == 22 || v >= 29 && v <= 31)) {
                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - command denied: control commands disabled", this.prop.serverName);
                return;
            }
            if (this.prop.keypadDisable && (v == 1 || v == 2 || v >= 4 && v <= 6 || v == 8 || v == 10 || v == 13 || v == 26 || v == 27 || v >= 48 && v <= 57)) {
                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - command denied: keypad commands disabled", this.prop.serverName);
                return;
            }
            this.emulation_cmd_key[8] = (byte)v;
            this.write(this.emulation_cmd_key);
            Logger.log(Logger.Mode.VERBOSE, "commandExecutor - Emulation Command (Key) sent", this.prop.serverName);
            return;
        } else if (function.equals("emulation")) {
            if (value.equals("1")) {
                this.write(this.emulation_cmd_start);
                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - Emulation Command (Start) sent", this.prop.serverName);
                return;
            } else {
                if (!value.equals("0")) throw new IllegalArgumentException("invalid value");
                this.write(this.emulation_cmd_stop);
                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - Emulation Command (Stop) sent", this.prop.serverName);
                this.ioWrite(this.prop.genEvents, "emulation", "0");
                this.prop.emulation = false;
            }
            return;
        } else if (function.equals("clock")) {
            if (value.equals("read")) {
                this.write(this.time_req);
                return;
            } else {
                String[] dt = value.split("-");
                String date = dt[0];
                String time = dt[1];
                String[] ymd = date.split("/");
                byte year = Byte.parseByte(ymd[0].substring(2));
                byte month = Byte.parseByte(ymd[1]);
                byte day = Byte.parseByte(ymd[2]);
                String[] hms = time.split(":");
                byte hour = Byte.parseByte(hms[0]);
                byte min = Byte.parseByte(hms[1]);
                byte sec = Byte.parseByte(hms[2]);
                this.set_time_req[6] = year;
                this.set_time_req[7] = month;
                this.set_time_req[8] = day;
                this.set_time_req[9] = hour;
                this.set_time_req[10] = min;
                this.set_time_req[11] = sec;
                this.write(this.set_time_req);
                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - Set Time request sent", this.prop.serverName);
            }
            return;
        } else {
            if (!function.endsWith(".status") || !value.equals("read")) throw new IllegalArgumentException("invalid function");
            String idxStr = function.substring(1).replace(".status", "");
            if (function.startsWith("i")) {
                int idx = Integer.parseInt(idxStr);
                this.v_input_data_req[6] = (byte)(idx >>> 8);
                this.v_input_data_req[7] = (byte)idx;
                this.write(this.v_input_data_req);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Input Data request sent [" + idx + "]", this.prop.serverName);
                return;
            } else {
                if (!function.startsWith("o")) throw new IllegalArgumentException("invalid function");
                int idx = Integer.parseInt(idxStr);
                this.v_output_data_req[6] = (byte)(idx >>> 8);
                this.v_output_data_req[7] = (byte)idx;
                this.write(this.v_output_data_req);
                Logger.log(Logger.Mode.VERBOSE, "processInitResponse - Volatile Output Data request sent [" + idx + "]", this.prop.serverName);
            }
        }
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.prop.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.prop.serverName) + "." + name, value);
        }
        this.uiSet(name, value);
    }

    private void ioWriteForced(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWriteForced(String.valueOf(this.prop.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.prop.serverName) + "." + name, value);
        }
    }

    private void uiSet(String name, String value) {
        if (!this.prop.guiSupport) {
            return;
        }
        if (name.startsWith("led.")) {
            if (value.equals("on")) {
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.on", "visible", "true");
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.on", "blink", "false");
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.off", "visible", "false");
            } else if (value.equals("off")) {
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.off", "visible", "true");
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.on", "visible", "false");
            } else if (value.equals("blink")) {
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.on", "visible", "true");
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.on", "blink", "true");
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.off", "visible", "false");
            }
        } else if (name.equals("log")) {
            this.logTime = System.currentTimeMillis();
            value = value.toUpperCase();
            String logEntry = "<div style=\"padding:3px\">" + this.prop.dateFormat.format(this.logTime).toUpperCase() + " " + value + "</div>";
            while (this.logs.size() >= this.prop.logSize) {
                this.logs.remove(this.prop.logSize - 1);
            }
            this.logs.add(0, logEntry);
            StringBuilder text = new StringBuilder();
            int i2 = 0;
            while (i2 < this.logs.size()) {
                text.append(this.logs.get(i2));
                ++i2;
            }
            userBase.uiSet(String.valueOf(this.prop.serverName) + ".log", "value", text.toString());
            userBase.uiSet(String.valueOf(this.prop.serverName) + ".log0", "value", value);
            i2 = 0;
            while (i2 < this.logs.size() && i2 < 20) {
                userBase.uiSet(String.valueOf(this.prop.serverName) + ".log" + (i2 + 1), "value", this.logs.get(i2));
                ++i2;
            }
            this.saveLogs();
        } else if (name.equals("connection")) {
            if (value.equals("online")) {
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label", "visible", "true");
            }
        } else if (name.equals("emulation")) {
            if (value.equals("0")) {
                this.display.off();
            }
        } else if (name.endsWith(".name")) {
            userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name, "value", value);
        } else if (name.endsWith(".alarm") || name.endsWith(".status")) {
            if (value.equals("1")) {
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.1", "visible", "true");
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.0", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.1", "visible", "false");
                userBase.uiSet(String.valueOf(this.prop.serverName) + "." + name + ".label.0", "visible", "true");
            }
        }
    }

    private void uiUpdate() {
        if (!this.prop.guiSupport) {
            return;
        }
        if (System.currentTimeMillis() > this.logTime + 10000L) {
            userBase.uiSet(String.valueOf(this.prop.serverName) + ".log0", "value", "");
        }
    }

    private class Area {
        private final int idx;
        private final String prefix;
        private int alarm_count = -1;
        private int fault_count = -1;
        private int coinc_count = -1;
        private int cond_count = -1;
        private int isol_count = -1;
        private int[] alarms = new int[7];
        private final String[] alarms_text = new String[]{"alarm.fire", "alarm.fault", "alarm.coincidence", "alarm.isolated", "alarm.condition", "alarm.enabled", "alarm.action"};

        public Area(int idx, String text) {
            this.idx = idx;
            this.prefix = "a" + idx + ".";
            int i2 = 0;
            while (i2 < this.alarms.length) {
                this.alarms[i2] = -1;
                ++i2;
            }
            FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "name", text);
        }

        public void setStatus(Vector<Byte> resp) {
            byte b1 = resp.get(7);
            byte b2 = resp.get(8);
            int val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setAlarmCount(val);
            b1 = resp.get(9);
            b2 = resp.get(10);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setFaultCount(val);
            b1 = resp.get(11);
            b2 = resp.get(12);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setConditionCount(val);
            b1 = resp.get(13);
            b2 = resp.get(14);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setCoincidenceCount(val);
            b1 = resp.get(15);
            b2 = resp.get(16);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setIsolateCount(val);
            val = resp.get(6) & 0xFF;
            this.setAlarm(val);
        }

        private void setAlarm(int val) {
            int i2 = 0;
            while (i2 < this.alarms.length) {
                int b2 = val >>> i2 & 1;
                if (this.alarms[i2] != b2) {
                    this.alarms[i2] = b2;
                    FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + this.alarms_text[i2], "" + b2);
                }
                ++i2;
            }
            if ((val & 0x7F) == 0) {
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "area.alarm", "0");
            } else {
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "area.alarm", "1");
            }
        }

        private void setIsolateCount(int val) {
            if (this.isol_count != val) {
                this.isol_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "isolate.count", "" + val);
            }
        }

        private void setCoincidenceCount(int val) {
            if (this.coinc_count != val) {
                this.coinc_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "coincidence.count", "" + val);
            }
        }

        private void setConditionCount(int val) {
            if (this.cond_count != val) {
                this.cond_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "condition.count", "" + val);
            }
        }

        private void setFaultCount(int val) {
            if (this.fault_count != val) {
                this.fault_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "fault.count", "" + val);
            }
        }

        private void setAlarmCount(int val) {
            if (this.alarm_count != val) {
                this.alarm_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "alarm.count", "" + val);
            }
        }
    }

    private class Display {
        private static final int COLUMNS_NUM = 40;
        private static final int ROWS_NUM = 8;
        private Vector<Char[]> rows = new Vector(8);
        private int cursorRow;
        private int cursorColumn;
        private char attribute = (char)48;
        private String dsplHLColor = "339933";

        public Display() {
            int i2 = 0;
            while (i2 < 8) {
                this.rows.add(new Char[40]);
                ++i2;
            }
            this.clearScreen();
        }

        private void setCursor(byte row, byte column) {
            this.cursorRow = (row & 0xFF) - 32;
            this.cursorColumn = (column & 0xFF) - 32;
        }

        private void setAttribute(byte attr) {
            this.attribute = (char)(attr & 0xFF);
        }

        private void print() {
            if (FP2000.this.prop.guiSupport && FP2000.this.prop.emulation) {
                StringBuilder sb = new StringBuilder();
                int r = 0;
                while (r < 8) {
                    int c2 = 0;
                    while (c2 < 40) {
                        if (this.rows.get((int)r)[c2].attr == '4') {
                            sb.append("<span style='background-color:#").append(this.dsplHLColor).append("'>");
                        } else if (this.rows.get((int)r)[c2].attr == '2') {
                            sb.append("<blink>");
                        } else if (this.rows.get((int)r)[c2].attr == '6') {
                            sb.append("<span style='background-color:#").append(this.dsplHLColor).append("'><blink>");
                        }
                        sb.append(this.rows.get((int)r)[c2].c);
                        if (this.rows.get((int)r)[c2].attr == '4') {
                            sb.append("</span>");
                        } else if (this.rows.get((int)r)[c2].attr == '2') {
                            sb.append("</blink>");
                        } else if (this.rows.get((int)r)[c2].attr == '6') {
                            sb.append("</blink></span>");
                        }
                        ++c2;
                    }
                    sb.append("<br />");
                    ++r;
                }
                userBase.uiSet(String.valueOf(FP2000.this.prop.serverName) + ".display", "value", sb.toString());
            }
        }

        public void off() {
            userBase.uiSet(String.valueOf(FP2000.this.prop.serverName) + ".display", "value", "");
        }

        private void setChar(byte c2) {
            if (c2 == 32) {
                c2 = (byte)-96;
            }
            this.rows.get((int)this.cursorRow)[this.cursorColumn].c = (char)(c2 & 0xFF);
            this.rows.get((int)this.cursorRow)[this.cursorColumn].attr = this.attribute;
            ++this.cursorColumn;
            if (this.cursorColumn >= 40) {
                this.cursorColumn = 0;
                ++this.cursorRow;
            }
            if (this.cursorRow >= 8) {
                this.cursorRow = 0;
            }
        }

        private void clearToEndOfLine() {
            int i2 = this.cursorColumn;
            while (i2 < 40) {
                this.rows.get((int)this.cursorRow)[i2] = new Char();
                ++i2;
            }
        }

        private void clearScreen() {
            int r = 0;
            while (r < 8) {
                int c2 = 0;
                while (c2 < 40) {
                    this.rows.get((int)r)[c2] = new Char();
                    ++c2;
                }
                ++r;
            }
        }

        private class Char {
            char c = (char)160;
            char attr = (char)48;

            private Char() {
            }
        }
    }

    private class Input {
        private final int idx;
        private final String prefix;
        private int status = -1;

        public Input(int idx, String text) {
            this.idx = idx;
            this.prefix = "i" + idx + ".";
            FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "name", text);
        }

        public void setStatus(int val) {
            if (this.status != (val &= 1)) {
                this.status = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "status", "" + val);
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class Loop {
        private int idx;
        private HashMap<Integer, Sensor> sensors = new HashMap();

        public Loop(int idx) {
            this.idx = idx;
        }

        public void addSensor(int sensorIdx, int zone, String text1, String text2) {
            this.sensors.put(sensorIdx, new Sensor(sensorIdx, this.idx, zone, text1, text2));
        }
    }

    private class Output {
        private final int idx;
        private final String prefix;
        private int status = -1;

        public Output(int idx, String text) {
            this.idx = idx;
            this.prefix = "o" + idx + ".";
            FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "name", text);
        }

        public void setStatus(int val) {
            if (this.status != (val &= 1)) {
                this.status = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "status", "" + val);
            }
        }
    }

    private class Properties {
        private String serverName;
        private String commPort;
        private boolean guiSupport = true;
        private boolean genEvents = false;
        private int accessCode = 0;
        private boolean keypadDisable = false;
        private boolean controlsDisable = false;
        private int logSize = 20;
        private int initialization_status = 1;
        private DateFormat dateFormat;
        private int typ = -1;
        private byte pkt = 0;
        private byte sor = (byte)7;
        private byte panelIDAddr = 0;
        private boolean emulation = false;
        private int status_event_count = -1;
        private int status_alarm_count = -1;
        private int status_fault_count = -1;
        private int status_condition_count = -1;
        private int status_coincidence_count = -1;
        private int status_isolated_count = -1;
        private int status_detector_count = -1;
        private int last_event_num = -1;

        private Properties() {
        }
    }

    private class Sensor {
        private final int idx;
        private final int zone;
        private final String prefix;
        private int alarm_count = -1;
        private int[] alarms = new int[16];
        private final String[] alarms_text = new String[]{"alarm.fire", "alarm.communication", "alarm.fault", "alarm.disabled", "alarm.type", "alarm.address", "alarm.condition", "alarm.maintenance", "alarm.notype", "alarm.enabled", "alarm.twoset", "alarm.segment", "alarm.led", "alarm.segment.cont", "alarm.flag", "alarm.pending"};

        public Sensor(int idx, int loop, int zone, String text1, String text2) {
            this.idx = idx;
            this.zone = zone;
            this.prefix = "l" + loop + ".s" + idx + ".";
            int i2 = 0;
            while (i2 < this.alarms.length) {
                this.alarms[i2] = -1;
                ++i2;
            }
            FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "name", text1);
        }

        public void setStatus(Vector<Byte> resp) {
            int val = resp.get(7) & 0xFF;
            this.setAlarmCount(val);
            byte b1 = resp.get(23);
            byte b2 = resp.get(24);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setAlarm(val);
        }

        private void setAlarm(int val) {
            int i2 = 0;
            while (i2 < this.alarms.length) {
                int b2 = val >>> i2 & 1;
                if (this.alarms[i2] != b2) {
                    this.alarms[i2] = b2;
                    FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + this.alarms_text[i2], "" + b2);
                }
                ++i2;
            }
            if (val == 0) {
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "alarm", "0");
            } else {
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "alarm", "1");
            }
        }

        private void setAlarmCount(int val) {
            if (this.alarm_count != val) {
                this.alarm_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "alarm.count", "" + val);
            }
        }
    }

    private class Zone {
        private final int idx;
        private final int area;
        private final String prefix;
        private int alarm_count = -1;
        private int fault_count = -1;
        private int coinc_count = -1;
        private int cond_count = -1;
        private int isol_count = -1;
        private int[] alarms = new int[10];
        private final String[] alarms_text = new String[]{"alarm.fire", "alarm.fault", "alarm.coincidence", "alarm.isolated", "alarm.test", "alarm.condition", "alarm.enabled", "alarm.autofire", "alarm.action", "alarm.warning"};

        public Zone(int idx, int area, String text) {
            this.idx = idx;
            this.area = area;
            this.prefix = "z" + idx + ".";
            int i2 = 0;
            while (i2 < this.alarms.length) {
                this.alarms[i2] = -1;
                ++i2;
            }
            FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "name", text);
        }

        public void setStatus(Vector<Byte> resp) {
            byte b1 = resp.get(8);
            byte b2 = resp.get(9);
            int val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setAlarmCount(val);
            b1 = resp.get(10);
            b2 = resp.get(11);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setFaultCount(val);
            b1 = resp.get(12);
            b2 = resp.get(13);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setConditionCount(val);
            b1 = resp.get(14);
            b2 = resp.get(15);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setCoincidenceCount(val);
            b1 = resp.get(16);
            b2 = resp.get(17);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setIsolateCount(val);
            b1 = resp.get(6);
            b2 = resp.get(7);
            val = ((b1 & 0xFF) << 8) + (b2 & 0xFF);
            this.setAlarm(val);
        }

        private void setAlarm(int val) {
            int i2 = 0;
            while (i2 < 9) {
                int b2 = val >>> i2 & 1;
                if (this.alarms[i2] != b2) {
                    this.alarms[i2] = b2;
                    FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + this.alarms_text[i2], "" + b2);
                }
                ++i2;
            }
            int b3 = val >>> 13 & 1;
            if (this.alarms[9] != b3) {
                this.alarms[9] = b3;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + this.alarms_text[9], "" + b3);
            }
            if ((val & 0x21FF) == 0) {
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "zone.alarm", "0");
            } else {
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "zone.alarm", "1");
            }
        }

        private void setIsolateCount(int val) {
            if (this.isol_count != val) {
                this.isol_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "isolate.count", "" + val);
            }
        }

        private void setCoincidenceCount(int val) {
            if (this.coinc_count != val) {
                this.coinc_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "coincidence.count", "" + val);
            }
        }

        private void setConditionCount(int val) {
            if (this.cond_count != val) {
                this.cond_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "condition.count", "" + val);
            }
        }

        private void setFaultCount(int val) {
            if (this.fault_count != val) {
                this.fault_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "fault.count", "" + val);
            }
        }

        private void setAlarmCount(int val) {
            if (this.alarm_count != val) {
                this.alarm_count = val;
                FP2000.this.ioWrite(FP2000.this.prop.genEvents, String.valueOf(this.prefix) + "alarm.count", "" + val);
            }
        }
    }
}

