/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ELMO {
    public static final String[] WebObjects = new String[]{"elmo"};
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private int language;
    private DateFormat dateFormat;
    private DateFormat eventDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH);
    private Vector<String> logs;
    private boolean guiSupport = true;
    private boolean userLogs = false;
    private boolean genEvents = false;
    private int pollinterval = 1;
    private boolean offlineLogs = false;
    private int logSize = 20;
    private int max_inputs_num_opt = Integer.MAX_VALUE;
    private int max_groups_num_opt = Integer.MAX_VALUE;
    private int max_outputs_num_opt = Integer.MAX_VALUE;
    private int max_users_num_opt = Integer.MAX_VALUE;
    private int userNum = 0;
    private String password = null;
    private byte[] connect;
    private byte[] version_req;
    private byte[] status_req;
    private byte[] bypass_req;
    private byte[] group_names_req;
    private byte[] input_names_req;
    private byte[] user_names_req;
    private byte[] event_log_req;
    private byte[] reset_log_ptr_req;
    private byte[] panel_cmd;
    private byte[] group_cmd;
    private byte[] area_cmd;
    private byte[] input_cmd;
    private byte[] output_cmd;
    private static final String[][] EVENTS = new String[][]{{"Ev. Code: 0", "Ev. Code: 0", "Ev. Code: 0"}, {"Pre-alarm", "Preallarme", "Alerte Precoce"}, {"Intrusion Alarm", "Allarme Intrusione", "Alarme Intrusion"}, {"Tamper Alarm", "Allarme Manomissione", "Alarme Falsification"}, {"Fire Alarm", "Allarme Incendio", "Alarme Incendie"}, {"Aggrassion Alarm", "Allarme Aggressione", "Alarme Agression"}, {"Medic Alarm", "Allarme Medico", "Alarme Medicale"}, {"Aid Request", "Richiesta Soccorso", "Demande Sauver"}, {"Gas Leak Alarm", "Allarme Fuga Gas", "Alarme evasion Gaz"}, {"Flooding Alarm", "Allarme Allagamento", "Alarme Inondation"}, {"Fire Detector Fault", "Guasto Antincendio", "Defectueux Feu"}, {"Fault", "Guasto", "Defectueux"}, {"Perimetral Violation", "Violazione Perimetrale", "Violation de Perimetre"}, {"Security Exit Alarm", "Allarme Uscita Sicurezza", "Alarme Sortie de securite"}, {"Opening (Set)", "Apertura (Set)", "Ouverture (Set)"}, {"Closing (Set)", "Chiusura (Set)", "Fermeture (Set)"}, {"Programmed Output Activation", "Attivazione Uscita Programmata", "Activer Annexe de Sortie"}, {"Programmed Output Deactivation", "Disattivazione Uscita Programmata", "Desactiver Annexe de Sortie"}, {"Power On (Set)", "Accensione (Set)", "Allumage (Set)"}, {"Power Off (Set)", "Spegnimento (Set)", "Eteindre (Set)"}, {"Mains fault", "Assenza Rete 230", "Reseau Absence 230"}, {"Low Battery", "Batteria Scarica", "Batterie Decharger"}, {"No Battery", "Batteria Assente", "Batterie Absent"}, {"Arming", "Inserimento", "Insertion"}, {"Arming Max Security", "Inserimento Max Sicurezza", "Insertion Maximale Securite"}, {"Exit Delay Start", "Inizio Tempo Uscita", "Debut Time Out"}, {"Key Point Arming", "Inserimento Punto Chiave", "Insertion Point Cle"}, {"Communication Failure", "Comunicazione Fallita", "Communication echec"}, {"System Access", "Accesso Sistema", "Systeme D'acces"}, {"Power Supply Fault", "Guasto Alimentazione", "Defectueux Fournir"}, {"Phone Line Fault", "Guasto linea telefonica", "Defectueux Ligne Telephonique"}, {"Alarms Reset", "Reset Allarmi", "Reinitialiser Alarmes"}, {"Setup Restore", "Ripristino Setup", "Restauration Setup"}, {"Initialization", "Inizializzazione", "Initialisation"}, {"Input Bypassed", "Esclusione Ingresso", "Exclusion Entree"}, {"Input Disabled", "Disabilitazione Ingresso", "Desactiver Entree"}, {"Output Activated", "Attivazione Uscita", "Activer Sortie"}, {"No GSM Recording", "Assenza registrazione GSM", "Absence Inscription GSM"}, {"Dialer StartUp", "Avvio Combinatore", "Initialisation Combineur"}, {"Coercion Alarm", "Allarme Coercizione", "Alarme Coercition"}, {"Keypad Tamper", "Manomissione Tastiera", "Falsification Clavier"}, {"False Key", "Chiave Falsa", "Cle Faux"}, {"System Tammper", "Manomissione Impianto", "Falsification Usine"}, {"Mains Fault Input", "Ingresso No Rete 230", "Entree No Reseau 230"}, {"Low Battery Input", "Ingresso Batteria Scarica", "Entree Batterie Decharger"}, {"Set Max. Security", "Set Max. Sicurezza", "Set Maximale Securite"}, {"Trigger AND", "Trigger AND", "Trigger AND"}, {"Panic Alarm", "Allarme Panico", "Alarme Panique"}, {"General Alarm Relay+", "Rele' Allarme Generale+", "Alarme Generale Relais+"}, {"Tamper Relay+", "Rele' Manomissione+", "Relais Falsification+"}, {"Fire Relay+", "Rele' Incendio+", "Relais Feu+"}, {"Pre-alarm Relay+", "Rele' Preallarme+", "Relais Alerte Precoce+"}, {"Gas/Flooding Relay+", "Rele' Allagamento/Gas+", "Relais Inondations/Gaz+"}, {"Arming Relay+", "Rele' Inserimento+", "Relais Insertion+"}, {"Aid Relay+", "Rele' Soccorso+", "Relais Sauver+"}, {"Aggression Relay+", "Rele' Aggressione+", "Relais Agression+"}, {"Int Sounders Relay+", "Rele' Sirene int+", "Relais Sirenes int+"}, {"Alarm Mem. Relay+", "Rele' Mem. Allarme+", "Relais Mem. Allarme+"}, {"Fault Relay+", "Rele' Guasto inc.+", "Relais Defectueux inc.+"}, {"Part. Relay+", "Rele' Parzializz.+", "Relay Chocquant+"}, {"Exit Delay Relay+", "Rele' Tempo Usc.+", "Relay Temps Sor.+"}, {"Start TVCC1", "Start TVCC1", "Start TVCC1"}, {"Start TVCC2", "Start TVCC2", "Start TVCC2"}, {"Start TVCC3", "Start TVCC3", "Start TVCC3"}, {"Line Cut", "Taglio Linea", "Ligne Coupe"}, {"Line Short Circuit", "Corto Circuito Linea", "Court-circuit Ligne"}, {"Tamper Trasponder", "Manomissione Trasponder", "Falsification Trasponder"}, {"Remote Activation", "Attivazione Remota", "Activation a Distance"}, {"Remote Deactivation", "Disattivazione Remota", "Desactiver a Distance"}, {"Remote Assistance", "Inizio TeleAssistenza", "Initialiser Teleassistance"}, {"Overtime Request", "Richiesta Straordinario", "Demande Extraordinaire"}, {"Credit Check SMS", "SMS Controllo Credito", "SMS Controle de Credit"}, {"Statistic Alarm", "Allarme Statistico", "Alarme Statistiques"}, {"Reset AND T. inf.", "Reset AND T. inf.", "Reset AND T. inf."}, {"Remote Control SMS", "SMS Tele-Controllo", "SMS Tele-Control"}, {"Report Request SMS", "SMS Richiesta Rapporto", "SMS Demande Rapport"}, {"Daylight Saving Time", "Ora Legale", "Heure D'ete"}, {"Presence Simulation Activated", "Attiv. Simulazione Presenza", "Activation Simuler Presence"}, {"Forced Arming", "Inserimento Forzato", "Marche Forcee"}, {"Communication Line Break", "Interruzione Linea Comunicazione", "Interruption Ligne Communication"}, {"Technologic N. 1", "Tecnologico N. 1", "Technologique N. 1"}, {"Technologic N. 2", "Tecnologico N. 2", "Technologique N. 2"}, {"Technologic N. 3", "Tecnologico N. 3", "Technologique N. 3"}, {"Technologic N. 4", "Tecnologico N. 4", "Technologique N. 4"}, {"Technologic N. 5", "Tecnologico N. 5", "Technologique N. 5"}, {"Technologic N. 6", "Tecnologico N. 6", "Technologique N. 6"}, {"Technologic N. 7", "Tecnologico N. 7", "Technologique N. 7"}, {"Technologic N. 8", "Tecnologico N. 8", "Technologique N. 8"}, {"Sensors Test Start", "Avvio Test Sensori", "Initialiser Capteurs Test"}, {"Sensors Test OK", "Test Sensori OK", "Capteurs Test OK"}, {"Output Activated", "Attivazione Uscita", "Activation Sortie"}, {"Access Attempts Exceeded", "Superamento Tentativi Accesso", "Surmonter Tentatives Acces"}, {"Gate Access ->", "Accesso Varco ->", "acces passage ->"}, {"Gate Enabling", "Abilitazione Varco", "Activation passage"}, {"Bypassed Input Alarm", "Allarme Ingresso Escluso", "Alarme Acces Desactivee"}, {"Input Auto-bypass", "Autoesclusione Ingresso", "Auto-Desactivee Acces"}, {"Arm/Dis. Usr. 0", "Ins/Dis. Ut. 0", "Ins/Dis. Ut. 0"}, {"Arm/Dis. Usr. 1", "Ins/Dis. Ut. 1", "Ins/Dis. Ut. 1"}, {"Arm/Dis. Usr. 2", "Ins/Dis. Ut. 2", "Ins/Dis. Ut. 2"}, {"Arm/Dis. Usr. 3", "Ins/Dis. Ut. 3", "Ins/Dis. Ut. 3"}, {"Arm/Dis. Usr. 4", "Ins/Dis. Ut. 4", "Ins/Dis. Ut. 4"}, {"Arm/Dis. Usr. 5", "Ins/Dis. Ut. 5", "Ins/Dis. Ut. 5"}, {"Arm/Dis. Usr. 6", "Ins/Dis. Ut. 6", "Ins/Dis. Ut. 6"}, {"Arm/Dis. Usr. 7", "Ins/Dis. Ut. 7", "Ins/Dis. Ut. 7"}, {"Arm/Dis. Usr. 8", "Ins/Dis. Ut. 8", "Ins/Dis. Ut. 8"}, {"Arm/Dis. Usr. 9", "Ins/Dis. Ut. 9", "Ins/Dis. Ut. 9"}, {"Radio Sensor Low Battery", "Batteria Scarica Sensore Radio", "Batterie Decharger Capteur Radio "}, {"Radio Sensor No Supervision", "Mancata Supervisione Sensore Radio", "echec Surveillance Capteur Radio"}, {"Raddio Sensor Fault", "Guasto Sensore Radio", "Defectueux Capteur Radio"}, {"Radio Sounder Tamper", "Manomissione Sirena Radio", "Falsification Sirene Radio"}, {"Radio Sounder Low Battery", "Batteria Scarica Sirena Radio", "Batterie Decharger Sirene Radio"}, {"Radio Sounder No Supervision", "Mancata Supervisione Sirena Radio", "echec Surveillance Sirene Radio"}, {"Radio Remote Control Low BAttery", "Batteria Scarica Telecomando Radio", "Batterie Decharger Telecommande Radio"}, {"Antiscramble", "Antiscramble", "Antiscramble"}, {"Outputs Test Run", "Test Uscite Eseguito", "Test Sortie Effectue"}, {"Dialer Test Run", "Test Combinatore Eseguito", "Test Combineur Effectue"}, {"Round Start", "Inizio Giro Ronda", "Initialiser Autour Patrouille"}, {"Round Alarm", "Allarme Giro Ronda", "Alarme Autour Patrouille"}, {"RF Interference", "Interferenza RF", "Ingerence RF"}, {"Failure To Arm", "Mancato Inserimento", "echec Insertion"}, {"Ev. Code: 120", "Ev. Code: 120", "Ev. Code: 120"}, {"Ev. Code: 121", "Ev. Code: 121", "Ev. Code: 121"}, {"Ev. Code: 122", "Ev. Code: 122", "Ev. Code: 122"}, {"Ev. Code: 123", "Ev. Code: 123", "Ev. Code: 123"}, {"Ev. Code: 124", "Ev. Code: 124", "Ev. Code: 124"}, {"Ev. Code: 125", "Ev. Code: 125", "Ev. Code: 125"}, {"Ev. Code: 126", "Ev. Code: 126", "Ev. Code: 126"}, {"Periodic Test", "Test Periodico", "Test Periodico"}, {"System Startup", "Avvio Sistema", "Initialiser Systeme"}, {"Pre-Alarm Reset", "Reset Preallarme", "Reset Alerte Precoce"}, {"Intrusion Alarm Reset", "Reset Allarme Intrusione", "Reset Alarme Intrusion"}, {"Tamper Alarm Reset", "Reset Allarme Manomissione", "Reset Alarme Falsification"}, {"FIre Alarm Reset", "Reset Allarme Incendio", "Reset Alarme Feu"}, {"Aggression Alarm Reset", "Reset Allarme Aggressione", "Reset Alarme Agression"}, {"Medic Alarm Reset", "Reset Allarme Medico", "Reset Medic-Alert"}, {"Aid Request Reset", "Reset Richiesta Soccorso", "Reset Demande Sauver"}, {"Gas Leak Alarm Reset", "Reset Allarme Fuga Gas", "Reset Alarme Fuite de gaz"}, {"Flooding Alarm Reset", "Reset Allarme Allagamento", "Reset Alarme Inondation"}, {"Fire Detector Fault Reset", "Reset Guasto Antincendio", "Reset Defectueux Feu"}, {"Fault Reset", "Reset Guasto", "Reset Defectueux"}, {"Perimetral Reset", "Reset Perimetrale", "Reset Perimetrique"}, {"Security Exit Reset", "Reset Uscita Sicurezza", "Reset Sortie Securite"}, {"Closing (Reset)", "Chiusura (Reset)", "Fermeture (Reset)"}, {"Opening (Reset)", "Apertura (Reset)", "Ouverture (Reset)"}, {"Ev. Code: 144", "Ev. Code: 144", "Ev. Code: 144"}, {"Ev. Code: 145", "Ev. Code: 145", "Ev. Code: 145"}, {"Switching off (Reset)", "Spegnimento (Reset)", "eteindre (Reset)"}, {"Switching on (Reset)", "Accensione (Reset)", "Allumage (Reset)"}, {"Mains Recovery", "Ripristino Rete 230", "Reseau de Recuperation 230"}, {"Battery OK", "Batteria OK", "Batterie OK"}, {"Battery Detected", "Batteria Presente", "Batteria Cette"}, {"Disarming", "Disinserimento", "Desarmant"}, {"Disarming Max Security", "Disinserimento Max Sicurezza", "Desarmant Maximale Securite"}, {"Exit Delay Stop", "Fine Tempo Uscita", "Fin Time Out"}, {"Key Point Disarming", "Disinserimento Punto Chiave", "Desarmant Point Cle"}, {"Dialer lock", "Blocco Combinat.", "Bloquer Combinat."}, {"System Access Stop", "Fine Accesso Sistema", "Systeme Acces Fin"}, {"Power Supply Fault Recovery", "Ripristino Guasto Alimentazione", "Restauration Defectueux Fournir "}, {"Phone Line Recovery", "Ripristino linea telefonica", "Restauration Ligne Telephonique"}, {"Day Change", "Cambio Giorno", "Echange Journee"}, {"Ev. Code: 160", "Ev. Code: 160", "Ev. Code: 160"}, {"Permanent Data Modification", "Modifica Dati Permanente", "Modification Donnees Permanent"}, {"Input Un-bypassed", "Inclusione Ingresso", "Inclusion Acces"}, {"Input Enabled", "Abilitazione Ingresso", "Activation Acces"}, {"Output Deactivated", "Disattivazione Uscita", "Desactivation Sortie"}, {"GSM Recording Restoration", "Ripristino registrazione GSM", "Restauration Enregistrement GSM"}, {"Ev. Code: 166", "Ev. Code: 166", "Ev. Code: 166"}, {"Ev. Code: 167", "Ev. Code: 167", "Ev. Code: 167"}, {"Keypad Tamper Reset", "Reset Manomissione Tastiera", "Reset Falsification Clavier"}, {"Ev. Code: 169", "Ev. Code: 169", "Ev. Code: 169"}, {"System Tamper Reset", "Reset Manomissione Impianto", "Reset Falsification Usine"}, {"Mains Fault Input Reset", "Ripristino Ingresso No Rete 230", "Restauration Entree No Reseau 230"}, {"Battery Input OK", "Ingresso Batteria OK", "Acces Batterie OK"}, {"Max Security Reset", "Reset Max. Sicurezza", "Reset Maximale Securite"}, {"Ev. Code: 174", "Ev. Code: 174", "Ev. Code: 174"}, {"Ev. Code: 175", "Ev. Code: 175", "Ev. Code: 175"}, {"General Alarm Ralay-", "Rele' Allarme Generale-", "Relay Alarme General-"}, {"Tamper Relay-", "Rele' Manomissione-", "Relay Falsification-"}, {"Fire Relay-", "Rele' Incendio-", "Relay Feu-"}, {"Pre-Alarm Relay-", "Rele' Preallarme-", "Relay Alerte Precoce-"}, {"Flooding/Gas Relay-", "Rele' Allagamento/Gas-", "Relay Inondations/Gaz-"}, {"Arming Relay-", "Rele' Inserimento-", "Relay Insertion-"}, {"Aid Relay-", "Rele' Soccorso-", "Relay Sauver-"}, {"Aggression Relay-", "Rele' Aggressione-", "Relay Agression-"}, {"Int Sounders Relay-", "Rele' Sirene int-", "Relay Sirenes int-"}, {"Alarm Mem. Relay-", "Rele' Mem. Allarme-", "Relay Mem. Alarme-"}, {"Fault Relay-", "Rele' Guasto inc.-", "Relay Defectueux inc.-"}, {"Part. Relay-", "Rele' Parzializz.-", "Relay Chocquant-"}, {"Exit Delay Relay-", "Rele' Tempo Usc.-", "Rele' Tempo Usc.-"}, {"Stop TVCC1", "Stop TVCC1", "Stop TVCC1"}, {"Stop TVCC2", "Stop TVCC2", "Stop TVCC2"}, {"Stop TVCC3", "Stop TVCC3", "Stop TVCC3"}, {"Line Cut Restore", "Ripristino Taglio Linea", "Restauration ligne Coupe"}, {"Line Short Circuit Restore", "Ripristino Corto Circuito Linea", "Restauration Court-Circuit Ligne "}, {"Transponder Tamper Restore", "Ripristino Manomissione Trasponder", "Restauration Falsification Trasponder"}, {"Ev. Code: 195", "Ev. Code: 195", "Ev. Code: 195"}, {"Ev. Code: 196", "Ev. Code: 196", "Ev. Code: 196"}, {"Remote Assistance Termination", "Fine TeleAssistenza", "Fin Teleassistance"}, {"Overtime Removed", "Eliminazione Straordinario", "elimination Extraordinaire"}, {"Credit Check SMS Restore", "Ripristino SMS Controllo Credito", "Restauration SMS Controle Credit"}, {"Statistic Alarm Reset", "Reset Allarme Statistico", "Reset Alarme Statistique"}, {"Ev. Code: 201", "Ev. Code: 201", "Ev. Code: 201"}, {"SMS Forwarding", "Inoltro SMS", "Avant SMS"}, {"Ev. Code: 203", "Ev. Code: 203", "Ev. Code: 203"}, {"Standard Time", "Ora Solare", "Heure Solaire"}, {"Presence Simulation Deactivation", "Disatt. Simulazione presenza", "Desactivation Simulation Presence"}, {"Ev. Code: 206", "Ev. Code: 206", "Ev. Code: 206"}, {"Communication Line Break Restore", "Rip. Interruzione Linea Comunicazione", "Rip. Interruption Ligne Communication"}, {"Technologic N. 1 Reset", "Reset Tecnologico N. 1", "Reset Technologique N. 1"}, {"Technologic N. 2 Reset", "Reset Tecnologico N. 2", "Reset Technologique N. 2"}, {"Technologic N. 3 Reset", "Reset Tecnologico N. 3", "Reset Technologique N. 3"}, {"Technologic N. 4 Reset", "Reset Tecnologico N. 4", "Reset Technologique N. 4"}, {"Technologic N. 5 Reset", "Reset Tecnologico N. 5", "Reset Technologique N. 5"}, {"Technologic N. 6 Reset", "Reset Tecnologico N. 6", "Reset Technologique N. 6"}, {"Technologic N. 7 Reset", "Reset Tecnologico N. 7", "Reset Technologique N. 7"}, {"Technologic N. 8 Reset", "Reset Tecnologico N. 8", "Reset Technologique N. 8"}, {"Perform Sensors Test", "Eseguire Test Sensori", "Faire Capteurs Test"}, {"Sensors Test Failed", "Test Sensori Fallito", "Capteurs Test echec"}, {"Output Deactivated", "Disattiv. Uscita", "Desactivation Sortie"}, {"Keypad Lock Terminated", "Fine Blocco Tastiera", "Fin Verrouiller Clavier"}, {"Gate Access <-", "Accesso Varco <-", "Acces Passage <-"}, {"Gate Enabling Terminated", "Fine Abilitazione Varco", "Fin Activation Passage"}, {"Bypassed Input Alarm Reset", "Reset Allarme Ingresso Escluso", "Reset Alarme Acces Exclusion"}, {"Input Auto-bypass Reset", "Reset Autoesclusione Ingresso", "Reset Auto-Exclusion Acces"}, {"Ev. Code: 224", "Ev. Code: 224", "Ev. Code: 224"}, {"Ev. Code: 225", "Ev. Code: 225", "Ev. Code: 225"}, {"Ev. Code: 226", "Ev. Code: 226", "Ev. Code: 226"}, {"Ev. Code: 227", "Ev. Code: 227", "Ev. Code: 227"}, {"Ev. Code: 228", "Ev. Code: 228", "Ev. Code: 228"}, {"Ev. Code: 229", "Ev. Code: 229", "Ev. Code: 229"}, {"Ev. Code: 230", "Ev. Code: 230", "Ev. Code: 230"}, {"Ev. Code: 231", "Ev. Code: 231", "Ev. Code: 231"}, {"Ev. Code: 232", "Ev. Code: 232", "Ev. Code: 232"}, {"Ev. Code: 233", "Ev. Code: 233", "Ev. Code: 233"}, {"Radio Sensor Battery OK", "Batteria Sensore Radio OK", "Batterie Capteur Radio OK"}, {"Ev. Code: 235", "Ev. Code: 235", "Ev. Code: 235"}, {"Radio Sensor Fault Restore", "Ripristino Guasto Sensore Radio", "Restauration Defectueux Capteur Radio"}, {"Radio Sounder Tamper Restore", "Ripristino Manomissione Sirena Radio", "Restauration Falsification Sirene Radio"}, {"Radio Sounder Battery OK", "Batteria Sirena Radio OK", "Batterie Sirene Radio OK"}, {"Ev. Code: 239", "Ev. Code: 239", "Ev. Code: 239"}, {"Radio Remote Control Battery OK", "Batteria Telecomando Radio OK", "Batterie Telecommande Radio OK"}, {"Antiscramble Terminated", "Fine Antiscramble", "Fin Antiscramble"}, {"Perform Output Test", "Eseguire Test Uscite", "Faire Test Sortie"}, {"Perform Dialer Test", "Eseguire Test Combinatore", "Faire Test Combineur"}, {"Round Terminated", "Fine Giro Ronda", "Fin Autour Patrouille"}};
    private static final String[] PROGRAM_TIMER = new String[]{"Program Timer", "Programm. Orario", "Programmation Heures"};
    private static final String[] REMOTE_CONTROL = new String[]{"Remote Control", "Controllo Remoto", "Controle a Distance"};
    private static final String[] ROUND = new String[]{"Round", "Giro Ronda", "Autour Patrouille"};
    private static final String[] PROX_CARD = new String[]{"Prox. Card", "Tessera Pross.", "Carte Pross."};
    private static final String[] INSTALLER = new String[]{"Installer", "Installatore", "Installer"};
    private static final String[] HOURS = new String[]{"Hours", "Ore", "Heur"};
    private static final String[] MINUTES = new String[]{"Minutes", "Minuti", "Minute"};
    private static final String[] KEYPAD = new String[]{"Keypad", "Tastiera", "Clavier"};
    private static final String[] OUTPUT = new String[]{"Output", "Uscita", "Sortie"};
    private static final String[] AREA = new String[]{"Area", "Area", "Zone"};
    private static final String[] MAIN_NUM_ATTEMPT = new String[]{"Main number, Attempt", "Numero principale, Tentativo", "Numero Principal, Tentative"};
    private static final String[] SECOND_NUM_ATTEMPT = new String[]{"Secondary number, Attempt", "Numero secondario, Tentativo", "Numero Secondaire, Tentative"};
    private static final String[] REMOTE_ASSISTANCE = new String[]{"Remote Assistance", "Teleassistenza", "Telecare"};
    private static final String[] RADIO_SOUNDER = new String[]{"Radio Sounder", "Sirena Radio", "Sirene Radio"};
    private static final String[] PANEL_STATUS = new String[]{"Panel Status", "Stato Centrale", "Etat Central"};
    private static final String[] INPUTS_STATUS = new String[]{"Input Status", "Stato Ingressi", "Etat Acces"};
    private static final String[] ALARMS_MEM = new String[]{"Alarms memory", "Memoria allarmi", "Memoire alarmi"};
    private static final String[] FAULTS = new String[]{"Faults", "Anomalie", "Anomalies"};
    private static final String[] OUTPUTS_STATUS = new String[]{"Output Status", "Stato Uscite", "Etat sortie"};
    private static final String[] BYPASSED_INPUTS = new String[]{"Bypassed Inputs", "Ingressi Esclusi", "Exclusion Entree"};
    private static final String[] PARTITIONS_STATUS = new String[]{"Partitions Status", "Stato settori", "Etat Secteurs"};
    private static final String[] REMINDER = new String[]{"Reminder", "Promemoria", "Rappel"};
    private static final String[] LOW_CREDIT = new String[]{"Low Credit", "Credito In Esaurimento", "Credit epuisement"};
    private static final String[] NO_CREDIT = new String[]{"No Credit", "Credito Esaurito", "Credit depense"};
    private static final String[] COMMAND_UNAVAILABLE = new String[]{"Command unavailable", "Comando non disponibile", "Commande no disponible"};
    private static final String[] ACCESS_DENIED = new String[]{"Access denied", "Accesso negato", "Acces refuse"};
    private static final String[] COMMAND_ERROR = new String[]{"Command execution error", "Errore esecuzione comando", "Erreur execution commande"};
    private static final int[][] eventsCat = new int[][]{{1, 129, 2, 130, 3, 131, 4, 132, 5, 133, 7, 135, 8, 136, 9, 137, 10, 138, 11, 139, 12, 140, 13, 141, 14, 142, 15, 143, 18, 146, 19, 147, 26, 154, 34, 162, 35, 163, 43, 171, 44, 172, 46, 64, 192, 65, 193, 66, 194, 72, 200, 80, 208, 81, 209, 82, 210, 83, 211, 84, 212, 85, 213, 86, 214, 87, 215, 217, 93, 221, 94, 222, 95, 223, 106, 234, 107, 108, 236, 117}, {6, 134}, {112, 240}, {23, 151, 24, 152, 28, 156, 45, 173, 77, 205}, {70, 198}, {39, 74, 92, 220, 116, 244}, {202}, {40, 168, 47}, {16, 17, 36, 164, 67, 68}, {25, 153}, {27}, {38}, {69, 197}, {109, 237, 110, 238, 111}, {75}, {71}, {79, 207}};
    private int max_inputs_num;
    private int max_groups_num;
    private int max_outputs_num;
    private int max_users_num;
    private int max_sounders_num;
    private int max_programs_num;
    private int max_keypads_num;
    private boolean interpet_logs;
    private Vector<Input> inputs;
    private Vector<Output> outputs;
    private Vector<Group> groups;
    private Vector<User> users;
    private Vector<Keypad> keypads;
    private int faultMains;
    private int panelTamper;
    private int faultBattery;
    private int rel_tamper;
    private int rel_alarm;
    private int sys_alarm;
    private int sys_tamper;
    private int sys_armed;
    private int sys_armed_max;
    private long logTime;
    private HashMap<Integer, Vector<String>> zoneSessions;

    public ELMO() {
        byte[] byArray = new byte[9];
        byArray[0] = 2;
        byArray[1] = 1;
        byArray[2] = 8;
        byArray[5] = 33;
        byArray[8] = 3;
        this.connect = byArray;
        byte[] byArray2 = new byte[9];
        byArray2[0] = 2;
        byArray2[1] = 1;
        byArray2[2] = 8;
        byArray2[5] = 36;
        byArray2[8] = 3;
        this.version_req = byArray2;
        byte[] byArray3 = new byte[9];
        byArray3[0] = 2;
        byArray3[1] = 1;
        byArray3[2] = 8;
        byArray3[5] = 63;
        byArray3[8] = 3;
        this.status_req = byArray3;
        byte[] byArray4 = new byte[9];
        byArray4[0] = 2;
        byArray4[1] = 1;
        byArray4[2] = 8;
        byArray4[5] = 44;
        byArray4[8] = 3;
        this.bypass_req = byArray4;
        byte[] byArray5 = new byte[12];
        byArray5[0] = 2;
        byArray5[1] = 4;
        byArray5[2] = 8;
        byArray5[5] = 61;
        byArray5[6] = 9;
        byArray5[11] = 3;
        this.group_names_req = byArray5;
        byte[] byArray6 = new byte[12];
        byArray6[0] = 2;
        byArray6[1] = 4;
        byArray6[2] = 8;
        byArray6[5] = 61;
        byArray6[6] = 10;
        byArray6[11] = 3;
        this.input_names_req = byArray6;
        byte[] byArray7 = new byte[12];
        byArray7[0] = 2;
        byArray7[1] = 4;
        byArray7[2] = 8;
        byArray7[5] = 61;
        byArray7[6] = 11;
        byArray7[11] = 3;
        this.user_names_req = byArray7;
        byte[] byArray8 = new byte[9];
        byArray8[0] = 2;
        byArray8[1] = 1;
        byArray8[2] = 8;
        byArray8[5] = 43;
        byArray8[8] = 3;
        this.event_log_req = byArray8;
        byte[] byArray9 = new byte[9];
        byArray9[0] = 2;
        byArray9[1] = 1;
        byArray9[2] = 8;
        byArray9[5] = 38;
        byArray9[8] = 3;
        this.reset_log_ptr_req = byArray9;
        byte[] byArray10 = new byte[29];
        byArray10[0] = 2;
        byArray10[1] = 21;
        byArray10[2] = 8;
        byArray10[5] = 45;
        byArray10[7] = 1;
        byArray10[9] = 1;
        byArray10[28] = 3;
        this.panel_cmd = byArray10;
        byte[] byArray11 = new byte[29];
        byArray11[0] = 2;
        byArray11[1] = 21;
        byArray11[2] = 8;
        byArray11[5] = 45;
        byArray11[7] = 9;
        byArray11[28] = 3;
        this.group_cmd = byArray11;
        byte[] byArray12 = new byte[29];
        byArray12[0] = 2;
        byArray12[1] = 21;
        byArray12[2] = 8;
        byArray12[5] = 45;
        byArray12[7] = 9;
        byArray12[11] = 9;
        byArray12[15] = 9;
        byArray12[19] = 9;
        byArray12[28] = 3;
        this.area_cmd = byArray12;
        byte[] byArray13 = new byte[29];
        byArray13[0] = 2;
        byArray13[1] = 21;
        byArray13[2] = 8;
        byArray13[5] = 45;
        byArray13[7] = 10;
        byArray13[28] = 3;
        this.input_cmd = byArray13;
        byte[] byArray14 = new byte[29];
        byArray14[0] = 2;
        byArray14[1] = 21;
        byArray14[2] = 8;
        byArray14[5] = 45;
        byArray14[7] = 12;
        byArray14[28] = 3;
        this.output_cmd = byArray14;
        this.interpet_logs = true;
        this.faultMains = -1;
        this.panelTamper = -1;
        this.faultBattery = -1;
        this.rel_tamper = 0;
        this.rel_alarm = 0;
        this.sys_alarm = -1;
        this.sys_tamper = -1;
        this.sys_armed = -1;
        this.sys_armed_max = -1;
        this.zoneSessions = new HashMap();
    }

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        try {
            this.userNum = Integer.parseInt(Configuration.ioServersUser.elementAt(ioIndex));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.password = Configuration.ioServersPassword.elementAt(ioIndex);
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("offlinelogs")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.offlineLogs = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.offlineLogs = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - offlinelogs ignored");
                    }
                } else if (param.equalsIgnoreCase("logsize")) {
                    try {
                        int l2 = Integer.parseInt(value);
                        if (l2 < 0) {
                            throw new Exception();
                        }
                        this.logSize = l2;
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - logsize ignored");
                    }
                } else if (param.equalsIgnoreCase("maxinput")) {
                    try {
                        int l3 = Integer.parseInt(value);
                        if (l3 < 0) {
                            throw new Exception();
                        }
                        this.max_inputs_num_opt = l3;
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxinput ignored");
                    }
                } else if (param.equalsIgnoreCase("maxoutput")) {
                    try {
                        int l4 = Integer.parseInt(value);
                        if (l4 < 0) {
                            throw new Exception();
                        }
                        this.max_outputs_num_opt = l4;
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxoutput ignored");
                    }
                } else if (param.equalsIgnoreCase("maxgroup")) {
                    try {
                        int l5 = Integer.parseInt(value);
                        if (l5 < 0) {
                            throw new Exception();
                        }
                        this.max_groups_num_opt = l5;
                    }
                    catch (Exception e6) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxgroup ignored");
                    }
                } else if (param.equalsIgnoreCase("maxuser")) {
                    try {
                        int l6 = Integer.parseInt(value);
                        if (l6 < 0) {
                            throw new Exception();
                        }
                        this.max_users_num_opt = l6;
                    }
                    catch (Exception e7) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxuser ignored");
                    }
                } else if (param.equalsIgnoreCase("userlogs")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.userLogs = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.userLogs = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - userlogs ignored");
                    }
                }
            }
            ++i2;
        }
        switch (Configuration.language) {
            case 1: {
                this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ITALIAN);
                this.language = 1;
                break;
            }
            case 2: {
                this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.FRENCH);
                this.language = 2;
                break;
            }
            default: {
                this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ENGLISH);
                this.language = 0;
            }
        }
        this.loadLogs();
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 33, this);
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "panel", "false");
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.init(me);
            if (!this.polling()) {
                throw new Exception("first polling failed");
            }
            SystemState.ioServersInitializedSet(ioIndex, true);
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e8) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e8);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            this.ioWrite(true, "connection", "online");
            Logger.log(Logger.Mode.SECURITY, "HSYCO - ONLINE", this.serverName);
            this.uiSet("log", "HSYCO - ONLINE");
            if (this.guiSupport) {
                this.updateZonesList();
            }
            this.genEvents = true;
        }
        catch (Exception e9) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Initializzation error - " + e9.getLocalizedMessage(), this.serverName);
            me.quit = true;
        }
        me.heartbeat = System.currentTimeMillis();
        try {
            String cmd = null;
            while (!me.quit) {
                cmd = this.ioqtx.poll(this.pollinterval, TimeUnit.SECONDS);
                if (cmd != null) {
                    do {
                        this.processCommand(cmd);
                    } while ((cmd = this.ioqtx.poll()) != null);
                }
                if (this.polling()) {
                    me.heartbeat = System.currentTimeMillis();
                }
                this.uiUpdate();
            }
        }
        catch (Exception e10) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e10.getLocalizedMessage(), this.serverName);
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (SystemState.ioGet(String.valueOf(this.serverName) + ".connection") == null || !SystemState.ioGet(String.valueOf(this.serverName) + ".connection").equals("offline")) {
            this.ioWrite(true, "connection", "offline");
            Logger.log(Logger.Mode.SECURITY, "HSYCO - OFFLINE", this.serverName);
            this.uiSet("log", "HSYCO - OFFLINE");
        }
    }

    private void init(ioMonitor me) throws Exception {
        int c2;
        StringBuilder name;
        int i2;
        Vector<Byte> resp = this.write(this.connect);
        StringBuilder conn = new StringBuilder();
        try {
            i2 = 5;
            while (i2 <= 11) {
                conn.append((char)resp.get(i2).byteValue());
                ++i2;
            }
            if (!conn.toString().equals("CONNECT")) {
                throw new Exception("resp = " + conn.toString());
            }
        }
        catch (Exception e2) {
            throw new Exception("Connection response error: " + e2.getMessage(), e2);
        }
        resp = this.write(this.version_req);
        conn = new StringBuilder();
        try {
            i2 = 5;
            while (i2 <= 20) {
                conn.append((char)resp.get(i2).byteValue());
                ++i2;
            }
        }
        catch (Exception e3) {
            throw new Exception("Version response error: " + e3.getMessage(), e3);
        }
        Logger.log(Logger.Mode.EVENT, "ioMonitor - Connection established - Panel: " + conn.toString().trim(), this.serverName);
        me.heartbeat = System.currentTimeMillis();
        int pClass = resp.get(21) & 0xFF;
        if (pClass == 20) {
            this.max_inputs_num = 48;
            this.max_groups_num = 8;
            this.max_outputs_num = 0;
            this.max_users_num = 16;
            this.max_sounders_num = 15;
            this.max_programs_num = 0;
            this.max_keypads_num = 0;
        } else if (pClass == 31) {
            this.max_inputs_num = 48;
            this.max_groups_num = 16;
            this.max_outputs_num = 48;
            this.max_users_num = 64;
            this.max_sounders_num = 0;
            this.max_programs_num = 24;
            this.max_keypads_num = 8;
        } else if (pClass == 23 || pClass == 55) {
            this.max_inputs_num = 104;
            this.max_groups_num = 32;
            this.max_outputs_num = 104;
            this.max_users_num = 128;
            this.max_sounders_num = 15;
            this.max_programs_num = 24;
            this.max_keypads_num = 16;
        } else if (pClass == 24 || pClass == 56) {
            this.max_inputs_num = 128;
            this.max_groups_num = 32;
            this.max_outputs_num = 128;
            this.max_users_num = 256;
            this.max_sounders_num = 15;
            this.max_programs_num = 24;
            this.max_keypads_num = 32;
        } else if (pClass == 25 || pClass == 57) {
            this.max_inputs_num = 256;
            this.max_groups_num = 32;
            this.max_outputs_num = 256;
            this.max_users_num = 256;
            this.max_sounders_num = 15;
            this.max_programs_num = 24;
            this.max_keypads_num = 32;
        } else if (pClass == 26 || pClass == 58) {
            this.max_inputs_num = 512;
            this.max_groups_num = 32;
            this.max_outputs_num = 512;
            this.max_users_num = 256;
            this.max_sounders_num = 15;
            this.max_programs_num = 24;
            this.max_keypads_num = 32;
        } else if (pClass == 39) {
            this.max_inputs_num = 16;
            this.max_groups_num = 8;
            this.max_outputs_num = 16;
            this.max_users_num = 10;
            this.max_sounders_num = 0;
            this.max_programs_num = 0;
            this.max_keypads_num = 3;
        } else if (pClass == 50) {
            this.max_inputs_num = 32;
            this.max_groups_num = 4;
            this.max_outputs_num = 32;
            this.max_users_num = 10;
            this.max_sounders_num = 0;
            this.max_programs_num = 8;
            this.max_keypads_num = 6;
        } else if (pClass == 41) {
            this.max_inputs_num = 104;
            this.max_groups_num = 4;
            this.max_outputs_num = 104;
            this.max_users_num = 64;
            this.max_sounders_num = 0;
            this.max_programs_num = 8;
            this.max_keypads_num = 12;
        } else if (pClass == 80 || pClass == 81) {
            this.max_inputs_num = 64;
            this.max_groups_num = 16;
            this.max_outputs_num = 64;
            this.max_users_num = 32;
            this.max_sounders_num = 15;
            this.max_programs_num = 16;
            this.max_keypads_num = 16;
        } else if (pClass == 90) {
            this.max_inputs_num = 104;
            this.max_groups_num = 16;
            this.max_outputs_num = 104;
            this.max_users_num = 64;
            this.max_sounders_num = 16;
            this.max_programs_num = 4;
            this.max_keypads_num = 16;
        } else if (pClass == 91 || pClass == 107) {
            this.max_inputs_num = 48;
            this.max_groups_num = 16;
            this.max_outputs_num = 48;
            this.max_users_num = 32;
            this.max_sounders_num = 16;
            this.max_programs_num = 4;
            this.max_keypads_num = 16;
        } else if (pClass == 112 || pClass == 64) {
            this.max_inputs_num = 1024;
            this.max_groups_num = 64;
            this.max_outputs_num = 1024;
            this.max_users_num = 1024;
            this.max_sounders_num = 96;
            this.max_programs_num = 32;
            this.max_keypads_num = 32;
            this.interpet_logs = false;
        } else if (pClass == 113) {
            this.max_inputs_num = 256;
            this.max_groups_num = 64;
            this.max_outputs_num = 256;
            this.max_users_num = 1024;
            this.max_sounders_num = 96;
            this.max_programs_num = 32;
            this.max_keypads_num = 32;
            this.interpet_logs = false;
        } else if (pClass == 114) {
            this.max_inputs_num = 128;
            this.max_groups_num = 64;
            this.max_outputs_num = 128;
            this.max_users_num = 1024;
            this.max_sounders_num = 96;
            this.max_programs_num = 32;
            this.max_keypads_num = 32;
            this.interpet_logs = false;
        } else {
            throw new Exception("Unknown panel class: " + Integer.toHexString(pClass));
        }
        if (this.password != null && !this.password.isEmpty()) {
            if (this.password.length() % 2 == 1) {
                this.password = String.valueOf(this.password) + "F";
            }
            int dataLen = 3 + this.password.length() / 2;
            byte[] access_req = new byte[8 + dataLen];
            access_req[0] = 2;
            access_req[1] = (byte)dataLen;
            access_req[2] = 8;
            access_req[3] = 0;
            access_req[4] = 0;
            access_req[5] = 65;
            access_req[6] = (byte)(this.userNum >>> 8);
            access_req[7] = (byte)this.userNum;
            int i3 = 0;
            while (i3 < this.password.length() / 2) {
                int n1 = Integer.parseInt(this.password.substring(i3 * 2, i3 * 2 + 1), 16);
                int n2 = Integer.parseInt(this.password.substring(i3 * 2 + 1, i3 * 2 + 2), 16);
                access_req[8 + i3] = (byte)(n1 << 4 | n2);
                ++i3;
            }
            access_req[access_req.length - 1] = 3;
            resp = this.write(access_req);
            byte res = resp.get(5);
            if ((resp.get(1) & 0xFF) > 1 || res != 6) {
                String err = res == 5 ? "command unavailable" : (res == 7 ? "user/password error" : (res == 21 ? "NAK received" : "unknown error"));
                throw new Exception("Access error: " + err);
            }
        }
        if (this.max_inputs_num_opt > this.max_inputs_num) {
            this.max_inputs_num_opt = this.max_inputs_num;
        }
        if (this.max_outputs_num_opt > this.max_outputs_num) {
            this.max_outputs_num_opt = this.max_outputs_num;
        }
        if (this.max_groups_num_opt > this.max_groups_num) {
            this.max_groups_num_opt = this.max_groups_num;
        }
        if (this.max_users_num_opt > this.max_users_num) {
            this.max_users_num_opt = this.max_users_num;
        }
        this.inputs = new Vector(this.max_inputs_num_opt);
        this.outputs = new Vector(this.max_outputs_num_opt);
        this.groups = new Vector(this.max_groups_num_opt);
        this.users = new Vector(this.max_users_num_opt);
        this.keypads = new Vector(this.max_keypads_num);
        int i4 = 1;
        while (i4 <= this.max_keypads_num) {
            this.keypads.add(new Keypad(i4));
            ++i4;
        }
        this.ioWrite(this.genEvents, "tamper", "0");
        this.ioWrite(this.genEvents, "rel.tamper", "0");
        this.ioWrite(this.genEvents, "rel.alarm", "0");
        i4 = 1;
        while (i4 <= this.max_groups_num_opt) {
            this.group_names_req[7] = (byte)(i4 >>> 8);
            this.group_names_req[8] = (byte)i4;
            resp = this.write(this.group_names_req);
            if (resp.get(5) > 21) {
                name = new StringBuilder();
                c2 = 5;
                while (c2 <= resp.size() - 4) {
                    name.append((char)resp.get(c2).byteValue());
                    ++c2;
                }
                this.groups.add(new Group(i4, name.toString()));
            }
            me.heartbeat = System.currentTimeMillis();
            ++i4;
        }
        i4 = 1;
        while (i4 <= this.max_inputs_num_opt) {
            this.input_names_req[7] = (byte)(i4 >>> 8);
            this.input_names_req[8] = (byte)i4;
            resp = this.write(this.input_names_req);
            if (resp.get(5) > 21) {
                name = new StringBuilder();
                c2 = 5;
                while (c2 <= resp.size() - 4) {
                    name.append((char)resp.get(c2).byteValue());
                    ++c2;
                }
                this.inputs.add(new Input(i4, name.toString()));
            }
            me.heartbeat = System.currentTimeMillis();
            ++i4;
        }
        i4 = 1;
        while (i4 <= this.max_outputs_num_opt) {
            this.outputs.add(new Output(i4));
            ++i4;
        }
        i4 = 1;
        while (i4 <= this.max_users_num_opt) {
            this.user_names_req[7] = (byte)(i4 >>> 8);
            this.user_names_req[8] = (byte)i4;
            resp = this.write(this.user_names_req);
            if (resp.get(5) > 21) {
                name = new StringBuilder();
                c2 = 5;
                while (c2 <= resp.size() - 4) {
                    name.append((char)resp.get(c2).byteValue());
                    ++c2;
                }
                this.users.add(new User(i4, name.toString()));
            }
            me.heartbeat = System.currentTimeMillis();
            ++i4;
        }
        if (!this.offlineLogs) {
            this.write(this.reset_log_ptr_req);
        }
    }

    private void loadLogs() {
        try {
            StringBuilder sb = new StringBuilder();
            this.logs = new Vector(this.logSize);
            String persistentlog = SystemState.varGet("__hsyco__elmo." + this.serverName + ".log!");
            if (persistentlog != null) {
                int i2 = 0;
                while (i2 < persistentlog.length()) {
                    char c2 = persistentlog.charAt(i2);
                    if (c2 != ';') {
                        sb.append(c2);
                    } else if (i2 + 1 < persistentlog.length() && persistentlog.charAt(i2 + 1) == ';') {
                        sb.append(c2);
                        ++i2;
                    } else {
                        this.logs.add(sb.toString());
                        if (this.logs.size() >= this.logSize) break;
                        sb = new StringBuilder();
                    }
                    ++i2;
                }
                if (this.logs.size() < this.logSize && sb.length() > 0) {
                    this.logs.add(sb.toString());
                }
            }
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "Error loading saved logs", this.serverName);
        }
    }

    private void saveLogs() {
        try {
            StringBuilder persistentlog = new StringBuilder();
            int i2 = 0;
            while (i2 < this.logs.size()) {
                String line = this.logs.get(i2).replace(";", ";;");
                if (line.length() > 0) {
                    if (persistentlog.length() > 0) {
                        persistentlog.append(';');
                    }
                    persistentlog.append(line);
                }
                ++i2;
            }
            SystemState.varSet("__hsyco__elmo." + this.serverName + ".log!", persistentlog.toString());
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "Error saving logs", this.serverName);
        }
    }

    private void updateZonesList() {
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        ArrayList<Input> set = new ArrayList<Input>(this.inputs);
        Collections.sort(set, new Comparator<Input>(){

            @Override
            public int compare(Input i1, Input i2) {
                return i1.name.toLowerCase().compareTo(i2.name.toLowerCase());
            }
        });
        for (Input i2 : set) {
            values.append(",").append(i2.idx);
            labels.append(",").append(i2.getListLabel());
        }
        if (values.length() > 1) {
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "values", values.substring(1));
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "labels", labels.substring(1));
        }
    }

    public String keypad(String session, String userId, String id) {
        if (this.guiSupport) {
            String value;
            String name;
            block17: {
                String zoneId;
                block16: {
                    Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
                    try {
                        int val_idx = id.lastIndexOf(46);
                        name = id.substring(0, val_idx);
                        value = id.substring(val_idx + 1);
                        if (!name.equals("zones.list")) break block16;
                        Input i2 = null;
                        int v = Integer.parseInt(value);
                        for (Input in : this.inputs) {
                            if (in.idx != v) continue;
                            i2 = in;
                            break;
                        }
                        if (i2 != null) {
                            userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.cont", "visible", "true");
                            userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value", Integer.toString(i2.idx));
                            userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.name", "value", i2.name);
                            userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.open.label", "visible", i2.open == 1 ? "true" : "false");
                            userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.alarm.label", "visible", i2.alarm == 1 ? "true" : "false");
                            userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.bypassed.label", "visible", i2.bypassed == 1 ? "true" : "false");
                            userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.tamper.label", "visible", i2.tamper == 1 ? "true" : "false");
                            Vector<String> s = this.zoneSessions.get(i2.idx);
                            if (s == null) {
                                s = new Vector();
                            }
                            s.add(session);
                            this.zoneSessions.put(i2.idx, s);
                        }
                        return "";
                    }
                    catch (Exception e2) {
                        Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                        return null;
                    }
                }
                if (!name.equals("zone.sel")) break block17;
                if (value.equals("close")) {
                    int idx;
                    Vector<String> s;
                    String currId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value", "");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.cont", "visible", "false");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.name", "value", "--");
                    if (currId != null && (s = this.zoneSessions.get(idx = Integer.parseInt(currId))) != null) {
                        s.remove(session);
                        if (s.isEmpty()) {
                            this.zoneSessions.remove(idx);
                        }
                    }
                } else if (value.equals("bypass")) {
                    String zoneId2 = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value");
                    if (zoneId2 != null && !zoneId2.equals("")) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".i" + zoneId2 + ".bypassed", "1");
                    }
                } else if (value.equals("unbypass") && (zoneId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value")) != null && !zoneId.equals("")) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".i" + zoneId + ".bypassed", "0");
                }
                return "";
            }
            SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private boolean polling() {
        block190: {
            block191: {
                block189: {
                    resp = this.write(this.status_req);
                    if ((resp.get(1) & 255) > 1) {
                        inLen = resp.get(5) & 255;
                        mInLen = resp.get(6) & 255;
                        outLen = resp.get(7) & 255;
                        dedOutLen = resp.get(8) & 255;
                        mDedOutLen = resp.get(9) & 255;
                        grLen = resp.get(10) & 255;
                        grParLen = resp.get(11) & 255;
                        grMaxLen = resp.get(12) & 255;
                        faultLen = resp.get(13) & 255;
                        i = 0;
                        while (i < inLen) {
                            map = resp.get(14 + i);
                            b = 7;
                            while (b >= 0) {
                                val = map >>> b & 1;
                                try {
                                    this.inputs.get(i * 8 + 7 - b).setOpen(val);
                                }
                                catch (ArrayIndexOutOfBoundsException var15_19) {
                                    // empty catch block
                                }
                                --b;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < mInLen) {
                            map = resp.get(14 + inLen + i);
                            b = 7;
                            while (b >= 0) {
                                val = map >>> b & 1;
                                try {
                                    this.inputs.get(i * 8 + 7 - b).setAlarm(val);
                                    this.setSysAlarm(val);
                                }
                                catch (ArrayIndexOutOfBoundsException var15_21) {
                                    // empty catch block
                                }
                                --b;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < outLen) {
                            map = resp.get(14 + inLen + mInLen + i);
                            b = 7;
                            while (b >= 0) {
                                val = map >>> b & 1;
                                try {
                                    this.outputs.get(i * 8 + 7 - b).setStatus(val);
                                }
                                catch (ArrayIndexOutOfBoundsException var15_22) {
                                    // empty catch block
                                }
                                --b;
                            }
                            ++i;
                        }
                        if (dedOutLen > 0) {
                            map = resp.get(14 + inLen + mInLen + outLen);
                            val = map & 1;
                            this.ioWrite(this.genEvents, "out.alarm", "" + val);
                            val = map >>> 1 & 1;
                            this.ioWrite(this.genEvents, "out.tamper", "" + val);
                        }
                        if (mDedOutLen > 0) {
                            map = resp.get(14 + inLen + mInLen + outLen + dedOutLen);
                            val = map & 1;
                            this.ioWrite(this.genEvents, "out.alarm.mem", "" + val);
                            val = map >>> 1 & 1;
                            this.ioWrite(this.genEvents, "out.tamper.mem", "" + val);
                        }
                        i = 0;
                        while (i < grLen) {
                            map = resp.get(14 + inLen + mInLen + outLen + dedOutLen + mDedOutLen + i);
                            b = 7;
                            while (b >= 0) {
                                val = map >>> b & 1;
                                try {
                                    this.groups.get(i * 8 + 7 - b).setArmed(val);
                                    this.setSysArmed(val);
                                }
                                catch (ArrayIndexOutOfBoundsException var15_23) {
                                    // empty catch block
                                }
                                --b;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < grParLen) {
                            map = resp.get(14 + inLen + mInLen + outLen + dedOutLen + mDedOutLen + grLen + i);
                            b = 7;
                            while (b >= 0) {
                                val = map >>> b & 1;
                                try {
                                    this.groups.get(i * 8 + 7 - b).setPartial(val);
                                }
                                catch (ArrayIndexOutOfBoundsException var15_24) {
                                    // empty catch block
                                }
                                --b;
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < grMaxLen) {
                            map = resp.get(14 + inLen + mInLen + outLen + dedOutLen + mDedOutLen + grLen + grParLen + i);
                            b = 7;
                            while (b >= 0) {
                                val = map >>> b & 1;
                                try {
                                    this.groups.get(i * 8 + 7 - b).setArmedMax(val);
                                    this.setSysArmedMax(val);
                                }
                                catch (ArrayIndexOutOfBoundsException var15_25) {
                                    // empty catch block
                                }
                                --b;
                            }
                            ++i;
                        }
                        if (faultLen > 0) {
                            map = resp.get(14 + inLen + mInLen + outLen + dedOutLen + mDedOutLen + grLen + grParLen + grMaxLen);
                            val = map & 1;
                            if (this.faultMains != val) {
                                this.faultMains = val;
                                this.ioWrite(this.genEvents, "fault.mains", "" + val);
                            }
                            if (this.faultBattery != (val = map >>> 1 & 1)) {
                                this.faultBattery = val;
                                this.ioWrite(this.genEvents, "fault.battery", "" + val);
                            }
                            if (this.panelTamper != (val = map >>> 2 & 1)) {
                                this.panelTamper = val;
                                this.ioWrite(this.genEvents, "panel.tamper", "" + val);
                            }
                        }
                        break block189;
                    }
                    res = resp.get(5);
                    if (res == 5) {
                        Logger.log(Logger.Mode.ERROR, "polling - command unavailable", this.serverName);
                    } else if (res == 7) {
                        Logger.log(Logger.Mode.ERROR, "polling - access denied", this.serverName);
                    } else if (res == 21) {
                        Logger.log(Logger.Mode.ERROR, "polling - NAK received", this.serverName);
                    }
                    return false;
                }
                try {
                    resp = this.write(this.bypass_req);
                    if ((resp.get(1) & 255) > 1) {
                        inLen = resp.get(5) & 255;
                        i = 0;
                        while (i < inLen) {
                            map = resp.get(6 + i);
                            b = 7;
                            while (b >= 0) {
                                val = map >>> b & 1;
                                try {
                                    this.inputs.get(i * 8 + 7 - b).setBypassed(val);
                                }
                                catch (ArrayIndexOutOfBoundsException grLen) {
                                    // empty catch block
                                }
                                --b;
                            }
                            ++i;
                        }
                    } else {
                        res = resp.get(5);
                        if (res == 5) {
                            Logger.log(Logger.Mode.ERROR, "polling - command unavailable", this.serverName);
                        } else if (res == 7) {
                            Logger.log(Logger.Mode.ERROR, "polling - access denied", this.serverName);
                        } else if (res == 21) {
                            Logger.log(Logger.Mode.ERROR, "polling - NAK received", this.serverName);
                        }
                        return false;
                    }
                    if (true) ** GOTO lbl506
                }
                catch (IOException e) {
                    Logger.log(Logger.Mode.VERBOSE, "polling - IOException: " + e.getLocalizedMessage(), this.serverName);
                    return false;
                }
                {
                    do {
                        event = resp.get(5) & 255;
                        par_h = resp.get(6) & 255;
                        par_l = resp.get(7) & 255;
                        par = (par_h << 8) + par_l;
                        day = resp.get(8);
                        day_h = day >>> 4 & 15;
                        day_l = day & 15;
                        month = resp.get(9);
                        month_h = month >>> 4 & 15;
                        month_l = month & 15;
                        year = resp.get(10);
                        year_h = year >>> 4 & 15;
                        year_l = year & 15;
                        hour = resp.get(11);
                        hour_h = hour >>> 4 & 15;
                        hour_l = hour & 15;
                        min = resp.get(12);
                        min_h = min >>> 4 & 15;
                        min_l = min & 15;
                        if (event == 64 || event == 65) {
                            try {
                                this.inputs.get(par - 1).setTamper(1);
                                this.setSysTamper(1);
                            }
                            catch (ArrayIndexOutOfBoundsException var21_33) {}
                        } else if (event == 192 || event == 193) {
                            try {
                                this.inputs.get(par - 1).setTamper(0);
                                this.setSysTamper(0);
                            }
                            catch (ArrayIndexOutOfBoundsException var21_34) {}
                        } else if (event == 49) {
                            if (this.rel_tamper != 1) {
                                this.rel_tamper = 1;
                                this.ioWrite(this.genEvents, "rel.tamper", "1");
                            }
                        } else if (event == 177) {
                            if (this.rel_tamper != 0) {
                                this.rel_tamper = 0;
                                this.ioWrite(this.genEvents, "rel.tamper", "0");
                            }
                        } else if (event == 48) {
                            if (this.rel_alarm != 1) {
                                this.rel_alarm = 1;
                                this.ioWrite(this.genEvents, "rel.alarm", "1");
                            }
                        } else if (event == 176) {
                            if (this.rel_alarm != 0) {
                                this.rel_alarm = 0;
                                this.ioWrite(this.genEvents, "rel.alarm", "0");
                            }
                        } else if (event == 40) {
                            this.keypads.get(par_l - 1).setTamper(1);
                        } else if (event == 168) {
                            this.keypads.get(par_l - 1).setTamper(0);
                        }
                        if (!this.interpet_logs) continue;
                        date_log = new StringBuilder();
                        log = new StringBuilder();
                        if (day != 255) {
                            date_log.append("20").append(year_h).append(year_l).append("/").append(month_h).append(month_l).append("/").append(day_h).append(day_l).append(" ").append(hour_h).append(hour_l).append(":").append(min_h).append(min_l).append(" ");
                        }
                        try {
                            log.append(ELMO.EVENTS[event][this.language]);
                        }
                        catch (Exception var23_36) {
                            // empty catch block
                        }
                        if (this.isCategory(1, event)) {
                            log.append(" - ");
                            try {
                                log.append(Input.access$0(this.inputs.get(par - 1)));
                            }
                            catch (ArrayIndexOutOfBoundsException var23_37) {}
                        } else if (this.isCategory(2, event)) {
                            log.append(" - ");
                            if (par < this.max_inputs_num) {
                                try {
                                    log.append(Input.access$0(this.inputs.get(par - 1)));
                                }
                                catch (ArrayIndexOutOfBoundsException var23_38) {}
                            } else {
                                par = par - this.max_inputs_num - this.max_sounders_num - 1;
                                try {
                                    log.append(User.access$0(this.users.get(par)));
                                }
                                catch (ArrayIndexOutOfBoundsException var23_39) {}
                            }
                        } else if (this.isCategory(3, event)) {
                            log.append(" - ");
                            par = par - this.max_inputs_num - this.max_sounders_num - 1;
                            try {
                                log.append(User.access$0(this.users.get(par)));
                            }
                            catch (ArrayIndexOutOfBoundsException var23_40) {}
                        } else if (this.isCategory(4, event)) {
                            log.append(" - ");
                            if (par == 65535) {
                                log.append(ELMO.PROGRAM_TIMER[this.language]);
                            } else if (par == 65534) {
                                log.append(ELMO.REMOTE_CONTROL[this.language]);
                            } else if (par == 65532) {
                                log.append(ELMO.ROUND[this.language]);
                            } else if (par == 65531) {
                                log.append(ELMO.PROX_CARD[this.language]);
                            } else if (par == 0) {
                                log.append(ELMO.INSTALLER[this.language]);
                            } else {
                                try {
                                    log.append(User.access$0(this.users.get(par - 1)));
                                }
                                catch (ArrayIndexOutOfBoundsException var23_41) {}
                            }
                        } else if (this.isCategory(5, event)) {
                            log.append(" - ");
                            if (par_h == 0 && par_l < this.max_programs_num) {
                                log.append("Prog. N. " + par_l);
                            } else {
                                h = par_h / 4;
                                m = par_h % 4 * 15;
                                log.append("Prog. N. " + par_l + ", " + h + " " + ELMO.HOURS[this.language] + " " + m + " " + ELMO.MINUTES[this.language]);
                            }
                        } else if (this.isCategory(6, event)) {
                            log.append(" - ");
                            if (par == 0) {
                                log.append(ELMO.INSTALLER[this.language]);
                            } else {
                                try {
                                    log.append(User.access$0(this.users.get(par - 1)));
                                }
                                catch (ArrayIndexOutOfBoundsException var23_43) {}
                            }
                        } else if (this.isCategory(7, event)) {
                            log.append(" - ");
                            log.append("SMS Num. " + par);
                        } else if (this.isCategory(8, event)) {
                            log.append(" - ");
                            if (par_h == 34) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Etr zenith]");
                            } else if (par_h == 35) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Nirva]");
                            } else if (par_h == 36) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Etr varco]");
                            } else if (par_h == 37) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Etr i8]");
                            } else {
                                try {
                                    log.append(User.access$0(this.users.get(par - 1)));
                                }
                                catch (ArrayIndexOutOfBoundsException var23_44) {}
                            }
                        } else if (this.isCategory(9, event)) {
                            log.append(" - ");
                            log.append(String.valueOf(ELMO.OUTPUT[this.language]) + " N. " + par);
                        } else if (this.isCategory(10, event)) {
                            log.append(" - ");
                            log.append(String.valueOf(ELMO.AREA[this.language]) + " N. " + par);
                        } else if (this.isCategory(11, event)) {
                            log.append(" - ");
                            log.append(par);
                        } else if (this.isCategory(12, event)) {
                            log.append(" - ");
                            if (par_h != 0) {
                                log.append("SMS Num. " + par_h);
                            } else if ((par_l & 192) == 128) {
                                log.append("PSTN Num. " + (par_l & 63));
                            } else if ((par_l & 192) == 192) {
                                log.append("GSM Num. " + (par_l & 63));
                            } else if ((par_l & 192) == 0) {
                                if ((par_l & 1) == 0) {
                                    log.append("PSTN " + ELMO.MAIN_NUM_ATTEMPT[this.language] + " " + (par_l >>> 1 & 31) + 1);
                                } else {
                                    log.append("PSTN " + ELMO.SECOND_NUM_ATTEMPT[this.language] + " " + (par_l >>> 1 & 31) + 1);
                                }
                            } else if ((par_l & 1) == 0) {
                                log.append("GSM " + ELMO.MAIN_NUM_ATTEMPT[this.language] + " " + (par_l >>> 1 & 31) + 1);
                            } else {
                                log.append("GSM " + ELMO.SECOND_NUM_ATTEMPT[this.language] + " " + (par_l >>> 1 & 31) + 1);
                            }
                        } else if (this.isCategory(13, event)) {
                            log.append(" - ");
                            if (par_l == 0) {
                                log.append(String.valueOf(ELMO.REMOTE_ASSISTANCE[this.language]) + " PSTN");
                            } else {
                                log.append(String.valueOf(ELMO.REMOTE_ASSISTANCE[this.language]) + " GSM");
                            }
                        } else if (this.isCategory(14, event)) {
                            log.append(" - ");
                            log.append(String.valueOf(ELMO.RADIO_SOUNDER[this.language]) + " N. " + (par - this.max_inputs_num));
                        } else if (this.isCategory(15, event)) {
                            log.append(" - ");
                            switch (par) {
                                case 0: {
                                    log.append(ELMO.PANEL_STATUS[this.language]);
                                    break;
                                }
                                case 1: {
                                    log.append(ELMO.INPUTS_STATUS[this.language]);
                                    break;
                                }
                                case 2: {
                                    log.append(ELMO.ALARMS_MEM[this.language]);
                                    break;
                                }
                                case 3: {
                                    log.append(ELMO.FAULTS[this.language]);
                                    break;
                                }
                                case 4: {
                                    log.append(ELMO.OUTPUTS_STATUS[this.language]);
                                    break;
                                }
                                case 5: {
                                    log.append(ELMO.BYPASSED_INPUTS[this.language]);
                                    break;
                                }
                                case 6: {
                                    log.append(ELMO.PARTITIONS_STATUS[this.language]);
                                }
                            }
                        } else if (this.isCategory(16, event)) {
                            log.append(" - ");
                            switch (par) {
                                case 0: {
                                    log.append(ELMO.REMINDER[this.language]);
                                    break;
                                }
                                case 1: {
                                    log.append(ELMO.LOW_CREDIT[this.language]);
                                    break;
                                }
                                case 2: {
                                    log.append(ELMO.NO_CREDIT[this.language]);
                                }
                            }
                        } else if (this.isCategory(17, event)) {
                            log.append(" - ");
                            if (par_h == 34) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Etr zenith]");
                            } else if (par_h == 35) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Nirva]");
                            } else if (par_h == 36) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Etr varco]");
                            } else if (par_h == 37) {
                                log.append(String.valueOf(ELMO.KEYPAD[this.language]) + " N. " + par_l + " [Etr i8]");
                            } else {
                                try {
                                    log.append(Input.access$0(this.inputs.get(par - 1)));
                                }
                                catch (ArrayIndexOutOfBoundsException var23_45) {
                                    // empty catch block
                                }
                            }
                        }
                        this.uiSet("log", log.toString());
                        date_log.append((CharSequence)log);
                        Logger.log(Logger.Mode.SECURITY, date_log.toString(), this.serverName);
lbl506:
                        // 3 sources

                    } while (((resp = this.write(this.event_log_req)).get(1) & 255) > 1 && resp.get(5) != 0);
                    if ((resp.get(1) & 255) > 1) break block190;
                    res = resp.get(5);
                    if (res == 5) {
                        Logger.log(Logger.Mode.ERROR, "polling - command unavailable", this.serverName);
                        break block191;
                    }
                    if (res == 7) {
                        Logger.log(Logger.Mode.ERROR, "polling - access denied", this.serverName);
                        break block191;
                    }
                    if (res != 21) break block191;
                    Logger.log(Logger.Mode.ERROR, "polling - NAK received", this.serverName);
                }
            }
            return false;
        }
        return true;
    }

    private void setSysArmedMax(int val) {
        if (this.sys_armed_max != val) {
            if (val == 1) {
                this.sys_armed_max = 1;
                this.ioWrite(this.genEvents, "armed.max", "1");
            } else {
                for (Group g2 : this.groups) {
                    if (g2.armedMax == 0) continue;
                    return;
                }
                this.sys_armed_max = 0;
                this.ioWrite(this.genEvents, "armed.max", "0");
            }
        }
    }

    private void setSysArmed(int val) {
        if (this.sys_armed != val) {
            if (val == 1) {
                this.sys_armed = 1;
                this.ioWrite(this.genEvents, "armed", "1");
            } else {
                for (Group g2 : this.groups) {
                    if (g2.armed == 0) continue;
                    return;
                }
                this.sys_armed = 0;
                this.ioWrite(this.genEvents, "armed", "0");
            }
        }
    }

    private void setSysAlarm(int val) {
        if (this.sys_alarm != val) {
            if (val == 1) {
                this.sys_alarm = 1;
                this.ioWrite(this.genEvents, "alarm", "1");
            } else {
                for (Input i2 : this.inputs) {
                    if (i2.alarm == 0) continue;
                    return;
                }
                this.sys_alarm = 0;
                this.ioWrite(this.genEvents, "alarm", "0");
            }
        }
    }

    private void setSysTamper(int val) {
        if (this.sys_tamper != val) {
            if (val == 1) {
                this.sys_tamper = 1;
                this.ioWrite(this.genEvents, "tamper", "1");
            } else {
                for (Input i2 : this.inputs) {
                    if (i2.tamper == 0) continue;
                    return;
                }
                this.sys_tamper = 0;
                this.ioWrite(this.genEvents, "tamper", "0");
            }
        }
    }

    private boolean isCategory(int category, int event) {
        int[] evs;
        int[] nArray = evs = eventsCat[category - 1];
        int n2 = evs.length;
        int n3 = 0;
        while (n3 < n2) {
            int e2 = nArray[n3];
            if (e2 == event) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private void processCommand(String cmd) {
        Logger.log(Logger.Mode.EVENT, "commandExecutor - processing command: " + cmd, this.serverName);
        cmd = cmd.toLowerCase();
        try {
            String[] ev_val = cmd.split("=");
            String ev = ev_val[0];
            String val = ev_val[1];
            int dot = ev.indexOf(46);
            if (dot == -1) {
                if (ev.startsWith("o")) {
                    int o2 = Integer.parseInt(ev.substring(1));
                    this.commandExecutor(Cmd.OUTPUT, o2, 0, null, val);
                    return;
                }
                this.commandExecutor(Cmd.PANEL, 0, 0, ev, val);
                return;
            }
            String prefix = ev.substring(0, dot);
            String func = ev.substring(dot + 1);
            if (prefix.startsWith("a")) {
                int p;
                int a2;
                try {
                    a2 = Integer.parseInt(prefix.substring(1));
                }
                catch (NumberFormatException e2) {
                    this.commandExecutor(Cmd.PANEL, 0, 0, ev, val);
                    return;
                }
                dot = func.indexOf(46);
                if (dot == -1) {
                    this.commandExecutor(Cmd.AREA, a2, 0, func, val);
                    return;
                }
                prefix = func.substring(0, dot);
                try {
                    p = Integer.parseInt(prefix);
                }
                catch (NumberFormatException e3) {
                    this.commandExecutor(Cmd.AREA, a2, 0, func, val);
                    return;
                }
                func = func.substring(dot + 1);
                this.commandExecutor(Cmd.PART, a2, p, func, val);
                return;
            }
            if (prefix.startsWith("i")) {
                int i2 = Integer.parseInt(prefix.substring(1));
                this.commandExecutor(Cmd.INPUT, i2, 0, func, val);
                return;
            }
            this.commandExecutor(Cmd.PANEL, 0, 0, ev, val);
        }
        catch (Exception e4) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e4.getLocalizedMessage(), this.serverName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commandExecutor(Cmd type, int idx, int par, String func, String val) throws Exception {
        byte[] cmd = null;
        int cmdsNum = 1;
        if (type == Cmd.PANEL) {
            cmd = this.panel_cmd;
            if (func.equals("armed")) {
                if (val.equals("1")) {
                    cmd[6] = 1;
                } else {
                    if (!val.equals("0")) throw new Exception("invalid value");
                    cmd[6] = 2;
                }
            } else {
                if (!func.equals("armed.max")) throw new Exception("invalid function");
                if (val.equals("1")) {
                    cmd[6] = 24;
                } else {
                    if (!val.equals("0")) throw new Exception("invalid value");
                    cmd[6] = 25;
                }
            }
        } else if (type == Cmd.AREA) {
            cmd = this.area_cmd;
            cmdsNum = 4;
            idx = (idx - 1) * 4 + 1;
            cmd[8] = (byte)(idx >>> 8);
            cmd[9] = (byte)idx;
            cmd[12] = (byte)(++idx >>> 8);
            cmd[13] = (byte)idx;
            cmd[16] = (byte)(++idx >>> 8);
            cmd[17] = (byte)idx;
            cmd[20] = (byte)(++idx >>> 8);
            cmd[21] = (byte)idx;
            if (func.equals("armed")) {
                if (val.equals("1")) {
                    cmd[18] = 1;
                    cmd[14] = 1;
                    cmd[10] = 1;
                    cmd[6] = 1;
                } else {
                    if (!val.equals("0")) throw new Exception("invalid value");
                    cmd[18] = 2;
                    cmd[14] = 2;
                    cmd[10] = 2;
                    cmd[6] = 2;
                }
            } else {
                if (!func.equals("armed.max")) throw new Exception("invalid function");
                if (val.equals("1")) {
                    cmd[18] = 24;
                    cmd[14] = 24;
                    cmd[10] = 24;
                    cmd[6] = 24;
                } else {
                    if (!val.equals("0")) throw new Exception("invalid value");
                    cmd[18] = 25;
                    cmd[14] = 25;
                    cmd[10] = 25;
                    cmd[6] = 25;
                }
            }
        } else if (type == Cmd.PART) {
            cmd = this.group_cmd;
            idx = (idx - 1) * 4 + par;
            cmd[8] = (byte)(idx >>> 8);
            cmd[9] = (byte)idx;
            if (func.equals("armed")) {
                if (val.equals("1")) {
                    cmd[6] = 1;
                } else {
                    if (!val.equals("0")) throw new Exception("invalid value");
                    cmd[6] = 2;
                }
            } else {
                if (!func.equals("armed.max")) throw new Exception("invalid function");
                if (val.equals("1")) {
                    cmd[6] = 24;
                } else {
                    if (!val.equals("0")) throw new Exception("invalid value");
                    cmd[6] = 25;
                }
            }
        } else if (type == Cmd.INPUT) {
            cmd = this.input_cmd;
            cmd[8] = (byte)(idx >>> 8);
            cmd[9] = (byte)idx;
            if (!func.equals("bypassed")) throw new Exception("invalid function");
            if (val.equals("0")) {
                cmd[6] = 1;
            } else {
                if (!val.equals("1")) throw new Exception("invalid value");
                cmd[6] = 2;
            }
        } else if (type == Cmd.OUTPUT) {
            cmd = this.output_cmd;
            cmd[8] = (byte)(idx >>> 8);
            cmd[9] = (byte)idx;
            if (val.equals("1")) {
                cmd[6] = 1;
            } else {
                if (!val.equals("0")) throw new Exception("invalid value");
                cmd[6] = 2;
            }
        }
        Vector<Byte> resp = this.write(cmd);
        int i2 = 0;
        while (i2 < cmdsNum) {
            byte res = resp.get(5 + i2);
            if (res == 5) {
                Logger.log(Logger.Mode.ERROR, "commandExecutor - command unavailable", this.serverName);
                this.uiSet("log", "HSYCO - " + COMMAND_UNAVAILABLE[this.language]);
                return;
            }
            if (res == 7) {
                Logger.log(Logger.Mode.EVENT, "commandExecutor - access denied", this.serverName);
                this.uiSet("log", "HSYCO - " + ACCESS_DENIED[this.language]);
                return;
            }
            if (res == 21) {
                Logger.log(Logger.Mode.ERROR, "commandExecutor - NAK received", this.serverName);
                this.uiSet("log", "HSYCO - " + COMMAND_ERROR[this.language]);
                return;
            }
            ++i2;
        }
        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - command OK", this.serverName);
    }

    private void ioWrite(boolean event, String name, String value) {
        String evName = String.valueOf(this.serverName) + "." + name;
        if (event) {
            SystemState.ioWrite(evName, value);
        } else {
            SystemState.ioWriteNoEvents(evName, value);
        }
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (!this.guiSupport) {
            return;
        }
        if (name.equals("log")) {
            this.logTime = System.currentTimeMillis();
            value = value.toUpperCase();
            String logEntry = "<div style=\"padding:3px\">" + this.dateFormat.format(this.logTime).toUpperCase() + "<br />" + value + "</div>";
            while (this.logs.size() >= this.logSize) {
                this.logs.remove(this.logSize - 1);
            }
            this.logs.add(0, logEntry);
            StringBuilder text = new StringBuilder();
            StringBuilder labels = new StringBuilder();
            StringBuilder params = new StringBuilder();
            int i2 = 0;
            while (i2 < this.logs.size()) {
                String l2 = this.logs.get(i2);
                text.append(l2);
                if (this.userLogs) {
                    try {
                        if (params.length() > 0) {
                            labels.append(',');
                            params.append(',');
                        }
                        String labelDate = l2.substring(25, 40);
                        GregorianCalendar now = new GregorianCalendar();
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(this.dateFormat.parse(labelDate));
                        if (now.get(2) < cal.get(2)) {
                            cal.set(1, now.get(1) - 1);
                        } else {
                            cal.set(1, now.get(1));
                        }
                        String paramDate = this.eventDateFormat.format(cal.getTime());
                        String ev = l2.substring(46, l2.length() - 6).replace(",", "&#44;");
                        String label = String.valueOf(labelDate) + "<br />" + ev;
                        String param = String.valueOf(paramDate) + " " + ev;
                        labels.append(label);
                        params.append(param);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i2;
            }
            if (this.userLogs) {
                userBase.uiSet(String.valueOf(this.serverName) + ".userlogs", "parameters", params.toString());
                userBase.uiSet(String.valueOf(this.serverName) + ".userlogs", "labels", labels.toString());
            }
            userBase.uiSet(String.valueOf(this.serverName) + ".log", "value", text.toString());
            userBase.uiSet(String.valueOf(this.serverName) + ".log0", "value", value);
            i2 = 0;
            while (i2 < this.logs.size() && i2 < 20) {
                userBase.uiSet(String.valueOf(this.serverName) + ".log" + (i2 + 1), "value", this.logs.get(i2));
                ++i2;
            }
            this.saveLogs();
        } else if (name.equals("connection")) {
            if (value.equals("online")) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "true");
            }
        } else if (name.endsWith(".name")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
        } else if (value.equals("1")) {
            user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
            user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
        } else if (value.equals("0")) {
            user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "true");
        }
    }

    private void uiUpdate() {
        if (!this.guiSupport) {
            return;
        }
        if (System.currentTimeMillis() > this.logTime + 10000L) {
            userBase.uiSet(String.valueOf(this.serverName) + ".log0", "value", "");
        }
    }

    private Vector<Byte> write(byte[] data) throws IOException {
        this.addChecksum(data);
        data = this.stuff(data);
        if (Configuration.verboseLog) {
            StringBuilder sb = new StringBuilder();
            byte[] byArray = data;
            int n2 = data.length;
            int n3 = 0;
            while (n3 < n2) {
                byte b2 = byArray[n3];
                sb.append(Integer.toHexString(b2 & 0xFF));
                sb.append(' ');
                ++n3;
            }
            Logger.log(Logger.Mode.VERBOSE, ">>> " + sb, this.serverName);
        }
        util.readComm(this.commPort, 0);
        if (util.writeCommBytes(this.commPort, data) != data.length) {
            throw new IOException("write comm error");
        }
        return this.read();
    }

    private Vector<Byte> read() throws IOException {
        StringBuilder sb;
        byte[] bs;
        Vector<Byte> resp;
        block9: {
            resp = new Vector<Byte>();
            boolean dle = false;
            bs = util.readCommBytes(this.commPort, 1);
            if (bs == null || bs.length != 1 || bs[0] != 2) {
                throw new IOException("read comm error 1");
            }
            resp.add(bs[0]);
            sb = null;
            if (Configuration.verboseLog) {
                sb = new StringBuilder();
                sb.append(Integer.toHexString(bs[0] & 0xFF));
                sb.append(' ');
            }
            while ((bs = util.readCommBytes(this.commPort, 1)) != null && bs.length == 1) {
                if (Configuration.verboseLog) {
                    sb.append(Integer.toHexString(bs[0] & 0xFF));
                    sb.append(' ');
                }
                if (bs[0] != 3) {
                    if (bs[0] == 16) {
                        dle = true;
                        continue;
                    }
                    if (dle) {
                        resp.add((byte)(bs[0] - 128));
                        dle = false;
                        continue;
                    }
                    resp.add(bs[0]);
                    continue;
                }
                break block9;
            }
            throw new IOException("read comm error 2");
        }
        resp.add(bs[0]);
        if (Configuration.verboseLog) {
            Logger.log(Logger.Mode.VERBOSE, "<<< " + sb, this.serverName);
        }
        if (!this.checkCrcAndProtocolVersion(resp)) {
            throw new IOException("checksum error");
        }
        return resp;
    }

    private void addChecksum(byte[] data) {
        int ck = 0;
        int i2 = 1;
        while (i2 < data.length - 3) {
            ck += data[i2] & 0xFF;
            ++i2;
        }
        data[data.length - 3] = (byte)(ck >>> 8);
        data[data.length - 2] = (byte)ck;
    }

    private boolean checkCrcAndProtocolVersion(Vector<Byte> data) {
        int ck = 0;
        if (data.get(1) == -1) {
            int i2 = 1;
            while (i2 < data.size() - 3) {
                ck ^= data.get(i2) & 0xFF;
                int k2 = 0;
                while (k2 < 8) {
                    ck = (ck & 1) != 0 ? ck >> 1 ^ 0xA001 : ck >> 1;
                    ++k2;
                }
                ++i2;
            }
            data.remove(5);
            data.remove(5);
        } else {
            int i3 = 1;
            while (i3 < data.size() - 3) {
                ck += data.get(i3) & 0xFF;
                ++i3;
            }
        }
        return data.get(data.size() - 3) == (byte)(ck >>> 8) && data.get(data.size() - 2) == (byte)ck;
    }

    private byte[] stuff(byte[] data) {
        Vector<Byte> v = new Vector<Byte>();
        v.add(data[0]);
        int i2 = 1;
        while (i2 < data.length - 1) {
            if (data[i2] == 2) {
                v.add((byte)16);
                v.add((byte)-126);
            } else if (data[i2] == 3) {
                v.add((byte)16);
                v.add((byte)-125);
            } else if (data[i2] == 16) {
                v.add((byte)16);
                v.add((byte)-112);
            } else {
                v.add(data[i2]);
            }
            ++i2;
        }
        v.add(data[data.length - 1]);
        byte[] ret = new byte[v.size()];
        int i3 = 0;
        while (i3 < ret.length) {
            ret[i3] = (Byte)v.get(i3);
            ++i3;
        }
        return ret;
    }

    private static enum Cmd {
        PANEL,
        INPUT,
        OUTPUT,
        AREA,
        PART;

    }

    private class Group {
        private final String prefix;
        private int armed = -1;
        private int armedMax = -1;
        private int partial = -1;

        public Group(int idx, String name) {
            int area = (idx - 1) / 4 + 1;
            int part = (idx - 1) % 4 + 1;
            this.prefix = "a" + area + "." + part + ".";
            ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "name", name.trim().replaceAll("\\s+", " "));
        }

        public void setArmedMax(int val) {
            if (this.armedMax != val) {
                this.armedMax = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "armed.max", "" + val);
            }
        }

        public void setPartial(int val) {
            if (this.partial != val) {
                this.partial = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "part", "" + val);
            }
        }

        public void setArmed(int val) {
            if (this.armed != val) {
                this.armed = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "armed", "" + val);
            }
        }
    }

    private class Input {
        private final int idx;
        private final String name;
        private final String prefix;
        private int open = -1;
        private int alarm = -1;
        private int tamper = 0;
        private int bypassed = -1;

        public Input(int idx, String name) {
            this.idx = idx;
            this.name = name.trim().replaceAll("\\s+", " ");
            this.prefix = "i" + idx + ".";
            ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "name", this.name);
            ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "tamper", "0");
        }

        public String getListLabel() {
            StringBuilder imgs = new StringBuilder();
            if (this.open == 1) {
                imgs.append("<img src=\"/$skin$/pic/elmo/elmo-dooropen.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.alarm == 1) {
                imgs.append("<img src=\"/$skin$/pic/elmo/elmo-alarm.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.bypassed == 1) {
                imgs.append("<img src=\"/$skin$/pic/elmo/elmo-block.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.tamper == 1) {
                imgs.append("<img src=\"/$skin$/pic/elmo/elmo-scissors.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            String row = "<table cellpadding=\"0\" cellspacing=\"0\" style=\"table-layout:fixed; width:100%\"><tr>";
            row = String.valueOf(row) + "<td><div style=\"max-width:100%; text-overflow:ellipsis; overflow:hidden; white-space:nowrap; padding-right:10px\">" + this.name + "</div></td>";
            row = String.valueOf(row) + "<td style=\"text-align:right; width:100px; padding-right:5px\">" + imgs.toString() + "</td>";
            row = String.valueOf(row) + "</tr></table>";
            return row;
        }

        public void setTamper(int val) {
            if (this.tamper != val) {
                this.tamper = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "tamper", "" + val);
                if (ELMO.this.guiSupport) {
                    Vector s = (Vector)ELMO.this.zoneSessions.get(this.idx);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(ELMO.this.serverName) + ".zone.sel.tamper.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    ELMO.this.updateZonesList();
                }
            }
        }

        public void setBypassed(int val) {
            if (this.bypassed != val) {
                this.bypassed = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "bypassed", "" + val);
                if (ELMO.this.guiSupport) {
                    Vector s = (Vector)ELMO.this.zoneSessions.get(this.idx);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(ELMO.this.serverName) + ".zone.sel.bypassed.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    ELMO.this.updateZonesList();
                }
            }
        }

        public void setAlarm(int val) {
            if (this.alarm != val) {
                this.alarm = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "alarm", "" + val);
                if (ELMO.this.guiSupport) {
                    Vector s = (Vector)ELMO.this.zoneSessions.get(this.idx);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(ELMO.this.serverName) + ".zone.sel.alarm.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    ELMO.this.updateZonesList();
                }
            }
        }

        public void setOpen(int val) {
            if (this.open != val) {
                this.open = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "open", "" + val);
                if (ELMO.this.guiSupport) {
                    Vector s = (Vector)ELMO.this.zoneSessions.get(this.idx);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(ELMO.this.serverName) + ".zone.sel.open.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    ELMO.this.updateZonesList();
                }
            }
        }
    }

    private class Keypad {
        private final String prefix;
        private int tamper = 0;

        public Keypad(int idx) {
            this.prefix = "kp" + idx + ".";
            ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "tamper", "0");
        }

        public void setTamper(int val) {
            if (this.tamper != val) {
                this.tamper = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "tamper", "" + val);
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class Output {
        private final String prefix;
        private int status = -1;

        public Output(int idx) {
            this.prefix = "o" + idx;
        }

        public void setStatus(int val) {
            if (this.status != val) {
                this.status = val;
                ELMO.this.ioWrite(ELMO.this.genEvents, this.prefix, "" + val);
            }
        }
    }

    private class User {
        private final String name;
        private final String prefix;

        public User(int idx, String name) {
            this.name = name.trim().replaceAll("\\s+", " ");
            this.prefix = "usr" + idx + ".";
            ELMO.this.ioWrite(ELMO.this.genEvents, String.valueOf(this.prefix) + "name", this.name);
        }

        static /* synthetic */ String access$0(User user2) {
            return user2.name;
        }
    }
}

