/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.HsycoFile;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.driverBase;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DriversWrapper {
    private static Hashtable<String, driverData> typeCache = new Hashtable();
    private static Hashtable<String, String> nameCache = new Hashtable();
    private driverData driver;
    private Object driverInstance;
    CommandDispatcher commandDispatcher;
    private long commandHeartbeat = Long.MAX_VALUE;
    String ioServerName = "unknown";

    static boolean isDriver(String type) {
        boolean registered = false;
        try {
            type = type.toLowerCase();
            if (typeCache.containsKey(type)) {
                registered = true;
            } else {
                HsycoFile hf = new HsycoFile("drivers", String.valueOf(type) + File.separator + "Driver.class");
                if (hf.getFile() != null) {
                    typeCache.put(type, new driverData(type));
                    registered = true;
                }
            }
        }
        catch (Exception e2) {
            return false;
        }
        return registered;
    }

    static void register(String name, String type) {
        if (typeCache.containsKey(type)) {
            nameCache.put(name, type);
        }
    }

    static int myDefaultSocketPort(String type) throws Exception {
        return typeCache.get(type).defaultSocketPort;
    }

    static int myCommandsQueueSize(String type) throws Exception {
        return typeCache.get(type).commandsQueueSize;
    }

    static boolean myShutdownWhenSlave(String type) throws Exception {
        return typeCache.get(type).shutdownWhenSlave;
    }

    String user(String session, String user2, String id, HashMap<String, String> fields) {
        Object[] params = new Object[]{session, user2, id, fields};
        try {
            return (String)this.driver.user.invoke(this.driverInstance, params);
        }
        catch (Exception e2) {
            return "";
        }
    }

    void monitor(int ioIndex, ioMonitor me) {
        block25: {
            try {
                String password;
                String user2;
                InetSocketAddress addr;
                SystemState.ioServersInitializedSet(ioIndex, false);
                this.ioServerName = Configuration.ioServersName.elementAt(ioIndex);
                this.driver = typeCache.get(nameCache.get(this.ioServerName));
                this.driverInstance = this.driver.classObject.newInstance();
                HashMap<String, String> config = new HashMap<String, String>();
                String comm = Configuration.ioServersComm.elementAt(ioIndex);
                if (comm != null) {
                    config.put("comm", comm);
                }
                if ((addr = new InetSocketAddress(Configuration.ioServersHost.elementAt(ioIndex), (int)Configuration.ioServersPort.elementAt(ioIndex))) != null && addr.getAddress() != null) {
                    config.put("host", addr.getAddress().getHostAddress());
                    config.put("port", Integer.toString(addr.getPort()));
                }
                if ((user2 = Configuration.ioServersUser.elementAt(ioIndex)) != null && user2.length() > 0) {
                    config.put("user", user2);
                }
                if ((password = Configuration.ioServersPassword.elementAt(ioIndex)) != null && password.length() > 0) {
                    config.put("password", password);
                }
                config.put("shutdowninactive", Boolean.toString(Configuration.ioServersShutdownWhenInactive.elementAt(ioIndex)));
                String options = Configuration.ioServersOptions.elementAt(ioIndex);
                if (options != null && options.length() > 0) {
                    String[] sa = options.split(",");
                    int i2 = 0;
                    while (i2 < sa.length) {
                        String param = "";
                        try {
                            String[] sb = sa[i2].split("=");
                            param = sb[0].trim().toLowerCase();
                            if (param.length() > 0) {
                                config.put(param, sb.length == 1 ? "true" : sb[1].trim());
                            }
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.ioServerName + "] - " + param + " ignored");
                        }
                        ++i2;
                    }
                }
                Object[] params = new Object[]{this.ioServerName, config};
                boolean initialized = false;
                if (((Boolean)this.driver.init.invoke(this.driverInstance, params)).booleanValue()) {
                    me.heartbeat = System.currentTimeMillis();
                    while (!me.quit) {
                        try {
                            if (((Boolean)this.driver.loop.invoke(this.driverInstance, null)).booleanValue()) {
                                me.heartbeat = System.currentTimeMillis();
                                if (!initialized) {
                                    initialized = true;
                                    hsyco.messageLog("Driver - started [" + this.ioServerName + "]");
                                    SystemState.ioServersInitializedSet(ioIndex, true);
                                    try {
                                        userCode.IOStartupEvent(ioIndex);
                                    }
                                    catch (Exception e3) {
                                        hsyco.errorLog("Driver - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
                                    }
                                    events.eventsExec("IOSTART" + this.ioServerName, 0, 0, null);
                                    if (this.driver.user != null) {
                                        PluginsWrapper.register(this.ioServerName, 100, this);
                                    }
                                    if (this.driver.command != null) {
                                        this.commandDispatcher = new CommandDispatcher();
                                        this.commandDispatcher.start();
                                    }
                                }
                            }
                            if (!initialized || this.commandHeartbeat >= System.currentTimeMillis() - 60000L) continue;
                            hsyco.errorLog("Driver - command dispatcher error [" + this.ioServerName + "] : timeout");
                            me.quit = true;
                        }
                        catch (Exception e4) {
                            hsyco.errorLog("Driver - driver main loop exception [" + this.ioServerName + "]: " + e4.getCause());
                            me.quit = true;
                        }
                    }
                    this.driver.end.invoke(this.driverInstance, null);
                    break block25;
                }
                hsyco.errorLog("Driver - initialization failed [" + this.ioServerName + "]");
            }
            catch (InvocationTargetException e5) {
                hsyco.errorLog("Driver - driver exception [" + this.ioServerName + "]: " + e5.getCause());
            }
            catch (Exception e6) {
                hsyco.errorLog("Driver - driver exception [" + this.ioServerName + "]: " + e6.toString());
            }
        }
        if (this.commandDispatcher != null && this.commandDispatcher.isAlive()) {
            this.commandDispatcher.quit = true;
            try {
                Thread.sleep(15000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hsyco.messageLog("Driver - quit [" + this.ioServerName + "]");
    }

    private class CommandDispatcher
    extends Thread {
        ArrayBlockingQueue<String> ioqtx;
        boolean quit = false;

        private CommandDispatcher() {
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("Driver - command dispatcher started [" + DriversWrapper.this.ioServerName + "]");
                DriversWrapper.this.commandHeartbeat = System.currentTimeMillis();
                this.ioqtx = Configuration.ioQueueTx.elementAt(Configuration.ioServersName.indexOf(DriversWrapper.this.ioServerName));
                while (!this.quit) {
                    int i2;
                    String cmd = this.ioqtx.poll(10L, TimeUnit.SECONDS);
                    if (cmd != null && (i2 = cmd.indexOf(61)) > 0) {
                        try {
                            Object[] params = new Object[]{cmd.substring(0, i2), cmd.length() > i2 + 1 ? cmd.substring(i2 + 1) : null};
                            DriversWrapper.this.driver.command.invoke(DriversWrapper.this.driverInstance, params);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("Driver - command dispatcher exception [" + DriversWrapper.this.ioServerName + "] : " + e2.getLocalizedMessage());
                        }
                    }
                    DriversWrapper.this.commandHeartbeat = System.currentTimeMillis();
                }
            }
            catch (Exception e3) {
                hsyco.errorLog("Driver - command dispatcher fatal exception [" + DriversWrapper.this.ioServerName + "] : " + e3.getLocalizedMessage());
            }
            hsyco.errorLog("Driver - command dispatcher quit [" + DriversWrapper.this.ioServerName + "]");
        }
    }

    private static class driverData {
        private Integer defaultSocketPort = 0;
        private Integer commandsQueueSize = 256;
        private Boolean shutdownWhenSlave = true;
        private Method init = null;
        private Method loop = null;
        private Method end = null;
        private Method command = null;
        private Method user = null;
        private Class<?> classObject = null;

        driverData(String type) throws Exception {
            this.classObject = Class.forName("drivers." + type + ".Driver");
            Object oo = this.classObject.newInstance();
            if (oo instanceof driverBase) {
                Field[] fields = this.classObject.getFields();
                int i2 = 0;
                while (i2 < fields.length) {
                    Field f2 = fields[i2];
                    String name = f2.getName();
                    if (name.equals("DEFAULTSOCKETPORT")) {
                        this.defaultSocketPort = f2.getInt(oo);
                    } else if (name.equals("COMMANDSQUEUESIZE")) {
                        this.commandsQueueSize = f2.getInt(oo);
                    } else if (name.equals("SHUTDOWNWHENSLAVE")) {
                        this.shutdownWhenSlave = f2.getBoolean(oo);
                    } else if (name.equals("WEBOBJECTS")) {
                        Configuration.addWebObjects(type, (String[])f2.get(oo));
                    }
                    ++i2;
                }
                Method[] methods = this.classObject.getMethods();
                int i3 = 0;
                while (i3 < methods.length) {
                    Method m2 = methods[i3];
                    String name = m2.getName();
                    if (m2.getDeclaringClass().equals(this.classObject)) {
                        Type rettype = m2.getGenericReturnType();
                        Type[] paramtypes = m2.getGenericParameterTypes();
                        if (name.equals("init")) {
                            if (rettype.equals(Boolean.TYPE) && paramtypes.length == 2 && paramtypes[0].equals(String.class) && ((ParameterizedType)paramtypes[1]).getRawType().equals(HashMap.class) && ((ParameterizedType)paramtypes[1]).getActualTypeArguments().length == 2 && ((ParameterizedType)paramtypes[1]).getActualTypeArguments()[0].equals(String.class) && ((ParameterizedType)paramtypes[1]).getActualTypeArguments()[1].equals(String.class)) {
                                this.init = m2;
                            }
                        } else if (name.equals("loop")) {
                            if (rettype.equals(Boolean.TYPE) && paramtypes.length == 0) {
                                this.loop = m2;
                            }
                        } else if (name.equals("end")) {
                            if (rettype.equals(Boolean.TYPE) && paramtypes.length == 0) {
                                this.end = m2;
                            }
                        } else if (name.equals("command")) {
                            if (rettype.equals(Void.TYPE) && paramtypes.length == 2 && paramtypes[0].equals(String.class) && paramtypes[1].equals(String.class)) {
                                this.command = m2;
                            }
                        } else if (name.equals("user") && rettype.equals(String.class) && paramtypes.length == 4 && paramtypes[0].equals(String.class) && paramtypes[1].equals(String.class) && paramtypes[2].equals(String.class) && ((ParameterizedType)paramtypes[3]).getRawType().equals(HashMap.class) && ((ParameterizedType)paramtypes[3]).getActualTypeArguments().length == 2 && ((ParameterizedType)paramtypes[3]).getActualTypeArguments()[0].equals(String.class) && ((ParameterizedType)paramtypes[3]).getActualTypeArguments()[1].equals(String.class)) {
                            this.user = m2;
                        }
                    }
                    ++i3;
                }
            }
            if (this.defaultSocketPort == null || this.commandsQueueSize == null || this.shutdownWhenSlave == null) {
                throw new Exception(String.valueOf(type) + " driver error: undefined fields");
            }
            if (this.init == null || this.loop == null || this.end == null) {
                throw new Exception(String.valueOf(type) + " driver error: undefined methods");
            }
        }
    }
}

