/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userCode;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Daikin {
    private static final long DEFAULT_POLL_INTERVALL = 20000L;
    private static final int INDIVIDUAL_CMD = 0;
    private static final int GLOBAL_CMD = 1;
    private static final int DI_CMD = 2;
    private static final int DIO_CMD = 3;
    private static final int VRV_CMD = 4;
    private static final int HRV_CMD = 5;
    private String serverName;
    private InetSocketAddress serverSocket;
    private ArrayBlockingQueue<String> ioqtx;
    private boolean guiSupport = true;
    private long pollInterval = 20000L;
    private boolean genEvents = false;
    private static final byte[] connectionStatusReq;
    private static final byte[] getProperties;
    private byte[] getCurrentStatus;
    private byte[] getCurrentStatus_iTC;
    private byte[] getCurrentStatus_iTM;
    private final byte[] setStatus_power_off;
    private final byte[] setStatus_power_on;
    private final byte[] setStatus_mode_fan;
    private final byte[] setStatus_mode_heat;
    private final byte[] setStatus_mode_cool;
    private final byte[] setStatus_mode_dependent;
    private final byte[] setStatus_mode_dry;
    private final byte[] setStatus_mode_auto;
    private final byte[] setStatus_vent_mode_auto;
    private final byte[] setStatus_vent_mode_exchange;
    private final byte[] setStatus_vent_mode_bypass;
    private final byte[] setStatus_vent_amount_auto_normal;
    private final byte[] setStatus_vent_amount_low_normal;
    private final byte[] setStatus_vent_amount_high_normal;
    private final byte[] setStatus_vent_amount_auto_freshup;
    private final byte[] setStatus_vent_amount_low_freshup;
    private final byte[] setStatus_vent_amount_high_freshup;
    private final byte[] setStatus_setPoint;
    private final byte[] setStatus_fanSpeed_low;
    private final byte[] setStatus_fanSpeed_mid;
    private final byte[] setStatus_fanSpeed_high;
    private final byte[] setStatus_fanSpeed_auto;
    private static final byte[] setStatus_fanDirection_0;
    private final byte[] setStatus_fanDirection_1;
    private final byte[] setStatus_fanDirection_2;
    private final byte[] setStatus_fanDirection_3;
    private final byte[] setStatus_fanDirection_4;
    private final byte[] setStatus_fanDirection_swing;
    private int online;
    private int sysPower;
    private int sysError;
    private int sysSetpoint;
    private byte sysFanSpeed;
    private byte sysFanDir;
    private int sysVentLvl;
    private int sysVentFU;
    private int vrvPower;
    private int vrvSetpoint;
    private byte vrvFanSpeed;
    private byte vrvFanDir;
    private int vrvVentLvl;
    private int vrvVentFU;
    private int hrvPower;
    private int hrvSetpoint;
    private byte hrvFanSpeed;
    private byte hrvFanDir;
    private int hrvVentLvl;
    private int hrvVentFU;
    private int dioPower;
    private int dioSetpoint;
    private byte dioFanSpeed;
    private byte dioFanDir;
    private int dioVentLvl;
    private int dioVentFU;
    private int diPower;
    private int diSetpoint;
    private byte diFanSpeed;
    private byte diFanDir;
    private int diVentLvl;
    private int diVentFU;
    private HashMap<Integer, AC> ACs;
    private int[] allAddresses;
    private int[] diAddresses;
    private int[] dioAddresses;
    private int[] vrvAddresses;
    private int[] hrvAddresses;
    private HashMap<String, IOCommandSet> keypadCmds;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 32;
        byArray[4] = 112;
        byArray[5] = 17;
        byArray[6] = 1;
        connectionStatusReq = byArray;
        byte[] byArray2 = new byte[32];
        byArray2[0] = 32;
        byArray2[4] = 114;
        byArray2[5] = 17;
        byArray2[6] = 1;
        getProperties = byArray2;
        byte[] byArray3 = new byte[24];
        byArray3[4] = 64;
        setStatus_fanDirection_0 = byArray3;
    }

    public Daikin() {
        byte[] byArray = new byte[32];
        byArray[0] = 32;
        byArray[4] = 116;
        byArray[5] = 17;
        byArray[6] = 1;
        this.getCurrentStatus_iTC = byArray;
        byte[] byArray2 = new byte[80];
        byArray2[0] = 80;
        byArray2[4] = 116;
        byArray2[5] = 17;
        byArray2[6] = 1;
        this.getCurrentStatus_iTM = byArray2;
        byte[] byArray3 = new byte[24];
        byArray3[4] = 1;
        this.setStatus_power_off = byArray3;
        byte[] byArray4 = new byte[24];
        byArray4[4] = 1;
        byArray4[8] = 1;
        this.setStatus_power_on = byArray4;
        byte[] byArray5 = new byte[24];
        byArray5[4] = 2;
        byArray5[10] = 1;
        this.setStatus_mode_fan = byArray5;
        byte[] byArray6 = new byte[24];
        byArray6[4] = 2;
        byArray6[10] = 2;
        this.setStatus_mode_heat = byArray6;
        byte[] byArray7 = new byte[24];
        byArray7[4] = 2;
        byArray7[10] = 4;
        this.setStatus_mode_cool = byArray7;
        byte[] byArray8 = new byte[24];
        byArray8[4] = 2;
        byArray8[10] = 16;
        this.setStatus_mode_dependent = byArray8;
        byte[] byArray9 = new byte[24];
        byArray9[4] = 2;
        byArray9[10] = 64;
        this.setStatus_mode_dry = byArray9;
        byte[] byArray10 = new byte[24];
        byArray10[4] = 2;
        byArray10[11] = 2;
        this.setStatus_mode_auto = byArray10;
        byte[] byArray11 = new byte[24];
        byArray11[4] = 4;
        byArray11[12] = 1;
        this.setStatus_vent_mode_auto = byArray11;
        byte[] byArray12 = new byte[24];
        byArray12[4] = 4;
        byArray12[12] = 2;
        this.setStatus_vent_mode_exchange = byArray12;
        byte[] byArray13 = new byte[24];
        byArray13[4] = 4;
        byArray13[12] = 4;
        this.setStatus_vent_mode_bypass = byArray13;
        byte[] byArray14 = new byte[24];
        byArray14[4] = 8;
        byArray14[14] = 1;
        this.setStatus_vent_amount_auto_normal = byArray14;
        byte[] byArray15 = new byte[24];
        byArray15[4] = 8;
        byArray15[14] = 2;
        this.setStatus_vent_amount_low_normal = byArray15;
        byte[] byArray16 = new byte[24];
        byArray16[4] = 8;
        byArray16[14] = 4;
        this.setStatus_vent_amount_high_normal = byArray16;
        byte[] byArray17 = new byte[24];
        byArray17[4] = 8;
        byArray17[14] = 8;
        this.setStatus_vent_amount_auto_freshup = byArray17;
        byte[] byArray18 = new byte[24];
        byArray18[4] = 8;
        byArray18[14] = 16;
        this.setStatus_vent_amount_low_freshup = byArray18;
        byte[] byArray19 = new byte[24];
        byArray19[4] = 8;
        byArray19[14] = 32;
        this.setStatus_vent_amount_high_freshup = byArray19;
        byte[] byArray20 = new byte[24];
        byArray20[4] = 16;
        this.setStatus_setPoint = byArray20;
        byte[] byArray21 = new byte[24];
        byArray21[4] = 32;
        this.setStatus_fanSpeed_low = byArray21;
        byte[] byArray22 = new byte[24];
        byArray22[4] = 32;
        byArray22[20] = 1;
        this.setStatus_fanSpeed_mid = byArray22;
        byte[] byArray23 = new byte[24];
        byArray23[4] = 32;
        byArray23[20] = 2;
        this.setStatus_fanSpeed_high = byArray23;
        byte[] byArray24 = new byte[24];
        byArray24[4] = 32;
        byArray24[20] = 100;
        this.setStatus_fanSpeed_auto = byArray24;
        byte[] byArray25 = new byte[24];
        byArray25[4] = 64;
        byArray25[21] = 1;
        this.setStatus_fanDirection_1 = byArray25;
        byte[] byArray26 = new byte[24];
        byArray26[4] = 64;
        byArray26[21] = 2;
        this.setStatus_fanDirection_2 = byArray26;
        byte[] byArray27 = new byte[24];
        byArray27[4] = 64;
        byArray27[21] = 3;
        this.setStatus_fanDirection_3 = byArray27;
        byte[] byArray28 = new byte[24];
        byArray28[4] = 64;
        byArray28[21] = 4;
        this.setStatus_fanDirection_4 = byArray28;
        byte[] byArray29 = new byte[24];
        byArray29[4] = 64;
        byArray29[21] = 7;
        this.setStatus_fanDirection_swing = byArray29;
        this.online = -1;
        this.sysPower = -1;
        this.sysError = -1;
        this.sysSetpoint = 0;
        this.sysFanSpeed = 0;
        this.sysFanDir = 0;
        this.sysVentLvl = 0;
        this.sysVentFU = 0;
        this.vrvPower = -1;
        this.vrvSetpoint = 0;
        this.vrvFanSpeed = 0;
        this.vrvFanDir = 0;
        this.vrvVentLvl = 0;
        this.vrvVentFU = 0;
        this.hrvPower = -1;
        this.hrvSetpoint = 0;
        this.hrvFanSpeed = 0;
        this.hrvFanDir = 0;
        this.hrvVentLvl = 0;
        this.hrvVentFU = 0;
        this.dioPower = -1;
        this.dioSetpoint = 0;
        this.dioFanSpeed = 0;
        this.dioFanDir = 0;
        this.dioVentLvl = 0;
        this.dioVentFU = 0;
        this.diPower = -1;
        this.diSetpoint = 0;
        this.diFanSpeed = 0;
        this.diFanDir = 0;
        this.diVentLvl = 0;
        this.diVentFU = 0;
        this.ACs = new HashMap();
        this.keypadCmds = new HashMap();
    }

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.serverSocket = Configuration.ioServersTCPAddress.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        this.pollInterval = Integer.parseInt(value) * 1000;
                        if (this.pollInterval < 1L) {
                            this.pollInterval = 20000L;
                            throw new Exception();
                        }
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 25, this);
        }
        if (this.detectConfiguration()) {
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
        } else {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - AC detection error [" + this.serverName + "]");
            me.quit = true;
        }
        me.heartbeat = System.currentTimeMillis();
        boolean ok = true;
        String cmd = null;
        long cmdTS = -1L;
        while (!me.quit) {
            try {
                if (cmd != null) {
                    cmdTS = System.currentTimeMillis();
                    if (!this.processCommand(cmd)) {
                        ok = false;
                    }
                }
                if (!this.polling()) {
                    ok = false;
                }
                if (ok) {
                    me.heartbeat = System.currentTimeMillis();
                }
                ok = true;
                this.genEvents = true;
                if (System.currentTimeMillis() > cmdTS + 3000L) {
                    cmd = this.ioqtx.poll(this.pollInterval, TimeUnit.MILLISECONDS);
                    continue;
                }
                cmd = this.ioqtx.poll(50L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e4) {
                Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e4);
                me.quit = true;
            }
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.online != 0) {
            this.online = 0;
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.ioWrite(true, "connection", "offline");
        }
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id + " [" + this.serverName + "]");
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                if (name.endsWith("setpoint") && (value.equals("up") || value.equals("down"))) {
                    int v;
                    IOCommandSet cs = this.keypadCmds.get(name);
                    if (cs == null) {
                        String vStr = user.uiGet(String.valueOf(this.serverName) + "." + name, "value").replace("&deg;C", "").trim();
                        v = (int)(Float.parseFloat(vStr) * 10.0f);
                    } else {
                        v = Integer.parseInt(cs.value);
                    }
                    v = value.equals("up") ? (v += 5) : (v -= 5);
                    if (v >= 160 && v <= 320) {
                        if (cs != null) {
                            cs.interrupt();
                        }
                        user.uiSet(String.valueOf(this.serverName) + "." + name, "value", String.valueOf((float)v / 10.0f) + " &deg;C");
                        this.keypadCmds.put(name, new IOCommandSet(name, "" + v));
                    }
                } else if (name.endsWith("fan.direction") && value.equals("switch")) {
                    String v;
                    IOCommandSet cs = this.keypadCmds.get(name);
                    if (cs == null) {
                        v = Byte.toString(this.getCurrentFanDir(name));
                    } else {
                        v = cs.value;
                        cs.interrupt();
                    }
                    v = v.equals("0") ? "1" : (v.equals("1") ? "2" : (v.equals("2") ? "3" : (v.equals("3") ? "4" : (v.equals("4") ? "swing" : "0"))));
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.2", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.3", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.4", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.swing", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label." + v, "visible", "true");
                    this.keypadCmds.put(name, new IOCommandSet(name, v));
                } else if (name.endsWith("fan.speed") && value.equals("switch")) {
                    String v;
                    IOCommandSet cs = this.keypadCmds.get(name);
                    if (cs == null) {
                        byte b2 = this.getCurrentFanSpeed(name);
                        v = b2 == 0 ? "low" : (b2 == 1 ? "mid" : "high");
                    } else {
                        v = cs.value;
                        cs.interrupt();
                    }
                    v = v.equals("low") ? "mid" : (v.equals("mid") ? "high" : "low");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.low", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.mid", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.high", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label." + v, "visible", "true");
                    this.keypadCmds.put(name, new IOCommandSet(name, v));
                } else if (name.endsWith("vent.level") && value.equals("switch")) {
                    String v;
                    IOCommandSet cs = this.keypadCmds.get(name);
                    if (cs == null) {
                        int b3 = this.getCurrentVentLevel(name);
                        v = b3 == 0 ? "auto" : (b3 == 1 ? "low" : "high");
                    } else {
                        v = cs.value;
                        cs.interrupt();
                    }
                    v = v.equals("auto") ? "low" : (v.equals("low") ? "high" : "auto");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.auto", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.low", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.high", "visible", "false");
                    user.uiSet(String.valueOf(this.serverName) + "." + name + ".label." + v, "visible", "true");
                    this.keypadCmds.put(name, new IOCommandSet(name, v));
                } else {
                    SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
                }
            }
            catch (Exception e2) {
                return null;
            }
        }
        return "";
    }

    private byte getCurrentFanDir(String ev) {
        int dot = ev.indexOf(46);
        if (dot == -1) {
            return this.sysFanDir;
        }
        String prefix = ev.substring(0, dot);
        if (prefix.equals("d3di")) {
            return this.diFanDir;
        }
        if (prefix.equals("d3dio")) {
            return this.dioFanDir;
        }
        if (prefix.equals("vrv")) {
            return this.vrvFanDir;
        }
        if (prefix.equals("hrv")) {
            return this.hrvFanDir;
        }
        try {
            return this.ACs.get(Integer.parseInt(prefix)).fanDir;
        }
        catch (Exception e2) {
            return this.sysFanDir;
        }
    }

    private byte getCurrentFanSpeed(String ev) {
        int dot = ev.indexOf(46);
        if (dot == -1) {
            return this.sysFanSpeed;
        }
        String prefix = ev.substring(0, dot);
        if (prefix.equals("d3di")) {
            return this.diFanSpeed;
        }
        if (prefix.equals("d3dio")) {
            return this.dioFanSpeed;
        }
        if (prefix.equals("vrv")) {
            return this.vrvFanSpeed;
        }
        if (prefix.equals("hrv")) {
            return this.hrvFanSpeed;
        }
        try {
            return this.ACs.get(Integer.parseInt(prefix)).fanSpeed;
        }
        catch (Exception e2) {
            return this.sysFanSpeed;
        }
    }

    private int getCurrentVentLevel(String ev) {
        int dot = ev.indexOf(46);
        if (dot == -1) {
            return this.sysVentLvl;
        }
        String prefix = ev.substring(0, dot);
        if (prefix.equals("d3di")) {
            return this.diVentLvl;
        }
        if (prefix.equals("d3dio")) {
            return this.dioVentLvl;
        }
        if (prefix.equals("vrv")) {
            return this.vrvVentLvl;
        }
        if (prefix.equals("hrv")) {
            return this.hrvVentLvl;
        }
        try {
            return this.ACs.get(Integer.parseInt(prefix)).ventLvl;
        }
        catch (Exception e2) {
            return this.sysVentLvl;
        }
    }

    private boolean detectConfiguration() {
        byte[] resp = this.httpPostRead(connectionStatusReq);
        if (resp == null) {
            return false;
        }
        this.getCurrentStatus = resp.length == 84 ? this.getCurrentStatus_iTM : this.getCurrentStatus_iTC;
        int a2 = 20;
        while (a2 < resp.length) {
            int i2 = 0;
            while (i2 < 8) {
                if ((resp[a2] >>> i2 & 1) == 1) {
                    AC ac = new AC((a2 - 20) * 8 + i2);
                    this.ACs.put(ac.address, ac);
                    this.getCurrentStatus[a2 - 4] = (byte)(this.getCurrentStatus[a2 - 4] | 1 << i2);
                }
                ++i2;
            }
            ++a2;
        }
        resp = this.httpPostRead(getProperties);
        if (resp == null) {
            return false;
        }
        a2 = 0;
        int dis = 0;
        int dios = 0;
        int vrvs = 0;
        int hrvs = 0;
        int n2 = (resp.length - 32) / 84;
        int i3 = 0;
        while (i3 < n2) {
            AC ac = this.ACs.get(i3);
            if (ac != null) {
                a2 = 32 + 84 * i3;
                byte[] sName = new byte[16];
                int s = 0;
                while (s < 16) {
                    sName[s] = resp[a2 + s];
                    ++s;
                }
                byte[] lName = new byte[64];
                int l2 = 0;
                while (l2 < 64) {
                    lName[l2] = resp[a2 + 16 + l2];
                    ++l2;
                }
                byte[] tp = new byte[]{resp[a2 + 80], resp[a2 + 81]};
                byte[] inTp = new byte[]{resp[a2 + 82], resp[a2 + 83]};
                String shortName = new String(sName);
                String longName = new String(lName);
                byte type = tp[0];
                byte innerType = inTp[0];
                ac.shortName = shortName;
                ac.longName = longName;
                ac.type = type;
                ac.innerType = innerType;
                block0 : switch (type) {
                    case 6: {
                        ++dis;
                        ac.typeString = "d3di";
                        break;
                    }
                    case 7: {
                        ++dios;
                        ac.typeString = "d3dio";
                        break;
                    }
                    case 9: {
                        switch (innerType) {
                            case 0: {
                                ++vrvs;
                                ac.typeString = "vrv";
                                break block0;
                            }
                            case 3: {
                                ++hrvs;
                                ac.typeString = "hrv";
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
            ++i3;
        }
        if (this.ACs.size() == 0) {
            Logger.log(Logger.Mode.EVENT, "ioMonitor - no AC detected [" + this.serverName + "]");
            return false;
        }
        this.allAddresses = new int[this.ACs.size()];
        this.diAddresses = new int[dis];
        this.dioAddresses = new int[dios];
        this.vrvAddresses = new int[vrvs];
        this.hrvAddresses = new int[hrvs];
        a2 = 0;
        dis = 0;
        dios = 0;
        vrvs = 0;
        hrvs = 0;
        for (AC ac : this.ACs.values()) {
            this.allAddresses[a2++] = ac.address;
            block9 : switch (ac.type) {
                case 6: {
                    this.diAddresses[dis++] = ac.address;
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3Di: " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                    break;
                }
                case 7: {
                    this.dioAddresses[dios++] = ac.address;
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3Dio: " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                    break;
                }
                case 9: {
                    switch (ac.innerType) {
                        case 0: {
                            this.vrvAddresses[vrvs++] = ac.address;
                            Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3 Inner (VRV): " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                            break block9;
                        }
                        case 3: {
                            this.hrvAddresses[hrvs++] = ac.address;
                            Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3 Inner (HRV): " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                            break block9;
                        }
                        case 4: {
                            this.hrvAddresses[hrvs++] = ac.address;
                            Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3 Inner (D3 Chiller): " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                            break block9;
                        }
                        case 5: {
                            this.hrvAddresses[hrvs++] = ac.address;
                            Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3 Inner (Altherma): " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                            break block9;
                        }
                        case 6: {
                            this.hrvAddresses[hrvs++] = ac.address;
                            Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3 Inner (Inv.Chiller): " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                            break block9;
                        }
                    }
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - detected D3 Inner: " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                    break;
                }
                default: {
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - detected unknown AC: " + this.serverName + "." + ac.address + " - " + ac.longName + " [" + this.serverName + "]");
                }
            }
        }
        return true;
    }

    private boolean polling() {
        byte[] resp = this.httpPostRead(this.getCurrentStatus);
        if (resp == null) {
            return false;
        }
        if (resp.length != 32 + 32 * this.ACs.size()) {
            return false;
        }
        int a2 = 32;
        while (a2 < resp.length) {
            int addr = (resp[a2] & 0xFF) + ((resp[a2 + 1] & 0xFF) << 8) + ((resp[a2 + 2] & 0xFF) << 16) + ((resp[a2 + 3] & 0xFF) << 24);
            AC ac = this.ACs.get(addr);
            ac.setStatus(resp[a2 + 4]);
            ac.setMalfunctionCode(resp[a2 + 6], resp[a2 + 7]);
            ac.setPower(resp[a2 + 8]);
            ac.setOpMode(resp[a2 + 10], resp[a2 + 11]);
            ac.setVentMode(resp[a2 + 12], resp[a2 + 13]);
            ac.setVentAmount(resp[a2 + 14], resp[a2 + 15]);
            ac.setEnableTemp(resp[a2 + 16]);
            ac.setRoomTemp(resp[a2 + 20], resp[a2 + 21], resp[a2 + 22], resp[a2 + 23]);
            ac.setTemp(resp[a2 + 24], resp[a2 + 25], resp[a2 + 26], resp[a2 + 27]);
            ac.setFanSpeed(resp[a2 + 28]);
            ac.setFanDirection(resp[a2 + 29]);
            ac.setFilterSign(resp[a2 + 30]);
            a2 += 32;
        }
        return true;
    }

    private void checkSystemOff(byte type, byte innerType) {
        boolean sys = true;
        for (AC ac : this.ACs.values()) {
            if (ac.power != 1) continue;
            if (ac.type == type && ac.innerType == innerType) {
                return;
            }
            sys = false;
        }
        if (sys && this.sysPower != 0) {
            this.sysPower = 0;
            this.ioWrite(this.genEvents, "power", "0");
        }
        if (type == 6 && this.diPower != 0) {
            this.diPower = 0;
            this.ioWrite(this.genEvents, "d3di.power", "0");
        } else if (type == 7 && this.dioPower != 0) {
            this.dioPower = 0;
            this.ioWrite(this.genEvents, "d3dio.power", "0");
        } else if (type == 9 && innerType == 0 && this.vrvPower != 0) {
            this.vrvPower = 0;
            this.ioWrite(this.genEvents, "vrv.power", "0");
        } else if (type == 9 && innerType == 3 && this.hrvPower != 0) {
            this.hrvPower = 0;
            this.ioWrite(this.genEvents, "hrv.power", "0");
        }
    }

    private void checkSystemError() {
        for (AC ac : this.ACs.values()) {
            if (ac.error != 1) continue;
            return;
        }
        if (this.sysError != 0) {
            this.sysError = 0;
            this.ioWrite(this.genEvents, "error", "0");
        }
    }

    private boolean processCommand(String cmd) {
        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - processing command: " + cmd + " [" + this.serverName + "]");
        cmd = cmd.toLowerCase();
        String[] ev_val = cmd.split("=");
        String ev = ev_val[0];
        String val = ev_val[1];
        if (val.equals("on")) {
            val = "1";
        } else if (val.equals("off")) {
            val = "0";
        }
        int dot = ev.indexOf(46);
        if (dot == -1) {
            return this.commandExecutor(cmd, 1, ev, val, this.allAddresses);
        }
        String prefix = ev.substring(0, dot);
        String func = ev.substring(dot + 1);
        if (prefix.equals("d3di")) {
            return this.commandExecutor(cmd, 2, func, val, this.diAddresses);
        }
        if (prefix.equals("d3dio")) {
            return this.commandExecutor(cmd, 3, func, val, this.dioAddresses);
        }
        if (prefix.equals("vrv")) {
            return this.commandExecutor(cmd, 4, func, val, this.vrvAddresses);
        }
        if (prefix.equals("hrv")) {
            return this.commandExecutor(cmd, 5, func, val, this.hrvAddresses);
        }
        try {
            int a2 = Integer.parseInt(prefix);
            if (this.ACs.get(a2) != null) {
                return this.commandExecutor(cmd, 0, func, val, a2);
            }
            Logger.log(Logger.Mode.ERROR, "commandExecutor - address error: " + a2 + " [" + this.serverName + "]");
            return false;
        }
        catch (Exception e2) {
            try {
                return this.commandExecutor(cmd, 1, ev, val, this.allAddresses);
            }
            catch (Exception e3) {
                Logger.log(Logger.Mode.ERROR, "commandExecutor - command error: " + cmd + " [" + this.serverName + "]");
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean commandExecutor(String cmd, int cmdType, String function, String value, int ... addresses) {
        byte[] resp = null;
        try {
            block163: {
                block195: {
                    byte fd;
                    block199: {
                        block198: {
                            block197: {
                                block196: {
                                    block191: {
                                        block194: {
                                            block192: {
                                                byte fs;
                                                block193: {
                                                    block179: {
                                                        block182: {
                                                            float v;
                                                            block186: {
                                                                block190: {
                                                                    block189: {
                                                                        block188: {
                                                                            block187: {
                                                                                block180: {
                                                                                    block185: {
                                                                                        block184: {
                                                                                            block183: {
                                                                                                block181: {
                                                                                                    block175: {
                                                                                                        int lv;
                                                                                                        block178: {
                                                                                                            block176: {
                                                                                                                int lv2;
                                                                                                                block177: {
                                                                                                                    block170: {
                                                                                                                        block171: {
                                                                                                                            int lv3;
                                                                                                                            block174: {
                                                                                                                                block172: {
                                                                                                                                    block173: {
                                                                                                                                        block169: {
                                                                                                                                            block165: {
                                                                                                                                                block168: {
                                                                                                                                                    block167: {
                                                                                                                                                        block166: {
                                                                                                                                                            block164: {
                                                                                                                                                                if (!function.equals("power")) break block164;
                                                                                                                                                                if (value.equals("0")) {
                                                                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_power_off, addresses));
                                                                                                                                                                    break block163;
                                                                                                                                                                } else {
                                                                                                                                                                    if (!value.equals("1")) {
                                                                                                                                                                        Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_power_on, addresses));
                                                                                                                                                                }
                                                                                                                                                                break block163;
                                                                                                                                                            }
                                                                                                                                                            if (!function.equals("opmode")) break block165;
                                                                                                                                                            if (!value.equals("fan")) break block166;
                                                                                                                                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_mode_fan, addresses));
                                                                                                                                                            break block163;
                                                                                                                                                        }
                                                                                                                                                        if (!value.equals("heat")) break block167;
                                                                                                                                                        resp = this.httpPostRead(this.formatCommand(this.setStatus_mode_heat, addresses));
                                                                                                                                                        break block163;
                                                                                                                                                    }
                                                                                                                                                    if (!value.equals("cool")) break block168;
                                                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_mode_cool, addresses));
                                                                                                                                                    break block163;
                                                                                                                                                }
                                                                                                                                                if (value.equals("dependent")) {
                                                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_mode_dependent, addresses));
                                                                                                                                                    break block163;
                                                                                                                                                } else if (value.equals("dry")) {
                                                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_mode_dry, addresses));
                                                                                                                                                    break block163;
                                                                                                                                                } else {
                                                                                                                                                    if (!value.equals("auto")) {
                                                                                                                                                        Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_mode_auto, addresses));
                                                                                                                                                }
                                                                                                                                                break block163;
                                                                                                                                            }
                                                                                                                                            if (!function.equals("vent.mode")) break block169;
                                                                                                                                            if (value.equals("auto")) {
                                                                                                                                                resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_mode_auto, addresses));
                                                                                                                                                break block163;
                                                                                                                                            } else if (value.equals("exchange")) {
                                                                                                                                                resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_mode_exchange, addresses));
                                                                                                                                                break block163;
                                                                                                                                            } else {
                                                                                                                                                if (!value.equals("bypass")) {
                                                                                                                                                    Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_mode_bypass, addresses));
                                                                                                                                            }
                                                                                                                                            break block163;
                                                                                                                                        }
                                                                                                                                        if (!function.equals("vent.level")) break block170;
                                                                                                                                        if (!value.equals("switch")) break block171;
                                                                                                                                        int fu = 0;
                                                                                                                                        if (cmdType == 1) {
                                                                                                                                            fu = this.sysVentFU;
                                                                                                                                        } else if (cmdType == 0) {
                                                                                                                                            fu = this.ACs.get(addresses[0]).ventFU;
                                                                                                                                        } else if (cmdType == 2) {
                                                                                                                                            fu = this.diVentFU;
                                                                                                                                        } else if (cmdType == 3) {
                                                                                                                                            fu = this.dioVentFU;
                                                                                                                                        } else if (cmdType == 4) {
                                                                                                                                            fu = this.vrvVentFU;
                                                                                                                                        } else if (cmdType == 5) {
                                                                                                                                            fu = this.hrvVentFU;
                                                                                                                                        }
                                                                                                                                        lv3 = 0;
                                                                                                                                        if (cmdType == 1) {
                                                                                                                                            lv3 = this.sysVentLvl;
                                                                                                                                        } else if (cmdType == 0) {
                                                                                                                                            lv3 = this.ACs.get(addresses[0]).ventLvl;
                                                                                                                                        } else if (cmdType == 2) {
                                                                                                                                            lv3 = this.diVentLvl;
                                                                                                                                        } else if (cmdType == 3) {
                                                                                                                                            lv3 = this.dioVentLvl;
                                                                                                                                        } else if (cmdType == 4) {
                                                                                                                                            lv3 = this.vrvVentLvl;
                                                                                                                                        } else if (cmdType == 5) {
                                                                                                                                            lv3 = this.hrvVentLvl;
                                                                                                                                        }
                                                                                                                                        if (fu != 0) break block172;
                                                                                                                                        if (lv3 != 0) break block173;
                                                                                                                                        resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_low_normal, addresses));
                                                                                                                                        break block163;
                                                                                                                                    }
                                                                                                                                    if (lv3 == 1) {
                                                                                                                                        resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_high_normal, addresses));
                                                                                                                                        break block163;
                                                                                                                                    } else if (lv3 == 2) {
                                                                                                                                        resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_auto_normal, addresses));
                                                                                                                                    }
                                                                                                                                    break block163;
                                                                                                                                }
                                                                                                                                if (lv3 != 0) break block174;
                                                                                                                                resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_low_freshup, addresses));
                                                                                                                                break block163;
                                                                                                                            }
                                                                                                                            if (lv3 == 1) {
                                                                                                                                resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_high_freshup, addresses));
                                                                                                                                break block163;
                                                                                                                            } else if (lv3 == 2) {
                                                                                                                                resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_auto_freshup, addresses));
                                                                                                                            }
                                                                                                                            break block163;
                                                                                                                        }
                                                                                                                        if (value.equals("auto")) {
                                                                                                                            int fu = 0;
                                                                                                                            if (cmdType == 1) {
                                                                                                                                fu = this.sysVentFU;
                                                                                                                            } else if (cmdType == 0) {
                                                                                                                                fu = this.ACs.get(addresses[0]).ventFU;
                                                                                                                            } else if (cmdType == 2) {
                                                                                                                                fu = this.diVentFU;
                                                                                                                            } else if (cmdType == 3) {
                                                                                                                                fu = this.dioVentFU;
                                                                                                                            } else if (cmdType == 4) {
                                                                                                                                fu = this.vrvVentFU;
                                                                                                                            } else if (cmdType == 5) {
                                                                                                                                fu = this.hrvVentFU;
                                                                                                                            }
                                                                                                                            resp = fu == 1 ? this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_auto_freshup, addresses)) : this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_auto_normal, addresses));
                                                                                                                            break block163;
                                                                                                                        } else if (value.equals("low")) {
                                                                                                                            int fu = 0;
                                                                                                                            if (cmdType == 1) {
                                                                                                                                fu = this.sysVentFU;
                                                                                                                            } else if (cmdType == 0) {
                                                                                                                                fu = this.ACs.get(addresses[0]).ventFU;
                                                                                                                            } else if (cmdType == 2) {
                                                                                                                                fu = this.diVentFU;
                                                                                                                            } else if (cmdType == 3) {
                                                                                                                                fu = this.dioVentFU;
                                                                                                                            } else if (cmdType == 4) {
                                                                                                                                fu = this.vrvVentFU;
                                                                                                                            } else if (cmdType == 5) {
                                                                                                                                fu = this.hrvVentFU;
                                                                                                                            }
                                                                                                                            resp = fu == 1 ? this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_low_freshup, addresses)) : this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_low_normal, addresses));
                                                                                                                            break block163;
                                                                                                                        } else {
                                                                                                                            if (!value.equals("high")) {
                                                                                                                                Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            int fu = 0;
                                                                                                                            if (cmdType == 1) {
                                                                                                                                fu = this.sysVentFU;
                                                                                                                            } else if (cmdType == 0) {
                                                                                                                                fu = this.ACs.get(addresses[0]).ventFU;
                                                                                                                            } else if (cmdType == 2) {
                                                                                                                                fu = this.diVentFU;
                                                                                                                            } else if (cmdType == 3) {
                                                                                                                                fu = this.dioVentFU;
                                                                                                                            } else if (cmdType == 4) {
                                                                                                                                fu = this.vrvVentFU;
                                                                                                                            } else if (cmdType == 5) {
                                                                                                                                fu = this.hrvVentFU;
                                                                                                                            }
                                                                                                                            resp = fu == 1 ? this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_high_freshup, addresses)) : this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_high_normal, addresses));
                                                                                                                        }
                                                                                                                        break block163;
                                                                                                                    }
                                                                                                                    if (!function.equals("vent.freshup")) break block175;
                                                                                                                    if (!value.equals("0")) break block176;
                                                                                                                    lv2 = 0;
                                                                                                                    if (cmdType == 1) {
                                                                                                                        lv2 = this.sysVentLvl;
                                                                                                                    } else if (cmdType == 0) {
                                                                                                                        lv2 = this.ACs.get(addresses[0]).ventLvl;
                                                                                                                    } else if (cmdType == 2) {
                                                                                                                        lv2 = this.diVentLvl;
                                                                                                                    } else if (cmdType == 3) {
                                                                                                                        lv2 = this.dioVentLvl;
                                                                                                                    } else if (cmdType == 4) {
                                                                                                                        lv2 = this.vrvVentLvl;
                                                                                                                    } else if (cmdType == 5) {
                                                                                                                        lv2 = this.hrvVentLvl;
                                                                                                                    }
                                                                                                                    if (lv2 != 0) break block177;
                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_auto_normal, addresses));
                                                                                                                    break block163;
                                                                                                                }
                                                                                                                if (lv2 == 1) {
                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_low_normal, addresses));
                                                                                                                    break block163;
                                                                                                                } else if (lv2 == 2) {
                                                                                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_high_normal, addresses));
                                                                                                                }
                                                                                                                break block163;
                                                                                                            }
                                                                                                            if (!value.equals("1")) {
                                                                                                                Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                                                                                                                return false;
                                                                                                            }
                                                                                                            lv = 0;
                                                                                                            if (cmdType == 1) {
                                                                                                                lv = this.sysVentLvl;
                                                                                                            } else if (cmdType == 0) {
                                                                                                                lv = this.ACs.get(addresses[0]).ventLvl;
                                                                                                            } else if (cmdType == 2) {
                                                                                                                lv = this.diVentLvl;
                                                                                                            } else if (cmdType == 3) {
                                                                                                                lv = this.dioVentLvl;
                                                                                                            } else if (cmdType == 4) {
                                                                                                                lv = this.vrvVentLvl;
                                                                                                            } else if (cmdType == 5) {
                                                                                                                lv = this.hrvVentLvl;
                                                                                                            }
                                                                                                            if (lv != 0) break block178;
                                                                                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_auto_freshup, addresses));
                                                                                                            break block163;
                                                                                                        }
                                                                                                        if (lv == 1) {
                                                                                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_low_freshup, addresses));
                                                                                                            break block163;
                                                                                                        } else if (lv == 2) {
                                                                                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_vent_amount_high_freshup, addresses));
                                                                                                        }
                                                                                                        break block163;
                                                                                                    }
                                                                                                    if (!function.equals("setpoint")) break block179;
                                                                                                    v = 0.0f;
                                                                                                    if (!value.equals("up")) break block180;
                                                                                                    if (cmdType != 1) break block181;
                                                                                                    v = this.sysSetpoint + 5;
                                                                                                    break block182;
                                                                                                }
                                                                                                if (cmdType != 0) break block183;
                                                                                                v = this.ACs.get(addresses[0]).setPoint + 5;
                                                                                                break block182;
                                                                                            }
                                                                                            if (cmdType != 2) break block184;
                                                                                            v = this.diSetpoint + 5;
                                                                                            break block182;
                                                                                        }
                                                                                        if (cmdType != 3) break block185;
                                                                                        v = this.dioSetpoint + 5;
                                                                                        break block182;
                                                                                    }
                                                                                    if (cmdType == 4) {
                                                                                        v = this.vrvSetpoint + 5;
                                                                                        break block182;
                                                                                    } else if (cmdType == 5) {
                                                                                        v = this.hrvSetpoint + 5;
                                                                                    }
                                                                                    break block182;
                                                                                }
                                                                                if (!value.equals("down")) break block186;
                                                                                if (cmdType != 1) break block187;
                                                                                v = this.sysSetpoint - 5;
                                                                                break block182;
                                                                            }
                                                                            if (cmdType != 0) break block188;
                                                                            v = this.ACs.get(addresses[0]).setPoint - 5;
                                                                            break block182;
                                                                        }
                                                                        if (cmdType != 2) break block189;
                                                                        v = this.diSetpoint - 5;
                                                                        break block182;
                                                                    }
                                                                    if (cmdType != 3) break block190;
                                                                    v = this.dioSetpoint - 5;
                                                                    break block182;
                                                                }
                                                                if (cmdType == 4) {
                                                                    v = this.vrvSetpoint - 5;
                                                                    break block182;
                                                                } else if (cmdType == 5) {
                                                                    v = this.hrvSetpoint - 5;
                                                                }
                                                                break block182;
                                                            }
                                                            try {
                                                                v = Integer.parseInt(value);
                                                            }
                                                            catch (Exception e2) {
                                                                Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                                                                return false;
                                                            }
                                                        }
                                                        byte[] b2 = this.floatToBytes(v /= 10.0f);
                                                        this.setStatus_setPoint[16] = b2[0];
                                                        this.setStatus_setPoint[17] = b2[1];
                                                        this.setStatus_setPoint[18] = b2[2];
                                                        this.setStatus_setPoint[19] = b2[3];
                                                        resp = this.httpPostRead(this.formatCommand(this.setStatus_setPoint, addresses));
                                                        break block163;
                                                    }
                                                    if (!function.equals("fan.speed")) break block191;
                                                    if (!value.equals("switch")) break block192;
                                                    fs = 0;
                                                    if (cmdType == 1) {
                                                        fs = this.sysFanSpeed;
                                                    } else if (cmdType == 0) {
                                                        fs = this.ACs.get(addresses[0]).fanSpeed;
                                                    } else if (cmdType == 2) {
                                                        fs = this.diFanSpeed;
                                                    } else if (cmdType == 3) {
                                                        fs = this.dioFanSpeed;
                                                    } else if (cmdType == 4) {
                                                        fs = this.vrvFanSpeed;
                                                    } else if (cmdType == 5) {
                                                        fs = this.hrvFanSpeed;
                                                    }
                                                    if (fs != 0) break block193;
                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanSpeed_mid, addresses));
                                                    break block163;
                                                }
                                                if (fs == 1) {
                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanSpeed_high, addresses));
                                                    break block163;
                                                } else if (fs == 2) {
                                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanSpeed_low, addresses));
                                                }
                                                break block163;
                                            }
                                            if (!value.equals("low")) break block194;
                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_fanSpeed_low, addresses));
                                            break block163;
                                        }
                                        if (value.equals("mid")) {
                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_fanSpeed_mid, addresses));
                                            break block163;
                                        } else if (value.equals("high")) {
                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_fanSpeed_high, addresses));
                                            break block163;
                                        } else {
                                            if (!value.equals("auto")) {
                                                Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                                                return false;
                                            }
                                            resp = this.httpPostRead(this.formatCommand(this.setStatus_fanSpeed_auto, addresses));
                                        }
                                        break block163;
                                    }
                                    if (!function.equals("fan.direction")) break block163;
                                    if (!value.equals("switch")) break block195;
                                    fd = 0;
                                    if (cmdType == 1) {
                                        fd = this.sysFanDir;
                                    } else if (cmdType == 0) {
                                        fd = this.ACs.get(addresses[0]).fanDir;
                                    } else if (cmdType == 2) {
                                        fd = this.diFanDir;
                                    } else if (cmdType == 3) {
                                        fd = this.dioFanDir;
                                    } else if (cmdType == 4) {
                                        fd = this.vrvFanDir;
                                    } else if (cmdType == 5) {
                                        fd = this.hrvFanDir;
                                    }
                                    if (fd != 0) break block196;
                                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_1, addresses));
                                    break block163;
                                }
                                if (fd != 1) break block197;
                                resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_2, addresses));
                                break block163;
                            }
                            if (fd != 2) break block198;
                            resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_3, addresses));
                            break block163;
                        }
                        if (fd != 3) break block199;
                        resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_4, addresses));
                        break block163;
                    }
                    if (fd == 4) {
                        resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_swing, addresses));
                        break block163;
                    } else if (fd == 7) {
                        resp = this.httpPostRead(this.formatCommand(setStatus_fanDirection_0, addresses));
                    }
                    break block163;
                }
                if (value.equals("0")) {
                    resp = this.httpPostRead(this.formatCommand(setStatus_fanDirection_0, addresses));
                } else if (value.equals("1")) {
                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_1, addresses));
                } else if (value.equals("2")) {
                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_2, addresses));
                } else if (value.equals("3")) {
                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_3, addresses));
                } else if (value.equals("4")) {
                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_4, addresses));
                } else {
                    if (!value.equals("swing")) {
                        Logger.log(Logger.Mode.ERROR, "commandExecutor - invalid command: " + cmd + " [" + this.serverName + "]");
                        return false;
                    }
                    resp = this.httpPostRead(this.formatCommand(this.setStatus_fanDirection_swing, addresses));
                }
            }
            if (this.checkSetResponse(resp, addresses)) {
                Logger.log(Logger.Mode.LOG, "commandExecutor - command OK: " + cmd + " [" + this.serverName + "]");
                return true;
            }
            Logger.log(Logger.Mode.ERROR, "commandExecutor - command response error: " + cmd + " [" + this.serverName + "]");
            return false;
        }
        catch (Exception e3) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - Exception in thread [" + this.serverName + "] - " + e3);
            return false;
        }
    }

    private boolean checkSetResponse(byte[] resp, int[] addresses) {
        if (resp == null) {
            return false;
        }
        int[] nArray = addresses;
        int n2 = addresses.length;
        int n3 = 0;
        while (n3 < n2) {
            int addr = nArray[n3];
            int a2 = addr / 8 + 20;
            int b2 = addr % 8;
            if ((resp[a2] >>> b2 & 1) == 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private byte[] formatCommand(byte[] cmd, int[] addresses) {
        byte[] ret = new byte[32 + cmd.length * addresses.length];
        ret[0] = (byte)ret.length;
        ret[1] = (byte)(ret.length >>> 8);
        ret[2] = (byte)(ret.length >>> 16);
        ret[3] = (byte)(ret.length >>> 24);
        ret[4] = 118;
        ret[5] = 17;
        ret[6] = 1;
        ret[7] = 0;
        ret[8] = (byte)addresses.length;
        ret[9] = (byte)(addresses.length >>> 8);
        ret[10] = (byte)(addresses.length >>> 16);
        ret[11] = (byte)(addresses.length >>> 24);
        int i2 = 0;
        while (i2 < addresses.length) {
            cmd[0] = (byte)addresses[i2];
            cmd[1] = (byte)(addresses[i2] >>> 8);
            cmd[2] = (byte)(addresses[i2] >>> 16);
            cmd[3] = (byte)(addresses[i2] >>> 24);
            int j2 = 0;
            while (j2 < cmd.length) {
                ret[32 + i2 * cmd.length + j2] = cmd[j2];
                ++j2;
            }
            ++i2;
        }
        return ret;
    }

    private void ioWrite(boolean event, String name, String value) {
        name = String.valueOf(this.serverName) + "." + name;
        if (event) {
            SystemState.ioWrite(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
        if (this.guiSupport) {
            this.uiSet(name, value);
        }
    }

    private void uiSet(String name, String value) {
        if (name.endsWith(".temp") || name.endsWith(".setpoint")) {
            value = String.valueOf(Float.toString(Float.parseFloat(value) / 10.0f)) + " &deg;C";
            user.uiSet(name, "value", value);
        } else if (name.endsWith(".connection")) {
            String vis = "true";
            if (value.equals("online")) {
                vis = "false";
            }
            user.uiSet(String.valueOf(name) + ".label", "visible", vis);
        } else if (name.endsWith(".error")) {
            String vis = "false";
            if (value.equals("1")) {
                vis = "true";
            }
            user.uiSet(String.valueOf(name) + ".label", "visible", vis);
        } else if (name.endsWith(".filter.sign")) {
            String vis = "false";
            if (value.equals("1")) {
                vis = "true";
            }
            user.uiSet(String.valueOf(name) + ".label", "visible", vis);
        } else if (name.endsWith(".power")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "false");
                user.uiSet(name, "value", "ON");
                user.uiSet(name.replace("power", "setpoint"), "visible", "true");
            } else if (value.equals("0")) {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "true");
                user.uiSet(name, "value", "OFF");
                user.uiSet(name.replace("power", "setpoint"), "visible", "false");
            }
        } else if (name.endsWith(".opmode")) {
            user.uiSet(String.valueOf(name) + ".label.fan", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.heat", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.cool", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.dependent", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.dry", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.auto-heat", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.auto-cool", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label." + value, "visible", "true");
        } else if (name.endsWith(".vent.mode")) {
            user.uiSet(String.valueOf(name) + ".label.auto", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.exchange", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.bypass", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label." + value, "visible", "true");
        } else if (name.endsWith(".vent.level")) {
            user.uiSet(String.valueOf(name) + ".label.auto", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.low", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.high", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label." + value, "visible", "true");
        } else if (name.endsWith(".vent.freshup")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "false");
            } else if (value.equals("0")) {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "true");
            }
        } else if (name.endsWith(".fan.speed")) {
            user.uiSet(String.valueOf(name) + ".label.low", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.mid", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.high", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.auto", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label." + value, "visible", "true");
        } else if (name.endsWith(".fan.direction")) {
            user.uiSet(String.valueOf(name) + ".label.0", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.1", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.2", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.3", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.4", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.swing", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label." + value, "visible", "true");
        }
    }

    private byte[] httpPostRead(byte[] data) {
        byte[] byArray;
        if (data == null) {
            return null;
        }
        Socket sock = null;
        BufferedInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            char c2;
            sock = new Socket();
            sock.connect(this.serverSocket, 3000);
            sock.setSoTimeout(11000);
            in = new BufferedInputStream(sock.getInputStream());
            out = sock.getOutputStream();
            String header = "POST /cmd/ HTTP/1.1\r\nContent-Length: " + data.length + "\r\n" + "Content-type: application/octet-stream\r\n" + "\r\n";
            out.write(header.getBytes());
            out.write(data);
            out.flush();
            StringBuffer res = new StringBuffer();
            while ((c2 = (char)in.read()) != '\n') {
                res.append("" + c2);
            }
            if (!res.toString().trim().endsWith("OK")) {
                return null;
            }
            while ((c2 = (char)in.read()) != '\n') {
            }
            while ((c2 = (char)in.read()) != '\n') {
            }
            while ((c2 = (char)in.read()) != '\n') {
            }
            while ((c2 = (char)in.read()) != '\n') {
            }
            res = new StringBuffer();
            while ((c2 = (char)in.read()) != '\n') {
                res.append("" + c2);
            }
            String lenStr = res.toString().substring(res.indexOf(":") + 1).trim();
            try {
                len = Integer.parseInt(lenStr);
            }
            catch (Exception e2) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            while ((c2 = (char)in.read()) != '\n') {
            }
            byte[] resp = new byte[len];
            int i2 = 0;
            while (i2 < resp.length) {
                resp[i2] = (byte)in.read();
                ++i2;
            }
            byArray = resp;
        }
        catch (Exception e3) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - communication error [" + this.serverName + "] - " + e3.getLocalizedMessage());
            return null;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                sock.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    private float bytesToFloat(byte b1, byte b2, byte b3, byte b4) {
        return Float.intBitsToFloat((b1 & 0xFF) + ((b2 & 0xFF) << 8) + ((b3 & 0xFF) << 16) + ((b4 & 0xFF) << 24));
    }

    private byte[] floatToBytes(float f2) {
        int i2 = Float.floatToRawIntBits(f2);
        byte[] b2 = new byte[]{(byte)(i2 & 0xFF), (byte)(i2 >>> 8 & 0xFF), (byte)(i2 >>> 16 & 0xFF), (byte)(i2 >>> 24 & 0xFF)};
        return b2;
    }

    private class AC {
        int address;
        String shortName = null;
        String longName = null;
        byte type = 0;
        byte innerType = 0;
        String typeString;
        private byte error = (byte)-2;
        private String malfunctionCode = "";
        private byte power = (byte)-2;
        private char opMode = (char)65535;
        private char ventMode = (char)65535;
        private char ventAmount = (char)65535;
        private byte setTempEn = (byte)-2;
        private byte roomTempEn = (byte)-2;
        private int temp = -2;
        private int setPoint = -2;
        private byte fanSpeed = (byte)-2;
        private byte fanDir = (byte)-2;
        private byte filterSign = (byte)-2;
        private int ventLvl = -1;
        private int ventFU = -1;

        public AC(int address) {
            this.address = address;
        }

        public void setStatus(byte b2) {
            if (b2 == 1) {
                if (this.error != 0) {
                    this.error = 0;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".error", "0");
                    Daikin.this.checkSystemError();
                }
            } else if (this.error != 1) {
                this.error = 1;
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".error", "1");
                if (Daikin.this.sysError != 1) {
                    Daikin.this.sysError = 1;
                    Daikin.this.ioWrite(Daikin.this.genEvents, "error", "1");
                }
            }
        }

        public void setMalfunctionCode(byte b1, byte b2) {
            String s = new StringBuffer().append((char)b1).append((char)b2).toString();
            if (this.error == 1 && !this.malfunctionCode.equals(s)) {
                this.malfunctionCode = s;
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".error.code", s);
            }
        }

        public void setPower(byte b2) {
            if (this.power != b2) {
                this.power = b2;
                if (b2 == 0) {
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".power", "0");
                    Daikin.this.checkSystemOff(this.type, this.innerType);
                } else if (b2 == 1) {
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".power", "1");
                    if (Daikin.this.sysPower != 1) {
                        Daikin.this.sysPower = 1;
                        Daikin.this.ioWrite(Daikin.this.genEvents, "power", "1");
                    }
                    if (this.type == 6 && Daikin.this.diPower != 1) {
                        Daikin.this.diPower = 1;
                        Daikin.this.ioWrite(Daikin.this.genEvents, "d3di.power", "1");
                    } else if (this.type == 7 && Daikin.this.dioPower != 1) {
                        Daikin.this.dioPower = 1;
                        Daikin.this.ioWrite(Daikin.this.genEvents, "d3dio.power", "1");
                    } else if (this.type == 9 && this.innerType == 0 && Daikin.this.vrvPower != 1) {
                        Daikin.this.vrvPower = 1;
                        Daikin.this.ioWrite(Daikin.this.genEvents, "vrv.power", "1");
                    } else if (this.type == 9 && this.innerType == 3 && Daikin.this.hrvPower != 1) {
                        Daikin.this.hrvPower = 1;
                        Daikin.this.ioWrite(Daikin.this.genEvents, "hrv.power", "1");
                    }
                } else if (b2 == 2) {
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".power", "unknown");
                }
            }
        }

        public void setOpMode(byte b1, byte b2) {
            char m2;
            if (this.type == 9 && this.innerType == 0 && this.opMode != (m2 = (char)(b1 | b2 << 8))) {
                this.opMode = m2;
                String modeStr = "unknown";
                if (m2 == '\u0001') {
                    modeStr = "fan";
                } else if (m2 == '\u0002') {
                    modeStr = "heat";
                } else if (m2 == '\u0004') {
                    modeStr = "cool";
                } else if (m2 == '\u0010') {
                    modeStr = "dependent";
                } else if (m2 == ' ') {
                    modeStr = "ventilation";
                } else if (m2 == '@') {
                    modeStr = "dry";
                } else if (m2 == '\u0100') {
                    modeStr = "auto-heat";
                } else if (m2 == '\u0200') {
                    modeStr = "auto-cool";
                }
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".opmode", modeStr);
                Daikin.this.ioWrite(Daikin.this.genEvents, "opmode", modeStr);
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".opmode", modeStr);
            }
        }

        public void setVentMode(byte b1, byte b2) {
            char m2;
            if (this.type == 9 && this.innerType == 3 && this.ventMode != (m2 = (char)(b1 | b2 << 8))) {
                this.ventMode = m2;
                String modeStr = "unknown";
                if (m2 == '\u0001') {
                    modeStr = "auto";
                } else if (m2 == '\u0002') {
                    modeStr = "exchange";
                } else if (m2 == '\u0004') {
                    modeStr = "bypass";
                }
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".vent.mode", modeStr);
                Daikin.this.ioWrite(Daikin.this.genEvents, "vent.mode", modeStr);
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.mode", modeStr);
            }
        }

        public void setVentAmount(byte b1, byte b2) {
            char m2;
            if (this.type == 9 && this.innerType == 3 && this.ventAmount != (m2 = (char)(b1 | b2 << 8))) {
                this.ventAmount = m2;
                String lvlStr = "unknown";
                String fuStr = "unknown";
                if (m2 == '\u0001') {
                    lvlStr = "auto";
                    fuStr = "0";
                    this.ventLvl = 0;
                    this.ventFU = 0;
                } else if (m2 == '\u0002') {
                    lvlStr = "low";
                    fuStr = "0";
                    this.ventLvl = 1;
                    this.ventFU = 0;
                } else if (m2 == '\u0004') {
                    lvlStr = "high";
                    fuStr = "0";
                    this.ventLvl = 2;
                    this.ventFU = 0;
                } else if (m2 == '\b') {
                    lvlStr = "auto";
                    fuStr = "1";
                    this.ventLvl = 0;
                    this.ventFU = 1;
                } else if (m2 == '\u0010') {
                    lvlStr = "low";
                    fuStr = "1";
                    this.ventLvl = 1;
                    this.ventFU = 1;
                } else if (m2 == ' ') {
                    lvlStr = "high";
                    fuStr = "1";
                    this.ventLvl = 2;
                    this.ventFU = 1;
                }
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".vent.level", lvlStr);
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".vent.freshup", fuStr);
                if (Daikin.this.sysVentLvl != this.ventLvl) {
                    Daikin.this.sysVentLvl = this.ventLvl;
                    Daikin.this.ioWrite(Daikin.this.genEvents, "vent.level", lvlStr);
                }
                if (this.type == 6 && Daikin.this.diVentLvl != this.ventLvl) {
                    Daikin.this.diVentLvl = this.ventLvl;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.level", lvlStr);
                } else if (this.type == 7 && Daikin.this.dioVentLvl != this.ventLvl) {
                    Daikin.this.dioVentLvl = this.ventLvl;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.level", lvlStr);
                } else if (this.type == 9 && this.innerType == 0 && Daikin.this.vrvVentLvl != this.ventLvl) {
                    Daikin.this.vrvVentLvl = this.ventLvl;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.level", lvlStr);
                } else if (this.type == 9 && this.innerType == 3 && Daikin.this.hrvVentLvl != this.ventLvl) {
                    Daikin.this.hrvVentLvl = this.ventLvl;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.level", lvlStr);
                }
                if (Daikin.this.sysVentFU != this.ventFU) {
                    Daikin.this.sysVentFU = this.ventFU;
                    Daikin.this.ioWrite(Daikin.this.genEvents, "vent.freshup", fuStr);
                }
                if (this.type == 6 && Daikin.this.diVentFU != this.ventFU) {
                    Daikin.this.diVentFU = this.ventFU;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.freshup", fuStr);
                } else if (this.type == 7 && Daikin.this.dioVentFU != this.ventFU) {
                    Daikin.this.dioVentFU = this.ventFU;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.freshup", fuStr);
                } else if (this.type == 9 && this.innerType == 0 && Daikin.this.vrvVentFU != this.ventFU) {
                    Daikin.this.vrvVentFU = this.ventFU;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.freshup", fuStr);
                } else if (this.type == 9 && this.innerType == 3 && Daikin.this.hrvVentFU != this.ventFU) {
                    Daikin.this.hrvVentFU = this.ventFU;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".vent.freshup", fuStr);
                }
            }
        }

        public void setEnableTemp(byte b2) {
            byte e2 = (byte)(b2 & 1);
            if (this.setTempEn != e2) {
                this.setTempEn = e2;
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".setpoint.enabled", "" + e2);
            }
            if (this.roomTempEn != (e2 = (byte)(b2 >>> 1 & 1))) {
                this.roomTempEn = e2;
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".temp.enabled", "" + e2);
            }
        }

        public void setRoomTemp(byte b1, byte b2, byte b3, byte b4) {
            int t;
            if (this.type == 9 && this.innerType == 0 && this.temp != (t = (int)(Daikin.this.bytesToFloat(b1, b2, b3, b4) * 10.0f))) {
                this.temp = t;
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".temp", "" + t);
            }
        }

        public void setTemp(byte b1, byte b2, byte b3, byte b4) {
            int t;
            if (this.type == 9 && this.innerType == 0 && this.setPoint != (t = (int)(Daikin.this.bytesToFloat(b1, b2, b3, b4) * 10.0f))) {
                this.setPoint = t;
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".setpoint", "" + t);
                if (Daikin.this.sysSetpoint != t) {
                    Daikin.this.sysSetpoint = t;
                    Daikin.this.ioWrite(Daikin.this.genEvents, "setpoint", "" + t);
                }
                if (this.type == 6 && Daikin.this.diSetpoint != t) {
                    Daikin.this.diSetpoint = t;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".setpoint", "" + t);
                } else if (this.type == 7 && Daikin.this.dioSetpoint != t) {
                    Daikin.this.dioSetpoint = t;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".setpoint", "" + t);
                } else if (this.type == 9 && this.innerType == 0 && Daikin.this.vrvSetpoint != t) {
                    Daikin.this.vrvSetpoint = t;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".setpoint", "" + t);
                } else if (this.type == 9 && this.innerType == 3 && Daikin.this.hrvSetpoint != t) {
                    Daikin.this.hrvSetpoint = t;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".setpoint", "" + t);
                }
            }
        }

        public void setFanSpeed(byte b2) {
            if (this.type == 9 && this.innerType == 0 && this.fanSpeed != b2) {
                this.fanSpeed = b2;
                String modeStr = "unknown";
                if (b2 == 0) {
                    modeStr = "low";
                } else if (b2 == 1) {
                    modeStr = "mid";
                } else if (b2 == 2) {
                    modeStr = "high";
                } else if (b2 == 100) {
                    modeStr = "auto";
                }
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".fan.speed", modeStr);
                if (Daikin.this.sysFanSpeed != b2) {
                    Daikin.this.sysFanSpeed = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, "fan.speed", modeStr);
                }
                if (this.type == 6 && Daikin.this.diFanSpeed != b2) {
                    Daikin.this.diFanSpeed = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.speed", modeStr);
                } else if (this.type == 7 && Daikin.this.dioFanSpeed != b2) {
                    Daikin.this.dioFanSpeed = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.speed", modeStr);
                } else if (this.type == 9 && this.innerType == 0 && Daikin.this.vrvFanSpeed != b2) {
                    Daikin.this.vrvFanSpeed = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.speed", modeStr);
                } else if (this.type == 9 && this.innerType == 3 && Daikin.this.hrvFanSpeed != b2) {
                    Daikin.this.hrvFanSpeed = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.speed", modeStr);
                }
            }
        }

        public void setFanDirection(byte b2) {
            if (this.type == 9 && this.innerType == 0 && this.fanDir != b2) {
                this.fanDir = b2;
                String modeStr = "unknown";
                if (b2 == 0) {
                    modeStr = "0";
                } else if (b2 == 1) {
                    modeStr = "1";
                } else if (b2 == 2) {
                    modeStr = "2";
                } else if (b2 == 3) {
                    modeStr = "3";
                } else if (b2 == 4) {
                    modeStr = "4";
                } else if (b2 == 7) {
                    modeStr = "swing";
                }
                Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".fan.direction", modeStr);
                if (Daikin.this.sysFanDir != b2) {
                    Daikin.this.sysFanDir = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, "fan.direction", modeStr);
                }
                if (this.type == 6 && Daikin.this.diFanDir != b2) {
                    Daikin.this.diFanDir = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.direction", modeStr);
                } else if (this.type == 7 && Daikin.this.dioFanDir != b2) {
                    Daikin.this.dioFanDir = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.direction", modeStr);
                } else if (this.type == 9 && this.innerType == 0 && Daikin.this.vrvFanDir != b2) {
                    Daikin.this.vrvFanDir = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.direction", modeStr);
                } else if (this.type == 9 && this.innerType == 3 && Daikin.this.hrvFanDir != b2) {
                    Daikin.this.hrvFanDir = b2;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.typeString) + ".fan.direction", modeStr);
                }
            }
        }

        public void setFilterSign(byte b2) {
            if (this.type == 9 && this.innerType == 0) {
                if (b2 == 0) {
                    if (this.filterSign != 0) {
                        this.filterSign = 0;
                        Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".filter.sign", "0");
                    }
                } else if (this.filterSign != 1) {
                    this.filterSign = 1;
                    Daikin.this.ioWrite(Daikin.this.genEvents, String.valueOf(this.address) + ".filter.sign", "1");
                }
            }
        }
    }

    private class IOCommandSet
    extends Thread {
        final String value;
        final String name;

        public IOCommandSet(String name, String value) {
            this.name = name;
            this.value = value;
            this.start();
        }

        @Override
        public void run() {
            try {
                IOCommandSet.sleep(2000L);
                Daikin.this.keypadCmds.remove(this.name);
                SystemState.ioSet(String.valueOf(Daikin.this.serverName) + "." + this.name, this.value);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(msg);
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR;

        }
    }
}

