/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.DataLogger;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

class CounterDataLogger
extends DataLogger {
    protected static PreparedStatement INSERT_STMT;
    protected static PreparedStatement UPDATE_STMT;
    protected static PreparedStatement SELECT_STMT;
    protected static PreparedStatement DELETE_BEFORE_STMT;
    protected static PreparedStatement CONSOLIDATE_UPDATE_DELTA_STMT;
    protected static PreparedStatement CONSOLIDATE_UPDATE_COST_STMT;
    protected static PreparedStatement CONSOLIDATE_INSERT_STMT;
    protected static PreparedStatement CONSOLIDATE_DELETE_STMT;
    private static final String SLOTS_FILE_NAME = "dataloggers.ini";
    private final double upperLimit;
    private final double maxDelta;
    private final boolean separateCharts;
    private final boolean slotAlign;
    private final String ratesLogFile;
    private Vector<SlotRule> slotRules;
    private HashMap<Integer, String> slotLabels = new HashMap();
    private HashMap<String, String> moves = null;
    private Double[] hour;
    private Double[] hourPast;
    private Double[] day;
    private Double[] dayPast;
    private Double[] month;
    private Double[] monthPast;
    private Double[] year;
    private Double[] yearPast;
    private LinkedHashMap<Integer, SlotCharts> slotCharts;

    protected CounterDataLogger(String id, int decimals, int hourInterval, int hourConsolidationFactor, int resolution, boolean varSet, double upperLimit, double maxDelta, boolean separateCharts, boolean slotAlign, String ratesLogFile) throws Exception {
        super(id, decimals, hourInterval, resolution, varSet);
        this.hourConsolidationFactor = hourConsolidationFactor;
        this.upperLimit = upperLimit;
        this.maxDelta = maxDelta;
        this.slotAlign = slotAlign;
        this.ratesLogFile = ratesLogFile;
        this.loadSlotsFile();
        boolean bl = this.separateCharts = this.slotRules != null && separateCharts;
        if (lookForOldVars) {
            this.convertData();
        }
        this.setVariables(System.currentTimeMillis());
    }

    @Override
    protected String getFirstDBEntryDate() throws SQLException {
        ResultSet rs = dbConnection.createStatement().executeQuery("select min(ts) from dl_counter where id = '" + this.id + "'");
        String ret = null;
        if (rs.next()) {
            ret = Long.toString(rs.getLong(1));
        }
        rs.close();
        return ret;
    }

    @Override
    protected long getLastDBEntryDate() throws SQLException {
        ResultSet rs = dbConnection.createStatement().executeQuery("select max(ts) from dl_counter where id = '" + this.id + "'");
        long ret = 0L;
        if (rs.next()) {
            ret = rs.getLong(1);
        }
        rs.close();
        return ret;
    }

    private void convertData() throws Exception {
        long dbTs;
        int d2;
        long dbTs2;
        this.rewriteSlotsFileIfAllDLsAreLoaded();
        if (SystemState.varGet(String.valueOf(this.id) + ".counter.chart.day!") == null) {
            return;
        }
        Double[] dayVals = new Double[24];
        Double[] dayPastVals = new Double[24];
        Double[] monthVals = new Double[31];
        Double[] monthPastVals = new Double[31];
        Double[] yearVals = new Double[12];
        Double[] yearPastVals = new Double[12];
        this.loadVarData(String.valueOf(this.id) + ".counter.chart.day!", dayVals);
        this.loadVarData(String.valueOf(this.id) + ".counter.chart.day.past!", dayPastVals);
        if (this.separateCharts) {
            throw new Exception("Data conversion not implemented for Counter DataLoggers with separate slots");
        }
        this.loadVarData(String.valueOf(this.id) + ".counter.chart.month!", monthVals);
        this.loadVarData(String.valueOf(this.id) + ".counter.chart.month.past!", monthPastVals);
        this.loadVarData(String.valueOf(this.id) + ".counter.chart.year!", yearVals);
        this.loadVarData(String.valueOf(this.id) + ".counter.chart.year.past!", yearPastVals);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int currMonth = cal.get(2);
        int currYear = cal.get(1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH0000");
        String toId = this.id;
        if (this.slotRules != null && this.moves != null && (toId = this.moves.get(this.id)) == null) {
            toId = this.id;
        }
        int h2 = 0;
        while (h2 < dayVals.length) {
            if (dayVals[h2] != null) {
                cal.set(11, h2);
                dbTs2 = Long.parseLong(sdf.format(cal.getTime()));
                if (this.slotRules == null) {
                    this.dbWriteDelta(dayVals[h2], dbTs2);
                } else {
                    this.dbWriteCost(toId, dayVals[h2], dbTs2);
                }
            }
            ++h2;
        }
        cal.add(5, -1);
        h2 = 0;
        while (h2 < dayPastVals.length) {
            if (dayPastVals[h2] != null) {
                cal.set(11, h2);
                dbTs2 = Long.parseLong(sdf.format(cal.getTime()));
                if (this.slotRules == null) {
                    this.dbWriteDelta(dayPastVals[h2], dbTs2);
                } else {
                    this.dbWriteCost(toId, dayPastVals[h2], dbTs2);
                }
            }
            ++h2;
        }
        cal.set(11, 0);
        cal.add(5, -1);
        int dayBeforeYesterday = cal.get(5);
        int dayBeforeYesterdaysMonth = cal.get(2);
        if (dayBeforeYesterdaysMonth == currMonth) {
            d2 = 0;
            while (d2 < dayBeforeYesterday) {
                if (monthVals[d2] != null) {
                    cal.set(5, d2 + 1);
                    dbTs = Long.parseLong(sdf.format(cal.getTime()));
                    if (this.slotRules == null) {
                        this.dbWriteDelta(monthVals[d2], dbTs);
                    } else {
                        this.dbWriteCost(toId, monthVals[d2], dbTs);
                    }
                }
                ++d2;
            }
            cal.add(2, -1);
            d2 = 0;
            while (d2 < monthPastVals.length) {
                if (monthPastVals[d2] != null) {
                    cal.set(5, d2 + 1);
                    dbTs = Long.parseLong(sdf.format(cal.getTime()));
                    if (this.slotRules == null) {
                        this.dbWriteDelta(monthPastVals[d2], dbTs);
                    } else {
                        this.dbWriteCost(toId, monthPastVals[d2], dbTs);
                    }
                }
                ++d2;
            }
        } else {
            d2 = 0;
            while (d2 < dayBeforeYesterday) {
                if (monthPastVals[d2] != null) {
                    cal.set(5, d2 + 1);
                    dbTs = Long.parseLong(sdf.format(cal.getTime()));
                    if (this.slotRules == null) {
                        this.dbWriteDelta(monthPastVals[d2], dbTs);
                    } else {
                        this.dbWriteCost(toId, monthPastVals[d2], dbTs);
                    }
                }
                ++d2;
            }
        }
        cal.set(5, 1);
        cal.add(2, -1);
        int twoMonthsAgo = cal.get(2);
        int twoMonthsAgosYear = cal.get(1);
        if (twoMonthsAgosYear == currYear) {
            long dbTs3;
            int m2 = 0;
            while (m2 <= twoMonthsAgo) {
                if (yearVals[m2] != null) {
                    cal.set(2, m2);
                    dbTs3 = Long.parseLong(sdf.format(cal.getTime()));
                    if (this.slotRules == null) {
                        this.dbWriteDelta(yearVals[m2], dbTs3);
                    } else {
                        this.dbWriteCost(toId, yearVals[m2], dbTs3);
                    }
                }
                ++m2;
            }
            cal.add(1, -1);
            m2 = 0;
            while (m2 < yearPastVals.length) {
                if (yearPastVals[m2] != null) {
                    cal.set(2, m2);
                    dbTs3 = Long.parseLong(sdf.format(cal.getTime()));
                    if (this.slotRules == null) {
                        this.dbWriteDelta(yearPastVals[m2], dbTs3);
                    } else {
                        this.dbWriteCost(toId, yearPastVals[m2], dbTs3);
                    }
                }
                ++m2;
            }
        } else {
            int m3 = 0;
            while (m3 < twoMonthsAgo) {
                if (yearPastVals[m3] != null) {
                    cal.set(2, m3);
                    long dbTs4 = Long.parseLong(sdf.format(cal.getTime()));
                    if (this.slotRules == null) {
                        this.dbWriteDelta(yearPastVals[m3], dbTs4);
                    } else {
                        this.dbWriteCost(toId, yearPastVals[m3], dbTs4);
                    }
                }
                ++m3;
            }
        }
    }

    private void rewriteSlotsFileIfAllDLsAreLoaded() throws Exception {
        if (this.moves == null) {
            return;
        }
        for (String dlId : this.moves.keySet()) {
            if (dlId.equals(this.id) || instances.containsKey(dlId.toLowerCase())) continue;
            return;
        }
        for (String dlId : this.moves.values()) {
            if (dlId.equals(this.id) || instances.containsKey(dlId.toLowerCase())) continue;
            return;
        }
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            try {
                String line;
                br = new BufferedReader(new FileReader(SLOTS_FILE_NAME));
                StringBuilder content = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    String lowCaseLine = (line = line.trim()).toLowerCase();
                    if (lowCaseLine.startsWith("move:")) continue;
                    for (Map.Entry<String, String> e2 : this.moves.entrySet()) {
                        String fromId = e2.getKey();
                        String toId = e2.getValue();
                        if (!lowCaseLine.startsWith(fromId) || !lowCaseLine.split(";")[0].equals(fromId) && !lowCaseLine.startsWith(String.valueOf(fromId) + ".slot.label.")) continue;
                        line = String.valueOf(toId) + line.substring(fromId.length());
                        break;
                    }
                    content.append(line);
                    content.append("\n");
                }
                File ini = new File(SLOTS_FILE_NAME);
                bw = new BufferedWriter(new FileWriter(ini));
                bw.write(content.toString());
                bw.flush();
                ini.setWritable(true, false);
            }
            catch (Exception e3) {
                throw new Exception("Error rewriting file 'dataloggers.ini' - " + e3.getLocalizedMessage());
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
            try {
                bw.close();
            }
            catch (Exception exception) {}
        }
    }

    private void loadVarData(String var, Double[] values) {
        String data = SystemState.varGet(var);
        if (data != null && data.length() != 0) {
            String[] fields = data.split("%");
            int deltasIdx = 0;
            if (fields.length == 4) {
                deltasIdx = 3;
            }
            String[] vals = fields[deltasIdx].split("&");
            int i2 = 0;
            while (i2 < vals.length) {
                try {
                    values[i2] = Double.parseDouble(vals[i2].split("#")[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i2;
            }
        }
        this.deleteVar(var);
    }

    private void loadSlotsFile() throws Exception {
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(SLOTS_FILE_NAME));
            }
            catch (FileNotFoundException e2) {
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            try {
                String line;
                boolean loadMoves;
                boolean bl = loadMoves = this.moves == null;
                if (loadMoves) {
                    this.moves = new HashMap();
                }
                int l2 = 1;
                while ((line = br.readLine()) != null) {
                    try {
                        line = line.trim();
                        if (line.toLowerCase().startsWith(this.id)) {
                            String lblPrefix = String.valueOf(this.id) + ".slot.label.";
                            if (line.toLowerCase().startsWith(lblPrefix)) {
                                int equalIdx = line.indexOf(61);
                                int sid = Integer.parseInt(line.substring(lblPrefix.length(), equalIdx).trim());
                                String sLabel = line.substring(equalIdx + 1).trim();
                                this.slotLabels.put(sid, sLabel);
                            } else {
                                String[] prms = line.split(";");
                                if (prms[0].toLowerCase().trim().equals(this.id)) {
                                    String id = prms[1].trim();
                                    String time = prms[2].trim();
                                    String dow = prms[3].trim();
                                    String date = prms[4].trim();
                                    String rate = prms[5].trim();
                                    SlotRule s = new SlotRule(id, time, dow, date, rate);
                                    if (this.slotRules == null) {
                                        this.slotRules = new Vector();
                                    }
                                    this.slotRules.add(s);
                                }
                            }
                        } else if (loadMoves && line.replaceAll("\\s+", "").toLowerCase().startsWith("move:")) {
                            String move = line.substring(line.indexOf(58) + 1);
                            String[] from_to = move.toLowerCase().split(",");
                            this.moves.put(from_to[0].trim(), from_to[1].trim());
                        }
                    }
                    catch (Exception e3) {
                        throw new Exception("line " + l2 + ": " + e3.getLocalizedMessage());
                    }
                    ++l2;
                }
            }
            catch (Exception e4) {
                throw new Exception("Error reading file 'dataloggers.ini' - " + e4.getLocalizedMessage());
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean update(Double val, long timestamp) {
        SimpleDateFormat dbTsFormatter = new SimpleDateFormat(this.dbTsFormat);
        Object object = this.updateLock;
        synchronized (object) {
            boolean updated = false;
            if (this.lastValue != null && val != null) {
                double dlt = val - this.lastValue;
                if (dlt < 0.0 && this.upperLimit > 0.0) {
                    dlt += this.upperLimit;
                }
                if (dlt >= 0.0 && dlt <= this.maxDelta) {
                    long ts = Long.parseLong(dbTsFormatter.format(timestamp));
                    Double cost = null;
                    if (this.slotRules != null) {
                        int y = (int)(ts / 10000000000L);
                        int m2 = (int)(ts % 10000000000L / 100000000L);
                        int d2 = (int)(ts % 100000000L / 1000000L);
                        int h2 = (int)(ts % 1000000L / 10000L);
                        int min = (int)(ts % 10000L / 100L);
                        try {
                            SlotRule s = this.getSlot(y, m2, d2, h2, min);
                            cost = dlt * s.rate;
                            this.writeRateLog(val, timestamp, y, m2, d2, s.id, s.rate, dlt, cost);
                        }
                        catch (Exception e2) {
                            this.writeRateLog(val, timestamp, y, m2, d2, null, null, null, null);
                        }
                    }
                    this.dbWriteDeltaAndCost(dlt, cost, ts);
                    if (this.firstDBEntryDate == null) {
                        this.firstDBEntryDate = Long.toString(ts);
                    }
                    updated = true;
                }
            }
            this.lastValue = val;
            this.lastValueTS = timestamp;
            if (updated) {
                this.setVariables(timestamp);
            }
            this.consolidate();
            return updated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean deleteDataBefore(long dbTimestamp) {
        try {
            PreparedStatement preparedStatement = DELETE_BEFORE_STMT;
            synchronized (preparedStatement) {
                DELETE_BEFORE_STMT.setString(1, this.id);
                DELETE_BEFORE_STMT.setLong(2, dbTimestamp);
                if (DELETE_BEFORE_STMT.executeUpdate() == 0) return false;
                return true;
            }
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error deleting data before " + dbTimestamp + ": " + e2.getLocalizedMessage());
        }
        return false;
    }

    @Override
    protected boolean monthConsolidateDataBefore(long dbTimestamp) {
        boolean consolidated = false;
        try {
            PreparedStatement consolidateSelectStmt = dbConnection.prepareStatement("select ts, delta, cost from dl_counter where id = ? and ts < ? and mod(ts, ?) <> ? limit 1000");
            PreparedStatement delete = dbConnection.prepareStatement("delete from dl_counter where id = ? and ts = ?");
            PreparedStatement insert = dbConnection.prepareStatement("insert into dl_counter (id, ts, delta, cost, locked) values (?, ?, ?, ?, true)");
            PreparedStatement updatedelta = dbConnection.prepareStatement("update dl_counter set delta = isnull(delta, 0) + ?, locked = true where id = ? and ts = ?");
            PreparedStatement updatecost = dbConnection.prepareStatement("update dl_counter set cost = isnull(cost, 0) + ?, locked = true where id = ? and ts = ?");
            consolidateSelectStmt.setString(1, this.id);
            consolidateSelectStmt.setLong(2, dbTimestamp);
            consolidateSelectStmt.setLong(3, 100000000L);
            consolidateSelectStmt.setLong(4, 1000000L);
            ResultSet rs = consolidateSelectStmt.executeQuery();
            while (rs.next()) {
                consolidated = true;
                long fromTs = rs.getLong(1);
                double delta = rs.getDouble(2);
                double cost = rs.getDouble(3);
                int y = (int)(fromTs / 10000000000L);
                int m2 = (int)(fromTs % 10000000000L / 100000000L);
                int d2 = (int)(fromTs % 100000000L / 1000000L);
                int h2 = (int)(fromTs % 1000000L / 10000L);
                int min = (int)(fromTs % 10000L / 100L);
                if (d2 == 1 && h2 == 0 && min == 0) continue;
                String tsStr = "" + y;
                if (m2 < 10) {
                    tsStr = String.valueOf(tsStr) + "0";
                }
                tsStr = String.valueOf(tsStr) + m2;
                tsStr = String.valueOf(tsStr) + "01000000";
                long toTs = Long.parseLong(tsStr);
                this.shift(delete, insert, updatedelta, updatecost, fromTs, toTs, delta, cost);
            }
            rs.close();
            consolidateSelectStmt.close();
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error during month consolidation: " + e2.getLocalizedMessage());
        }
        return consolidated;
    }

    @Override
    protected boolean dayConsolidateDataBefore(long dbTimestamp) {
        boolean consolidated = false;
        try {
            PreparedStatement consolidateSelectStmt = dbConnection.prepareStatement("select ts, delta, cost from dl_counter where id = ? and ts < ? and mod(ts, ?) <> ? limit 1000");
            PreparedStatement delete = dbConnection.prepareStatement("delete from dl_counter where id = ? and ts = ?");
            PreparedStatement insert = dbConnection.prepareStatement("insert into dl_counter (id, ts, delta, cost, locked) values (?, ?, ?, ?, true)");
            PreparedStatement updatedelta = dbConnection.prepareStatement("update dl_counter set delta = isnull(delta, 0) + ?, locked = true where id = ? and ts = ?");
            PreparedStatement updatecost = dbConnection.prepareStatement("update dl_counter set cost = isnull(cost, 0) + ?, locked = true where id = ? and ts = ?");
            consolidateSelectStmt.setString(1, this.id);
            consolidateSelectStmt.setLong(2, dbTimestamp);
            consolidateSelectStmt.setLong(3, 1000000L);
            consolidateSelectStmt.setLong(4, 0L);
            ResultSet rs = consolidateSelectStmt.executeQuery();
            while (rs.next()) {
                consolidated = true;
                long fromTs = rs.getLong(1);
                double delta = rs.getDouble(2);
                double cost = rs.getDouble(3);
                int y = (int)(fromTs / 10000000000L);
                int m2 = (int)(fromTs % 10000000000L / 100000000L);
                int d2 = (int)(fromTs % 100000000L / 1000000L);
                int h2 = (int)(fromTs % 1000000L / 10000L);
                int min = (int)(fromTs % 10000L / 100L);
                if (h2 == 0 && min == 0) continue;
                String tsStr = "" + y;
                if (m2 < 10) {
                    tsStr = String.valueOf(tsStr) + "0";
                }
                tsStr = String.valueOf(tsStr) + m2;
                if (d2 < 10) {
                    tsStr = String.valueOf(tsStr) + "0";
                }
                tsStr = String.valueOf(tsStr) + d2;
                tsStr = String.valueOf(tsStr) + "000000";
                long toTs = Long.parseLong(tsStr);
                this.shift(delete, insert, updatedelta, updatecost, fromTs, toTs, delta, cost);
            }
            rs.close();
            consolidateSelectStmt.close();
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error during day consolidation: " + e2.getLocalizedMessage());
        }
        return consolidated;
    }

    @Override
    protected boolean hourConsolidateDataBefore(long dbTimestamp) {
        boolean consolidated = false;
        try {
            int factorInterval = 60 / this.hourConsolidationFactor;
            PreparedStatement hourConsolidateSelectStmt = dbConnection.prepareStatement("select ts, delta, cost from dl_counter where id = ? and ts < ? and mod(mod(ts, 10000) / 100, ?) <> 0 limit 1000");
            PreparedStatement delete = dbConnection.prepareStatement("delete from dl_counter where id = ? and ts = ?");
            PreparedStatement insert = dbConnection.prepareStatement("insert into dl_counter (id, ts, delta, cost, locked) values (?, ?, ?, ?, true)");
            PreparedStatement updatedelta = dbConnection.prepareStatement("update dl_counter set delta = isnull(delta, 0) + ?, locked = true where id = ? and ts = ?");
            PreparedStatement updatecost = dbConnection.prepareStatement("update dl_counter set cost = isnull(cost, 0) + ?, locked = true where id = ? and ts = ?");
            hourConsolidateSelectStmt.setString(1, this.id);
            hourConsolidateSelectStmt.setLong(2, dbTimestamp);
            hourConsolidateSelectStmt.setLong(3, factorInterval);
            ResultSet rs = hourConsolidateSelectStmt.executeQuery();
            while (rs.next()) {
                consolidated = true;
                long fromTs = rs.getLong(1);
                double delta = rs.getDouble(2);
                double cost = rs.getDouble(3);
                int min = (int)(fromTs % 10000L / 100L);
                int mini = min / factorInterval * factorInterval;
                long toTs = fromTs / 10000L * 10000L + (long)(mini * 100);
                this.shift(delete, insert, updatedelta, updatecost, fromTs, toTs, delta, cost);
            }
            rs.close();
            hourConsolidateSelectStmt.close();
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error during hour consolidation: " + e2.getLocalizedMessage());
        }
        return consolidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shift(PreparedStatement delete, PreparedStatement insert, PreparedStatement updatedelta, PreparedStatement updatecost, long fromTs, long toTs, double delta, double cost) throws SQLException {
        if (delta != 0.0) {
            updatedelta.setDouble(1, delta);
            updatedelta.setString(2, this.id);
            updatedelta.setLong(3, toTs);
            if (updatedelta.executeUpdate() == 0) {
                insert.setString(1, this.id);
                insert.setLong(2, toTs);
                insert.setDouble(3, delta);
                insert.setNull(4, 8);
                insert.executeUpdate();
            }
        }
        if (cost != 0.0) {
            PreparedStatement preparedStatement = updatecost;
            synchronized (preparedStatement) {
                updatecost.setDouble(1, cost);
                updatecost.setString(2, this.id);
                updatecost.setLong(3, toTs);
                if (updatecost.executeUpdate() == 0) {
                    insert.setString(1, this.id);
                    insert.setLong(2, toTs);
                    insert.setDouble(3, 0.0);
                    insert.setDouble(4, cost);
                    insert.executeUpdate();
                }
            }
        }
        delete.setString(1, this.id);
        delete.setLong(2, fromTs);
        delete.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbWriteDeltaAndCost(double delta, Double cost, long dbTimestamp) {
        try {
            PreparedStatement preparedStatement = UPDATE_STMT;
            synchronized (preparedStatement) {
                UPDATE_STMT.setDouble(1, delta);
                if (cost != null) {
                    UPDATE_STMT.setDouble(2, cost);
                } else {
                    UPDATE_STMT.setNull(2, 8);
                }
                UPDATE_STMT.setString(3, this.id);
                UPDATE_STMT.setLong(4, dbTimestamp);
                if (UPDATE_STMT.executeUpdate() == 0) {
                    INSERT_STMT.setString(1, this.id);
                    INSERT_STMT.setLong(2, dbTimestamp);
                    INSERT_STMT.setDouble(3, delta);
                    if (cost != null) {
                        INSERT_STMT.setDouble(4, cost);
                    } else {
                        INSERT_STMT.setNull(4, 8);
                    }
                    INSERT_STMT.executeUpdate();
                }
            }
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error writing to database: " + e2.getLocalizedMessage());
        }
    }

    private void dbWriteDelta(double delta, long dbTimestamp) {
        try {
            Statement update_delta_stmt = dbConnection.createStatement();
            int count = update_delta_stmt.executeUpdate("update dl_counter set delta = " + delta + " where id = '" + this.id + "'" + " and ts = " + dbTimestamp);
            if (count == 0) {
                Statement insert_delta_stmt = dbConnection.createStatement();
                insert_delta_stmt.executeUpdate("insert into dl_counter (id, ts, delta, locked) values ('" + this.id + "', " + dbTimestamp + ", " + delta + ", " + "false)");
            }
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error writing to database: " + e2.getLocalizedMessage());
        }
    }

    private void dbWriteCost(String id, double cost, long dbTimestamp) {
        try {
            Statement update_cost_stmt = dbConnection.createStatement();
            int count = update_cost_stmt.executeUpdate("update dl_counter set cost = " + cost + ", " + " locked = true" + " where id = '" + id + "'" + " and ts = " + dbTimestamp);
            if (count == 0) {
                Statement insert_delta_stmt = dbConnection.createStatement();
                insert_delta_stmt.executeUpdate("insert into dl_counter (id, ts, delta, cost, locked) values ('" + id + "', " + dbTimestamp + ", " + "0, " + cost + ", " + "true)");
            }
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + id + "] - Error writing to database: " + e2.getLocalizedMessage());
        }
    }

    private void writeRateLog(Double val, long timestamp, int year, int mont, int day, Integer slotId, Double rate, Double delta, Double cost) {
        if (this.ratesLogFile != null) {
            String path = "./" + this.ratesLogFile.replace("%Y", "" + year).replace("%M", "" + mont).replace("%D", "" + day);
            String time = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(timestamp);
            StringBuilder line = new StringBuilder(this.id).append(csvSeparator);
            line.append(time).append(csvSeparator);
            if (val != null) {
                line.append(val).append(csvSeparator);
            } else {
                line.append("#").append(csvSeparator);
            }
            if (cost != null) {
                line.append(cost).append(csvSeparator);
            } else {
                line.append("#").append(csvSeparator);
            }
            if (slotId != null) {
                line.append(slotId).append(csvSeparator);
            } else {
                line.append("#").append(csvSeparator);
            }
            if (rate != null) {
                line.append(rate);
            } else {
                line.append("#");
            }
            File csv = new File(path);
            if (!csv.exists()) {
                util.fileLog(path, "datalogger" + csvSeparator + "time" + csvSeparator + "value" + csvSeparator + "cost" + csvSeparator + "slot" + csvSeparator + "rate");
            }
            util.fileLog(path, line.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected synchronized StringBuffer computeCharts(long timestamp, DecimalFormat valuesFormat, int hourInterval, boolean returnJson) throws SQLException {
        dbTsFormatter = new SimpleDateFormat(this.dbTsFormat);
        this.hour = new Double[60];
        this.hourPast = new Double[60];
        this.day = new Double[24];
        this.dayPast = new Double[24];
        this.month = new Double[31];
        this.monthPast = new Double[31];
        this.year = new Double[12];
        this.yearPast = new Double[12];
        if (this.slotRules != null) {
            if (this.separateCharts) {
                this.slotCharts = new LinkedHashMap<K, V>(this.slotRules.size());
                for (SlotRule s : this.slotRules) {
                    if (this.slotCharts.containsKey(SlotRule.access$2(s))) continue;
                    this.slotCharts.put(SlotRule.access$2(s), new SlotCharts());
                }
            } else {
                this.slotCharts = new LinkedHashMap<K, V>(1);
                this.slotCharts.put(0, new SlotCharts());
            }
        }
        to = dbTsFormatter.format(timestamp);
        currY = Integer.parseInt(to.substring(0, 4));
        currM = Integer.parseInt(to.substring(4, 6)) - 1;
        currD = Integer.parseInt(to.substring(6, 8)) - 1;
        currH = Integer.parseInt(to.substring(8, 10));
        yesterday = new GregorianCalendar();
        yesterday.setTimeInMillis(timestamp);
        yesterday.add(5, -1);
        prevM = currM == 0 ? 11 : currM - 1;
        prevD = yesterday.get(5) - 1;
        prevH = currH == 0 ? 23 : currH - 1;
        from = String.valueOf(currY - 1) + "0000000000";
        var18_17 = CounterDataLogger.SELECT_STMT;
        synchronized (var18_17) {
            CounterDataLogger.SELECT_STMT.setString(1, this.id);
            CounterDataLogger.SELECT_STMT.setLong(2, Long.parseLong(from));
            CounterDataLogger.SELECT_STMT.setLong(3, Long.parseLong(to));
            rs = CounterDataLogger.SELECT_STMT.executeQuery();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl43 : MonitorExitStatement: MONITOREXIT : var18_17
            if (true) ** GOTO lbl102
        }
        do {
            ts = rs.getLong(1);
            delta = rs.getDouble(2);
            locked = rs.getBoolean(4);
            cost = 0.0;
            if (locked) {
                cost = rs.getDouble(3);
            }
            y = (int)(ts / 10000000000L);
            m = (int)(ts % 10000000000L / 100000000L);
            d = (int)(ts % 100000000L / 1000000L);
            h = (int)(ts % 1000000L / 10000L);
            min = (int)(ts % 10000L / 100L);
            sc = null;
            if (this.slotRules != null) {
                s = null;
                try {
                    s = this.getSlot(y, m, d, h, min);
                    if (!locked) {
                        cost = delta * SlotRule.access$1(s);
                    }
                }
                catch (Exception var32_52) {
                    // empty catch block
                }
                if (s != null) {
                    sc = this.separateCharts != false ? this.slotCharts.get(SlotRule.access$2(s)) : this.slotCharts.get(0);
                }
            }
            --m;
            --d;
            if (y == currY) {
                if (m == currM) {
                    if (d == currD) {
                        if (h == currH) {
                            this.addToHour(min, delta, cost, sc);
                        } else if (h == prevH) {
                            this.addToPastHour(min, delta, cost, sc);
                        }
                        this.addToDay(h, delta, cost, sc);
                    } else if (d == prevD) {
                        if (currH == 0 && h == prevH) {
                            this.addToPastHour(min, delta, cost, sc);
                        }
                        this.addToPastDay(h, delta, cost, sc);
                    }
                    this.addToMonth(d, delta, cost, sc);
                } else if (m == prevM) {
                    if (currD == 0 && d == prevD) {
                        if (currH == 0 && h == prevH) {
                            this.addToPastHour(min, delta, cost, sc);
                        }
                        this.addToPastDay(h, delta, cost, sc);
                    }
                    this.addToPastMonth(d, delta, cost, sc);
                }
                this.addToYear(m, delta, cost, sc);
                continue;
            }
            if (currM == 0 && m == prevM) {
                if (currD == 0 && d == prevD) {
                    if (currH == 0 && h == prevH) {
                        this.addToPastHour(min, delta, cost, sc);
                    }
                    this.addToPastDay(h, delta, cost, sc);
                }
                this.addToPastMonth(d, delta, cost, sc);
            }
            this.addToPastYear(m, delta, cost, sc);
lbl102:
            // 3 sources

        } while (rs.next());
        rs.close();
        hourTotal = valuesFormat.format(this.sum(this.hour));
        hourPastTotal = valuesFormat.format(this.sum(this.hourPast));
        dayTotal = valuesFormat.format(this.sum(this.day));
        dayPastTotal = valuesFormat.format(this.sum(this.dayPast));
        monthTotal = valuesFormat.format(this.sum(this.month));
        monthPastTotal = valuesFormat.format(this.sum(this.monthPast));
        yearTotal = valuesFormat.format(this.sum(this.year));
        yearPastTotal = valuesFormat.format(this.sum(this.yearPast));
        if (this.varSet) {
            this.varSet("hour.tot", hourTotal);
            this.varSet("hour.past.tot", hourPastTotal);
            this.varSet("day.tot", dayTotal);
            this.varSet("day.past.tot", dayPastTotal);
            this.varSet("month.tot", monthTotal);
            this.varSet("month.past.tot", monthPastTotal);
            this.varSet("year.tot", yearTotal);
            this.varSet("year.past.tot", yearPastTotal);
        }
        jsonBuffer = null;
        if (returnJson) {
            if (hourInterval != 1) {
                day_adjusted = new Double[24 / hourInterval];
                dayPast_adjusted = new Double[24 / hourInterval];
                i = 0;
                while (i < this.day.length) {
                    h = i / hourInterval;
                    if (this.day[i] != null) {
                        day_adjusted[h] = day_adjusted[h] == null ? this.day[i] : day_adjusted[h] + this.day[i];
                    }
                    if (this.dayPast[i] != null) {
                        dayPast_adjusted[h] = dayPast_adjusted[h] == null ? this.dayPast[i] : dayPast_adjusted[h] + this.dayPast[i];
                    }
                    ++i;
                }
            } else {
                day_adjusted = this.day;
                dayPast_adjusted = this.dayPast;
            }
            hourMaxValue = valuesFormat.format(this.getMax(new Double[][]{this.hour}));
            hourPastMaxValue = valuesFormat.format(this.getMax(new Double[][]{this.hourPast}));
            dayMaxValue = valuesFormat.format(this.getMax(new Double[][]{day_adjusted}));
            dayPastMaxValue = valuesFormat.format(this.getMax(new Double[][]{dayPast_adjusted}));
            monthMaxValue = valuesFormat.format(this.getMax(new Double[][]{this.month}));
            monthPastMaxValue = valuesFormat.format(this.getMax(new Double[][]{this.monthPast}));
            yearMaxValue = valuesFormat.format(this.getMax(new Double[][]{this.year}));
            yearPastMaxValue = valuesFormat.format(this.getMax(new Double[][]{this.yearPast}));
            jsonBuffer = new StringBuffer("{\"type\":\"counter\",");
            if (this.slotRules != null) {
                jsonBuffer.append("\"slots\":[");
                jsonBuffer.append("{\"label\":\"Counter\",");
            }
            jsonBuffer.append("\"hour\":{");
            jsonBuffer.append("\"present\":{\"values\":\"");
            i = 0;
            while (i < this.hour.length) {
                if (this.hour[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hour[i]));
                }
                if (i < this.hour.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(hourMaxValue);
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.hourPast.length) {
                if (this.hourPast[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hourPast[i]));
                }
                if (i < this.hourPast.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourPastTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(hourPastMaxValue);
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"day\":{");
            jsonBuffer.append("\"present\":{\"values\":\"");
            i = 0;
            while (i < day_adjusted.length) {
                if (day_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(day_adjusted[i]));
                }
                if (i < day_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(dayMaxValue);
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < dayPast_adjusted.length) {
                if (dayPast_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(dayPast_adjusted[i]));
                }
                if (i < dayPast_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayPastTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(dayPastMaxValue);
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"month\":{");
            jsonBuffer.append("\"present\":{\"values\":\"");
            i = 0;
            while (i < this.month.length) {
                if (this.month[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.month[i]));
                }
                if (i < this.month.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(monthMaxValue);
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.monthPast.length) {
                if (this.monthPast[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.monthPast[i]));
                }
                if (i < this.monthPast.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthPastTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(monthPastMaxValue);
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"year\":{");
            jsonBuffer.append("\"present\":{\"values\":\"");
            i = 0;
            while (i < this.year.length) {
                if (this.year[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.year[i]));
                }
                if (i < this.year.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(yearMaxValue);
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.yearPast.length) {
                if (this.yearPast[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.yearPast[i]));
                }
                if (i < this.yearPast.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearPastTotal);
            jsonBuffer.append("\",\"rangemin\":\"0\"");
            jsonBuffer.append(",\"rangemax\":\"");
            jsonBuffer.append(yearPastMaxValue);
            jsonBuffer.append("\"}}}");
        }
        if (this.slotRules != null) {
            for (SlotCharts sc : this.slotCharts.values()) {
                SlotCharts.access$1(sc, hourInterval);
            }
            if (this.slotAlign) {
                hMV = 0.0;
                dMV = 0.0;
                mMV = 0.0;
                yMV = 0.0;
                for (SlotCharts sc : this.slotCharts.values()) {
                    if (sc.hourMaxValue > dMV) {
                        dMV = sc.hourMaxValue;
                    }
                    if (sc.dayMaxValue > dMV) {
                        dMV = sc.dayMaxValue;
                    }
                    if (sc.monthMaxValue > mMV) {
                        mMV = sc.monthMaxValue;
                    }
                    if (!(sc.yearMaxValue > yMV)) continue;
                    yMV = sc.yearMaxValue;
                }
                for (SlotCharts sc : this.slotCharts.values()) {
                    sc.hourMaxValue = hMV;
                    sc.dayMaxValue = dMV;
                    sc.monthMaxValue = mMV;
                    sc.yearMaxValue = yMV;
                }
            }
            for (Map.Entry e : this.slotCharts.entrySet()) {
                slotId = (Integer)e.getKey();
                sc = (SlotCharts)e.getValue();
                hourTotal = valuesFormat.format(sc.hourTotal);
                hourPastTotal = valuesFormat.format(sc.hourPastTotal);
                dayTotal = valuesFormat.format(sc.dayTotal);
                dayPastTotal = valuesFormat.format(sc.dayPastTotal);
                monthTotal = valuesFormat.format(sc.monthTotal);
                monthPastTotal = valuesFormat.format(sc.monthPastTotal);
                yearTotal = valuesFormat.format(sc.yearTotal);
                yearPastTotal = valuesFormat.format(sc.yearPastTotal);
                if (this.varSet) {
                    this.varSet("s" + slotId + ".hour.tot", hourTotal);
                    this.varSet("s" + slotId + ".hour.past.tot", hourPastTotal);
                    this.varSet("s" + slotId + ".day.tot", dayTotal);
                    this.varSet("s" + slotId + ".day.past.tot", dayPastTotal);
                    this.varSet("s" + slotId + ".month.tot", monthTotal);
                    this.varSet("s" + slotId + ".month.past.tot", monthPastTotal);
                    this.varSet("s" + slotId + ".year.tot", yearTotal);
                    this.varSet("s" + slotId + ".year.past.tot", yearPastTotal);
                }
                if (!returnJson) continue;
                jsonBuffer.append(",{\"label\":\"");
                if (this.separateCharts) {
                    lbl = this.slotLabels.get(slotId);
                    if (lbl == null) {
                        lbl = "Slot " + slotId;
                    }
                    jsonBuffer.append(lbl);
                } else {
                    jsonBuffer.append("Cost");
                }
                jsonBuffer.append("\",\"hour\":{");
                jsonBuffer.append("\"present\":{\"values\":\"");
                i = 0;
                while (i < sc.hour.length) {
                    if (sc.hour[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.hour[i]));
                    }
                    if (i < sc.hour.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(hourTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.hourMaxValue));
                jsonBuffer.append("\"}");
                jsonBuffer.append(",\"past\":{\"values\":\"");
                i = 0;
                while (i < sc.hourPast.length) {
                    if (sc.hourPast[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.hourPast[i]));
                    }
                    if (i < sc.hourPast.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(hourPastTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.hourPastMaxValue));
                jsonBuffer.append("\"}},");
                jsonBuffer.append("\"day\":{");
                jsonBuffer.append("\"present\":{\"values\":\"");
                i = 0;
                while (i < sc.day_adjusted.length) {
                    if (sc.day_adjusted[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.day_adjusted[i]));
                    }
                    if (i < sc.day_adjusted.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(dayTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.dayMaxValue));
                jsonBuffer.append("\"}");
                jsonBuffer.append(",\"past\":{\"values\":\"");
                i = 0;
                while (i < sc.dayPast_adjusted.length) {
                    if (sc.dayPast_adjusted[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.dayPast_adjusted[i]));
                    }
                    if (i < sc.dayPast_adjusted.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(dayPastTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.dayPastMaxValue));
                jsonBuffer.append("\"}},");
                jsonBuffer.append("\"month\":{");
                jsonBuffer.append("\"present\":{\"values\":\"");
                i = 0;
                while (i < sc.month.length) {
                    if (sc.month[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.month[i]));
                    }
                    if (i < sc.month.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(monthTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.monthMaxValue));
                jsonBuffer.append("\"}");
                jsonBuffer.append(",\"past\":{\"values\":\"");
                i = 0;
                while (i < sc.monthPast.length) {
                    if (sc.monthPast[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.monthPast[i]));
                    }
                    if (i < sc.monthPast.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(monthPastTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.monthPastMaxValue));
                jsonBuffer.append("\"}},");
                jsonBuffer.append("\"year\":{");
                jsonBuffer.append("\"present\":{\"values\":\"");
                i = 0;
                while (i < sc.year.length) {
                    if (sc.year[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.year[i]));
                    }
                    if (i < sc.year.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(yearTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.yearMaxValue));
                jsonBuffer.append("\"}");
                jsonBuffer.append(",\"past\":{\"values\":\"");
                i = 0;
                while (i < sc.yearPast.length) {
                    if (sc.yearPast[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.yearPast[i]));
                    }
                    if (i < sc.yearPast.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(yearPastTotal);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.yearPastMaxValue));
                jsonBuffer.append("\"}}}");
            }
            if (returnJson) {
                jsonBuffer.append("]}");
            }
        }
        return jsonBuffer;
    }

    private void addToPastYear(int m2, double delta, double cost, SlotCharts sc) {
        this.yearPast[m2] = this.yearPast[m2] == null ? delta : this.yearPast[m2] + delta;
        if (sc != null) {
            sc.yearPast[m2] = sc.yearPast[m2] == null ? cost : sc.yearPast[m2] + cost;
        }
    }

    private void addToYear(int m2, double delta, double cost, SlotCharts sc) {
        this.year[m2] = this.year[m2] == null ? delta : this.year[m2] + delta;
        if (sc != null) {
            sc.year[m2] = sc.year[m2] == null ? cost : sc.year[m2] + cost;
        }
    }

    private void addToPastMonth(int d2, double delta, double cost, SlotCharts sc) {
        this.monthPast[d2] = this.monthPast[d2] == null ? delta : this.monthPast[d2] + delta;
        if (sc != null) {
            sc.monthPast[d2] = sc.monthPast[d2] == null ? cost : sc.monthPast[d2] + cost;
        }
    }

    private void addToMonth(int d2, double delta, double cost, SlotCharts sc) {
        this.month[d2] = this.month[d2] == null ? delta : this.month[d2] + delta;
        if (sc != null) {
            sc.month[d2] = sc.month[d2] == null ? cost : sc.month[d2] + cost;
        }
    }

    private void addToPastDay(int h2, double delta, double cost, SlotCharts sc) {
        this.dayPast[h2] = this.dayPast[h2] == null ? delta : this.dayPast[h2] + delta;
        if (sc != null) {
            sc.dayPast[h2] = sc.dayPast[h2] == null ? cost : sc.dayPast[h2] + cost;
        }
    }

    private void addToDay(int h2, double delta, double cost, SlotCharts sc) {
        this.day[h2] = this.day[h2] == null ? delta : this.day[h2] + delta;
        if (sc != null) {
            sc.day[h2] = sc.day[h2] == null ? cost : sc.day[h2] + cost;
        }
    }

    private void addToPastHour(int min, double delta, double cost, SlotCharts sc) {
        this.hourPast[min] = this.hourPast[min] == null ? delta : this.hourPast[min] + delta;
        if (sc != null) {
            sc.hourPast[min] = sc.hourPast[min] == null ? cost : sc.hourPast[min] + cost;
        }
    }

    private void addToHour(int min, double delta, double cost, SlotCharts sc) {
        this.hour[min] = this.hour[min] == null ? delta : this.hour[min] + delta;
        if (sc != null) {
            sc.hour[min] = sc.hour[min] == null ? cost : sc.hour[min] + cost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected StringBuffer getBrowserData(DecimalFormat valuesFormat, long from, long to, int resolution, int values) throws SQLException {
        baseChart = new Double[values];
        sltCharts = null;
        if (this.slotRules != null) {
            if (this.separateCharts) {
                sltCharts = new LinkedHashMap<K, V>(this.slotRules.size());
                for (SlotRule s : this.slotRules) {
                    if (sltCharts.containsKey(SlotRule.access$2(s))) continue;
                    sltCharts.put(SlotRule.access$2(s), new SlotChart(values));
                }
            } else {
                sltCharts = new LinkedHashMap<Integer, SlotChart>(1);
                sltCharts.put(0, new SlotChart(values));
            }
        }
        var11_8 = CounterDataLogger.SELECT_STMT;
        synchronized (var11_8) {
            CounterDataLogger.SELECT_STMT.setString(1, this.id);
            CounterDataLogger.SELECT_STMT.setLong(2, from);
            CounterDataLogger.SELECT_STMT.setLong(3, to);
            rs = CounterDataLogger.SELECT_STMT.executeQuery();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl24 : MonitorExitStatement: MONITOREXIT : var11_8
            if (true) ** GOTO lbl80
        }
        do {
            ts = rs.getLong(1);
            delta = rs.getDouble(2);
            locked = rs.getBoolean(4);
            cost = 0.0;
            if (locked) {
                cost = rs.getDouble(3);
            }
            y = (int)(ts / 10000000000L);
            m = (int)(ts % 10000000000L / 100000000L);
            d = (int)(ts % 100000000L / 1000000L);
            h = (int)(ts % 1000000L / 10000L);
            min = (int)(ts % 10000L / 100L);
            sc = null;
            if (this.slotRules != null) {
                s = null;
                try {
                    s = this.getSlot(y, m, d, h, min);
                    if (!locked) {
                        cost = delta * SlotRule.access$1(s);
                    }
                }
                catch (Exception var25_30) {
                    // empty catch block
                }
                if (s != null) {
                    sc = this.separateCharts != false ? (SlotChart)sltCharts.get(SlotRule.access$2(s)) : (SlotChart)sltCharts.get(0);
                }
            }
            switch (resolution) {
                case 0: {
                    if (values <= 10) {
                        i = (int)((long)y - from / 10000000000L);
                        break;
                    }
                    i = (int)((long)y - from / 10000000000L) * 12 + m - 1;
                    break;
                }
                case 1: {
                    if (values <= 12) {
                        i = m - 1;
                        break;
                    }
                    i = (m - 1) * 31 + d - 1;
                    break;
                }
                case 2: {
                    if (values <= 31) {
                        i = d - 1;
                        break;
                    }
                    i = (d - 1) * 24 + h;
                    break;
                }
                case 3: {
                    if (values <= 60) {
                        i = h;
                        break;
                    }
                    i = h * 60 + min;
                    break;
                }
                default: {
                    i = min;
                }
            }
            baseChart[i] = baseChart[i] == null ? delta : baseChart[i] + delta;
            if (sc == null) continue;
            sc.chart[i] = sc.chart[i] == null ? cost : sc.chart[i] + cost;
lbl80:
            // 3 sources

        } while (rs.next());
        rs.close();
        maxValue = valuesFormat.format(this.getMax(new Double[][]{baseChart}));
        total = valuesFormat.format(this.sum(baseChart));
        jsonBuffer = new StringBuffer("{\"type\":\"counter\",");
        if (this.slotRules != null) {
            jsonBuffer.append("\"slots\":[");
            jsonBuffer.append("{\"label\":\"Counter\",");
        }
        jsonBuffer.append("\"browser\":{");
        jsonBuffer.append("\"data\":{\"values\":\"");
        i = 0;
        while (i < baseChart.length) {
            if (baseChart[i] != null) {
                jsonBuffer.append(valuesFormat.format(baseChart[i]));
            }
            if (i < baseChart.length - 1) {
                jsonBuffer.append(",");
            }
            ++i;
        }
        jsonBuffer.append("\",\"total\":\"");
        jsonBuffer.append(total);
        jsonBuffer.append("\",\"rangemin\":\"0\"");
        jsonBuffer.append(",\"rangemax\":\"");
        jsonBuffer.append(maxValue);
        jsonBuffer.append("\"}}}");
        if (this.slotRules != null) {
            for (SlotChart sc : sltCharts.values()) {
                SlotChart.access$1(sc);
            }
            if (this.slotAlign) {
                mv = 0.0;
                for (SlotChart sc : sltCharts.values()) {
                    if (!(sc.maxValue > mv)) continue;
                    mv = sc.maxValue;
                }
                for (SlotChart sc : sltCharts.values()) {
                    sc.maxValue = mv;
                }
            }
            for (Map.Entry e : sltCharts.entrySet()) {
                slotId = (Integer)e.getKey();
                sc = (SlotChart)e.getValue();
                total = valuesFormat.format(sc.total);
                jsonBuffer.append(",{\"label\":\"");
                if (this.separateCharts) {
                    lbl = this.slotLabels.get(slotId);
                    if (lbl == null) {
                        lbl = "Slot " + slotId;
                    }
                    jsonBuffer.append(lbl);
                } else {
                    jsonBuffer.append("Cost");
                }
                jsonBuffer.append("\",\"browser\":{");
                jsonBuffer.append("\"data\":{\"values\":\"");
                i = 0;
                while (i < sc.chart.length) {
                    if (sc.chart[i] != null) {
                        jsonBuffer.append(valuesFormat.format(sc.chart[i]));
                    }
                    if (i < sc.chart.length - 1) {
                        jsonBuffer.append(",");
                    }
                    ++i;
                }
                jsonBuffer.append("\",\"total\":\"");
                jsonBuffer.append(total);
                jsonBuffer.append("\",\"rangemin\":\"0\"");
                jsonBuffer.append(",\"rangemax\":\"");
                jsonBuffer.append(valuesFormat.format(sc.maxValue));
                jsonBuffer.append("\"}}}");
            }
            jsonBuffer.append("]}");
        }
        return jsonBuffer;
    }

    private SlotRule getSlot(int year, int month, int day, int hour, int min) throws Exception {
        if (this.slotRules == null) {
            return null;
        }
        for (SlotRule s : this.slotRules) {
            if (!s.matches(year, month, day, hour, min)) continue;
            return s;
        }
        throw new Exception("no matching slot");
    }

    @Override
    protected void clear() {
        try {
            Statement delete_stmt = dbConnection.createStatement();
            delete_stmt.executeUpdate("delete from dl_counter where id='" + this.id + "'");
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error deleting data: " + e2.getLocalizedMessage());
        }
    }

    @Override
    protected Vector<Double[]> getDayCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.day);
        if (this.slotRules != null) {
            for (SlotCharts sc : this.slotCharts.values()) {
                charts.add(sc.day);
            }
        }
        return charts;
    }

    @Override
    protected Vector<Double[]> getDayPastCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.dayPast);
        if (this.slotRules != null) {
            for (SlotCharts sc : this.slotCharts.values()) {
                charts.add(sc.dayPast);
            }
        }
        return charts;
    }

    @Override
    protected Vector<Double[]> getMonthCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.month);
        if (this.slotRules != null) {
            for (SlotCharts sc : this.slotCharts.values()) {
                charts.add(sc.month);
            }
        }
        return charts;
    }

    @Override
    protected Vector<Double[]> getMonthPastCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.monthPast);
        if (this.slotRules != null) {
            for (SlotCharts sc : this.slotCharts.values()) {
                charts.add(sc.monthPast);
            }
        }
        return charts;
    }

    @Override
    protected Vector<Double[]> getYearCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.year);
        if (this.slotRules != null) {
            for (SlotCharts sc : this.slotCharts.values()) {
                charts.add(sc.year);
            }
        }
        return charts;
    }

    @Override
    protected Vector<Double[]> getYearPastCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.yearPast);
        if (this.slotRules != null) {
            for (SlotCharts sc : this.slotCharts.values()) {
                charts.add(sc.yearPast);
            }
        }
        return charts;
    }

    @Override
    protected Vector<String> getChartsNames() {
        Vector<String> names = new Vector<String>();
        names.add(String.valueOf(this.id) + ".count");
        if (this.slotRules != null) {
            if (this.separateCharts) {
                for (Integer i2 : this.slotCharts.keySet()) {
                    names.add(String.valueOf(this.id) + ".cost.s" + i2);
                }
            } else {
                names.add(String.valueOf(this.id) + ".cost");
            }
        }
        return names;
    }

    private class SlotChart {
        Double[] chart;
        double maxValue;
        double total;

        private SlotChart(int values) {
            this.chart = new Double[values];
        }

        private void calculate() {
            this.maxValue = CounterDataLogger.this.getMax(new Double[][]{this.chart});
            this.total = CounterDataLogger.this.sum(this.chart);
        }

        static /* synthetic */ void access$1(SlotChart slotChart) {
            slotChart.calculate();
        }
    }

    private class SlotCharts {
        Double[] hour = new Double[60];
        Double[] hourPast = new Double[60];
        Double[] day = new Double[24];
        Double[] dayPast = new Double[24];
        Double[] month = new Double[31];
        Double[] monthPast = new Double[31];
        Double[] year = new Double[12];
        Double[] yearPast = new Double[12];
        Double[] day_adjusted;
        Double[] dayPast_adjusted;
        double hourMaxValue;
        double hourPastMaxValue;
        double hourTotal;
        double hourPastTotal;
        double dayMaxValue;
        double dayPastMaxValue;
        double dayTotal;
        double dayPastTotal;
        double monthMaxValue;
        double monthPastMaxValue;
        double monthTotal;
        double monthPastTotal;
        double yearMaxValue;
        double yearPastMaxValue;
        double yearTotal;
        double yearPastTotal;

        private SlotCharts() {
        }

        private void calculate(int hourInterval) {
            if (hourInterval != 1) {
                this.day_adjusted = new Double[24 / hourInterval];
                this.dayPast_adjusted = new Double[24 / hourInterval];
                int i2 = 0;
                while (i2 < this.day.length) {
                    int h2 = i2 / hourInterval;
                    if (this.day[i2] != null) {
                        this.day_adjusted[h2] = this.day_adjusted[h2] == null ? this.day[i2] : this.day_adjusted[h2] + this.day[i2];
                    }
                    if (this.dayPast[i2] != null) {
                        this.dayPast_adjusted[h2] = this.dayPast_adjusted[h2] == null ? this.dayPast[i2] : this.dayPast_adjusted[h2] + this.dayPast[i2];
                    }
                    ++i2;
                }
            } else {
                this.day_adjusted = this.day;
                this.dayPast_adjusted = this.dayPast;
            }
            this.hourMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.hour});
            this.hourPastMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.hourPast});
            this.hourTotal = CounterDataLogger.this.sum(this.hour);
            this.hourPastTotal = CounterDataLogger.this.sum(this.hourPast);
            this.dayMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.day_adjusted});
            this.dayPastMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.dayPast_adjusted});
            this.dayTotal = CounterDataLogger.this.sum(this.day_adjusted);
            this.dayPastTotal = CounterDataLogger.this.sum(this.dayPast_adjusted);
            this.monthMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.month});
            this.monthPastMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.monthPast});
            this.monthTotal = CounterDataLogger.this.sum(this.month);
            this.monthPastTotal = CounterDataLogger.this.sum(this.monthPast);
            this.yearMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.year});
            this.yearPastMaxValue = CounterDataLogger.this.getMax(new Double[][]{this.yearPast});
            this.yearTotal = CounterDataLogger.this.sum(this.year);
            this.yearPastTotal = CounterDataLogger.this.sum(this.yearPast);
        }

        static /* synthetic */ void access$1(SlotCharts slotCharts, int n2) {
            slotCharts.calculate(n2);
        }
    }

    private class SlotRule {
        private final int id;
        private final SlotTime startTime;
        private final SlotTime endTime;
        private final int[] dow;
        private final SlotDate startDate;
        private final boolean dateRange;
        private final SlotDate endDate;
        private final double rate;

        private SlotRule(String id, String time, String dow, String date, String rate) throws Exception {
            this.id = Integer.parseInt(id);
            if (!time.equals("*")) {
                String[] start_end = time.split("-");
                this.startTime = new SlotTime(start_end[0]);
                this.endTime = new SlotTime(start_end[1]);
            } else {
                this.startTime = null;
                this.endTime = null;
            }
            if (!dow.equals("*")) {
                this.dow = new int[dow.length()];
                int i2 = 0;
                while (i2 < dow.length()) {
                    this.dow[i2] = Integer.parseInt(Character.toString(dow.charAt(i2)));
                    if (this.dow[i2] < 1 || this.dow[i2] > 7) {
                        throw new Exception("Invalid day of week " + this.dow[i2]);
                    }
                    ++i2;
                }
            } else {
                this.dow = null;
            }
            if (!date.equals("*")) {
                String[] start_end = date.split("-");
                this.startDate = !start_end[0].equals("*") ? new SlotDate(start_end[0]) : null;
                if (start_end.length > 1) {
                    this.dateRange = true;
                    if (!start_end[1].equals("*")) {
                        if (!start_end[0].equals("*") && start_end[0].contains("*") || start_end[1].contains("*")) {
                            throw new Exception("It is not allowed to use a wildcard character (*) for fields of date ranges");
                        }
                        this.endDate = new SlotDate(start_end[1]);
                    } else {
                        this.endDate = null;
                    }
                } else {
                    this.dateRange = false;
                    this.endDate = null;
                }
            } else {
                this.dateRange = false;
                this.startDate = null;
                this.endDate = null;
            }
            this.rate = Double.parseDouble(rate);
        }

        private boolean matches(int year, int month, int day, int hour, int min) {
            SlotTime t;
            SlotDate dt = new SlotDate(year, month, day);
            if (!this.dateRange && this.startDate != null ? !this.startDate.matches(dt) : (this.startDate != null ? (this.endDate != null ? !this.startDate.isBeforeOrEqualTo(dt) || !this.endDate.isAfterOrEqualTo(dt) : !this.startDate.isBeforeOrEqualTo(dt)) : this.endDate != null && !this.endDate.isAfterOrEqualTo(dt))) {
                return false;
            }
            if (this.dow != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(1, year);
                cal.set(2, month - 1);
                cal.set(5, day);
                int d2 = cal.get(7);
                d2 = d2 == 1 ? 7 : d2 - 1;
                boolean listed = false;
                int[] nArray = this.dow;
                int n2 = this.dow.length;
                int n3 = 0;
                while (n3 < n2) {
                    int i2 = nArray[n3];
                    if (d2 == i2) {
                        listed = true;
                        break;
                    }
                    ++n3;
                }
                if (!listed) {
                    return false;
                }
            }
            return this.startTime == null || this.startTime.isBeforeOrEqualsTo(t = new SlotTime(hour, min)) && this.endTime.isAfterOrEqualsTo(t);
        }

        private class SlotDate {
            int year = -1;
            int month = -1;
            int day = -1;

            private SlotDate(int year, int month, int day) {
                this.year = year;
                this.month = month;
                this.day = day;
            }

            private SlotDate(String date) throws Exception {
                String[] ymd = date.split("/");
                if (!ymd[0].equals("*")) {
                    this.year = Integer.parseInt(ymd[0]);
                }
                if (!ymd[1].equals("*")) {
                    this.month = Integer.parseInt(ymd[1]);
                    if (this.month < 1 || this.month > 12) {
                        throw new Exception("Invalid date " + date);
                    }
                }
                if (!ymd[2].equals("*")) {
                    this.day = Integer.parseInt(ymd[2]);
                    if (this.day < 1 || this.day > 31) {
                        throw new Exception("Invalid date " + date);
                    }
                }
            }

            private boolean matches(SlotDate anotherDate) {
                if (this.year != -1 && this.year != anotherDate.year) {
                    return false;
                }
                if (this.month != -1 && this.month != anotherDate.month) {
                    return false;
                }
                return this.day == -1 || this.day == anotherDate.day;
            }

            private boolean isBeforeOrEqualTo(SlotDate d2) {
                return this.year < d2.year || this.year == d2.year && (this.month < d2.month || this.month == d2.month && this.day <= d2.day);
            }

            private boolean isAfterOrEqualTo(SlotDate d2) {
                return this.year > d2.year || this.year == d2.year && (this.month > d2.month || this.month == d2.month && this.day >= d2.day);
            }
        }

        private class SlotTime {
            int hour;
            int min;

            private SlotTime(int hour, int min) {
                this.hour = hour;
                this.min = min;
            }

            private SlotTime(String time) throws Exception {
                String[] hm = time.split(":");
                this.hour = Integer.parseInt(hm[0]);
                this.min = Integer.parseInt(hm[1]);
                if (this.hour < 0 || this.hour > 23 || this.min < 0 || this.min > 59) {
                    throw new Exception("Invalid time " + time);
                }
            }

            private boolean isAfterOrEqualsTo(SlotTime t) {
                return this.hour > t.hour || this.hour == t.hour && this.min >= t.min;
            }

            private boolean isBeforeOrEqualsTo(SlotTime t) {
                return this.hour < t.hour || this.hour == t.hour && this.min <= t.min;
            }
        }
    }
}

