/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.CAMObject;
import com.hsyco.Configuration;
import com.hsyco.DigestParams;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

class CamerasStatusClient
extends Thread {
    public long heartbeat = 0L;
    public boolean quit = false;
    private int camIndex = -1;
    CAMObject camo = null;

    public CamerasStatusClient(int camIndex) {
        this.camIndex = camIndex;
        this.heartbeat = System.currentTimeMillis();
    }

    @Override
    public void run() {
        boolean connected = false;
        String cameraName = null;
        URL statusUrl = null;
        URLConnection uc = null;
        String user2 = null;
        String password = null;
        String auth = null;
        DigestParams authparams = null;
        InputStream instream = null;
        BufferedReader inreader = null;
        long sleepmillis = 1000L;
        int contentLength = 0;
        String line = null;
        String lastCameraReport = "";
        try {
            URL camUrl = null;
            user2 = Configuration.CamerasUser.elementAt(this.camIndex);
            password = Configuration.CamerasPassword.elementAt(this.camIndex);
            auth = Configuration.CamerasAuth.elementAt(this.camIndex);
            cameraName = Configuration.getCameraName(this.camIndex);
            this.camo = SystemState.camoGet(this.camIndex);
            switch (this.camo.model) {
                case 4: {
                    camUrl = Configuration.CamerasURL.elementAt(this.camIndex);
                    statusUrl = new URL(camUrl.getProtocol(), camUrl.getHost(), "/rev.cgi?Cmd=nav&action=1");
                    break;
                }
                case 7: {
                    camUrl = Configuration.CamerasURL.elementAt(this.camIndex);
                    statusUrl = new URL(camUrl.getProtocol(), camUrl.getHost(), "/cgi-bin/motion?submenu=motion&action=monitor");
                    break;
                }
                case 8: {
                    camUrl = Configuration.CamerasURL.elementAt(this.camIndex);
                    statusUrl = new URL(camUrl.getProtocol(), camUrl.getHost(), "/cgi-bin/control.cgi?msubmenu=motion&action=monitor");
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Exception in CamerasStatusClient thread initialization [" + this.camIndex + "] - " + e2.getLocalizedMessage());
            return;
        }
        hsyco.messageLog("CamerasStatusClient thread started [" + this.camIndex + "]");
        while (!this.quit) {
            try {
                int code;
                long t;
                this.heartbeat = t = System.currentTimeMillis();
                if (this.camo.model == 4) {
                    uc = statusUrl.openConnection();
                    uc.setConnectTimeout(6000);
                    uc.setReadTimeout(6000);
                    if (authparams == null) {
                        if (auth != null) {
                            uc.setRequestProperty("Authorization", auth);
                        }
                    } else if ((authparams = util.httpDigestAuth(authparams)) != null) {
                        uc.setRequestProperty("Authorization", authparams.authorization);
                    }
                    if ((code = util.httpResponseCode(uc)) == 200) {
                        contentLength = uc.getContentLength();
                        instream = uc.getInputStream();
                        byte[] data = new byte[contentLength];
                        int off = 0;
                        while (off < contentLength && !this.quit) {
                            int r = instream.read(data, off, data.length - off);
                            if (r == -1) {
                                instream.close();
                                this.quit = true;
                                continue;
                            }
                            off += r;
                        }
                        instream.close();
                        if (off == contentLength) {
                            int room = 0;
                            int nav = 0;
                            int wifi = 0;
                            boolean charging = false;
                            boolean lowbattery = false;
                            String status = new String(data);
                            String[] sa = status.split("[\\|\\n\\r]+");
                            int i2 = 0;
                            while (i2 < sa.length) {
                                if (sa[i2].startsWith("room=")) {
                                    room = Integer.parseInt(sa[i2].substring(5));
                                } else if (sa[i2].startsWith("ss=")) {
                                    nav = Integer.parseInt(sa[i2].substring(3)) / 5000;
                                } else if (sa[i2].startsWith("wifi_ss=")) {
                                    wifi = Integer.parseInt(sa[i2].substring(8)) / 50;
                                } else if (sa[i2].startsWith("battery=")) {
                                    lowbattery = Integer.parseInt(sa[i2].substring(8)) < 110;
                                } else if (sa[i2].startsWith("charging=")) {
                                    charging = Integer.parseInt(sa[i2].substring(9)) == 80;
                                }
                                ++i2;
                            }
                            StringBuffer sb = new StringBuffer();
                            sb.append("NAV:");
                            if (nav > 0) {
                                sb.append(room);
                                sb.append("/");
                                sb.append(nav);
                            } else {
                                sb.append("NO");
                            }
                            sb.append(" WIFI:");
                            sb.append(wifi);
                            sb.append(" BAT:");
                            if (charging) {
                                sb.append("CH");
                            } else if (lowbattery) {
                                sb.append("LO");
                            } else {
                                sb.append("OK");
                            }
                            String newCameraReport = sb.toString();
                            if (!lastCameraReport.equals(newCameraReport)) {
                                lastCameraReport = new String(newCameraReport);
                                SystemState.cameraReportSet(newCameraReport, this.camIndex);
                            }
                            sleepmillis = 2000L;
                        } else {
                            SystemState.cameraReportSet("", this.camIndex);
                            this.quit = true;
                            hsyco.errorLog("Error reading camera status from server in CamerasStatusClient thread loop: " + Configuration.CamerasURL.elementAt(this.camIndex));
                        }
                    } else if (code == 401) {
                        if (authparams != null) {
                            Thread.sleep(1000L);
                        }
                        if ((authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "GET", statusUrl.getFile(), user2, password)) != null) continue;
                        this.quit = true;
                    } else {
                        this.quit = true;
                    }
                } else if (this.camo.model == 7 || this.camo.model == 8) {
                    if (!connected) {
                        uc = statusUrl.openConnection();
                        uc.setConnectTimeout(6000);
                        uc.setReadTimeout(6000);
                        if (authparams == null) {
                            if (auth != null) {
                                uc.setRequestProperty("Authorization", auth);
                            }
                        } else if ((authparams = util.httpDigestAuth(authparams)) != null) {
                            uc.setRequestProperty("Authorization", authparams.authorization);
                        }
                        if ((code = util.httpResponseCode(uc)) == 200) {
                            instream = uc.getInputStream();
                            inreader = new BufferedReader(new InputStreamReader(instream));
                            String type = uc.getContentType();
                            if (type.startsWith("multipart/x-mixed-replace")) {
                                connected = true;
                            } else {
                                int i3 = 0;
                                while (i3 < 100000 && instream.read() != -1) {
                                    ++i3;
                                }
                                instream.close();
                                sleepmillis = 30000L;
                            }
                        } else if (code == 401) {
                            if (authparams != null) {
                                Thread.sleep(1000L);
                            }
                            if ((authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "GET", statusUrl.getFile(), user2, password)) != null) continue;
                            this.quit = true;
                        } else {
                            this.quit = true;
                        }
                    }
                    if (connected) {
                        while (!(line = inreader.readLine()).startsWith("motion:")) {
                        }
                        if (line.endsWith("H")) {
                            SystemState.cameraRecTrigger(cameraName, null, this.camIndex, "HTTP Motion Notification", Configuration.CamerasRecordingMotionTriggerSeconds, false);
                        }
                    }
                }
            }
            catch (Exception e3) {
                hsyco.errorLog("Exception in CamerasStatusClient thread loop [" + this.camIndex + "] - " + e3.getLocalizedMessage());
                this.quit = true;
            }
            if (connected) continue;
            try {
                Thread.sleep(sleepmillis);
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        try {
            int i4 = 0;
            while (i4 < 100000 && instream.read() != -1) {
                ++i4;
            }
            instream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        hsyco.errorLog("Quit CamerasStatusClient thread [" + this.camIndex + "]");
    }
}

