/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;

class CAMObject {
    int cameraid;
    int type;
    int model;
    String command;
    String value;
    boolean single_step;
    String s_move;
    String s_light;
    String s_headpos;
    int s_zoom;
    int s_pan;
    int s_tilt;
    int vptz_sx1;
    int vptz_sy1;
    int vptz_sx2;
    int vptz_sy2;
    int vptz_xmax;
    int vptz_ymax;
    boolean command_dispatcher;
    boolean command_repeat;
    long time;

    CAMObject(int camera) {
        this.cameraid = camera;
        String ptztype = Configuration.CamerasPTZ.elementAt(camera);
        String modeltype = Configuration.CamerasType.elementAt(camera);
        this.command = null;
        this.value = null;
        this.s_move = "";
        this.s_light = "";
        this.s_headpos = "";
        this.single_step = false;
        this.time = 0L;
        if (ptztype == null) {
            this.type = -1;
            this.model = -1;
            this.command_dispatcher = false;
            this.command_repeat = false;
        } else if (ptztype.equalsIgnoreCase("axis")) {
            this.type = 1;
            this.model = 1;
            this.command_dispatcher = true;
            this.command_repeat = false;
        } else if (ptztype.equalsIgnoreCase("axis-vptz")) {
            this.type = 6;
            this.model = 6;
            this.command_dispatcher = true;
            this.command_repeat = true;
        } else if (ptztype.equalsIgnoreCase("panasonic")) {
            this.type = 2;
            this.model = 2;
            this.command_dispatcher = true;
            this.command_repeat = true;
        } else if (ptztype.equalsIgnoreCase("panasonic-wv")) {
            this.type = 3;
            this.model = 3;
            this.command_dispatcher = true;
            this.command_repeat = true;
        } else if (ptztype.equalsIgnoreCase("rovio")) {
            this.type = 4;
            this.model = 4;
            this.command_dispatcher = true;
            this.command_repeat = true;
        } else if (ptztype.equalsIgnoreCase("mobotix")) {
            this.type = 5;
            this.model = 5;
            this.command_dispatcher = true;
            this.command_repeat = true;
        } else if (ptztype.equalsIgnoreCase("samsung23")) {
            this.type = 8;
            this.command_dispatcher = true;
            this.command_repeat = false;
        } else if (ptztype.equalsIgnoreCase("user")) {
            this.type = 0;
            this.model = 0;
            this.command_dispatcher = false;
            this.command_repeat = false;
        } else if (ptztype.equalsIgnoreCase("vptz")) {
            this.type = 99;
            this.model = -1;
            this.s_zoom = 1;
            this.s_tilt = 0;
            this.s_pan = 0;
            this.command_dispatcher = true;
            this.command_repeat = true;
        } else {
            this.type = -1;
            this.model = -1;
            this.command_dispatcher = false;
            this.command_repeat = false;
        }
        if (this.model == -1) {
            if (modeltype.equalsIgnoreCase("samsung1")) {
                this.model = 7;
            } else if (modeltype.equalsIgnoreCase("samsung2")) {
                this.model = 8;
            }
        }
    }

    void updateVirtualPTZCoordinates() {
        try {
            float zoomfactor = 2.0f + 8.0f * (float)(this.s_zoom - 1) / 19.0f;
            int w2 = Math.round((float)(this.vptz_xmax + 1) / zoomfactor);
            int h2 = Math.round((float)(this.vptz_ymax + 1) / zoomfactor);
            int cx = Math.round((float)((this.s_pan + 10) * this.vptz_xmax) / 20.0f);
            int cy = Math.round((float)((this.s_tilt + 10) * this.vptz_ymax) / 20.0f);
            if (cx < w2) {
                cx = w2;
            } else if (cx > this.vptz_xmax - w2) {
                cx = this.vptz_xmax - w2;
            }
            if (cy < h2) {
                cy = h2;
            } else if (cy > this.vptz_ymax - h2) {
                cy = this.vptz_ymax - h2;
            }
            this.vptz_sx1 = cx - w2;
            this.vptz_sx2 = cx + w2;
            this.vptz_sy1 = cy - h2;
            this.vptz_sy2 = cy + h2;
        }
        catch (Exception e2) {
            this.vptz_sy1 = 0;
            this.vptz_sx1 = 0;
            this.vptz_sx2 = this.vptz_xmax;
            this.vptz_sy2 = this.vptz_ymax;
        }
    }
}

