/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.AudioItem;
import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class AudioServer
extends Thread {
    public long heartbeat = 0L;
    private String TtsWavFile = null;
    private static ArrayBlockingQueue<AudioItem> queue = new ArrayBlockingQueue(32);
    private static Vector<String> webQueue = new Vector();
    private Process rtpProcess = null;

    public static int file(String where, String filename) {
        if (where.equals("speaker") || where.startsWith("web") || where.indexOf(64) != -1) {
            File f2 = new File(filename);
            if (f2.canRead()) {
                AudioItem item = new AudioItem(where, f2);
                try {
                    queue.add(item);
                    return queue.size();
                }
                catch (IllegalStateException e2) {
                    hsyco.errorLog("Audio Server error: the playback queue is full - entry has been discarded");
                }
            } else {
                hsyco.errorLog("Audio Server error: file not found - entry has been discarded [" + filename + "]");
            }
        }
        return -1;
    }

    public static int voice(String where, String voice, String text) {
        if ((where.equals("speaker") || where.startsWith("web") || where.indexOf(64) != -1) && (voice != null && voice.length() > 0 || voice == null) && text != null && text.length() > 0) {
            AudioItem item = new AudioItem(where, voice, text);
            try {
                queue.add(item);
                return queue.size();
            }
            catch (IllegalStateException e2) {
                hsyco.errorLog("Audio Server error: the playback queue is full - entry has been discarded");
            }
        }
        return -1;
    }

    @Override
    public void run() {
        hsyco.messageLog("Audio Server started");
        try {
            if (!hsyco.TMPDIR.isDirectory()) {
                hsyco.TMPDIR.mkdir();
                hsyco.TMPDIR.setWritable(true, false);
            }
            this.TtsWavFile = new File(hsyco.TMPDIR, "tts.wav").getPath();
            File[] fa = hsyco.TMPDIR.listFiles();
            int i2 = 0;
            while (i2 < fa.length) {
                if (fa[i2].isFile() && fa[i2].getName().endsWith(".wav")) {
                    fa[i2].delete();
                }
                ++i2;
            }
            while (true) {
                this.heartbeat = System.currentTimeMillis();
                AudioItem item = queue.poll(60L, TimeUnit.SECONDS);
                if (item != null) {
                    if (item.where.equals("speaker")) {
                        switch (item.mode) {
                            case 0: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing file [" + item.file.getName() + "] on " + item.where);
                                }
                                this.playFile(item.file);
                                break;
                            }
                            case 1: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing text [" + item.text + "] on " + item.where + " using " + (item.voice == null ? "default voice" : item.voice));
                                }
                                this.playVoice(item.where, item.voice, item.text);
                            }
                        }
                    } else if (item.where.startsWith("web")) {
                        switch (item.mode) {
                            case 0: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing file [" + item.file.getName() + "] on " + item.where);
                                }
                                this.playWebFile(item.where, item.file);
                                break;
                            }
                            case 1: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing text [" + item.text + "] on " + item.where + " using " + (item.voice == null ? "default voice" : item.voice));
                                }
                                this.playWebVoice(item.where, item.voice, item.text);
                            }
                        }
                    } else if (item.where.startsWith("io@")) {
                        switch (item.mode) {
                            case 0: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing file [" + item.file.getName() + "] on " + item.where);
                                }
                                this.playIOFile(item.where, item.file);
                                break;
                            }
                            case 1: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing text [" + item.text + "] on " + item.where + " using " + (item.voice == null ? "default voice" : item.voice));
                                }
                                this.playIOVoice(item.where, item.voice, item.text);
                            }
                        }
                    } else if (item.where.startsWith("snom@")) {
                        switch (item.mode) {
                            case 0: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing file [" + item.file.getName() + "] on " + item.where);
                                }
                                this.multicastFile(item.where, item.file);
                                break;
                            }
                            case 1: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing text [" + item.text + "] on " + item.where + " using " + (item.voice == null ? "default voice" : item.voice));
                                }
                                this.multicastVoice(item.where, item.voice, item.text);
                            }
                        }
                    } else if (item.where.startsWith("axis@")) {
                        switch (item.mode) {
                            case 0: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing file [" + item.file.getName() + "] on " + item.where);
                                }
                                this.axisfile(item.where, item.file);
                                break;
                            }
                            case 1: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing text [" + item.text + "] on " + item.where + " using " + (item.voice == null ? "default voice" : item.voice));
                                }
                                this.axisVoice(item.where, item.voice, item.text);
                            }
                        }
                    } else if (item.where.startsWith("rovio@")) {
                        switch (item.mode) {
                            case 0: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing file [" + item.file.getName() + "] on " + item.where);
                                }
                                this.roviofile(item.where, item.file);
                                break;
                            }
                            case 1: {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("Audio Server: playing text [" + item.text + "] on " + item.where + " using " + (item.voice == null ? "default voice" : item.voice));
                                }
                                this.rovioVoice(item.where, item.voice, item.text);
                            }
                        }
                    }
                }
                if (webQueue == null) continue;
                boolean deleted = false;
                int i3 = webQueue.size() - 1;
                while (i3 >= 0) {
                    String element = webQueue.elementAt(i3);
                    String[] sa = element.split("@");
                    File f2 = new File(hsyco.TMPDIR, "__webaudio_" + sa[1] + ".wav");
                    if (f2.exists() && f2.lastModified() < this.heartbeat - 600000L) {
                        f2.delete();
                        webQueue.remove(i3);
                        deleted = true;
                    }
                    --i3;
                }
                if (!deleted) continue;
                SystemState.AudioServerWebQueueSet(webQueue);
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Exception in Audio Server main loop [" + e2 + "]");
            return;
        }
    }

    private void playWebFile(String where, File f2) {
        long fileid = this.random();
        long now = System.currentTimeMillis();
        try {
            if (f2.canRead()) {
                this.fileCopy(f2.getPath(), new File(hsyco.TMPDIR, "__webaudio_" + fileid + ".wav").getPath());
                webQueue.add(where.startsWith("web@") ? String.valueOf(now) + "@" + fileid + where.substring(3) : String.valueOf(now) + "@" + fileid);
                SystemState.AudioServerWebQueueSet(webQueue);
            } else {
                hsyco.errorLog("Audio Server error: not found [" + f2.getName() + "] on " + where);
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error playing file [" + f2.getName() + "] on " + where);
        }
    }

    private void playWebVoice(String where, String voice, String text) {
        long fileid = this.random();
        long now = System.currentTimeMillis();
        try {
            File tf = new File(hsyco.TMPDIR, "__webaudio_" + fileid + ".wav");
            this.tts(voice, text, tf.getPath(), 1);
            if (tf.canRead()) {
                webQueue.add(where.startsWith("web@") ? String.valueOf(now) + "@" + fileid + where.substring(3) : String.valueOf(now) + "@" + fileid);
                SystemState.AudioServerWebQueueSet(webQueue);
            } else {
                hsyco.errorLog("Audio Server error: error playing voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error playing voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
        }
    }

    private void playIOFile(String where, File f2) {
        long random = this.random();
        try {
            if (f2.canRead()) {
                this.fileCopy(f2.getPath(), new File(hsyco.TMPDIR, "__webaudio_" + random + ".wav").getPath());
                SystemState.ioSet(String.valueOf(where.substring(3)) + ".play.pathname", "/x/getaudioforio/" + random + "/file.wav");
            } else {
                hsyco.errorLog("Audio Server error: not found [" + f2.getName() + "] on " + where);
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error playing file [" + f2.getName() + "] on " + where);
        }
    }

    private void playIOVoice(String where, String voice, String text) {
        long random = this.random();
        try {
            File tf = new File(hsyco.TMPDIR, "__webaudio_" + random + ".wav");
            this.tts(voice, text, tf.getPath(), 1);
            if (tf.canRead()) {
                SystemState.ioSet(String.valueOf(where.substring(3)) + ".play.pathname", "/x/getaudioforio/" + random + "/file.wav");
            } else {
                hsyco.errorLog("Audio Server error: error playing voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error playing voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
        }
    }

    private void playVoice(String where, String voice, String text) {
        try {
            this.tts(voice, text, null, -1);
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error playing voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
        }
    }

    private void playFile(File f2) {
        Vector<String> cmd = new Vector<String>();
        try {
            switch (hsyco.OS) {
                case 1: {
                    cmd.add("play");
                    cmd.add("-q");
                    if (Configuration.AudioServerVolume != 0) {
                        cmd.add("-v");
                        cmd.add(Float.toString((float)Configuration.AudioServerVolume / 100.0f));
                    }
                    cmd.add(f2.getCanonicalPath());
                    if (Configuration.AudioServerSpeed == 0) break;
                    cmd.add("speed");
                    cmd.add(Float.toString((float)Configuration.AudioServerSpeed / 100.0f));
                    break;
                }
                case 2: {
                    cmd.add("afplay");
                    cmd.add(f2.getCanonicalPath());
                    if (Configuration.AudioServerVolume != 0) {
                        cmd.add("-v");
                        cmd.add(Integer.toString(Configuration.AudioServerVolume));
                    }
                    if (Configuration.AudioServerSpeed == 0) break;
                    cmd.add("-r");
                    cmd.add(Integer.toString(Configuration.AudioServerSpeed));
                }
            }
            String[] st = new String[cmd.size()];
            this.exec(cmd.toArray(st));
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error playing file [" + f2.getName() + "] on speaker");
        }
    }

    private void multicastFile(String where, File f2) {
        try {
            int s = where.indexOf(58);
            int port = Integer.parseInt(where.substring(s + 1));
            this.RTPExecutor(where.substring(5, s), port, f2.getPath());
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error multicasting file [" + f2.getName() + "] on " + where);
        }
    }

    private void multicastVoice(String where, String voice, String text) {
        try {
            this.tts(voice, text, this.TtsWavFile, 0);
            int s = where.indexOf(58);
            int port = Integer.parseInt(where.substring(s + 1));
            this.RTPExecutor(where.substring(5, s), port, this.TtsWavFile);
            new File(this.TtsWavFile).delete();
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error multicasting voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void axisfile(String where, File f) {
        out = null;
        addr = null;
        s = null;
        try {
            block29: {
                block30: {
                    name = where.substring(5);
                    cam = Configuration.getCameraIndex(name);
                    if (cam == -1) break block29;
                    cu = Configuration.CamerasURL.elementAt(cam);
                    if (cu.getPath().indexOf("axis") <= 0) break block30;
                    user = Configuration.CamerasUser.elementAt(cam);
                    password = Configuration.CamerasPassword.elementAt(cam);
                    addr = new InetSocketAddress(cu.getHost(), cu.getPort() == -1 ? 80 : cu.getPort());
                    ** GOTO lbl33
                }
                return;
            }
            try {
                io = Configuration.ioServers.indexOf(name);
                if (io != -1 && Configuration.ioServersType.elementAt(io) == 27) {
                    user = Configuration.ioServersUser.elementAt(io);
                    password = Configuration.ioServersPassword.elementAt(io);
                    addr = Configuration.ioServersTCPAddress.elementAt(io);
                } else {
                    sa = name.split(":");
                    if (sa.length == 3) {
                        name = sa[0];
                        user = sa[1];
                        password = sa[2];
                    } else {
                        user = null;
                        password = null;
                    }
                    addr = new InetSocketAddress(name, 80);
                }
lbl33:
                // 3 sources

                rf = new RandomAccessFile(f, "r");
                b = new byte[(int)f.length()];
                rf.readFully(b);
                rf.close();
                s = new Socket();
                s.connect(addr, 6000);
                out = s.getOutputStream();
                out.write("POST /axis-cgi/audio/transmit.cgi HTTP/1.0\r\n".getBytes());
                if (user != null && password != null) {
                    out.write(("Authorization: Basic " + util.encodeBase64String(String.valueOf(user) + ":" + password) + "\r\n").getBytes());
                }
                out.write("Content-Type: audio/basic\r\n".getBytes());
                out.write(("Content-Length: " + b.length + "\r\n").getBytes());
                out.write("Connection: Keep-Alive\r\n".getBytes());
                out.write("Cache-Control: no-cache\r\n\r\n".getBytes());
                out.flush();
                i = 0;
                while (i < b.length) {
                    len = i + 512 < b.length ? 512 : b.length - i;
                    out.write(b, i, len);
                    out.flush();
                    i += len;
                }
            }
            catch (Exception e) {
                hsyco.errorLog("Audio Server exception [ " + e + "]: error posting file [" + f.getName() + "] on " + where);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception var15_13) {}
            try {
                s.close();
            }
            catch (Exception var15_14) {}
        }
    }

    private void axisVoice(String where, String voice, String text) {
        File f2 = new File(this.TtsWavFile);
        try {
            this.tts(voice, text, this.TtsWavFile, 3);
            this.axisfile(where, f2);
            f2.delete();
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error posting voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
        }
    }

    private void roviofile(String where, File f2) {
        OutputStream out = null;
        InetSocketAddress addr = null;
        Socket s = null;
        try {
            URL cu;
            String name = where.substring(6);
            int cam = Configuration.getCameraIndex(name);
            if (cam != -1) {
                cu = Configuration.CamerasURL.elementAt(cam);
                if (cu.getPath().indexOf("GetData") <= 0) {
                    return;
                }
            } else {
                return;
            }
            String user2 = Configuration.CamerasUser.elementAt(cam);
            String password = Configuration.CamerasPassword.elementAt(cam);
            addr = new InetSocketAddress(cu.getHost(), cu.getPort() == -1 ? 80 : cu.getPort());
            try {
                RandomAccessFile rf = new RandomAccessFile(f2, "r");
                byte[] b2 = new byte[(int)f2.length()];
                rf.readFully(b2);
                rf.close();
                s = new Socket();
                s.connect(addr, 6000);
                out = s.getOutputStream();
                out.write("POST /GetAudio.cgi HTTP/1.0\r\n".getBytes());
                if (user2 != null && password != null) {
                    out.write(("Authorization: Basic " + util.encodeBase64String(String.valueOf(user2) + ":" + password) + "\r\n").getBytes());
                }
                out.write("Content-Type: audio/x-wav\r\n".getBytes());
                out.write(("Content-Length: " + b2.length + "\r\n\r\n").getBytes());
                int i2 = 0;
                while (i2 < b2.length) {
                    int len = i2 + 64 < b2.length ? 64 : b2.length - i2;
                    out.write(b2, i2, len);
                    out.flush();
                    i2 += len;
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("Audio Server exception [ " + e2 + "]: error posting file [" + f2.getName() + "] on " + where);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
    }

    private void rovioVoice(String where, String voice, String text) {
        File f2 = new File(this.TtsWavFile);
        try {
            this.tts(voice, text, this.TtsWavFile, 2);
            this.roviofile(where, f2);
            f2.delete();
        }
        catch (Exception e2) {
            hsyco.errorLog("Audio Server exception [ " + e2 + "]: error posting voice [" + text + "] on " + where + " using " + (voice == null ? "default voice" : voice));
        }
    }

    synchronized void tts(String voice, String text, String filename, int target) throws Exception {
        Vector<String> cmd = new Vector<String>();
        block0 : switch (hsyco.OS) {
            case 1: {
                if (Configuration.AudioServerTTS == 2) {
                    cmd.add("acapela");
                    if (voice != null) {
                        cmd.add(voice);
                    }
                    if (filename != null) {
                        switch (target) {
                            case 2: 
                            case 4: {
                                cmd.add(String.valueOf(filename) + ".wav");
                                String[] st = new String[cmd.size()];
                                this.exec(cmd.toArray(st), text);
                                String[] sox = new String[]{"sox", String.valueOf(filename) + ".wav", "-r", "8k", "--endian", "little", "-b", "16", "-e", "signed-integer", filename};
                                this.exec(sox);
                                new File(String.valueOf(filename) + ".wav").delete();
                                break block0;
                            }
                        }
                        cmd.add(filename);
                        String[] st = new String[cmd.size()];
                        this.exec(cmd.toArray(st), text);
                        break;
                    }
                    cmd.add(this.TtsWavFile);
                    String[] st = new String[cmd.size()];
                    this.exec(cmd.toArray(st), text);
                    this.playFile(new File(this.TtsWavFile));
                    break;
                }
                cmd.add("espeak");
                cmd.add("--stdin");
                if (voice != null) {
                    cmd.add("-v");
                    cmd.add(voice);
                }
                if (Configuration.AudioServerSpeed != 0) {
                    cmd.add("-s");
                    cmd.add(Integer.toString(160 * Configuration.AudioServerSpeed / 100));
                }
                if (Configuration.AudioServerVolume != 0) {
                    cmd.add("-a");
                    cmd.add(Integer.toString(Configuration.AudioServerVolume));
                }
                if (filename != null) {
                    switch (target) {
                        case 2: 
                        case 4: {
                            cmd.add("-w");
                            cmd.add(String.valueOf(filename) + ".wav");
                            String[] st = new String[cmd.size()];
                            this.exec(cmd.toArray(st), text);
                            String[] sox1 = new String[]{"sox", String.valueOf(filename) + ".wav", "-r", "8k", "--endian", "little", "-b", "16", "-e", "signed-integer", filename};
                            this.exec(sox1);
                            new File(String.valueOf(filename) + ".wav").delete();
                            break block0;
                        }
                        case 3: {
                            cmd.add("-w");
                            cmd.add(String.valueOf(filename) + ".wav");
                            String[] st = new String[cmd.size()];
                            this.exec(cmd.toArray(st), text);
                            String[] sox2 = new String[]{"sox", String.valueOf(filename) + ".wav", "-r", "8k", "--endian", "little", "-e", "mu-law", filename};
                            this.exec(sox2);
                            new File(String.valueOf(filename) + ".wav").delete();
                            break block0;
                        }
                    }
                    cmd.add("-w");
                    cmd.add(filename);
                    String[] st = new String[cmd.size()];
                    this.exec(cmd.toArray(st), text);
                    break;
                }
                cmd.add("--stdout");
                String[] st = new String[cmd.size()];
                String[] aplay = new String[]{"aplay", "-q"};
                this.exec(cmd.toArray(st), aplay, text);
                break;
            }
            case 2: {
                if (voice != null) {
                    int i2 = voice.indexOf(":");
                    if (i2 > 0) {
                        cmd.add("sudo");
                        cmd.add("-u");
                        cmd.add(voice.substring(0, i2));
                        cmd.add("say");
                        cmd.add("-v");
                        cmd.add(voice.substring(i2 + 1));
                    } else {
                        cmd.add("say");
                        cmd.add("-v");
                        cmd.add(voice);
                    }
                } else {
                    cmd.add("say");
                }
                if (Configuration.AudioServerSpeed != 0) {
                    cmd.add("-r");
                    cmd.add(Integer.toString(Configuration.AudioServerSpeed));
                }
                if (Configuration.AudioServerQuality != 0) {
                    cmd.add("--quality=" + Configuration.AudioServerQuality);
                }
                if (filename != null) {
                    cmd.add("-o");
                    cmd.add(filename);
                    switch (target) {
                        case 1: 
                        case 2: 
                        case 4: {
                            cmd.add("--data-format=LEI16@8000");
                            break;
                        }
                        case 3: {
                            cmd.add("--data-format=ulaw@8000");
                            break;
                        }
                        default: {
                            cmd.add("--data-format=ulaw@8000");
                        }
                    }
                }
                String[] st = new String[cmd.size()];
                this.exec(cmd.toArray(st), text);
            }
        }
    }

    private void RTPExecutor(String address, int port, String filename) {
        String[] cmd = new String[]{"java", "-Djava.library.path=.", "-cp", new File(".hsyco.jar").exists() ? ".hsyco.jar:." : "hsyco.jar:.", "com.hsyco.hsyco", "exec", "rtp"};
        try {
            this.RTPExecute(String.valueOf(address) + " " + port + " " + filename);
        }
        catch (Exception e2) {
            try {
                this.load(cmd);
                this.RTPExecute(String.valueOf(address) + " " + port + " " + filename);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.load(cmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fileCopy(String source, String dest) throws Exception {
        FileInputStream fin = new FileInputStream(source);
        FileOutputStream fout = new FileOutputStream(dest);
        FileChannel in = fin.getChannel();
        FileChannel out = fout.getChannel();
        in.transferTo(0L, in.size(), out);
        fin.close();
        fout.close();
    }

    private void exec(String[] cmd) throws Exception {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmd);
        BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while (brout.readLine() != null) {
        }
        while (brerr.readLine() != null) {
        }
        proc.destroy();
        brerr.close();
        brout.close();
    }

    private void exec(String[] cmd, String input) throws Exception {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(cmd);
        BufferedWriter brin = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream(), "UTF-8"));
        BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        brin.write(input);
        brin.flush();
        brin.close();
        while (brout.readLine() != null) {
        }
        while (brerr.readLine() != null) {
        }
        proc.destroy();
        brerr.close();
        brout.close();
    }

    private void exec(String[] cmd1, String[] cmd2, String input) throws Exception {
        int b2;
        Runtime rt = Runtime.getRuntime();
        Process proc1 = rt.exec(cmd1);
        BufferedWriter brin1 = new BufferedWriter(new OutputStreamWriter(proc1.getOutputStream(), "UTF-8"));
        BufferedReader brerr1 = new BufferedReader(new InputStreamReader(proc1.getErrorStream()));
        InputStream out1 = proc1.getInputStream();
        Process proc2 = rt.exec(cmd2);
        OutputStream in2 = proc2.getOutputStream();
        BufferedReader brerr2 = new BufferedReader(new InputStreamReader(proc2.getErrorStream()));
        BufferedReader brout2 = new BufferedReader(new InputStreamReader(proc2.getInputStream()));
        brin1.write(input);
        brin1.flush();
        brin1.close();
        while ((b2 = out1.read()) != -1) {
            in2.write(b2);
        }
        while (brerr1.readLine() != null) {
        }
        proc1.destroy();
        brerr1.close();
        out1.close();
        in2.flush();
        in2.close();
        while (brout2.readLine() != null) {
        }
        while (brerr2.readLine() != null) {
        }
        proc2.destroy();
        brerr2.close();
        brout2.close();
    }

    private void load(String[] cmd) throws Exception {
        try {
            this.rtpProcess.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Runtime rt = Runtime.getRuntime();
        this.rtpProcess = rt.exec(cmd);
    }

    private void RTPExecute(String input) throws Exception {
        BufferedWriter brin = new BufferedWriter(new OutputStreamWriter(this.rtpProcess.getOutputStream()));
        BufferedReader brerr = new BufferedReader(new InputStreamReader(this.rtpProcess.getErrorStream()));
        BufferedReader brout = new BufferedReader(new InputStreamReader(this.rtpProcess.getInputStream()));
        brin.write(input);
        brin.newLine();
        brin.flush();
        while (brout.readLine() != null) {
        }
        while (brerr.readLine() != null) {
        }
        this.rtpProcess.destroy();
        brerr.close();
        brout.close();
        brin.close();
    }

    private long random() {
        return Math.abs(new SecureRandom().nextLong());
    }
}

