/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OAuth2Utils {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String METADATA_SERVER_URL = "http://metadata.google.internal";

    static <T extends Throwable> T exceptionWithCause(T exception, Throwable cause) {
        exception.initCause(cause);
        return exception;
    }

    static boolean headersContainValue(HttpHeaders headers, String headerName, String value) {
        Object values = headers.get(headerName);
        if (values instanceof Collection) {
            Collection valuesList = (Collection)values;
            for (Object headerValue : valuesList) {
                if (!(headerValue instanceof String) || !((String)headerValue).equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean runningOnComputeEngine(HttpTransport transport) {
        try {
            GenericUrl tokenUrl = new GenericUrl(METADATA_SERVER_URL);
            HttpRequest request = transport.createRequestFactory().buildGetRequest(tokenUrl);
            HttpResponse response = request.execute();
            HttpHeaders headers = response.getHeaders();
            if (OAuth2Utils.headersContainValue(headers, "Metadata-Flavor", "Google")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private OAuth2Utils() {
    }
}

