/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.transport.ClientKexManager;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.TransportConnection;
import ch.ethz.ssh2.transport.TransportManager;
import ch.ethz.ssh2.util.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class ClientTransportManager
extends TransportManager {
    protected final Socket sock = new Socket();

    public void setTcpNoDelay(boolean state) throws IOException {
        this.sock.setTcpNoDelay(state);
    }

    public void setSoTimeout(int timeout) throws IOException {
        this.sock.setSoTimeout(timeout);
    }

    public void connect(String hostname, int port, String softwareversion, CryptoWishList cwl, ServerHostKeyVerifier verifier, DHGexParameters dhgex, int connectTimeout, SecureRandom rnd) throws IOException {
        this.connect(hostname, port, connectTimeout);
        ClientServerHello csh = ClientServerHello.clientHello(softwareversion, this.sock.getInputStream(), this.sock.getOutputStream());
        TransportConnection tc = new TransportConnection(this.sock.getInputStream(), this.sock.getOutputStream(), rnd);
        ClientKexManager km = new ClientKexManager(this, csh, cwl, hostname, port, verifier, rnd);
        super.init(tc, km);
        km.initiateKEX(cwl, dhgex, null, null);
        this.startReceiver();
    }

    @Override
    public void close(Throwable cause, boolean useDisconnectPacket) {
        this.close(this.sock, cause, useDisconnectPacket);
    }

    protected void connect(String hostname, int port, int connectTimeout) throws IOException {
        InetAddress addr = ClientTransportManager.createInetAddress(hostname);
        this.sock.connect(new InetSocketAddress(addr, port), connectTimeout);
    }

    protected static InetAddress createInetAddress(String host) throws UnknownHostException {
        InetAddress addr = ClientTransportManager.parseIPv4Address(host);
        if (addr != null) {
            return addr;
        }
        return InetAddress.getByName(host);
    }

    private static InetAddress parseIPv4Address(String host) throws UnknownHostException {
        if (host == null) {
            return null;
        }
        String[] quad = Tokenizer.parseTokens(host, '.');
        if (quad == null || quad.length != 4) {
            return null;
        }
        byte[] addr = new byte[4];
        int i2 = 0;
        while (i2 < 4) {
            int part = 0;
            if (quad[i2].length() == 0 || quad[i2].length() > 3) {
                return null;
            }
            int k2 = 0;
            while (k2 < quad[i2].length()) {
                char c2 = quad[i2].charAt(k2);
                if (c2 < '0' || c2 > '9') {
                    return null;
                }
                part = part * 10 + (c2 - 48);
                ++k2;
            }
            if (part > 255) {
                return null;
            }
            addr[i2] = (byte)part;
            ++i2;
        }
        return InetAddress.getByAddress(host, addr);
    }
}

