/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.digest;

import ch.ethz.ssh2.crypto.digest.Digest;

public final class MD5
implements Digest {
    private int state0;
    private int state1;
    private int state2;
    private int state3;
    private long count;
    private final byte[] block = new byte[64];
    private final int[] x = new int[16];
    private static final byte[] padding;

    static {
        byte[] byArray = new byte[64];
        byArray[0] = -128;
        padding = byArray;
    }

    public MD5() {
        this.reset();
    }

    private static int FF(int a2, int b2, int c2, int d2, int x, int s, int ac) {
        return ((a2 += (b2 & c2 | ~b2 & d2) + x + ac) << s | a2 >>> 32 - s) + b2;
    }

    private static int GG(int a2, int b2, int c2, int d2, int x, int s, int ac) {
        return ((a2 += (b2 & d2 | c2 & ~d2) + x + ac) << s | a2 >>> 32 - s) + b2;
    }

    private static int HH(int a2, int b2, int c2, int d2, int x, int s, int ac) {
        return ((a2 += (b2 ^ c2 ^ d2) + x + ac) << s | a2 >>> 32 - s) + b2;
    }

    private static int II(int a2, int b2, int c2, int d2, int x, int s, int ac) {
        return ((a2 += (c2 ^ (b2 | ~d2)) + x + ac) << s | a2 >>> 32 - s) + b2;
    }

    private static void encode(byte[] dst, int dstoff, int word) {
        dst[dstoff] = (byte)word;
        dst[dstoff + 1] = (byte)(word >> 8);
        dst[dstoff + 2] = (byte)(word >> 16);
        dst[dstoff + 3] = (byte)(word >> 24);
    }

    private void transform(byte[] src, int pos) {
        int a2 = this.state0;
        int b2 = this.state1;
        int c2 = this.state2;
        int d2 = this.state3;
        int i2 = 0;
        while (i2 < 16) {
            this.x[i2] = src[pos] & 0xFF | (src[pos + 1] & 0xFF) << 8 | (src[pos + 2] & 0xFF) << 16 | (src[pos + 3] & 0xFF) << 24;
            ++i2;
            pos += 4;
        }
        a2 = MD5.FF(a2, b2, c2, d2, this.x[0], 7, -680876936);
        d2 = MD5.FF(d2, a2, b2, c2, this.x[1], 12, -389564586);
        c2 = MD5.FF(c2, d2, a2, b2, this.x[2], 17, 606105819);
        b2 = MD5.FF(b2, c2, d2, a2, this.x[3], 22, -1044525330);
        a2 = MD5.FF(a2, b2, c2, d2, this.x[4], 7, -176418897);
        d2 = MD5.FF(d2, a2, b2, c2, this.x[5], 12, 1200080426);
        c2 = MD5.FF(c2, d2, a2, b2, this.x[6], 17, -1473231341);
        b2 = MD5.FF(b2, c2, d2, a2, this.x[7], 22, -45705983);
        a2 = MD5.FF(a2, b2, c2, d2, this.x[8], 7, 1770035416);
        d2 = MD5.FF(d2, a2, b2, c2, this.x[9], 12, -1958414417);
        c2 = MD5.FF(c2, d2, a2, b2, this.x[10], 17, -42063);
        b2 = MD5.FF(b2, c2, d2, a2, this.x[11], 22, -1990404162);
        a2 = MD5.FF(a2, b2, c2, d2, this.x[12], 7, 1804603682);
        d2 = MD5.FF(d2, a2, b2, c2, this.x[13], 12, -40341101);
        c2 = MD5.FF(c2, d2, a2, b2, this.x[14], 17, -1502002290);
        b2 = MD5.FF(b2, c2, d2, a2, this.x[15], 22, 1236535329);
        a2 = MD5.GG(a2, b2, c2, d2, this.x[1], 5, -165796510);
        d2 = MD5.GG(d2, a2, b2, c2, this.x[6], 9, -1069501632);
        c2 = MD5.GG(c2, d2, a2, b2, this.x[11], 14, 643717713);
        b2 = MD5.GG(b2, c2, d2, a2, this.x[0], 20, -373897302);
        a2 = MD5.GG(a2, b2, c2, d2, this.x[5], 5, -701558691);
        d2 = MD5.GG(d2, a2, b2, c2, this.x[10], 9, 38016083);
        c2 = MD5.GG(c2, d2, a2, b2, this.x[15], 14, -660478335);
        b2 = MD5.GG(b2, c2, d2, a2, this.x[4], 20, -405537848);
        a2 = MD5.GG(a2, b2, c2, d2, this.x[9], 5, 568446438);
        d2 = MD5.GG(d2, a2, b2, c2, this.x[14], 9, -1019803690);
        c2 = MD5.GG(c2, d2, a2, b2, this.x[3], 14, -187363961);
        b2 = MD5.GG(b2, c2, d2, a2, this.x[8], 20, 1163531501);
        a2 = MD5.GG(a2, b2, c2, d2, this.x[13], 5, -1444681467);
        d2 = MD5.GG(d2, a2, b2, c2, this.x[2], 9, -51403784);
        c2 = MD5.GG(c2, d2, a2, b2, this.x[7], 14, 1735328473);
        b2 = MD5.GG(b2, c2, d2, a2, this.x[12], 20, -1926607734);
        a2 = MD5.HH(a2, b2, c2, d2, this.x[5], 4, -378558);
        d2 = MD5.HH(d2, a2, b2, c2, this.x[8], 11, -2022574463);
        c2 = MD5.HH(c2, d2, a2, b2, this.x[11], 16, 1839030562);
        b2 = MD5.HH(b2, c2, d2, a2, this.x[14], 23, -35309556);
        a2 = MD5.HH(a2, b2, c2, d2, this.x[1], 4, -1530992060);
        d2 = MD5.HH(d2, a2, b2, c2, this.x[4], 11, 1272893353);
        c2 = MD5.HH(c2, d2, a2, b2, this.x[7], 16, -155497632);
        b2 = MD5.HH(b2, c2, d2, a2, this.x[10], 23, -1094730640);
        a2 = MD5.HH(a2, b2, c2, d2, this.x[13], 4, 681279174);
        d2 = MD5.HH(d2, a2, b2, c2, this.x[0], 11, -358537222);
        c2 = MD5.HH(c2, d2, a2, b2, this.x[3], 16, -722521979);
        b2 = MD5.HH(b2, c2, d2, a2, this.x[6], 23, 76029189);
        a2 = MD5.HH(a2, b2, c2, d2, this.x[9], 4, -640364487);
        d2 = MD5.HH(d2, a2, b2, c2, this.x[12], 11, -421815835);
        c2 = MD5.HH(c2, d2, a2, b2, this.x[15], 16, 530742520);
        b2 = MD5.HH(b2, c2, d2, a2, this.x[2], 23, -995338651);
        a2 = MD5.II(a2, b2, c2, d2, this.x[0], 6, -198630844);
        d2 = MD5.II(d2, a2, b2, c2, this.x[7], 10, 1126891415);
        c2 = MD5.II(c2, d2, a2, b2, this.x[14], 15, -1416354905);
        b2 = MD5.II(b2, c2, d2, a2, this.x[5], 21, -57434055);
        a2 = MD5.II(a2, b2, c2, d2, this.x[12], 6, 1700485571);
        d2 = MD5.II(d2, a2, b2, c2, this.x[3], 10, -1894986606);
        c2 = MD5.II(c2, d2, a2, b2, this.x[10], 15, -1051523);
        b2 = MD5.II(b2, c2, d2, a2, this.x[1], 21, -2054922799);
        a2 = MD5.II(a2, b2, c2, d2, this.x[8], 6, 1873313359);
        d2 = MD5.II(d2, a2, b2, c2, this.x[15], 10, -30611744);
        c2 = MD5.II(c2, d2, a2, b2, this.x[6], 15, -1560198380);
        b2 = MD5.II(b2, c2, d2, a2, this.x[13], 21, 1309151649);
        a2 = MD5.II(a2, b2, c2, d2, this.x[4], 6, -145523070);
        d2 = MD5.II(d2, a2, b2, c2, this.x[11], 10, -1120210379);
        c2 = MD5.II(c2, d2, a2, b2, this.x[2], 15, 718787259);
        b2 = MD5.II(b2, c2, d2, a2, this.x[9], 21, -343485551);
        this.state0 += a2;
        this.state1 += b2;
        this.state2 += c2;
        this.state3 += d2;
    }

    @Override
    public final void reset() {
        this.count = 0L;
        this.state0 = 1732584193;
        this.state1 = -271733879;
        this.state2 = -1732584194;
        this.state3 = 271733878;
        int i2 = 0;
        while (i2 < 16) {
            this.x[i2] = 0;
            ++i2;
        }
    }

    @Override
    public final void update(byte b2) {
        int space = 64 - (int)(this.count & 0x3FL);
        ++this.count;
        this.block[64 - space] = b2;
        if (space == 1) {
            this.transform(this.block, 0);
        }
    }

    @Override
    public final void update(byte[] buff, int pos, int len) {
        int space = 64 - (int)(this.count & 0x3FL);
        this.count += (long)len;
        while (len > 0) {
            if (len < space) {
                System.arraycopy(buff, pos, this.block, 64 - space, len);
                break;
            }
            if (space == 64) {
                this.transform(buff, pos);
            } else {
                System.arraycopy(buff, pos, this.block, 64 - space, space);
                this.transform(this.block, 0);
            }
            pos += space;
            len -= space;
            space = 64;
        }
    }

    @Override
    public final void update(byte[] b2) {
        this.update(b2, 0, b2.length);
    }

    @Override
    public final void digest(byte[] dst, int pos) {
        byte[] bits = new byte[8];
        MD5.encode(bits, 0, (int)(this.count << 3));
        MD5.encode(bits, 4, (int)(this.count >> 29));
        int idx = (int)this.count & 0x3F;
        int padLen = idx < 56 ? 56 - idx : 120 - idx;
        this.update(padding, 0, padLen);
        this.update(bits, 0, 8);
        MD5.encode(dst, pos, this.state0);
        MD5.encode(dst, pos + 4, this.state1);
        MD5.encode(dst, pos + 8, this.state2);
        MD5.encode(dst, pos + 12, this.state3);
        this.reset();
    }

    @Override
    public final void digest(byte[] dst) {
        this.digest(dst, 0);
    }

    @Override
    public final int getDigestLength() {
        return 16;
    }
}

