/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SCPInputStream
extends BufferedInputStream {
    private Session session;
    private long remaining;

    public SCPInputStream(SCPClient client, Session session) throws IOException {
        super(session.getStdout());
        String line;
        int c2;
        this.session = session;
        BufferedOutputStream os = new BufferedOutputStream(session.getStdin(), 512);
        ((OutputStream)os).write(0);
        ((OutputStream)os).flush();
        do {
            if ((c2 = session.getStdout().read()) < 0) {
                throw new IOException("Remote scp terminated unexpectedly.");
            }
            line = client.receiveLine(session.getStdout());
        } while (c2 == 84);
        if (c2 == 1 || c2 == 2) {
            throw new IOException("Remote SCP error: " + line);
        }
        if (c2 != 67) {
            throw new IOException("Remote SCP error: " + (char)c2 + line);
        }
        SCPClient.LenNamePair lnp = client.parseCLine(line);
        ((OutputStream)os).write(0);
        ((OutputStream)os).flush();
        this.remaining = lnp.length;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int b2 = super.read();
        if (b2 < 0) {
            throw new IOException("Remote scp terminated connection unexpectedly");
        }
        --this.remaining;
        return b2;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int read;
        if (this.remaining <= 0L) {
            return -1;
        }
        int trans = (int)this.remaining;
        if (this.remaining > (long)len) {
            trans = len;
        }
        if ((read = super.read(b2, off, trans)) < 0) {
            throw new IOException("Remote scp terminated connection unexpectedly");
        }
        this.remaining -= (long)read;
        return read;
    }

    @Override
    public void close() throws IOException {
        try {
            this.session.getStdin().write(0);
            this.session.getStdin().flush();
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
        }
    }
}

