/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SCPInputStream;
import ch.ethz.ssh2.SCPOutputStream;
import ch.ethz.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class SCPClient {
    Connection conn;
    String charsetName = null;

    public void setCharset(String charset) throws IOException {
        if (charset == null) {
            this.charsetName = charset;
            return;
        }
        try {
            Charset.forName(charset);
        }
        catch (UnsupportedCharsetException e2) {
            throw new IOException("This charset is not supported", e2);
        }
        this.charsetName = charset;
    }

    public String getCharset() {
        return this.charsetName;
    }

    public SCPClient(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.conn = conn;
    }

    protected void readResponse(InputStream is) throws IOException {
        int c2 = is.read();
        if (c2 == 0) {
            return;
        }
        if (c2 == -1) {
            throw new IOException("Remote scp terminated unexpectedly.");
        }
        if (c2 != 1 && c2 != 2) {
            throw new IOException("Remote scp sent illegal error code.");
        }
        if (c2 == 2) {
            throw new IOException("Remote scp terminated with error.");
        }
        String err = this.receiveLine(is);
        throw new IOException("Remote scp terminated with error (" + err + ").");
    }

    protected String receiveLine(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder(30);
        while (true) {
            if (sb.length() > 8192) {
                throw new IOException("Remote scp sent a too long line");
            }
            int c2 = is.read();
            if (c2 < 0) {
                throw new IOException("Remote scp terminated unexpectedly.");
            }
            if (c2 == 10) break;
            sb.append((char)c2);
        }
        return sb.toString();
    }

    protected LenNamePair parseCLine(String line) throws IOException {
        long len;
        if (line.length() < 8) {
            throw new IOException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (line.charAt(4) != ' ' || line.charAt(5) == ' ') {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        int length_name_sep = line.indexOf(32, 5);
        if (length_name_sep == -1) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        String length_substring = line.substring(5, length_name_sep);
        String name_substring = line.substring(length_name_sep + 1);
        if (length_substring.length() <= 0 || name_substring.length() <= 0) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + length_substring.length() + name_substring.length() != line.length()) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        try {
            len = Long.parseLong(length_substring);
        }
        catch (NumberFormatException e2) {
            throw new IOException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (len < 0L) {
            throw new IOException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        LenNamePair lnp = new LenNamePair();
        lnp.length = len;
        lnp.filename = name_substring;
        return lnp;
    }

    public SCPOutputStream put(String remoteFile, long length, String remoteTargetDirectory, String mode) throws IOException {
        Session sess = null;
        if (remoteFile == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (remoteTargetDirectory == null) {
            remoteTargetDirectory = "";
        }
        if (mode == null) {
            mode = "0600";
        }
        if (mode.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        int i2 = 0;
        while (i2 < mode.length()) {
            if (!Character.isDigit(mode.charAt(i2))) {
                throw new IllegalArgumentException("Invalid mode.");
            }
            ++i2;
        }
        remoteTargetDirectory = remoteTargetDirectory.length() > 0 ? remoteTargetDirectory : ".";
        String cmd = "scp -t -d \"" + remoteTargetDirectory + "\"";
        sess = this.conn.openSession();
        sess.execCommand(cmd, this.charsetName);
        return new SCPOutputStream(this, sess, remoteFile, length, mode);
    }

    public SCPInputStream get(String remoteFile) throws IOException {
        Session sess = null;
        if (remoteFile == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (remoteFile.length() == 0) {
            throw new IllegalArgumentException("Cannot accept empty filename.");
        }
        String cmd = "scp -f";
        cmd = String.valueOf(cmd) + " \"" + remoteFile + "\"";
        sess = this.conn.openSession();
        sess.execCommand(cmd, this.charsetName);
        return new SCPInputStream(this, sess);
    }

    public class LenNamePair {
        public long length;
        String filename;
    }
}

