ace.define('ace/snippets/events',['require','exports','module'], function(require, exports, module) {
var s = {
	// scopes
	events:[],
	actions:[],
	js:[]
};

exports.snippetText = s;


var a = s.events;
a.push({
	title:"DAY",
	subTitle:"Events, System Events",
	docHTML:"<p>A stable condition that is true during day time, as computed based on the latitude and longitude data set in hsyco.ini and the SunriseOffsetMinutes and SunsetOffsetMinutes parameters.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>DAY\n</td>\n<td>stable\n</td>\n<td>triggered at sunrise; remains true until sunset\n</td></tr></tbody></table><p><br>\n<b>Examples:</b>\n</p><pre>DAY : IO k.33 k.34 k.35 = 0\n</pre>",
	content:"DAY"
});
a.push({
	title:"HAACTIVE",
	subTitle:"Events, System Events",
	docHTML:"<p>This event is triggered when HSYCO is a master or slave in a high availability configuration and the server is active.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>HAACTIVE\n</td>\n<td>transient\n</td>\n<td>this HSYCO server is active\n</td></tr></tbody></table><p><br>\n<b>Examples:</b>\n</p><p>Send an email when the slave HSYCO server becomes active:\n</p><pre>HAACTIVE AND $HAMASTER$ = 0 : MAIL email@hsyco.com = hsyco@hsyco.com \"Sent from HSYCO\" \"The slave server is now active\"\n</pre>",
	content:"HAACTIVE"
});
a.push({
	title:"HSYCOSTART",
	subTitle:"Events, System Events",
	docHTML:"<p>This event is triggered only once when HSYCO starts, after the initialization and HTTP server start-up, but before the execution of the different field devices interface threads.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>HSYCOSTART\n</td>\n<td>transient\n</td>\n<td>occurs only once at start-up\n</td></tr></tbody></table><p><br>\n<b>Examples:</b>\n</p><pre>HSYCOSTART : $count = 0\n</pre>",
	content:"HSYCOSTART"
});
a.push({
	title:"INIT",
	subTitle:"Events, System Events",
	docHTML:"<p>This event is triggered when HSYCO reloads any EVENTS file.\n</p><p>Note that, because HSYCO takes a few seconds to reload these files after they are changed, if multiple changes occur very closely in time, a single INIT event may be triggered for a batch of changes.\n</p><p>Reloading occurs when HSYCO starts and every time the file is manually saved, even with no content changes.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>INIT\n</td>\n<td>transient\n</td>\n<td>an EVENTS file has been reloaded\n</td></tr></tbody></table><p><br>\n<b>Examples:</b>\n</p><pre>INIT : $count = 0\n</pre>",
	content:"INIT"
});
a.push({
	title:"NIGHT",
	subTitle:"Events, System Events",
	docHTML:"<p>A stable condition that is true during night time, as computed based on the latitude and longitude data set in hsyco.ini and the SunriseOffsetMinutes and SunsetOffsetMinutes parameters.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>NIGHT\n</td>\n<td>stable\n</td>\n<td>triggered at sunset; remains true until sunrise\n</td></tr></tbody></table><p><br>\n<b>Examples:</b>\n</p><pre>NIGHT: IO k.33 k.34 k.35 = 1\n</pre>",
	content:"NIGHT"
});
a.push({
	title:"POWER",
	subTitle:"Events, System Events",
	docHTML:"<p>Triggered by a change of the current power load level, as set using the powerSet() Java method or JavaScript function, or the POWER action.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>POWER\n</td>\n<td>transient\n</td>\n<td>triggered by any change to the power level\n</td></tr>\n<tr>\n<td>\n<p>POWER > power<br>\nPOWER < power<br>\nPOWER >= power<br>\nPOWER <= power\n</p>\n</td>\n<td>stable\n</td>\n<td>\n<p>occurs when a change in the power level is detected. It is true if the comparison condition is satisfied\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>power - the power in Watt.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>POWER > 2000 : IO k.70 = 0\nPOWER : LOG \"NEW POWER: \" $POWER$\n</pre>",
	content:"POWER"
});
a.push({
	title:"POWER > power",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"POWER > ${2:power}"
});
a.push({
	title:"POWER < power",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"POWER < ${1:power}"
});
a.push({
	title:"POWER >= power",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"POWER >= ${1:power}"
});
a.push({
	title:"POWER ",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"POWER "
});
a.push({
	title:"PROGRAMTIMER name",
	subTitle:"Events, System Events",
	docHTML:"<p>Triggered by a program timer.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>PROGRAMTIMER name\n</td>\n<td>transient\n</td>\n<td>triggered after the program timer’s set time-interval\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - program timer id.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>Turns on light k.33 approximately 10 seconds after the click on a user button:\n</p><pre>USER timer : PROGRAMTIMER test = SET 10\nPROGRAMTIMER test : IO k.33 = 1\n</pre>",
	content:"PROGRAMTIMER ${1:name}"
});
a.push({
	title:"SUNAZIMUTH",
	subTitle:"Events, System Events",
	docHTML:"<p>This event is triggered every time there is a change in the integer part of Sun’s azimuth angle (the angle between North and the Sun’s projection on the horizon), as computed based on the latitude and longitude data set in hsyco.ini and the SunriseOffsetMinutes and SunsetOffsetMinutes parameters.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>SUNAZIMUTH\n</td>\n<td>transient\n</td>\n<td>triggered when the Sun's azimuth changes\n</td></tr>\n<tr>\n<td>\n<p>SUNAZIMUTH = value<br>\nSUNAZIMUTH > value<br>\nSUNAZIMUTH < value<br>\nSUNAZIMUTH >= value<br>\nSUNAZIMUTH <= value\n</p>\n</td>\n<td>stable\n</td>\n<td>true if the condition matches. Angles are compared ignoring decimals\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>value - angle in decimal degrees, as a positive integer number, between 0 and 359.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>SUNAZIMUTH > 180 AND SUNAZIMUTH < 220 : IO k.54 = 0\n</pre>",
	content:"SUNAZIMUTH"
});
a.push({
	title:"SUNAZIMUTH = value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNAZIMUTH = ${2:value}"
});
a.push({
	title:"SUNAZIMUTH > value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNAZIMUTH > ${1:value}"
});
a.push({
	title:"SUNAZIMUTH < value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNAZIMUTH < ${1:value}"
});
a.push({
	title:"SUNAZIMUTH >= value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNAZIMUTH >= ${1:value}"
});
a.push({
	title:"SUNAZIMUTH ",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNAZIMUTH "
});
a.push({
	title:"SUNELEVATION",
	subTitle:"Events, System Events",
	docHTML:"<p>This event is triggered every time there is a change in the integer part of Sun’s elevation angle (the angle between the horizon and the Sun), as computed based on the latitude and longitude data set in hsyco.ini and the SunriseOffsetMinutes and SunsetOffsetMinutes parameters.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>SUNELEVATION\n</td>\n<td>transient\n</td>\n<td>triggered when the Sun's elevation changes\n</td></tr>\n<tr>\n<td>\n<p>SUNELEVATION = value<br>\nSUNELEVATION > value<br>\nSUNELEVATION < value<br>\nSUNELEVATION >= value<br>\nSUNELEVATION <= value\n</p>\n</td>\n<td>stable\n</td>\n<td>true if the condition matches. Angles are compared ignoring decimals\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>value - angle in decimal degrees, as an integer number, between -90 and 90.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>SUNELEVATION > 45 : IO k.55 = 0\n</pre>",
	content:"SUNELEVATION"
});
a.push({
	title:"SUNELEVATION = value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNELEVATION = ${2:value}"
});
a.push({
	title:"SUNELEVATION > value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNELEVATION > ${1:value}"
});
a.push({
	title:"SUNELEVATION < value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNELEVATION < ${1:value}"
});
a.push({
	title:"SUNELEVATION >= value",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNELEVATION >= ${1:value}"
});
a.push({
	title:"SUNELEVATION ",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"SUNELEVATION "
});
a.push({
	title:"TIME",
	subTitle:"Events, System Events",
	docHTML:"<p>The current time event.\n</p><p>In its simple form, it is just a transient event that is triggered every minute.\n</p><p>It can also be used as a stable condition, comparing the current time with a constant time in the HHMM format.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>TIME\n</td>\n<td>transient\n</td>\n<td>triggered at the beginning of each minute\n</td></tr>\n<tr>\n<td>\n<p>TIME = hhmm<br>\nTIME > hhmm<br>\nTIME < hhmm<br>\nTIME >= hhmm<br>\nTIME <= hhmm\n</p>\n</td>\n<td>stable\n</td>\n<td>compares the current time with the specified time in the HHMM format\n</td></tr></tbody></table><p><br>\n<b>Examples:</b>\n</p><pre>TIME : CAMERAREC entrance = 60\nTIME = 0930 : IO k.33 = 0\n</pre>",
	content:"TIME"
});
a.push({
	title:"TIME = hhmm",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"TIME = ${2:hhmm}"
});
a.push({
	title:"TIME > hhmm",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"TIME > ${1:hhmm}"
});
a.push({
	title:"TIME < hhmm",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"TIME < ${1:hhmm}"
});
a.push({
	title:"TIME >= hhmm",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"TIME >= ${1:hhmm}"
});
a.push({
	title:"TIME ",
	subTitle:"Events, System Events",
	docHTML:a.last().docHTML,
	content:"TIME "
});
a.push({
	title:"CAMERA name",
	subTitle:"Events, Cameras",
	docHTML:"<p>This event is true while HSYCO is recording video from a specific camera.\n</p><p>Recording could start automatically when a camera notifies a recording request with the recording HTTP API call:\n</p><pre>http://192.168.0.50/x/camerarec?camera=name\nhttp://192.168.0.50/x/camerarec?camera=name&zone=id\n</pre><p><br>\nRecording can also be triggered by the CameraRecTrigger() Java call or the CAMERAREC or CAMERARECFULL actions in EVENTS.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>CAMERA name\n</td>\n<td>stable\n</td>\n<td>the camera is recording\n</td></tr>\n<tr>\n<td>CAMERA name = zone\n</td>\n<td>transient\n</td>\n<td>transient event triggered by a camera recording request with zone information\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the camera id</li>\n<li>zone - the zone id.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>CAMERA entrance\n</pre>",
	content:"CAMERA ${1:name}"
});
a.push({
	title:"CAMERA name = zone",
	subTitle:"Events, Cameras",
	docHTML:a.last().docHTML,
	content:"CAMERA ${1:name} = ${2:zone}"
});
a.push({
	title:"CAMERACOMMAND name = function",
	subTitle:"Events, Cameras",
	docHTML:"<p>Triggered by a camera control input from the Web interface.\n</p><p>It can be used to execute arbitrary actions when the user clicks on the active areas of the camera view.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"240\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>CAMERACOMMAND name = function\n</td>\n<td>transient\n</td>\n<td>if this event has a positive match in EVENTS, the standard PTZ command associated to the camera’s PTZ driver is not executed\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the camera id</li>\n<li>function - see the table below.</li></ul>",
	content:"CAMERACOMMAND ${1:name} = ${2:function}"
});
a.push({
	title:"CAMERAVIEW name = status",
	subTitle:"Events, Cameras",
	docHTML:"<p>This event is used to check if HSYCO is currently displaying the real-time video from a camera.\n</p><p>The event will reset to off when no Web client has been loading images from the camera for several consecutive seconds.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"180\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>CAMERAVIEW name = status\n</td>\n<td>stable\n</td>\n<td>the camera real-time view status\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the camera id</li>\n<li>status - set to \"on\" or \"1\" to match the event when HSYCO is displaying the live view, and to \"off\" or \"0\" to match the event when HSYCO is not displaying a live view of the camera on any client.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>CAMERAVIEW entrance = on\n</pre>",
	content:"CAMERAVIEW ${1:name} = ${2:status}"
});
a.push({
	title:"DMX address",
	subTitle:"Events, DMX",
	docHTML:"<p>Events on the DMX bus channels.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"150\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>DMX address\n</td>\n<td>transient\n</td>\n<td>any change to the channel value\n</td></tr>\n<tr>\n<td>DMX address = ON\n</td>\n<td>stable\n</td>\n<td>channel value > 0\n</td></tr>\n<tr>\n<td>DMX address = OFF\n</td>\n<td>stable\n</td>\n<td>channel value = 0\n</td></tr>\n<tr>\n<td>\n<p>DMX address = value<br>\nDMX address > value<br>\nDMX address < value<br>\nDMX address >= value<br>\nDMX address <= value\n</p>\n</td>\n<td>stable\n</td>\n<td>the channel value is equal, greater, greater or equal, less, less or equal to the given value.\n<p>Valid values are numbers between 0 and 255\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>address - when using one DMX gateway, address will be a standard DMX-512 address between 1 and 512. If there is more than one gateway, 1000 must be added to the DMX address for the second gateway, 2000 for the third one and so on. For example, 2100 stands for the address 100 on the DMX bus controlled by the third gateway.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>DMX 100 = ON\nDMX 1200 = OFF\nDMX 135 = OFF OR DMX 100 > 50\nDMX 41 <= $LEVEL\n</pre>",
	content:"DMX ${1:address}"
});
a.push({
	title:"DMX address = ON",
	subTitle:"Events, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} = ON"
});
a.push({
	title:"DMX address = OFF",
	subTitle:"Events, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} = OFF"
});
a.push({
	title:"DMX address = value",
	subTitle:"Events, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${2:address} = ${3:value}"
});
a.push({
	title:"DMX address > value",
	subTitle:"Events, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} > ${2:value}"
});
a.push({
	title:"DMX address < value",
	subTitle:"Events, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} < ${2:value}"
});
a.push({
	title:"DMX address >= value",
	subTitle:"Events, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} >= ${2:value}"
});
a.push({
	title:"DMX address ",
	subTitle:"Events, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} "
});
a.push({
	title:"DMXSTART busid",
	subTitle:"Events, DMX",
	docHTML:"<p>This event is triggered when starting the monitor threads for each DMX bus, once per bus at the start of the execution of HSYCO, and also after every restart of the monitor thread.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>DMXSTART busid\n</td>\n<td>transient\n</td>\n<td>occurs when HSYCO connects to the DMX gateway.\n<p>HSYCO establishes the connection at start-up.\n</p><p>If the gateway is turned off and then on, or if communication errors occur, HSYCO automatically re-establishes the connection as soon as possible, calling this event in case of success\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>busid - the id of the DMX gateway. The first gateway has address 0. The second  has address 1, etc. busid can be omitted if 0.</li></ul><p><b>Examples:</b>\n</p><pre>DMXSTART: DMX 100-200 = OFF\nDMXSTART 1: DMX 1100-1200 = OFF\n</pre>",
	content:"DMXSTART ${1:busid}"
});
a.push({
	title:"IR name = command",
	subTitle:"Events, Infrared Control",
	docHTML:"<p>This event is triggered when an IRTrans receives and successfully decodes an infrared command.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>IRTrans can only receive and decode infrared commands that have been previously stored in its internal FLASH memory database.</b>\n</p><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>IR name = command\n</td>\n<td>transient\n</td>\n<td>command received by an IRTrans device\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the IRTrans, as defined in the IRTrans parameter in hsyco.ini</li>\n<li>command - the command format is \"remote.command\", that is the remote control database name followed by a dot and the command name.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>IR theater = dvd.play\n</pre>",
	content:"IR ${1:name} = ${2:command}"
});
a.push({
	title:"IO name",
	subTitle:"Events, I/O Servers",
	docHTML:"<p>Triggered by a status change of any data port of an I/O server.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>IO name\n</td>\n<td>transient\n</td>\n<td>any change of an I/O variable\n</td></tr>\n<tr>\n<td>\n<p>IO name = value<br>\nIO name > value<br>\nIO name < value<br>\nIO name >= value<br>\nIO name <= value\n</p>\n</td>\n<td>stable\n</td>\n<td>the value is equal, greater, greater or equal, less, less or equal to the given value.<br>\n<p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The names and values of the I/O variables are specifically related to the type of I/O server. Values can be numeric or strings</b>\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the data point name of the input or output port. According to the type of server, the format changes but it generally appears as server name, as declared with the ioServers parameter in hsyco.ini, followed by a dot and the input/output port name. See the Application Notes for more information.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>IO tempmeter.indoor > 25.5\nIO contacts.c1 = 1\n</pre>",
	content:"IO ${1:name}"
});
a.push({
	title:"IO name = value",
	subTitle:"Events, I/O Servers",
	docHTML:a.last().docHTML,
	content:"IO ${2:name} = ${3:value}"
});
a.push({
	title:"IO name > value",
	subTitle:"Events, I/O Servers",
	docHTML:a.last().docHTML,
	content:"IO ${1:name} > ${2:value}"
});
a.push({
	title:"IO name < value",
	subTitle:"Events, I/O Servers",
	docHTML:a.last().docHTML,
	content:"IO ${1:name} < ${2:value}"
});
a.push({
	title:"IO name >= value",
	subTitle:"Events, I/O Servers",
	docHTML:a.last().docHTML,
	content:"IO ${1:name} >= ${2:value}"
});
a.push({
	title:"IO name ",
	subTitle:"Events, I/O Servers",
	docHTML:a.last().docHTML,
	content:"IO ${1:name} "
});
a.push({
	title:"IOSTART id",
	subTitle:"Events, I/O Servers",
	docHTML:"<p>This event indicates that the connection with an I/O server has been correctly established.\n</p><p>It should be safe to associate this event with actions that set the I/O server writable variables.\n</p><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"120\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>IOSTART id\n</td>\n<td>transient\n</td>\n<td>Triggered by the start of the communication thread of each I/O server - once for each server at the beginning of the execution of HSYCO, and also after every reboot of the communication thread, for example after communication errors\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>id - the I/O server number, starting from 0, based on the listing order of the ioServers parameter in hsyco.ini; If only one I/O server is available, it can be omitted.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>IOSTART: IO contacts.c1 = 1\nIOSTART 2: IO relays.door = 1\n</pre>",
	content:"IOSTART ${1:id}"
});
a.push({
	title:"LEAK name",
	subTitle:"Events, Leak Detector",
	docHTML:"<p>This stable event is triggered by a LEAK action when the Intelligent Leak Detector detects a leak condition, or the leak condition is reset.\n</p><p>See the LEAK action for additional information.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LEAK name\n</td>\n<td>transient\n</td>\n<td>any status change of the leak detector\n</td></tr>\n<tr>\n<td>LEAK name = ON\n</td>\n<td>stable\n</td>\n<td>leak condition detected\n</td></tr>\n<tr>\n<td>LEAK name = OFF\n</td>\n<td>stable\n</td>\n<td>leak condition reset\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the name of a leak detector. Using different names you can implement several independent leak detectors.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>HSYCOSTART : PROGRAMTIMER modbusread = repeat 4\nPROGRAMTIMER modbusread : IO modbus.2.768 = readholdingregisters:uint, LEAK water = IO modbus.2.768\nLEAK water = ON : MAIL john@example.com = hsyco@example.com \"Urgent Message from HSYCO\" \"Leak Detected\"\nLEAK water = OFF : MAIL john@example.com = hsyco@example.com \"Message from HSYCO\" \"Leak Reset\"\n</pre>",
	content:"LEAK ${1:name}"
});
a.push({
	title:"LEAK name = ON",
	subTitle:"Events, Leak Detector",
	docHTML:a.last().docHTML,
	content:"LEAK ${1:name} = ON"
});
a.push({
	title:"LEAK name = OFF",
	subTitle:"Events, Leak Detector",
	docHTML:a.last().docHTML,
	content:"LEAK ${1:name} = OFF"
});
a.push({
	title:"LOCATION address = zone",
	subTitle:"Events, Location Services",
	docHTML:"<p>This event is triggered when a change in the association status of a client to the Wi-Fi access points is detected.\n</p><p>It is a stable condition that represents the current connection state and location of WiFi clients logged into the HSYCO Web interface.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LOCATION address = zone\n</td>\n<td>stable\n</td>\n<td>a device connects to the access point identified by the zone name, as declared in the LocationBases parameter in hsyco.ini\n</td></tr>\n<tr>\n<td>LOCATION address = ON\n</td>\n<td>stable\n</td>\n<td>a device connects to the WiFi network\n</td></tr>\n<tr>\n<td>LOCATION address = OFF\n</td>\n<td>stable\n</td>\n<td>a device disconnects from the WiFi network\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>address - the WiFi device’s MAC address. It is made of 6 byte pairs, written in hexadecimal format and separated by \":\"</li>\n<li>zone - id associated to the iBeacon, as declared in the LocationBases configuration in hsyco.ini.</li></ul>",
	content:"LOCATION ${1:address} = ${2:zone}"
});
a.push({
	title:"LOCATION address = ON",
	subTitle:"Events, Location Services",
	docHTML:a.last().docHTML,
	content:"LOCATION ${1:address} = ON"
});
a.push({
	title:"LOCATION address = OFF",
	subTitle:"Events, Location Services",
	docHTML:a.last().docHTML,
	content:"LOCATION ${1:address} = OFF"
});
a.push({
	title:"LOCATIONBEACON userid = zone",
	subTitle:"Events, Location Services",
	docHTML:"<div style=\"color:#CC0000\"><b><div class=\"note note-reminder\"><center>WARNING! The Beacons functionality for iOS is experimental and subject to changes.</center></div></b>\n<p><b></b>\n</p>\n</div><p>This event is triggered when a change in the proximity of an HSYCO App based client to an iBeacon is detected. See <a href=\"/3.8/index.php/Beacons_on_HSYCO_App_for_iOS\" title=\"Beacons on HSYCO App for iOS\">Beacons on HSYCO App for iOS</a> for additional information.\n</p><p>It is a stable condition that represents the current connection state and location of WiFi clients logged into the HSYCO Web interface.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"260\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LOCATIONBEACON userid = zone\n</td>\n<td>stable\n</td>\n<td>a user is in proximity to an iBeacon\n</td></tr>\n<tr>\n<td>LOCATIONBEACON zone\n</td>\n<td>stable\n</td>\n<td>one or more users are in the proximity range of an iBeacon\n</td></tr>\n</tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>userid - the user id</li>\n<li>zone - id associated to the iBeacon, as declared in the LocationBases configuration in hsyco.ini.</li></ul>",
	content:"LOCATIONBEACON ${1:userid} = ${2:zone}"
});
a.push({
	title:"LOCATIONBEACON zone",
	subTitle:"Events, Location Services",
	docHTML:a.last().docHTML,
	content:"LOCATIONBEACON ${1:zone}"
});
a.push({
	title:"LOCATIONGEO userid = zone",
	subTitle:"Events, Location Services",
	docHTML:"<p>This event is triggered when a geographic location notification is sent by an HSYCO iOS or Android app, for a specific user, if the location is defined in hsyco.ini.\n</p><p>It is a transient event, true if the reported location is inside the distance from the zone's coordinates set in hsyco.ini, or false if outside.\n</p><p><br>\n</p><div class=\"note note-reminder\"><center>Note that the horizontal accuracy radius is taken into account. So, considering a circumference cantered on the zone's coordinates and having a radius equal to the distance parameter set in hsyco.ini, and another circumference centered on the reported position coordinates and with a radius equal to the horizontal accuracy, the event is true if the two circumferences overlap.</center></div><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LOCATIONGEO userid = zone\n</td>\n<td>transient\n</td>\n<td>a geographic location notification is sent by an HSYCO iOS or Android app from userid\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>userid - the user id</li>\n<li>zone - id associated to the geographic location, as declared in the LocationBases configuration in hsyco.ini.</li></ul>",
	content:"LOCATIONGEO ${1:userid} = ${2:zone}"
});
a.push({
	title:"HTTP query",
	subTitle:"Events, Network Services",
	docHTML:"<p>This transient event is triggered when the HSYCO HTTP server receives a GET request with the following path:\n</p><pre>/x/httpcall?query\n</pre><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The HTTP client's IP address must be in the trusted network range, or the httpcall request will be rejected, unless HTTPServerLowSecurityEnabled is true and the request is sent using HTTPS</b>\n</p><p>If a matching event is found, and the httpCallEvent JavaScript or Java callbacks are not defined, the HTTP server will respond with an \"ack\" text/plain answer to the HTTP client (with HTTP response code 200).\n</p><p>HSYCO will return a 404 Not Found response code if all of the following conditions are true:\n</p><ul><li>no HTTP event matches the query in EVENTS</li>\n<li>the httpCallEvent JavaScript callback is not defined in EVENTS, or doesn't return a value</li>\n<li>the httpCallEvent Java callback is not defined in user.java or in any plugins, or returns null.</li></ul><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>HTTP query\n</td>\n<td>transient\n</td>\n<td>the HSYCO HTTP/HTTPS server received an HTTP GET request: /x/httpcall?query\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>query - the string following the ? in the URL path.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>HTTP \"test\" : log = \"test http call\"\n</pre>",
	content:"HTTP ${1:query}"
});
a.push({
	title:"PING hostname = ON",
	subTitle:"Events, Network Services",
	docHTML:"<p>This transient event is generated by a <a href=\"/3.8/index.php/Action_Keywords#PING\" title=\"Action Keywords\">PING action</a>, that tests the reachability of one or more IP hosts, identified by their hostnames or IP addresses, within the optional timeout defined in milliseconds (or using a default timeout of 200 ms). \n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>PING hostname = ON\n</td>\n<td>transient\n</td>\n<td>the device has been reached after a PING action\n</td></tr>\n<tr>\n<td>PING hostname = OFF\n</td>\n<td>transient\n</td>\n<td>the device is not reachable after a PING action\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>hostname - the IP device name or IP address, as called by the corresponding PING action.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>TIME: PING 192.168.1.1\nPING 192.168.1.1 = OFF : LOG = \"router is off-line\"\n</pre>",
	content:"PING ${1:hostname} = ON"
});
a.push({
	title:"PING hostname = OFF",
	subTitle:"Events, Network Services",
	docHTML:a.last().docHTML,
	content:"PING ${1:hostname} = OFF"
});
a.push({
	title:"URL \"url\" = status_code",
	subTitle:"Events, Network Services",
	docHTML:"<p>This transient event is generated by a URL action, that sends an HTTP or HTTPS request to a given url.\n</p><p>The response can be checked for a specific numeric status code or looking at a string in the response body.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>URL \"url\" = status_code\n</td>\n<td>transient\n</td>\n<td>the response status code to the HTTP url request is equal to status_code\n</td></tr>\n<tr>\n<td>URL \"url\" *= \"string\"\n</td>\n<td>transient\n</td>\n<td>the response data to the HTTP url request contains the string\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>url - a full url, including the mandatory http:// or https:// query scheme and optional query string</li>\n<li>status_code - the numeric status code returned by the server’s response; 200 is usually the code returned by a successful request</li>\n<li>string - the event matches any response containing the given string in the response body.</li></ul><p><br>\n<b>Examples:</b>\n</p><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>TIME 0800: URL GET \"http://10.0.0.5/cgi-bin/cmd.sh?id=relay1\"\nURL \"http://10.0.0.5/cgi-bin/cmd.sh?id=relay1\" : LOG = \"relay opened\"</pre></div>",
	content:"URL \"${1:url}\" = ${2:status_code}"
});
a.push({
	title:"URL \"url\" *= \"string\"",
	subTitle:"Events, Network Services",
	docHTML:a.last().docHTML,
	content:"URL \"${1:url}\" *= \"${2:string}\""
});
a.push({
	title:"PBX from = to",
	subTitle:"Events, PBX",
	docHTML:"<p>Called when a call notification is sent to HSYCO by the PBX system.\n</p><p>The PBX should generate HTTP requests to the HSYCO Web Server, using the following formats:\n</p><pre>http://192.168.0.50/x/vcall/<from>/<to>\n</pre><p>or:\n</p><pre>http://192.168.0.50/x/vcall?from=<from>&to=<to>\n</pre><p>For example, the HTTP request:\n</p><pre>http://192.168.0.50/x/vcall?from=21&to=25\n</pre><p>is interpreted as a call notification from internal number 21 to number 25.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The HTTP client's IP address must be in the trusted network range, or the httpcall request will be rejected.</b>\n</p><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"140\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>PBX from = to\n</td>\n<td>transient\n</td>\n<td>phone call event, with originator and destination data\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>from - the caller number</li>\n<li>to - the called number.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>A call from number 22 to number 44 turns on light k.33:\n</p><pre>PBX 22 = 44 : IO k.33 = 1\n</pre>",
	content:"PBX ${1:from} = ${2:to}"
});
a.push({
	title:"MUSIC address = ON",
	subTitle:"Events, Squeezebox",
	docHTML:"<p>Triggered by a status change in a Squeezebox player. It is a stable condition that represents the current ON/OFF/PLAY/PAUSE status of the player.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>MUSIC address = ON\n</td>\n<td>stable\n</td>\n<td>player on\n</td></tr>\n<tr>\n<td>MUSIC address = OFF\n</td>\n<td>stable\n</td>\n<td>player off\n</td></tr>\n<tr>\n<td>MUSIC address = PLAY\n</td>\n<td>stable\n</td>\n<td>player on - play\n</td></tr>\n<tr>\n<td>MUSIC address = PAUSE\n</td>\n<td>stable\n</td>\n<td>player on - pause\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>address - player number, starting from 0 for the first player, based on the listing order of the slimPlayers parameter in hsyco.ini.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>MUSIC 0 = ON\nMUSIC 1 = PLAY\n</pre>",
	content:"MUSIC ${1:address} = ON"
});
a.push({
	title:"MUSIC address = OFF",
	subTitle:"Events, Squeezebox",
	docHTML:a.last().docHTML,
	content:"MUSIC ${1:address} = OFF"
});
a.push({
	title:"MUSIC address = PLAY",
	subTitle:"Events, Squeezebox",
	docHTML:a.last().docHTML,
	content:"MUSIC ${1:address} = PLAY"
});
a.push({
	title:"MUSIC address = PAUSE",
	subTitle:"Events, Squeezebox",
	docHTML:a.last().docHTML,
	content:"MUSIC ${1:address} = PAUSE"
});
a.push({
	title:"TIMER name = ON",
	subTitle:"Events, Timers and Schedulers",
	docHTML:"<p>This is a stable event that matches the current status of a user timer or scheduler.\n</p><p>It is triggered by the timer’s activation and deactivation.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>TIMER name = ON\n</td>\n<td>stable\n</td>\n<td>true when the timer or scheduler rule is active (ON status)\n</td></tr>\n<tr>\n<td>TIMER name = OFF\n</td>\n<td>stable\n</td>\n<td>true when the timer or scheduler rule is not active (OFF status)\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the timer’s id, as declared with the Timers parameter in hsyco.ini, or the scheduler’s rule name.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>TIMER irrigation = ON : IO k.33 k.34 = 1\nTIMER irrigation = OFF : IO k.33 k.34 = 0\n</pre>",
	content:"TIMER ${1:name} = ON"
});
a.push({
	title:"TIMER name = OFF",
	subTitle:"Events, Timers and Schedulers",
	docHTML:a.last().docHTML,
	content:"TIMER ${1:name} = OFF"
});
a.push({
	title:"PAGE project = page",
	subTitle:"Events, User Interface",
	docHTML:"<p>Triggered when the specified page of a project is viewed by a client.\n</p><p>There is no guarantee that the event would be fired the exact moment the page is loaded.\n</p><p>Network delays or errors could cause delayed triggering of this event.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>You can use the UISESSIONSET action with this event</b>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>PAGE project = page\n</td>\n<td>transient\n</td>\n<td>a Web client is viewing a specific page of a project\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>project - the name of the project</li>\n<li>page - the page id, with the #landscape or #portrait suffix if the page has distinct orientation versions in the project.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>Count how many times the portrait and landscape versions of a project’s menu page are viewed:\n</p><pre>PAGE \"myproject\" = \"menu#landscape\" : $landscape_counter + 1\nPAGE \"myproject\" = \"menu#portrait\" : $portrait_counter + 1\n</pre>",
	content:"PAGE ${1:project} = ${2:page}"
});
a.push({
	title:"LOGIN userid",
	subTitle:"Events, User Interface",
	docHTML:"<p>Triggered when a user authenticates with a valid PIN or PIN/PUK.\n</p><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LOGIN userid\n</td>\n<td>transient\n</td>\n<td>a user authenticates with a valid PIN or PIN/PUK\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>userid - the user id.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>Count how many times the staff user has logged in successfully:\n</p><pre>LOGIN \"staff\" : $login_counter_staff + 1\n</pre>",
	content:"LOGIN ${1:userid}"
});
a.push({
	title:"LOGOUT userid",
	subTitle:"Events, User Interface",
	docHTML:"<p>Triggered when a user logs out or locks the user interface.\n</p><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LOGOUT userid\n</td>\n<td>transient\n</td>\n<td>a user logs out or locks the user interface\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>userid - the user id.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>Count how many times the staff user has logged out:\n</p><pre>LOGOUT \"staff\" : $logout_counter_staff + 1\n</pre>",
	content:"LOGOUT ${1:userid}"
});
a.push({
	title:"USER name = param",
	subTitle:"Events, User Interface",
	docHTML:"<p>Triggered by user clicks on buttons created in the Web interface with the (user), (usermini), (usermicro), (userrgb) or (userimage) objects, by a USER action in EVENTS, or by the user() Java method or JavaScript function. Also triggered by by the screensaver (see the <b><a href=\"/3.8/index.php/Screensaver\" title=\"Screensaver\"> Screensaver</a></b> page for more details).\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Event</b>\n</td>\n<td width=\"80\"><b>State</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>USER name = param\n</td>\n<td>transient\n</td>\n<td>this format requires a match with both name and parameter\n</td></tr>\n<tr>\n<td>USER name\n</td>\n<td>transient\n</td>\n<td>this format requires a match with name only\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the name field of the (user) object</li>\n<li>param - the id of the (user) object.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>Turns on light k.33 approximately 10 seconds after the click on a user button:\n</p><pre>USER timer : PROGRAMTIMER test = SET 10\nPROGRAMTIMER test : IO k.33 = 1\n</pre>",
	content:"USER ${1:name} = ${2:param}"
});
a.push({
	title:"USER name",
	subTitle:"Events, User Interface",
	docHTML:a.last().docHTML,
	content:"USER ${1:name}"
});



var a = s.actions;
a.push({
	title:"DATESET = datetime",
	subTitle:"Actions, System Keywords",
	docHTML:"<p>Set the HSYCO Server’s system clock.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>DATESET = datetime\n</td>\n<td>set the HSYCO Server operating system’s clock and hardware clock\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>datetime - date and time formatted as \"YYYY-MM-DD hh:mm:ss\" or \"YYYYMMDDhhmmss\", in the local time zone</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>DATESET \"2014-10-31 20:00:00\"\nDATESET \"20141031200000\"\n</pre>",
	content:"DATESET = ${1:datetime}"
});
a.push({
	title:"HAACTIVE = FALSE",
	subTitle:"Actions, System Keywords",
	docHTML:"<p>Force a master HSYCO server to become inactive, or return to the active state.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>HAACTIVE = FALSE\n</td>\n<td>force a master to become inactive (has no effect on the slave system)\n</td></tr>\n<tr>\n<td>HAACTIVE = TRUE\n</td>\n<td>used after the master was forced to become inactive, returns it to the active state (has no effect on the slave system)\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>active - true or false</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>IO mygate.connection = offline : HAACTIVE = false\n</pre>",
	content:"HAACTIVE = FALSE"
});
a.push({
	title:"HAACTIVE = TRUE",
	subTitle:"Actions, System Keywords",
	docHTML:a.last().docHTML,
	content:"HAACTIVE = TRUE"
});
a.push({
	title:"NLP = text",
	subTitle:"Actions, System Keywords",
	docHTML:"<p>Send a text to the Natural Language Processor (NLP). See the <a href=\"/3.8/index.php/NLP#How_to_send_text_messages_to_the_NLP_engine\" title=\"NLP\">NLP engine</a> page for additional information.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>NLP = text\n</td>\n<td>\n<p>the text string is passed to the NLP for processing and to execute the corresponding actions if a match is found.\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>text - natural language text string</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>NLP = \"turn on the kitchen lights\"\n</pre>",
	content:"NLP = ${1:text}"
});
a.push({
	title:"POWER = power",
	subTitle:"Actions, System Keywords",
	docHTML:"<p>Sets the electric power state variable.\n</p><p>The power value is shown in the navigation or status bar of the Web interface.\n</p><p>Besides setting the power value, this method also triggers the execution of the powerEvent() callback and the POWER event in EVENTS.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>POWER = power\n</td>\n<td>sets the electric power state variable to a specific value, in Watts\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>power - the power in Watt units.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>POWER = IO meter.power\n</pre>",
	content:"POWER = ${1:power}"
});
a.push({
	title:"PROGRAMTIMER name = SET seconds",
	subTitle:"Actions, System Keywords",
	docHTML:"<p>Creates or deletes a program timer.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"280\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>PROGRAMTIMER name = SET seconds\n</td>\n<td>\n<p>a program timer will be executed after the number of seconds specified in SET.<br>\nIf a program timer with the same name has already been set, the action will be ignored\n</p>\n</td></tr>\n<tr>\n<td>PROGRAMTIMER name = CLEAR\n</td>\n<td>deletes a timer\n</td></tr>\n<tr>\n<td>PROGRAMTIMER name = RESET seconds\n</td>\n<td>similar to SET, but if a program timer with the same name has already been set, the timer settings will be changed to the new timeout\n</td></tr>\n<tr>\n<td>PROGRAMTIMER name = REPEAT seconds\n</td>\n<td>sets a program timer that is executed repeatedly with an interval  equal to the specified number of seconds\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the program timer name</li>\n<li>seconds - the timeout, in seconds.</li></ul><p>If the program timer name starts with $, then the server will also automatically set a variable, with a name equal to the program timer's name, to the remaining number of seconds. Note that the variable is not guarateed to be updated at every second, as some updates may be skipped due to timing constraints.\n</p><p><b>Examples:</b>\n</p><pre>SECURITY evo = ON 1  : PROGRAMTIMER presence = REPEAT 3600\nSECURITY evo = OFF 1 : PROGRAMTIMER presence = CLEAR\n</pre>",
	content:"PROGRAMTIMER ${1:name} = SET ${2:seconds}"
});
a.push({
	title:"PROGRAMTIMER name = CLEAR",
	subTitle:"Actions, System Keywords",
	docHTML:a.last().docHTML,
	content:"PROGRAMTIMER ${1:name} = CLEAR"
});
a.push({
	title:"PROGRAMTIMER name = RESET seconds",
	subTitle:"Actions, System Keywords",
	docHTML:a.last().docHTML,
	content:"PROGRAMTIMER ${1:name} = RESET ${2:seconds}"
});
a.push({
	title:"PROGRAMTIMER name = REPEAT seconds",
	subTitle:"Actions, System Keywords",
	docHTML:a.last().docHTML,
	content:"PROGRAMTIMER ${1:name} = REPEAT ${2:seconds}"
});
a.push({
	title:"WAIT = s",
	subTitle:"Actions, System Keywords",
	docHTML:"<p>Pauses before the execution of the next action.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>WAIT = s\n</td>\n<td>\n<p>causes a pause in the execution of actions for the specified number of seconds.<br>\nIt can be also set in decimal format\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>s - wait time in seconds</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>WAIT = 5\nWAIT = 0.3\n</pre>",
	content:"WAIT = ${1:s}"
});
a.push({
	title:"CAMERA name = ON",
	subTitle:"Actions, Cameras",
	docHTML:"<p>The CAMERA action is used to temporarily disable cameras’ live view and recording features.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"180\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>CAMERA name = ON\n</td>\n<td>live view enabled\n</td></tr>\n<tr>\n<td>CAMERA name = OFF\n</td>\n<td>live view and recording disabled\n</td></tr>\n<tr>\n<td>CAMERA name = RECON\n</td>\n<td>recording enabled\n</td></tr>\n<tr>\n<td>CAMERA name = RECOFF\n</td>\n<td>recording disabled\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the camera’s id. You can specify a list of space separated ids.</li></ul><p><br>\n<b>Examples:</b>\n</p><ul><li>CAMERA entrance = ON</li></ul>",
	content:"CAMERA ${1:name} = ON"
});
a.push({
	title:"CAMERA name = OFF",
	subTitle:"Actions, Cameras",
	docHTML:a.last().docHTML,
	content:"CAMERA ${1:name} = OFF"
});
a.push({
	title:"CAMERA name = RECON",
	subTitle:"Actions, Cameras",
	docHTML:a.last().docHTML,
	content:"CAMERA ${1:name} = RECON"
});
a.push({
	title:"CAMERA name = RECOFF",
	subTitle:"Actions, Cameras",
	docHTML:a.last().docHTML,
	content:"CAMERA ${1:name} = RECOFF"
});
a.push({
	title:"CAMERAREC name = sec",
	subTitle:"Actions, Cameras",
	docHTML:"<p>Records video from a camera.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"180\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>CAMERAREC name = sec\n</td>\n<td>records for the number of seconds defined with the set attribute\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the camera’s id. You can specify a list of space separated ids</li>\n<li>sec - recording time in seconds. If set to 0, stops the current recording.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>CAMERAREC openspace = 30\n</pre>",
	content:"CAMERAREC ${1:name} = ${2:sec}"
});
a.push({
	title:"CAMERARECFULL name = sec",
	subTitle:"Actions, Cameras",
	docHTML:"<p>Records video from a camera, like CAMERAREC, but ignores the DroppedFrames parameter in hsyco.ini, so that all frames captured from the camera during the recording period are recorded with no skips.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"200\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>CAMERARECFULL name = sec\n</td>\n<td>records for the number of seconds defined with the set attribute\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the camera’s id. You can specify a list of space separated ids</li>\n<li>sec - recording time in seconds. If set to 0, stops the current recording.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>CAMERARECFULL openspace = 30\n</pre>",
	content:"CAMERARECFULL ${1:name} = ${2:sec}"
});
a.push({
	title:"DATALOGGER name = value",
	subTitle:"Actions, Data Logger",
	docHTML:"<p>Updates and performs operations on a data logger.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"360\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>DATALOGGER name = value\n</td>\n<td>\n<p>Supplies the data logger with a new value to be processed.<br>\nIt will also trigger the refresh procedure\n</p>\n</td></tr>\n<tr>\n<td>DATALOGGER name = CLEAR\n</td>\n<td>Clears the data gathered in the data logger\n</td></tr>\n<tr>\n<td>DATALOGGER name = ERROR\n</td>\n<td>Used with counter data loggers, resets the internal delta baseline\n</td></tr>\n<tr>\n<td>DATALOGGER name = FILE LOG filename\n</td>\n<td>\n<p>Appends the last acquired value to the specified file (filename) using the CSV format.\n</p>\n</td></tr>\n<tr>\n<td>DATALOGGER name = FILE LOG filename TIMESTAMP\n</td>\n<td>\n<p>Appends the last acquired value to the specified file (filename) using the CSV format.<br>\nThe timestamp of the record will be reported too\n</p>\n</td></tr>\n<tr>\n<td>DATALOGGER name = FILE STAT filename\n</td>\n<td>Creates or updates the specified file (filename) with the currently gathered data using the CSV format\n</td></tr>\n<tr>\n<td>DATALOGGER name = FILE CSVWRITE path\n</td>\n<td>Writes a raw dump of all data from a data logger into a CSV file. The file, named <data logger id>.csv is written in the < path> directory\n</td></tr>\n<tr>\n<td>DATALOGGER name = FILE CSVWRITE FROM yyyymmddhhmm TO yyyymmddhhmm GROUPBY year | month | day | hour PATH path\n</td>\n<td>Writes a raw dump of data from a data logger into a CSV file, between the given time interval. The file, named <data logger id>.csv is written in the < path> directory. The date and time must be written as a 12 digit string. Data returned including the first time and excluding the second. The \"TO\" limit is optional. \"GROUPBY\" is also optional. If omitted, all individual records matching the time interval are written to the CSV file. If \"GROUPBY\" is specified, records and their values are grouped together by year, month, day or hour. Note that, to optimise performance and resources allocation, this extended form of the FILE CSVWRITE action can write only up to 10000 rows to the CSV file\n</td></tr>\n<tr>\n<td>DATALOGGER name = FILE CSVREAD path\n</td>\n<td>Upload a CSV file to insert, update or delete records of a data logger. The file, named <data logger id>.csv, is read from the < path> directory\n</td></tr>\n<tr>\n<td>DATALOGGER name = FILE CSVREADOVER path\n</td>\n<td>Upload a CSV file that will replace all records of a data logger\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - identifier of the data logger. It is possible to use a list of names separated by spaces to address several data loggers. Variables can be used</li>\n<li>filename - the file pathname. You can use multiple distinct strings, including variables, that will be concatenated to create the file name.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>See <a href=\"/3.8/index.php/Data_Loggers#CSV_Import.2FExport\" title=\"Data Loggers\">Data Loggers CSV Import/Export</a> for CSV raw data import export examples.\n</p><pre>$value : DATALOGGER energy = $value,\n  DATALOGGER energy = FILE LOG userdata/energylog.csv TIMESTAMP,\n  DATALOGGER energy = FILE STAT userdata/energystat.csv\n</pre><pre>TIME : DATALOGGER temperature = IO ste.1\nTIME : DATALOGGER humidity = IO ste.2\n</pre><p>Example of code to export and import a data logger called \"loggermem\" (path: \"logger\", data logger id: \"loggermem\")\n</p><pre>user dataimport : DATALOGGER loggermem = FILE CSVREADOVER \"logger\"\nuser dataexport : DATALOGGER loggermem = FILE CSVWRITE \"logger\"\nuser dataexport : DATALOGGER loggermem = FILE CSVWRITE FROM \"201801010000\" TO \"202101010000\" GROUPBY \"month\" PATH \"logger\"\n</pre>",
	content:"DATALOGGER ${1:name} = ${2:value}"
});
a.push({
	title:"DATALOGGER name = CLEAR",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = CLEAR"
});
a.push({
	title:"DATALOGGER name = ERROR",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = ERROR"
});
a.push({
	title:"DATALOGGER name = FILE LOG filename",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = FILE LOG ${2:filename}"
});
a.push({
	title:"DATALOGGER name = FILE LOG filename TIMESTAMP",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = FILE LOG ${2:filename} TIMESTAMP"
});
a.push({
	title:"DATALOGGER name = FILE STAT filename",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = FILE STAT ${2:filename}"
});
a.push({
	title:"DATALOGGER name = FILE CSVWRITE path",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = FILE CSVWRITE ${2:path}"
});
a.push({
	title:"DATALOGGER name = FILE CSVWRITE FROM yyyymmddhhmm TO yyyymmddhhmm GROUPBY year | month | day | hour PATH path",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = FILE CSVWRITE FROM ${2:yyyymmddhhmm} TO ${3:yyyymmddhhmm} GROUPBY ${4:year} | ${5:month} | ${6:day} | ${7:hour} PATH ${8:path}"
});
a.push({
	title:"DATALOGGER name = FILE CSVREAD path",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = FILE CSVREAD ${2:path}"
});
a.push({
	title:"DATALOGGER name = FILE CSVREADOVER path",
	subTitle:"Actions, Data Logger",
	docHTML:a.last().docHTML,
	content:"DATALOGGER ${1:name} = FILE CSVREADOVER ${2:path}"
});
a.push({
	title:"DMX address = ON",
	subTitle:"Actions, DMX",
	docHTML:"<p>Controls the value of DMX-512 channels.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"200\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>DMX address = ON\n</td>\n<td>sets the DMX address to the value preceding the last OFF command\n</td></tr>\n<tr>\n<td>DMX address = OFF\n</td>\n<td>sets the DMX address to value = 0\n</td></tr>\n<tr>\n<td>DMX address = FLIP\n</td>\n<td>\n<p>flips the status of a DMX channel (if the status is ON it executes the OFF command and vice versa).<br>\nWhen more channels are specified, if the previous status of at least one of the channels is different from OFF, the OFF command will be sent to all the channels, otherwise the ON command will be sent\n</p>\n</td></tr>\n<tr>\n<td>DMX address = value\n</td>\n<td>\n<p>assigns a value to the DMX channel.<br>\nValid values are numbers between 0 and 255\n</p>\n</td></tr>\n<tr>\n<td>DMX addressX = DMX addressY\n</td>\n<td>the DMX channel addressX assumes the current status of the DMX channel addressY\n</td></tr>\n<tr>\n<td>DMX address = MERGE\n</td>\n<td>the channel or channels on the DMX OUT bus of the gateway follow the same channels of the DMX IN bus\n</td></tr>\n<tr>\n<td>DMX address = UNMERGE\n</td>\n<td>disables merge mode\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>address - when using one DMX gateway, address will be a standard DMX-512 address between 1 and 512. If there is more than one gateway, 1000 must be added to the DMX address for the second gateway, 2000 for the third one and so on. For example, 2100 stands for the address 100 on the DMX bus controlled by the third gateway. You can also use a from-to range format to specify a contiguous block of channels.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>DMX 100 101 102 = ON\nDMX 100-120  200-220 = DMX 40\nDMX 33 = MERGE\n</pre>",
	content:"DMX ${1:address} = ON"
});
a.push({
	title:"DMX address = OFF",
	subTitle:"Actions, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} = OFF"
});
a.push({
	title:"DMX address = FLIP",
	subTitle:"Actions, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} = FLIP"
});
a.push({
	title:"DMX address = value",
	subTitle:"Actions, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} = ${2:value}"
});
a.push({
	title:"DMX addressX = DMX addressY",
	subTitle:"Actions, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address}X = DMX ${2:address}Y"
});
a.push({
	title:"DMX address = MERGE",
	subTitle:"Actions, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} = MERGE"
});
a.push({
	title:"DMX address = UNMERGE",
	subTitle:"Actions, DMX",
	docHTML:a.last().docHTML,
	content:"DMX ${1:address} = UNMERGE"
});
a.push({
	title:"IR name = command",
	subTitle:"Actions, Infrared Control",
	docHTML:"<p>Sends a command to an IRTrans.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>IR name = command\n</td>\n<td>the IR code must be in the local IRTrans FLASH memory database or, If the hsyco/ir directory contains a .ccfhex file corresponding to the database name, then the CCF string in that file is used instead of sending the command stored in the IRTrans internal database\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - identifies the IRTrans, as defined with the IRTrans parameter in hsyco.ini</li>\n<li>command - the command format is remote.command; that is the remote control database name followed by a dot and the command name.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>IR theater = dvd.play\n</pre>",
	content:"IR ${1:name} = ${2:command}"
});
a.push({
	title:"IO name = value",
	subTitle:"Actions, I/O Servers",
	docHTML:"<p>Writes to I/O servers data points.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>IO name = value\n</td>\n<td>\n<p>sets the data point to a value.<br>\nValues are specific to the type of I/O server\n</p>\n</td></tr>\n<tr>\n<td>IO name = FLIP\n</td>\n<td>inverts the output of the I/O data point. If the status of the output is 0 the new status will be 1, if different from 0 the new status will be 0\n</td></tr>\n<tr>\n<td>IO name1 = IO name2\n</td>\n<td>sets the I/O interface output name1 to the current value of the I/O interface name2\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the server id, followed by a single dot and the data point suffix. The EVENTS interpreter converts data points names to lower case</li>\n<li>value - you can use multiple unquoted words, quoted strings and variables, that will be appended to the value string.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>IO contacts.c1 contacts.c3= 1\nIO sensors.c1 = FLIP\nIO contacts.o1 contacts.o2 = IO sensors.flood\n</pre>",
	content:"IO ${1:name} = ${2:value}"
});
a.push({
	title:"IO name = FLIP",
	subTitle:"Actions, I/O Servers",
	docHTML:a.last().docHTML,
	content:"IO ${1:name} = FLIP"
});
a.push({
	title:"IO name1 = IO name2",
	subTitle:"Actions, I/O Servers",
	docHTML:a.last().docHTML,
	content:"IO ${1:name1} = IO ${2:name2}"
});
a.push({
	title:"LEAK name = value",
	subTitle:"Actions, Leak Detector",
	docHTML:"<p>Controls the integrated leak detector.\n</p><p>The detector’s logic uses two parameters to set its sensitivity and time base.\n</p><p>The detector generates a warning if the flow deviation constantly remains below the deviation threshold for the time period.\n</p><p>You can change the defaults to adapt to your specific conditions.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"180\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LEAK name = value\n</td>\n<td>\n<p>calls the leak detector passing the current liters counter value.<br>\nUsing variables or references to IO data points is supported\n</p>\n</td></tr>\n<tr>\n<td>LEAK name = PERIOD t\n</td>\n<td>\n<p>changes the time base. The default is 1200 seconds.<br>\nSet the period to 0 to temporarily disable the detector.<br>\nThe time base can be changed anytime, even when the detector is already processing data\n</p>\n</td></tr>\n<tr>\n<td>LEAK name = DEVIATION d\n</td>\n<td>\n<p>changes the deviation percentage. d should be a number between 1 and 100. The default is 50.<br>\nSet the deviation to 0 to temporarily disable the detector.<br>\nLower values cause the algorithm to activate leak warnings only when the flow is very constant in time, becoming less susceptible to false alarms, but a value that is too low could miss actual leaks. Higher values could easily generate false alarms. <br>\nThe deviation can be changed anytime\n</p>\n</td></tr>\n<tr>\n<td>LEAK name = CLEAR\n</td>\n<td>\n<p>clears the detector’s internal state.<br>\nIn normal applications, there is no need to call this function, as the detector automatically clears its state from old data\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the name of a leak detector. Using different names you can implement several independent leak detectors</li>\n<li>t - time base</li>\n<li>d - deviation percentage</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>HSYCOSTART : PROGRAMTIMER modbusread = repeat 4\nPROGRAMTIMER modbusread :  IO modbus.2.768 = readholdingregisters:uint, LEAK water = IO modbus.2.768\nLEAK water = ON : MAIL \"john@example.com\" = \"hsyco@example.com\" \"Urgent Message from HSYCO\" \"Leak Detected\"\nLEAK water = OFF : MAIL \"john@example.com\" = \"hsyco@example.com\" \"Message from HSYCO\" \"Leak Reset\"\n</pre>",
	content:"LEAK ${1:name} = ${2:value}"
});
a.push({
	title:"LEAK name = PERIOD t",
	subTitle:"Actions, Leak Detector",
	docHTML:a.last().docHTML,
	content:"LEAK ${1:name} = PERIOD ${2:t}"
});
a.push({
	title:"LEAK name = DEVIATION d",
	subTitle:"Actions, Leak Detector",
	docHTML:a.last().docHTML,
	content:"LEAK ${1:name} = DEVIATION ${2:d}"
});
a.push({
	title:"LEAK name = CLEAR",
	subTitle:"Actions, Leak Detector",
	docHTML:a.last().docHTML,
	content:"LEAK ${1:name} = CLEAR"
});
a.push({
	title:"FILELOG filename = text",
	subTitle:"Actions, Log",
	docHTML:"<p>Appends a generic text message at the end of a file.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>FILELOG filename = text\n</td>\n<td>you can use multiple unquoted words, quoted strings and variables, that will be appended at the last line of the text file\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>filename - the file name. You can specify any path, starting from HSYCO’s base directory. If the file or parent directories don’t exist, they will be created automatically. The filename parameter can be a variable</li>\n<li>text - the message that will be appended at the last line of the text file.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>HSYCOSTART : FILELOG logs/mylog.txt = \"log message example\"\n</pre>",
	content:"FILELOG ${1:filename} = ${2:text}"
});
a.push({
	title:"LOG = text",
	subTitle:"Actions, Log",
	docHTML:"<p>Generates an information message in the daily log file.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>LOG = text\n</td>\n<td>you can use multiple unquoted words, quoted strings and variables, that will be appended to the log message\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>text - the log message</li>\n<li>from - the sender e-mail address.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>LOG = \"log message example\"\nLOG = \"Time: \" $TIME:H-M-S$ \" DATE: \" $DATE:D/M/Y$\n</pre>",
	content:"LOG = ${1:text}"
});
a.push({
	title:"MAIL to = from subject body",
	subTitle:"Actions, Mail",
	docHTML:"<p>Sends an email message.\n</p><p>HSYCO SERVER sends the mail either directly to the recipient’s domain mail server if the SmtpName parameter is not defined in hsyco.ini, or using a specific email account with user authentication and traffic encryption if the SMTP server and account parameters are set.\n</p><p>If the email message is sent directly to the recipient’s domain mail server, you need to ensure that the mail server accepts mail to the destination address being sent with the from address and the public IP of the HSYCO SERVER.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>HSYCO does not automatically retry sending the message if the destination mail server is not available when the send mail function is called.</b>\n</p><p><br>\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"200\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>MAIL to = from subject body\n</td>\n<td>\n<p>sends text and camera images.<br>\nThe body part of the mail is the last attribute. You can email the same message to multiple recipients\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>to - the recipient address. It is possible to send the same email to a space  separated list of email addresses. You can optionally specify the destination SMTP server name or IP address by appending :server name or address to the recipient's email address, for example: john@example.com:192.168.1.1</li>\n<li>from - the sender e-mail address</li>\n<li>subject - a quoted string or variable with the message object</li>\n<li>body - the message body. To send an ordinary text, just enter a quoted text string. To send an image, append strings with the following format: \"cam:cameraname[:seconds_back[:frames_back]]\". For example, \"cam:door\" sends a live frame from the camera called \"door\"; \"cam:door:0\" sends the last recorded frame; \"cam:door:2\" sends a frame that was recorded two seconds before the last recorded frame and \"cam:door:2:5\" sends a frame that is 5 frames earlier than the one recorded two seconds before the last recording. To send files as attachments, use the following format: \"file:file name\". The file path is relative to the HSYCO root directory.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>In this example, we send a message every minute, with the measured power load, to two email addresses:\n</p><pre>TIME : $BODY = \"Energy consumption for \" $DATE:y/m/d$ \" at \" $TIME:h:m:s$ \" is \" $power$ \" Watt\"\n$BODY : MAIL email1@hsyco.com email2@hsyco.com = hsyco@hsyco.net \"Sent from HSYCO\" $BODY\n</pre><p>40 seconds after the alarm event, an email from the address hsyco@hsyco.net is sent to emal1@hsyco.com,  with three images attached: the first is a real time image, the second is the last recorded image, the third one is the frame that was recorded 15 seconds before:\n</p><pre>user \"security\" = \"alarm\" : CAMERAREC entrance = 30, PROGRAMTIMER rec = 40\nPROGRAMTIMER rec : MAIL email1@hsyco.com = hsyco@hsyco.net \"Sent from HSYCO\" \"Camera entrance\" \"cam:entrance\" \"cam:entrance:0\" \"cam:entrance:15\"\n</pre><p>At midnight, we are sending the energy.csv file in the data sub-directory as an attachment:\n</p><pre>TIME = 0000: MAIL email1@hsyco.com = hsyco@hsyco.net \"Sent\nfrom HSYCO\" \"Energy daily report.\" file:data/energy.csv\n</pre>",
	content:"MAIL ${1:to} = ${2:from} ${3:subject} ${4:body}"
});
a.push({
	title:"PING hostname",
	subTitle:"Actions, Network Services",
	docHTML:"<p>Tests the reachability of one or more hosts, identified by their hostnames or IP addresses, within the optional timeout defined in milliseconds (or using a default timeout of 200 ms).\n</p><p>This test generates PING events like PING hostname = ON if the host is reachable, or PING hostname = OFF if not reachable.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>PING hostname\n</td>\n<td>test the reachability of hostname, with 200ms response time-out\n</td></tr>\n<tr>\n<td>PING hostname = time\n</td>\n<td>test the reachability of hostname, with a specific response time-out\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>hostname - the IP device name or IP address</li>\n<li>time - response time-out, in milliseconds.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>TIME : PING 192.168.1.1\nTIME : PING 192.168.1.200 192.168.1.201 = 1000\n</pre>",
	content:"PING ${1:hostname}"
});
a.push({
	title:"PING hostname = time",
	subTitle:"Actions, Network Services",
	docHTML:a.last().docHTML,
	content:"PING ${1:hostname} = ${2:time}"
});
a.push({
	title:"URL GET \"url\"",
	subTitle:"Actions, Network Services",
	docHTML:"<p>Sends a GET or POST HTTP or HTTPS request to the specified url.\n</p><p>The HTTP basic or digest access authentication methods are supported.\n</p><p>Responses can be checked using the corresponding URL event.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"320\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>URL GET \"url\"\n</td>\n<td>sends a GET request without authentication\n</td></tr>\n<tr>\n<td>URL GET \"user:password\" \"url\"\n</td>\n<td>sends a GET request with authentication\n</td></tr>\n<tr>\n<td>URL POST \"url\" \"content_type\" \"data\"\n</td>\n<td>sends a POST request without authentication\n</td></tr>\n<tr>\n<td>URL POST \"user:password\" \"url\" \"content_type\" \"data\"\n</td>\n<td>sends a POST request with authentication\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>url - a full url, including the mandatory http:// or https:// query scheme and optional query string</li>\n<li>user:password - user and password for basic or digest access authentication</li>\n<li>content_type - the MIME type descriptor for the POST data</li>\n<li>data - the POST data (HTTP message body) sent with the request, encoded according to the content_type parameter (usually application/x-www-form-urlencoded for POST messages)</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>HSYCOSTART: URL POST \"http://10.0.0.5/cgi-bin/cmd.sh\" \"text/xml\" \"%3C%3Fxml%20version%3D%22...\"\t\n</pre><pre>TIME 0800: URL GET \"usr1:qi3qw\" \"http://10.0.0.5/cgi-bin/cmd.sh?id=relay1\"\n</pre><pre>URL \"http://10.0.0.5/cgi-bin/cmd.sh?id=relay1\" : LOG = \"relay opened\"\n</pre>",
	content:"URL GET \"${1:url}\""
});
a.push({
	title:"URL GET \"user:password\" \"url\"",
	subTitle:"Actions, Network Services",
	docHTML:a.last().docHTML,
	content:"URL GET \"${1:user:password}\" \"${2:url}\""
});
a.push({
	title:"URL POST \"url\" \"content_type\" \"data\"",
	subTitle:"Actions, Network Services",
	docHTML:a.last().docHTML,
	content:"URL POST \"${1:url}\" \"${2:content_type}\" \"${3:data}\""
});
a.push({
	title:"URL POST \"user:password\" \"url\" \"content_type\" \"data\"",
	subTitle:"Actions, Network Services",
	docHTML:a.last().docHTML,
	content:"URL POST \"${1:user:password}\" \"${2:url}\" \"${3:content_type}\" \"${4:data}\""
});
a.push({
	title:"AUDIO to = FILE filename",
	subTitle:"Actions, Public Announcement",
	docHTML:"<p>The AUDIO action is used to play text-to-speech messages or recorded audio files.\n</p><p>Audio can be sent to the Web browser, the server’s audio line out connector, the internal speaker or audio out line of Axis cameras, SNOM's phones or PA devices, and I/O servers with audio playback capabilities.\n</p><p>See the <a href=\"/3.8/index.php/Audio_and_Public_Announcement\" title=\"Audio and Public Announcement\">Audio and Public Announcement</a> section for additional information.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"240\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>AUDIO to = FILE filename\n</td>\n<td>plays a pre-recorded audio file\n</td></tr>\n<tr>\n<td>AUDIO to = VOICE:voicename message\n</td>\n<td>converts a text message to speech and plays the audio\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>to - the audio destination (see table below)</li>\n<li>filename - the pathname of the audio file, relative to the HSYCO’s main directory</li>\n<li>voicename - the voice name for the text-to-speech engine; see the <a href=\"/3.8/index.php/Audio_and_Public_Announcement\" title=\"Audio and Public Announcement\">Audio and Public Announcement</a> section for additional information</li>\n<li>message - the text message for text-to-speech conversion; you can use multiple strings that will be automatically appended.</li></ul><p><br>\n</p><table class=\"wikitable\" width=\"600\">\n<tbody><tr>\n<th>Audio Destination\n</th>\n<th>Description\n</th></tr>\n<tr>\n<td width=\"150\">speaker\n</td>\n<td>the server’s audio line out connector\n</td></tr>\n<tr>\n<td>web<br>web@channel\n</td>\n<td>the Web browser’s audio output. \"channel\" can be the project id or an an arbitrary name assigned to an audio channel set using the \"audiochannel\" project attribute.\n<p>If \"*\" or no channel is specified, the audio will play on all clients.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>this feature is supported only on Firefox and Chrome browsers</b>\n</p>\n</td></tr>\n<tr>\n<td>axis@camera id\n</td>\n<td>audio sent to an Axis camera, using the camera id defined in the Cameras parameter in hsyco.ini\n</td></tr>\n<tr>\n<td>axis@host name\n</td>\n<td>audio sent to an Axis geric audio device. Use the host name or IP address of the device. The device must allow anonymous commands via HTTP on the default port 80\n</td></tr>\n<tr>\n<td>axis@host:user:password name\n</td>\n<td>audio sent to an Axis geric audio device. Use the host name or IP address of the device, authenticating with user and password. The device must allow commands via HTTP on the default port 80\n</td></tr>\n<tr>\n<td>snom@ip:port\n</td>\n<td>audio sent to SNOM phones and public announcement devices, to the multicast IP address and port specified (the IP address and port should be configured as multicast addresses on each phone)\n</td></tr>\n<tr>\n<td>io@I/O server id[.zone id]\n</td>\n<td>audio sent to I/O servers with audio playback capabilities, e.g. the Sonos I/O server\n</td></tr></tbody></table><p><br>\n<b>Examples:</b>\n</p><p>The gong.mp3 audio file is played every minute through the server’s audio line out or internal speaker:\n</p><pre>TIME : audio speaker = file \"audio/gong.mp3\"\n</pre><p>Same as above, but played at the same time on all phones registered to the 239.255.255.245 multicast address and port 5555:\n</p><pre>TIME : audio snom@239.255.255.245:5555 = file \"audio/gong.mp3\"\n</pre><p>Same as above, but played to the Axis camera with id \"cam1\":\n</p><pre>TIME : audio axis@cam1 = file \"audio/gong.mp3\"\n</pre><p>Converts a text message to speech using the \"en\" voice of the text-to-speech engine, and play the audio on an Axis camera:\n</p><pre>TIME : audio axis@cam1 = \"voice:en\" \"the time is \" $time:h:m$\n</pre><p>Same as above, but played by web browser with Acapela \"Ryan\" voice:\n</p><pre>TIME : audio web = \"voice:ryan22k\" \"the time is \" $time:h:m$\n</pre>",
	content:"AUDIO ${1:to} = FILE ${2:filename}"
});
a.push({
	title:"AUDIO to = VOICE:voicename message",
	subTitle:"Actions, Public Announcement",
	docHTML:a.last().docHTML,
	content:"AUDIO ${1:to} = VOICE${2::voicename} ${3:message}"
});
a.push({
	title:"COMM name = hexbytes",
	subTitle:"Actions, Serial Communication Ports",
	docHTML:"<p>Sends a sequence of bytes to the specified communication port.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>COMM name = hexbytes\n</td>\n<td>sends bytes to a serial port\n</td></tr></tbody></table><p><br>\n<img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>If both verboseLog and userLog are set to true, the full trace of sent bytes is written to the log file.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - the name of the communications port, as defined in the CommPorts parameter in hsyco.ini</li>\n<li>hexbytes - string with the hexadecimal representation of the sequence of bytes to be sent. You can use multiple unquoted words, quoted strings and variables, that will be appended to generate the byte stream sent to the communication port.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>COMM serialport =  FE03C9104B27\nCOMM serialport =  FE $body 27\n</pre>",
	content:"COMM ${1:name} = ${2:hexbytes}"
});
a.push({
	title:"MUSIC address =  ON",
	subTitle:"Actions, Squeezebox",
	docHTML:"<p>Controls the Squeezebox players.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>MUSIC address =  ON\n</td>\n<td>turns the player on\n</td></tr>\n<tr>\n<td>MUSIC address = OFF\n</td>\n<td>turns the player off\n</td></tr>\n<tr>\n<td>MUSIC address = PLAY\n</td>\n<td>starts playing music in the active playlist\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>address - player number, starting from 0 for the first player, based on the listing order of the slimPlayers parameter in hsyco.ini.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>MUSIC 0 = ON\nMUSIC 1 = PLAY\n</pre>",
	content:"MUSIC ${1:address} =  ON"
});
a.push({
	title:"MUSIC address = OFF",
	subTitle:"Actions, Squeezebox",
	docHTML:a.last().docHTML,
	content:"MUSIC ${1:address} = OFF"
});
a.push({
	title:"MUSIC address = PLAY",
	subTitle:"Actions, Squeezebox",
	docHTML:a.last().docHTML,
	content:"MUSIC ${1:address} = PLAY"
});
a.push({
	title:"USERTIMERSET timerid = on hour minute duration days",
	subTitle:"Actions, Timers and Schedulers",
	docHTML:"<p>Sets a user timer.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"400\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>USERTIMERSET timerid = on hour minute duration days\n</td>\n<td>set the user timer\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>on - true enables the timer; false disables the timer; null or empty string leaves the mode unchanged</li>\n<li>hour - start hour, from 0 to 23; null or empty string leaves the start hour unchanged</li>\n<li>minute - start minute, from 0 to 59; null or empty string leaves the start minute unchanged</li>\n<li>duration - duration in minutes, from 0 to 1439; null or empty string leaves the duration unchanged</li>\n<li>days - activation days, as a string of up to 7 characters from 1 to 7, 1 is Monday, 7 is Sunday; null or empty string leaves the days unchanged.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>USERTIMERSET t1 = TRUE 11 50 null 67\n</p><p>enables timer \"t1\", setting the start time at 11:50, Saturday and Sunday, leaving the duration unchanged.\n</p>",
	content:"USERTIMERSET ${1:timerid} = ${2:on} ${3:hour} ${4:minute} ${5:duration} ${6:days}"
});
a.push({
	title:"UISESSIONSET id.attr = value",
	subTitle:"Actions, User Interface",
	docHTML:"<p>Changes the dynamic attributes of an identified GUI object, just like UISET, but only affects the client session that generated the event that triggered this action.\n</p><p>UISESSIONSET can only be used with PAGE and USER events, and will override settings made with UISET.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"200\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>UISESSIONSET id.attr = value\n</td>\n<td>id is the unique name that identifies the object, specified in the index.hsm file with the extension  !id after the object type\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>id - object id</li>\n<li>attr - attribute name</li>\n<li>value - attribute value. You can use multiple unquoted words, quoted strings and variables, that will be appended to form the value parameter.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>USER mybutton = 1 : UISESSIONSET mytext.style = italic\n</pre>",
	content:"UISESSIONSET ${1:id.attr} = ${2:value}"
});
a.push({
	title:"UISET id.attr = value",
	subTitle:"Actions, User Interface",
	docHTML:"<p>Changes the dynamic attributes of an identified GUI object.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>UISET id.attr = value\n</td>\n<td>id is the unique name that identifies the object, specified in the index.hsm file with the extension  !id after the object type\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>id - object id. You can also target all objects of a type by specifying as id \"(<object's type>)\" (e.g. \"UISET (user).fontweight = bold\" will target all user objects)</li>\n<li>attr - attribute name</li>\n<li>value - attribute value. You can use multiple unquoted words, quoted strings and variables, that will be appended to form the value parameter.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>UISET mytext.style = italic\nUISET mychart.barcolor =\"#000000\"\n</pre>",
	content:"UISET ${1:id.attr} = ${2:value}"
});
a.push({
	title:"USER name = param",
	subTitle:"Actions, User Interface",
	docHTML:"<p>Triggers a USER event and the userCommand(String name, String param) Java method and JavaScript function.\n</p><p>Can be used like a function call in EVENTS, and as a calling mechanism between EVENTS, JavaScript and Java.\n</p><table class=\"wikitable\">\n<tbody><tr>\n<td width=\"160\"><b>Action</b>\n</td>\n<td><b>Description</b>\n</td></tr>\n<tr>\n<td>USER name = param\n</td>\n<td>\n<p>executes the  userCommand(name, param) Java method and JavaScript function, and the USER name = param event.<br>\nEither name or param can be omitted, and will be passed as empty strings, but not both\n</p>\n</td></tr></tbody></table><p><br>\n<b>Parameters:</b>\n</p><ul><li>name - passed as the name parameter to USER and userCommand(). You can use multiple unquoted words, quoted strings and variables, that will be appended to form the name parameter</li>\n<li>param - passed as the param parameter to USER and userCommand(). You can use multiple unquoted words, quoted strings and variables, that will be appended to form the param parameter.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>USER hometheater = \"on\"\nUSER hometheater = \"changed\" $newvalue\n</pre>",
	content:"USER ${1:name} = ${2:param}"
});



var a = s.events;
a.push({
	title:"function DaylightEvent(day)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Called at sunrise and sunset, according to the latitude and longitude values set in hsyco.ini, and the optional SunriseOffsetMinutes and SunsetOffsetMinutes parameters.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>day:  boolean - true at sunrise, false at sunset.</li></ul>",
	content:"function DaylightEvent(day) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function haActiveEvent(active)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Triggered by the change of state of an HSYCO server in a master/slave high availability configuration.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>active:  boolean - true if the server is active, false if not active.</li></ul>",
	content:"function haActiveEvent(active) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function PowerEvent(power)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Triggered by a change of the current power load level, as set using the powerSet() Java API or the POWER action.\n</p><p>Thanks to this function, you can alter the power value shown in the Web interface, for example to aggregate power readings acquired from other sensors.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>power: numeric - the power level, in Watts.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - if PowerEvent() returns -1 or doesn't return a value, HSYCO status is updated with the detected power value, the value returned by PowerEvent() is otherwise used.</li></ul><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The JavaScript PowerEvent function is always called, but its return value is used only when the Java PowerEvent callback is not defined or returned -1.</b>\n</p>",
	content:"function PowerEvent(power) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function programTimerEvent(name)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Called when a program timer is activated.\n</p><p>Program timers are set using <a href=\"/3.8/index.php/Java_Command_and_Utility_Methods_API#programTimerSet\" title=\"Java Command and Utility Methods API\">programTimerSet()</a>, <a href=\"/3.8/index.php/Java_Command_and_Utility_Methods_API#programTimerReset\" title=\"Java Command and Utility Methods API\">programTimerReset()</a>, <a href=\"/3.8/index.php/Java_Command_and_Utility_Methods_API#programTimerRepeat\" title=\"Java Command and Utility Methods API\">programTimerRepeat()</a>, or using the corresponding actions in EVENTS.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - program timer name.</li></ul>",
	content:"function programTimerEvent(name) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function SchedulerEvent(groupname, schedulename)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>This callback blocking function allows to call user methods at configurable intervals.\n</p><p>Schedules are defined using a group name and a schedule name.\n</p><p>Schedules under the same group run in the same thread and are executed sequentially, based on their interval in milliseconds. Schedules in different groups run in parallel.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>groupname: string - the scheduler’s group name</li>\n<li>schedulename: string - the scheduler’s name.</li></ul>",
	content:"function SchedulerEvent(groupname, schedulename) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function StartupEvent()",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Called only once when HSYCO starts, after the initialization and HTTP server start-up, but before the execution of the different field interface threads. It is not executed in a thread, it is therefore a blocking method, that must complete its execution before all other HSYCO services can be started.\n</p>",
	content:"function StartupEvent() : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function SunPositionEvent(azimuth, elevation)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Called when the Sun changes its height with respect to the horizon or its angle from true north.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>azimuth: numeric - the current Sun angle from true north, in decimal degrees</li>\n<li>elevation: numeric - the current Sun elevation in decimal degrees from the horizon. Elevation is negative at night.</li></ul><p><br>\n</p>",
	content:"function SunPositionEvent(azimuth, elevation) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function TimeEvent(time)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Called every 60 seconds.\n</p><p>HSYCO tries to synchronize the execution at the beginning of the minute, executing this method at seconds 0 of every minute.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>However, the execution is not guaranteed. In case of heavy load HSYCO might not be able to execute the call with accurate timing. In extreme cases, it could  occasionally skip some calls.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>time: numeric - the current time in milliseconds.</li></ul><p><br>\n</p>",
	content:"function TimeEvent(time) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function varEvent(name, value)",
	subTitle:"Javascript Callback Functions, System Functions",
	docHTML:"<p>Triggered by the change of value of a program variable.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the variable name. Names are case-insensitive</li>\n<li>value: string - the value to be assigned to the program variable.</li></ul>",
	content:"function varEvent(name, value) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function CameraCommandEvent(camerafunction, action, camera)",
	subTitle:"Javascript Callback Functions, Cameras",
	docHTML:"<p>Triggered by a camera control input from the Web interface.\n</p><p>It can be used to execute arbitrary actions when the user clicks on the active areas of the camera view, or to replace some or all of the standard PTZ commands with custom actions.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>camerafunction: string - see the table below</li>\n<li>action: string - see the table below</li>\n<li>camera: string - the camera name.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - if CameraCommandEvent() returns -1 or doesn't return a value, the standard PTZ command associated to the PTZ driver is skipped, otherwise it is executed normally.</li></ul><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The JavaScript CameraCommandEvent camerafunction is always called, but its return value is used only when the Java CameraCommandEvent callback is not defined or returned -1.</b>\n</p>",
	content:"function CameraCommandEvent(camerafunction, action, camera) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function CameraMotionEvent(event, time)",
	subTitle:"Javascript Callback Functions, Cameras",
	docHTML:"<p>Called when HSYCO starts recording video from a camera.\n</p><p>Recording starts when a camera notifies a recording request with the recording HTTP API call (the zone=id portion is optional):\n</p><pre><b>http://192.168.0.50/x/camerarec?camera=name&zone=id</b>\n</pre><p>Recording can also be triggered by the CameraRecTrigger() Java method or JavaScript function, or the CAMERAREC or CAMERARECFULL actions in EVENTS.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>event: string - the event identification string, either the camera name only or name:id if recording is triggered by a camerarec HTTP call with the optional zone=id parameter</li>\n<li>time: numeric - the current time in milliseconds.</li></ul>",
	content:"function CameraMotionEvent(event, time) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function CameraViewEvent(camera, active)",
	subTitle:"Javascript Callback Functions, Cameras",
	docHTML:"<p>CameraViewEvent() is called on changes of the live view status of cameras.\n</p><p>When at least one web client is showing the live feed from a camera, the camera is marked as active.\n</p><p>When no live feed request is received for a several consecutive seconds, the camera is marked as not active.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>camera: string - the camera name</li>\n<li>active: boolean - true if active, false if not.</li></ul>",
	content:"function CameraViewEvent(camera, active) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function DmxEvent(channel, state)",
	subTitle:"Javascript Callback Functions, DMX",
	docHTML:"<p>Called after changes to DMX-512 channels.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>channel: numeric - DMX channel address, from 1 to 512 which might be preceded by the DMX gateway number, starting from 0</li>\n<li>state: numeric - the new channel value, from 0 to 255.</li></ul><p><br>\n</p>",
	content:"function DmxEvent(channel, state) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function DmxFilter(channel, state, reverse)",
	subTitle:"Javascript Callback Functions, DMX",
	docHTML:"<p>This function allows to filter the value of the status of each channel on the DMX-512 buses, sending to the gateway different values from those set in HSYCO.\n</p><p>This way, it is possible to apply chromatic corrections, or any on the fly translation of channels values.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>This is a blocking function and is called when sending commands to the DMX gateway.</b>\n</p><p>It is also called after reading current channels values from the gateway. In this case the conversion function should be symmetric and return a complementary value.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>channel: numeric - the DMX channel address, from 1 to 512 which might be preceded by the DMX gateway number, starting from 0</li>\n<li>state: numeric - the unfiltered value of the channel, from 0 to 255</li>\n<li>reverse: boolean - false if called when writing to the gateway; true if called when reading from the gateway.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - the channel value that will be sent to the DMX gateway.</li></ul><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The JavaScript DmxFilter function is called only when the Java DmxFilter callback is not defined or returned the original value.</b>\n</p><p><br>\n</p>",
	content:"function DmxFilter(channel, state, reverse) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function DmxStartupEvent(index)",
	subTitle:"Javascript Callback Functions, DMX",
	docHTML:"<p>Called when starting the monitor threads for each DMX bus, once per bus at the start of the execution of HSYCO, and also after every restart of the monitor thread, for example after communication errors.\n</p><p>It is safe, inside this function, to execute commands for the same DMX gateway.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>This is a blocking function. The DMX driver will start after this function returns.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>Index: numeric - number of the DMX bus, starting from 0.</li></ul>",
	content:"function DmxStartupEvent(index) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function IREvent(received, irtransid, event)",
	subTitle:"Javascript Callback Functions, Infrared Control",
	docHTML:"<p>This function is called when an IRTrans receives or sends an IR command from its local IR database.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>IRTrans can only receive and decode infrared commands that have been previously stored in its internal FLASH memory database.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>received: boolean - true if the command has been received by the IRTrans, false if sent</li>\n<li>irtransid: numeric - IRTrans number, starting from 0 for the first device, based on the listing order of the IRTrans parameter in hsyco.ini</li>\n<li>event: string - the string of the command received or issued, formatted as: \"remote_name,command\".</li></ul>",
	content:"function IREvent(received, irtransid, event) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function IOEvent(name, value)",
	subTitle:"Javascript Callback Functions, I/O Servers",
	docHTML:"<p>Triggered by the value change of any data point of an I/O server.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>id: string - the server id and the name of the data point. According to the type of server, the format changes but it generally appears as server name, as declared the ioServers parameter in hsyco.ini, followed by a specific name representing the data point within the system</li>\n<li>value: string - the new value. For binary inputs or outputs, the returned values are \"0\" or \"1\".</li></ul><p><br>\n</p>",
	content:"function IOEvent(name, value) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function IOStartupEvent(index)",
	subTitle:"Javascript Callback Functions, I/O Servers",
	docHTML:"<p>Triggered by the start of the communication thread of each I/O server - once for each server at the beginning of the execution of HSYCO, and also after every reboot of the communication thread, for example after communication errors.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>This is a blocking method. The I/O server driver will start after this function returns.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>index: numeric - the I/O server number, starting from 0, based on the listing order of the ioServers parameter in hsyco.ini.</li></ul><p><br>\n</p>",
	content:"function IOStartupEvent(index) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function ModbusEvent(name, addr, unitid, pdu)",
	subTitle:"Javascript Callback Functions, Modbus",
	docHTML:"<p>Called by the Modbus Server I/O Server on every Modbus request received from a Modbus client.\n</p><p>The returned byte array is used as the Modbus response PDU (function code and data).\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the name of the Modbus Server I/O server</li>\n<li>addr: string - IP address of the Modbus client</li>\n<li>unitid: numeric - the unit id set in the received Modbus request</li>\n<li>pdu: string - the request PDU data, in hexadecimal string format.</li></ul><p><b>Returns:</b>\n</p><ul><li>string - the response PDU data, in hexadecimal string format.</li></ul><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The JavaScript ModbusEvent function is called only when the Java ModbusEvent callback is not defined or returned a null value.</b>\n</p>",
	content:"function ModbusEvent(name, addr, unitid, pdu) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function LocationEvent(mac, ip, zoneId)",
	subTitle:"Javascript Callback Functions, Location Services",
	docHTML:"<p>Called, if the location service is active, when a variation in the association of a client to the Wi-Fi Access Points is detected.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>mac: string - the MAC address of the client</li>\n<li>ip: string - the IP address of the client, if available, or null (the IP address could be null if the associated device is not connected to the HSYCO Web interface)</li>\n<li>zoneId: numeric - in case of association, it is the Access Point sequence number,  according to the order defined in the LocationBases parameter in hsyco.ini; -1 if the client was de-associated from the Wi-Fi network.</li></ul>",
	content:"function LocationEvent(mac, ip, zoneId) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function LocationBeaconEvent",
	subTitle:"Javascript Callback Functions, Location Services",
	docHTML:"<div style=\"color:#CC0000\"><b><div class=\"note note-reminder\"><center>WARNING! The Beacons functionality for iOS is experimental and subject to changes.</center></div></b>\n<p><b></b>\n</p>\n</div><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>LocationBeaconEvent(session, address, userid, zone, distance, background)</pre></div><p>Called when the HSYCO App detects a change in the proximity of one of the configured beacons. See <a href=\"/3.8/index.php/Beacons_on_HSYCO_App_for_iOS\" title=\"Beacons on HSYCO App for iOS\">Beacons on HSYCO App for iOS</a> for additional information.\n</p><p>There is no guarantee that the event would be fired.\n</p><p>Network delays or errors could cause delayed triggering of this event.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>session: string - session id string that uniquely identifies the client session</li>\n<li>address: string - the beacon's address</li>\n<li>userid: string - the user id</li>\n<li>zone: string - the beacon's zone</li>\n<li>distance: string - far, near, immediate or off</li>\n<li>background: boolean - true if the app called the server while in background mode (app closed).</li></ul>",
	content:"function LocationBeaconEvent : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function LocationGeoEvent(session, address, userid, lat, lon, alt, speed, course, ah, av, as, ac, background)",
	subTitle:"Javascript Callback Functions, Location Services",
	docHTML:"<p>Called when a geographic location notification is sent by an HSYCO iOS or Android app.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>session: string - session id string that uniquely identifies the client session</li>\n<li>address: string - the beacon's address</li>\n<li>userid: string - the user id</li>\n<li>lat: numeric - geographic coordinates latitude, in decimal degrees (positive east, negative west)</li>\n<li>lon: numeric - geographic coordinates longitude, in decimal degrees (positive north, negative south)</li>\n<li>alt: numeric - altitude, in meters</li>\n<li>speed: numeric - speed, in meters per second</li>\n<li>course: numeric - course, in decimal degrees</li>\n<li>ah: numeric - radius of uncertainty for the location, in meters</li>\n<li>av: numeric - accuracy of the altitude value, in meters</li>\n<li>as: numeric - accuracy of the speed value, in meters per second</li>\n<li>ac: numeric - accuracy of the course value, in degrees</li>\n<li>background: boolean - true if the app called the server while in background mode (app closed).</li></ul>",
	content:"function LocationGeoEvent(session, address, userid, lat, lon, alt, speed, course, ah, av, as, ac, background) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function httpCallEvent(address, secure, query)",
	subTitle:"Javascript Callback Functions, Network Services",
	docHTML:"<p>Called when the HSYCO HTTP server receives a GET request with the following path:\n</p><pre>/x/httpcall?query\n</pre><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The HTTP client's IP address must be in the trusted network range, or the httpcall request will be rejected, unless HTTPServerLowSecurityEnabled is true and the request is sent using HTTPS</b>\n</p><p>This function shoud return a string, that will be sent as the text/plain answer to the HTTP client (with HTTP response code 200).\n</p><p>HSYCO will return a 404 Not Found response code if all of the following conditions are true:\n</p><ul><li>no HTTP event matches the query in EVENTS</li>\n<li>the httpCallEvent JavaScript callback is not defined in EVENTS, or doesn't return a value</li>\n<li>the httpCallEvent Java callback is not defined in user.java or in any plugins, or returns null.</li></ul><p>If the httpCallEvent is defined both in JavaScript and Java, the Java version return value (unless null) will be used in the HTTP response.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>address: string - the IP address of the HTTP client</li>\n<li>secure: boolean - true if the request is sent to the HTTPS server, false if the request is sent to the HTTP server</li>\n<li>query: string - the string following the ? in the URL path.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - the string to send as the text/plain answer to the HTTP client.</li></ul>",
	content:"function httpCallEvent(address, secure, query) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function httpRawEvent(host, secure, version, httpmethod, gzip, contenttype, query, session, userid, indata)",
	subTitle:"Javascript Callback Functions, Network Services",
	docHTML:"<p>Called when the HSYCO HTTP server receives a GET or POST request with the following path:\n</p><pre>/x/raw\n</pre><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>httpRawEvent is called only if the HTTP client's IP address is in the trusted network range and the HTTPServerLowSecurityEnabled option is true, or if the request has a valid user authentication cookie</b>\n</p><p>The application code inside the httpRawEvent() function should return a complete HTTP response (both headers and body).\n</p><p>If multiple httpRawEvent() callbacks or functions are defined, only one should write the HTTP response.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>host: string - the IP address of the HTTP client</li>\n<li>secure: boolean - true if the request is sent to the HTTPS server, false if the request is sent to the HTTP server</li>\n<li>version: string - the HTTP version, as passed in the HTTP request header</li>\n<li>httpmethod: string - the HTTP request's method, \"GET\", \"POST\" or \"HEAD\"</li>\n<li>gzip: boolean - true if the client accepts compressed content (the Accept-Encoding header contains \"gzip\")</li>\n<li>contenttype: string - the HTTP request's content type (value of Content-Type header)</li>\n<li>query: string - the string following the ? in the URL path, or null if not present</li>\n<li>session: string - the authenticated session id, or null</li>\n<li>userid: string - the user id for requests having a valid authentication cookie, null otherwise</li>\n<li>indata: string - the POST data, or an empty string for GET or HEAD requests.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - the application code should return the full HTTP response, including all headers.</li></ul><p><br>\n<b>Example:</b>\n</p><pre>function httpRawEvent(host, secure, version, httpmethod, gzip, contenttype, query, session, userid, indata) : {\n\tmessageLog(\"host: \" + host);\n\tmessageLog(\"secure: \" + secure);\n\tmessageLog(\"version: \" + version);\n\tmessageLog(\"httpmethod: \" + httpmethod);\n\tmessageLog(\"gzip: \" + gzip);\n\tmessageLog(\"contenttype: \" + contenttype);\n\tmessageLog(\"query: \" + query);\n\tmessageLog(\"session: \" + session);\n\tmessageLog(\"userid: \" + userid);\n\tmessageLog(\"in: \" + indata);\n\t\n\tvar outdata = httpmethod + \" data echoed from host [\" + host + \"] : \" + indata + \"\r\n\";\n\tvar httpreply = version + \" 200 OK\r\n\";\n\thttpreply += \"Server: HSYCO\r\n\";\n\thttpreply += \"Content-length: \" + outdata.length + \"\r\n\";\n\thttpreply += \"Content-type: text/plain\r\n\";\n\thttpreply += \"Cache-Control: no-store, no-cache\r\n\r\n\";\n\thttpreply += outdata;\n\treturn httpreply;\n}\n</pre>",
	content:"function httpRawEvent(host, secure, version, httpmethod, gzip, contenttype, query, session, userid, indata) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function SysLogEvent(address, log)",
	subTitle:"Javascript Callback Functions, Network Services",
	docHTML:"<p>Called when the HSYCO SYSLOG server receives a log message from a network client.\n</p><p>Note that this is a blocking call. The SYSLOG server will not process further messages until the last call has been processed.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>address: string - the IP address of the SYSLOG client</li>\n<li>log: string - SYSLOG log message.</li></ul>",
	content:"function SysLogEvent(address, log) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function PBXCallEvent(host, caller, called)",
	subTitle:"Javascript Callback Functions, PBX",
	docHTML:"<p>Called when a call notification is sent to HSYCO by the PBX system.\n</p><p>If the method returns true, the request is recorded on the log file with the [OK] status, with [ERROR] otherwise.\n</p><p>The PBX should generate HTTP requests to the HSYCO Web Server, using the following formats:\n</p><pre>http://192.168.0.50/x/vcall/<from>/<to>\n</pre><p>or:\n</p><pre>http://192.168.0.50/x/vcall?from=<from>&to=<to>\n</pre><p>For example, the HTTP request:\n</p><pre>http://192.168.0.50/x/vcall?from=21&to=25\n</pre><p>is interpreted as a call notification from internal number 21 to number 25.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The HTTP client's IP address must be in the trusted network range, or the httpcall request will be rejected.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>host: string - the IP address of the PBX server</li>\n<li>caller: string - the caller number</li>\n<li>called: string - the called number.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - return true to generate a log entry with [OK] status, false for [ERROR] status.</li></ul>",
	content:"function PBXCallEvent(host, caller, called) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function SlimPowerEvent(index, power)",
	subTitle:"Javascript Callback Functions, Squeezebox",
	docHTML:"<p>Called when a Squeezebox player is turned on or off.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>index: numeric - player number, starting from 0 for the first player, based on the listing order of the slimPlayers parameter in hsyco.ini</li>\n<li>power: numeric - 0: OFF, 1: ON.</li></ul>",
	content:"function SlimPowerEvent(index, power) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function SlimStatusEvent()",
	subTitle:"Javascript Callback Functions, Squeezebox",
	docHTML:"<p>Called when a Squeezebox player changes its playback mode.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>index: numeric - player number, starting from 0 for the first player, based on the listing order of the slimPlayers parameter in hsyco.ini</li>\n<li>status: numeric - 0: OFF, 1: ON, 2: PAUSE, 3: PLAY, -1: UNKNOWN.</li></ul><p><br>\n</p>",
	content:"function SlimStatusEvent() : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function SlimVolumeEvent(index, volume)",
	subTitle:"Javascript Callback Functions, Squeezebox",
	docHTML:"<p>Called when a Squeezebox player changes its volume level.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>index: numeric - player number, starting from 0 for the first player, based on the listing order of the slimPlayers parameter in hsyco.ini</li>\n<li>volume: numeric - an integer number representing the volume change (not the absolute audio level) in a scale from 0 to 100; positive numbers correspond to a volume increase, negative numbers to a decrease.</li></ul><p><br>\n</p>",
	content:"function SlimVolumeEvent(index, volume) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function UserTimerEvent(name, active)",
	subTitle:"Javascript Callback Functions, Timers and Schedulers",
	docHTML:"<p>Called when a user timer or scheduler’s rule should be activated, and before executing the associated action in EVENTS.\n</p><p>It is also executed at the timer or scheduler’s rule deactivation.\n</p><p>This method must return a true value in order to make the timer or rule actually active and the associated actions executed.\n</p><p>Whenever the method returns false, the timer will not be activated, and the method will be called again once a minute for the scheduled duration of the timer.\n</p><p>In the same way, if the method returns false when the timer or rule is deactivated, the timer or rule will not be deactivated, extending the timer activation beyond the scheduled duration.\n</p><p>This is a blocking method.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - timer name or scheduler’s rule name</li>\n<li>active: boolean - true when activating and false when deactivating the timer or scheduler’s rule.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true to confirm the timer event, false to block the event.</li></ul><p><br>\n<img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The JavaScript UserTimerEvent function is alway called, but its return value is used only when the Java UserTimerEvent callback is not defined or returned true.</b>\n</p><p><br>\n</p>",
	content:"function UserTimerEvent(name, active) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function pageEvent(address, session, userid, project, page)",
	subTitle:"Javascript Callback Functions, User Interface",
	docHTML:"<p>Called when a Web client initially loads a project and when navigating between pages.\n</p><p>There is no guarantee that the event would be fired the exact moment the page is loaded.\n</p><p>Network delays or errors could cause delayed triggering of this event.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>address: string - the client’s IP address</li>\n<li>session: string - session id string that uniquely identifies the client session</li>\n<li>userid: string - the user id</li>\n<li>project: string - project’s id</li>\n<li>page: string -  the page id, with the #landscape or #portrait suffix if the page has distinct orientation versions in the project.</li></ul>",
	content:"function pageEvent(address, session, userid, project, page) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function loginEvent(address, session, userid)",
	subTitle:"Javascript Callback Functions, User Interface",
	docHTML:"<p>Called when a user authenticates with a valid PIN or PIN/PUK.\n</p><p>Note that, while the session string passed to the pageEvent callback contains the browser global session id followed by a web view id, the session string passed to loginEvent only contains the global session id. The global session id is the portion of session id that is common between multiple web views open concurrently on the same web browser.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>address: string - the client’s IP address string in textual presentation</li>\n<li>session: string - session id string that uniquely identifies the client session</li>\n<li>userid: string - the user id.</li></ul>",
	content:"function loginEvent(address, session, userid) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function logoutEvent(address, session, userid, lock)",
	subTitle:"Javascript Callback Functions, User Interface",
	docHTML:"<p>Called when a user logs out or locks the user interface.\n</p><p>Note that, while the session string passed to the pageEvent callback contains the browser global session id followed by a web view id, the session string passed to logoutEvent only contains the global session id. The global session id is the portion of session id that is common between multiple web views open concurrently on the same web browser.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>address: string - the client’s IP address string in textual presentation</li>\n<li>session: string - session id string that uniquely identifies the client session</li>\n<li>userid: string - the user id</li>\n<li>lock: boolean - false when logging out; true when the user locks the user interface.</li></ul>",
	content:"function logoutEvent(address, session, userid, lock) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function uiClearEvent(session)",
	subTitle:"Javascript Callback Functions, User Interface",
	docHTML:"<p>Called, following an explicit call of uiClear() or after the client session inactivity timeout expires, if the client session becomes active again (i.e. the client starts handshaking again with the server with the same session id).\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>session: string - session id string that uniquely identifies the client session.</li></ul>",
	content:"function uiClearEvent(session) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function userCommand(session, userid, name, param)",
	subTitle:"Javascript Callback Functions, User Interface",
	docHTML:"<p>Called by user clicks on buttons created in the Web interface with the <a href=\"/3.8/index.php/User\" title=\"User\">user objects</a>, by a USER action in EVENTS, or by the user() Java method and JavaScript function.\nAlso triggered by by the screensaver (see the <b><a href=\"/3.8/index.php/Screensaver\" title=\"Screensaver\"> Screensaver</a></b> page for more details).\n</p><p>This function can optionally return a string. Any returned string causes the log of an [OK] status. If you want to prevent logging, for example to avoid sensitive information to be written in the log file, you should return the string \"!\".\n</p><p>If you want to navigate to a specific page when the button is pressed (it would be like pressing a <a href=\"/3.8/index.php/Link\" title=\"Link\">Link object</a>), return a string starting with \"page:\" followed by the page name; in this case, userCommand() will be called again when that popup or page is closed, with \"/close\" appended to param.\n</p><p>You can also use \"page:back\" or \"page:forward\" to move back and forth along the pages' navigation history. Use \"page:close\" to close a popup.\n</p><p>When the interface is loaded inside the HSYCO App (<a href=\"/3.8/index.php/HSYCO_App_for_iOS_Devices\" title=\"HSYCO App for iOS Devices\">iOS</a> or <a href=\"/3.8/index.php/HSYCO_App_for_Android_Devices\" title=\"HSYCO App for Android Devices\">Android</a>), you can send a specific command to the app by returning a string that starts with \"app:\" followed by the command; the commands currently supported are \"speech\", which enables the speech recognition, and \"codescan\" which enables qr/bar code scanning.\n</p><p>Use \"copy:<text>\" to copy a text in the clipboard.\nIn the HSYCO App you can also use \"share:<text>\" to open a popup with various options. This will behave like \"copy\" on browser.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>As this callback may return data synchronously to the Web interface in response to a user command, its execution should be fast enough to avoid the timeout of the browser's request. To ensure a safe margin, it should complete in no more than one second.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>session: string - a session id string that uniquely identifies the client session</li>\n<li>userid: string - the user id</li>\n<li>name: string - the name field of the <a href=\"/3.8/index.php/User\" title=\"User\">user object</a></li>\n<li>param: string - the param of the <a href=\"/3.8/index.php/User\" title=\"User\">user object</a></li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - log or go to page, see text above. If this function doesn't return a value, an [ERROR] status is logged in the log file, while any other string causes the log of an [OK] status.</li></ul><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The JavaScript userCommand function is alway called, but its return value is used only when the Java userCommand callback is not defined or returned null or an empty string.</b>\n</p>",
	content:"function userCommand(session, userid, name, param) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function userSubmit(session, userid, name, fields)",
	subTitle:"Javascript Callback Functions, User Interface",
	docHTML:"<p>This function is similar to userCommand(session, userid, name, param).\n</p><p>When userSubmit() is defined, it will be called when a <a href=\"/3.8/index.php/Submit\" title=\"Submit\">submit button</a> is pressed, while userCommand() will continue to be called on <a href=\"/3.8/index.php/User\" title=\"User\">user buttons</a>.\n</p><p>userSubmit() provides a more convenient access to the values of multiple input fields in a form.\n</p><p>This function can optionally return a string. Any returned string causes the log of an [OK] status. If you want to prevent logging, for example to avoid sensitive information to be written in the log file, you should return the string \"!\".\n</p><p>If you want to force the Web interface to show a specific page after the button is pressed (it would be like pressing a <a href=\"/3.8/index.php/Link\" title=\"Link\">link object</a>), return a string starting with \"page:\" followed by the page name; in this case, userCommand() will be called when that popup or page is closed, with \"/close\" appended to param.\n</p><p>You can also use \"page:back\" or \"page:forward\" to move back and forth along the pages' navigation history. Use \"page:close\" to close a popup.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>As this callback may return data synchronously to the Web interface in response to a user command, its execution should be fast enough to avoid the timeout of the browser's request. To ensure a safe margin, it should complete in no more than one second.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>session: string - a session id string that uniquely identifies the client session</li>\n<li>userid: string - the user id</li>\n<li>name: string - the id of the (submit!id) object</li>\n<li>fields: array - the array of all input fields in the container where the (submit) object is located.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - log or go to page, see text above. If this function doesn't return a value, an [ERROR] status is logged in the log file, while any other string causes the log of an [OK] status.</li></ul><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The JavaScript userSubmit function is alway called, but its return value is used only when the Java userCommand or userSubmit callback are not defined or returned null or an empty string.</b>\n</p><p><br>\n<b>Examples:</b>\n</p><p>The following code shows how to retrieve all field names and values of a submitted form.\n</p><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>function userSubmit(session, user, name, values) : {\n\tif (session.length > 0) {\n\t\tmessageLog(user + ', ' + name + '=' + values);\n\t\tvar keys = values.keySet().toArray();\n\t\tfor (var i = 0; i < keys.length; i++) {\n\t\t\tmessageLog(user + ', ' + keys[i] +  ' = ' + values.get(keys[i]));\n\t\t}\n\t\treturn \"\";\n\t}\n}</pre></div><p>Create a project with a form and a few input fields in a container. Pressing the submit button should return something like this in the log file:\n</p><pre>2014.01.31 13:54:32.034 - staff, submit1={keypad1=344, date1=20140131, input1=this is a text field} \n2014.01.31 13:54:32.038 - staff, keypad1 = 344 \n2014.01.31 13:54:32.039 - staff, date1 = 20140131 \n2014.01.31 13:54:32.042 - staff, input1 = this is a text field \n2014.01.31 13:54:32.043 - WEB USER COMMAND [submit1]: input1@this is a text field@date1@20140131@keypad1@344 [OK]\n</pre>",
	content:"function userSubmit(session, userid, name, fields) : {\n\t${1:// body...} \n}"
});
a.push({
	title:"function WebRootRequestEvent(addr, secure, useragent)",
	subTitle:"Javascript Callback Functions, User Interface",
	docHTML:"<p>This method is called when the Web server receives a root URL request. It can return a string to redirect the browser to a valid URL, or null to prevent redirection.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>As this callback returns data synchronously to the Web interface in response to the HTTP request, its execution should be fast enough to avoid the timeout of the browser's request. To ensure a safe margin, it should complete in no more than one second.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>addr: string - the HTTP client’s address</li>\n<li>secure: boolean - true if this is an HTTPS request</li>\n<li>useragent: string - the Web browser’s user agent information.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - optional return string containing a valid absolute or relative URL</li></ul><p><br>\n<b>Examples:</b>\n</p><p>The following code redirects any root HTTP request received by the HSYCO server to the manager page.\n</p><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>function WebRootRequestEvent(addr, secure, useragent) : {\n\treturn \"hsycoserver/manager\";\n}</pre></div>",
	content:"function WebRootRequestEvent(addr, secure, useragent) : {\n\t${1:// body...} \n}"
});



var a = s.js;
a.push({
	title:"dateSet(year, month, day, hour, minute, second)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Sets the HSYCO Server operating system’s clock and hardware clock, in the local time zone.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>year: numeric - the year, greater than 1900</li>\n<li>month: numeric - the month, between 1-12</li>\n<li>day: numeric - the day, between 1-31</li>\n<li>hour: numeric - the hour, between 0-23</li>\n<li>minute: numeric - the minute, between 0-59</li>\n<li>second: numeric - the second, between 0-59.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true if successful, false if not.</li></ul><p><br>\n</p>",
	content:"dateSet(${1:year}, ${2:month}, ${3:day}, ${4:hour}, ${5:minute}, ${6:second})"
});
a.push({
	title:"getNextSunrise(now, withoffset)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Computes the time of the next sunrise after the time set in the now parameter.\n</p><p>The sunrise time is returned in milliseconds since midnight, January 1, 1970 UTC.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>now: numeric - the reference time in milliseconds</li>\n<li>withoffset: boolean - true to take the sunrise offset into account, as defined with the SunriseOffsetMinutes in hsyco.ini, false to ignore the offset and return the actual sunrise time (Based on civil dawn, begins when the geometric center of the sun is 6° below the horizon).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - the next sunrise time in milliseconds since midnight, January 1, 1970 UTC.</li></ul><p><br>\n</p>",
	content:"getNextSunrise(${1:now}, ${2:withoffset})"
});
a.push({
	title:"getNextSunset(now, withoffset)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Computes the time of the next sunset after the time set in the now parameter.\n</p><p>The sunset time is returned in milliseconds since midnight, January 1, 1970 UTC.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>now: numeric - the reference time in milliseconds</li>\n<li>withoffset: boolean - true to take the sunset offset into account, as defined with the SunriseOffsetMinutes in hsyco.ini, false to ignore the offset and return the actual sunrise time (Based on civil dusk, ends when the geometric center of the sun reaches 6° below the horizon).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - the next sunset time in milliseconds since midnight, January 1, 1970 UTC.</li></ul>",
	content:"getNextSunset(${1:now}, ${2:withoffset})"
});
a.push({
	title:"static double geoBearing(double lat1, double lon1, double lat2, double lon2)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Returns the bearing in decimal degrees between two geographical coordinates.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>lat1: numeric - latitude in decimal degrees of point 1 (origin)</li>\n<li>lon1: numeric - longitude in decimal degrees of point 1 (origin)</li>\n<li>lat2: numeric - latitude in decimal degrees of point 2 (target)</li>\n<li>lon2: numeric - longitude in decimal degrees of point 2 (target).</li></ul><p>Latitude is positive east, negative west; longitude is positive north, negative south.\n</p><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - bearing in decimal degrees.</li></ul>",
	content:"static double geoBearing(${1:double} lat1, ${2:double} lon1, ${3:double} lat2, ${4:double} lon2)"
});
a.push({
	title:"static double geoDistance(double lat1, double lon1, double lat2, double lon2)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Returns the distance in meters between two geographical coordinates.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>lat1: numeric - latitude in decimal degrees of point 1 (origin)</li>\n<li>lon1: numeric - longitude in decimal degrees of point 1 (origin)</li>\n<li>lat2: numeric - latitude in decimal degrees of point 2 (target)</li>\n<li>lon2: numeric - longitude in decimal degrees of point 2 (target).</li></ul><p>Latitude is positive east, negative west; longitude is positive north, negative south.\n</p><p><b>Returns:</b>\n</p><ul><li>numeric - distance in meters.</li></ul>",
	content:"static double geoDistance(${1:double} lat1, ${2:double} lon1, ${3:double} lat2, ${4:double} lon2)"
});
a.push({
	title:"haActiveState()",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>When HSYCO is installed in a high availability configuration, this method returns true if the system (master or slave) is active, false if it is not active.\n</p><p>If high availability is not configured, the method returns true.\n</p><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - high availability current state.</li></ul><p><br>\n</p>",
	content:"haActiveState()"
});
a.push({
	title:"haActive(active)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Force a master HSYCO server to become inactive, or return to the active state.\n</p><p>This method should be called on the master only, and has no effect on the slave server.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>active: boolean - set to true to force a master to become inactive, or false to return it to the active state after the master was forced to become inactive.</li></ul><p><br>\n</p>",
	content:"haActive(${1:active})"
});
a.push({
	title:"isDaylight()",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Returns the day or night status at present time.\n</p><p>The result is based on the latitude and longitude data set in hsyco.ini and the SunriseOffsetMinutes and SunsetOffsetMinutes parameters.\n</p><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true during the day, false at night.</li></ul><p><br>\n</p>",
	content:"isDaylight()"
});
a.push({
	title:"nlp(text)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Send a text to the Natural Language Processor (NLP). See the <a href=\"/3.8/index.php/NLP\" title=\"NLP\">NLP engine</a> page for additional information.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>text: string - natural language text string.</li></ul>",
	content:"nlp(${1:text})"
});
a.push({
	title:"powerSet(power)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Sets the electric power state variable.\n</p><p>The power value is shown in the navigation or status bar of the Web interface.\n</p><p>Besides setting the power value, this method also triggers the execution of the powerEvent() callback and the POWER event in EVENTS.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>power: numeric - the power in Watt units.</li></ul>",
	content:"powerSet(${1:power})"
});
a.push({
	title:"programTimerClear(name)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Cancels a program timer.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the program timer name.</li></ul><p><br>\n</p>",
	content:"programTimerClear(${1:name})"
});
a.push({
	title:"programTimerRepeat(name, seconds)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Sets a program timer that is executed repeatedly with an interval  equal to the specified number of seconds. \n</p><p>If a program timer with the same name has already been set, the number of seconds to the timer’s execution is reset to the new value.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the program timer name</li>\n<li>seconds: numeric - the interval in seconds of the timer’s execution.</li></ul><p>If the program timer name starts with $, then the server will also automatically set a variable, with a name equal to the program timer's name, to the remaining number of seconds. Note that the variable is not guarateed to be updated at every second, as some updates may be skipped due to timing constraints.\n</p>",
	content:"programTimerRepeat(${1:name}, ${2:seconds})"
});
a.push({
	title:"programTimerReset(name, seconds)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Sets a program timer to be executed after the specified number of seconds.\n</p><p>If a program timer with the same name has already been set, the number of seconds to the timer’s execution is reset to the new value.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the program timer name</li>\n<li>seconds: numeric - the number of seconds to the timer’s execution.</li></ul><p>If the program timer name starts with $, then the server will also automatically set a variable, with a name equal to the program timer's name, to the remaining number of seconds. Note that the variable is not guarateed to be updated at every second, as some updates may be skipped due to timing constraints.\n</p>",
	content:"programTimerReset(${1:name}, ${2:seconds})"
});
a.push({
	title:"programTimerSet(name, seconds)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Sets a program timer to be executed after the specified number of seconds.\nIf a program timer with the same name has already been set, the action will be ignored.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the program timer name</li>\n<li>seconds: numeric - the number of seconds to the timer’s execution.</li></ul><p>If the program timer name starts with $, then the server will also automatically set a variable, with a name equal to the program timer's name, to the remaining number of seconds. Note that the variable is not guarateed to be updated at every second, as some updates may be skipped due to timing constraints.\n</p>",
	content:"programTimerSet(${1:name}, ${2:seconds})"
});
a.push({
	title:"schedulerRegister(groupname, schedulename, interval)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>This function registers a new scheduled callback.\n</p><p>Schedules are defined using a group name and a schedule name.\n</p><p>Schedules under the same group run in the same thread and are executed sequentially, based on their interval in milliseconds. Schedules in different groups run in parallel.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>groupname: string - the group name</li>\n<li>schedulename: string - the schedule name</li>\n<li>interval: numeric - interval in milliseconds.</li></ul>",
	content:"schedulerRegister(${1:groupname}, ${2:schedulename}, ${3:interval})"
});
a.push({
	title:"schedulerRemove(groupname, schedulename)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Deletes a schedule.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>groupname: string - the group name</li>\n<li>schedulename: string - the schedule name.</li></ul><p><br>\n</p>",
	content:"schedulerRemove(${1:groupname}, ${2:schedulename})"
});
a.push({
	title:"sleep(millis)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Causes the currently executing thread to sleep (temporarily cease execution) for the specified number of milliseconds.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>millis: numeric - the length of time to sleep in milliseconds.</li></ul><p><br>\n</p>",
	content:"sleep(${1:millis})"
});
a.push({
	title:"varGet(name)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Returns the value of a program variable, or a comma-separated list of all variables.\n</p><p>Program variables can be set using varSet() in user.java or in the EVENTS programming environment.\n</p><p>To access a variable used in EVENTS, the name used in varGet() should start with the $ character.\n</p><p>Variables names ending with ! are considered persistent and their values are preserved when HSYCO restarts; normal variables are deleted when HSYCO starts.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the variable name. Names are case-insensitive. Set to \"*\" to request the list of all variables.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - the current value of the program variable or comma-separated list of all variables. Returns null if the variable is not defined.</li></ul>",
	content:"varGet(${1:name})"
});
a.push({
	title:"varSet(name, value)",
	subTitle:"Javascript Command and Utility Functions, System Functions",
	docHTML:"<p>Sets a program variable to the value parameter.\n</p><p>Variables set with varSet() can be read using varGet() and are also available in the EVENTS programming environment, if the variable name starts with $.\n</p><p>If you need to use variables in Java or JavaScript but don’t want these variables to be available in EVENTS, just use names that don’t start with the $ character.\n</p><p>Variables names ending with ! are considered persistent and their values are preserved when HSYCO restarts; normal variables are deleted when HSYCO starts.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the variable name. Names are case-insensitive</li>\n<li>value: string - the value to be assigned to the program variable.</li></ul><p><br>\n</p>",
	content:"varSet(${1:name}, ${2:value})"
});
a.push({
	title:"cameraCommand(func, action, camera)",
	subTitle:"Javascript Command and Utility Functions, Cameras",
	docHTML:"<p>Sends PTZ and focus commands to cameras.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>function: string - see the table below</li>\n<li>action: string - see the table below</li>\n<li>camera: string - the camera name.</li></ul><table>\n<tbody><tr>\n<td>\n<table class=\"wikitable\">\n<tbody><tr>\n<td><b>icon</b>\n</td>\n<td><b>function</b>\n</td>\n<td><b>action</b>\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-ff.png\" class=\"image\"><img alt=\"Camover-ff.png\" src=\"/3.8/images/9/92/Camover-ff.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>focus\n</td>\n<td>far\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-fn.png\" class=\"image\"><img alt=\"Camover-fn.png\" src=\"/3.8/images/d/da/Camover-fn.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>focus\n</td>\n<td>near\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-zin.png\" class=\"image\"><img alt=\"Camover-zin.png\" src=\"/3.8/images/d/db/Camover-zin.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>zoom\n</td>\n<td>tele\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-zout.png\" class=\"image\"><img alt=\"Camover-zout.png\" src=\"/3.8/images/8/81/Camover-zout.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>zoom\n</td>\n<td>wide\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-l.png\" class=\"image\"><img alt=\"Camover-l.png\" src=\"/3.8/images/9/9a/Camover-l.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>move\n</td>\n<td>left\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-r.png\" class=\"image\"><img alt=\"Camover-r.png\" src=\"/3.8/images/f/ff/Camover-r.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>move\n</td>\n<td>right\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-u.png\" class=\"image\"><img alt=\"Camover-u.png\" src=\"/3.8/images/b/b9/Camover-u.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>move\n</td>\n<td>up\n</td></tr>\n<tr>\n<td><a href=\"/3.8/index.php/File:Camover-d.png\" class=\"image\"><img alt=\"Camover-d.png\" src=\"/3.8/images/e/e9/Camover-d.png\" decoding=\"async\" width=\"50\" height=\"50\"></a>\n</td>\n<td>move\n</td>\n<td>down\n</td></tr>\n<tr>\n<td>\n</td>\n<td>move\n</td>\n<td>stop\n</td></tr></tbody></table>\n</td>\n<td style=\"width:600px;align:center\"><div class=\"center\"><div class=\"floatnone\"><a href=\"/3.8/index.php/File:Camerapanel_ptz.png\" class=\"image\"><img alt=\"Camerapanel ptz.png\" src=\"/3.8/images/thumb/0/06/Camerapanel_ptz.png/300px-Camerapanel_ptz.png\" decoding=\"async\" width=\"300\" height=\"267\" style=\"vertical-align: top\" class=\"thumbborder\" srcset=\"/3.8/images/thumb/0/06/Camerapanel_ptz.png/450px-Camerapanel_ptz.png 1.5x, /3.8/images/0/06/Camerapanel_ptz.png 2x\"></a></div></div>\n</td></tr></tbody></table><p><br>\n</p>",
	content:"cameraCommand(${1:func}, ${2:action}, ${3:camera})"
});
a.push({
	title:"cameraMode(cameraName, enabled)",
	subTitle:"Javascript Command and Utility Functions, Cameras",
	docHTML:"<p>Disables or enables a camera.\n</p><p>When the live view is disabled, recording is also disabled.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>camera: string - the camera name</li>\n<li>enabled: boolean - true to enable the camera, false to disable.</li></ul>",
	content:"cameraMode(${1:cameraName}, ${2:enabled})"
});
a.push({
	title:"cameraRecMode(cameraName, enabled)",
	subTitle:"Javascript Command and Utility Functions, Cameras",
	docHTML:"<p>Disables or enables recording from a camera, not affecting live view.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>camera: string - the camera name</li>\n<li>enabled: boolean - true to enable the recording, false to disable.</li></ul><p><br>\n</p>",
	content:"cameraRecMode(${1:cameraName}, ${2:enabled})"
});
a.push({
	title:"cameraRecTrigger(cameraName, source, seconds)",
	subTitle:"Javascript Command and Utility Functions, Cameras",
	docHTML:"<p>Records video from a camera.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>camera: string - the camera name</li>\n<li>source: string - a string used to generate a log message, to identify the source that triggered the recording</li>\n<li>seconds: numeric - recording time in seconds. If set to 0, stops the current recording.</li></ul>",
	content:"cameraRecTrigger(${1:cameraName}, ${2:source}, ${3:seconds})"
});
a.push({
	title:"cameraRecTriggerFull(cameraName, source, seconds)",
	subTitle:"Javascript Command and Utility Functions, Cameras",
	docHTML:"<p>Records video from a camera, like cameraRecTrigger(), but ignores the DroppedFrames parameter in hsyco.ini, so that all frames captured from the camera during the recording period are recorded with no skips.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>camera: string - the camera name</li>\n<li>source: string - a string used to generate a log message, to identify the source that triggered the recording</li>\n<li>seconds: numeric - recording time in seconds. If set to 0, stops the current recording.</li></ul>",
	content:"cameraRecTriggerFull(${1:cameraName}, ${2:source}, ${3:seconds})"
});
a.push({
	title:"dataLoggerClear(name)",
	subTitle:"Javascript Command and Utility Functions, Data Logger",
	docHTML:"<p>Permanently deletes all historical data of the specified data logger.\n</p><p><b>Parameters:</b>\n</p><ul><li>name: string - data logger name.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true if successful, false if not.</li></ul><p><br>\n</p>",
	content:"dataLoggerClear(${1:name})"
});
a.push({
	title:"dataLoggerOptions(name, param, value)",
	subTitle:"Javascript Command and Utility Functions, Data Logger",
	docHTML:"<p>Sets a specific option for the specified data logger.\n</p><p>So far the only available option is \"origin\" which sets the x-bar of all the charts linked to the data logger to the passed value.\n</p><p><b>Parameters:</b>\n</p><ul><li>name: string - data logger name</li>\n<li>param: string - option to be set (\"origin\" is the only option you can currently set with this method)</li>\n<li>value: string - value for the specified option.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true if successful, false if not.</li></ul><p><br>\n</p>",
	content:"dataLoggerOptions(${1:name}, ${2:param}, ${3:value})"
});
a.push({
	title:"dataLoggerSave(action, names, path, timestamp)",
	subTitle:"Javascript Command and Utility Functions, Data Logger",
	docHTML:"<p>Also used to import and export of raw data logger data in CSV format. See <a href=\"/3.8/index.php/Data_Loggers#CSV_Import.2FExport\" title=\"Data Loggers\">Data Loggers CSV Import/Export</a> for additional information.\n</p><p>The possible actions are:\n</p><ul><li>log: append the last acquired value by the data logger to the specified file</li>\n<li>stat: updates the specified file with the currently gathered data by the specified data logger</li>\n<li>csvwrite: create a CSV file with all raw data from a data logger</li>\n<li>csvwrite from <yyyymmddhhmm> to <yyyymmddhhmm> groupby <year | month | day | hour> path <path>: create a CSV file with raw data from a data logger, between the given time interval. The file, named <data id=\"\">.csv is written in the < path> directory. The date and time must be written as a 12 digit string. Data returned including the first time and excluding the second. The \"TO\" limit is optional. GROUPBY is also optional. If omitted, all individual records matching the time interval are written to the CSV file. If GROUPBY is specified, records and their values are grouped together by year, month, day or hour. Note that, to optimise performance and resources allocation, this extended form of the FILE CSVWRITE action can write only up to 10000 rows to the CSV file</data></li>\n<li>csvread: insert, update or delete records to a data logger</li>\n<li>csvreadover: insert records to a data logger, replacing all existing data.</li></ul><p><br>\n<b>Parameters:</b>\n</p><ul><li>action: string - set to \"log\", \"stat\", \"csvwrite\", \"csvwrite from <yyyymmddhhmm> to <yyyymmddhhmm> groupby <year | month | day | hour> path <path>\", \"csvread\" or \"csvreadover\"</li>\n<li>names: string array - data logger names</li>\n<li>path: string - path of the file to be created</li>\n<li>timestamp: boolean - if true and the action is log adds a timestamp column in the CSV file for the logged values.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true if successful, false if not.</li></ul><p><br>\n<b>Examples:</b>\n</p><p>The following code appends a new line every minute to the userdata/log.csv file with the most recent values of three data loggers, \"a\", \"b\" and \"c\".\n</p><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre> time : { dataLoggerSave('log', ['a','b','c'], 'userdata/log.csv', true); }</pre></div>",
	content:"dataLoggerSave(${1:action}, ${2:names}, ${3:path}, ${4:timestamp})"
});
a.push({
	title:"dataLoggerUpdate(name, value)",
	subTitle:"Javascript Command and Utility Functions, Data Logger",
	docHTML:"<p>Supplies the specified data logger with a new value to be processed.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - data logger name</li>\n<li>value: numeric - value to be processed. Setting value to null, with counter data loggers only, resets the internal delta baseline.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true if successful, false if not.</li></ul><p><br>\n</p>",
	content:"dataLoggerUpdate(${1:name}, ${2:value})"
});
a.push({
	title:"dmxGet(channel)",
	subTitle:"Javascript Command and Utility Functions, DMX",
	docHTML:"<p>Returns the current status of a channel on the DMX-512 bus.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>channel: numeric - when using one DMX gateway, address will be a standard DMX-512 address between 1 and 512. If there is more than one gateway, 1000 must be added to the DMX address for the second gateway, 2000 for the third one and so on.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - channel current status, between 0 and 255, or UNKNOWN (-1) if the status is unknown.</li></ul><p><br>\n</p>",
	content:"dmxGet(${1:channel})"
});
a.push({
	title:"dmxOff(channel)",
	subTitle:"Javascript Command and Utility Functions, DMX",
	docHTML:"<p>Sets a channel on the DMX-512 bus to 0. It also saves the previous value, so it can be restored with dmxOn().\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>channel: numeric - when using one DMX gateway, address will be a standard DMX-512 address between 1 and 512. If there is more than one gateway, 1000 must be added to the DMX address for the second gateway, 2000 for the third one and so on.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, 0 if not.</li></ul><p><br>\n</p>",
	content:"dmxOff(${1:channel})"
});
a.push({
	title:"dmxOn(channel)",
	subTitle:"Javascript Command and Utility Functions, DMX",
	docHTML:"<p>Sets a DMX-512 channel to the value preceding the last call to dmxOff().\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>channel: numeric - when using one DMX gateway, address will be a standard DMX-512 address between 1 and 512. If there is more than one gateway, 1000 must be added to the DMX address for the second gateway, 2000 for the third one and so on.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, 0 if not.</li></ul><p><br>\n</p>",
	content:"dmxOn(${1:channel})"
});
a.push({
	title:"dmxMerge(fromchannel, tochannel, merge)",
	subTitle:"Javascript Command and Utility Functions, DMX",
	docHTML:"<p>Sets all DMX-512 channels between the parameters from and to to merge mode or normal mode. In merge mode, the channels on the DMX OUT bus of the gateway follow the values of the channels of the DMX IN bus.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>fromchannel: numeric - first address of the range. When using one DMX gateway, address will be a standard DMX-512 address between 1 and 512. If there is more than one gateway, 1000 must be added to the DMX address for the second gateway, 2000 for the third one and so on</li>\n<li>tochannel: numeric - last address of the range</li>\n<li>merge: boolean - true to enable merge mode, false to return to normal mode.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, -1 if to < from, 0 for other errors.</li></ul><p><br>\n</p>",
	content:"dmxMerge(${1:fromchannel}, ${2:tochannel}, ${3:merge})"
});
a.push({
	title:"dmxSet(channel, state)",
	subTitle:"Javascript Command and Utility Functions, DMX",
	docHTML:"<p>Sets the value of a single DMX-512 channel.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>channel: numeric - when using one DMX gateway, address will be a standard DMX-512 address between 1 and 512. If there is more than one gateway, 1000 must be added to the DMX address for the second gateway, 2000 for the third one and so on</li></ul><p>state: numeric - the new value of the channel, from 0 to 255.\n</p><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, 0 if not.</li></ul>",
	content:"dmxSet(${1:channel}, ${2:state})"
});
a.push({
	title:"irtransCommand(irid, command)",
	subTitle:"Javascript Command and Utility Functions, Infrared Control",
	docHTML:"<p>Sends a command to an IRTrans.\n</p><p><br>\nAn infrared command is composed by the name that identifies the commands database, followed by a comma and the name of the command in the database.\n</p><p>More commands in a sequence can be separated by \";\".\n</p><p>It is possible to insert the special command @N, which introduces a wait time of N milliseconds before sending the next command.\n</p><p>This command:\n</p><pre>denon1036,on;@4000;denon1036,tv\n</pre><p>sends the \"on\" command of the \"denon-1036\" remote, then waits 4 seconds before sending the \"tv\" command.\n</p><p>Moreover, the special command @0 allows to send IR commands without wait times before sending the next command.\n</p><p>When the @N delay before an IR command is not specified, there will be a default 500ms pause between commands; with @0 this pause will be reduced to 1ms.\n</p><p>For example:\n</p><pre>denon,on;@0;nad,on\n</pre><p>sends the \"on\" command of the \"denon\" remote, immediately followed by the \"on\" command of the \"nad\" remote.\n</p><p><br>\n<img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>Every IRTrans can contain a database of several remote controls, and each database stores the list of the distinct IR commands. If the hsyco/ir directory contains a .ccfhex file corresponding to the database name, then the CCF string in the file is used instead of sending the command stored in the IRTrans internal database.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>irid: string - identifies the IRTrans, as defined with the IRTrans parameter in hsyco.ini</li>\n<li>command: string - the sequence of IR commands to be sent.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, 0 if not.</li></ul><p><br>\n</p>",
	content:"irtransCommand(${1:irid}, ${2:command})"
});
a.push({
	title:"ioGet(id)",
	subTitle:"Javascript Command and Utility Functions, I/O Servers",
	docHTML:"<p>Retrieves the current status of an I/O data point, or a comma-separated list of all data points.\n</p><p><b>Parameters:</b>\n</p><ul><li>id: string - the full data point name, including the I/O server id prefix. Set to \"*\" to request the list of all data points.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - the data point value or comma-separated list of all data points.</li></ul>",
	content:"ioGet(${1:id})"
});
a.push({
	title:"ioServersRestart(name)",
	subTitle:"Javascript Command and Utility Functions, I/O Servers",
	docHTML:"<p>Restarts an I/O server that was previously stopped.\n</p><p>This command has no effect on a running I/O server.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>Note that this command will return before the I/O server is actually restarted.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the I/O server name.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, -1 if the server name is not defined.</li></ul><p><br>\n</p>",
	content:"ioServersRestart(${1:name})"
});
a.push({
	title:"ioServersStop(name)",
	subTitle:"Javascript Command and Utility Functions, I/O Servers",
	docHTML:"<p>Stops the execution of an I/O server.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>Note that this command will return before the I/O server is actually stopped.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the I/O server name.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, -1 if the server name is not defined.</li></ul><p><br>\n</p>",
	content:"ioServersStop(${1:name})"
});
a.push({
	title:"ioSet(id, value)",
	subTitle:"Javascript Command and Utility Functions, I/O Servers",
	docHTML:"<p>Writes to I/O servers variables or data points.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>id: string - the full data point name, including the I/O server id prefix</li>\n<li>value: string - the new value.</li></ul><p><br>\n</p>",
	content:"ioSet(${1:id}, ${2:value})"
});
a.push({
	title:"leakDetectorClear(name)",
	subTitle:"Javascript Command and Utility Functions, Leak Detector",
	docHTML:"<p>Clears the detector’s internal state.\n</p><p>In normal applications, there is no need to call this method, as the detector automatically clears its state from old data.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - leak detector name.</li></ul><p><br>\n</p>",
	content:"leakDetectorClear(${1:name})"
});
a.push({
	title:"leakDetectorOptions(name, param, value)",
	subTitle:"Javascript Command and Utility Functions, Leak Detector",
	docHTML:"<p>The detector’s logic uses two parameters to set its sensitivity and time base. You can change the defaults to adapt to your specific conditions.\n</p><p>The \"period\" parameter changes the time base, expressed in seconds. The default is 1200 seconds.\nThe detector generates a warning if the flow deviation constantly remains below the deviation threshold for the time period.\n</p><p>The \"deviation\" parameter changes the deviation percentage, and should be a number between 1 and 100. The default is 50.\nSet the period or deviation to 0 to temporarily disable the detector.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>Small deviation values cause the algorithm to activate leak warnings only when the flow is very constant in time, becoming less susceptible to false alarms, but a value that is too low could miss actual leaks. Larger values could easily generate false alarms.</b>\n</p><p>Both period and deviation parameters can be changed anytime, even when the detector is already processing data.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - leak detector name</li>\n<li>param: string - set to \"period\" or \"deviation\"</li>\n<li>value: numeric - the period or deviation value.</li></ul><p><br>\n</p>",
	content:"leakDetectorOptions(${1:name}, ${2:param}, ${3:value})"
});
a.push({
	title:"leakDetectorUpdate(name, value)",
	subTitle:"Javascript Command and Utility Functions, Leak Detector",
	docHTML:"<p>Calls the leak detector passing the current liters counter value.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - leak detector name</li>\n<li>value: numeric - the flow counter value.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - -1 if the detector status is not changed, 0 if the status has changed to a reset condition, and 1 if the status has changed to a leak condition.</li></ul>",
	content:"leakDetectorUpdate(${1:name}, ${2:value})"
});
a.push({
	title:"errorLog(message)",
	subTitle:"Javascript Command and Utility Functions, Log",
	docHTML:"<p>Generates an error message in the daily log file.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>message: string - the text of the error message.</li></ul><p><br>\n</p>",
	content:"errorLog(${1:message})"
});
a.push({
	title:"fileLog(pathname, message)",
	subTitle:"Javascript Command and Utility Functions, Log",
	docHTML:"<p>Appends a generic text message at the end of a file.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>pathname: string - the file name. You can specify any path, starting from HSYCO’s base directory. If the file or parent directories don’t exist, they will be created automatically</li>\n<li>message: string - the message that will be appended at the last line of the text file.</li></ul><p><br>\n</p>",
	content:"fileLog(${1:pathname}, ${2:message})"
});
a.push({
	title:"messageLog(message)",
	subTitle:"Javascript Command and Utility Functions, Log",
	docHTML:"<p>Generates an information message in the daily log file.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>message: string - the text of the message.</li></ul>",
	content:"messageLog(${1:message})"
});
a.push({
	title:"sendMail(to, from, subject, body)",
	subTitle:"Javascript Command and Utility Functions, Mail",
	docHTML:"<p>Sends a multipart email message, mixing text and multiple images from cameras, live or recorded.\n</p><p>HSYCO SERVER sends the mail either directly to the recipient’s domain mail server if the SmtpName parameter is not defined in hsyco.ini, or using a specific email account with user authentication and traffic encryption if the SMTP server and account parameters are set.\n</p><p>If the email message is sent directly to the recipient’s domain mail server, you need to ensure that the mail server accepts mail to the destination address being sent with the from address and the public IP of the HSYCO SERVER.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>HSYCO does not automatically retry sending the message if the destination mail server is not available when the send mail function is called.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>to: string - a valid email address of the intended recipient. You can optionally specify the destination SMTP server name or IP address by appending :<server name or address to the recipient's email address, for example: john@example.com:192.168.1.1</li>\n<li>from: string - a valid email address to be used as the sender address</li>\n<li>subject: string - the message subject</li>\n<li>body: string array - the message body. To send an ordinary text, just fill the array with the desired text strings. To send an image, append strings with the following format: \"cam:cameraname[:seconds_back[:frames_back]]\". For example, \"cam:door\" sends a live frame from the camera called \"door\"; \"cam:door:0\" sends the last recorded frame; \"cam:door:2\" sends a frame that was recorded two seconds before the last recorded frame and \"cam:door:2:5\" sends a frame that is 5 frames earlier than the one recorded two seconds before the last recording. To send files as attachments, use the following format: \"file:<file name>\". The file path is relative to the HSYCO root directory.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1: message sent; 0: message not sent; -1: other errors, including address errors.</li></ul><p><br>\n<b>Examples:</b>\n</p><pre>... : { sendMail('ulde@hsyco.com', 'test@hsyco.net', 'this is a test', ['Door camera','cam:door:2']); }\n</pre><p>sends an email message with body containing a short text and a camera snapshot.\n</p>",
	content:"sendMail(${1:to}, ${2:from}, ${3:subject}, ${4:body})"
});
a.push({
	title:"modbusReadCoils(name, unit, address, quantity)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Reads the content of a contiguous block of coils in a MODBUS device, using function code <b>0x01</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x01, the second to the byte count of the data part, and the data starts from the third byte.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The coils in the response message are packed as one coil per bit of the data field. Status is indicated as 1= ON and 0= OFF. The LSB of the first data byte contains the output addressed in the query. The other coils follow toward the high order end of this byte, and from low order to high order in subsequent bytes.\nIf the returned output quantity is not a multiple of eight, the remaining bits in the final data byte will be padded with zeros (toward the high order end of the byte). The byte count field in the response PDU specifies the quantity of complete bytes of data.</b>\n</p><p><br>\nIf there is an error, the first byte is set to 0x81 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the starting address of the block of coils</li>\n<li>quantity: numeric - the quantity of coils you are reading (1 to 2000).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusReadCoils(${1:name}, ${2:unit}, ${3:address}, ${4:quantity})"
});
a.push({
	title:"modbusReadDiscreteInputs(name, unit, address, quantity)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Reads the content of a contiguous block of discrete inputs in a MODBUS device, using function code <b>0x02</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x02, the second to the byte count of the data part, and the data starts from the third byte.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>The discrete inputs in the response message are packed as one input per bit of the data field. Status is indicated as 1= ON; 0= OFF. The LSB of the first data byte contains the input addressed in the query. The other inputs follow toward the high order end of this byte, and from low order to high order in subsequent bytes.\nIf the returned input quantity is not a multiple of eight, the remaining bits in the final data byte will be padded with zeros (toward the high order end of the byte). The byte count field of the response PDU specifies the quantity of complete bytes of data.</b>\n</p><p><br>\nIf there is an error, the first byte is set to 0x82 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the starting address of the block of discrete inputs</li>\n<li>quantity: numeric - the quantity of discrete inputs you are reading (1 to 2000).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusReadDiscreteInputs(${1:name}, ${2:unit}, ${3:address}, ${4:quantity})"
});
a.push({
	title:"modbusReadHoldingRegisters(name, unit, address, quantity)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Reads the content of a contiguous block of holding registers in a MODBUS device, using function code <b>0x03</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x03, the second to the byte count of the data part, and the data starts from the third byte.\n</p><p>If there is an error, the first byte is set to 0x83 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the starting address of the block of registers</li>\n<li>quantity: numeric - the quantity of registers you are reading (1 to 125).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusReadHoldingRegisters(${1:name}, ${2:unit}, ${3:address}, ${4:quantity})"
});
a.push({
	title:"modbusReadInputRegisters(name, unit, address, quantity)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Reads the content of a contiguous block of input registers in a MODBUS device, using function code <b>0x04</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x04, the second to the byte count of the data part, and the data starts from the third byte.\n</p><p>If there is an error, the first byte is set to 0x84 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the starting address of the block of registers</li>\n<li>quantity: numeric - the quantity of registers you are reading (1 to 125).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusReadInputRegisters(${1:name}, ${2:unit}, ${3:address}, ${4:quantity})"
});
a.push({
	title:"modbusReadWriteMultipleRegisters(name, unit, readaddress, readquantity, writeaddress, bytes)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Writes a block of contiguous registers in a MODBUS device, then reads the content of a contiguous block of holding registers, using function code <b>0x17</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x17, the second to the byte count of the data part, and the data starts from the third byte.\n</p><p>If there is an error, the first byte is set to 0x97 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>readaddress: numeric - the starting address of the block of registers to read</li>\n<li>readquantity: numeric - the quantity of registers you are reading (1 to 125)</li>\n<li>writeaddress: numeric - the starting address of the block of registers to write</li>\n<li>bytes: numeric array - data to be written in the registers, using big-endian encoding (the most significant byte is sent first), with the array elements set to the unsigned decimal value of each byte.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusReadWriteMultipleRegisters(${1:name}, ${2:unit}, ${3:readaddress}, ${4:readquantity}, ${5:writeaddress}, ${6:bytes})"
});
a.push({
	title:"modbusWriteMaskRegister(name, unit, address, mask, bytes)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Writes a register with a bit mask in a MODBUS device, using function code <b>0x16</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x16, the next two bytes to the mask and the last two to register value.\n</p><p>If there is an error, the first byte is set to 0x96 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>mask: numeric array - the AND mask to be applied to the register</li>\n<li>bytes: numeric array - data to be written in the register, using big-endian encoding (the most significant byte is sent first), with the array elements set to the unsigned decimal value of each byte.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusWriteMaskRegister(${1:name}, ${2:unit}, ${3:address}, ${4:mask}, ${5:bytes})"
});
a.push({
	title:"modbusWriteMultipleCoils(name, unit, address, coils, bytes)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Writes multiple coils in a MODBUS device, using function code <b>0x0F</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x0F, the next two to the data address of the first coil, and the last two to the number of coils written.\n</p><p>If there is an error, the first byte is set to 0x8F and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the coil’s address</li>\n<li>coils: numeric - the number of coils to be written</li>\n<li>bytes: numeric array - The requested ON/OFF states are specified by contents of the request data field, following the same data format defined in the Modbus specification for function 0x0F. A logical '1' in a bit position of the field requests the corresponding output to be ON. A logical '0' requests it to be OFF. The first byte represents coils with the lowest address, with the least significant bit addressing the lowest address coil. The array elements are set to the unsigned decimal value of each byte.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusWriteMultipleCoils(${1:name}, ${2:unit}, ${3:address}, ${4:coils}, ${5:bytes})"
});
a.push({
	title:"modbusWriteMultipleRegisters(name, unit, address, bytes)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Writes a block of contiguous registers in a MODBUS device, using function code <b>0x10</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x10, the next two bytes to the starting address and the last two to the quantity of registers.\n</p><p>If there is an error, the first byte is set to 0x90 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the starting address of the block of registers</li>\n<li>bytes: numeric array - data to be written in the registers, using big-endian encoding (the most significant byte is sent first), with the array elements set to the unsigned decimal value of each byte.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusWriteMultipleRegisters(${1:name}, ${2:unit}, ${3:address}, ${4:bytes})"
});
a.push({
	title:"modbusWriteSingleCoil(name, unit, address, value)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Writes a single coil in a MODBUS device, using function code <b>0x05</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x05 and the last two to 0xFF00 if the coil is on, and 0x0000 if the coil is off.\n</p><p>If there is an error, the first byte is set to 0x85 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the coil’s address</li>\n<li>value: boolean - true to turn the coil on, false to turn it off.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul>",
	content:"modbusWriteSingleCoil(${1:name}, ${2:unit}, ${3:address}, ${4:value})"
});
a.push({
	title:"modbusWriteSingleRegister(name, unit, address, bytes)",
	subTitle:"Javascript Command and Utility Functions, Modbus",
	docHTML:"<p>Writes a single register in a MODBUS device, using function code <b>0x06</b>.\n</p><p>Returns a standard response PDU.\n</p><p>If there is a correct response from the device, the first byte is set to 0x06 and the last two to register value.\n</p><p>If there is an error, the first byte is set to 0x86 and the second byte to the error code.\n</p><p>This function can be invoked passing a name parameter that represents either a predefined I/O Server, or the host name or IP address of the MODBUS gateway.\n</p><p>When using the gateways’s IP address or name, you can call this function to access gateways that are not defined as I/O servers.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the id of the I/O Server as defined in hsyco.ini, or the host name or IP address and optional port number (address:port) of the MODBUS gateway</li>\n<li>unit: numeric - the MODBUS slave unit identifier (1 to 247)</li>\n<li>address: numeric - the register’s address</li>\n<li>bytes: numeric array - data to be written in the register, using big-endian encoding (the most significant byte is sent first), with the array elements set to the unsigned decimal value of each byte.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric array - response PDU (the array elements are set to the unsigned decimal value of each byte).</li></ul><p>Code example:\n</p><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>time : {\n   var cmd = [0,1];\n   var resp = modbusWriteSingleRegister(\"modbus\", 1, 1152, cmd);\n   messageLog(\"MODBUS - resp: \" + resp);\n}</pre></div>",
	content:"modbusWriteSingleRegister(${1:name}, ${2:unit}, ${3:address}, ${4:bytes})"
});
a.push({
	title:"ping(host, timeout)",
	subTitle:"Javascript Command and Utility Functions, Network Services",
	docHTML:"<p>Sends an IP network ping command to the host specified.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>host: string - the hostname or IP address</li>\n<li>timeout: numeric - timeout in milliseconds.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true if the host is reachable, false otherwise.</li></ul>",
	content:"ping(${1:host}, ${2:timeout})"
});
a.push({
	title:"urlGet(url, user, password)",
	subTitle:"Javascript Command and Utility Functions, Network Services",
	docHTML:"<p>Sends a GET HTTP or HTTPS request.\n</p><p>The request has a 10 sec. connection timeout, and 30 sec. response timeout.\n</p><p>The HTTP basic or digest access authentication methods are supported.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>url: string - a full url, including the mandatory http:// or https:// query scheme and optional query string</li>\n<li>user: string - the user for HTTP authentication (set to null if authentication is not needed)</li>\n<li>password: string - the password for HTTP authentication (set to null if authentication is not needed).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - a string with the HTTP return code, followed by \":\" and the response content, or null if a generic error occurred (including malformed URLs).</li></ul>",
	content:"urlGet(${1:url}, ${2:user}, ${3:password})"
});
a.push({
	title:"urlPost(url, contenttype, data, user, password)",
	subTitle:"Javascript Command and Utility Functions, Network Services",
	docHTML:"<p>Sends a POST HTTP or HTTPS request.\n</p><p>The request has a 10 sec. connection timeout, and 30 sec. response timeout.\n</p><p>The HTTP basic or digest access authentication methods are supported.\n</p><p>Note that if contenttype is set to null, you will have to pass all required HTTP headers in the data parameter, including Content-Type and Content-Length, and the mandatory empty line (CRLF only) between the headers and message body. If contenttype is set to the appropriate content type, all headers will be set internally by urlPost() and the data parameter should only contain the actual message body, without the leading empty line, that is added automatically.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>url: string - a full url, including the mandatory http:// or https:// query scheme and optional query string</li>\n<li>contenttype: string - the MIME content type of the data being sent (e.g. \"application/x-www-form-urlencoded\")</li>\n<li>data: string - the data being sent with the POST request</li>\n<li>user: string - the user for HTTP authentication (set to null if authentication is not needed)</li>\n<li>password: string - the password for HTTP authentication (set to null if authentication is not needed).</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - a string with the HTTP return code, followed by \":\" and the response content, or null if a generic error occurred (including malformed URLs).</li></ul>",
	content:"urlPost(${1:url}, ${2:contenttype}, ${3:data}, ${4:user}, ${5:password})"
});
a.push({
	title:"wakeOnLan(broadcast, address)",
	subTitle:"Javascript Command and Utility Functions, Network Services",
	docHTML:"<p>Sends a Wake on LAN command to the LAN specified in the broadcast.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>broadcast: string - the LAN broadcast address. For example \"192.168.0.255\"</li>\n<li>address: string - the IP or MAC address of the network interface. For example,  IP address \"192.168.0.1\" or MAC address \"45-ab-44-00-00-ba\".</li></ul><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>If the IP address is used to identify the destination interface, HSYCO will try to automatically determine the corresponding MAC address, permanently saving this association27. So, when using the IP address, and only the first time this method is called, the device with have to be on to allow HSYCO to determine the MAC address.</b>\n</p><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, -1 if not.</li></ul>",
	content:"wakeOnLan(${1:broadcast}, ${2:address})"
});
a.push({
	title:"audioPlayFile(where, file)",
	subTitle:"Javascript Command and Utility Functions, Public Announcement",
	docHTML:"<p>Plays a pre-recorded audio file.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>where: string - the audio destination; see the table above</li>\n<li>file: string - the audio file name pathname, relative to HSYCO's root directory.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - the index of this message in the play back queue if successful, -1 in case of errors.</li></ul><p><br>\n</p>",
	content:"audioPlayFile(${1:where}, ${2:file})"
});
a.push({
	title:"audioPlayText(where, voice, text)",
	subTitle:"Javascript Command and Utility Functions, Public Announcement",
	docHTML:"<p>Converts a text message to audio using the installed text-to-speech engine, and plays the audio.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>where: string - the audio destination; see the table above</li>\n<li>voice: string - the voice name for the text-to-speech engine; see the <a href=\"/3.8/index.php/Audio_and_Public_Announcement\" title=\"Audio and Public Announcement\">Audio and Public Announcement</a> section for additional information</li>\n<li>text: string - the text message for text-to-speech conversion.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - the index of this message in the play back queue if successful, -1 in case of errors.</li></ul>",
	content:"audioPlayText(${1:where}, ${2:voice}, ${3:text})"
});
a.push({
	title:"closeComm(portname)",
	subTitle:"Javascript Command and Utility Functions, Serial Communication Ports",
	docHTML:"<p>Closes a serial port connection when the serial port is defined ad a \"server\" type, and is ignored otherwise.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>When used with serial servers having a fail-over configuration, this method forces a reconnect at the next call of readComm() or writeComm(), so that a switch between the fail-over IPs would happen if the current IP is not responding.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>portname: string - the name of the communications port, as defined in the CommPorts parameter in hsyco.ini.</li></ul><p><br>\n</p>",
	content:"closeComm(${1:portname})"
});
a.push({
	title:"readComm(portname, len)",
	subTitle:"Javascript Command and Utility Functions, Serial Communication Ports",
	docHTML:"<p>Reads a sequence of bytes from a communication port.\n</p><p>The number of bytes read depends on the availability of data in the buffer of the communication port, until the maximum number specified in the len parameter.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>There is a 2 seconds default time-out on reads. If the buffer is empty, this function will wait until the time-out expires before returning.</b>\n</p><p><br>\nIf len is set to 0, the function doesn’t return data, but it empties the communication port’s buffer from older data.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>If both verboseLog and userLog are true, the full trace of received and sent bytes is written to the log file.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>portname: string - the name of the communications port, as defined in the CommPorts parameter in hsyco.ini</li>\n<li>len: numeric - maximum number of bytes to be read from the port, or 0 to empty the buffer without reading data.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - null in case of errors, a string with the hexadecimal representation of the received byte sequence, or an empty string if the incoming data buffer is empty. For example \"45AB4400BA\".</li></ul>",
	content:"readComm(${1:portname}, ${2:len})"
});
a.push({
	title:"writeComm(portname, data)",
	subTitle:"Javascript Command and Utility Functions, Serial Communication Ports",
	docHTML:"<p>Sends a sequence of bytes to a communication port.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>If both verboseLog and userLog are true, the full trace of received and sent bytes is written to the log file.</b>\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>portname: string - the name of the communications port, as defined in the CommPorts parameter in hsyco.ini</li>\n<li>data: string - a string with the hexadecimal representation of the sequence of bytes to be sent. For example \"45AB4400BA\".</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - the number of bytes sent if successful, or 0 in case of errors.</li></ul><p><br>\n</p>",
	content:"writeComm(${1:portname}, ${2:data})"
});
a.push({
	title:"slimButton(player, button)",
	subTitle:"Javascript Command and Utility Functions, Squeezebox",
	docHTML:"<p>Controls the Squeezebox players, simulating a remote control button.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>player: string - the Squeezebox name, as listed in the slimPlayers parameter in hsyco.ini</li>\n<li>button: string - the Squeezebox command.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>numeric - 1 if successful, 0 otherwise.</li></ul>",
	content:"slimButton(${1:player}, ${2:button})"
});
a.push({
	title:"slimCommand(player, command)",
	subTitle:"Javascript Command and Utility Functions, Squeezebox",
	docHTML:"<p>Sends commands to the Squeezebox players.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>player: string - the Squeezebox name, as listed in the slimPlayers parameter in hsyco.ini</li>\n<li>command: string - the Squeezebox command.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - the   protocol answer to the command if successful, or null in case of errors.</li></ul><p><br>\n</p>",
	content:"slimCommand(${1:player}, ${2:command})"
});
a.push({
	title:"userTimerSet(timerid, on, hour, minute, duration, days)",
	subTitle:"Javascript Command and Utility Functions, Timers and Schedulers",
	docHTML:"<p>Sets a user timer.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>on: boolean - true enables the timer; false disables the timer; null leaves the mode unchanged</li>\n<li>hour: number - start hour, from 0 to 23; null leaves the start hour unchanged</li>\n<li>minute: number - start minute, from 0 to 59; null leaves the start minute unchanged</li>\n<li>duration: number - duration in minutes, from 0 to 1439; null leaves the duration unchanged</li>\n<li>days: string - activation days, as a string of up to 7 characters from 1 to 7, 1 is Monday, 7 is Sunday; null or empty string leaves the days unchanged.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>boolean - true if successful.</li></ul>",
	content:"userTimerSet(${1:timerid}, ${2:on}, ${3:hour}, ${4:minute}, ${5:duration}, ${6:days})"
});
a.push({
	title:"uiClear(session)",
	subTitle:"Javascript Command and Utility Functions, User Interface",
	docHTML:"<p>Removes all session specific UI object attributes set with uiSet().\n</p><p>uiClear() is also implicitly called after the client session inactivity timeout expires.\n</p><p>The uiClearEvent() callback is called following the uiClear() execution if the client session becomes active again (i.e. the client starts handshaking again with the server with the same session id).\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>session: string - session id string that uniquely identifies the client session.</li></ul><p><br>\n</p>",
	content:"uiClear(${1:session})"
});
a.push({
	title:"uiGet(id, attr)",
	subTitle:"Javascript Command and Utility Functions, User Interface",
	docHTML:"<p>Gets the current value of an attribute of an identified UI object, set with the uiSet() function or the UISET action in EVENTS.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>id: string - object id</li>\n<li>attr: string - attribute name.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - the current value of the attribute of an identified UI object, or null if the object attribute has not been set.</li></ul><p><br>\n</p>",
	content:"uiGet(${1:id}, ${2:attr})"
});
a.push({
	title:"uiSessionGet(session, id, attr)",
	subTitle:"Javascript Command and Utility Functions, User Interface",
	docHTML:"<p>Gets the session-specific value of an attribute of an identified UI object, set with the uiSessionSet() function or the UISESSIONSET action in EVENTS\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>id: string - object id</li>\n<li>attr: string - attribute name.</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>string - the session value of the attribute of an identified UI object, or null if the object attribute has not been set.</li></ul><p><br>\n</p>",
	content:"uiSessionGet(${1:session}, ${2:id}, ${3:attr})"
});
a.push({
	title:"uiSessionSet(session, id, attr, value)",
	subTitle:"Javascript Command and Utility Functions, User Interface",
	docHTML:"<p>Changes the dynamic attributes of identified user interface (UI) objects for a specific client session.\n</p><p><br>\n<img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>Session specific attributes values will override values set globally.</b>\n</p><p>Calling this method with a null value, if a global UI value exists, removes the session value and restores the global one.\nPassing a null value has no effect if there is no previous session UI value, or no global UI value exists.\n</p><p>id is the unique name that identifies the object, specified in the index.hsm file with the extension  !id after the object type.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>id: string - object id</li>\n<li>attr: string - attribute name</li>\n<li>value: string - attribute value, or null to remove a previously set session value.</li></ul>",
	content:"uiSessionSet(${1:session}, ${2:id}, ${3:attr}, ${4:value})"
});
a.push({
	title:"uiSet(id, attr, value)",
	subTitle:"Javascript Command and Utility Functions, User Interface",
	docHTML:"<p>Changes the dynamic attributes of the identified  user interface (UI) objects.\n</p><p>id is the unique name that identifies the object, specified in the index.hsm file with the extension  !id after the object type.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>id: string - object id. You can also target all objects of a type by specifying as id \"(<object's type>)\" (e.g. \"uiSet(\"(user)\", \"fontweight\", \"bold\") will target all user objects)</li>\n<li>attr: string - attribute name</li>\n<li>value: string - attribute value.</li></ul>",
	content:"uiSet(${1:id}, ${2:attr}, ${3:value})"
});
a.push({
	title:"static void uiLink(source, target)",
	subTitle:"Javascript Command and Utility Functions, User Interface",
	docHTML:"<p>Creates a symbolic link under the www directory to another existing directory under the HSYCO home directory.\nAny access to UI files with a path corresponding to \"source\" will be searched in the \"target\" directory instead.\n</p><p><img src=\"/manager/pic/bulb.png\" width=\"18\" height=\"22\"> <b>Note that a symbolic link has lower priority over existing files. If a file exists, a matching symbolic link will be ignored.</b>\n</p><p><b>Parameters:</b>\n</p><ul><li>source: string - the original path under the www directory to be linked to the target path</li>\n<li>target: string - the target path of the symbolic link, can be any existing directory in the HSYCO home directory. Set to null to remove the link.</li></ul><p><br>\nFor example, if \"resources/myimages\" is a valid path under the HSYCO home directory, the following command:\n</p><p><code>uiLink(\"myproject/img\", \"resources/myimages\");</code>\n</p><p>allows to make image files in the resources/myimages directory accessible to image objects defined in the myproject UI project, as if they where saved in a real www/myproject/img directory.\n</p>",
	content:"static void uiLink(${1:source}, ${2:target})"
});
a.push({
	title:"user(name, param)",
	subTitle:"Javascript Command and Utility Functions, User Interface",
	docHTML:"<p>Triggers a USER event, the execution of the userCommand() JavaScript function and of the userCommand() Java method.\n</p><p>It can be used as a calling mechanism between Java, JavaScript and EVENTS.\n</p><p><br>\n<b>Parameters:</b>\n</p><ul><li>name: string - the name parameter, passed to userCommand() and the USER event</li>\n<li>param: string -the param parameter, passed to userCommand() and the USER event.</li></ul>",
	content:"user(${1:name}, ${2:param})"
});



exports.scope = 'events';
});